'PicBasic Pro program to Test Alfat SD board
'Using PIC16F877

'10mhz oscillator
define  OSC 10

'Set ALFAT pins on PIC
  Symbol ALFAT_RESET_PIN = PORTB.5			' Output connected to the ALFAT RESET line (Active Low)
  Symbol ALFAT_RTS_PIN = PORTB.6			' Output connected to ALFAT CTS line
  Symbol ALFAT_CTS_PIN = PORTB.7			' Input from ALFAT RTS line
                                                              
  ALFAT_RX var PORTC.7		                'ALFAT IN pin
  ALFAT_TX VAR PORTC.6		                'ALFAT OUT pin 
  SER_BAUD CON	84                          'Baud Rate = 9600
  TRISC.6 = 0
  TRISC.7 = 1
   
'RX string
ALFAT_STRING var byte(96)

 
' Define LCD registers and bits
Define  LCD_DREG        PORTD
Define  LCD_DBIT        4
Define  LCD_RSREG       PORTE
Define  LCD_RSBIT       0
Define  LCD_EREG        PORTE
Define  LCD_EBIT        1

'startup LCD
  ADCON1 = 7      ' Set PORTA and PORTE to digital
  Low PORTE.2     ' LCD R/W line low (W)
  Pause 100       ' Wait for LCD to start up
  Lcdout $fe, 1   ' Clear screen
  Pause 500       ' Wait .5 second

'Startup & Reset AlfatSD
  Pause 500
  low ALFAT_CTS_PIN
  pauseus 20
  input ALFAT_RTS_PIN
  pauseus 20
  low ALFAT_RESET_PIN
  pause 200
  input ALFAT_RESET_PIN
  pause 500
  
  'Send reset string
  serout2 ALFAT_RX,SER_BAUD,["RS OK",13]                       
  lcdout "RS Sent"
  pause 500


'---------------Main Program------------
Main:
 gosub Read_Alfat
 goSub List_Files
pause 1000  'Wait a second
goto main
'---------------end of Main--------------


Read_Alfat:
serin2 ALFAT_TX,SER_BAUD,3000,ALFAT_ERROR,[ str ALFAT_STRING\96]   'BRING IN UPTO 96 BYTES (MAX NUMBER DEPENDS ON AVAILABLE SPACE)
'Output rcv characters to LCD
gosub Clear_LCD
lcdout "Rcvd"
Lcdout $fe, $c0 ' move to second line
Pause 500
lcdout ALFAT_STRING
pause 1000
gosub Clear_LCD
return

List_Files:
'Try listing the folders
serout2 ALFAT_RX,SER_BAUD,["A",13]
serout2 ALFAT_RX,SER_BAUD,["LF",13]
gosub Read_Alfat
return

Clear_LCD:
Lcdout $fe, 1   ' Clear screen
Pause 500       ' Wait .5 second
return

ALFAT_ERROR:   
  Lcdout $fe, 1   ' Clear screen
  Pause 500       ' Wait .5 second
  lcdout "Error"
  Pause 500       ' Wait .5 second
  Goto ALFAT_ERROR       ' Do it forever
End
