
; PICBASIC PRO(TM) Compiler 3.0.7.4, (c) 1998, 2013 microEngineering Labs, Inc. All Rights Reserved. 
MPASMX_USED			EQU	1

#define	PBP_PATH	C:\PBP3\




        NOLIST
    ifdef PM_USED
        LIST
        "Error: PM does not support this device.  Use MPASM."
        NOLIST
    else
        LIST
        LIST p = 18LF46K80, r = dec, w = -311, f = inhx32
        INCLUDE "P18LF46K80.INC"	; MPASM  Header
        NOLIST
    endif
        LIST
GO_DONE        EQU  H'0001'     ;named GO_NOT_DONE in the MPASM header file
EEPROM_START   EQU	0F00000h
BLOCK_SIZE     EQU	64


    #define HPWM_OVERRIDE 1
PBP_HARDWAREDEF  macro
    #include PBP_PATH\HPWM_K80_1.HWLIB
  endm


    CONFIG  RETEN = ON            ; Ultra low-power regulator is Enabled (Controlled by SRETEN bit)
    CONFIG  INTOSCSEL = HIGH      ; LF-INTOSC in High-power mode during Sleep
    CONFIG  SOSCSEL = HIGH        ; High Power SOSC circuit selected
    CONFIG  XINST = OFF           ; Disabled
    CONFIG  FOSC = HS1            ; HS oscillator (Medium power, 4 MHz - 16 MHz)
    CONFIG  PLLCFG = ON           ; Enabled
    CONFIG  FCMEN = OFF           ; Disabled
    CONFIG  IESO = OFF            ; Disabled
    CONFIG  PWRTEN = OFF          ; Disabled
    CONFIG  BOREN = SBORDIS       ; Enabled in hardware, SBOREN disabled
    CONFIG  BORV = 3              ; 1.8V
    CONFIG  BORPWR = ZPBORMV      ; ZPBORMV instead of BORMV is selected
    CONFIG  WDTEN = SWDTDIS       ; WDT enabled in hardware; SWDTEN bit disabled
    CONFIG  WDTPS = 512           ; 1:512
    CONFIG  CANMX = PORTB         ; ECAN TX and RX pins are located on RB2 and RB3, respectively
    CONFIG  MSSPMSK = MSK7        ; 7 Bit address masking mode
    CONFIG  MCLRE = ON            ; MCLR Enabled, RE3 Disabled
    CONFIG  STVREN = ON           ; Enabled
    CONFIG  BBSIZ = BB2K          ; 2K word Boot Block size
    CONFIG  CP0 = OFF             ; Disabled
    CONFIG  CP1 = OFF             ; Disabled
    CONFIG  CP2 = OFF             ; Disabled
    CONFIG  CP3 = OFF             ; Disabled
    CONFIG  CPB = OFF             ; Disabled
    CONFIG  CPD = OFF             ; Disabled
    CONFIG  WRT0 = OFF            ; Disabled
    CONFIG  WRT1 = OFF            ; Disabled
    CONFIG  WRT2 = OFF            ; Disabled
    CONFIG  WRT3 = OFF            ; Disabled
    CONFIG  WRTC = OFF            ; Disabled
    CONFIG  WRTB = OFF            ; Disabled
    CONFIG  WRTD = OFF            ; Disabled
    CONFIG  EBTR0 = OFF           ; Disabled
    CONFIG  EBTR1 = OFF           ; Disabled
    CONFIG  EBTR2 = OFF           ; Disabled
    CONFIG  EBTR3 = OFF           ; Disabled
    CONFIG  EBTRB = OFF           ; Disabled



; Define statements.
; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00610	DEFINE  ADC_CHANNELS 1
#define		ADC_CHANNELS		 1

RAM_START       		EQU	00000h
RAM_END         		EQU	00E40h
RAM_BANKS       		EQU	0000Fh
BANK0_START     		EQU	00060h
BANK0_END       		EQU	000FFh
BANK1_START     		EQU	00100h
BANK1_END       		EQU	001FFh
BANK2_START     		EQU	00200h
BANK2_END       		EQU	002FFh
BANK3_START     		EQU	00300h
BANK3_END       		EQU	003FFh
BANK4_START     		EQU	00400h
BANK4_END       		EQU	004FFh
BANK5_START     		EQU	00500h
BANK5_END       		EQU	005FFh
BANK6_START     		EQU	00600h
BANK6_END       		EQU	006FFh
BANK7_START     		EQU	00700h
BANK7_END       		EQU	007FFh
BANK8_START     		EQU	00800h
BANK8_END       		EQU	008FFh
BANK9_START     		EQU	00900h
BANK9_END       		EQU	009FFh
BANK10_START    		EQU	00A00h
BANK10_END      		EQU	00AFFh
BANK11_START    		EQU	00B00h
BANK11_END      		EQU	00BFFh
BANK12_START    		EQU	00C00h
BANK12_END      		EQU	00CFFh
BANK13_START    		EQU	00D00h
BANK13_END      		EQU	00DFFh
BANK14_START    		EQU	00E00h
BANK14_END      		EQU	00E40h
BANKA_START     		EQU	00000h
BANKA_END       		EQU	0005Fh

; C:\PBP3\PBPPI18L.RAM     	00028	A00000	FLAGS   VAR     BYTE BANKA SYSTEM       ' Static flags
FLAGS           		EQU	RAM_START + 000h
; C:\PBP3\PBPPI18L.RAM     	00027	A00001	GOP     VAR     BYTE BANKA SYSTEM       ' Gen Op Parameter
GOP             		EQU	RAM_START + 001h
; C:\PBP3\PBPPI18L.RAM     	00016	A00002	R4      VAR     WORD BANKA SYSTEM       ' System Register
R4              		EQU	RAM_START + 002h
; C:\PBP3\PBPPI18L.RAM     	00017	A00004	R5      VAR     WORD BANKA SYSTEM       ' System Register
R5              		EQU	RAM_START + 004h
; C:\PBP3\PBPPI18L.RAM     	00018	A00006	R6      VAR     WORD BANKA SYSTEM       ' System Register
R6              		EQU	RAM_START + 006h
; C:\PBP3\PBPPI18L.RAM     	00019	A00008	R7      VAR     WORD BANKA SYSTEM       ' System Register
R7              		EQU	RAM_START + 008h
; C:\PBP3\PBPPI18L.RAM     	00020	A0000A	R8      VAR     WORD BANKA SYSTEM       ' System Register
R8              		EQU	RAM_START + 00Ah
; C:\PBP3\PBPPI18L.RAM     	00023	A0000C	RM1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Mask
RM1             		EQU	RAM_START + 00Ch
; C:\PBP3\PBPPI18L.RAM     	00026	A0000D	RM2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Mask
RM2             		EQU	RAM_START + 00Dh
; C:\PBP3\PBPPI18L.RAM     	00021	A0000E	RR1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Register
RR1             		EQU	RAM_START + 00Eh
; C:\PBP3\PBPPI18L.RAM     	00024	A0000F	RR2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Register
RR2             		EQU	RAM_START + 00Fh
; C:\PBP3\PBPPI18L.RAM     	00022	A00010	RS1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Bank
RS1             		EQU	RAM_START + 010h
; C:\PBP3\PBPPI18L.RAM     	00025	A00011	RS2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Bank
RS2             		EQU	RAM_START + 011h
; C:\PBP3\PBPPI18L.RAM     	00012	A00012	R0      VAR     LONG BANKA SYSTEM       ' System Register
R0              		EQU	RAM_START + 012h
; C:\PBP3\PBPPI18L.RAM     	00013	A00016	R1      VAR     LONG BANKA SYSTEM       ' System Register
R1              		EQU	RAM_START + 016h
; C:\PBP3\PBPPI18L.RAM     	00014	A0001A	R2      VAR     LONG BANKA SYSTEM       ' System Register
R2              		EQU	RAM_START + 01Ah
; C:\PBP3\PBPPI18L.RAM     	00015	A0001E	R3      VAR     LONG BANKA SYSTEM       ' System Register
R3              		EQU	RAM_START + 01Eh
; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00001	A00022	'http://www.darreltaylor.com/DT_Analog/
T1              		EQU	RAM_START + 022h
; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00016	A00026	ADmax        VAR WORD        ; global - Max A/D value at this resolution
_ADmax           		EQU	RAM_START + 026h
; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00015	A00028	ADvalue      VAR WORD        ; global - the final A/D value
_ADvalue         		EQU	RAM_START + 028h
; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00018	A0002A	DTadCount    VAR WORD        ; local - sample count
_DTadCount       		EQU	RAM_START + 02Ah
; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00019	A0002C	DTadDivisor  VAR WORD        ; local - averaging divisor
_DTadDivisor     		EQU	RAM_START + 02Ch
; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00014	A0002E	ADbits       VAR BYTE        ; global - # of bits in result
_ADbits          		EQU	RAM_START + 02Eh
; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00013	A0002F	ADchan       VAR BYTE        ; global - A/D channel to use
_ADchan          		EQU	RAM_START + 02Fh
; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00020	A00030	DTadShiftR   VAR BYTE        ; local - bits to shift for UnderSampling
_DTadShiftR      		EQU	RAM_START + 030h
; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00022	A00031	    DTadAccum    VAR long     ; local - 32-bit sample accumulator
_DTadAccum       		EQU	RAM_START + 031h
; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00611	PORTL   VAR     PORTB
_PORTL           		EQU	 PORTB
; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00612	PORTH   VAR     PORTC
_PORTH           		EQU	 PORTC
; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00613	TRISL   VAR     TRISB
_TRISL           		EQU	 TRISB
; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00614	TRISH   VAR     TRISC
_TRISH           		EQU	 TRISC

; EEPROM data.


	INCLUDE	"DT_ANALOG.MAC"
	INCLUDE	"C:\PBP3\PBPPI18L.LIB"


; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00036	#HEADER
; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00063	#CONFIG
; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00584	BANKA   $0000, $005F
; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00585	BANK0   $0060, $00FF
; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00586	BANK1   $0100, $01FF
; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00587	BANK2   $0200, $02FF
; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00588	BANK3   $0300, $03FF
; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00589	BANK4   $0400, $04FF
; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00590	BANK5   $0500, $05FF
; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00591	BANK6   $0600, $06FF
; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00592	BANK7   $0700, $07FF
; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00593	BANK8   $0800, $08FF
; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00594	BANK9   $0900, $09FF
; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00595	BANK10  $0A00, $0AFF
; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00596	BANK11  $0B00, $0BFF
; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00597	BANK12  $0C00, $0CFF
; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00598	BANK13  $0D00, $0DFF
; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00599	BANK14  $0E00, $0E40
; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00601	'EEPROM  $F00000, $F003FF
; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00603	    #MSG "LONG Variables enabled (PBPL used)"
; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00604	    LIBRARY  "PBPPI18L"

; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00605	    INCLUDE "PBPPI18L.RAM"
; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00608	    INCLUDE "PBPPIC18.RAM"
; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00609	#ENDIF
; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00610	DEFINE  ADC_CHANNELS 1
; C:\PBP3\DEVICES\PIC18LF46K80.PBPINC	00618	#header

; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00011	GOTO OverDTAnalog
	GOTO?L	_OverDTAnalog
; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00020	DTadShiftR   VAR BYTE        ; local - bits to shift for UnderSampling
; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00024	    DTadAccum    VAR WORD[2]     ; local - 32-bit sample accumulator
; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00025	#ENDIF

; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00027	GetADC:

	LABEL?L	_GetADC	

; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00028	  IF (ADbits >= 10) THEN
	CMPLT?BCL	_ADbits, 00Ah, L00004

; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00029	    DTadShiftR = 0   ; 10 11 12 13  14   15   16
	MOVE?CB	000h, _DTadShiftR

; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00030	    LOOKUP2 ADbits-10,[ 1, 4,16,64,256,1024,4096],DTadCount
	SUB?BCN	_ADbits, 00Ah, T1
	LOOKUP2?NCLW	T1, 007h, L00001, _DTadCount
	LU2RET?C	001h
	LU2RET?C	004h
	LU2RET?C	010h
	LU2RET?C	040h
	LU2RET?C	00100h
	LU2RET?C	00400h
	LU2RET?C	01000h

	LABEL?L	L00001	

; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00031	    LOOKUP  ADbits-10,[ 1, 2, 4, 8, 16,  32,  64],DTadDivisor
	SUB?BCN	_ADbits, 00Ah, T1
	LOOKUP?NCLW	T1, 007h, L00002, _DTadDivisor
	LURET?C	001h
	LURET?C	002h
	LURET?C	004h
	LURET?C	008h
	LURET?C	010h
	LURET?C	020h
	LURET?C	040h

	LABEL?L	L00002	

; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00032	  ELSE
	GOTO?L	L00005
	LABEL?L	L00004	

; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00033	    DTadCount = 1
	MOVE?CW	001h, _DTadCount

; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00034	    DTadDivisor = 1
	MOVE?CW	001h, _DTadDivisor

; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00035	    DTadShiftR = 10 - ADbits
	SUB?CBB	00Ah, _ADbits, _DTadShiftR

; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00036	  ENDIF  
	LABEL?L	L00005	

; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00038	                  2046,4092,8184,16368,32736,65472],ADmax
	LOOKUP2?BCLW	_ADbits, 011h, L00003, _ADmax
	LU2RET?C	000h
	LU2RET?C	001h
	LU2RET?C	003h
	LU2RET?C	007h
	LU2RET?C	00Fh
	LU2RET?C	01Fh
	LU2RET?C	03Fh
	LU2RET?C	07Fh
	LU2RET?C	0FFh
	LU2RET?C	001FFh
	LU2RET?C	003FFh
	LU2RET?C	007FEh
	LU2RET?C	00FFCh
	LU2RET?C	01FF8h
	LU2RET?C	03FF0h
	LU2RET?C	07FE0h
	LU2RET?C	0FFC0h

	LABEL?L	L00003	

; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00040	  DTadAccum = 0 : DTadAccum[1] = 0     ; clear the accumulator
	MOVE?CN	000h, _DTadAccum

; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00040	  DTadAccum = 0 : DTadAccum[1] = 0     ; clear the accumulator
	MOVE?CN	000h, _DTadAccum + 00004h

; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00041	DTadLoop:

	LABEL?L	_DTadLoop	

; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00042	  ADCIN  ADchan, ADvalue               ; get 10-bit sample
	ADCIN?BW	_ADchan, _ADvalue

; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00043	  DTadAccum = DTadAccum + ADvalue      ; add it to the accumulator
	ADD?NWN	_DTadAccum, _ADvalue, _DTadAccum
; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00047	      ENDIF
; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00048	  #ENDIF

; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00049	  DTadCount = DTadCount - 1            ; done with this sample
	SUB?WCW	_DTadCount, 001h, _DTadCount

; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00050	  IF DTadCount > 0 THEN DTadLoop       ; loop if not done with ALL samples
	CMPGT?WCL	_DTadCount, 000h, _DTadLoop
; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00050	  IF DTadCount > 0 THEN DTadLoop       ; loop if not done with ALL samples

; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00052	      ADvalue = DTadAccum / DTadDivisor
	DIV?NWW	_DTadAccum, _DTadDivisor, _ADvalue
; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00056	      ADvalue = DIV32 DTadDivisor          ; get the average value
; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00057	  #ENDIF

; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00058	   ADvalue = ADvalue >> DTadShiftR      ; Shift right if < 10-bit
	SHIFTR?WBW	_ADvalue, _DTadShiftR, _ADvalue

; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00059	RETURN
	RETURN?	

; D:\ELEKTRONIKA\CODE PIC\DT ANALOG OVERSAMPLING\DT_ANALOG.PBP	00060	OverDTAnalog:

	LABEL?L	_OverDTAnalog	

	END
