' Define LCD connections
DEFINE LCD_DREG PORTC   ' Set LCD Data port
DEFINE LCD_DBIT 0       ' Set starting Data bit (0 or 4) if 4-bit bus
DEFINE LCD_RSREG PORTD  ' Set LCD Register Select port
DEFINE LCD_RSBIT 1      ' Set LCD Register Select bit
DEFINE LCD_EREG PORTD   ' Set LCD Enable port
DEFINE LCD_EBIT 0       ' Set LCD Enable bit
DEFINE LCD_BITS 4       ' Set LCD bus size (4 or 8 bits)
DEFINE LCD_LINES 2      ' Set number of lines on LCD
DEFINE LCD_COMMANDUS 2000 'Command delay time in us
DEFINE LCD_DATAUS 50 'Data delay time in us

LCDOUT $FE,1                    ' Initialize LCD
PAUSE  200

DEFINE  OSC 20

INCLUDE "DT_INTS-18.bas"
INCLUDE "ReEnterPBP-18.bas"
INCLUDE "Elapsed_INT-18.bas"  ; Elapsed Timer Routines

ASM
INT_LIST  macro    ; IntSource,        Label,  Type, ResetFlag?
        INT_Handler   TMR1_INT,  _ClockCount,   PBP,  yes
    endm
    INT_CREATE            ; Creates the interrupt processor
ENDASM

@   INT_ENABLE  TMR1_INT  ; Enable Timer 1 Interrupts  

GOSUB ResetTime           ' Reset Time to  0d-00:00:00.00
GOSUB StartTimer          ' Start the Elapsed Timer

Main:
  IF SecondsChanged = 1 THEN  
     SecondsChanged = 0
     LCDOUT $FE,2, DEC Days,"d-",$FE,$C0,DEC2 Hours,":",DEC2 Minutes,":",DEC2 Seconds
  ENDIF
GOTO Main
