;**********************************************************************************************
;
;        		TERMOMETER AND CLOCK WITH NOKIA 3310 DISPLAY
;             			DEVELOPED BY NICULESCU DAN
;                 			SEPTEMBER-2014
;
;
; Note : most parts of code are from PicBasic.Co.Uk/forum 
; please visit : http://www.picbasic.co.uk/forum/showthread.php?t=327
;
;
;**********************************************************************************************
;                                                              
;                        .oooO                                 
;                        (   )   Oooo.                         
;                         \ (    (   )
;                          \_)    ) /
;                                (_/
;

@ DEVICE pic16F648A, INTRC_OSC, WDT_OFF, PWRT_OFF, BOD_OFF, MCLR_ON, LVP_OFF, CPD_OFF, PROTECT_OFF 

Define  NO_CLRWDT 1
DEFINE  OSC 4                            

        TRISB = %00101110        			'portB configuration  0=out 1=in
        TRISA = %01100001        			'portA configuration
        PORTA.0 = 0
        CMCON = 7                		
        VRCON = 0                		
        INTCON = 0              

OPTION_REG=%00000111   					'weak pullups on
                                                
Lcd_DC      	var PortB.0 
Lcd_SDA     	var PortA.3
Lcd_RST     	var PortA.4
Lcd_CLK     	var PortA.2
DQ          	var PortB.5   

DecButton 	var PORTB.1	' Press to Decrement Button
SetButton 	var PORTB.2	' Press to Set/memorise Button
IncButton 	var PORTB.3	' Press to Increment Button

SDApin 	 	var PORTA.6 	' DS1307 SDA pin #5
SCLpin 	 	var PORTA.7 	' DS1307 SCL pin #6

DB       var BYTE[8] 		' Data byte array
RTCSec   var DB[0]   		' alias individual bytes in array
RTCMin   var DB[1]
RTCHour  var DB[2]
RTCDay   var DB[3]
RTCDate  var DB[4]
RTCMonth var DB[5]
RTCYear  var DB[6]
RTCCtrl  var DB[7]

      TimeOut  	var word	' Variable for SetUp Menu Time-Out
      ore      	var word
      minute   	var word
      secunde  	var word
      ziua     	var word
      luna     	var word
      oraa     	var byte
      orab     	var byte
      minutea  	var byte
      minuteb  	var byte
      seca     	var byte
      secb     	var byte
      zza      	var byte
      zzb      	var byte
      lla      	var byte
      llb      	var byte

SetSec     	var byte	' Seconds
SetMin     	var byte	' Minutes
SetDecMin  	Var byte
SetHour    	var byte	' Hours
SetDecHour 	var byte
SetDecMonth 	var byte
SetMonth 	var byte
SetDecDay 	var byte
SetDay 		var byte


Ts          	var bit         ' TYPE Of SPACE, variable / constante
Tc          	var byte        ' TYPE Of Charater, normal / big
Ic          	var bit         ' Inverted Char
i           	var byte
j           	var Word
k           	var byte
Tv          	var byte        
Nc          	var byte       
PosX        	var byte
PosY        	var byte
Letra       	var byte [9]
LetraA      	var byte
LetraB      	var byte 
LcdStr      	var byte [28]
Lcd_Data    	var byte
LcdReg      	var byte        
X           	var byte
y           	var byte        
cursor      	var byte


Temperature     var word 		
TempC           var word 		
Sign            var word 		
Float           var word 			   
Dummy           var byte 		
w1 		var word
w3 		var word

CounterA 	var byte	' General purpose Variable
CounterB 	var byte	' General purpose Variable
CounterC 	var byte	' General purpose Variable
      
ButtonRepeat 	con 200		' Timeperiod in mS for Edit Buttons auto-repeat
Debounce     	con 250     
DS18B20_12bit   con %01111111   ' 750ms,   0.0625C 

data @0,$FF,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,_
$01,$01,$7F,$7F,$7F,$43,$43,$7F,$7F,$3D,$01,$01,$7F,$7F,_
$7F,$01,$01,$3D,$7F,$7F,$43,$53,$77,$77,$35,$01,$01,$7F,_
$7F,$7F,$01,$03,$03,$03,$7F,$7F,$7F,$03,$03,$03,$01,$7D,_
$7F,$7F,$13,$13,$7F,$7F,$7D,$01,$01,$7F,$7F,$7F,$41,$41,_
$41,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$FF

'-----------------------------------------------------------------

'Initialize LCD, run 1st this!                 
    Low Lcd_RST                           ' Reset LCD (HW reset)
    pause 100 
    High Lcd_RST                          ' Release Reset
    Low Lcd_DC                            ' Command/Data
     
  Lcd_Data= $21: GOSUB Lcd_SentByte       ' LCD EXTENDED COMMANDS
  Lcd_Data= $c2: GOSUB Lcd_SentByte       ' SET LCD Vop (CONTRAST) era c8
  Lcd_Data= $06: GOSUB Lcd_SentByte       ' SET TEMP COEFFICENT
  Lcd_Data= $13: GOSUB Lcd_Sentbyte       ' LCD BIAS MODE
  Lcd_Data= $20: GOSUB Lcd_Sentbyte       ' LCD STANDARD COMMANDS
  Lcd_Data= $09: GOSUB Lcd_Sentbyte       ' all on
   pause 1000
  Lcd_data= $08: gosub lcd_sentbyte       ' lcd blank
  Lcd_Data= $0D: GOSUB Lcd_sentbyte       ' LCD IN NORMAL MODE         $0D for INVERSE ; $0C for NORMAL

  Ts = 0                                  ' Space constante
  Ic = 0                                  ' Blinking OFF

gosub Lcd_Clear                     	  ' Clear contents of screen
Low Lcd_DC

Pause 100


'==================================================
' Init Sensor 1
 OWOUT DQ, 1, [$CC, $4E, 0, 0, DS18B20_12bit]
 OWOut DQ, 1, [$CC, $48]       		    
 OWOut DQ, 1, [$CC, $B8] 
 OWOut DQ, 1, [$CC, $BE] 
 Pause 50
 OWIn DQ, 2, [temperature.byte0, temperature.byte1]
 Pause 100

 gosub Read_1307
 gosub Write_1307

'==================================================
main:
Call BorderLine
pause 100
sign = " "
	If SetButton=0 then
	call lcd_clear
		Gosub SetButtonRelease
		Goto Setup
	endif

Gosub read_1307
    oraa 	=  ore DIG 1
    orab 	=  ore DIG 0
    minutea 	=  minute DIG 1
    minuteb 	=  minute DIG 0
    seca 	= secunde DIG 1
    secb 	= secunde DIG 0
    zza 	= ziua DIG 1
    zzb 	= ziua DIG 0
    lla 	= luna DIG 1
    llb 	= luna DIG 0
    

' Start temp.conv.
 OWOut DQ, 1, [$CC, $44] 
 OWOut DQ, 1, [$CC, $BE]
 OWIn DQ, 2, [temperature.byte0, temperature.byte1]  

If Temperature.15 then       
  Temperature= ~Temperature +1
  sign="-"
else
  sign="+"
Endif
 
Dummy = 625 * Temperature
TempC = DIV32 10 
TempC = (Temperature & $7FF) >> 4
Float = ((Temperature.Lowbyte & $0F ) * 25 )>>2
Temperature = TempC*100 + Float

w1=temperature
w3=sign

gosub afisare_TEMP
gosub afisare_CEAS
gosub afisare_SEC
gosub afisare_DATA

goto main

'==================================================
afisare_TEMP:
LcdStr(5) = 59                            ' simbol for degree
LcdStr(4) = 48 + w1 DIG 1
LcdStr(3) = "."
LcdStr(2) = 48 + w1 DIG 2
if w1 DIG 3=0 then
LcdStr(1) = 32
else
LcdStr(1) = 48 + w1 DIG 3
endif
LcdStr(0) = w3 

Tc=0
Nc=6
PosX=3
PosY=1 
Gosub Lcd_GotoXY : Gosub Lcd_SentString
Return

'==================================================
afisare_CEAS:
LcdStr(4) = 48 + minuteb
LcdStr(3) = 48 + minutea
if porta.0 = 0 then
lcdstr(2) = 32
else
LcdStr(2) = 58				' ":"
endif
LcdStr(1) = 48 + orab
if oraa=0 then
LcdStr(0) = 32
else
LcdStr(0) = 48 + oraa
endif

Tc=2
Nc=5
PosX=11
PosY=3 
Gosub Lcd_GotoXY : Gosub Lcd_SentString

Tc=3
Nc=5
PosX=11
PosY=4
Gosub Lcd_GotoXY : Gosub Lcd_SentString
Return


Afisare_SEC:
LcdStr(1) = 48 + secb
LcdStr(0) = 48 + seca
Tc=0
Nc=2
PosX=70
PosY=11 
Gosub Lcd_GotoXY : Gosub Lcd_SentString
Return


Afisare_DATA:
LcdStr(4) = 48 + llb
LcdStr(3) = 48 + lla
LcdStr(2) = 47
LcdStr(1) = 48 + zzb
LcdStr(0) = 48 + zza
Tc=0
Nc=5
PosX=52
PosY=1 
Gosub Lcd_GotoXY : Gosub Lcd_SentString
Return

'==================================================
Lcd_Clear:
For cursor = 0 to 5
	PosX=0:PosY=Cursor:Gosub Lcd_GotoXY
	High Lcd_DC

	For i= 1 to 84
      	Lcd_Data=0:Gosub Lcd_SentByte
      	Lcd_Data=0:Gosub Lcd_SentByte
	Next i
Next cursor
Return

'==================================================
Lcd_GotoXY:
Low Lcd_DC
Lcd_Data=%01000000 | PosY :Gosub Lcd_SentByte	'Y
Lcd_Data=%10000000 | PosX :Gosub Lcd_SentByte	'X
Return
'==================================================
Lcd_SentByte:
SHiftOUT Lcd_SDA , Lcd_CLK , 1, [ Lcd_Data ]
Return
'==================================================
Lcd_SentString:
For k=0 to Nc-1	  
    Lcd_Data=LcdStr(k)
    Gosub Lcd_SentChar
next k
Return
'==================================================
Lcd_SentChar:
Letra(0)=$00:Letra(1)=$00:Letra(2)=$00:Letra(3)=$00:Letra(4)=$00:Letra(5)=$00

SELECT CASE lcd_data				
CASE 32
Tv=1            		                                                    '
CASE 42
Tv=5:Letra(0)=$14: Letra(1)=$08:Letra(2)=$3E:Letra(3)=$08: Letra(4)=$14	    '*
CASE 43
Tv=5:Letra(0)=$08: Letra(1)=$08:Letra(2)=$3E:Letra(3)=$08: Letra(4)=$08	    '+
CASE 45
Tv=5:Letra(0)=$08: Letra(1)=$08:Letra(2)=$08:Letra(3)=$08: Letra(4)=$08	    '-
CASE 46
Tv=1:Letra(1)=$60 : Letra(2)=$60                                      	    '.
case 47
Tv=4:Letra(0)=96 : Letra(1)=48 :Letra(2)=24	:Letra(3)=12 : Letra(4)=06  '/
CASE 48
Tv=5:Letra(0)=$3E: Letra(1)=$51:Letra(2)=$49:Letra(3)=$45: Letra(4)=$3E	    '0
CASE 49                                  
Tv=4:Letra(1)=$42: Letra(2)=$7F:Letra(3)=$40	                            '1
CASE 50
Tv=5:Letra(0)=$42: Letra(1)=$61:Letra(2)=$51:Letra(3)=$49: Letra(4)=$46	    '2
CASE 51
Tv=5:Letra(0)=$21: Letra(1)=$41:Letra(2)=$45:Letra(3)=$4B: Letra(4)=$31	    '3
CASE 52
Tv=5:Letra(0)=$18: Letra(1)=$14:Letra(2)=$12:Letra(3)=$7F: Letra(4)=$10	    '4
CASE 53
Tv=5:Letra(0)=$27: Letra(1)=$45:Letra(2)=$45:Letra(3)=$45: Letra(4)=$39	    '5
CASE 54
Tv=5:Letra(0)=$3C: Letra(1)=$4A:Letra(2)=$49:Letra(3)=$49: Letra(4)=$30     '6
CASE 55                                                                
Tv=5:Letra(0)=$01: Letra(1)=$71:Letra(2)=$09:Letra(3)=$05: Letra(4)=$03	    '7
CASE 56
Tv=5:Letra(0)=$36: Letra(1)=$49:Letra(2)=$49:Letra(3)=$49: Letra(4)=$36	    '8
CASE 57
Tv=5:Letra(0)=$06: Letra(1)=$49:Letra(2)=$49:Letra(3)=$29: Letra(4)=$1E	    '9
CASE 58
Tv=3:Letra(1)=$36: Letra(2)=$36                             	            ':
CASE 59
Tv=5:Letra(0)=$02: Letra(1)=$05: Letra(2)=$32: Letra(3)=$48: Letra(4)=$48   'simbol grade
end select

High Lcd_DC
'==================================================
If Tc = 0 Then              		' Normal Character
    iF Ts = 0 tHEN     
        j = 5               		' CONSTANTE SPACE (6)
       Else
        j = Tv              		' VARIABLE SPACE
    endif
      
        for I=0 to j
            If Ic=0 Then    		' Normal Character            
            	ShiftOUT Lcd_SDA , Lcd_CLK , 1 , [ Letra(I)]                    
            else            		' Inverted Charater
            	ShiftOUT Lcd_SDA , Lcd_CLK , 1 , [ (127-Letra(I))+128 ]           
            endif                 
        next I

     Return    
Endif                   ' Double Charater
'==================================================
' Tc = 1   Nothing to change       2 x 1
If Tc = 2  Then         		' 1 time of 2x2
   for i = 0 to 5
        LetraA = Letra(i)
        LetraB.0 = LetraA.0
        LetraB.1 = LetraA.0
        LetraB.2 = LetraA.1
        LetraB.3 = LetraA.1
        LetraB.4 = LetraA.2
        LetraB.5 = LetraA.2
        LetraB.6 = LetraA.3
        LetraB.7 = LetraA.3
        Letra(i) = LetraB                       
    next i    
ENdif

If TC = 3 then      			' 2 time of 2x2 
    for i = 0 to 5
        LetraA = Letra(i)
        LetraB.0 = LetraA.4
        LetraB.1 = LetraA.4
        LetraB.2 = LetraA.5
        LetraB.3 = LetraA.5
        LetraB.4 = LetraA.6
        LetraB.5 = LetraA.6
        LetraB.6 = LetraA.7
        LetraB.7 = LetraA.7
        Letra(i) = LetraB                        
    next i    
endif    


    iF Ts = 0 tHEN     
        j = 5               
      Else
        j = Tv              
    endif
      
        for I=0 to j
            If Ic=0 Then                
		ShiftOUT Lcd_SDA , Lcd_CLK , 1 , [ Letra(I), Letra(i) ]    
               else            
		ShiftOUT Lcd_SDA , Lcd_CLK , 1 , [ (127-Letra(I))+128, (127-Letra(I))+128 ]       
            endif                 
        next I
Return

 
BorderLine:                         ' 
'=================================== RAND 0
                 for y = 0 to 83 
                 call setcursor
                 read y, LcdReg                      
                 call    PrintDataLcd                
                 next y
'===================================  RAND 1                                
               LcdReg  =  %10000000            		' cursor  X  
               call    PrintCtrlLcd
                LcdReg  =  %01000001            	' cursor  Y
               call    PrintCtrlLcd 
               LOokup 0, [$FF] , LcdReg 
               call    PrintDataLcd     
               
                LcdReg  =  %10000000 + 83            	' cursor  X  
               call    PrintCtrlLcd
                LcdReg  =  %01000001            	' cursor  Y
               call    PrintCtrlLcd 
               LOokup 0, [$FF] , LcdReg 
               call    PrintDataLcd  
'===================================  RAND 2
                LcdReg  =  %10000000            	' cursor  X  
               call    PrintCtrlLcd
                LcdReg  =  %01000010            	' cursor  Y
               call    PrintCtrlLcd    
               LOokup 0, [$FF] , LcdReg 
               call    PrintDataLcd
                               
                LcdReg  =  %10000000 + 83           	' cursor  X  
               call    PrintCtrlLcd
                LcdReg  =  %01000010            	' cursor  Y
               call    PrintCtrlLcd
               LOokup 0, [$FF] , LcdReg 
               call    PrintDataLcd

'===================================  RAND 3
                LcdReg  =  %10000000            	' cursor  X  
               call    PrintCtrlLcd
                LcdReg  =  %01000011            	' cursor  Y
               call    PrintCtrlLcd
               LOokup 0, [$FF] , LcdReg 
               call    PrintDataLcd
               
               LcdReg  =  %10000000 + 83            	' cursor  X  
               call    PrintCtrlLcd
                LcdReg  =  %01000011            	' cursor  Y
               call    PrintCtrlLcd
               LOokup 0, [$FF] , LcdReg 
               call    PrintDataLcd   
'===================================  RAND 4                
               LcdReg  =  %10000000            		' cursor  X  
               call    PrintCtrlLcd
                LcdReg  =  %01000100            	' cursor  Y
               call    PrintCtrlLcd 
               LOokup 0, [$FF] , LcdReg 
               call    PrintDataLcd     
               
                LcdReg  =  %10000000 + 83            	' cursor  X  
               call    PrintCtrlLcd
                LcdReg  =  %01000100            	' cursor  Y
               call    PrintCtrlLcd 
               LOokup 0, [$FF] , LcdReg 
               call    PrintDataLcd    
'===================================  JOS                
		LcdReg  =  %10000000            	' cursor  X  
                call    PrintCtrlLcd
                LcdReg  =  %01000101            	' cursor  Y
                call    PrintCtrlLcd
                for y = 0 to 83  
             
    LOokup y, [$FF,$82,$82,$FE,$FE,$FE,$82,$82,$80,$FE,$FE,$FE,$D2,_
	       $D2,$C2,$80,$FE,$FE,$FE,$92,$B2,$FE,$CC,$80,$FE,$FE,_
               $FE,$84,$88,$84,$FE,$FE,$FE,$80,$BC,$FE,$FE,$C2,$C2,_
               $FE,$BC,$80,$98,$98,$98,$80,$BC,$FE,$FE,$C2,$C2,$C2,_
               $80,$FE,$FE,$FE,$C0,$C0,$C0,$80,$BC,$FE,$FE,$C2,$C2,_
               $FE,$BC,$80,$BC,$FE,$FE,$C2,$C2,$C2,$80,$FE,$FE,$FE,_
               $98,$BC,$E6,$C2,$80,$FF] ,LcdReg
                call    PrintDataLcd
                next y 
return

'==================================================
setcursor:	
                LcdReg  =  %10000000 + y           	' cursor  X  
               call    PrintCtrlLcd
                LcdReg  =  %01000000            	' cursor  Y
               call    PrintCtrlLcd
return

PrintCtrlLcd:   LCD_DC = 0                             

PrintDataLcd:   for x = 1 to 8                
                    LCD_SDA = LcdReg.7              
                    LCD_CLK = 1
                    LcdReg = LcdReg << 1
                    LCD_CLK = 0
                next x               
                LCD_DC = 1
return     

;SetupPreset:
;	RTCSec=		$00	' Seconds preset to 00
;	RTCMin=		$15	' Minutes preset to 15
;	RTCHour=	$13	' Hours preset to 13
;	RTCDay=		$01	' Weekday preset to 01
;	RTCMonth=	$06	' Months preset to June
;	RTCYear=	$02	' Year preset to 2002
;	RTCCtrl=	$90
		'
		'	Convert the Current BCD Data to Something easier to Edit
		'	--------------------------------------------------------
Setup:
I2CREAD SDApin,SCLpin,$D0,$00,[STR DB\8]  				' Read 8 bytes from DS1307
; RTCSec,RTCMin,RTCHour,RTCDay,RTCDate,RTCMonth,RTCYear
ore     = (db[2] & $F )+((db[2]>>4)*10) 				' Hex to Dec hour
minute  = (db[1] & $F )+((db[1]>>4)*10) 				' Hex to Dec minutes
luna    = (db[5] & $F )+((db[5]>>4)*10) 
ziua    = (db[4] & $F )+((db[4]>>4)*10) 

setdechour	= ore DIG 1
sethour		= ore DIG 0
setdecmin 	= minute DIG 1
setmin		= minute DIG 0
setdecmonth 	= luna DIG 1
setmonth	= luna DIG 0
setdecday	= ziua DIG 1
setday 		= ziua DIG 0

	CounterC=0		' Set to Start of Setup (four steps from 0 to 4)
	TimeOut=0		' Zero the Time-Out counter
		'	------------------
SetupEntryLoop:
    	oraa 	= setdechour
    	orab 	= sethour
    	minutea = setdecmin
    	minuteb = setmin
    	lla 	= setdecmonth
    	llb 	= setmonth
    	zza 	= setdecday
    	zzb 	= setday
call afisare_ceas
call afisare_DATA
		'
		'	Decrement Button Pressed
		'	------------------------
	If DecButton=0 then
				'
				'	Decrement Tens Hours
				'	---------------
		If CounterC=0 then
			If setdechour=0 then
				setdechour=2
				else
				setdechour=setdechour-1
			endif
		endif
				'
				'	Decrement Units Hours
				'	---------------
		If CounterC=1 then
              	IF sethour=0 then
                		sethour=9
                		else
                        sethour=sethour-1
		        Endif
       		endif	
                        	'
				'	Decrement Tens Minutes
				'	-----------------
		If CounterC=2 then
			If setdecmin=0 then
				setdecmin=5
				else
				setdecmin=setdecmin-1
			endif
		endif                                  
                        	'
				'	Decrement Units Minutes
				'	-----------------
		If CounterC=3 then
			If setmin=0 then
				setmin=9
				else
				setmin=setmin-1
			endif
		endif
                        	'
				'	Decrement Tens Days
				'	-----------------
		If CounterC=4 then
			If setdecday=0 then
				setdecday=3
				else
				setdecday=setdecday-1
			endif
		endif
				'	
				'	Decrement Units Days
				'	-----------------
		If CounterC=5 then
			If setday=0 then
				setday=9
				else
				setday=setday-1
			endif
		endif	
		
                        	'
				'	Decrement Tens Months
				'	-----------------
		If CounterC=6 then
			If setdecmonth=0 then
				setdecmonth=1
				else
				setdecmonth=setdecmonth-1
			endif
		endif
				'	
				'	Decrement Units Month
				'	-----------------
		If CounterC=7 then
			If setmonth=0 then
				setmonth=2
				else
				setmonth=setmonth-1
			endif
		endif	

		Pause ButtonRepeat
		TimeOut=0
		Goto SetupEntryLoop
		endif
			'
			'	Increment Button Pressed
			'	------------------------
			' 	This is just like Decrement but opposite...
	If IncButton=0 then
				'
				'
				'	Increment Tens Hours
				'	---------------
		If CounterC=0 then
			If setdechour=2 then
				setdechour=0
				else
				setdechour=setdechour+1
                  	Endif
            	Endif
				'
				'	Increment Units Hours
				'	---------------
		If CounterC=1 then
                  	IF sethour=9 then
                        	sethour=0
                        	else
                        	sethour=sethour+1
                  	Endif         
       		Endif   	  			
           		'
				'	Increment Tens Minutes
				'	-----------------
		If CounterC=2 then
			If setdecmin=5 then
				setdecmin=0
				else
				setdecmin=setdecmin+1
			Endif
		Endif
                                   
           			'
				'	Increment Units Minutes
				'	-----------------
		If CounterC=3 then
			If setmin=9 then
				setmin=0
				else
				setmin=setmin+1
			Endif
		Endif
                        	'
				'	Increment Tens Days
				'	-----------------
		If CounterC=4 then
			If setdecday=3 then
				setdecday=0
				else
				setdecday=setdecday+1
			endif
		endif	
				'	Increment Units Days
				'	-----------------
		If CounterC=5 then
			If setday=9 then
				setday=0
				else
				setday=setday+1
			endif
		endif	
		
                        	'
				'	Increment Tens Months
				'	-----------------
		If CounterC=6 then
			If setdecmonth=1 then
				setdecmonth=0
				else
				setdecmonth=setdecmonth+1
			endif
		endif
				'	
				'	Increment Units Month
				'	-----------------
		If CounterC=7 then
			If setmonth=2 then
				setmonth=0
				else
				setmonth=setmonth+1
			endif
		endif	

		Pause ButtonRepeat
		TimeOut=0
		Goto SetupEntryLoop
		endif
			'
			'	Set Button Pressed
			'	------------------
	If SetButton=0 then
		CounterC=CounterC+1	' Increment Menu Item
		TimeOut=0
	   If CounterC>7 then
		call lcd_clear
				'     Save Data if all edit items exhaused
				'
				'	Save Hours to BCD DS1307's Format
				'	---------------------------------------
			CounterA= (setdechour *10)+ sethour  
			Gosub ConvertBCD
			RTCHour=CounterB			
         			'
				'	Save Minutes to BCD DS1307's Format
				'	---------------------------------------
			CounterA= (setdecmin *10) + setmin           ; Yupppy ! I found it !
			Gosub ConvertBCD
			RTCMin=CounterB
         			'
				'	Save Days to BCD DS1307's Format
				'	---------------------------------------
			CounterA= (setdecday *10) + setday           
			Gosub ConvertBCD
			RTCDate=CounterB
         			'
				'	Save Month to BCD DS1307's Format
				'	---------------------------------------
			CounterA= (setdecmonth *10) + setmonth           ; Yupppy ! I found it !
			Gosub ConvertBCD
			RTCMonth=CounterB
				'
				'	Do the Business
				'	---------------
			   RTCSec = $00
               I2CWrite SDApin,SCLpin,$D0,$00,[RTCSec,RTCMin,RTCHour,RTCDay,RTCDate,RTCMonth,RTCYear,$90]   
gosub afisare_ceas
gosub afisare_DATA          
			Pause 100
			Gosub SetButtonRelease
			Goto Main
	   endif
		Gosub SetButtonRelease
		Goto SetupEntryLoop	' Loop for Next Menu Item
	endif
		'
		'	Menu TimeOut Counter
		'	--------------------
	Pause 1			' Kill 1mS 
	TimeOut=TimeOut+1
	If TimeOut>2000 then goto Main
				' User paused too long
				' Return User to Time & Date Display
				' This will however bounce the User to the original
				' Setup Menu start point if the DS1307 has not 
				' been initialised
	Goto SetupEntryLoop	' Loop for Button Press

				
'============================================
read_1307:                              		' Read time Secs,Mins,Hours,Day,Date,Month,Year,Control
    I2CREAD SDApin,SCLpin,$D0,$00,[STR DB\8]  		' Read 8 bytes from DS1307
ore     = (db[2] & $F )+((db[2]>>4)*10) 		' Hex to Dec hour
minute  = (db[1] & $F )+((db[1]>>4)*10) 		' Hex to Dec minutes
secunde = (DB[0] & $F )+((db[0]>>4)*10)
luna    = (db[5] & $F )+((db[5]>>4)*10) 
ziua    = (db[4] & $F )+((db[4]>>4)*10) 
RETURN

write_1307:
I2CWrite SDApin,SCLpin,$D0,$00,[RTCSec,RTCMin,RTCHour,RTCDay,RTCDate,RTCMonth,RTCYear,$90]
pause 10
return
	'
	'	Subroutine Converts back to BCD
	'	-------------------------------
		' CounterA is the entry variable
		' CounterB holds the converted BCD result on exit
ConvertBCD:
	CounterB=CounterA DIG 1
	CounterB=CounterB<<4
	CounterB=CounterB+CounterA DIG 0
	Return

SetButtonRelease:
	While SetButton=0:Wend
	Pause 250	' Small pause to kill any Key-Bounce
	Return

