'***************************************************************************
'*  Name    : One_Wire_74HC595.bas                                         *
'*  Notes   : PicBasic Pro interface to a HD44780 with only 1Wire          *
'*          : uses LCDOUT, the interface is transparent to the user        *
'*          : For more info, see this webpage                              *
'*          : http://www.picbasic.co.uk/forum/showthread.php?t=18972       *
'*          : A big thanks to Darrel Taylor                                *
'**************************************************************************
'* HighJack routines must be installed in PBPPIC??.LIB first               *
'*    See this webpage for more information on HighJack ...                *
'*    http://www.picbasic.co.uk/forum/showthread.php?t=7038                *
'**************************************************************************

Char_Temp             var byte
ShiftOut_Steps        var Byte
Count_ShiftOut_Steps  var byte
ShiftLoop_Steps       Var byte
Bit_Shift             Var byte


INCLUDE "VirtualPort.bas"

Goto Over_One_Wire_74HC595

;===============( DO NOT Change anything below this line )====================

ASM ; Make sure HighJack has been installed in PBP's .LIB file
    ifndef LCDOUT_HIGHJACKED 
        error "HighJacked-LCDOUT Not found in PBPPIC??.LIB"
    endif
ENDASM
DEFINE  HJ_LCDOUT  _LCDsend    ; Redirect PBP's LCDOUT to LCDsend: Subroutine

;----[Send a byte to the Virtual LCD PORT]------------(DO NOT Change)---------
TempChar        var  byte
Char            VAR  Byte
LCD_Initialized VAR  FLAGS.1
RSS             VAR  FLAGS.0                ; LCD RS State

;----[ This routine is called once for every character sent by LCDOUT ]-------
LCDsend:
      @  MOVE?AB  _TempChar                 ; Get char sent by LCDOUT, in WREG
      if !LCD_Initialized then LCD_Init     ; Make sure LCD was Initialized 
  LCDAfterInit:
      if TempChar = $FE then RSS=0 : goto LCDsendDone ; next char is Command 
      Char = TempChar
  LCDsendCOM:  
      Goto ShiftLoop_Char
  After_ShiftLoop_Char:      
      IF RSS = 0 then                       ; Is a Command
          IF Char = 1 then CommandDelay     ; Long delay for Clear Screen
          IF Char = 2 then CommandDelay     ; Long delay for Home
          goto DelayDone
     CommandDelay:
       @  DelayUS   _LCD_COMMANDUS      
      endif  
  DelayDone:
     if LCD_Initialized then RSS = 1      ; Set RS to Data next time 
     STATUS.0 = 1                         ; for using SEROUT2 Flow Control Pin  
  LCDsendDone:                            ; C_Flag is Set
return

;----[Initialize the LCD]-------------------(DO NOT Change)-------------------
LCD_Init:    
    ShiftOut_Steps = 1
    Char = $33 : gosub  LCDsendCOM  : @  DelayUS 5000
                 gosub  LCDsendCOM  : @  DelayUS 100
                 gosub  LCDsendCOM  : @  DelayUS 100                
    Char = $22 : gosub  LCDsendCOM  : @  DelayUS 100  ; Start 4-bit mode

    ShiftOut_Steps = 3
    Char = $28 : gosub  LCDsendCOM   ; Function Set, 4-bit, 2-line, 5x7
    Char = $0C : gosub  LCDsendCOM   ; Display ON    
    Char = $06 : gosub  LCDsendCOM   ; Entry Mode
    LCD_Initialized = 1              ; LCD has been Initialized        
goto LCDAfterInit

;----[Send it to 74HC595]-------------------(DO NOT Change)-------------------

ShiftLoop_Char:
For Count_ShiftOut_Steps = 0 to ShiftOut_Steps           
SELECT CASE Count_ShiftOut_Steps
 CASE 0
    Char_Temp = Char & %11110000                         ; Isolate Upper 4 Bits 
    If RSS = 1 Then : Char_Temp = Char_Temp | %00000100  ; Set RS Bit
    Char_Temp = Char_Temp | %00001000                    ; Set Enable Bit          
 CASE 1, 3
    Char_Temp = Char_Temp ^ %00001000                    ; Clear Enable Bit 
 Case 2
    Char_Temp = Char & %00001111                         ; Isolate Lower4 Bits
    @ swapf _Char_Temp ,F                                ; Swap Nibbles
    If RSS = 1 Then : Char_Temp = Char_Temp | %00000100  ; Set RS Bit
    Char_Temp = Char_Temp | %00001000                    ; Set Enable Bit            
END SELECT
Bit_Shift = Char_Temp

;----[Shift_Routine_74HC595 ]---------------(DO NOT Change)-------------------

For ShiftLoop_Steps = 0 to 6
 @ rlf _Bit_Shift, F                    ; Shift 1.Pos left
If STATUS.0 = 1 Then                    ; Carry Flag
  Serial_Pin = 0 : @  DelayUS 1         ; min 1 s for 1
  Serial_Pin = 1 : @  DelayUS 15        ; min 15 s
else
  Serial_Pin = 0 : @  DelayUS 15        ; min 15 s for 0
  Serial_Pin = 1 : @  DelayUS 30        ; min 30 s 
endif
next
 ;Latch
  Serial_Pin = 0 : @  DelayUS 200       ; min 200 s for Latch 
  Serial_Pin = 1 : @  DelayUS 300       ; min 300 s
Next                   
Goto After_ShiftLoop_Char
Over_One_Wire_74HC595:
