'****************************************************************  *
'*  Name    : Servo Controller/Tester                              *
'*  Author  : Charles Linquist  
'*          ; Written in PicBasic Pro V3.0.1.4                     *
'*  Notice  : No Copyright - Charles Linquist, Campbell,CA         *
'*          : All Rights Reserved                                  *
'*  Date    : 9/4/2013                                             *
'*  Version : 1.0                                                  *
'*  Notes   : I grant permission to use for any purposes           *
'*          : whatsoever.  Just give me the credit, please         *
;           ; Written for PIC 18F2321 but should work on Most      *
;           ; PIC18F series parts with no                          *
;           ; or minor changes                                     *
'****************************************************************  *

       DATA @90,0   
ASM
       movlw 0x62                   ; %0110 0010  = 4 Mhz, internal osc block
       movwf OSCCON
       movlw 0x80                ;   %1000 0000  = PLL disabled
       movwf OSCTUNE
ENDASM       
        
        DEFINE OSC 4                                                          
        DEFINE NO_CLRWDT 1         ' Don't waste cycles clearing WDT  
        Define USE_LFSR 1
        define LOADER_USED 1        ; in case someone wants to use MCLOADER

        RCSTA1 = $90   ' Enable serial port & continuous receive ; use RCSTA1 = $90 if device has two uarts
        TXSTA1 = $20   ' Enable transmit, BRGH = 0 ; Use TXSTA1 if device has two uarts
        SPBRG1 = 25    ' 9600 Baud @ 4MHz, 0.16%  ; same as above
        SPBRGH1 = 0       ; same as above
        BAUDCON1.3 = 1 ' Enable 16 bit baudrate generator  ; same as above


        CMCON  = %00000111                     ' No Comparator used, turn it off
        ADCON0 = 0                             ; No A/D
      
        T0CON = %10001000         ; Timer ON, No prescaler, 
'------------------------  Port Initialization -------------------------------

    CCP1CON = %00000000         ' Disable CCP Module
   

' ----------------------------- Port Aliases ---------------------------------
     PWM1 Var LATB.0
     PWM2 var LATB.1
     PWM3 var LATB.2
     PWM4 var LATB.3
     PWM5 var LATB.4
     PWM6 var LATB.5
     PWM7 var LATB.6
     PWM8 var LATB.7
     
';---- TRISTATE register aliases
     
     iPWM1 Var TRISB.0
     iPWM2 var TRISB.1
     iPWM3 var TRISB.2
     iPWM4 var TRISB.3
     iPWM5 var TRISB.4
     Ipwm6 VAR TRISB.5
     iPWM7 var TRISB.6
     iPWM8 var TRISB.7
     
 ; below was for testing on a different board only    
    ' PWM1 Var LATC.0
'     PWM1 var Byte
'     PWM2 var LATC.1
'     PWM3 var LATC.2
'     PWM4 var LATC.3
'     PWM5 var LATC.4
'     PWM6 var LATC.5
   
'     PWM7 var BYTE
'     PWM8 var byte
'     PWM7 var LATB.6
'     PWM8 var LATB.7
     
';---- TRISTATE register aliases
     
   ;  iPWM1 Var TRISC.0
'     ipWM1 var byte
     
'     iPWM2 var TRISC.1
'     iPWM3 var TRISC.2
'     iPWM4 var TRISC.3
'     iPWM5 var TRISC.4
'     Ipwm6 VAR TRISC.5
'     iPWM7 var byte
'     iPWM8 var byte
     
     
'     iPWM7 var TRISB.6
'     iPWM8 var TRISB.7
          
     
     
     
     
     
'---------------------- Miscellaneous Variables ------------------------------

    TRISA = %11111111   ; Startup with all inputs
    TRISB = %11111111   
    TRISC = %10111111   ; Need B.6 = 0 for UART
    
;-------------     Variables ---------------------------------------

   OpenDrain var byte
   X var byte
   xx var word
   Type var byte
   PWMValArray var word[9]
  
   PWMIncrement var word
   
   Timer0PreloadH var byte
   Timer0PreloadL var byte
  
   UserInput var byte
   Channel   var byte
  
   
   CR CON 13
   LF CON 10
   FF con 12
  
   Channel = 0
   
   Timer0PreloadH = $B1   ; 20 Msec at 4Mhz
   Timer0PreloadL = $E7
 
   PWMIncrement = 20  ; 20 uSec
   
    LATB = 0  ;  May need to change to PORTB for some chips
    TRISB = 0  ; all outputs low
    
     
   gosub zeroValues  
   
;---------------------  Interrupts. See   http://darreltaylor.com/DT_INTS-18/ --  
   
     
        INCLUDE "DT_INTS-18.bas"         ; Base Interrupt System
        INCLUDE "ReEnterPBP-18.bas"     ; Include if using PBP interrupts
  
ASM
INT_LIST  macro    ; IntSource,        Label,  Type, ResetFlag?
              INT_Handler    TMR0_INT,   _MAINTIMER,   PBP,  yes 
          endm
    INT_CREATE               ; Creates the interrupt processor
ENDASM
;----------------------------------------------------------------------------                         
Goto OverInt

'---[INT - interrupt handler]---------------------------------------------------

MAINTIMER:

    TMR0H = Timer0PreloadH
    TMR0L = Timer0PreloadL
    
    if !OpenDrain then
      PWM1 = 1
        pauseus PWMValArray[0]
      PWM1 = 0 
        
      PWM2 = 1
        pauseus PWMValArray[1]
      PWM2 = 0 
           
      PWM3 = 1
        pauseus PWMValArray[2]
      PWM3 = 0 
        
      PWM4 = 1
        pauseus PWMValArray[3]
      PWM4 = 0   
     
      PWM5 = 1
        pauseus PWMValArray[4]
      PWM5 = 0
      
      PWM6 = 1
        pauseus PWMValArray[5]
      PWM6 = 0 
        
      PWM7 = 1
        pauseus PWMValArray[6]
      PWM7 = 0 
     
      PWM8 = 1
        pauseus PWMValArray[7]
      PWM8 = 0      
  
   else

      iPWM1 = 1
        pauseus PWMValArray[0]
      iPWM1 = 0 
        
      iPWM2 = 1
        pauseus PWMValArray[1]
      iPWM2 = 0 
           
      iPWM3 = 1
        pauseus PWMValArray[2]
      iPWM3 = 0 
        
      iPWM4 = 1
        pauseus PWMValArray[3]
      iPWM4 = 0   
     
      iPWM5 = 1
        pauseus PWMValArray[4]
      iPWM5 = 0
      
      iPWM6 = 1
        pauseus PWMValArray[5]
      iPWM6 = 0 
        
      iPWM7 = 1
        pauseus PWMValArray[6]
      iPWM7 = 0 
           
      iPWM8 = 1
        pauseus PWMValArray[7]
      iPWM8 = 0 
    endif
      
@ INT_RETURN        
    
;-----------------------------------------------------------------------------------      
      
 

OverInt:



  
  read 90,x
   if X <> $AA then 
        gosub SetDefaults
        Write 90,$AA
   endif
        
   gosub ReadEE
    
   hserout [cr,lf,cr,lf,"SERVO TEST/MANIPULATION PROGRAM, written by Charles Linquist",CR,LF]
     
InputTimeout1:

             hserout [cr,lf,cr,lf,"Use the number 1-8 to select the channel you wish to change"]
             hserout [cr,lf,"Then use the 'U' key on the keyboard to Increase, the 'D' key to Decrease the Pulse Width of that channel"]
             hserout [cr,lf,"Use the 'T' key, to toggle a channel between bi-direcional and unidirectional operation.  This setting is 'remembered' through power cycles."]
             hserout [cr,lf,"Use the 'Q' key to see the current settings of all channels"]
             hserout [cr,lf,"Use the <ESC> key to Reset all channels to defaults (Unidirectional, 0.6 mSec, Driven)",cr,lf]
             hserout [cr,lf,"Use the 'H' key to send a servo to its HOME position"]
             hserout [cr,lf,"All channels have a minimum pulse width of 0.6 mSec, and have a maximum of 2.60 mSec."] 
             hserout [cr,lf,"The U/D increment is 20uSec (2%), the refresh rate is 25Hz (40 mSec)"]
             hserout [cr,lf,cr,lf,"All outputs are on PORTB, with B.0 = channel 1, and are DRIVEN by default. Change with the '*' key",cr,lf,cr,lf]
             hserout [cr,lf,"The default starting channel is '1'",cr,lf,cr,lf]
             hserout [cr,lf,"Press any key to continue",cr,lf,cr,lf]
             hserin 4000,InputTimeout1,[x]
                gosub ShowChannels

@ INT_ENABLE TMR0_INT    ; Start the 20 mSec interrupt         
                      
        
Main:

            if pir1.5 then       ; useful way to detect if any key was hit
               hserin [UserInput]   ; no timeout necessary, we know that someone pressed a key.
               
                if UserInput = 27 then goto OverInt
                if UserInput = "*" then gosub OutputType
                if UserInput = "Z" or UserInput = "z" then gosub ZeroValues
                if UserInput > "0" and UserInput < "9" then
                   Channel = UserInput - $31 ; Change "1" ASCII to zero, etc.
                   hserout [cr,lf,cr,lf,"Channel set to ",#(Channel + 1),cr,lf]
                endif
                if UserInput = "Q" or UserInput = "q" then
                   gosub Showchannels
                endif
                
                if UserInput = "T" or UserInput = "t" then
                  If Type.0[Channel] = 0 then 
                   Hserout [cr,lf,"Channel ",#(Channel + 1)," set to Bidirectional state. The default pulse width will now be 1.500 mSec",cr,lf]
                    xx = 1500
                    Type.0[Channel] = 1
                   INTCON.7 = 0
                        PWMValArray [Channel] = xx
                   INTCON.7 = 1
                else  
                  Hserout [cr,lf,"Channel ",#(Channel + 1)," set to Unidirectional state. The default pulse width will now be 1.000 mSec",cr,lf]
                    xx = 1000
                    Type.0[Channel] = 0
                    INTCON.7 = 0
                         PWMValArray [Channel] = xx
                    INTCON.7 = 1
                endif 
                     Write 100,Type
                endif 
                if UserInput = "H" or UserInput = "h" then
                      if Type.0[Channel] = 1 then
                         INTCON.7 = 0
                           PWMValArray[Channel] = 1500
                         INTCON.7 = 1
                       else
                         INTCON.7 = 0
                           PWMValArray[Channel] = 600
                         INTCON.7 = 1
                      endif 
                endif                  
                    
                if UserInput = "U" or UserInput = "u" then
                          INTCON.7 = 0
                          IF PWMValArray[Channel] < 2600 then PWMValArray[Channel] = PWmValArray[Channel] + PWMIncrement
                          INTCON.7 = 1
                          hserout ["Channel ",#(Channel + 1)," Pulsewidth is ",#(PwmValArray[Channel]/1000),".",dec3 (PWMValArray[Channel]//1000)," mSec",cr,lf]
                 endif
                 if UserInput = "D" or UserInput = "d" then
                          INTCON.7 = 0
                          if PWMValArray[Channel] > 600 then PWMValArray[Channel] = PWmValArray[Channel] - PWMIncrement
                          INTCON.7 = 1   
                          hserout ["Channel ",#(Channel + 1)," Pulsewidth is ",#(PwmValArray[Channel]/1000),".",dec3 (PWMValArray[Channel]//1000)," mSec",cr,lf]
                 endif
              endif
              
InputTimeout3:              
              goto Main 
                      
                              
SetDefaults:   
    
    For X = 0 to 7
      PWMValArray [x] = 600  
    next x
    
    iPWM1 = 0
    ipWM2 = 0
    iPWM3 = 0
    iPWM4 = 0
    iPWM5 = 0
    iPWM6 = 0
    iPWM7 = 0
    iPWM8 = 0
    
    Channel = 0
    OpenDrain = 0
    Write 99,OpenDrain
    Type = 0
    write 100,Type 
   
  return  

ZeroValues:
      for X = 0 to 7
        if Type.0[x] = 0 then
          pwmValArray[x] = 1500
        else
          pwmValArray[x] = 600
        endif  
      next x 
   

ReadEE:
      Read 100,Type
      Read 99,OpenDrain
      gosub ZeroValues
  return 
  
OutputType:  
           read 99,OpenDrain
           hserout [cr,lf,"All outputs Driven (0) or Open-Drain (1)? - they are currently "]
            if OpenDrain = 1 then 
               hserout ["Open Drain   "]
            else
               hserout ["Driven       "]
            endif 
             
           hserin 5000,Main,[UserInput]
           hserout [cr,lf]
           select case UserInput
             case "0"
               TRISB = 0
               OpenDrain = 0
               Hserout ["Driven"]
               Write 99,OpenDrain
             case "1"
               TRISB = $FF
               OpenDrain = 1
               hserout ["Open Drain"]
               Write 99,OpenDrain
             case else
               hserout ["No Change"]
            end select
                
         return
         
ShowChannels:         
              read 100,Type
                   for X = 1 to 8
                    hserout [cr,lf,"Channel ",#X,"  pulse width ",#(PwmValArray[X-1])/1000,".",dec3 (PWMValArray[X-1]//1000)," mSec   "] 
                     if Type.0[X-1] = 1 then
                       hserout ["Bidirectional"]
                     else
                       hserout ["Unidirectional"]
                     endif    
                   next x 
                   hserout[cr,lf,cr,lf]          
                  return
