
; PICBASIC PRO(TM) Compiler 3.0.6.1, (c) 1998, 2012 microEngineering Labs, Inc. All Rights Reserved. 
MPASMWIN_USED			EQU	1

#define	PBP_PATH	C:\PBP3\




        NOLIST
    ifdef PM_USED
        LIST
        "Error: PM does not support this device.  Use MPASM."
        NOLIST
    else
        LIST
        LIST p = 18F4550, r = dec, w = -311, w = -230, f = inhx32
        INCLUDE "P18F4550.INC"	; MPASM  Header
        NOLIST
    endif
        LIST
EEPROM_START	EQU	0F00000h
BLOCK_SIZE	EQU	32


PBP_HARDWAREDEF  macro
  endm


        __CONFIG    _CONFIG1L, _PLLDIV_5_1L & _CPUDIV_OSC1_PLL2_1L & _USBDIV_2_1L
        __CONFIG    _CONFIG1H, _FOSC_HSPLL_HS_1H & _FCMEN_OFF_1H & _IESO_OFF_1H
        __CONFIG    _CONFIG2L, _PWRT_OFF_2L & _BOR_ON_2L & _BORV_3_2L & _VREGEN_ON_2L
        __CONFIG    _CONFIG2H, _WDT_ON_2H & _WDTPS_512_2H
        __CONFIG    _CONFIG3H, _CCP2MX_ON_3H & _PBADEN_OFF_3H & _LPT1OSC_OFF_3H & _MCLRE_ON_3H
        __CONFIG    _CONFIG4L, _STVREN_ON_4L & _LVP_OFF_4L & _ICPRT_OFF_4L & _XINST_OFF_4L



; Define statements.
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00018	DEFINE OSC 48
#define		OSC		 48
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00022	DEFINE  INTHAND       INT_ENTRY_H  ' Context saving for High Priority Ints
#define		INTHAND		       INT_ENTRY_H  
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00023	DEFINE  INTLHAND      INT_ENTRY_L  ' Context saving for Low Priority Ints
#define		INTLHAND		      INT_ENTRY_L  
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00020	DEFINE DT_HID_USED  1
#define		DT_HID_USED		  1
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00079	DEFINE   USB_Handler    USB_INT, _DoUSBService,  ASM,  yes
#define		USB_Handler		    USB_INT, _DoUSBService,  ASM,  yes
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00030	DEFINE USB_VENDORID    6017
#define		USB_VENDORID		    6017
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00031	DEFINE USB_PRODUCTID   2000
#define		USB_PRODUCTID		   2000
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00032	DEFINE USB_VERSION     1
#define		USB_VERSION		     1
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00033	DEFINE USB_VENDORNAME  "Hugo Oliveira"
#define		USB_VENDORNAME		  "Hugo Oliveira"
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00034	DEFINE USB_PRODUCTNAME "Demo USB"
#define		USB_PRODUCTNAME		 "Demo USB"
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00035	DEFINE USB_SERIAL      "001Hugo"
#define		USB_SERIAL		      "001Hugo"
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00036	DEFINE USB_INSIZE      8    ;  IN report is PIC to PC (8,16,32,64)
#define		USB_INSIZE		      8    ;  IN report is PIC to PC (8,16,32,64)
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00037	DEFINE USB_OUTSIZE     8    ; OUT report is PC to PIC
#define		USB_OUTSIZE		     8    ; OUT report is PC to PIC
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00038	DEFINE USB_POLLIN      10   ; Polling times in mS, MIN=1 MAX=10
#define		USB_POLLIN		      10   ; Polling times in mS, MIN=1 MAX=10
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00039	DEFINE USB_POLLOUT     10
#define		USB_POLLOUT		     10
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00042	DEFINE USB_LEDPOLARITY 1       ; LED ON State [0 or 1]  (default = 1)
#define		USB_LEDPOLARITY		 1       ; LED ON State [0 or 1]  (default = 1)
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00056	DEFINE ADC_BITS 8  ; Number of bits in ADCIN result
#define		ADC_BITS		 8  ; Number of bits in ADCIN result

RAM_START       		EQU	00000h
RAM_END         		EQU	007FFh
RAM_BANKS       		EQU	00008h
BANK0_START     		EQU	00060h
BANK0_END       		EQU	000FFh
BANK1_START     		EQU	00100h
BANK1_END       		EQU	001FFh
BANK2_START     		EQU	00200h
BANK2_END       		EQU	002FFh
BANK3_START     		EQU	00300h
BANK3_END       		EQU	003FFh
BANK4_START     		EQU	00400h
BANK4_END       		EQU	004FFh
BANK5_START     		EQU	00500h
BANK5_END       		EQU	005FFh
BANK6_START     		EQU	00600h
BANK6_END       		EQU	006FFh
BANK7_START     		EQU	00700h
BANK7_END       		EQU	007FFh
BANKA_START     		EQU	00000h
BANKA_END       		EQU	0005Fh

; C:\PBP3\PBPPIC18.RAM     	00028	A00000	FLAGS   VAR     BYTE BANKA SYSTEM       ' Static flags
FLAGS           		EQU	RAM_START + 000h
; C:\PBP3\PBPPIC18.RAM     	00027	A00001	GOP     VAR     BYTE BANKA SYSTEM       ' Gen Op Parameter
GOP             		EQU	RAM_START + 001h
; C:\PBP3\PBPPIC18.RAM     	00012	A00002	R0      VAR     WORD BANKA SYSTEM       ' System Register
R0              		EQU	RAM_START + 002h
; C:\PBP3\PBPPIC18.RAM     	00013	A00004	R1      VAR     WORD BANKA SYSTEM       ' System Register
R1              		EQU	RAM_START + 004h
; C:\PBP3\PBPPIC18.RAM     	00014	A00006	R2      VAR     WORD BANKA SYSTEM       ' System Register
R2              		EQU	RAM_START + 006h
; C:\PBP3\PBPPIC18.RAM     	00015	A00008	R3      VAR     WORD BANKA SYSTEM       ' System Register
R3              		EQU	RAM_START + 008h
; C:\PBP3\PBPPIC18.RAM     	00016	A0000A	R4      VAR     WORD BANKA SYSTEM       ' System Register
R4              		EQU	RAM_START + 00Ah
; C:\PBP3\PBPPIC18.RAM     	00017	A0000C	R5      VAR     WORD BANKA SYSTEM       ' System Register
R5              		EQU	RAM_START + 00Ch
; C:\PBP3\PBPPIC18.RAM     	00018	A0000E	R6      VAR     WORD BANKA SYSTEM       ' System Register
R6              		EQU	RAM_START + 00Eh
; C:\PBP3\PBPPIC18.RAM     	00019	A00010	R7      VAR     WORD BANKA SYSTEM       ' System Register
R7              		EQU	RAM_START + 010h
; C:\PBP3\PBPPIC18.RAM     	00020	A00012	R8      VAR     WORD BANKA SYSTEM       ' System Register
R8              		EQU	RAM_START + 012h
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00001	A00014	'***************************************************************************
T1              		EQU	RAM_START + 014h
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00040	A00016	INT_Flags   VAR BYTE  BANKA  SYSTEM
INT_Flags       		EQU	RAM_START + 016h
; C:\PBP3\PBPPIC18.RAM     	00023	A00017	RM1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Mask
RM1             		EQU	RAM_START + 017h
; C:\PBP3\PBPPIC18.RAM     	00026	A00018	RM2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Mask
RM2             		EQU	RAM_START + 018h
; C:\PBP3\PBPPIC18.RAM     	00021	A00019	RR1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Register
RR1             		EQU	RAM_START + 019h
; C:\PBP3\PBPPIC18.RAM     	00024	A0001A	RR2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Register
RR2             		EQU	RAM_START + 01Ah
; C:\PBP3\PBPPIC18.RAM     	00022	A0001B	RS1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Bank
RS1             		EQU	RAM_START + 01Bh
; C:\PBP3\PBPPIC18.RAM     	00025	A0001C	RS2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Bank
RS2             		EQU	RAM_START + 01Ch
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00025	A0001D	wsave       var byte  BANKA  SYSTEM   ' location for WREG
wsave           		EQU	RAM_START + 01Dh
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00038	A0001E	RetAddrH    VAR BYTE[3]  BANKA  SYSTEM  ' 21-bit return address Hi Pri.
RetAddrH        		EQU	RAM_START + 01Eh
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00039	A00021	RetAddrL    VAR BYTE[3]  BANKA  SYSTEM  '                       Lo Pri.
RetAddrL        		EQU	RAM_START + 021h
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00001	A00024	'***************************************************************************
PB01            		EQU	RAM_START + 024h
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00051	A00025	DUTY1       VAR  WORD
_DUTY1           		EQU	RAM_START + 025h
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00052	A00027	DUTY2       VAR  WORD
_DUTY2           		EQU	RAM_START + 027h
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00460	A00029	FlashAdd            VAR WORD
_FlashAdd        		EQU	RAM_START + 029h
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00461	A0002B	ReadAdd             VAR WORD
_ReadAdd         		EQU	RAM_START + 02Bh
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00455	A0002D	Str_TempWord        VAR WORD
_Str_TempWord    		EQU	RAM_START + 02Dh
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00048	A0002F	Value0      VAR  WORD
_Value0          		EQU	RAM_START + 02Fh
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00049	A00031	Value1      VAR  WORD
_Value1          		EQU	RAM_START + 031h
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00050	A00033	X           VAR  WORD
_X               		EQU	RAM_START + 033h
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00054	A00035	New_PORTA   VAR  BYTE
_New_PORTA       		EQU	RAM_START + 035h
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00053	A00036	Old_PORTA   VAR  BYTE
_Old_PORTA       		EQU	RAM_START + 036h
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00459	A00037	Str_Length          VAR BYTE
_Str_Length      		EQU	RAM_START + 037h
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00456	A00038	Str_Loop            VAR BYTE
_Str_Loop        		EQU	RAM_START + 038h
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00039	A00039	USBRXBufferCount   Var Byte     : USBRXBufferCount = USBBufferSizeRX
_USBRXBufferCount		EQU	RAM_START + 039h
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00040	A0003A	USBTXBufferCount   Var Byte     : USBTXBufferCount = USBBufferSizeTX
_USBTXBufferCount		EQU	RAM_START + 03Ah
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00032	A00060	fsave0H     var WORD  BANK0  SYSTEM   ' locations for FSR registers
fsave0H         		EQU	RAM_START + 060h
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00035	A00062	fsave0L     var WORD  BANK0  SYSTEM   ' low priority FSR locations
fsave0L         		EQU	RAM_START + 062h
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00033	A00064	fsave1H     var WORD  BANK0  SYSTEM
fsave1H         		EQU	RAM_START + 064h
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00036	A00066	fsave1L     var WORD  BANK0  SYSTEM
fsave1L         		EQU	RAM_START + 066h
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00034	A00068	fsave2H     var WORD  BANK0  SYSTEM
fsave2H         		EQU	RAM_START + 068h
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00037	A0006A	fsave2L     var WORD  BANK0  SYSTEM
fsave2L         		EQU	RAM_START + 06Ah
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00027	A0006C	bsave       var byte  BANK0  SYSTEM   ' location for BSR register
bsave           		EQU	RAM_START + 06Ch
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00060	A0006D	INTS_FROM     VAR BYTE BANK0 SYSTEM
INTS_FROM       		EQU	RAM_START + 06Dh
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00030	A0006E	psaveH      VAR BYTE  BANK0  SYSTEM   ' PCLATH Hi Pri.
psaveH          		EQU	RAM_START + 06Eh
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00031	A0006F	psaveL      VAR BYTE  BANK0  SYSTEM   '        Lo Pri.
psaveL          		EQU	RAM_START + 06Fh
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00028	A00070	psaveUH     VAR BYTE  BANK0  SYSTEM   ' PCLATU Hi Pri.
psaveUH         		EQU	RAM_START + 070h
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00029	A00071	psaveUL     VAR BYTE  BANK0  SYSTEM   '        Lo Pri.
psaveUL         		EQU	RAM_START + 071h
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00026	A00072	ssave       var byte  BANK0  SYSTEM   ' location for STATUS register
ssave           		EQU	RAM_START + 072h
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00052	A00073	USB_Flags          VAR BYTE BANK0
_USB_Flags       		EQU	RAM_START + 073h
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00033	A00074	USBRXBuffer        VAR BYTE[64]
_USBRXBuffer     		EQU	RAM_START + 074h
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00034	A000B4	USBTXBuffer        VAR BYTE[64]
_USBTXBuffer     		EQU	RAM_START + 0B4h
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00025	A00400	USBReservedMemory VAR BYTE[USBMEMORYSIZE] USBMEMORYADDRESS	
_USBReservedMemory		EQU	RAM_START + 00400h
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00271	PORTL   VAR     PORTB
_PORTL           		EQU	 PORTB
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00272	PORTH   VAR     PORTC
_PORTH           		EQU	 PORTC
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00273	TRISL   VAR     TRISB
_TRISL           		EQU	 TRISB
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00274	TRISH   VAR     TRISC
_TRISH           		EQU	 TRISC
_DUTY1??LOWBYTE  		EQU	_DUTY1
_DUTY1??HIGHBYTE 		EQU	_DUTY1 + 001h
_DUTY2??LOWBYTE  		EQU	_DUTY2
_DUTY2??HIGHBYTE 		EQU	_DUTY2 + 001h
#define _Serviced_H      	_INT_Flags??0
#define _Serviced_L      	_INT_Flags??1
#define _InHPint         	_INT_Flags??2
#define _NoPriority      	_INT_Flags??3
#define _IDLEIF          	_UIR??4
#define _SOFIF           	_UIR??6
#define _SOFIE           	_UIE??6
#define _RXOWNED         	_BD1STATOUT??7
#define _TXOWNED         	_BD1STATIN??7
#define _Plugged         	_USB_Flags??0
#define _RX_Rcvd         	_USB_Flags??1
#define _RX_READY        	_USB_Flags??2
#define _TX_READY        	_USB_Flags??3
#define _RX_ERROR        	_USB_Flags??4
#define _TX_ERROR        	_USB_Flags??5
#define _GIEsave         	 PB01, 000h
#define _INT_Flags??0    	 INT_Flags, 000h
#define _INT_Flags??1    	 INT_Flags, 001h
#define _INT_Flags??2    	 INT_Flags, 002h
#define _INT_Flags??3    	 INT_Flags, 003h
#define _UIR??4          	 UIR, 004h
#define _UIR??6          	 UIR, 006h
#define _UIE??6          	 UIE, 006h
#define _BD1STATOUT??7   	 BD1STATOUT, 007h
#define _BD1STATIN??7    	 BD1STATIN, 007h
#define _USB_Flags??0    	_USB_Flags, 000h
#define _USB_Flags??1    	_USB_Flags, 001h
#define _USB_Flags??2    	_USB_Flags, 002h
#define _USB_Flags??3    	_USB_Flags, 003h
#define _USB_Flags??4    	_USB_Flags, 004h
#define _USB_Flags??5    	_USB_Flags, 005h
#define _INTCON??7       	 INTCON, 007h
#define _R0??0           	 R0, 000h
#define _PORTC??1        	 PORTC, 001h
#define _PORTC??2        	 PORTC, 002h
#define _ADCON2??7       	 ADCON2, 007h
#define _PORTA??2        	 PORTA, 002h
#define _PORTA??3        	 PORTA, 003h
#define _PORTA??4        	 PORTA, 004h
#define _PORTA??5        	 PORTA, 005h
#define _CCP1CON??5      	 CCP1CON, 005h
#define _DUTY1??1        	_DUTY1, 001h
#define _CCP1CON??4      	 CCP1CON, 004h
#define _DUTY1??0        	_DUTY1, 000h
#define _CCP2CON??5      	 CCP2CON, 005h
#define _DUTY2??1        	_DUTY2, 001h
#define _CCP2CON??4      	 CCP2CON, 004h
#define _DUTY2??0        	_DUTY2, 000h

; Constants.
_USBMEMORYADDRESS		EQU	00400h
_USBMEMORYSIZE   		EQU	00100h

; EEPROM data.


	INCLUDE	"PICUSB.MAC"
	INCLUDE	"C:\PBP3\PBPPIC18.LIB"


; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00036	#HEADER
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00062	#CONFIG
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00252	BANKA   $0000, $005F
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00253	BANK0   $0060, $00FF
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00254	BANK1   $0100, $01FF
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00255	BANK2   $0200, $02FF
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00256	BANK3   $0300, $03FF
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00257	BANK4   $0400, $04FF
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00258	BANK5   $0500, $05FF
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00259	BANK6   $0600, $06FF
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00260	BANK7   $0700, $07FF
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00266	    INCLUDE "PBPPI18L.RAM"
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00267	#ELSE
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00268	    LIBRARY  "PBPPIC18"

; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00269	    INCLUDE "PBPPIC18.RAM"
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00270	#ENDIF
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00275	USBMEMORYADDRESS Con	$400	' USB RAM starts here
; C:\PBP3\DEVICES\PIC18F4550.PBPINC	00279	#HEADER

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00010	ASM  ; 18F2550/4550, 8mhz crystal

	ASM?
  ; 18F2550/4550, 8mhz crystal
   __CONFIG    _CONFIG1L, _PLLDIV_2_1L & _CPUDIV_OSC1_PLL2_1L & _USBDIV_2_1L
   __CONFIG    _CONFIG1H, _FOSC_HSPLL_HS_1H
   __CONFIG    _CONFIG2L, _PWRT_ON_2L & _BOR_OFF_2L & _VREGEN_ON_2L
   __CONFIG    _CONFIG2H, _WDT_ON_2H & _WDTPS_512_2H
   __CONFIG    _CONFIG3H, _PBADEN_OFF_3H
   __CONFIG    _CONFIG4L, _LVP_OFF_4L & _XINST_OFF_4L


	ENDASM?

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00018	DEFINE OSC 48

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00019	CLEAR
	CLEAR?	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00021	INCLUDE "DT_INTS-18.bas"     ; Base Interrupt System

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00020	DISABLE DEBUG
	DDISABLE?	
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00022	DEFINE  INTHAND       INT_ENTRY_H  ' Context saving for High Priority Ints
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00023	DEFINE  INTLHAND      INT_ENTRY_L  ' Context saving for Low Priority Ints

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00046	INT_Flags = 0 
	MOVE?CB	000h, INT_Flags

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00048	goto  OVER_DT_INTS_18
	GOTO?L	_OVER_DT_INTS_18

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00050	ASM

	ASM?

;____ Check for PBPL (PBP ver. 2.50 and above only)__________________________
PBPLongs_Used = 0
  if (R1 - R0 == 4)
PBPLongs_Used = 1
;    messg PBPL Used = 1
  endif

  nolist
;____ DEFINE available interrupt sources_____________________________________

  #define INT_INT   INTCON, INT0IF  ;-- INT External, 16F compatible
  #define INT0_INT  INTCON, INT0IF  ;-- INT0 External 
  #define INT1_INT  INTCON3,INT1IF  ;-- INT1 External 
  #define INT2_INT  INTCON3,INT2IF  ;-- INT2 External 
  #define INT3_INT  INTCON3,INT3IF  ;-- INT3 External 
  #define RBC_INT   INTCON, RBIF    ;-- RB Port Change 
  #define TMR0_INT  INTCON, TMR0IF  ;-- TMR0 Overflow  18F
  #define TMR1_INT  PIR1, TMR1IF    ;-- TMR1 Overflow 
  #define TMR2_INT  PIR1, TMR2IF    ;-- TMR2 to PR2 Match 
  #define TMR3_INT  PIR2, TMR3IF    ;-- TMR3 Overflow 
  #define TMR4_INT  PIR3, TMR4IF    ;-- TMR4 Overflow 
  #define TX_INT    PIR1, TXIF      ;-- USART Transmit 
  #define TX1_INT   PIR1, TX1IF     ;-- USART1 Transmit 
  #define TX2_INT   PIR3, TX2IF     ;-- USART2 Transmit 
  #define RX_INT    PIR1, RCIF      ;-- USART Receive 
  #define RX1_INT   PIR1, RC1IF     ;-- USART1 Receive 
  #define RX2_INT   PIR3, RC2IF     ;-- USART2 Receive 
  #define CMP_INT   PIR2, CMIF      ;-- Comparator 
  #define EE_INT    PIR2, EEIF      ;-- EEPROM/FLASH Write Operation 
  #define BUS_INT   PIR2, BCLIF     ;-- Bus Collision 
  #define LVD_INT   PIR2, LVDIF     ;-- Low Voltage Detect 
  #define HLVD_INT  PIR2, HLVDIF    ;-- High/Low Voltage Detect 
  #define PSP_INT   PIR1, PSPIF     ;-- Parallel Slave Port Read/Write 
  #define AD_INT    PIR1, ADIF      ;-- A/D Converter 
  #define SSP_INT   PIR1, SSPIF     ;-- Master Synchronous Serial Port 
  #define CCP1_INT  PIR1, CCP1IF    ;-- CCP1 
  #define CCP2_INT  PIR2, CCP2IF    ;-- CCP2 
  #define CCP3_INT  PIR3, CCP3IF    ;-- CCP3 
  #define CCP4_INT  PIR3, CCP4IF    ;-- CCP4 
  #define CCP5_INT  PIR3, CCP5IF    ;-- CCP5 
  #define OSC_INT   PIR2, OSCFIF    ;-- Oscillator Fail 

; -- Added for ver. 3.2 --
  #define SPP_INT   PIR1, SPPIF     ;-- Streaming Parallel Port Read/Write
  #define BUS1_INT  PIR2, BCL1IF    ;-- Bus 1 Collision 
  #define BUS2_INT  PIR3, BCL2IF    ;-- Bus 2 Collision
  #define ECCP1_INT PIR2, ECCP1IF   ;-- ECCP1
  #define LCD_INT   PIR3, LCDIF     ;-- LCD Driver
  #define PMP_INT   PIR1, PMPIF     ;-- Parallel Master Port
  #define SSP1_INT  PIR1, SSP1IF    ;-- Synchronous Serial Port 1
  #define SSP2_INT  PIR3, SSP2IF    ;-- Synchronous Serial Port 2
  #define TMR5_INT  PIR3, TMR5IF    ;-- Timer 5
  #define PT_INT    PIR3, PTIF      ;-- PWM Time Base
  #define IC1IF_INT  PIR3, IC1IF    ;-- Motion Feedback
  #define IC2QEIF_INT  PIR3, IC2QEIF  ;-- Motion Feedback
  #define IC3DRIF_INT  PIR3, IC3DRIF  ;-- Motion Feedback

;_____ Comparators __________________________________________________________
  #define CMP0_INT  PIR1, CMP0IF    ;-- Comparator 0 - 1230/1330 only

CMPIFREG = PIR2                     ;-- Comparator 1
CMPIEREG = PIE2
CMPIPREG = IPR2
    ifdef C1IF                      ;     18F24K20  18F25K20  18F26K20
CM1IFBIT = C1IF                     ;     18F44K20  18F45K20  18F46K20
    endif
    ifdef CM1IF
CM1IFBIT = CM1IF                    ;     several J PICs
    endif
    ifdef CMP1IF
CMPIFREG = PIR1                     ;     1230/1330 only
CM1IFBIT = CMP1IF
CMPIEREG = PIE1
CMPIPREG = IPR1
    endif

    ifdef CM1IFBIT
       #define CMP1_INT  CMPIFREG, CM1IFBIT     
    endif

    ifdef C2IF                      ;-- Comparator 2
CM2IFBIT = C2IF                     ;     18F24K20  18F25K20  18F26K20
    endif                           ;     18F44K20  18F45K20  18F46K20
    ifdef CM2IF
CM2IFBIT = CM2IF                    ;     several J PICs
    endif    
    ifdef CMP2IF
CM2IFBIT = CMP2IF                   ;     1230/1330 only
    endif    

    ifdef CM2IFBIT
      #define CMP2_INT  CMPIFREG, CM2IFBIT     
    endif

;_____ USB Module ___________________________________________________________

  #define USB_INT       PIR2, USBIF   ;-- USB Interrupt (funnel)
  #define USB_ACTV_INT  UIR,  ACTVIF  ;-- Bus Activity Detect 
  #define USB_ERR_INT   UIR,  UERRIF  ;-- USB Error Condition INT (funnel)
  #define USB_RST_INT   UIR,  URSTIF  ;-- USB Reset 
  #define USB_IDLE_INT  UIR,  IDLEIF  ;-- Idle Detect 
  #define USB_STALL_INT UIR,  STALLIF ;-- A STALL Handshake 
  #define USB_TRN_INT   UIR,  TRNIF   ;-- Transaction Complete 
  #define USB_SOF_INT   UIR,  SOFIF   ;-- START-OF-FRAME Token 

; -- USB Error Flags --
  #define USB_BTO_INT   UEIR, BTOEF   ;-- Bus Turnaround Time-out Error
  #define USB_BTS_INT   UEIR, BTSEF   ;-- Bit Stuff Error
  #define USB_CRC16_INT UEIR, CRC16EF ;-- CRC16 Failure
  #define USB_CRC5_INT  UEIR, CRC5EF  ;-- CRC5 Host Error
  #define USB_DFN8_INT  UEIR, DFN8EF  ;-- Data Field Size Error
  #define USB_PID_INT   UEIR, PIDEF   ;-- PID Check Failure
   
;_____ Ethernet Module ______________________________________________________
  #define ETH_INT       PIR2, ETHIF   ;-- Ethernet Module
  #define ETH_DMA_INT    EIR, DMAIF   ;-- DMA Interrupt
  #define ETH_LINK_INT   EIR, LINKIF  ;-- Link Status Change
  #define ETH_PKT_INT    EIR, PKTIF   ;-- Receive Packet Pending
  #define ETH_RXER_INT   EIR, RXERIF  ;-- Receive Error
  #define ETH_TXER_INT   EIR, TXERIF  ;-- Transmit Error
  #define ETH_TX_INT     EIR, TXIF    ;-- Transmit

;_____ CAN Module ___________________________________________________________
  #define CAN_ERR_INT    PIR3, ERRIF    ;-- CAN bus Error
  #define CAN_IRX_INT    PIR3, IRXIF    ;-- Invalid Received Message
  #define CAN_RXB0_INT   PIR3, RXB0IF   ;-* Receive Buffer 0      Mode 0
  #define CAN_FIFOWM_INT PIR3, FIFOWMIF ;-- FIFO Watermark        Mode 1, 2
  #define CAN_RXB1_INT   PIR3, RXB1IF   ;-* Receive Buffer 1      Mode 0
  #define CAN_RXBn_INT   PIR3, RXBnIF   ;-- Any Receive Buffer    Mode 1, 2
  #define CAN_TXB0_INT   PIR3, TXB0IF   ;-- Transmit Buffer 0
  #define CAN_TXB1_INT   PIR3, TXB1IF   ;-- Transmit Buffer 1
  #define CAN_TXB2_INT   PIR3, TXB2IF   ;-* Transmit Buffer 2     Mode 0
  #define CAN_TXBn_INT   PIR3, TXBnIF   ;-- Any Transmit Buffer   Mode 1, 2
  #define CAN_WAKE_INT   PIR3, WAKIF    ;-- CAN bus Activity Wake-up


	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00187	asm

	ASM?

; -- macro --
INT_Source  macro  IFR, IFB, IER, IEB, IPR, IPB
    if (IflagReg == IFR) && (IflagBit == IFB)  
  list  
INT_Flag_Reg = IFR
INT_Flag_Bit = IFB
INT_Enable_Reg = IER
INT_Enable_Bit = IEB
INT_Priority_Reg = IPR
INT_Priority_Bit = IPB
Found = 1
    endif
  nolist  
    endm 


	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00205	asm

	ASM?

;____________________________________________________________________________
GetIntInfo  macro  IflagReg, IflagBit
  nolist
INT_Flag_Reg = -1
INT_Flag_Bit = -1
INT_Enable_Reg = -1
INT_Enable_Bit = -1
  ifdef  IPR1
INT_Priority_Reg = -1
INT_Priority_Bit = -1
  endif
Found = 0
  ifdef INT0IF
      INT_Source  INTCON,INT0IF, INTCON,INT0IE, -1, -1
  endif
  ifdef INT1IF
      INT_Source  INTCON3,INT1IF, INTCON3,INT1IE, INTCON3,INT1IP
  endif
  ifdef INT2IF
      INT_Source  INTCON3,INT2IF, INTCON3,INT2IE, INTCON3,INT2IP
  endif
  ifdef INT3IF
      INT_Source  INTCON3,INT3IF, INTCON3,INT3IE, INTCON2,INT3IP
  endif
  ifdef RBIF
      INT_Source  INTCON,RBIF, INTCON, RBIE,INTCON2,RBIP
  endif
  ifdef TMR0IF
      INT_Source  INTCON,TMR0IF, INTCON,TMR0IE, INTCON2,TMR0IP
  endif
  ifdef TMR1IF
      INT_Source  PIR1,TMR1IF, PIE1,TMR1IE, IPR1,TMR1IP
  endif
  ifdef TMR2IF
      INT_Source  PIR1,TMR2IF, PIE1,TMR2IE, IPR1,TMR2IP
  endif
  ifdef TMR3IF
      INT_Source  PIR2,TMR3IF, PIE2,TMR3IE, IPR2,TMR3IP
  endif
  ifdef TMR4IF
      INT_Source  PIR3,TMR4IF, PIE3,TMR4IE, IPR3,TMR4IP
  endif
  ifndef TX1IF
      ifdef TXIF
          INT_Source  PIR1,TXIF, PIE1,TXIE, IPR1,TXIP
      endif
  endif
  ifdef TX1IF
      INT_Source  PIR1,TX1IF, PIE1,TX1IE, IPR1,TX1IP
  endif
  ifdef TX2IF
      INT_Source  PIR3,TX2IF, PIE3,TX2IE, IPR3,TX2IP
  endif
  ifndef RC1IF
    ifdef RCIF
        INT_Source  PIR1,RCIF, PIE1,RCIE, IPR1,RCIP
    endif
  endif
  ifdef RC1IF
      INT_Source  PIR1,RC1IF, PIE1,RC1IE, IPR1,RC1IP
  endif
  ifdef RC2IF
      INT_Source  PIR3,RC2IF, PIE3,RC2IE, IPR3,RC2IP
  endif
  ifdef CMIF
      INT_Source  PIR2,CMIF, PIE2,CMIE, IPR2,CMIP
  endif
  ifdef EEIF
      INT_Source  PIR2,EEIF, PIE2,EEIE, IPR2,EEIP
  endif
  ifdef BCLIF
      INT_Source  PIR2,BCLIF, PIE2,BCLIE, IPR2,BCLIP
  endif
  ifdef LVDIF
      INT_Source  PIR2,LVDIF, PIE2,LVDIE, IPR2,LVDIP
  endif
  ifdef HLVDIF
      INT_Source  PIR2,HLVDIF, PIE2,HLVDIE, IPR2,HLVDIP
  endif
  ifdef PSPIF
      INT_Source  PIR1,PSPIF, PIE1,PSPIE, IPR1,PSPIP
  endif
  ifdef ADIF
      INT_Source  PIR1,ADIF, PIE1,ADIE, IPR1,ADIP
  endif
  ifdef SSPIF
      INT_Source  PIR1,SSPIF, PIE1,SSPIE, IPR1,SSPIP
  endif
  ifdef CCP1IF
      INT_Source  PIR1,CCP1IF, PIE1,CCP1IE, IPR1,CCP1IP
  endif
  ifdef CCP2IF
      INT_Source  PIR2,CCP2IF, PIE2,CCP2IE, IPR2,CCP2IP
  endif
  ifdef CCP3IF
      INT_Source  PIR3,CCP3IF, PIE3,CCP3IE, IPR3,CCP3IP
  endif
  ifdef CCP4IF
      INT_Source  PIR3,CCP4IF, PIE3,CCP4IE, IPR3,CCP4IP
  endif
  ifdef CCP5IF
      INT_Source  PIR3,CCP5IF, PIE3,CCP5IE, IPR3,CCP5IP
  endif
  ifdef OSCFIF
      INT_Source  PIR2,OSCFIF, PIE2,OSCFIE, IPR2,OSCFIP
  endif
  ifdef SPPIF
      INT_Source  PIR1,SPPIF, PIE1,SPPIE, IPR1,SPPIP
  endif
  ifdef BCL1IF
      INT_Source  BUS1_INT, PIE2,BCL1IE, IPR2,BCL1IP
  endif
  ifdef BCL2IF
      INT_Source  BUS2_INT, PIE3,BCL2IE, IPR3,BCL2IP
  endif
  ifdef CMP0IF
      INT_Source  CMP0_INT, PIE1,CMP0IE, IPR1,CMP0IP
  endif
  ifdef CM1IFBIT
      INT_Source  CMP1_INT, CMPIEREG,CM1IFBIT, CMPIPREG,CM1IFBIT
  endif
  ifdef CM2IFBIT
      INT_Source  CMP2_INT, CMPIEREG,CM2IFBIT, CMPIPREG,CM2IFBIT
  endif
  ifdef ECCP1IF
      INT_Source  ECCP1_INT, PIE2,ECCP1IE, IPR2,ECCP1IP
  endif
  ifdef LCDIF
      INT_Source  LCD_INT, PIE3,LCDIE, IPR3,LCDIP
  endif
  ifdef PMPIF
      INT_Source  PMP_INT, PIE1,PMPIE, IPR1,PMPIP
  endif
  ifdef SSP1IF
      INT_Source  SSP1_INT, PIE1,SSP1IE, IPR1,SSP1IP
  endif
  ifdef SSP2IF
      INT_Source  SSP2_INT, PIE3,SSP2IE, IPR3,SSP2IP
  endif
  ifdef TMR5IF
      INT_Source  TMR5_INT, PIE3,TMR5IE, IPR3,TMR5IP
  endif
  ifdef PTIF
      INT_Source  PT_INT, PIE3,PTIE, IPR3,PTIP
  endif
  ifdef IC1IF
      INT_Source  IC1IF_INT, PIE3,IC1IE, IPR3,IC1IP
  endif
  ifdef IC2QEIF
      INT_Source  IC2QEIF_INT, PIE3,IC2QEIE, IPR3,IC2QEIP
  endif
  ifdef IC3DRIF
      INT_Source  IC3DRIF_INT, PIE3,IC3DRIE, IPR3,IC3DRIP
  endif
  ifdef USBIF
      INT_Source  PIR2,USBIF, PIE2,USBIE, IPR2,USBIP
      INT_Source  USB_ACTV_INT, UIE,ACTVIE, _NoPriority
      INT_Source  USB_RST_INT, UIE,URSTIE, _NoPriority
      INT_Source  USB_IDLE_INT, UIE,IDLEIE, _NoPriority
      INT_Source  USB_STALL_INT, UIE,STALLIE, _NoPriority
      INT_Source  USB_TRN_INT, UIE,TRNIE, _NoPriority
      INT_Source  USB_SOF_INT, UIE,SOFIE, _NoPriority
      INT_Source  USB_ERR_INT, UIE,UERRIE, _NoPriority
      INT_Source  USB_BTO_INT, UEIE,BTOEE, _NoPriority
      INT_Source  USB_BTS_INT, UEIE,BTSEE, _NoPriority
      INT_Source  USB_CRC16_INT, UEIE,CRC16EE, _NoPriority
      INT_Source  USB_CRC5_INT, UEIE,CRC5EE, _NoPriority
      INT_Source  USB_DFN8_INT, UEIE,DFN8EE, _NoPriority
      INT_Source  USB_PID_INT, UEIE,PIDEE, _NoPriority
  endif
  ifdef ETHIF
      INT_Source  ETH_INT, PIE2,ETHIE, IPR2,ETHIP
      INT_Source  ETH_DMA_INT, EIE,DMAIE, _NoPriority
      INT_Source  ETH_LINK_INT, EIE,LINKIE, _NoPriority
      INT_Source  ETH_PKT_INT, EIE,PKTIE, _NoPriority
      INT_Source  ETH_RXER_INT, EIE,RXERIE, _NoPriority
      INT_Source  ETH_TXER_INT, EIE,TXERIE, _NoPriority
      INT_Source  ETH_TX_INT, EIE,TXIE, _NoPriority
  endif
  ifdef WAKIF  
      INT_Source  CAN_ERR_INT, PIE3,ERRIE, IPR3,ERRIP
      INT_Source  CAN_IRX_INT, PIE3,IRXIE, IPR3,IRXIP
      INT_Source  CAN_RXB0_INT, PIE3,RXB0IE, IPR3,RXB0IP
      INT_Source  CAN_FIFOWM_INT, PIE3,FIFOWMIE, IPR3,FIFOWMIP
      INT_Source  CAN_RXB1_INT, PIE3,RXB1IE, IPR3,RXB1IP
      INT_Source  CAN_RXBn_INT, PIE3,RXBnIE, IPR3,RXBnIP
      INT_Source  CAN_TXB0_INT, PIE3,TXB0IE, IPR3,TXB0IP
      INT_Source  CAN_TXB1_INT, PIE3,TXB1IE, IPR3,TXB1IP
      INT_Source  CAN_TXB2_INT, PIE3,TXB2IE, IPR3,TXB2IP
      INT_Source  CAN_TXBn_INT, PIE3,TXBnIE, IPR3,TXBnIP
      INT_Source  CAN_WAKE_INT, PIE3,WAKIE, IPR3,WAKIP
  endif
  list
    endm
  list  


	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00404	ASM

	ASM?

    ifndef  USE_LOWPRIORITY
INT_ENTRY_L
        retfie
    else
        if (USE_LOWPRIORITY != 1)
INT_ENTRY_L
            retfie
        endif
    endif        


	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00417	Asm

	ASM?

asm = 0    ; Assembly language Interrupts
ASM = 0
Asm = 0
pbp = 1    ; Basic language interrupts
PBP = 1
Pbp = 1
YES = 1
yes = 1
Yes = 1
NO = 0
no = 0
No = 0
H equ 'H'  ; High Priority
h equ 'H'
L equ 'L'  ; Low Priority
l equ 'L'

  nolist
  
;_____________________________________________________________________________
SaveFSR  macro  F, Pr
  list
    if (F >= 0) && (F <= 2)
        if (Pr == H) || (Pr == L)
            movff    FSR#v(F)L, fsave#v(F)Pr
            movff    FSR#v(F)H, fsave#v(F)Pr + 1
          nolist
        else
            ERROR "SaveFSR - Invalid Priority"
        endif
    else
        ERROR "SaveFSR - Invalid FSR number"
    endif
    list
  endm


	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00456	Asm

	ASM?

RestFSR  macro  F, Pr
  list
    if (F >= 0) && (F <= 2)
        if (Pr == H) || (Pr == L)
            movff    fsave#v(F)Pr , FSR#v(F)L
            movff    fsave#v(F)Pr + 1 , FSR#v(F)H 
          nolist
        else
            ERROR "RestFSR - Invalid Priority"
        endif
    else
        ERROR "RestFSR - Invalid FSR number"
    endif
    list
  endm


	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00475	Asm

	ASM?

INT_FINISH_H   macro
  endm


	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00481	ASM

	ASM?

INT_CREATE_H  macro
  local OverCREATE
    goto OverCREATE
Priority = H    
INT_ENTRY_H  
    movff   PCLATU, psaveUH
    movff   PCLATH, psaveH
    SaveFSR  0, H
    SaveFSR  1, H
    SaveFSR  2, H
    bsf      _InHPint, 0
List_Start_H
    bcf      _Serviced_H, 0         ; Clear Serviced flag
    clrf  BSR
PREV_BANK = 0
    ifdef INT_LIST_H
        INT_LIST_H                  ; Expand the users list of HP INT handlers
    else
        ifdef INT_LIST
            INT_LIST                ; Expand the 16F Compatible List
        else
            error "INT_CREATE_H - INT_LIST or INT_LIST_H not found"
        endif
    endif
    btfsc    _Serviced_H,0          ; if anything was serviced
    goto     List_Start_H           ; go around, and check again

    ifdef ReEnterHPused             ; was ReEnterPBP-18.bas included
        GetAddress21  INT_EXIT_H, RetAddrH
        L?GOTO   _RestorePBP_H      ; Restore PBP system Vars
    endif

INT_EXIT_H
PREV_BANK = 0
    bcf      _InHPint, 0
    RestFSR  0, H                   ; Restore FSR0, if it was saved?
    RestFSR  1, H                   ; Restore FSR1, if it was saved?
    RestFSR  2, H                   ; Restore FSR2, if it was saved?
    movff    psaveH, PCLATH
    movff    psaveUH, PCLATU
    retfie    FAST                  ; Return from Interrupt
OverCREATE
    bsf   INTCON,GIE, 0             ; Enable High Priority Interrupts
    bsf   INTCON,PEIE, 0            ; Enable Peripheral Interrupts
  endm

;---[Stay compatible with the 14-bit version]---------------------------------
INT_CREATE  macro
    INT_CREATE_H
  endm


	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00535	ASM

	ASM?

INT_CREATE_L  macro
  local OverCREATE
    goto OverCREATE
    ifdef USE_LOWPRIORITY
        if (USE_LOWPRIORITY != 1)
       error "'DEFINE USE_LOWPRIORITY 1' required for Low Priority Interrupts"
        endif
    else
       error "'DEFINE USE_LOWPRIORITY 1' required for Low Priority Interrupts"
    endif
Priority = L
INT_ENTRY_L  
    movff   WREG, wsave             ; Wreg
    movff   STATUS, ssave           ; STATUS
    movff   BSR, bsave              ; BSR
    movff   PCLATU, psaveUL
    movff   PCLATH, psaveL
    SaveFSR  0, L                   ; FSR0
    SaveFSR  1, L                   ; FSR1
    SaveFSR  2, L                   ; FSR2
    bcf      _InHPint, 0    
List_Start_L
  clrf  BSR
PREV_BANK = 0
    bcf      _Serviced_L, 0
    ifdef INT_LIST_L
        INT_LIST_L                  ; Expand the users list of HP INT handlers
    else
        error "INT_CREATE_L - INT_LIST_L not defined, can not create"
    endif
    btfsc    _Serviced_L, 0         ; if anything was serviced
    goto     List_Start_L           ; go around, and check again

    ifdef ReEnterLPused             ; was ReEnterPBP-18LP.bas included
        GetAddress21  INT_EXIT_L, RetAddrL
        L?GOTO   _RestorePBP_L      ; Restore PBP system Vars
    endif

INT_EXIT_L
PREV_BANK = 0
    RestFSR  0, L                   ; Restore saved vars
    RestFSR  1, L
    RestFSR  2, L                
    movff   psaveUL, PCLATU
    movff   psaveL, PCLATH
    movff   bsave, BSR              ; BSR
    movff   wsave, WREG             ; WREG
    movff   ssave, STATUS           ; STATUS
    retfie                          ; Return from Interrupt
OverCREATE
    bsf   RCON,IPEN, 0              ; Enable Interrupt Priorities
    bsf   INTCON,GIEL, 0            ; Enable Low Priority Interrupts
  endm


	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00591	ASM

	ASM?

;---[Returns the Address of a Label as a Word]--(under 64K)------------------
GetAddress macro Label, Wout
    CHK?RP Wout
    movlw low Label          ; get low byte
    movwf Wout
    movlw High Label         ; get high byte
    movwf Wout + 1
    endm

;---[Returns the Address of a Label as a 3 byte array]---(under/over 64k)-----
GetAddress21 macro Label, Aout
    CHK?RP Aout
    movlw low Label          ; get low byte
    movwf Aout
    movlw high Label         ; get high byte
    movwf Aout + 1
    movlw upper Label        ; get upper byte
    movwf Aout + 2
    endm

;---[find correct bank for a PBP BIT variable]-------------------------------
CHKRP?T  macro reg, bit
        CHK?RP  reg
    endm
    


;---[find Assigned Priority for specified INT Source]------------------------
INT_Count = 0

FindIntPriority  macro IntFlagReg, IntFlagBit
  local LoopCount
    nolist
Pfound = 0
LoopCount = 1
      while LoopCount <= INT_Count
          if  (IntFlagReg == PrList#v(LoopCount)R)
             if (IntFlagBit == PrList#v(LoopCount)B)
  list
Priority =  PrList#v(LoopCount)Priority
Pfound = 1
             endif
          endif
LoopCount += 1
      endw
  endm  


	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00640	ASM

	ASM?


;---[Add an Interrupt Source to the user's list of INT Handlers]--------------
INT_Handler  macro  IntFlagReg, IntFlagBit, Label, Type, Reset
  list
    local AfterSave, AfterUser, NoInt
INT_Count += 1
PrList#v(INT_Count)R = IntFlagReg
PrList#v(INT_Count)B = IntFlagBit
PrList#v(INT_Count)Priority = Priority
        GetIntInfo   IntFlagReg, IntFlagBit
        if (Found == YES)
            btfss    INT_Enable_Reg, INT_Enable_Bit, 0  ; if INT is enabled
            goto   NoInt
            btfss    INT_Flag_Reg, INT_Flag_Bit, 0      ; and the Flag set?
            goto     NoInt
            if (Priority == H)
                bsf      _Serviced_H, 0
            else
                bsf      _Serviced_L, 0
            endif
            ifdef NO_CLRWDT
                if  (NO_CLRWDT != 1)
                    CLRWDT
                endif
            else
                CLRWDT
            endif
                
            if (Type == PBP)                         ; If INT handler is PBP
              if (Priority == H)
                ifdef ReEnterHPused
                    GetAddress21  AfterSave, RetAddrH  
                    L?GOTO  _SavePBP_H        ; Save PBP system Vars in HP INT
                else
    error "ReEnterPBP-18 must be INCLUDEd to use High Priority PBP interrupts"
                endif
              else ; Priority = L
                ifdef ReEnterLPused
                    GetAddress21  AfterSave, RetAddrL  
                    L?GOTO  _SavePBP_L        ; Save PBP system Vars in LP INT
                else
   error "ReEnterPBP-18LP must be INCLUDEd to use Low Priority PBP interrupts"
                endif
              endif
            endif
AfterSave
PREV_BANK = 0
            if (Priority == H)
                  GetAddress21  AfterUser, RetAddrH  
            else ; Priority = L
                  GetAddress21  AfterUser, RetAddrL
            endif  
            L?GOTO   Label                        ; goto the users INT handler
                    
AfterUser
PREV_BANK = 0
            if (Reset == YES)                      ; reset flag (if specified)
                bcf      INT_Flag_Reg, INT_Flag_Bit, 0 
            endif
        else
            error Interrupt Source (IntFlagReg,IntFlagBit) not found
        endif
NoInt
    clrf  BSR
PREV_BANK = 0
    endm


	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00709	asm

	ASM?

;---[Returns from a "goto" subroutine]--(21-bit RetAddr? must be set first)---
INT_RETURN  macro
  local Ret2LP, Ret2HP
      btfsc   _InHPint, 0
      goto    Ret2HP
Ret2LP
      movff   RetAddrL + 2, PCLATU  ; Load PC buffers with return address
      movff   RetAddrL + 1, PCLATH
      movf    RetAddrL, W, 0
    clrf  BSR                    ; Set to BANK0 before returning
PREV_BANK = 0                    ; Tell PBP about the BANK change
      movwf   PCL, 0             ; Go back to where we were
      
Ret2HP       
      movff   RetAddrH + 2, PCLATU ; Load PC buffers with return address
      movff   RetAddrH + 1, PCLATH
      movf    RetAddrH, W, 0
    clrf  BSR                    ; Set to BANK0 before returning
PREV_BANK = 0                    ; Tell PBP about the BANK change
      movwf   PCL, 0             ; Go back to where we were
    endm    
    
;---[Enable an interrupt source]----------------------------------------------
INT_ENABLE  macro  IntFlagReg, IntFlagBit
      GetIntInfo   IntFlagReg, IntFlagBit
      if (Found == YES)
          FindIntPriority  IntFlagReg, IntFlagBit
          if (Pfound == 1)
              if (INT_Priority_Reg != -1)
                  if (Priority == H)
                      bsf  INT_Priority_Reg, INT_Priority_Bit, 0
                  else
                      if (Priority == L)
                          bcf  INT_Priority_Reg, INT_Priority_Bit, 0
                      else
                          error "INT_ENABLE - Invalid Priority Specified"
                      endif
                  endif
              else
                  if (Priority == L)
                      error "INT0_INT can NOT be assigned to Low Priority"
                  endif
              endif
          else
              error "INT_ENABLE - Priority State Not Found"
          endif
;          bcf     INT_Flag_Reg, INT_Flag_Bit, 0        ; clear the flag first 
          bsf     INT_Enable_Reg, INT_Enable_Bit, 0    ; enable the INT source  
      else
          error  "INT_ENABLE - Interrupt Source not found!"
      endif
    endm    

;---[Disable an interrupt source]---------------------------------------------
INT_DISABLE  macro  IntFlagReg, IntFlagBit
      GetIntInfo   IntFlagReg, IntFlagBit
      if (Found == YES)
          bcf     INT_Enable_Reg, INT_Enable_Bit, 0   ; disable the INT source  
      else
          error "INT_DISABLE - Interrupt Source not found!"
      endif
    endm    

;---[Clear an interrupt Flag]-------------------------------------------------
INT_CLEAR  macro  IntFlagReg, IntFlagBit
      GetIntInfo   IntFlagReg, IntFlagBit
      if (Found == YES)
          bcf     INT_Flag_Reg, INT_Flag_Bit, 0       ; clear the INT flag
      else
          error "INT_CLEAR -  Interrupt Source not found!"
      endif
    endm



	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00786	ASM

	ASM?

Save_TBLPTR = 0

    ifdef SIN_USED
Save_TBLPTR = 1
    endif
    ifdef DTMFOUT_USED
Save_TBLPTR = 1
    endif
    ifdef SERDELAY_USED
Save_TBLPTR = 1
    endif
    ifdef CONVBIT_USED
Save_TBLPTR = 1
    endif
    ifdef ERASECODE_USED
Save_TBLPTR = 1
    endif
    ifdef READCODE_USED
Save_TBLPTR = 1
    endif
    ifdef WRITECODE_USED
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?BCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?BCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?BCLW
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?CCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?CCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?CCLW
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?WCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?WCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?WCLW
Save_TBLPTR = 1
    endif
    ifdef LOOK2_USED 
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?BCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?BCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?BCLW
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?CCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?CCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?CCLW
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?TCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?TCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?TCLW
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?WCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?WCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?WCLW
Save_TBLPTR = 1
    endif


	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00878	OVER_DT_INTS_18:

	LABEL?L	_OVER_DT_INTS_18	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_INTS-18.BAS	00880	ENABLE DEBUG
	DENABLE?	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00022	ASM

	ASM?

INT_LIST  macro    ; IntSource,          Label,  Type, ResetFlag?
        INT_Handler   USB_Handler
    endm
    INT_CREATE               ; Creates the interrupt processor


	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00029	INCLUDE "DT_HID260.pbp"

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00019	DISABLE DEBUG
	DDISABLE?	
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00020	DEFINE DT_HID_USED  1
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00024	USBMEMORYSIZE     CON 256  ; USB RAM size in bytes
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00036	USBBufferSizeRX    CON EXT      : @USBBufferSizeRX = USB_OUTSIZE

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00036	USBBufferSizeRX    CON EXT      : @USBBufferSizeRX = USB_OUTSIZE

	ASM?
USBBufferSizeRX = USB_OUTSIZE

	ENDASM?

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00037	USBBufferSizeTX    CON EXT      : @USBBufferSizeTX = USB_INSIZE

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00037	USBBufferSizeTX    CON EXT      : @USBBufferSizeTX = USB_INSIZE

	ASM?
USBBufferSizeTX = USB_INSIZE

	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00039	USBRXBufferCount   Var Byte     : USBRXBufferCount = USBBufferSizeRX
	MOVE?CB	USBBufferSizeRX, _USBRXBufferCount

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00040	USBTXBufferCount   Var Byte     : USBTXBufferCount = USBBufferSizeTX
	MOVE?CB	USBBufferSizeTX, _USBTXBufferCount

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00046	BD1STATOUT         VAR BYTE EXT : @BD1STATOUT = _USBMEMORYADDRESS + 8 ; 408h

	ASM?
BD1STATOUT = _USBMEMORYADDRESS + 8 ; 408h

	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00049	BD1STATIN          VAR BYTE EXT : @BD1STATIN = _USBMEMORYADDRESS + 0Ch ;40Ch

	ASM?
BD1STATIN = _USBMEMORYADDRESS + 0Ch ;40Ch

	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00062	pause 100                    ; Allow VUSB to stabilize
	PAUSE?C	064h

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00063	usbinit                      ; initialize the USB driver
	USBINIT?	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00064	usbservice                   ; service it once
	USBSERVICE?	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00065	UIE = $7F                    ; enable USB interrupts
	MOVE?CB	07Fh, UIE

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00066	UEIE = $9F                   ; enable USB Error interrupts
	MOVE?CB	09Fh, UEIE

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00068	gosub MakeStrings            ; Create Descriptor strings (First-Run only)
	GOSUB?L	_MakeStrings

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00069	gosub ClearRXbuffer          ; clear the USB buffers
	GOSUB?L	_ClearRXbuffer

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00070	gosub ClearTXbuffer
	GOSUB?L	_ClearTXbuffer

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00072	@   INT_ENABLE  USB_INT

	ASM?
   INT_ENABLE  USB_INT

	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00074	GOTO Over_DT_HID
	GOTO?L	_Over_DT_HID
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00079	DEFINE   USB_Handler    USB_INT, _DoUSBService,  ASM,  yes

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00082	ASM

	ASM?

    ifndef  USB_LEDPOLARITY          ; If LED polarity wasn't specified?
USB_LEDPOLARITY = 1                  ;   default to ON when HIGH
    endif
    
;-------------------------------     
LEDOFF  macro Port, Bit              ; -- Turn LED OFF --
    if (USB_LEDPOLARITY == 1)        ;   If LED is ON when HIGH?
        LOW?T  Port, Bit             ;     make it LOW
    else                             ;   otherwise
        HIGH?T Port, Bit             ;     make it HIGH
    endif
  endm

;-------------------------------  
LEDON  macro Port,Bit                ; -- Turn LED ON --
    if (USB_LEDPOLARITY == 1)        ;   If LED is ON when HIGH?
        HIGH?T Port, Bit             ;     make it HIGH
    else                             ;   otherwise
        LOW?T  Port, Bit             ;     make it LOW
    endif
  endm

;-------------------------------  
ifLEDisON  macro Port,Bit, Label
    if (USB_LEDPOLARITY == 1)        ; if LED is ON when HIGH
        btfsc   Port, Bit            ;   and the pin is LOW
    else                             ; or if LED is ON when LOW
        btfss   Port, Bit            ;   and the pin is HIGH
    endif                            ; then the LED is OFF
    goto      Label                  ;    so don't jump to the label
  endm                                       
;-------------------------------  
ifLEDisOFF  macro Port,Bit, Label
    if (USB_LEDPOLARITY == 1)        ; if LED is ON when HIGH
        btfss   Port, Bit            ;   and the pin is HIGH
    else                             ; or if LED is ON when LOW
        btfsc   Port, Bit            ;   and the pin is LOW
    endif                            ; then the LED is ON
    goto      Label                  ;    so don't jump to the label
  endm  


	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00126		Asm

	ASM?


#define USB_EP0_BUFF_SIZE	8	; 8, 16, 32, or 64
#define USB_MAX_NUM_INT		1
#define USB_MAX_EP_NUMBER	1
#define NUM_CONFIGURATIONS	1
#define NUM_INTERFACES		1

#define UCFG_VAL	USB_PULLUP_ENABLE|USB_INTERNAL_TRANSCEIVER|USB_FULL_SPEED|USB_PING_PONG__NO_PING_PONG
;#define UCFG_VAL	USB_PULLUP_ENABLE|USB_INTERNAL_TRANSCEIVER|USB_LOW_SPEED|USB_PING_PONG__NO_PING_PONG

;#define USE_SELF_POWER_SENSE_IO
;#define USE_USB_BUS_SENSE_IO

#define USB_POLLING

; HID
; Endpoints Allocation
#define HID_INTF_ID		0x00
#define HID_EP			1
#define HID_INT_OUT_EP_SIZE	USB_OUTSIZE ;8
#define HID_INT_IN_EP_SIZE	USB_INSIZE  ;8
#define HID_NUM_OF_DSC		1

	include	"usb_hid.asm"	; Include rest of USB files, starting with HID class code

; ******************************************************************
; This table is polled by the host immediately after USB Reset has been released.
; This table defines the maximum packet size EP0 can take.
; See section 9.6.1 of the Rev 1.0 USB specification.
; These fields are application DEPENDENT. Modify these to meet
; your specifications.
; ******************************************************************
DeviceDescriptor
	retlw	(EndDeviceDescriptor-DeviceDescriptor)/2	; Size of this descriptor in bytes
	retlw	USB_DESCRIPTOR_DEVICE	; DEVICE descriptor type
	retlw	0x10		; USB Spec Release Number in BCD format - 1.10 (low byte)
	retlw	0x01		; (high byte)
	retlw	0x00		; Class Code
	retlw	0x00		; Subclass code
	retlw	0x00		; Protocol code
	retlw	USB_EP0_BUFF_SIZE	; Max packet size for EP0

	retlw	low(USB_VENDORID)   ; VendorID
	retlw	high(USB_VENDORID) 

	retlw	low(USB_PRODUCTID)  ; ProductID
	retlw	high(USB_PRODUCTID) 

  retlw low(USB_VERSION)    ; Version
	retlw	high(USB_VERSION)

;	retlw	0x25		; Vendor ID - 0x0925 is LakeView Research ID (low byte)
;	retlw	0x09		; (high byte)
;	retlw	0x34		; Product ID: Jan Axelson demo (low byte)
;	retlw	0x12		; (high byte)
;	retlw	0x01		; Device release number in BCD format (low byte)
;	retlw	0x00		; (high byte)

	retlw	0x01		; Manufacturer string index
	retlw	0x02		; Product string index
	retlw	0x03		; Device serial number string index
	retlw	NUM_CONFIGURATIONS	; Number of possible configurations
EndDeviceDescriptor

; ******************************************************************
; This table is retrieved by the host after the address has been set.
; This table defines the configurations available for the device.
; See section 9.6.2 of the Rev 1.0 USB specification (page 184).
; These fields are application DEPENDENT. 
; Modify these to meet your specifications.
; ******************************************************************
; Configuration pointer table
USB_CD_Ptr
Configs
	db	low Config1, high Config1
	db	upper Config1, 0

; Configuration Descriptor
Config1
	retlw	(Interface1-Config1)/2	; Size of this descriptor in bytes
	retlw	USB_DESCRIPTOR_CONFIGURATION	; CONFIGURATION descriptor type
Config1Len
	retlw	low ((EndConfig1-Config1)/2)	; Total length of data for this cfg
	retlw	high ((EndConfig1-Config1)/2)
	retlw	NUM_INTERFACES	; Number of interfaces in this cfg
	retlw	0x01		; Index value of this configuration
	retlw	0x00		; Configuration string index
	retlw	_DEFAULT|_SELF	; Attributes
	retlw	50		; Max power consumption (2X mA)
Interface1
	retlw	(HIDDescriptor1-Interface1)/2	; Size of this descriptor in bytes
	retlw	USB_DESCRIPTOR_INTERFACE	; INTERFACE descriptor type
	retlw	0x00		; Interface Number
	retlw	0x00		; Alternate Setting Number
	retlw	0x02		; Number of endpoints in this intf
	retlw	HID_INTF	; Class code
	retlw	0x00		; Subclass code
	retlw	0x00		; Protocol code
	retlw	0x00		; Interface string index
HIDDescriptor1
	retlw	(Endpoint1Out-HIDDescriptor1)/2	; Size of this descriptor in bytes
	retlw	DSC_HID		; HID descriptor type
	retlw	0x11		; HID Spec Release Number in BCD format - 1.11 (low byte)
	retlw	0x01		; (high byte)
	retlw	0x00		; Country Code (0x00 for Not supported)
	retlw	HID_NUM_OF_DSC	; Number of class descriptors
	retlw	DSC_RPT		; Report descriptor type (HID)
ReportDescriptor1Len
	retlw	low ((EndReportDescriptor1-ReportDescriptor1)/2)
	retlw	high ((EndReportDescriptor1-ReportDescriptor1)/2)
Endpoint1Out
	retlw	(Endpoint1In-Endpoint1Out)/2		; Size of this descriptor in bytes
	retlw	USB_DESCRIPTOR_ENDPOINT	; ENDPOINT descriptor type
	retlw	HID_EP|_EP_OUT	; Endpoint Address
	retlw	_INT		; Attributes
	retlw	low (HID_INT_OUT_EP_SIZE)	; Size of the endpoint buffer in bytes (low byte)
	retlw	high (HID_INT_OUT_EP_SIZE)	; (high byte)
	retlw	USB_POLLOUT ;0x0A		; Polling interval (10ms)
Endpoint1In
	retlw	(EndConfig1-Endpoint1In)/2	; Size of this descriptor in bytes
	retlw	USB_DESCRIPTOR_ENDPOINT	; ENDPOINT descriptor type
	retlw	HID_EP|_EP_IN	; Endpoint Address
	retlw	_INT		; Attributes
	retlw	low (HID_INT_IN_EP_SIZE)	; Size of the endpoint buffer in bytes (low byte)
	retlw	high (HID_INT_IN_EP_SIZE)	; (high byte)
	retlw	USB_POLLIN 		; Polling interval (10ms)
EndConfig1

ReportDescriptor1
  retlw	0x06		; usage page (Vendor Defined)
	retlw	0xA0
  retlw	0xFF
	retlw	0x09		; usage (Vendor Defined)
  retlw	0x01
	retlw	0xA1		; collection (application)
  retlw	0x01
	retlw	0x09		; usage (Vendor Defined)
  retlw	0x02
	retlw	0xA1		; collection (linked)
  retlw	0x00
	retlw	0x06		; usage page (buttons)
  retlw	0xa1
	retlw	0xFF
	retlw	0x09		; usage vendor defined
  retlw	0x03
	retlw	0x09		; usage vendor defined
  retlw	0x04
	retlw	0x15		; logical minimum (-128)
  retlw	0x80
	retlw	0x25		; logical maximum (127)
  retlw	0x7F
	retlw	0x35		; Physical Minimum (0)
  retlw	0x00
	retlw	0x45		; Physical Maximum (255)
  retlw	0xFF
  retlw	0x75		; report size (8) (bits)
	retlw	0x08
  retlw	0x95		; report count (2) (fields)
	retlw	USB_INSIZE
  retlw	0x81		; input (Data, Variable, Absolute)
	retlw	0x02
  retlw	0x09		; usage (Vendor Defined)
	retlw	0x05
  retlw	0x09		; useage (Vendor Defined)
	retlw	0x06
	retlw	0x15		; logical minimum (-128)
	retlw	0x80
  retlw	0x25		; logical maximum (127)
	retlw	0x7F
  retlw	0x35		; Physical Minimum (0)
	retlw	0x00
  retlw	0x45		; Physical Maximum (255)
	retlw	0xFF
  retlw	0x75		; report size (8) (bits)
	retlw	0x08
  retlw	0x95		; report Count (2) (fields)
	retlw	USB_OUTSIZE
  retlw	0x91		; Output (Data, Variable, Absolute)
	retlw	0x02
	retlw   0xC0		; end collection
	retlw   0xC0		; end collection
EndReportDescriptor1

; String pointer table
USB_SD_Ptr
Strings
	db	low String0, high String0
	db	upper String0, 0
	db	low String1, high String1
	db	upper String1, 0
	db	low String2, high String2
	db	upper String2, 0
	db	low String3, high String3
	db	upper String3, 0

; Language code string descriptor
String0
	retlw   (String0End-String0)/2	; Size of this descriptor in bytes
	retlw   USB_DESCRIPTOR_STRING	; STRING descriptor type
	retlw   0x09		; Language ID as defined by MS - 0x0409 (low byte)
	retlw   0x04		; (high byte)
String0End


	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00332	DoUSBIn:

	LABEL?L	_DoUSBIn	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00333	   if !RX_Rcvd then
	CMPT?TL	_RX_Rcvd, L00001

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00334	       USBIn 1, USBRXBuffer, USBRXBufferCount, NoRX  ' read data, if available
	USBIN?CBBL	001h, _USBRXBuffer, _USBRXBufferCount, _NoRX

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00335	       RX_Rcvd = 1
	MOVE?CT	001h, _RX_Rcvd

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00336	       return
	RETURN?	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00337	   endif
	LABEL?L	L00001	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00338	 NoRX:

	LABEL?L	_NoRX	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00339	return
	RETURN?	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00343	ASM

	ASM?

ON_USBRX_GOSUB  macro label
  local _NotReady, _AlreadyThere


	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00347	    if RX_Rcvd then AlreadyThere    ; If we already have data
	CMPT?TL	_RX_Rcvd, _AlreadyThere

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00348	    if !Plugged then NotReady       ; If USB is connected
	CMPF?TL	_Plugged, _NotReady

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00349	    if !RX_READY then NotReady      ;   and RX data is ready
	CMPF?TL	_RX_READY, _NotReady

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00350	    gosub DoUSBIn                   ;     get the incomming data
	GOSUB?L	_DoUSBIn

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00351	    if !RX_Rcvd then NotReady       
	CMPF?TL	_RX_Rcvd, _NotReady

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00352	AlreadyThere:                       ; if something was received?

	LABEL?L	_AlreadyThere	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00353	@   L?CALL  label                   ;   GOSUB to the RX data handler

	ASM?
   L?CALL  label                   ;   GOSUB to the RX data handler

	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00354	    RX_Rcvd = 0                     ; Done with RX data
	MOVE?CT	000h, _RX_Rcvd

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00355	NotReady:

	LABEL?L	_NotReady	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00356	@  endm

	ASM?
  endm

	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00359	DoUSBOut:

	LABEL?L	_DoUSBOut	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00360	    ASM

	ASM?

        ifdef    USB_TXLED
            LEDON  USB_TXLED
        endif  
    

	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00365	 TXbusy:

	LABEL?L	_TXbusy	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00366	    if Plugged then                               ' try to, transmit data
	CMPF?TL	_Plugged, L00003

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00367	        USBOut 1, USBTXBuffer, USBTXBufferCount, TXbusy 
	USBOUT?CBBL	001h, _USBTXBuffer, _USBTXBufferCount, _TXbusy

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00368	    else
	GOTO?L	L00004
	LABEL?L	L00003	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00371	    endif
	LABEL?L	L00004	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00372	return
	RETURN?	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00376	ClearRXbuffer:

	LABEL?L	_ClearRXbuffer	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00377	    for PRODL = 0 to (USBBufferSizeRX - 1)
	MOVE?CB	000h, PRODL
	LABEL?L	L00005	
	SUB?CCW	USBBufferSizeRX, 001h, T1
	CMPGT?BWL	PRODL, T1, L00006

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00378	        USBRXBuffer(PRODL) = 0
	AIN?CBB	000h, _USBRXBuffer, PRODL

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00379	    next PRODL
	NEXT?BCL	PRODL, 001h, L00005
	LABEL?L	L00006	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00380	return
	RETURN?	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00382	ClearTXbuffer:

	LABEL?L	_ClearTXbuffer	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00383	    for PRODL = 0 to (USBBufferSizeTX - 1)
	MOVE?CB	000h, PRODL
	LABEL?L	L00007	
	SUB?CCW	USBBufferSizeTX, 001h, T1
	CMPGT?BWL	PRODL, T1, L00008

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00384	        USBTXBuffer(PRODL) = 0
	AIN?CBB	000h, _USBTXBuffer, PRODL

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00385	    next PRODL
	NEXT?BCL	PRODL, 001h, L00007
	LABEL?L	L00008	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00386	return
	RETURN?	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00389	ASM

	ASM?

    ifndef USB_VENDORNAME               ; If Vendor name wasn't specified
      #define USB_VENDORNAME  "Darrel Taylor" ;   use this default
    endif
VendorStrBegin                          ; String1, Vendor Name
    DT  USB_VENDORNAME                        
VendorStrEnd
VendorLength = (VendorStrEnd - VendorStrBegin);/ 2

;-------------------------------  
    ifndef USB_PRODUCTNAME              ; If Product name wasn't specified
      #define USB_PRODUCTNAME  "DT_HID" ;   use this default
    endif
ProductStrBegin                         ; String2, Product Name
    DT  USB_PRODUCTNAME                             
ProductStrEnd
ProductLength = (ProductStrEnd - ProductStrBegin);/ 2

;-------------------------------  
    ifndef USB_SERIAL                   ; If Serial number wasn't specified
      #define USB_SERIAL  "SN0001"      ;   use this default
    endif
SerialStrBegin                          ; String3, Serial number
    DT  USB_SERIAL                                   
SerialStrEnd
SerialLength = (SerialStrEnd - SerialStrBegin) ;/ 2

;-------------------------------  
FlashBlockSize = 64               ; Erase 64, Write 32
StringBlockSize = (SerialStrEnd - VendorStrBegin + 6) * 2
StringFlashBlocks = (StringBlockSize + 4) / FlashBlockSize + 1
    if (($ & 0x3F) > 0)           ; Align StringBlock with a "FLASH block"
        ORG (($ >> 6) + 1) << 6
    endif
                                  ; reserve FLASH for strings
String1                           ; is already erased after programming
    ORG  ($ + (VendorLength * 2) + 4)
String2
    ORG  ($ + (ProductLength * 2) + 4)
String3
    ORG  ($ + (SerialLength * 2) + 4)
String4


    ORG (String1 + (FlashBlockSize * StringFlashBlocks)) 
StringsWrittenFlag = $ -2         ; 0FFFFh means hasn't been written                     
                             


	ENDASM?

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00439	StringsWrittenFlag  CON EXT
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00440	VendorStrBegin      CON EXT
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00441	VendorStrEnd        CON EXT
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00442	VendorLength        CON EXT
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00443	ProductStrBegin     CON EXT
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00444	ProductStrEnd       CON EXT
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00445	ProductLength       CON EXT
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00446	SerialStrBegin      CON EXT
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00447	SerialStrEnd        CON EXT
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00448	SerialLength        CON EXT
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00449	USB_DESCRIPTOR_STRING  CON EXT
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00450	String1             CON EXT
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00451	String2             CON EXT
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00452	String3             CON EXT
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00453	String4             CON EXT

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00464	STR_CODE:

	LABEL?L	_STR_CODE	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00465	    for Str_Loop = 0 to Str_Length step 2
	MOVE?CB	000h, _Str_Loop
	LABEL?L	L00009	
	CMPGT?BBL	_Str_Loop, _Str_Length, L00010

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00466	        READCODE ReadAdd, Str_TempWord
	READCODE?WW	_ReadAdd, _Str_TempWord

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00467	        ReadAdd = ReadAdd + 2
	ADD?WCW	_ReadAdd, 002h, _ReadAdd

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00468	        WriteCode  FlashAdd, Str_TempWord
	WRITECODE?WW	_FlashAdd, _Str_TempWord

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00469	        FlashAdd = FlashAdd + 2
	ADD?WCW	_FlashAdd, 002h, _FlashAdd

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00470	        WriteCode  FlashAdd, $0C00
	WRITECODE?WC	_FlashAdd, 00C00h

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00471	        FlashAdd = FlashAdd + 2
	ADD?WCW	_FlashAdd, 002h, _FlashAdd

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00472	    next Str_Loop
	NEXT?BCL	_Str_Loop, 002h, L00009
	LABEL?L	L00010	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00474	return
	RETURN?	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00476	ASM

	ASM?

MakeString  macro FromAddr, Length
    MOVE?CW  FromAddr, _ReadAdd
    MOVE?CW  Length, _Str_Length
    L?CALL   _STR_CODE       
  endm


	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00484	MakeStrings:

	LABEL?L	_MakeStrings	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00485	    READCODE  StringsWrittenFlag, Str_TempWord
	READCODE?CW	StringsWrittenFlag, _Str_TempWord

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00486	    IF (Str_TempWord & $FF) = $FF then
	AND?WCW	_Str_TempWord, 0FFh, T1
	CMPNE?WCL	T1, 0FFh, L00011

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00487	        GIEsave = INTCON.7
	MOVE?TT	_INTCON??7, _GIEsave

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00488	        INTCON.7 = 0
	MOVE?CT	000h, _INTCON??7

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00489	        FlashAdd = String1
	MOVE?CW	String1, _FlashAdd

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00490	        WriteCode  FlashAdd, ($0C00 | (VendorLength + 2))
	ADD?CCW	VendorLength, 002h, T1
	OR?CWW	00C00h, T1, T1
	WRITECODE?WW	_FlashAdd, T1

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00491	        FlashAdd = FlashAdd + 2
	ADD?WCW	_FlashAdd, 002h, _FlashAdd

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00492	        WriteCode  FlashAdd, ($0C00 | USB_DESCRIPTOR_STRING)
	OR?CCW	00C00h, USB_DESCRIPTOR_STRING, T1
	WRITECODE?WW	_FlashAdd, T1

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00493	        FlashAdd = FlashAdd + 2
	ADD?WCW	_FlashAdd, 002h, _FlashAdd

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00494	        @ MakeString  VendorStrBegin, VendorLength

	ASM?
 MakeString  VendorStrBegin, VendorLength

	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00496	        FlashAdd = String2
	MOVE?CW	String2, _FlashAdd

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00497	        WriteCode  FlashAdd, ($0C00 | (ProductLength + 2))
	ADD?CCW	ProductLength, 002h, T1
	OR?CWW	00C00h, T1, T1
	WRITECODE?WW	_FlashAdd, T1

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00498	        FlashAdd = FlashAdd + 2
	ADD?WCW	_FlashAdd, 002h, _FlashAdd

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00499	        WriteCode  FlashAdd, ($0C00 | USB_DESCRIPTOR_STRING)
	OR?CCW	00C00h, USB_DESCRIPTOR_STRING, T1
	WRITECODE?WW	_FlashAdd, T1

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00500	        FlashAdd = FlashAdd + 2
	ADD?WCW	_FlashAdd, 002h, _FlashAdd

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00501	        @ MakeString  ProductStrBegin, ProductLength

	ASM?
 MakeString  ProductStrBegin, ProductLength

	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00503	        FlashAdd = String3
	MOVE?CW	String3, _FlashAdd

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00504	        WriteCode  FlashAdd, ($0C00 | (SerialLength + 2))
	ADD?CCW	SerialLength, 002h, T1
	OR?CWW	00C00h, T1, T1
	WRITECODE?WW	_FlashAdd, T1

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00505	        FlashAdd = FlashAdd + 2
	ADD?WCW	_FlashAdd, 002h, _FlashAdd

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00506	        WriteCode  FlashAdd, ($0C00 | USB_DESCRIPTOR_STRING)
	OR?CCW	00C00h, USB_DESCRIPTOR_STRING, T1
	WRITECODE?WW	_FlashAdd, T1

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00507	        FlashAdd = FlashAdd + 2
	ADD?WCW	_FlashAdd, 002h, _FlashAdd

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00508	        @ MakeString  SerialStrBegin, SerialLength

	ASM?
 MakeString  SerialStrBegin, SerialLength

	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00510	        repeat
	LABEL?L	L00013	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00511	            Str_TempWord = 0
	MOVE?CW	000h, _Str_TempWord

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00512	            WriteCode  FlashAdd, Str_TempWord
	WRITECODE?WW	_FlashAdd, _Str_TempWord

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00513	            FlashAdd = FlashAdd + 2
	ADD?WCW	_FlashAdd, 002h, _FlashAdd

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00514	        until FlashAdd >= StringsWrittenFlag            ; * combine with next writecode
	CMPLT?WCL	_FlashAdd, StringsWrittenFlag, L00013
	LABEL?L	L00014	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00516	        WriteCode  StringsWrittenFlag, Str_TempWord     ; * add to previous loop
	WRITECODE?CW	StringsWrittenFlag, _Str_TempWord

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00518	        INTCON.7 = GIEsave
	MOVE?TT	_GIEsave, _INTCON??7

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00519	    endif
	LABEL?L	L00011	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00520	return
	RETURN?	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00523	@  ifdef DoesNotCompile 

	ASM?
  ifdef DoesNotCompile 

	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00524	      INPUT  R0.0
	INPUT?T	_R0??0

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00525	      OUTPUT R0.0
	OUTPUT?T	_R0??0

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00526	      LOW    R0.0
	LOW?T	_R0??0

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00527	      HIGH   R0.0
	HIGH?T	_R0??0

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00528	@  endif

	ASM?
  endif

	ENDASM?

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00533	CONFIGURED_STATE   CON EXT

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00535	DoUSBService:

	LABEL?L	_DoUSBService	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00536	    INTS_FROM = INTS_FROM | UIR
	OR?BBB	INTS_FROM, UIR, INTS_FROM

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00537	ASM

	ASM?

   ifdef USB_ServiceLED
     LEDON  USB_ServiceLED
   endif


	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00542	    IF IDLEIF THEN
	CMPF?TL	_IDLEIF, L00015

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00543	        Plugged = 0
	MOVE?CT	000h, _Plugged

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00544	    endif
	LABEL?L	L00015	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00545	    IF SOFIF  THEN
	CMPF?TL	_SOFIF, L00017

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00546	        IF (USBDeviceState = CONFIGURED_STATE) THEN
	CMPNE?BCL	USBDeviceState, CONFIGURED_STATE, L00019

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00547	            Plugged = 1
	MOVE?CT	001h, _Plugged

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00548	        endif
	LABEL?L	L00019	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00549	    endif
	LABEL?L	L00017	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00550	    usbservice
	USBSERVICE?	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00552	    if !Plugged then UEIR = 0        ; prevents lock-ups when not terminated
	CMPT?TL	_Plugged, L00021
	MOVE?CB	000h, UEIR
	LABEL?L	L00021	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00554	asm

	ASM?

#define Addr(port,bit) port
;---- USB Plugged LED -----------------------------
    ifdef USB_PLUGGEDLED                     ; if plugged LED was defined
        ifLEDisOFF   USB_PLUGGEDLED, PlugLED_IsOFF ;   and the LED is ON
        banksel  Addr(_Plugged)                
        btfsc    _Plugged                    ;   and USB is NOT plugged in
        goto     PluggedLED_Done
        LEDOFF   USB_PLUGGEDLED             ;      then turn LED OFF
        goto     PluggedLED_Done
PlugLED_IsOFF
        banksel  Addr(_Plugged)                
        btfss    _Plugged                    ;   and USB IS plugged in
        goto     PluggedLED_Done
        LEDON    USB_PLUGGEDLED             ;      then turn LED ON
PluggedLED_Done
    endif
;---- USB Transmit LED ----------------------------
    ifdef USB_TXLED                          ; if the TX LED was defined
        ifLEDisOFF   USB_TXLED, TXLED_IsOFF  ;   and the LED is ON
        banksel  Addr(_TXOWNED)                
        btfsc    _TXOWNED                    ;      and CPU Owns the buffer
        goto     TXLED_Done
        LEDOFF   USB_TXLED                   ;         then turn LED OFF
        goto     TXLED_Done
TXLED_IsOFF                                  ;   The LED is OFF
        banksel  Addr(_TXOWNED)                
        btfss    _TXOWNED                    ;      and SIE Owns the buffer
        goto     TXLED_Done
        LEDON    USB_TXLED                   ;         then turn LED ON
TXLED_Done
        banksel  0
    endif
;---- USB Receive LED -----------------------------
    ifdef USB_RXLED                          ; if the TX LED was defined
        ifLEDisOFF   USB_RXLED, RXLED_IsOFF  ;   and the LED is ON
        banksel  Addr(_RXOWNED)                
        btfss    _RXOWNED                    ;      and SIE Owns the buffer
        goto     RXLED_Done
        LEDOFF   USB_RXLED                   ;         then turn LED OFF
        goto     RXLED_Done
RXLED_IsOFF                                  ;   The LED is OFF
        banksel  Addr(_RXOWNED)                
        btfsc    _RXOWNED                    ;      and CPU Owns the buffer
        goto     RXLED_Done
        LEDON    USB_RXLED                   ;         then turn LED ON
RXLED_Done
        banksel  0
    endif

   ifdef USB_ServiceLED
     LEDOFF USB_ServiceLED
   endif 


	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00608	    RX_READY = !RXOWNED
	LNOT?TT	_RXOWNED, _RX_READY

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00609	    TX_READY = !TXOWNED
	LNOT?TT	_TXOWNED, _TX_READY

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00610	@   INT_RETURN

	ASM?
   INT_RETURN

	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00613	Over_DT_HID:

	LABEL?L	_Over_DT_HID	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\DT_HID260.PBP	00615	enable debug
	DENABLE?	
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00030	DEFINE USB_VENDORID    6017
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00031	DEFINE USB_PRODUCTID   2000
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00032	DEFINE USB_VERSION     1
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00033	DEFINE USB_VENDORNAME  "Hugo Oliveira"
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00034	DEFINE USB_PRODUCTNAME "Demo USB"
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00035	DEFINE USB_SERIAL      "001Hugo"
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00036	DEFINE USB_INSIZE      8    ;  IN report is PIC to PC (8,16,32,64)
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00037	DEFINE USB_OUTSIZE     8    ; OUT report is PC to PIC
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00038	DEFINE USB_POLLIN      10   ; Polling times in mS, MIN=1 MAX=10
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00039	DEFINE USB_POLLOUT     10
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00042	DEFINE USB_LEDPOLARITY 1       ; LED ON State [0 or 1]  (default = 1)
; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00056	DEFINE ADC_BITS 8  ; Number of bits in ADCIN result

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00058	CCPR1L = 0
	MOVE?CB	000h, CCPR1L

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00059	CCPR2L = 0
	MOVE?CB	000h, CCPR2L

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00060	CCP1CON =   %00001100       ' CCP1, PWM mode
	MOVE?CB	00Ch, CCP1CON

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00061	CCP2CON =   %00001100       ' CCP2, PWM mode
	MOVE?CB	00Ch, CCP2CON

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00062	PR2     =   249             ' 0-1000 duty range
	MOVE?CB	0F9h, PR2

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00063	T2CON   =   %00000101       ' TMR2 on, prescaler 1:4
	MOVE?CB	005h, T2CON

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00064	TRISB = 0
	MOVE?CB	000h, TRISB

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00065	OUTPUT PORTC.1
	OUTPUT?T	_PORTC??1

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00066	OUTPUT PORTC.2
	OUTPUT?T	_PORTC??2

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00068	ADCON2.7 = 0       ; left justify    (Change this if ADFM in diff register)
	MOVE?CT	000h, _ADCON2??7

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00069	ADCON1 = %1101     ; AN0/AN1 Analog
	MOVE?CB	00Dh, ADCON1

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00071	Main:

	LABEL?L	_Main	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00072	    FOR X = 0 to 1000           ; Check for incomming USB data while waiting
	MOVE?CW	000h, _X
	LABEL?L	L00023	
	CMPGT?WCL	_X, 003E8h, L00024

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00073	@       ON_USBRX_GOSUB  _HandleRX

	ASM?
       ON_USBRX_GOSUB  _HandleRX

	ENDASM?


; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00074	        PAUSE 1
	PAUSE?C	001h

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00076	        New_PORTA = PORTA                ; Check PORTA pins
	MOVE?BB	PORTA, _New_PORTA

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00077	        IF New_PORTA != Old_PORTA THEN
	CMPEQ?BBL	_New_PORTA, _Old_PORTA, L00025

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00078	            Old_PORTA = New_PORTA
	MOVE?BB	_New_PORTA, _Old_PORTA

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00079	            ARRAYWRITE USBTXBuffer, ["HugoDem1"]
	ARRAYWRITENAME?B	_USBTXBuffer
	ARRAYWRITE?C	048h
	ARRAYWRITE?C	075h
	ARRAYWRITE?C	067h
	ARRAYWRITE?C	06Fh
	ARRAYWRITE?C	044h
	ARRAYWRITE?C	065h
	ARRAYWRITE?C	06Dh
	ARRAYWRITE?C	031h

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00080	            GOSUB WaitToSend
	GOSUB?L	_WaitToSend

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00082	                                     PORTA.3, PORTA.4, PORTA.5,0,0]
	ARRAYWRITENAME?B	_USBTXBuffer
	ARRAYWRITE?W	_Value0
	ARRAYWRITE?W	_Value1
	ARRAYWRITE?T	_PORTA??2
	ARRAYWRITE?T	_PORTA??3
	ARRAYWRITE?T	_PORTA??4
	ARRAYWRITE?T	_PORTA??5
	ARRAYWRITE?C	000h
	ARRAYWRITE?C	000h

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00083	            GOSUB WaitToSend
	GOSUB?L	_WaitToSend

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00084	        ENDIF
	LABEL?L	L00025	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00085	    NEXT X
	NEXT?WCL	_X, 001h, L00023
	LABEL?L	L00024	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00087	    ADCIN 0, Value0            ; Send A/D about once/sec
	ADCIN?CW	000h, _Value0

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00088	    ADCIN 1, Value1
	ADCIN?CW	001h, _Value1

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00090	                             PORTA.3, PORTA.4, PORTA.5,0,0]
	ARRAYWRITENAME?B	_USBTXBuffer
	ARRAYWRITE?W	_Value0
	ARRAYWRITE?W	_Value1
	ARRAYWRITE?T	_PORTA??2
	ARRAYWRITE?T	_PORTA??3
	ARRAYWRITE?T	_PORTA??4
	ARRAYWRITE?T	_PORTA??5
	ARRAYWRITE?C	000h
	ARRAYWRITE?C	000h

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00091	    GOSUB SendIfReady
	GOSUB?L	_SendIfReady

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00092	GOTO Main
	GOTO?L	_Main

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00094	SendIfReady:

	LABEL?L	_SendIfReady	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00095	    IF Plugged AND TX_READY THEN DoUSBOut
	LAND?TTL	_Plugged, _TX_READY, _DoUSBOut

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00096	RETURN
	RETURN?	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00098	WaitToSend:

	LABEL?L	_WaitToSend	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00099	    WHILE Plugged and !TX_READY : WEND
	LABEL?L	L00027	
	LNOT?TB	_TX_READY, T1
	LAND?TBW	_Plugged, T1, T1
	CMPF?WL	T1, L00028

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00099	    WHILE Plugged and !TX_READY : WEND
	GOTO?L	L00027
	LABEL?L	L00028	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00100	    IF TX_READY THEN GOSUB DoUSBOut
	CMPF?TL	_TX_READY, L00029
	GOSUB?L	_DoUSBOut
	LABEL?L	L00029	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00101	RETURN
	RETURN?	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00103	HandleRX:

	LABEL?L	_HandleRX	

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00105	                                    DUTY2.LowByte, DUTY2.HighByte]
	ARRAYREADNAME?B	_USBRXBuffer
	ARRAYREAD?B	PORTB
	ARRAYREAD?B	_DUTY1??LOWBYTE
	ARRAYREAD?B	_DUTY1??HIGHBYTE
	ARRAYREAD?B	_DUTY2??LOWBYTE
	ARRAYREAD?B	_DUTY2??HIGHBYTE

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00106	    CCP1CON.5=DUTY1.1       ' load CCP1 duty value            
	MOVE?TT	_DUTY1??1, _CCP1CON??5

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00107	    CCP1CON.4=DUTY1.0       '      with Duty1 
	MOVE?TT	_DUTY1??0, _CCP1CON??4

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00108	    CCPR1L=DUTY1>>2         '
	SHIFTR?WCB	_DUTY1, 002h, CCPR1L

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00110	    CCP2CON.5=DUTY2.1       ' load CCP2 duty value            
	MOVE?TT	_DUTY2??1, _CCP2CON??5

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00111	    CCP2CON.4=DUTY2.0       '      with Duty2
	MOVE?TT	_DUTY2??0, _CCP2CON??4

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00112	    CCPR2L=DUTY2>>2         '
	SHIFTR?WCB	_DUTY2, 002h, CCPR2L

; C:\PIC\MEL\PBP3061\18F4550\USB\PICUSB\PICUSB.PBP	00113	return
	RETURN?	

	END
