
; PicBasic Pro Compiler , (c) 1998, 2004 microEngineering Labs, Inc. All Rights Reserved.  
PM_USED			EQU	1

	INCLUDE	"16F628A.INC"


; Define statements.
#define		HSER_RCSTA		       90h                  
#define		HSER_TXSTA		       24h                  
#define		HSER_BAUD		        9600                 
#define		I2C_SLOW		 1
#define		I2C_SCLOUT		 1

RAM_START       		EQU	00020h
RAM_END         		EQU	0014Fh
RAM_BANKS       		EQU	00003h
BANK0_START     		EQU	00020h
BANK0_END       		EQU	0007Fh
BANK1_START     		EQU	000A0h
BANK1_END       		EQU	000EFh
BANK2_START     		EQU	00120h
BANK2_END       		EQU	0014Fh
EEPROM_START    		EQU	02100h
EEPROM_END      		EQU	0217Fh

R0              		EQU	RAM_START + 000h
R1              		EQU	RAM_START + 002h
R2              		EQU	RAM_START + 004h
R3              		EQU	RAM_START + 006h
R4              		EQU	RAM_START + 008h
R5              		EQU	RAM_START + 00Ah
R6              		EQU	RAM_START + 00Ch
R7              		EQU	RAM_START + 00Eh
R8              		EQU	RAM_START + 010h
T1              		EQU	RAM_START + 012h
FLAGS           		EQU	RAM_START + 014h
GOP             		EQU	RAM_START + 015h
RM1             		EQU	RAM_START + 016h
RM2             		EQU	RAM_START + 017h
RR1             		EQU	RAM_START + 018h
RR2             		EQU	RAM_START + 019h
_MagData         		EQU	RAM_START + 01Ah
_addr            		EQU	RAM_START + 042h
_CounterA        		EQU	RAM_START + 044h
_CounterB        		EQU	RAM_START + 045h
_CounterC        		EQU	RAM_START + 046h
_CounterD        		EQU	RAM_START + 047h
_data_array      		EQU	RAM_START + 048h
_i               		EQU	RAM_START + 049h
_MagError        		EQU	RAM_START + 04Ah
_PORTL           		EQU	 PORTB
_PORTH           		EQU	 PORTA
_TRISL           		EQU	 TRISB
_TRISH           		EQU	 TRISA
#define _MagRDA          	_PORTB_5
#define _MagCLK          	_PORTB_6
#define _MagCIN          	_PORTB_7
#define _GreenLED        	_PORTA_4
#define _SCL             	_PORTA_0
#define _SDA             	_PORTA_1
#define _PORTB_5         	 PORTB, 005h
#define _PORTB_6         	 PORTB, 006h
#define _PORTB_7         	 PORTB, 007h
#define _PORTA_4         	 PORTA, 004h
#define _PORTA_0         	 PORTA, 000h
#define _PORTA_1         	 PORTA, 001h
#define _OPTION_REG_7    	 OPTION_REG, 007h
#define _MagError_7      	_MagError, 007h
#define _CounterD_4      	_CounterD, 004h
#define _MagError_3      	_MagError, 003h
#define _MagError_1      	_MagError, 001h
#define _MagError_4      	_MagError, 004h
#define _MagError_0      	_MagError, 000h
#define _MagError_2      	_MagError, 002h

; Constants.
_MagMax          		EQU	00028h
	INCLUDE	"CARD.MAC"
	INCLUDE	"PBPPIC14.LIB"


	ASM?
 DEVICE pic16F628a, XT_OSC       

	ENDASM?


	ASM?
 DEVICE pic16F628a, WDT_ON       

	ENDASM?


	ASM?
 DEVICE pic16F628a, PWRT_ON      

	ENDASM?


	ASM?
 DEVICE pic16F628a, BOD_ON       

	ENDASM?


	ASM?
 DEVICE pic16F628a, MCLR_ON      

	ENDASM?


	ASM?
 DEVICE pic16F628a, LVP_OFF      

	ENDASM?


	ASM?
 DEVICE pic16F628a, CPD_OFF      

	ENDASM?


	ASM?
 DEVICE pic16F628a, PROTECT_OFF  

	ENDASM?

	GOTO?L	_JumpStart

	LABEL?L	_JumpStart	
	MOVE?CB	007h, CMCON
	MOVE?CB	000h, TRISA
	MOVE?CB	0FFh, TRISB
	MOVE?CT	000h, _OPTION_REG_7
	PAUSE?C	0FAh

	LABEL?L	_ReadReadyLoop	
	MOVE?CB	000h, _CounterA
	LABEL?L	L00001	
	CMPGT?BCL	_CounterA, 027h, L00002
	AIN?CBB	000h, _MagData, _CounterA
	NEXT?BCL	_CounterA, 001h, L00001
	LABEL?L	L00002	
	LOW?T	_GreenLED
	LABEL?L	L00003	
	CMPNE?TCL	_MagCIN, 001h, L00004
	GOTO?L	L00003
	LABEL?L	L00004	
	HIGH?T	_GreenLED
	MOVE?CB	000h, _CounterB
	MOVE?CB	000h, _CounterC
	MOVE?CB	018h, _MagError

	LABEL?L	_MagReadByteLoop	
	MOVE?CB	000h, _CounterA
	MOVE?CB	000h, _CounterD
	MOVE?CT	000h, _MagError_7

	LABEL?L	_MagReadBitLoop	
	CMPNE?TCL	_MagCIN, 001h, L00005
	GOTO?L	_MagReadErrorCheck
	LABEL?L	L00005	
	CMPNE?TCL	_MagCLK, 001h, L00007
	GOTO?L	_MagReadBitLoop
	LABEL?L	L00007	
	XOR?TCT	_MagRDA, 001h, _CounterD_4
	XOR?TTT	_MagError_7, _CounterD_4, _MagError_7
	ADD?BCB	_CounterA, 001h, _CounterA
	CMPGE?BCL	_CounterA, 005h, L00009
	SHIFTR?BCB	_CounterD, 001h, _CounterD
	LABEL?L	L00011	
	CMPNE?TCL	_MagCLK, 000h, L00012
	GOTO?L	L00011
	LABEL?L	L00012	
	GOTO?L	_MagReadBitLoop
	LABEL?L	L00009	
	CMPNE?TCL	_MagError_3, 001h, L00013
	CMPNE?BCL	_CounterD, 00Bh, L00015
	MOVE?CT	000h, _MagError_3
	GOTO?L	L00016
	LABEL?L	L00015	
	SUB?BCB	_CounterA, 001h, _CounterA
	SHIFTR?BCB	_CounterD, 001h, _CounterD
	LABEL?L	L00017	
	CMPNE?TCL	_MagCLK, 000h, L00018
	GOTO?L	L00017
	LABEL?L	L00018	
	GOTO?L	_MagReadBitLoop
	LABEL?L	L00016	
	LABEL?L	L00013	
	CMPEQ?TCL	_MagError_7, 001h, L00019
	MOVE?CT	001h, _MagError_1
	LABEL?L	L00019	
	AIN?BBB	_CounterD, _MagData, _CounterB
	XOR?BBB	_CounterC, _CounterD, _CounterC
	ADD?BCB	_CounterB, 001h, _CounterB
	CMPNE?TCL	_MagError_4, 000h, L00021
	AND?BCW	_CounterC, 00Fh, T1
	CMPEQ?WCL	T1, 000h, L00023
	MOVE?CT	001h, _MagError_0
	LABEL?L	L00023	
	GOTO?L	_MagReadErrorCheck
	LABEL?L	L00021	
	CMPNE?BCL	_CounterD, 01Fh, L00025
	MOVE?CT	000h, _MagError_4
	LABEL?L	L00025	
	CMPLT?BCL	_CounterB, _MagMax, L00027
	MOVE?CT	001h, _MagError_2
	GOTO?L	_MagReadErrorCheck
	LABEL?L	L00027	
	LABEL?L	L00029	
	CMPNE?TCL	_MagCLK, 000h, L00030
	GOTO?L	L00029
	LABEL?L	L00030	
	GOTO?L	_MagReadByteLoop

	LABEL?L	_MagReadErrorCheck	
	MOVE?CT	000h, _MagError_7
	CMPEQ?BCL	_MagError, 000h, L00031
	MOVE?CB	001h, _CounterA
	LABEL?L	L00033	
	CMPGT?BCL	_CounterA, 00Ah, L00034
	LOW?T	_GreenLED
	PAUSE?C	032h
	HIGH?T	_GreenLED
	PAUSE?C	032h
	NEXT?BCL	_CounterA, 001h, L00033
	LABEL?L	L00034	
	GOTO?L	L00032
	LABEL?L	L00031	
	PAUSE?C	001F4h
	LOW?T	_GreenLED
	PAUSE?C	001F4h
	HIGH?T	_GreenLED
	LABEL?L	L00032	
	MOVE?CW	000h, _addr
	LABEL?L	L00035	
	CMPGT?WCL	_addr, 0FFFFh, L00036
	I2CDATA?T	_SDA
	I2CCLOCK?T	_SCL
	I2CWRITE?C	0A0h
	I2CWRITE?W	_addr
	I2CCOUNT?C	040h
	I2CWRITESTRS?B	_MagData
	HSEROUT?C	02Eh
	PAUSE?C	00Ah
	NEXT?WCL	_addr, 040h, L00035
	LABEL?L	L00036	
	MOVE?CB	000h, _i
	HSEROUT?C	00Ah
	HSEROUT?C	00Dh
	HSEROUT?C	00Ah
	HSEROUT?C	00Dh
	HSEROUT?C	063h
	HSEROUT?C	068h
	HSEROUT?C	065h
	HSEROUT?C	063h
	HSEROUT?C	06Bh
	HSEROUT?C	069h
	HSEROUT?C	06Eh
	HSEROUT?C	067h
	HSEROUT?C	00Ah
	HSEROUT?C	00Dh
	MOVE?CW	000h, _addr
	LABEL?L	L00037	
	CMPGT?WCL	_addr, 0FFFFh, L00038
	ADD?BCB	_i, 001h, _i
	I2CDATA?T	_SDA
	I2CCLOCK?T	_SCL
	I2CWRITE?C	0A0h
	I2CWRITE?W	_addr
	I2CREADS?B	_data_array
	HSEROUTCOUNT?C	002h
	HSEROUTNUM?B	_data_array
	HSEROUTHEX?	
	HSEROUT?C	020h
	AND?BCW	_i, 007h, T1
	CMPNE?WCL	T1, 000h, L00039
	HSEROUT?C	00Ah
	HSEROUT?C	00Dh
	LABEL?L	L00039	
	NEXT?WCL	_addr, 00101h, L00037
	LABEL?L	L00038	
	PAUSE?C	003E8h
	GOTO?L	_ReadReadyLoop
	END?	

	END
