
; PICBASIC PRO(TM) Compiler 3.0.5.4, (c) 1998, 2012 microEngineering Labs, Inc. All Rights Reserved. 
MPASMWIN_USED			EQU	1

#define	PBP_PATH	C:\PBP3\




        NOLIST
    ifdef PM_USED
        LIST
        "Error: PM does not support this device.  Use MPASM."
        NOLIST
    else
        LIST
        LIST p = 18F2550, r = dec, w = -311, w = -230, f = inhx32
        INCLUDE "P18F2550.INC"	; MPASM  Header
        NOLIST
    endif
        LIST
EEPROM_START	EQU	0F00000h
BLOCK_SIZE	EQU	32


PBP_HARDWAREDEF  macro
  endm


    __CONFIG    _CONFIG1L, _PLLDIV_5_1L & _CPUDIV_OSC1_PLL2_1L & _USBDIV_2_1L
    __CONFIG    _CONFIG1H, _FOSC_HSPLL_HS_1H & _FCMEN_OFF_1H & _IESO_OFF_1H
    __CONFIG    _CONFIG2L, _PWRT_OFF_2L & _BOR_ON_2L & _BORV_3_2L & _VREGEN_ON_2L
    __CONFIG    _CONFIG2H, _WDT_ON_2H & _WDTPS_512_2H
    __CONFIG    _CONFIG3H, _CCP2MX_ON_3H & _PBADEN_OFF_3H & _LPT1OSC_OFF_3H & _MCLRE_OFF_3H
    __CONFIG    _CONFIG4L, _STVREN_ON_4L & _LVP_OFF_4L & _XINST_OFF_4L



; Define statements.
; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00001	DEFINE OSC 48
#define		OSC		 48
; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00013	DEFINE LCD_DREG  PORTB                            ; LCD Data port
#define		LCD_DREG		  PORTB                            ; LCD Data port
; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00014	DEFINE LCD_DBIT  4                                ; starting Data bit (0 or 4)
#define		LCD_DBIT		  4                                ; starting Data bit (0 or 4)
; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00015	DEFINE LCD_EREG  PORTB                            ; LCD Enable port
#define		LCD_EREG		  PORTB                            ; LCD Enable port
; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00016	DEFINE LCD_EBIT  2                                ;     Enable bit
#define		LCD_EBIT		  2                                ;     Enable bit
; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00017	DEFINE LCD_RSREG PORTB                            ; LCD Register Select port
#define		LCD_RSREG		 PORTB                            ; LCD Register Select port
; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00018	DEFINE LCD_RSBIT 1                                ;     Register Select bit
#define		LCD_RSBIT		 1                                ;     Register Select bit
; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00019	DEFINE LCD_BITS  4                                ; LCD bus size (4 or 8 bits)
#define		LCD_BITS		  4                                ; LCD bus size (4 or 8 bits)
; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00020	DEFINE LCD_LINES 2                                ; number of lines on LCD
#define		LCD_LINES		 2                                ; number of lines on LCD
; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00021	DEFINE LCD_COMMANDUS 2000                         ; Command delay time in us 
#define		LCD_COMMANDUS		 2000                         ; Command delay time in us 
; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00022	DEFINE LCD_DATAUS 50                              ; Data delay time in us 
#define		LCD_DATAUS		 50                              ; Data delay time in us 

RAM_START       		EQU	00000h
RAM_END         		EQU	007FFh
RAM_BANKS       		EQU	00008h
BANK0_START     		EQU	00060h
BANK0_END       		EQU	000FFh
BANK1_START     		EQU	00100h
BANK1_END       		EQU	001FFh
BANK2_START     		EQU	00200h
BANK2_END       		EQU	002FFh
BANK3_START     		EQU	00300h
BANK3_END       		EQU	003FFh
BANK4_START     		EQU	00400h
BANK4_END       		EQU	004FFh
BANK5_START     		EQU	00500h
BANK5_END       		EQU	005FFh
BANK6_START     		EQU	00600h
BANK6_END       		EQU	006FFh
BANK7_START     		EQU	00700h
BANK7_END       		EQU	007FFh
BANKA_START     		EQU	00000h
BANKA_END       		EQU	0005Fh

; C:\PBP3\PBPPIC18.RAM     	00028	A00000	FLAGS   VAR     BYTE BANKA SYSTEM       ' Static flags
FLAGS           		EQU	RAM_START + 000h
; C:\PBP3\PBPPIC18.RAM     	00027	A00001	GOP     VAR     BYTE BANKA SYSTEM       ' Gen Op Parameter
GOP             		EQU	RAM_START + 001h
; C:\PBP3\PBPPIC18.RAM     	00012	A00002	R0      VAR     WORD BANKA SYSTEM       ' System Register
R0              		EQU	RAM_START + 002h
; C:\PBP3\PBPPIC18.RAM     	00013	A00004	R1      VAR     WORD BANKA SYSTEM       ' System Register
R1              		EQU	RAM_START + 004h
; C:\PBP3\PBPPIC18.RAM     	00014	A00006	R2      VAR     WORD BANKA SYSTEM       ' System Register
R2              		EQU	RAM_START + 006h
; C:\PBP3\PBPPIC18.RAM     	00015	A00008	R3      VAR     WORD BANKA SYSTEM       ' System Register
R3              		EQU	RAM_START + 008h
; C:\PBP3\PBPPIC18.RAM     	00016	A0000A	R4      VAR     WORD BANKA SYSTEM       ' System Register
R4              		EQU	RAM_START + 00Ah
; C:\PBP3\PBPPIC18.RAM     	00017	A0000C	R5      VAR     WORD BANKA SYSTEM       ' System Register
R5              		EQU	RAM_START + 00Ch
; C:\PBP3\PBPPIC18.RAM     	00018	A0000E	R6      VAR     WORD BANKA SYSTEM       ' System Register
R6              		EQU	RAM_START + 00Eh
; C:\PBP3\PBPPIC18.RAM     	00019	A00010	R7      VAR     WORD BANKA SYSTEM       ' System Register
R7              		EQU	RAM_START + 010h
; C:\PBP3\PBPPIC18.RAM     	00020	A00012	R8      VAR     WORD BANKA SYSTEM       ' System Register
R8              		EQU	RAM_START + 012h
; C:\PBP3\PBPPIC18.RAM     	00023	A00014	RM1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Mask
RM1             		EQU	RAM_START + 014h
; C:\PBP3\PBPPIC18.RAM     	00026	A00015	RM2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Mask
RM2             		EQU	RAM_START + 015h
; C:\PBP3\PBPPIC18.RAM     	00021	A00016	RR1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Register
RR1             		EQU	RAM_START + 016h
; C:\PBP3\PBPPIC18.RAM     	00024	A00017	RR2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Register
RR2             		EQU	RAM_START + 017h
; C:\PBP3\PBPPIC18.RAM     	00022	A00018	RS1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Bank
RS1             		EQU	RAM_START + 018h
; C:\PBP3\PBPPIC18.RAM     	00025	A00019	RS2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Bank
RS2             		EQU	RAM_START + 019h
; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00031	A0001A	TempC       VAR WORD
_TempC           		EQU	RAM_START + 01Ah
; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00030	A0001C	ConfigReg   VAR BYTE                              
_ConfigReg       		EQU	RAM_START + 01Ch
; C:\PBP3\DEVICES\PIC18F2550.PBPINC	00259	PORTL   VAR     PORTB
_PORTL           		EQU	 PORTB
; C:\PBP3\DEVICES\PIC18F2550.PBPINC	00260	PORTH   VAR     PORTC
_PORTH           		EQU	 PORTC
; C:\PBP3\DEVICES\PIC18F2550.PBPINC	00261	TRISL   VAR     TRISB
_TRISL           		EQU	 TRISB
; C:\PBP3\DEVICES\PIC18F2550.PBPINC	00262	TRISH   VAR     TRISC
_TRISH           		EQU	 TRISC
_TempC??LOWBYTE  		EQU	_TempC
_TempC??HIGHBYTE 		EQU	_TempC + 001h
#define _SCL             	_PORTA??2
#define _SDA             	_PORTA??3
#define _PORTA??2        	 PORTA, 002h
#define _PORTA??3        	 PORTA, 003h
#define _ConfigReg??0    	_ConfigReg, 000h
#define _TempC??7        	_TempC, 007h
#define _ConfigReg??4    	_ConfigReg, 004h

; Constants.
_USBMEMORYADDRESS		EQU	00400h
_TempHigh        		EQU	0001Ch
_TempLow         		EQU	00018h
_DS1621          		EQU	00090h

; EEPROM data.


	INCLUDE	"DS1621_2550.MAC"
	INCLUDE	"C:\PBP3\PBPPIC18.LIB"


; C:\PBP3\DEVICES\PIC18F2550.PBPINC	00036	Z00002	#HEADER
Z00002
; C:\PBP3\DEVICES\PIC18F2550.PBPINC	00062	Z00003	#CONFIG
Z00003
; C:\PBP3\DEVICES\PIC18F2550.PBPINC	00240	Z00004	BANKA   $0000, $005F
Z00004
; C:\PBP3\DEVICES\PIC18F2550.PBPINC	00241	Z00005	BANK0   $0060, $00FF
Z00005
; C:\PBP3\DEVICES\PIC18F2550.PBPINC	00242	Z00006	BANK1   $0100, $01FF
Z00006
; C:\PBP3\DEVICES\PIC18F2550.PBPINC	00243	Z00007	BANK2   $0200, $02FF
Z00007
; C:\PBP3\DEVICES\PIC18F2550.PBPINC	00244	Z00008	BANK3   $0300, $03FF
Z00008
; C:\PBP3\DEVICES\PIC18F2550.PBPINC	00245	Z00009	BANK4   $0400, $04FF
Z00009
; C:\PBP3\DEVICES\PIC18F2550.PBPINC	00246	Z0000A	BANK5   $0500, $05FF
Z0000A
; C:\PBP3\DEVICES\PIC18F2550.PBPINC	00247	Z0000B	BANK6   $0600, $06FF
Z0000B
; C:\PBP3\DEVICES\PIC18F2550.PBPINC	00248	Z0000C	BANK7   $0700, $07FF
Z0000C
; C:\PBP3\DEVICES\PIC18F2550.PBPINC	00254	Z0000D	    INCLUDE "PBPPI18L.RAM"
Z0000D
; C:\PBP3\DEVICES\PIC18F2550.PBPINC	00255	Z0000E	#ELSE
Z0000E
; C:\PBP3\DEVICES\PIC18F2550.PBPINC	00256	Z0000F	    LIBRARY  "PBPPIC18"
Z0000F

; C:\PBP3\DEVICES\PIC18F2550.PBPINC	00257	Z00010	    INCLUDE "PBPPIC18.RAM"
Z00010
; C:\PBP3\DEVICES\PIC18F2550.PBPINC	00258	Z00011	#ENDIF
Z00011
; C:\PBP3\DEVICES\PIC18F2550.PBPINC	00263	Z00012	USBMEMORYADDRESS Con	$400	' USB RAM starts here
Z00012
; C:\PBP3\DEVICES\PIC18F2550.PBPINC	00267	Z00013	#HEADER
Z00013
; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00001	Z00014	DEFINE OSC 48
Z00014
; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00003	Z00015	#config
Z00015
; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00013	Z00016	DEFINE LCD_DREG  PORTB                            ; LCD Data port
Z00016
; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00014	Z00017	DEFINE LCD_DBIT  4                                ; starting Data bit (0 or 4)
Z00017
; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00015	Z00018	DEFINE LCD_EREG  PORTB                            ; LCD Enable port
Z00018
; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00016	Z00019	DEFINE LCD_EBIT  2                                ;     Enable bit
Z00019
; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00017	Z0001A	DEFINE LCD_RSREG PORTB                            ; LCD Register Select port
Z0001A
; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00018	Z0001B	DEFINE LCD_RSBIT 1                                ;     Register Select bit
Z0001B
; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00019	Z0001C	DEFINE LCD_BITS  4                                ; LCD bus size (4 or 8 bits)
Z0001C
; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00020	Z0001D	DEFINE LCD_LINES 2                                ; number of lines on LCD
Z0001D
; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00021	Z0001E	DEFINE LCD_COMMANDUS 2000                         ; Command delay time in us 
Z0001E
; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00022	Z0001F	DEFINE LCD_DATAUS 50                              ; Data delay time in us 
Z0001F
; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00027	Z00020	TempHigh    CON 28                                ; DS1621 High Temp Limit
Z00020
; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00028	Z00021	TempLow     CON 24                                ; DS1621 Low Temp Limit
Z00021
; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00029	Z00022	DS1621      CON $90                               ; DS1621 Slave Address
Z00022

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00034	Z00023	CMCON = 7                                         ; All Digital
Z00023
	MOVE?CB	007h, CMCON

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00035	Z00024	ADCON1 = 15
Z00024
	MOVE?CB	00Fh, ADCON1

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00037	Z00025	I2CREAD SDA,SCL,DS1621,$AC,[ConfigReg]            ; Read the configuration
Z00025
	I2CDATA?T	_SDA
	I2CCLOCK?T	_SCL
	I2CWRITE?C	_DS1621
	I2CWRITE?C	0ACh
	I2CREADS?B	_ConfigReg

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00038	Z00026	IF ConfigReg.0 = 1 THEN                           ; if in Polling Mode?
Z00026
	CMPNE?TCL	_ConfigReg??0, 001h, L00001

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00039	Z00027	    ConfigReg.0 = 0                               ; Set it to Continuous Mode
Z00027
	MOVE?CT	000h, _ConfigReg??0

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00040	Z00028	    I2CWRITE SDA,SCL,DS1621,$AC,[ConfigReg]       ; Write the Config register
Z00028
	I2CDATA?T	_SDA
	I2CCLOCK?T	_SCL
	I2CWRITE?C	_DS1621
	I2CWRITE?C	0ACh
	I2CWRITES?B	_ConfigReg

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00041	Z00029	    GOSUB WaitForEE
Z00029
	GOSUB?L	_WaitForEE

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00042	Z0002A	ENDIF
Z0002A
	LABEL?L	L00001	

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00044	Z0002B	I2CREAD SDA,SCL,DS1621,$A1,[TempC.LowByte]        ; Read the High Temp Limit
Z0002B
	I2CDATA?T	_SDA
	I2CCLOCK?T	_SCL
	I2CWRITE?C	_DS1621
	I2CWRITE?C	0A1h
	I2CREADS?B	_TempC??LOWBYTE

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00045	Z0002C	IF TempC != TempHigh THEN                         ; if High limit is incorrect
Z0002C
	CMPEQ?WCL	_TempC, _TempHigh, L00003

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00046	Z0002D	    I2CWRITE SDA,SCL,DS1621,$A1,[TempHigh]        ;  Write High Limit
Z0002D
	I2CDATA?T	_SDA
	I2CCLOCK?T	_SCL
	I2CWRITE?C	_DS1621
	I2CWRITE?C	0A1h
	I2CWRITES?C	_TempHigh

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00047	Z0002E	    GOSUB WaitForEE
Z0002E
	GOSUB?L	_WaitForEE

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00048	Z0002F	ENDIF
Z0002F
	LABEL?L	L00003	

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00050	Z00030	I2CREAD SDA,SCL,DS1621,$A2,[TempC.LowByte]        ; Read the Low Temp Limit
Z00030
	I2CDATA?T	_SDA
	I2CCLOCK?T	_SCL
	I2CWRITE?C	_DS1621
	I2CWRITE?C	0A2h
	I2CREADS?B	_TempC??LOWBYTE

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00051	Z00031	IF TempC != TempLow THEN                          ; if Low limit is incorrect
Z00031
	CMPEQ?WCL	_TempC, _TempLow, L00005

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00052	Z00032	    I2CWRITE SDA,SCL,DS1621,$A2,[TempLow]         ;  Write Low Limit
Z00032
	I2CDATA?T	_SDA
	I2CCLOCK?T	_SCL
	I2CWRITE?C	_DS1621
	I2CWRITE?C	0A2h
	I2CWRITES?C	_TempLow

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00053	Z00033	    GOSUB WaitForEE
Z00033
	GOSUB?L	_WaitForEE

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00054	Z00034	ENDIF
Z00034
	LABEL?L	L00005	

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00056	Z00035	I2CWRITE SDA,SCL,DS1621,$EE,[0]                   ; Start Conversions
Z00035
	I2CDATA?T	_SDA
	I2CCLOCK?T	_SCL
	I2CWRITE?C	_DS1621
	I2CWRITE?C	0EEh
	I2CWRITES?C	000h

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00059	Z00036	Main:
Z00036

	LABEL?L	_Main	

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00060	Z00037	    PAUSE 900
Z00037
	PAUSE?C	00384h

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00061	Z00038	    I2CREAD SDA,SCL,DS1621,$AC,[ConfigReg]        ; Read the configuration
Z00038
	I2CDATA?T	_SDA
	I2CCLOCK?T	_SCL
	I2CWRITE?C	_DS1621
	I2CWRITE?C	0ACh
	I2CREADS?B	_ConfigReg

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00062	Z00039	    LCDOUT $FE,$80,"CONFIG=",IBIN8 ConfigReg
Z00039
	LCDOUT?C	0FEh
	LCDOUT?C	080h
	LCDOUT?C	043h
	LCDOUT?C	04Fh
	LCDOUT?C	04Eh
	LCDOUT?C	046h
	LCDOUT?C	049h
	LCDOUT?C	047h
	LCDOUT?C	03Dh
	LCDOUTCOUNT?C	008h
	LCDOUTNUM?B	_ConfigReg
	LCDOUTIBIN?	

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00064	Z0003A	    I2CREAD SDA,SCL,DS1621,$AA,[TempC.HighByte, TempC.LowByte]
Z0003A
	I2CDATA?T	_SDA
	I2CCLOCK?T	_SCL
	I2CWRITE?C	_DS1621
	I2CWRITE?C	0AAh
	I2CREAD?B	_TempC??HIGHBYTE
	I2CREADS?B	_TempC??LOWBYTE

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00065	Z0003B	    LCDOUT $FE,$C0,"  Temp="
Z0003B
	LCDOUT?C	0FEh
	LCDOUT?C	0C0h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	054h
	LCDOUT?C	065h
	LCDOUT?C	06Dh
	LCDOUT?C	070h
	LCDOUT?C	03Dh

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00066	Z0003C	    GOSUB ShowTemp
Z0003C
	GOSUB?L	_ShowTemp

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00068	Z0003D	    I2CREAD SDA,SCL,DS1621,$A1,[TempC.HighByte, TempC.LowByte]
Z0003D
	I2CDATA?T	_SDA
	I2CCLOCK?T	_SCL
	I2CWRITE?C	_DS1621
	I2CWRITE?C	0A1h
	I2CREAD?B	_TempC??HIGHBYTE
	I2CREADS?B	_TempC??LOWBYTE

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00069	Z0003E	    LCDOUT $FE,$94,"    TH="
Z0003E
	LCDOUT?C	0FEh
	LCDOUT?C	094h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	054h
	LCDOUT?C	048h
	LCDOUT?C	03Dh

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00070	Z0003F	    GOSUB ShowTemp
Z0003F
	GOSUB?L	_ShowTemp

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00072	Z00040	    I2CREAD SDA,SCL,DS1621,$A2,[TempC.HighByte, TempC.LowByte]
Z00040
	I2CDATA?T	_SDA
	I2CCLOCK?T	_SCL
	I2CWRITE?C	_DS1621
	I2CWRITE?C	0A2h
	I2CREAD?B	_TempC??HIGHBYTE
	I2CREADS?B	_TempC??LOWBYTE

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00073	Z00041	    LCDOUT $FE,$D4,"    TL="
Z00041
	LCDOUT?C	0FEh
	LCDOUT?C	0D4h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	020h
	LCDOUT?C	054h
	LCDOUT?C	04Ch
	LCDOUT?C	03Dh

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00074	Z00042	    GOSUB ShowTemp
Z00042
	GOSUB?L	_ShowTemp

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00076	Z00043	GOTO Main
Z00043
	GOTO?L	_Main

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00079	Z00044	ShowTemp:
Z00044

	LABEL?L	_ShowTemp	

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00080	Z00045	    LCDOUT DEC TempC.HighByte
Z00045
	LCDOUTCOUNT?C	000h
	LCDOUTNUM?B	_TempC??HIGHBYTE
	LCDOUTDEC?	

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00081	Z00046	    IF TempC.7 THEN
Z00046
	CMPF?TL	_TempC??7, L00007

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00082	Z00047	        LCDOUT ".5  "
Z00047
	LCDOUT?C	02Eh
	LCDOUT?C	035h
	LCDOUT?C	020h
	LCDOUT?C	020h

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00083	Z00048	    ELSE
Z00048
	GOTO?L	L00008
	LABEL?L	L00007	

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00084	Z00049	        LCDOUT ".0  "
Z00049
	LCDOUT?C	02Eh
	LCDOUT?C	030h
	LCDOUT?C	020h
	LCDOUT?C	020h

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00085	Z0004A	    ENDIF
Z0004A
	LABEL?L	L00008	

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00086	Z0004B	RETURN
Z0004B
	RETURN?	

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00089	Z0004C	WaitForEE:
Z0004C

	LABEL?L	_WaitForEE	

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00090	Z0004D	    REPEAT                                        ; Wait for EEPROM write
Z0004D
	LABEL?L	L00009	

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00091	Z0004E	        I2CREAD SDA,SCL,DS1621,$AC,[ConfigReg]
Z0004E
	I2CDATA?T	_SDA
	I2CCLOCK?T	_SCL
	I2CWRITE?C	_DS1621
	I2CWRITE?C	0ACh
	I2CREADS?B	_ConfigReg

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00092	Z0004F	        LCDOUT $FE,$80,"CONFIG=",IBIN8 ConfigReg
Z0004F
	LCDOUT?C	0FEh
	LCDOUT?C	080h
	LCDOUT?C	043h
	LCDOUT?C	04Fh
	LCDOUT?C	04Eh
	LCDOUT?C	046h
	LCDOUT?C	049h
	LCDOUT?C	047h
	LCDOUT?C	03Dh
	LCDOUTCOUNT?C	008h
	LCDOUTNUM?B	_ConfigReg
	LCDOUTIBIN?	

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00093	Z00050	    UNTIL ConfigReg.4 = 0
Z00050
	CMPNE?TCL	_ConfigReg??4, 000h, L00009
	LABEL?L	L00010	

; C:\ISIS\DS1621\DS1621_2550\DS1621_2550.PBP	00094	Z00051	RETURN
Z00051
	RETURN?	

	END
