
; PICBASIC PRO(TM) Compiler 2.60, (c) 1998, 2009 microEngineering Labs, Inc. All Rights Reserved. 
_USED			EQU	1

	INCLUDE	"C:\PBP\18F2620.INC"


; Define statements.
; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00001	DEFINE OSC 40
#define		OSC		 40
; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00020	DEFINE  INTHAND       INT_ENTRY_H  ' Context saving for High Priority Ints
#define		INTHAND		       INT_ENTRY_H  
; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00021	DEFINE  INTLHAND      INT_ENTRY_L  ' Context saving for Low Priority Ints
#define		INTLHAND		      INT_ENTRY_L  
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00022	DEFINE   ReEnterHPused  1
#define		ReEnterHPused		  1

RAM_START       		EQU	00000h
RAM_END         		EQU	00F7Fh
RAM_BANKS       		EQU	00010h
BANK0_START     		EQU	00080h
BANK0_END       		EQU	000FFh
BANK1_START     		EQU	00100h
BANK1_END       		EQU	001FFh
BANK2_START     		EQU	00200h
BANK2_END       		EQU	002FFh
BANK3_START     		EQU	00300h
BANK3_END       		EQU	003FFh
BANK4_START     		EQU	00400h
BANK4_END       		EQU	004FFh
BANK5_START     		EQU	00500h
BANK5_END       		EQU	005FFh
BANK6_START     		EQU	00600h
BANK6_END       		EQU	006FFh
BANK7_START     		EQU	00700h
BANK7_END       		EQU	007FFh
BANK8_START     		EQU	00800h
BANK8_END       		EQU	008FFh
BANK9_START     		EQU	00900h
BANK9_END       		EQU	009FFh
BANK10_START    		EQU	00A00h
BANK10_END      		EQU	00AFFh
BANK11_START    		EQU	00B00h
BANK11_END      		EQU	00BFFh
BANK12_START    		EQU	00C00h
BANK12_END      		EQU	00CFFh
BANK13_START    		EQU	00D00h
BANK13_END      		EQU	00DFFh
BANK14_START    		EQU	00E00h
BANK14_END      		EQU	00EFFh
BANK15_START    		EQU	00F00h
BANK15_END      		EQU	00F7Fh
BANKA_START     		EQU	00000h
BANKA_END       		EQU	0007Fh

; C:\PBP\PBPPIC18.RAM      	00028	A00000	FLAGS   VAR     BYTE BANKA SYSTEM       ' Static flags
FLAGS           		EQU	RAM_START + 000h
; C:\PBP\PBPPIC18.RAM      	00012	A00001	R0      VAR     WORD BANKA SYSTEM       ' System Register
R0              		EQU	RAM_START + 001h
; C:\PBP\PBPPIC18.RAM      	00013	A00003	R1      VAR     WORD BANKA SYSTEM       ' System Register
R1              		EQU	RAM_START + 003h
; C:\PBP\PBPPIC18.RAM      	00014	A00005	R2      VAR     WORD BANKA SYSTEM       ' System Register
R2              		EQU	RAM_START + 005h
; C:\PBP\PBPPIC18.RAM      	00015	A00007	R3      VAR     WORD BANKA SYSTEM       ' System Register
R3              		EQU	RAM_START + 007h
; C:\PBP\PBPPIC18.RAM      	00016	A00009	R4      VAR     WORD BANKA SYSTEM       ' System Register
R4              		EQU	RAM_START + 009h
; C:\PBP\PBPPIC18.RAM      	00017	A0000B	R5      VAR     WORD BANKA SYSTEM       ' System Register
R5              		EQU	RAM_START + 00Bh
; C:\PBP\PBPPIC18.RAM      	00018	A0000D	R6      VAR     WORD BANKA SYSTEM       ' System Register
R6              		EQU	RAM_START + 00Dh
; C:\PBP\PBPPIC18.RAM      	00019	A0000F	R7      VAR     WORD BANKA SYSTEM       ' System Register
R7              		EQU	RAM_START + 00Fh
; C:\PBP\PBPPIC18.RAM      	00020	A00011	R8      VAR     WORD BANKA SYSTEM       ' System Register
R8              		EQU	RAM_START + 011h
; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00001	A00013	DEFINE OSC 40
T1              		EQU	RAM_START + 013h
; C:\PBP\PBPPIC18.RAM      	00027	A00015	GOP     VAR     BYTE BANKA SYSTEM       ' Gen Op Parameter
GOP             		EQU	RAM_START + 015h
; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00038	A00016	INT_Flags   VAR BYTE  BANKA  SYSTEM
INT_Flags       		EQU	RAM_START + 016h
; C:\PBP\PBPPIC18.RAM      	00023	A00017	RM1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Mask
RM1             		EQU	RAM_START + 017h
; C:\PBP\PBPPIC18.RAM      	00026	A00018	RM2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Mask
RM2             		EQU	RAM_START + 018h
; C:\PBP\PBPPIC18.RAM      	00021	A00019	RR1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Register
RR1             		EQU	RAM_START + 019h
; C:\PBP\PBPPIC18.RAM      	00024	A0001A	RR2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Register
RR2             		EQU	RAM_START + 01Ah
; C:\PBP\PBPPIC18.RAM      	00022	A0001B	RS1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Bank
RS1             		EQU	RAM_START + 01Bh
; C:\PBP\PBPPIC18.RAM      	00025	A0001C	RS2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Bank
RS2             		EQU	RAM_START + 01Ch
; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00023	A0001D	wsave       var byte  BANKA  SYSTEM   ' location for WREG
wsave           		EQU	RAM_START + 01Dh
; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00036	A0001E	RetAddrH    VAR BYTE[3]  BANKA  SYSTEM  ' 21-bit return address Hi Pri.
RetAddrH        		EQU	RAM_START + 01Eh
; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00037	A00021	RetAddrL    VAR BYTE[3]  BANKA  SYSTEM  '                       Lo Pri.
RetAddrL        		EQU	RAM_START + 021h
; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00001	A00024	DEFINE OSC 40
PB01            		EQU	RAM_START + 024h
; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00016	A00025	dummy               VAR BYTE
_dummy           		EQU	RAM_START + 025h
; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00019	A00026	i var byte
_i               		EQU	RAM_START + 026h
; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00014	A00027	i2c_data_index      VAR BYTE
_i2c_data_index  		EQU	RAM_START + 027h
; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00013	A00028	i2c_data            VAR BYTE[6]
_i2c_data        		EQU	RAM_START + 028h
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00029	A0002E	HP_Vars  VAR  WORD[34]        ; group vars together for less banking
_HP_Vars         		EQU	RAM_START + 02Eh
; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00030	A00080	fsave0H     var WORD  BANK0  SYSTEM   ' locations for FSR registers
fsave0H         		EQU	RAM_START + 080h
; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00033	A00082	fsave0L     var WORD  BANK0  SYSTEM   ' low priority FSR locations
fsave0L         		EQU	RAM_START + 082h
; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00031	A00084	fsave1H     var WORD  BANK0  SYSTEM
fsave1H         		EQU	RAM_START + 084h
; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00034	A00086	fsave1L     var WORD  BANK0  SYSTEM
fsave1L         		EQU	RAM_START + 086h
; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00032	A00088	fsave2H     var WORD  BANK0  SYSTEM
fsave2H         		EQU	RAM_START + 088h
; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00035	A0008A	fsave2L     var WORD  BANK0  SYSTEM
fsave2L         		EQU	RAM_START + 08Ah
; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00025	A0008C	bsave       var byte  BANK0  SYSTEM   ' location for BSR register
bsave           		EQU	RAM_START + 08Ch
; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00028	A0008D	psaveH      VAR BYTE  BANK0  SYSTEM   ' PCLATH Hi Pri.
psaveH          		EQU	RAM_START + 08Dh
; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00029	A0008E	psaveL      VAR BYTE  BANK0  SYSTEM   '        Lo Pri.
psaveL          		EQU	RAM_START + 08Eh
; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00026	A0008F	psaveUH     VAR BYTE  BANK0  SYSTEM   ' PCLATU Hi Pri.
psaveUH         		EQU	RAM_START + 08Fh
; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00027	A00090	psaveUL     VAR BYTE  BANK0  SYSTEM   '        Lo Pri.
psaveUL         		EQU	RAM_START + 090h
; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00024	A00091	ssave       var byte  BANK0  SYSTEM   ' location for STATUS register
ssave           		EQU	RAM_START + 091h
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00030	    R0_SaveH      VAR HP_Vars[0]
_R0_SaveH        		EQU	_HP_Vars
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00031	    R1_SaveH      VAR HP_Vars[2]
_R1_SaveH        		EQU	_HP_Vars + 004h
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00032	    R2_SaveH      VAR HP_Vars[4]
_R2_SaveH        		EQU	_HP_Vars + 008h
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00033	    R3_SaveH      VAR HP_Vars[6]
_R3_SaveH        		EQU	_HP_Vars + 00Ch
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00034	    R4_SaveH      VAR HP_Vars[8]
_R4_SaveH        		EQU	_HP_Vars + 010h
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00035	    R5_SaveH      VAR HP_Vars[9]
_R5_SaveH        		EQU	_HP_Vars + 012h
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00036	    R6_SaveH      VAR HP_Vars[10]
_R6_SaveH        		EQU	_HP_Vars + 014h
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00037	    R7_SaveH      VAR HP_Vars[11]
_R7_SaveH        		EQU	_HP_Vars + 016h
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00038	    R8_SaveH      VAR HP_Vars[12]
_R8_SaveH        		EQU	_HP_Vars + 018h
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00039	    Flag_GOP_H    VAR HP_Vars[13]
_Flag_GOP_H      		EQU	_HP_Vars + 01Ah
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00042	    RM_H          VAR HP_Vars[14]
_RM_H            		EQU	_HP_Vars + 01Ch
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00045	    RR_H          VAR HP_Vars[15]
_RR_H            		EQU	_HP_Vars + 01Eh
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00048	    RS_H          VAR HP_Vars[16]
_RS_H            		EQU	_HP_Vars + 020h
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00051	    T1_SaveH      VAR HP_Vars[17]
_T1_SaveH        		EQU	_HP_Vars + 022h
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00052	    T2_SaveH      VAR HP_Vars[19]
_T2_SaveH        		EQU	_HP_Vars + 026h
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00053	    T3_SaveH      VAR HP_Vars[21]
_T3_SaveH        		EQU	_HP_Vars + 02Ah
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00054	    T4_SaveH      VAR HP_Vars[23]
_T4_SaveH        		EQU	_HP_Vars + 02Eh
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00055	    T5_SaveH      VAR HP_Vars[25]
_T5_SaveH        		EQU	_HP_Vars + 032h
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00056	    T6_SaveH      VAR HP_Vars[27]
_T6_SaveH        		EQU	_HP_Vars + 036h
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00057	    T7_SaveH      VAR HP_Vars[29]
_T7_SaveH        		EQU	_HP_Vars + 03Ah
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00058	    TBLPTRU_H     VAR HP_Vars[31]
_TBLPTRU_H       		EQU	_HP_Vars + 03Eh
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00060	    TBLPTR_H      VAR HP_Vars[32]
_TBLPTR_H        		EQU	_HP_Vars + 040h
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00063	    Product_H     VAR HP_Vars[33]
_Product_H       		EQU	_HP_Vars + 042h
; C:\PBP\18F2620.BAS       	00034	PORTL   VAR     PORTB
_PORTL           		EQU	 PORTB
; C:\PBP\18F2620.BAS       	00035	PORTH   VAR     PORTC
_PORTH           		EQU	 PORTC
; C:\PBP\18F2620.BAS       	00036	TRISL   VAR     TRISB
_TRISL           		EQU	 TRISB
; C:\PBP\18F2620.BAS       	00037	TRISH   VAR     TRISC
_TRISH           		EQU	 TRISC
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00040	      Flags_SaveH   VAR Flag_GOP_H.lowbyte
_Flags_SaveH     		EQU	_Flag_GOP_H
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00041	      GOP_SaveH     VAR Flag_GOP_H.highbyte
_GOP_SaveH       		EQU	_Flag_GOP_H + 001h
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00043	      RM1_SaveH     VAR RM_H.lowbyte
_RM1_SaveH       		EQU	_RM_H
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00044	      RM2_SaveH     VAR RM_H.highbyte
_RM2_SaveH       		EQU	_RM_H + 001h
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00046	      RR1_SaveH     VAR RR_H.lowbyte
_RR1_SaveH       		EQU	_RR_H
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00047	      RR2_SaveH     VAR RR_H.highbyte
_RR2_SaveH       		EQU	_RR_H + 001h
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00049	      RS1_SaveH     VAR RS_H.lowbyte
_RS1_SaveH       		EQU	_RS_H
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00050	      RS2_SaveH     VAR RS_H.highbyte
_RS2_SaveH       		EQU	_RS_H + 001h
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00059	      TBLPTRU_SaveH VAR TBLPTRU_H.lowbyte
_TBLPTRU_SaveH   		EQU	_TBLPTRU_H
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00061	      TBLPTRH_SaveH VAR TBLPTR_H.highbyte
_TBLPTRH_SaveH   		EQU	_TBLPTR_H + 001h
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00062	      TBLPTRL_SaveH VAR TBLPTR_H.lowbyte
_TBLPTRL_SaveH   		EQU	_TBLPTR_H
_Flag_GOP_H??LOWBYTE		EQU	_Flag_GOP_H
_Flag_GOP_H??HIGHBYTE		EQU	_Flag_GOP_H + 001h
_RM_H??LOWBYTE   		EQU	_RM_H
_RM_H??HIGHBYTE  		EQU	_RM_H + 001h
_RR_H??LOWBYTE   		EQU	_RR_H
_RR_H??HIGHBYTE  		EQU	_RR_H + 001h
_RS_H??LOWBYTE   		EQU	_RS_H
_RS_H??HIGHBYTE  		EQU	_RS_H + 001h
_TBLPTRU_H??LOWBYTE		EQU	_TBLPTRU_H
_TBLPTR_H??HIGHBYTE		EQU	_TBLPTR_H + 001h
_TBLPTR_H??LOWBYTE		EQU	_TBLPTR_H
#define _Serviced_H      	_INT_Flags??0
#define _Serviced_L      	_INT_Flags??1
#define _InHPint         	_INT_Flags??2
#define _NoPriority      	_INT_Flags??3
#define _VarsSaved_H     	 PB01, 000h
#define _i2c_buffer_full 	_SSPSTAT??0
#define _i2c_read        	_SSPSTAT??2
#define _i2c_release_scl 	_SSPCON1??4
#define _INT_Flags??0    	 INT_Flags, 000h
#define _INT_Flags??1    	 INT_Flags, 001h
#define _INT_Flags??2    	 INT_Flags, 002h
#define _INT_Flags??3    	 INT_Flags, 003h
#define _SSPSTAT??0      	 SSPSTAT, 000h
#define _SSPSTAT??2      	 SSPSTAT, 002h
#define _SSPCON1??4      	 SSPCON1, 004h
#define _SSPCON2??0      	 SSPCON2, 000h

; EEPROM data.


	INCLUDE	"MASTER~1.MAC"
	INCLUDE	"C:\PBP\PBPPIC18.LIB"


; C:\PBP\18F2620.BAS       	00012	BANKA   $0000, $007F
; C:\PBP\18F2620.BAS       	00013	BANK0   $0080, $00FF
; C:\PBP\18F2620.BAS       	00014	BANK1   $0100, $01FF
; C:\PBP\18F2620.BAS       	00015	BANK2   $0200, $02FF
; C:\PBP\18F2620.BAS       	00016	BANK3   $0300, $03FF
; C:\PBP\18F2620.BAS       	00017	BANK4   $0400, $04FF
; C:\PBP\18F2620.BAS       	00018	BANK5   $0500, $05FF
; C:\PBP\18F2620.BAS       	00019	BANK6   $0600, $06FF
; C:\PBP\18F2620.BAS       	00020	BANK7   $0700, $07FF
; C:\PBP\18F2620.BAS       	00021	BANK8   $0800, $08FF
; C:\PBP\18F2620.BAS       	00022	BANK9   $0900, $09FF
; C:\PBP\18F2620.BAS       	00023	BANK10  $0A00, $0AFF
; C:\PBP\18F2620.BAS       	00024	BANK11  $0B00, $0BFF
; C:\PBP\18F2620.BAS       	00025	BANK12  $0C00, $0CFF
; C:\PBP\18F2620.BAS       	00026	BANK13  $0D00, $0DFF
; C:\PBP\18F2620.BAS       	00027	BANK14  $0E00, $0EFF
; C:\PBP\18F2620.BAS       	00028	BANK15  $0F00, $0F7F
; C:\PBP\18F2620.BAS       	00030	LIBRARY "PBPPIC18"

; C:\PBP\18F2620.BAS       	00032	        include "PIC18EXT.BAS"

; C:\PBP\18F2620.BAS       	00039	        include "PBPPIC18.RAM"
; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00001	DEFINE OSC 40

; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00003	INCLUDE "DT_INTS-18.bas"  

; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00018	DISABLE DEBUG
	DDISABLE?	
; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00020	DEFINE  INTHAND       INT_ENTRY_H  ' Context saving for High Priority Ints
; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00021	DEFINE  INTLHAND      INT_ENTRY_L  ' Context saving for Low Priority Ints

; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00044	INT_Flags = 0 
	MOVE?CB	000h, INT_Flags

; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00046	goto  OVER_DT_INTS_18
	GOTO?L	_OVER_DT_INTS_18

; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00048	ASM

	ASM?

;____ Check for PBPL (PBP ver. 2.50 and above only)__________________________
PBPLongs_Used = 0
  if (R1 - R0 == 4)
PBPLongs_Used = 1
;    messg PBPL Used = 1
  endif

  nolist
;____ DEFINE available interrupt sources_____________________________________

  #define INT_INT   INTCON, INT0IF  ;-- INT External, 16F compatible
  #define INT0_INT  INTCON, INT0IF  ;-- INT0 External 
  #define INT1_INT  INTCON3,INT1IF  ;-- INT1 External 
  #define INT2_INT  INTCON3,INT2IF  ;-- INT2 External 
  #define INT3_INT  INTCON3,INT3IF  ;-- INT3 External 
  #define RBC_INT   INTCON, RBIF    ;-- RB Port Change 
  #define TMR0_INT  INTCON, TMR0IF  ;-- TMR0 Overflow  18F
  #define TMR1_INT  PIR1, TMR1IF    ;-- TMR1 Overflow 
  #define TMR2_INT  PIR1, TMR2IF    ;-- TMR2 to PR2 Match 
  #define TMR3_INT  PIR2, TMR3IF    ;-- TMR3 Overflow 
  #define TMR4_INT  PIR3, TMR4IF    ;-- TMR4 Overflow 
  #define TX_INT    PIR1, TXIF      ;-- USART Transmit 
  #define TX1_INT   PIR1, TX1IF     ;-- USART1 Transmit 
  #define TX2_INT   PIR3, TX2IF     ;-- USART2 Transmit 
  #define RX_INT    PIR1, RCIF      ;-- USART Receive 
  #define RX1_INT   PIR1, RC1IF     ;-- USART1 Receive 
  #define RX2_INT   PIR3, RC2IF     ;-- USART2 Receive 
  #define CMP_INT   PIR2, CMIF      ;-- Comparator 
  #define EE_INT    PIR2, EEIF      ;-- EEPROM/FLASH Write Operation 
  #define BUS_INT   PIR2, BCLIF     ;-- Bus Collision 
  #define LVD_INT   PIR2, LVDIF     ;-- Low Voltage Detect 
  #define HLVD_INT  PIR2, HLVDIF    ;-- High/Low Voltage Detect 
  #define PSP_INT   PIR1, PSPIF     ;-- Parallel Slave Port Read/Write 
  #define AD_INT    PIR1, ADIF      ;-- A/D Converter 
  #define SSP_INT   PIR1, SSPIF     ;-- Master Synchronous Serial Port 
  #define CCP1_INT  PIR1, CCP1IF    ;-- CCP1 
  #define CCP2_INT  PIR2, CCP2IF    ;-- CCP2 
  #define CCP3_INT  PIR3, CCP3IF    ;-- CCP3 
  #define CCP4_INT  PIR3, CCP4IF    ;-- CCP4 
  #define CCP5_INT  PIR3, CCP5IF    ;-- CCP5 
  #define OSC_INT   PIR2, OSCFIF    ;-- Oscillator Fail 

; -- Added for ver. 3.2 --
  #define SPP_INT   PIR1, SPPIF     ;-- Streaming Parallel Port Read/Write
  #define BUS1_INT  PIR2, BCL1IF    ;-- Bus 1 Collision 
  #define BUS2_INT  PIR3, BCL2IF    ;-- Bus 2 Collision
  #define ECCP1_INT PIR2, ECCP1IF   ;-- ECCP1
  #define LCD_INT   PIR3, LCDIF     ;-- LCD Driver
  #define PMP_INT   PIR1, PMPIF     ;-- Parallel Master Port
  #define SSP1_INT  PIR1, SSP1IF    ;-- Synchronous Serial Port 1
  #define SSP2_INT  PIR3, SSP2IF    ;-- Synchronous Serial Port 2
  #define TMR5_INT  PIR3, TMR5IF    ;-- Timer 5
  #define PT_INT    PIR3, PTIF      ;-- PWM Time Base
  #define IC1IF_INT  PIR3, IC1IF    ;-- Motion Feedback
  #define IC2QEIF_INT  PIR3, IC2QEIF  ;-- Motion Feedback
  #define IC3DRIF_INT  PIR3, IC3DRIF  ;-- Motion Feedback

;_____ Comparators __________________________________________________________
  #define CMP0_INT  PIR1, CMP0IF    ;-- Comparator 0 - 1230/1330 only

CMPIFREG = PIR2                     ;-- Comparator 1
CMPIEREG = PIE2
CMPIPREG = IPR2
    ifdef C1IF                      ;     18F24K20  18F25K20  18F26K20
CM1IFBIT = C1IF                     ;     18F44K20  18F45K20  18F46K20
    endif
    ifdef CM1IF
CM1IFBIT = CM1IF                    ;     several J PICs
    endif
    ifdef CMP1IF
CMPIFREG = PIR1                     ;     1230/1330 only
CM1IFBIT = CMP1IF
CMPIEREG = PIE1
CMPIPREG = IPR1
    endif

    ifdef CM1IFBIT
       #define CMP1_INT  CMPIFREG, CM1IFBIT     
    endif

    ifdef C2IF                      ;-- Comparator 2
CM2IFBIT = C2IF                     ;     18F24K20  18F25K20  18F26K20
    endif                           ;     18F44K20  18F45K20  18F46K20
    ifdef CM2IF
CM2IFBIT = CM2IF                    ;     several J PICs
    endif    
    ifdef CMP2IF
CM2IFBIT = CMP2IF                   ;     1230/1330 only
    endif    

    ifdef CM2IFBIT
      #define CMP2_INT  CMPIFREG, CM2IFBIT     
    endif

;_____ USB Module ___________________________________________________________

  #define USB_INT       PIR2, USBIF   ;-- USB Interrupt (funnel)
  #define USB_ACTV_INT  UIR,  ACTVIF  ;-- Bus Activity Detect 
  #define USB_ERR_INT   UIR,  UERRIF  ;-- USB Error Condition INT (funnel)
  #define USB_RST_INT   UIR,  URSTIF  ;-- USB Reset 
  #define USB_IDLE_INT  UIR,  IDLEIF  ;-- Idle Detect 
  #define USB_STALL_INT UIR,  STALLIF ;-- A STALL Handshake 
  #define USB_TRN_INT   UIR,  TRNIF   ;-- Transaction Complete 
  #define USB_SOF_INT   UIR,  SOFIF   ;-- START-OF-FRAME Token 

; -- USB Error Flags --
  #define USB_BTO_INT   UEIR, BTOEF   ;-- Bus Turnaround Time-out Error
  #define USB_BTS_INT   UEIR, BTSEF   ;-- Bit Stuff Error
  #define USB_CRC16_INT UEIR, CRC16EF ;-- CRC16 Failure
  #define USB_CRC5_INT  UEIR, CRC5EF  ;-- CRC5 Host Error
  #define USB_DFN8_INT  UEIR, DFN8EF  ;-- Data Field Size Error
  #define USB_PID_INT   UEIR, PIDEF   ;-- PID Check Failure
   
;_____ Ethernet Module ______________________________________________________
  #define ETH_INT       PIR2, ETHIF   ;-- Ethernet Module
  #define ETH_DMA_INT    EIR, DMAIF   ;-- DMA Interrupt
  #define ETH_LINK_INT   EIR, LINKIF  ;-- Link Status Change
  #define ETH_PKT_INT    EIR, PKTIF   ;-- Receive Packet Pending
  #define ETH_RXER_INT   EIR, RXERIF  ;-- Receive Error
  #define ETH_TXER_INT   EIR, TXERIF  ;-- Transmit Error
  #define ETH_TX_INT     EIR, TXIF    ;-- Transmit

;_____ CAN Module ___________________________________________________________
  #define CAN_ERR_INT    PIR3, ERRIF    ;-- CAN bus Error
  #define CAN_IRX_INT    PIR3, IRXIF    ;-- Invalid Received Message
  #define CAN_RXB0_INT   PIR3, RXB0IF   ;-* Receive Buffer 0      Mode 0
  #define CAN_FIFOWM_INT PIR3, FIFOWMIF ;-- FIFO Watermark        Mode 1, 2
  #define CAN_RXB1_INT   PIR3, RXB1IF   ;-* Receive Buffer 1      Mode 0
  #define CAN_RXBn_INT   PIR3, RXBnIF   ;-- Any Receive Buffer    Mode 1, 2
  #define CAN_TXB0_INT   PIR3, TXB0IF   ;-- Transmit Buffer 0
  #define CAN_TXB1_INT   PIR3, TXB1IF   ;-- Transmit Buffer 1
  #define CAN_TXB2_INT   PIR3, TXB2IF   ;-* Transmit Buffer 2     Mode 0
  #define CAN_TXBn_INT   PIR3, TXBnIF   ;-- Any Transmit Buffer   Mode 1, 2
  #define CAN_WAKE_INT   PIR3, WAKIF    ;-- CAN bus Activity Wake-up


	ENDASM?


; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00185	asm

	ASM?

; -- macro --
INT_Source  macro  IFR, IFB, IER, IEB, IPR, IPB
    if (IflagReg == IFR) && (IflagBit == IFB)  
  list  
INT_Flag_Reg = IFR
INT_Flag_Bit = IFB
INT_Enable_Reg = IER
INT_Enable_Bit = IEB
INT_Priority_Reg = IPR
INT_Priority_Bit = IPB
Found = 1
    endif
  nolist  
    endm 


	ENDASM?


; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00203	asm

	ASM?

;____________________________________________________________________________
GetIntInfo  macro  IflagReg, IflagBit
  nolist
INT_Flag_Reg = -1
INT_Flag_Bit = -1
INT_Enable_Reg = -1
INT_Enable_Bit = -1
  ifdef  IPR1
INT_Priority_Reg = -1
INT_Priority_Bit = -1
  endif
Found = 0

  ifdef INT0IF  ;----{ INT0 External Interrupt }----------[INTCON, INT0IF]---
      INT_Source  INTCON,INT0IF, INTCON,INT0IE, -1, -1
  endif
  ifdef INT1IF  ;----{ INT1 External Interrupt }---------[INTCON3, INT1IF]---
      INT_Source  INTCON3,INT1IF, INTCON3,INT1IE, INTCON3,INT1IP
  endif
  ifdef INT2IF  ;----{ INT2 External Interrupt }---------[INTCON3, INT2IF]---
      INT_Source  INTCON3,INT2IF, INTCON3,INT2IE, INTCON3,INT2IP
  endif
  ifdef INT3IF  ;----{ INT3 External Interrupt }---------[INTCON3, INT3IF]---
      INT_Source  INTCON3,INT3IF, INTCON3,INT3IE, INTCON2,INT3IP
  endif
  ifdef RBIF    ;----{ RB Port Change Interrupt }-----------[INTCON, RBIF]---
      INT_Source  INTCON,RBIF, INTCON, RBIE,INTCON2,RBIP
  endif
  ifdef TMR0IF  ;----{ TMR0 Overflow Interrupt }----------[INTCON, TMR0IF]---
      INT_Source  INTCON,TMR0IF, INTCON,TMR0IE, INTCON2,TMR0IP
  endif
  ifdef TMR1IF  ;----{ TMR1 Overflow Interrupt }------------[PIR1, TMR1IF]---
      INT_Source  PIR1,TMR1IF, PIE1,TMR1IE, IPR1,TMR1IP
  endif
  ifdef TMR2IF  ;----{ TMR2 to PR2 Match Interrupt }--------[PIR1, TMR2IF]---
      INT_Source  PIR1,TMR2IF, PIE1,TMR2IE, IPR1,TMR2IP
  endif
  ifdef TMR3IF  ;----{ TMR3 Overflow Interrupt }------------[PIR2, TMR3IF]---
      INT_Source  PIR2,TMR3IF, PIE2,TMR3IE, IPR2,TMR3IP
  endif
  ifdef TMR4IF  ;----{ TMR4 Overflow Interrupt }------------[PIR3, TMR4IF]---
      INT_Source  PIR3,TMR4IF, PIE3,TMR4IE, IPR3,TMR4IP
  endif
  ifndef TX1IF  ;----{ USART Transmit Interrupt }-------------[PIR1, TXIF]---
      ifdef TXIF
          INT_Source  PIR1,TXIF, PIE1,TXIE, IPR1,TXIP
      endif
  endif
  ifdef TX1IF   ;----{ USART1 Transmit Interrupt }-----------[PIR1, TX1IF]---
      INT_Source  PIR1,TX1IF, PIE1,TX1IE, IPR1,TX1IP
  endif
  ifdef TX2IF   ;----{ USART2 Transmit Interrupt }-----------[PIR3, TX2IF]---
      INT_Source  PIR3,TX2IF, PIE3,TX2IE, IPR3,TX2IP
  endif
  ifndef RC1IF  ;----{ USART Receive Interrupt }---------------[PIR1 RCIF]---  
    ifdef RCIF
        INT_Source  PIR1,RCIF, PIE1,RCIE, IPR1,RCIP
    endif
  endif
  ifdef RC1IF   ;----{ USART1 Receive Interrupt }------------[PIR1, RC1IF]---
      INT_Source  PIR1,RC1IF, PIE1,RC1IE, IPR1,RC1IP
  endif
  ifdef RC2IF   ;----{ USART2 Receive Interrupt }------------[PIR3, RC2IF]---
      INT_Source  PIR3,RC2IF, PIE3,RC2IE, IPR3,RC2IP
  endif
  ifdef CMIF    ;----{ Comparator Interrupt }-----------------[PIR2, CMIF]---
      INT_Source  PIR2,CMIF, PIE2,CMIE, IPR2,CMIP
  endif
  ifdef EEIF    ;----{ EEPROM/FLASH Write Operation Interrupt [PIR2, EEIF]---
      INT_Source  PIR2,EEIF, PIE2,EEIE, IPR2,EEIP
  endif
  ifdef BCLIF   ;----{ Bus Collision Interrupt }-------------[PIR2, BCLIF]---
      INT_Source  PIR2,BCLIF, PIE2,BCLIE, IPR2,BCLIP
  endif
  ifdef LVDIF   ;----{ Low Voltage Detect Interrupt }--------[PIR2, LVDIF]---
      INT_Source  PIR2,LVDIF, PIE2,LVDIE, IPR2,LVDIP
  endif
  ifdef HLVDIF  ;----{ High/Low Voltage Detect Interrupt }--[PIR2, HLVDIF]---
      INT_Source  PIR2,HLVDIF, PIE2,HLVDIE, IPR2,HLVDIP
  endif
  ifdef PSPIF   ;----{ Parallel Slave Port Interrupt }-------[PIR1, PSPIF]---
      INT_Source  PIR1,PSPIF, PIE1,PSPIE, IPR1,PSPIP
  endif
  ifdef ADIF    ;----{ A/D Converter Interrupt }--------------[PIR1, ADIF]---
      INT_Source  PIR1,ADIF, PIE1,ADIE, IPR1,ADIP
  endif
  ifdef SSPIF   ;----{ Synchronous Serial Port Interrupt }---[PIR1, SSPIF]---
      INT_Source  PIR1,SSPIF, PIE1,SSPIE, IPR1,SSPIP
  endif
  ifdef CCP1IF  ;----{ CCP1 Interrupt }---------------------[PIR1, CCP1IF]---
      INT_Source  PIR1,CCP1IF, PIE1,CCP1IE, IPR1,CCP1IP
  endif
  ifdef CCP2IF  ;----{ CCP2 Interrupt Flag }----------------[PIR2, CCP2IF]---
      INT_Source  PIR2,CCP2IF, PIE2,CCP2IE, IPR2,CCP2IP
  endif
  ifdef CCP3IF  ;----{ CCP3 Interrupt Flag }----------------[PIR3, CCP3IF]---
      INT_Source  PIR3,CCP3IF, PIE3,CCP3IE, IPR3,CCP3IP
  endif
  ifdef CCP4IF  ;----{ CCP4 Interrupt Flag }----------------[PIR3, CCP4IF]---
      INT_Source  PIR3,CCP4IF, PIE3,CCP4IE, IPR3,CCP4IP
  endif
  ifdef CCP5IF  ;----{ CCP5 Interrupt Flag }----------------[PIR3, CCP5IF]---
      INT_Source  PIR3,CCP5IF, PIE3,CCP5IE, IPR3,CCP5IP
  endif
  ifdef OSCFIF  ;----{ Osc Fail  Interrupt Flag }-----------[PIR2, OSCFIF]---
      INT_Source  PIR2,OSCFIF, PIE2,OSCFIE, IPR2,OSCFIP
  endif


	ENDASM?


; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00313	asm

	ASM?

; -- Added for ver. 3.2 --
  ifdef SPPIF   ;----{ Streaming Parallel Port Read/Write }--[PIR1, SPPIF]---
      INT_Source  PIR1,SPPIF, PIE1,SPPIE, IPR1,SPPIP
  endif
  ifdef BCL1IF  ;----{ Bus 1 Collision }--------------------[PIR2, BCL1IF]---
      INT_Source  BUS1_INT, PIE2,BCL1IE, IPR2,BCL1IP
  endif
  ifdef BCL2IF  ;----{ Bus 2 Collision }--------------------[PIR3, BCL2IF]---
      INT_Source  BUS2_INT, PIE3,BCL2IE, IPR3,BCL2IP
  endif
  ifdef CMP0IF  ;----{ Comparator 0 }-----------------------[PIR1, CMP0IF]---
      INT_Source  CMP0_INT, PIE1,CMP0IE, IPR1,CMP0IP
  endif
  ifdef CM1IFBIT  ;--{ Comparator 1 }-----------------------------[varies]---
      INT_Source  CMP1_INT, CMPIEREG,CM1IFBIT, CMPIPREG,CM1IFBIT
  endif
  ifdef CM2IFBIT  ;--{ Comparator 2 }-----------------------------[varies]---
      INT_Source  CMP2_INT, CMPIEREG,CM2IFBIT, CMPIPREG,CM2IFBIT
  endif
  ifdef ECCP1IF  ;---{ ECCP1 }-----------------------------[PIR2, ECCP1IF]---
      INT_Source  ECCP1_INT, PIE2,ECCP1IE, IPR2,ECCP1IP
  endif
  ifdef LCDIF   ;----{ LCD Driver }--------------------------[PIR3, LCDIF]---
      INT_Source  LCD_INT, PIE3,LCDIE, IPR3,LCDIP
  endif
  ifdef PMPIF   ;----{ Parallel Master Port }----------------[PIR1, PMPIF]---
      INT_Source  PMP_INT, PIE1,PMPIE, IPR1,PMPIP
  endif
  ifdef SSP1IF  ;----{ Synchronous Serial Port 1 }----------[PIR1, SSP1IF]---
      INT_Source  SSP1_INT, PIE1,SSP1IE, IPR1,SSP1IP
  endif
  ifdef SSP2IF  ;----{ Synchronous Serial Port 2 }----------[PIR3, SSP2IF]---
      INT_Source  SSP2_INT, PIE3,SSP2IE, IPR3,SSP2IP
  endif
  ifdef TMR5IF  ;----{ Timer 5 }----------------------------[PIR3, TMR5IF]---
      INT_Source  TMR5_INT, PIE3,TMR5IE, IPR3,TMR5IP
  endif
  ifdef PTIF    ;----{ PWM Time Base }------------------------[PIR3, PTIF]---
      INT_Source  PT_INT, PIE3,PTIE, IPR3,PTIP
  endif
  ifdef IC1IF   ;----{ Motion Feedback IC1}------------------[PIR3, IC1IF]---
      INT_Source  IC1IF_INT, PIE3,IC1IE, IPR3,IC1IP
  endif
  ifdef IC2QEIF ;----{ Motion Feedback IC2QE}--------------[PIR3, IC2QEIF]---
      INT_Source  IC2QEIF_INT, PIE3,IC2QEIE, IPR3,IC2QEIP
  endif
  ifdef IC3DRIF ;----{ Motion Feedback IC3DR}--------------[PIR3, IC3DRIF]---
      INT_Source  IC3DRIF_INT, PIE3,IC3DRIE, IPR3,IC3DRIP
  endif
  
;  ifdef   ;----{  }-------------[, ]---
;      INT_Source  , ,, ,
;  endif


	ENDASM?


; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00369	asm  ; -- USB sources --

	ASM?
  ; -- USB sources --
  ifdef USBIF   ;----{ USB  Interrupt funnel }---------------[PIR2, USBIF]---
      INT_Source  PIR2,USBIF, PIE2,USBIE, IPR2,USBIP
          
                ;----{ Bus Activity Detect }-----------------[UIR, ACTVIF]---
      INT_Source  USB_ACTV_INT, UIE,ACTVIE, _NoPriority
  
                ;----{ USB Reset }---------------------------[UIR, URSTIF]---
      INT_Source  USB_RST_INT, UIE,URSTIE, _NoPriority
  
                ;----{ Idle Detect }-------------------------[UIR, IDLEIF]---
      INT_Source  USB_IDLE_INT, UIE,IDLEIE, _NoPriority
  
                ;----{ A STALL Handshake }------------------[UIR, STALLIF]---
      INT_Source  USB_STALL_INT, UIE,STALLIE, _NoPriority
  
                ;----{ Transaction Complete }-----------------[UIR, TRNIF]---
      INT_Source  USB_TRN_INT, UIE,TRNIE, _NoPriority
  
                ;----{ START-OF-FRAME Token }-----------------[UIR, SOFIF]---
      INT_Source  USB_SOF_INT, UIE,SOFIE, _NoPriority
  
; -- USB Error Flags --
                ;----{ USB Error Condition Int funnel }------[UIR, UERRIF]---
      INT_Source  USB_ERR_INT, UIE,UERRIE, _NoPriority
   
                ;----{ Bus Turnaround Time-out Error }-------[UEIR, BTOEF]---
      INT_Source  USB_BTO_INT, UEIE,BTOEE, _NoPriority
   
                ;----{ Bit Stuff Error }---------------------[UEIR, BTSEF]---
      INT_Source  USB_BTS_INT, UEIE,BTSEE, _NoPriority
   
                ;--{ CRC16 Failure }-----------------------[UEIR, CRC16EF]---
      INT_Source  USB_CRC16_INT, UEIE,CRC16EE, _NoPriority
   
                ;---{ CRC5 Host Error }---------------------[UEIR, CRC5EF]---
      INT_Source  USB_CRC5_INT, UEIE,CRC5EE, _NoPriority
   
                ;---{ Data Field Size Error }---------------[UEIR, DFN8EF]---
      INT_Source  USB_DFN8_INT, UEIE,DFN8EE, _NoPriority
   
                ;----{ PID Check Failure }-------------------[UEIR, PIDEF]---
      INT_Source  USB_PID_INT, UEIE,PIDEE, _NoPriority
  endif


	ENDASM?


; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00415	asm  ; -- Ethernet sources --

	ASM?
  ; -- Ethernet sources --
  ifdef ETHIF  ;----{ Ethernet Module }----------------------[PIR2, ETHIF]---
      INT_Source  ETH_INT, PIE2,ETHIE, IPR2,ETHIP
   
               ;----{ DMA Interrupt }-------------------------[EIR, DMAIF]---
      INT_Source  ETH_DMA_INT, EIE,DMAIE, _NoPriority
   
               ;----{ Link Status Change }-------------------[EIR, LINKIF]---
      INT_Source  ETH_LINK_INT, EIE,LINKIE, _NoPriority
   
               ;----{ Receive Packet Pending }----------------[EIR, PKTIF]---
      INT_Source  ETH_PKT_INT, EIE,PKTIE, _NoPriority
   
               ;----{ Receive Error }------------------------[EIR, RXERIF]---
      INT_Source  ETH_RXER_INT, EIE,RXERIE, _NoPriority
              
               ;----{ Transmit Error }-----------------------[EIR, TXERIF]---
      INT_Source  ETH_TXER_INT, EIE,TXERIE, _NoPriority
   
               ;----{ Transmit }-------------------------------[EIR, TXIF]---
      INT_Source  ETH_TX_INT, EIE,TXIE, _NoPriority
  endif


	ENDASM?


; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00439	asm  ; -- CAN Module --

	ASM?
  ; -- CAN Module --
  ifdef WAKIF  
               ;----{ CAN bus Error }------------------------[PIR3, ERRIF]---
      INT_Source  CAN_ERR_INT, PIE3,ERRIE, IPR3,ERRIP
  
               ;----{ Invalid Received Message }-------------[PIR3, IRXIF]---
      INT_Source  CAN_IRX_INT, PIE3,IRXIE, IPR3,IRXIP
  
               ;----{ Receive Buffer 0 }------Mode 0--------[PIR3, RXB0IF]---
      INT_Source  CAN_RXB0_INT, PIE3,RXB0IE, IPR3,RXB0IP
               ;----{ FIFO Watermark }--------Mode 1, 2---[PIR3, FIFOWMIF]---
      INT_Source  CAN_FIFOWM_INT, PIE3,FIFOWMIE, IPR3,FIFOWMIP
  
               ;----{ Receive Buffer 1 }------Mode 0--------[PIR3, RXB1IF]---
      INT_Source  CAN_RXB1_INT, PIE3,RXB1IE, IPR3,RXB1IP
               ;----{ Any Receive Buffer }----Mode 1, 2-----[PIR3, RXBnIF]---
      INT_Source  CAN_RXBn_INT, PIE3,RXBnIE, IPR3,RXBnIP
  
               ;----{ Transmit Buffer 0 }-------------------[PIR3, TXB0IF]---
      INT_Source  CAN_TXB0_INT, PIE3,TXB0IE, IPR3,TXB0IP
  
               ;----{ Transmit Buffer 1 }-------------------[PIR3, TXB1IF]---
      INT_Source  CAN_TXB1_INT, PIE3,TXB1IE, IPR3,TXB1IP
  
               ;----{ Transmit Buffer 2 }-----Mode 0=-------[PIR3, TXB2IF]---
      INT_Source  CAN_TXB2_INT, PIE3,TXB2IE, IPR3,TXB2IP
               ;----{ Any Transmit Buffer }---Mode 1, 2-----[PIR3, TXBnIF]---
      INT_Source  CAN_TXBn_INT, PIE3,TXBnIE, IPR3,TXBnIP
  
               ;----{ CAN bus Activity Wake-up }-------------[PIR3, WAKIF]---
      INT_Source  CAN_WAKE_INT, PIE3,WAKIE, IPR3,WAKIP
  endif
  
  list
    endm
  list  


	ENDASM?


; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00478	ASM

	ASM?

    ifndef  USE_LOWPRIORITY
INT_ENTRY_L
        retfie
    else
        if (USE_LOWPRIORITY != 1)
INT_ENTRY_L
            retfie
        endif
    endif        


	ENDASM?


; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00491	Asm

	ASM?

asm = 0    ; Assembly language Interrupts
ASM = 0
Asm = 0
pbp = 1    ; Basic language interrupts
PBP = 1
Pbp = 1
YES = 1
yes = 1
Yes = 1
NO = 0
no = 0
No = 0
H equ 'H'  ; High Priority
h equ 'H'
L equ 'L'  ; Low Priority
l equ 'L'

  nolist
  
;_____________________________________________________________________________
SaveFSR  macro  F, Pr
  list
    if (F >= 0) && (F <= 2)
        if (Pr == H) || (Pr == L)
            movff    FSR#v(F)L, fsave#v(F)Pr
            movff    FSR#v(F)H, fsave#v(F)Pr + 1
          nolist
        else
            ERROR "SaveFSR - Invalid Priority"
        endif
    else
        ERROR "SaveFSR - Invalid FSR number"
    endif
    list
  endm


	ENDASM?


; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00530	Asm

	ASM?

RestFSR  macro  F, Pr
  list
    if (F >= 0) && (F <= 2)
        if (Pr == H) || (Pr == L)
            movff    fsave#v(F)Pr , FSR#v(F)L
            movff    fsave#v(F)Pr + 1 , FSR#v(F)H 
          nolist
        else
            ERROR "RestFSR - Invalid Priority"
        endif
    else
        ERROR "RestFSR - Invalid FSR number"
    endif
    list
  endm


	ENDASM?


; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00549	Asm

	ASM?

INT_FINISH_H   macro
  endm


	ENDASM?


; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00555	ASM

	ASM?

INT_CREATE_H  macro
  local OverCREATE
    goto OverCREATE
Priority = H    
INT_ENTRY_H  
    movff   PCLATU, psaveUH
    movff   PCLATH, psaveH
    SaveFSR  0, H
    SaveFSR  1, H
    SaveFSR  2, H
    bsf      _InHPint, 0
List_Start_H
    bcf      _Serviced_H, 0         ; Clear Serviced flag
    clrf  BSR
PREV_BANK = 0
    ifdef INT_LIST_H
        INT_LIST_H                  ; Expand the users list of HP INT handlers
    else
        ifdef INT_LIST
            INT_LIST                ; Expand the 16F Compatible List
        else
            error "INT_CREATE_H - INT_LIST or INT_LIST_H not found"
        endif
    endif
    btfsc    _Serviced_H,0          ; if anything was serviced
    goto     List_Start_H           ; go around, and check again

    ifdef ReEnterHPused             ; was ReEnterPBP-18.bas included
        GetAddress21  INT_EXIT_H, RetAddrH
        L?GOTO   _RestorePBP_H      ; Restore PBP system Vars
    endif

INT_EXIT_H
PREV_BANK = 0
    bcf      _InHPint, 0
    RestFSR  0, H                   ; Restore FSR0, if it was saved?
    RestFSR  1, H                   ; Restore FSR1, if it was saved?
    RestFSR  2, H                   ; Restore FSR2, if it was saved?
    movff    psaveH, PCLATH
    movff    psaveUH, PCLATU
    retfie    FAST                  ; Return from Interrupt
OverCREATE
    bsf   INTCON,GIE, 0             ; Enable High Priority Interrupts
    bsf   INTCON,PEIE, 0            ; Enable Peripheral Interrupts
  endm

;---[Stay compatible with the 14-bit version]---------------------------------
INT_CREATE  macro
    INT_CREATE_H
  endm


	ENDASM?


; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00609	ASM

	ASM?

INT_CREATE_L  macro
  local OverCREATE
    goto OverCREATE
    ifdef USE_LOWPRIORITY
        if (USE_LOWPRIORITY != 1)
       error "'DEFINE USE_LOWPRIORITY 1' required for Low Priority Interrupts"
        endif
    else
       error "'DEFINE USE_LOWPRIORITY 1' required for Low Priority Interrupts"
    endif
Priority = L
INT_ENTRY_L  
    movff   WREG, wsave             ; Wreg
    movff   STATUS, ssave           ; STATUS
    movff   BSR, bsave              ; BSR
    movff   PCLATU, psaveUL
    movff   PCLATH, psaveL
    SaveFSR  0, L                   ; FSR0
    SaveFSR  1, L                   ; FSR1
    SaveFSR  2, L                   ; FSR2
    bcf      _InHPint, 0    
List_Start_L
  clrf  BSR
PREV_BANK = 0
    bcf      _Serviced_L, 0
    ifdef INT_LIST_L
        INT_LIST_L                  ; Expand the users list of HP INT handlers
    else
        error "INT_CREATE_L - INT_LIST_L not defined, can not create"
    endif
    btfsc    _Serviced_L, 0         ; if anything was serviced
    goto     List_Start_L           ; go around, and check again

    ifdef ReEnterLPused             ; was ReEnterPBP-18LP.bas included
        GetAddress21  INT_EXIT_L, RetAddrL
        L?GOTO   _RestorePBP_L      ; Restore PBP system Vars
    endif

INT_EXIT_L
PREV_BANK = 0
    RestFSR  0, L                   ; Restore saved vars
    RestFSR  1, L
    RestFSR  2, L                
    movff   psaveUL, PCLATU
    movff   psaveL, PCLATH
    movff   bsave, BSR              ; BSR
    movff   wsave, WREG             ; WREG
    movff   ssave, STATUS           ; STATUS
    retfie                          ; Return from Interrupt
OverCREATE
    bsf   RCON,IPEN, 0              ; Enable Interrupt Priorities
    bsf   INTCON,GIEL, 0            ; Enable Low Priority Interrupts
  endm


	ENDASM?


; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00665	ASM

	ASM?

;---[Returns the Address of a Label as a Word]--(under 64K)------------------
GetAddress macro Label, Wout
    CHK?RP Wout
    movlw low Label          ; get low byte
    movwf Wout
    movlw High Label         ; get high byte
    movwf Wout + 1
    endm

;---[Returns the Address of a Label as a 3 byte array]---(under/over 64k)-----
GetAddress21 macro Label, Aout
    CHK?RP Aout
    movlw low Label          ; get low byte
    movwf Aout
    movlw high Label         ; get high byte
    movwf Aout + 1
    movlw upper Label        ; get upper byte
    movwf Aout + 2
    endm

;---[find correct bank for a PBP BIT variable]-------------------------------
CHKRP?T  macro reg, bit
        CHK?RP  reg
    endm
    


;---[find Assigned Priority for specified INT Source]------------------------
INT_Count = 0

FindIntPriority  macro IntFlagReg, IntFlagBit
  local LoopCount
    nolist
Pfound = 0
LoopCount = 1
      while LoopCount <= INT_Count
          if  (IntFlagReg == PrList#v(LoopCount)R)
             if (IntFlagBit == PrList#v(LoopCount)B)
  list
Priority =  PrList#v(LoopCount)Priority
Pfound = 1
             endif
          endif
LoopCount += 1
      endw
  endm  


	ENDASM?


; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00714	ASM

	ASM?


;---[Add an Interrupt Source to the user's list of INT Handlers]--------------
INT_Handler  macro  IntFlagReg, IntFlagBit, Label, Type, Reset
  list
    local AfterSave, AfterUser, NoInt
INT_Count += 1
PrList#v(INT_Count)R = IntFlagReg
PrList#v(INT_Count)B = IntFlagBit
PrList#v(INT_Count)Priority = Priority
        GetIntInfo   IntFlagReg, IntFlagBit
        if (Found == YES)
            btfss    INT_Enable_Reg, INT_Enable_Bit, 0  ; if INT is enabled
            goto   NoInt
            btfss    INT_Flag_Reg, INT_Flag_Bit, 0      ; and the Flag set?
            goto     NoInt
            if (Priority == H)
                bsf      _Serviced_H, 0
            else
                bsf      _Serviced_L, 0
            endif
            ifdef NO_CLRWDT
                if  (NO_CLRWDT != 1)
                    CLRWDT
                endif
            else
                CLRWDT
            endif
                
            if (Type == PBP)                         ; If INT handler is PBP
              if (Priority == H)
                ifdef ReEnterHPused
                    GetAddress21  AfterSave, RetAddrH  
                    L?GOTO  _SavePBP_H        ; Save PBP system Vars in HP INT
                else
    error "ReEnterPBP-18 must be INCLUDEd to use High Priority PBP interrupts"
                endif
              else ; Priority = L
                ifdef ReEnterLPused
                    GetAddress21  AfterSave, RetAddrL  
                    L?GOTO  _SavePBP_L        ; Save PBP system Vars in LP INT
                else
   error "ReEnterPBP-18LP must be INCLUDEd to use Low Priority PBP interrupts"
                endif
              endif
            endif
AfterSave
PREV_BANK = 0
            if (Priority == H)
                  GetAddress21  AfterUser, RetAddrH  
            else ; Priority = L
                  GetAddress21  AfterUser, RetAddrL
            endif  
            L?GOTO   Label                        ; goto the users INT handler
                    
AfterUser
PREV_BANK = 0
            if (Reset == YES)                      ; reset flag (if specified)
                bcf      INT_Flag_Reg, INT_Flag_Bit, 0 
            endif
        else
            error Interrupt Source (IntFlagReg,IntFlagBit) not found
        endif
NoInt
    clrf  BSR
PREV_BANK = 0
    endm


	ENDASM?


; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00783	asm

	ASM?

;---[Returns from a "goto" subroutine]--(21-bit RetAddr? must be set first)---
INT_RETURN  macro
  local Ret2LP, Ret2HP
      btfsc   _InHPint, 0
      goto    Ret2HP
Ret2LP
      movff   RetAddrL + 2, PCLATU  ; Load PC buffers with return address
      movff   RetAddrL + 1, PCLATH
      movf    RetAddrL, W, 0
    clrf  BSR                    ; Set to BANK0 before returning
PREV_BANK = 0                    ; Tell PBP about the BANK change
      movwf   PCL, 0             ; Go back to where we were
      
Ret2HP       
      movff   RetAddrH + 2, PCLATU ; Load PC buffers with return address
      movff   RetAddrH + 1, PCLATH
      movf    RetAddrH, W, 0
    clrf  BSR                    ; Set to BANK0 before returning
PREV_BANK = 0                    ; Tell PBP about the BANK change
      movwf   PCL, 0             ; Go back to where we were
    endm    
    
;---[Enable an interrupt source]----------------------------------------------
INT_ENABLE  macro  IntFlagReg, IntFlagBit
      GetIntInfo   IntFlagReg, IntFlagBit
      if (Found == YES)
          FindIntPriority  IntFlagReg, IntFlagBit
          if (Pfound == 1)
              if (INT_Priority_Reg != -1)
                  if (Priority == H)
                      bsf  INT_Priority_Reg, INT_Priority_Bit, 0
                  else
                      if (Priority == L)
                          bcf  INT_Priority_Reg, INT_Priority_Bit, 0
                      else
                          error "INT_ENABLE - Invalid Priority Specified"
                      endif
                  endif
              else
                  if (Priority == L)
                      error "INT0_INT can NOT be assigned to Low Priority"
                  endif
              endif
          else
              error "INT_ENABLE - Priority State Not Found"
          endif
;          bcf     INT_Flag_Reg, INT_Flag_Bit, 0        ; clear the flag first 
          bsf     INT_Enable_Reg, INT_Enable_Bit, 0    ; enable the INT source  
      else
          error  "INT_ENABLE - Interrupt Source not found!"
      endif
    endm    

;---[Disable an interrupt source]---------------------------------------------
INT_DISABLE  macro  IntFlagReg, IntFlagBit
      GetIntInfo   IntFlagReg, IntFlagBit
      if (Found == YES)
          bcf     INT_Enable_Reg, INT_Enable_Bit, 0   ; disable the INT source  
      else
          error "INT_DISABLE - Interrupt Source not found!"
      endif
    endm    

;---[Clear an interrupt Flag]-------------------------------------------------
INT_CLEAR  macro  IntFlagReg, IntFlagBit
      GetIntInfo   IntFlagReg, IntFlagBit
      if (Found == YES)
          bcf     INT_Flag_Reg, INT_Flag_Bit, 0       ; clear the INT flag
      else
          error "INT_CLEAR -  Interrupt Source not found!"
      endif
    endm



	ENDASM?


; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00860	ASM

	ASM?

Save_TBLPTR = 0

    ifdef SIN_USED
Save_TBLPTR = 1
    endif
    ifdef DTMFOUT_USED
Save_TBLPTR = 1
    endif
    ifdef SERDELAY_USED
Save_TBLPTR = 1
    endif
    ifdef CONVBIT_USED
Save_TBLPTR = 1
    endif
    ifdef ERASECODE_USED
Save_TBLPTR = 1
    endif
    ifdef READCODE_USED
Save_TBLPTR = 1
    endif
    ifdef WRITECODE_USED
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?BCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?BCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?BCLW
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?CCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?CCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?CCLW
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?WCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?WCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?WCLW
Save_TBLPTR = 1
    endif
    ifdef LOOK2_USED 
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?BCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?BCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?BCLW
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?CCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?CCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?CCLW
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?TCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?TCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?TCLW
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?WCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?WCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?WCLW
Save_TBLPTR = 1
    endif


	ENDASM?


; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00952	OVER_DT_INTS_18:

	LABEL?L	_OVER_DT_INTS_18	

; C:\PBP\COMMUNICATION\SLAVE1\DT_INTS-18.BAS	00954	ENABLE DEBUG
	DENABLE?	

; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00004	INCLUDE "ReEnterPBP-18.bas"

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00020	DISABLE DEBUG
	DDISABLE?	
; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00022	DEFINE   ReEnterHPused  1

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00024	VarsSaved_H = 0
	MOVE?CT	000h, _VarsSaved_H

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00026	goto OverReEnterH
	GOTO?L	_OverReEnterH

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00065	SavePBP_H:               ' Save all PBP system Vars High Priority

	LABEL?L	_SavePBP_H	

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00066	  if VarsSaved_H = 0 then
	CMPNE?TCL	_VarsSaved_H, 000h, L00001

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00067	    R0_SaveH = R0
	MOVE?WW	R0, _R0_SaveH

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00068	    R1_SaveH = R1
	MOVE?WW	R1, _R1_SaveH

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00069	    R2_SaveH = R2
	MOVE?WW	R2, _R2_SaveH

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00070	    R3_SaveH = R3
	MOVE?WW	R3, _R3_SaveH

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00071	    asm

	ASM?

        if (PBPLongs_Used == 1)
            MOVE?WW  R0+2, _R0_SaveH+2
            MOVE?WW  R1+2, _R1_SaveH+2
            MOVE?WW  R2+2, _R2_SaveH+2
            MOVE?WW  R3+2, _R3_SaveH+2
        endif
    

	ENDASM?


; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00079	    R4_SaveH = R4
	MOVE?WW	R4, _R4_SaveH

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00080	    R5_SaveH = R5
	MOVE?WW	R5, _R5_SaveH

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00081	    R6_SaveH = R6
	MOVE?WW	R6, _R6_SaveH

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00082	    R7_SaveH = R7
	MOVE?WW	R7, _R7_SaveH

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00083	    R8_SaveH = R8
	MOVE?WW	R8, _R8_SaveH

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00084	    Flags_SaveH = FLAGS
	MOVE?BB	FLAGS, _Flags_SaveH

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00085	    GOP_SaveH = GOP
	MOVE?BB	GOP, _GOP_SaveH

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00086	    RM1_SaveH = RM1
	MOVE?BB	RM1, _RM1_SaveH

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00087	    RM2_SaveH = RM2
	MOVE?BB	RM2, _RM2_SaveH

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00088	    RR1_SaveH = RR1
	MOVE?BB	RR1, _RR1_SaveH

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00089	    RR2_SaveH = RR2
	MOVE?BB	RR2, _RR2_SaveH

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00090	@ if Save_TBLPTR == 1

	ASM?
 if Save_TBLPTR == 1

	ENDASM?


; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00091	    TBLPTRU_SaveH = TBLPTRU
	MOVE?BB	TBLPTRU, _TBLPTRU_SaveH

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00092	    TBLPTRH_SaveH = TBLPTRH
	MOVE?BB	TBLPTRH, _TBLPTRH_SaveH

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00093	    TBLPTRL_SaveH = TBLPTRL
	MOVE?BB	TBLPTRL, _TBLPTRL_SaveH

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00094	@ endif

	ASM?
 endif

	ENDASM?


; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00095	    ASM

	ASM?

        ifdef RS1
            MOVE?BB    RS1, _RS1_SaveH
        endif
        ifdef RS2
            MOVE?BB    RS2, _RS2_SaveH
        endif
        ifdef MUL_USED
            MOVE?WW    PRODL, _Product_H
        endif
        ifdef T1
            MOVE?WW    T1, _T1_SaveH
            if (PBPLongs_Used == 1)
                MOVE?WW  T1+2, _T1_SaveH+2
            endif
        endif
        ifdef T2
            MOVE?WW    T2, _T2_SaveH
            if (PBPLongs_Used == 1)
                MOVE?WW  T2+2, _T2_SaveH+2
            endif
        endif
        ifdef T3
            MOVE?WW    T3, _T3_SaveH
            if (PBPLongs_Used == 1)
                MOVE?WW  T3+2, _T3_SaveH+2
            endif
        endif
        ifdef T4
            MOVE?WW    T4, _T4_SaveH
            if (PBPLongs_Used == 1)
                MOVE?WW  T4+2, _T4_SaveH+2
            endif
        endif
        ifdef T5
            MOVE?WW    T5, _T5_SaveH
            if (PBPLongs_Used == 1)
                MOVE?WW  T5+2, _T5_SaveH+2
            endif
        endif
        ifdef T6
            MOVE?WW    T6, _T6_SaveH
            if (PBPLongs_Used == 1)
                MOVE?WW  T6+2, _T6_SaveH+2
            endif
        endif
        ifdef T7
            MOVE?WW    T7, _T7_SaveH
            if (PBPLongs_Used == 1)
                MOVE?WW  T7+2, _T7_SaveH+2
            endif
        endif
    

	ENDASM?


; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00148	    VarsSaved_H = 1
	MOVE?CT	001h, _VarsSaved_H

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00149	  endif
	LABEL?L	L00001	

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00150	@ INT_RETURN

	ASM?
 INT_RETURN

	ENDASM?


; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00152	RestorePBP_H:

	LABEL?L	_RestorePBP_H	

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00153	  if VarsSaved_H = 1 then
	CMPNE?TCL	_VarsSaved_H, 001h, L00003

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00154	    R0 = R0_SaveH
	MOVE?WW	_R0_SaveH, R0

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00155	    R1 = R1_SaveH
	MOVE?WW	_R1_SaveH, R1

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00156	    R2 = R2_SaveH
	MOVE?WW	_R2_SaveH, R2

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00157	    R3 = R3_SaveH
	MOVE?WW	_R3_SaveH, R3

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00158	    asm

	ASM?

        if (PBPLongs_Used == 1)
            MOVE?WW  _R0_SaveH+2, R0+2
            MOVE?WW  _R1_SaveH+2, R1+2 
            MOVE?WW  _R2_SaveH+2, R2+2 
            MOVE?WW  _R3_SaveH+2, R3+2 
        endif
    

	ENDASM?


; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00166	    R4 = R4_SaveH
	MOVE?WW	_R4_SaveH, R4

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00167	    R5 = R5_SaveH
	MOVE?WW	_R5_SaveH, R5

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00168	    R6 = R6_SaveH
	MOVE?WW	_R6_SaveH, R6

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00169	    R7 = R7_SaveH
	MOVE?WW	_R7_SaveH, R7

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00170	    R8 = R8_SaveH
	MOVE?WW	_R8_SaveH, R8

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00171	    FLAGS = Flags_SaveH
	MOVE?BB	_Flags_SaveH, FLAGS

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00172	    GOP = GOP_SaveH
	MOVE?BB	_GOP_SaveH, GOP

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00173	    RM1 = RM1_SaveH
	MOVE?BB	_RM1_SaveH, RM1

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00174	    RM2 = RM2_SaveH
	MOVE?BB	_RM2_SaveH, RM2

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00175	    RR1 = RR1_SaveH
	MOVE?BB	_RR1_SaveH, RR1

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00176	    RR2 = RR2_SaveH
	MOVE?BB	_RR2_SaveH, RR2

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00177	@ if Save_TBLPTR == 1

	ASM?
 if Save_TBLPTR == 1

	ENDASM?


; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00178	    TBLPTRU = TBLPTRU_SaveH
	MOVE?BB	_TBLPTRU_SaveH, TBLPTRU

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00179	    TBLPTRH = TBLPTRH_SaveH
	MOVE?BB	_TBLPTRH_SaveH, TBLPTRH

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00180	    TBLPTRL = TBLPTRL_SaveH
	MOVE?BB	_TBLPTRL_SaveH, TBLPTRL

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00181	@ endif

	ASM?
 endif

	ENDASM?


; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00182	    ASM

	ASM?

        ifdef RS1
            MOVE?BB    _RS1_SaveH, RS1
        endif
        ifdef RS2
            MOVE?BB    _RS2_SaveH, RS2
        endif
        ifdef MUL
            MOVE?WW    _Product_H, PRODL
        endif
        ifdef T1
            MOVE?WW    _T1_SaveH, T1
            if (PBPLongs_Used == 1)
                MOVE?WW  _T1_SaveH+2, T1+2 
            endif
        endif
        ifdef T2
            MOVE?WW    _T2_SaveH, T2
            if (PBPLongs_Used == 1)
                MOVE?WW  _T2_SaveH+2, T2+2 
            endif
        endif
        ifdef T3
            MOVE?WW    _T3_SaveH, T3
            if (PBPLongs_Used == 1)
                MOVE?WW  _T3_SaveH+2, T3+2 
            endif
        endif
        ifdef T4
            MOVE?WW    _T4_SaveH, T4
            if (PBPLongs_Used == 1)
                MOVE?WW  _T4_SaveH+2, T4+2 
            endif
        endif
        ifdef T5
            MOVE?WW    _T5_SaveH, T5
            if (PBPLongs_Used == 1)
                MOVE?WW  _T5_SaveH+2, T5+2 
            endif
        endif
        ifdef T6
            MOVE?WW    _T6_SaveH, T6
            if (PBPLongs_Used == 1)
                MOVE?WW  _T6_SaveH+2, T6+2 
            endif
        endif
        ifdef T7
            MOVE?WW    _T7_SaveH, T7
            if (PBPLongs_Used == 1)
                MOVE?WW  _T7_SaveH+2, T7+2 
            endif
        endif
        ifdef T8
            ifndef NO_T7_WARNING
                messg "Temp variables exceeding T7"
            endif
        endif
    

	ENDASM?


; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00240	    VarsSaved_H = 0
	MOVE?CT	000h, _VarsSaved_H

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00241	  ENDIF
	LABEL?L	L00003	

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00242	@ INT_RETURN

	ASM?
 INT_RETURN

	ENDASM?


; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00244	OverReEnterH:

	LABEL?L	_OverReEnterH	

; C:\PBP\COMMUNICATION\SLAVE1\REENTERPBP-18.BAS	00245	ENABLE DEBUG
	DENABLE?	

; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00006	ADCON1=%00001111                            
	MOVE?CB	00Fh, ADCON1

; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00007	CMCON=%00000111         		     
	MOVE?CB	007h, CMCON

; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00020	i=1
	MOVE?CB	001h, _i

; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00022	SSPADD=$10         ' I2C Address: $01
	MOVE?CB	010h, SSPADD

; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00023	SSPCON1=$36
	MOVE?CB	036h, SSPCON1

; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00024	SSPCON2.0=1
	MOVE?CT	001h, _SSPCON2??0

; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00026	i2c_data[0]=1
	MOVE?CB	001h, _i2c_data

; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00027	i2c_data[1]=2
	MOVE?CB	002h, _i2c_data + 00001h

; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00028	i2c_data[2]=3
	MOVE?CB	003h, _i2c_data + 00002h

; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00029	i2c_data[3]=4
	MOVE?CB	004h, _i2c_data + 00003h

; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00030	i2c_data[4]=5
	MOVE?CB	005h, _i2c_data + 00004h

; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00031	i2c_data[5]=6
	MOVE?CB	006h, _i2c_data + 00005h

; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00035	i2c_data_index=0
	MOVE?CB	000h, _i2c_data_index

; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00037	ASM

	ASM?

INT_LIST  macro  
        INT_Handler SSP_INT, _i2c_int_handler, PBP, yes
    endm
    INT_CREATE          
    INT_ENABLE SSP_INT


	ENDASM?


; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00046	main:  

	LABEL?L	_main	

; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00048	goto main 
	GOTO?L	_main

; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00051	i2c_int_handler:

	LABEL?L	_i2c_int_handler	

; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00052	IF i2c_read then
	CMPF?TL	_i2c_read, L00005

; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00053	    dummy=SSPBUF
	MOVE?BB	SSPBUF, _dummy

; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00054	    IF i2c_buffer_full=0 THEN
	CMPNE?TCL	_i2c_buffer_full, 000h, L00007

; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00055	        SSPBUF=i2c_data[i2c_data_index]
	AOUT?BBB	_i2c_data, _i2c_data_index, SSPBUF

; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00056	        i2c_data_index=i2c_data_index+1
	ADD?BCB	_i2c_data_index, 001h, _i2c_data_index

; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00057	        IF i2c_data_index=6 THEN i2c_data_index=0
	CMPNE?BCL	_i2c_data_index, 006h, L00009
	MOVE?CB	000h, _i2c_data_index
	LABEL?L	L00009	

; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00058	    ENDIF
	LABEL?L	L00007	

; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00059	ENDIF
	LABEL?L	L00005	

; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00060	i2c_release_scl=1 
	MOVE?CT	001h, _i2c_release_scl

; C:\PBP\COMMUNICATION\SLAVE1\MASTER~1.PBP	00061	@ INT_RETURN

	ASM?
 INT_RETURN

	ENDASM?


	END
