'****************************************************************
'*  Name    : ELAPSED.PBP                                       *
'*  Author  : Darrel Taylor                                     *
'*  Notice  : Copyright (c) 2003                                *
'*  Date    : 12/16/2003                                        *
'*  Notes   :                                                   *
'****************************************************************
disable debug

Define  INTHAND _ClockCount    ' Tell PBP Where the code starts on an interrupt
Include "ASM_INTS-18.bas"         ' ASM Interrupt Stubs

Ticks    var byte   ' 1/100th of a second
Seconds  var byte
Minutes  var byte
Hours    var byte
Days     var word
R0save   var word
R1save   var word
R4save   var word

SecondsChanged   var bit
MinutesChanged   var bit
HoursChanged     var bit
DaysChanged      var bit
SecondsChanged = 1
MinutesChanged = 1

Goto OverElapsed

' ------------------------------------------------------------------------------
Asm
  IF OSC == 4                       ; Constants for 100hz interrupt from Timer1
TimerConst = 0D8F7h                 ; Executed at compile time only
  EndIF
  If OSC == 8
TimerConst = 0B1E7h
  EndIF
  If OSC == 10
TimerConst = 09E5Fh
  EndIF
  If OSC == 20
TimerConst = 03CB7h
  EndIF
  If OSC == 40
TimerConst = 03CB7h
  EndIF

; -----------------  ADD TimerConst to TMR1H:TMR1L
ADD2_TIMER   macro
    CHK?RP  T1CON
    BCF     T1CON,TMR1ON           ; Turn off timer
    MOVLW   LOW(TimerConst)        ;  1
    ADDWF   TMR1L,F                ;  1    ; reload timer with correct value
    BTFSC   STATUS,C               ;  1/2
    INCF    TMR1H,F                ;  1
    MOVLW   HIGH(TimerConst)       ;  1
    ADDWF   TMR1H,F                ;  1
    endm

; -----------------  ADD TimerConst to TMR1H:TMR1L and restart TIMER1
RELOAD_TIMER  macro
    ADD2_TIMER
    BSF     T1CON,TMR1ON           ;  1    ; Turn TIMER1 back on
    CHK?RP  PIR1
    bcf     PIR1, TMR1IF           ; Clear Timer1 Interrupt Flag
    endm

; -----------------  Load TimerConst into TMR1H:TMR1L
LOAD_TIMER  macro
EndAsm
    T1CON.0 = 0                    ; Turn OFF Timer1
    TMR1L = 0
    TMR1H = 0
Asm
    ADD2_TIMER
    endm
EndAsm

' ------[ This is the Interrupt Handler ]---------------------------------------
ClockCount:   ' Note: this is being handled as an ASM interrupt
@ INT_START
@ RELOAD_TIMER                    ; Reload TIMER1
  R0save = R0                     ; Save 2 PBP system vars that are used during
  R1save = R1                     ; the interrupt
  R4save = R4
    Ticks = Ticks + 1
    if Ticks = 100 then
       Ticks = Ticks-100
       Seconds = Seconds + 1
       SecondsChanged = 1
       if Seconds = 60 then
          Minutes = Minutes + 1
          MinutesChanged = 1
          Seconds = 0
       endif
       if Minutes = 60 then
          Hours = Hours + 1
          HoursChanged = 1
          Minutes = 0
       endif
       if Hours = 24 then
          Days = Days + 1
          DaysChanged = 1
          Hours = 0
       endif
    endif
  R4 = R4save                     ; Restore the PBP system vars
  R1 = R1save
  R0 = R0save
@ INT_RETURN                      ; Restore context and return from interrupt

'-----====[ END OF TMR1 Interrupt Handler ]====---------------------------------

StartTimer:
    T1CON.1 = 0                   ; (TMR1CS) Select FOSC/4 Clock Source
    T1CON.3 = 0                   ; (T1OSCEN) Disable External Oscillator
    PIR1.0  = 0                   ; (TMR1IF) Clear Timer1 Interrupt Flag
    PIE1.0  = 1                   ; (TMR1IE) Enable TMR1 overflow interrupt
    INTCON.6 = 1                  ; (PEIE) Enable peripheral interrupts
    INTCON.7 = 1                  ; (GIE) Enable global interrupts
    T1CON.0 = 1                   ; (TMR1ON) Start TIMER1
@ if OSC == 40
    T1CON.5 = 0                   ; Prescaler = 1:2
    T1CON.4 = 1
@ endif
return

; -----------------
StopTimer:
    T1CON.0 = 0                   ; Turn OFF Timer1
return

; -----------------
ResetTime:
    R0save = T1CON.0              ; Save TMR1ON bit
    T1CON.0 = 0                   ; Turn OFF Timer1
    TMR1L = 0
    TMR1H = 0
@   LOAD_TIMER                    ; Load TimerConst
    T1CON.0 = R0save              ; Restore TMR1ON bit
    Ticks = 0
    Seconds = 0
    Minutes = 0
    Hours = 0
    Days = 0
    SecondsChanged = 1
return

OverElapsed:
enable debug


