;User defined variables
;---------------------------------------------------------------------------------------
;Oscillator frequency
#define OSCILLATOR	d'20000000'
;---------------------------------------------------------------------------------------
;Timer0 prescaler
#define	TIMER0_PRESCALE	d'16'
;---------------------------------------------------------------------------------------
;number of entries in the sine table, or the sampling frequency
#define	SINE_TABLE_ENTRIES	d'19'
;---------------------------------------------------------------------------------------
SAMPLES_PER_CYCLE = (SINE_TABLE_ENTRIES-1)*d'2'
INSTRUCTION_CYCLE = (OSCILLATOR)/d'4'
FREQUENCY_SCALE = (INSTRUCTION_CYCLE/SAMPLES_PER_CYCLE)/(TIMER0_PRESCALE/4)
;Timer prescale/4 is done to compensate ADC multiplication factor of 4 to the frequency)
;---------------------------------------------------------------------------------------
;PWM frequency definition
#define TIMER2_PRESCALE	d'01'
#define	PWM_FREQUENCY	d'20000'
;#define	PWM_FREQUENCY	d'16000'
PR2_VALUE = (OSCILLATOR/(4*PWM_FREQUENCY*TIMER2_PRESCALE))-1
;---------------------------------------------------------------------------------------
;ADC initialization
#define	Fosc_by_2	b'000'
#define	Fosc_by_8	b'001'
#define	Fosc_by_32	b'010'
#define	FRC		b'011'
#define	Fosc_by_4	b'100'
#define	Fosc_by_16	b'101'
#define	Fosc_by_64	b'110'

#define	ADC_CLOCK	Fosc_by_32
#define	ADC_CHANNEL	d'0'
#define	ADC_ON_BIT	b'1'
#define LEFT_JUSTIFIED
#define	ADC_PORT_CONFIG	b'1110'	;Refer the table in the manual for selection

ADCON0_VALUE = ((ADC_CLOCK<<6)|(ADC_CHANNEL<<4)|(ADC_ON_BIT))

	if ((ADC_CLOCK==Fosc_by_2)||(ADC_CLOCK ==Fosc_by_8)||(ADC_CLOCK ==Fosc_by_32)||(ADC_CLOCK==FRC))
	ifndef	LEFT_JUSTIFIED
ADCON1_VALUE = ((1<<7) | (ADC_PORT_CONFIG))
	else
ADCON1_VALUE = ADC_PORT_CONFIG
	endif
	endif
	if	((ADC_CLOCK==Fosc_by_4)||(ADC_CLOCK==Fosc_by_16)||(ADC_CLOCK==Fosc_by_64)) 	
	ifndef	LEFT_JUSTIFIED
ADCON1_VALUE = ((1<<7) |(1<<6)| (ADC_PORT_CONFIG))
	else
ADCON1_VALUE = ( (1<<6)| (ADC_PORT_CONFIG))
	endif
	endif
;---------------------------------------------------------------------------------------

