;This routine dispalys few key parameters on Hyper terminal. 
;Baud rate set to 9600
;Parameters displayed can be changed in the main motor control program
;After debugging, this program can be removed from the motor control project

; Author : Padmaraja Yedamale, Microchip Technology Inc
;	Modified by: Jon Burroughs, for ACIM application
;	Version : 1.0-ACIM
;----------------------------------------------------------------


	include		"P18F4431.inc"

;----------------------------------------------------------------
	UDATA_ACS
DISPLAY_TARGET_FREQ			res	1
DISPLAY_ROTOR_FREQ_U		res	1
DISPLAY_ROTOR_FREQ_L		res	1
DISPLAY_SLIP_FREQ_U			res	1
DISPLAY_SLIP_FREQ_L			res	1
DISPLAY_SLIP_PERCENTAGE		res	1
DISPLAY_PID_PERCENTAGE		res	1
DISPLAY_DRIVE_FREQ			res	1
DISPLAY_PID_FLAGS			res	1
#define DIRECTION_CMD 4

DISPLAY_TEMP1				res 1
DISPLAY_TEMP2				res 1
;----------------------------------------------------------------
	GLOBAL	DISPLAY_TARGET_FREQ
	GLOBAL	DISPLAY_ROTOR_FREQ_U
	GLOBAL	DISPLAY_ROTOR_FREQ_L
	GLOBAL	DISPLAY_SLIP_FREQ_U
	GLOBAL	DISPLAY_SLIP_FREQ_L
	GLOBAL	DISPLAY_SLIP_PERCENTAGE
	GLOBAL	DISPLAY_PID_PERCENTAGE
	GLOBAL	DISPLAY_DRIVE_FREQ
	GLOBAL	DISPLAY_PID_FLAGS
	GLOBAL	DISPLAY_TEMP1
;----------------------------------------------------------------
	GLOBAL	WELCOME_MESSAGE	
	GLOBAL	SEND_BYTE_FROM_WREG
	GLOBAL	INITIALIZE_SERIAL_PORT
	GLOBAL	DISPLAY_PARAMETERS
	GLOBAL	DISPLAY_DIGITS
;*******************************************************************************
PRG1 code
;*******************************************************************
;This routine initializes USART parameters 
;******************************************************************
INITIALIZE_SERIAL_PORT

	movlw	0x81		;Baudrate = 9600
	movwf	SPBRG
	
	movlw	0x24		;8-bit transmission;Enable Transmission;	
	movwf	TXSTA		;Asynchronous mode with High speed transmission
	
	movlw	0x90		;Enable the serial port
	movwf	RCSTA		;with 8-bit continuous reception

	bcf	TRISC,6
	bsf	TRISC,7

	return


;*******************************************************************************
;This routine loads the data in Wreg to Transmission register(TXREG) after checking
;of completion of previously loaded byte transmission
;*******************************************************************************
SEND_BYTE_FROM_WREG
	btfss	PIR1,TXIF
	goto	SEND_BYTE_FROM_WREG
	movwf	TXREG
	return

;*******************************************************************************
;This routine intializes the USART module to communicate with host PC and displays 
;a welcome message on the screen
;*******************************************************************************
WELCOME_MESSAGE
	movlw	UPPER WELCOME_TABLE	;Initialize Table pointer to the first  
	movwf	TBLPTRU				;location of the table
	movlw	HIGH WELCOME_TABLE
	movwf	TBLPTRH
	movlw	LOW WELCOME_TABLE
	movwf	TBLPTRL
SEND_NEXT_W1
	TBLRD*+
	movf	TABLAT,W
	btfsc	STATUS,Z
	return
	call	SEND_BYTE_FROM_WREG
	bra		SEND_NEXT_W1	

WELCOME_TABLE ;"ACIM Motor Control"
	db	0xA, 0xA,0xD,0x41,0x43,0x49,0x4D,0x20,0x4D,0x6F,0x74,0x6F,0x72,0x20,0x43,0x6F,0x6E,0x74,0x72,0x6F,0x6C,0x0A,0x0D,0x00
;*******************************************************************************
;DISPLAY_TARGET_FREQ
;DISPLAY_ROTOR_FREQ_UPPER
;DISPLAY_ROTOR_FREQ_LOWER
;DISPLAY_SLIP_FREQ_UPPER
;DISPLAY_SLIP_FREQ_LOWER	
;DISPLAY_SLIP_PERCENTAGE
;DISPLAY_PID_PERCENTAGE
;DISPLAY_DRIVE_FREQ
;DISPLAY_PID_FLAGS



DISPLAY_PARAMETERS
	call	PARAMETER_ZERO
	movff	DISPLAY_TARGET_FREQ,DISPLAY_TEMP1
	call	DISPLAY_DIGITS
	
	call	PARAMETER_ONE
	movff	DISPLAY_ROTOR_FREQ_U,DISPLAY_TEMP1
	call	DISPLAY_DIGITS
	movff	DISPLAY_ROTOR_FREQ_L,DISPLAY_TEMP1
	call	DISPLAY_DIGITS
	
	call	PARAMETER_TWO
	btfss	DISPLAY_PID_FLAGS, DIRECTION_CMD
	bra		DISP_REV2
	call	DISPLAY_FORWARD
	bra		NEXT_PARA_DISPLAY3
DISP_REV2	
	call	DISPLAY_REVERSE
	
NEXT_PARA_DISPLAY3	
	call	PARAMETER_THREE
	btfss	QEICON,5
	bra		DISP_REV3
	call	DISPLAY_FORWARD
	bra		NEXT_PARA_DISPLAY4
DISP_REV3
	call	DISPLAY_REVERSE
	
NEXT_PARA_DISPLAY4
	call	PARAMETER_FOUR
	movff	DISPLAY_SLIP_FREQ_U,DISPLAY_TEMP1
	call	DISPLAY_DIGITS
	movff	DISPLAY_SLIP_FREQ_L,DISPLAY_TEMP1
	call	DISPLAY_DIGITS 
	
	call	PARAMETER_FIVE
	movff	DISPLAY_SLIP_PERCENTAGE,DISPLAY_TEMP1
	call	DISPLAY_DIGITS 
	
	call	PARAMETER_SIX
	movff	DISPLAY_PID_PERCENTAGE,DISPLAY_TEMP1
	call	DISPLAY_DIGITS 
	 
	call	PARAMETER_SEVEN
	movff	DISPLAY_DRIVE_FREQ,DISPLAY_TEMP1
	call	DISPLAY_DIGITS
	
	call	PARAMETER_EIGHT
	movff	DISPLAY_PID_FLAGS,DISPLAY_TEMP1
	call	DISPLAY_DIGITS
		
	return

;******************************************************************************
;TargFreq= 
PARAMETER_ZERO
	movlw	UPPER PARAMETER_0	;Initialize Table pointer to the first  
	movwf	TBLPTRU				;location of the table
	movlw	HIGH PARAMETER_0
	movwf	TBLPTRH
	movlw	LOW PARAMETER_0
	movwf	TBLPTRL
SEND_NEXT_P0
	TBLRD*+
	movf	TABLAT,W
	btfsc	STATUS,Z
	return
	call	SEND_BYTE_FROM_WREG
	bra		SEND_NEXT_P0	

PARAMETER_0	;	TargFreq= 
	db	0xA,0xA,0xD,0x54,0x61,0x72,0x67,0x46,0x72,0x65,0x71,0x3D,0x20,0x00
;*******************************************************************************
;RotorFreq= 
PARAMETER_ONE
	movlw	UPPER PARAMETER_1	;Initialize Table pointer to the first  
	movwf	TBLPTRU				;location of the table
	movlw	HIGH PARAMETER_1
	movwf	TBLPTRH
	movlw	LOW PARAMETER_1
	movwf	TBLPTRL
SEND_NEXT_P1
	TBLRD*+
	movf	TABLAT,W
	btfsc	STATUS,Z
	return
	call	SEND_BYTE_FROM_WREG
	bra		SEND_NEXT_P1

PARAMETER_1	;	RotorFreq = 
	db	0xA,0xD,0x52,0x6f,0x74,0x6f,0x72,0x46,0x72,0x65,0x71,0x3D,0x20,0x00
	
;*******************************************************************************
;Ref motor direction : Direction Command :  
PARAMETER_TWO
	movlw	UPPER PARAMETER_2	;Initialize Table pointer to the first  
	movwf	TBLPTRU				;location of the table
	movlw	HIGH PARAMETER_2
	movwf	TBLPTRH
	movlw	LOW PARAMETER_2
	movwf	TBLPTRL
SEND_NEXT_P2
	TBLRD*+
	movf	TABLAT,W
	btfsc	STATUS,Z
	return
	call	SEND_BYTE_FROM_WREG
	bra		SEND_NEXT_P2

PARAMETER_2	;	Direction Command :  
	db	0xA,0xD,0x44,0x69,0x72,0x65,0x63,0x74,0x69,0x6f,0x6e,0x20,0x43,0x6d,0x64,0x20,0x3a,0x00
		
;*******************************************************************************
;Actual motor direction : Direction Act :  
PARAMETER_THREE
	movlw	UPPER PARAMETER_3	;Initialize Table pointer to the first  
	movwf	TBLPTRU				;location of the table
	movlw	HIGH PARAMETER_3
	movwf	TBLPTRH
	movlw	LOW PARAMETER_3
	movwf	TBLPTRL
SEND_NEXT_P3
	TBLRD*+
	movf	TABLAT,W
	btfsc	STATUS,Z
	return
	call	SEND_BYTE_FROM_WREG
	bra		SEND_NEXT_P3

PARAMETER_3	;	Direction Act :  
	db	0xA,0xD,0x44,0x69,0x72,0x65,0x63,0x74,0x69,0x6f,0x6e,0x20,0x41,0x63,0x74,0x20,0x3a,0x00

;*******************************************************************************
;SlipFreq=   
PARAMETER_FOUR
	movlw	UPPER PARAMETER_4	;Initialize Table pointer to the first  
	movwf	TBLPTRU				;location of the table
	movlw	HIGH PARAMETER_4
	movwf	TBLPTRH
	movlw	LOW PARAMETER_4
	movwf	TBLPTRL
SEND_NEXT_P4
	TBLRD*+
	movf	TABLAT,W
	btfsc	STATUS,Z
	return
	call	SEND_BYTE_FROM_WREG
	bra		SEND_NEXT_P4

PARAMETER_4	;SlipFreq=   
	db	0xA,0xD,0x53,0x6c,0x69,0x70,0x46,0x72,0x65,0x71,0x3D,0x20,0x00
;*******************************************************************************
;Slip % =   
PARAMETER_FIVE
	movlw	UPPER PARAMETER_5	;Initialize Table pointer to the first  
	movwf	TBLPTRU				;location of the table
	movlw	HIGH PARAMETER_5
	movwf	TBLPTRH
	movlw	LOW PARAMETER_5
	movwf	TBLPTRL
SEND_NEXT_P5
	TBLRD*+
	movf	TABLAT,W
	btfsc	STATUS,Z
	return
	call	SEND_BYTE_FROM_WREG
	bra		SEND_NEXT_P5

PARAMETER_5	;	Slip % =   
	db	0xA,0xD,0x53,0x6c,0x69,0x70,0x20,0x25,0x20,0x3D,0x20,0x00
;*******************************************************************************
;PID % =   
PARAMETER_SIX
	movlw	UPPER PARAMETER_6	;Initialize Table pointer to the first  
	movwf	TBLPTRU				;location of the table
	movlw	HIGH PARAMETER_6
	movwf	TBLPTRH
	movlw	LOW PARAMETER_6
	movwf	TBLPTRL
SEND_NEXT_P6
	TBLRD*+
	movf	TABLAT,W
	btfsc	STATUS,Z
	return
	call	SEND_BYTE_FROM_WREG
	bra		SEND_NEXT_P6

PARAMETER_6	;	PID % =    
	db	0xA,0xD,0x50,0x49,0x44,0x20,0x25,0x20,0x3d,0x20,0x00

;*******************************************************************************
;DriveFreq =  
PARAMETER_SEVEN
	movlw	UPPER PARAMETER_7	;Initialize Table pointer to the first  
	movwf	TBLPTRU				;location of the table
	movlw	HIGH PARAMETER_7
	movwf	TBLPTRH
	movlw	LOW PARAMETER_7
	movwf	TBLPTRL
SEND_NEXT_P7
	TBLRD*+
	movf	TABLAT,W
	btfsc	STATUS,Z
	return
	call	SEND_BYTE_FROM_WREG
	bra		SEND_NEXT_P7

PARAMETER_7	;	DriveFreq = 
	db	0xA,0xD,0x44,0x72,0x69,0x76,0x65,0x46,0x72,0x65,0x71,0x3D,0x20,0x00

;*******************************************************************************
;PIDFlags =
PARAMETER_EIGHT
	movlw	UPPER PARAMETER_8	;Initialize Table pointer to the first  
	movwf	TBLPTRU				;location of the table
	movlw	HIGH PARAMETER_8
	movwf	TBLPTRH
	movlw	LOW PARAMETER_8
	movwf	TBLPTRL
SEND_NEXT_P8
	TBLRD*+
	movf	TABLAT,W
	btfsc	STATUS,Z
	return
	call	SEND_BYTE_FROM_WREG
	bra		SEND_NEXT_P8

PARAMETER_8	;	PIDFlags = 
	db	0xA,0xD,0x50,0x49,0x44,0x46,0x6c,0x61,0x67,0x73,0x3D,0x20,0x00


;*******************************************************************************
;Misc display: ParaX3 =  (EI) 
PARAMETER_NINE
	movlw	UPPER PARAMETER_9	;Initialize Table pointer to the first  
	movwf	TBLPTRU				;location of the table
	movlw	HIGH PARAMETER_9
	movwf	TBLPTRH
	movlw	LOW PARAMETER_9
	movwf	TBLPTRL
SEND_NEXT_P9
	TBLRD*+
	movf	TABLAT,W
	btfsc	STATUS,Z
	return
	call	SEND_BYTE_FROM_WREG
	bra		SEND_NEXT_P9

PARAMETER_9	;	ParaX2= 
;	db	0xA,0xD,0x50,0x61,0x72,0x61,0x58,0x32,0x20,0x3d,0x20,0x00
	db	0xA,0xD,0x45,0x49,0x00
	
;*******************************************************************************
;Misc display: ParaX2 =  (EO) 
PARAMETER_TEN
	movlw	UPPER PARAMETER_10	;Initialize Table pointer to the first  
	movwf	TBLPTRU				;location of the table
	movlw	HIGH PARAMETER_10
	movwf	TBLPTRH
	movlw	LOW PARAMETER_10
	movwf	TBLPTRL
SEND_NEXT_P10
	TBLRD*+
	movf	TABLAT,W
	btfsc	STATUS,Z
	return
	call	SEND_BYTE_FROM_WREG
	bra		SEND_NEXT_P10

PARAMETER_10	;	ParaX2= 
;	db	0xA,0xD,0x50,0x61,0x72,0x61,0x58,0x32,0x20,0x3d,0x20,0x00
	db	0xA,0xD,0x45,0x4F,0x00	
;*******************************************************************************
;Display: FORWARD   
DISPLAY_FORWARD
	movlw	UPPER DISP_FORWARD	;Initialize Table pointer to the first  
	movwf	TBLPTRU				;location of the table
	movlw	HIGH DISP_FORWARD
	movwf	TBLPTRH
	movlw	LOW DISP_FORWARD
	movwf	TBLPTRL
SEND_NEXT_FWD
	TBLRD*+
	movf	TABLAT,W
	btfsc	STATUS,Z
	return
	call	SEND_BYTE_FROM_WREG
	bra		SEND_NEXT_FWD

DISP_FORWARD	;	FORWARD 
	db	0x46,0x4F,0x52,0x57,0x41,0x52,0x44,0x00					
;*******************************************************************************
;Display: REVERSE   
DISPLAY_REVERSE   
	movlw	UPPER DISP_REVERSE   	;Initialize Table pointer to the first  
	movwf	TBLPTRU				;location of the table
	movlw	HIGH DISP_REVERSE   
	movwf	TBLPTRH
	movlw	LOW DISP_REVERSE   
	movwf	TBLPTRL
SEND_NEXT_REVERSE   
	TBLRD*+
	movf	TABLAT,W
	btfsc	STATUS,Z
	return
	call	SEND_BYTE_FROM_WREG
	bra		SEND_NEXT_REVERSE   

DISP_REVERSE   	;REVERSE    
	db	0x52,0x45,0x56,0x45,0x52,0x53,0x45,0x00		
;---------------------------------------------------------
DISPLAY_DIGITS
	movf	DISPLAY_TEMP1,W
	andlw	0xF0
	swapf	WREG,W
	addlw	0x30	
	call	CHECK_39
	call	SEND_BYTE_FROM_WREG
	movf	DISPLAY_TEMP1,W
	andlw	0x0F
	addlw	0x30	
	call	CHECK_39
	call	SEND_BYTE_FROM_WREG
	RETURN
;------------------------------
CHECK_39
	movwf	DISPLAY_TEMP2
	movlw	0x39
	cpfsgt	DISPLAY_TEMP2
	bra		LESS_39
	movf	DISPLAY_TEMP2,W
	addlw	0x7
	return
LESS_39
	movf	DISPLAY_TEMP2,W
	return
		
	end
