@ DEVICE pic16F628A, INTRC_OSC, WDT_OFF, PWRT_OFF, BOD_OFF, MCLR_ON, LVP_OFF, CPD_OFF, PROTECT_OFF 

   
;   Include "modedefs.bas"   ' Serial Protocol
   Define   OSC 4           ' 4MHz 
   CMCON = 7                ' Disable on-chip comparator, PORTA in digital mode
              
   '// Define port pins as inputs and outputs ...
TRISA  = %00000111
PORTB.7=0
TRISB.7=0

include "c:\pbp\keypad2.pbp" ' see http://www.picbasic.co.uk/forum/showthread.php?t=3250

'------------------------------------------------------------------------
StartH CON %11010111        ' High 8 bits of start frame
StartM CON %11011011        ' Middle 8 nits of start frame
StartL CON %10101011        ' Low 8 bits of start frame
'------------------------------------------------------------------------
VolUpH CON %11011011        ' High 8 bits of command
VolUpM CON %11010110        ' Middle 8 nits of command
VolUpL CON %11010101        ' Low bit of command + 7bits END of frame
'------------------------------------------------------------------------
VolDnH CON %01101101        ' High 8 bits of command
VolDnM CON %11110110        ' Middle 8 nits of command
VolDnL CON %11010101        ' Low bit of command + 7bits END of frame 
'------------------------------------------------------------------------
ByteArray VAR BYTE[6]       ' 6 bytes = 48bits
BitCount  VAR BYTE          ' Index variable for above array
i         VAR BYTE          ' General purpose
'------------------------------------------------------------------------
' Initialise the first three bytes of the array, these are static.
ByteArray[0] = StartH 
ByteArray[1] = StartM
ByteArray[2] = StartL
    
Pause 1000


main:
gosub keypadscan
gosub check
goto main


check:
select case key 
CASE 1  ; volume down
GOSUB VolumeDn
   
case 3	; volume up
GOSUB VolumeUp
   
end select
Pause 500 ' do it for 0.5 sec
Return


'------------------------------------------------------------------------
' Subroutines follows:
'------------------------------------------------------------------------    
VolumeUp:
    ' Set non static part of array to current command.
    ByteArray[3] = VolUpH
    ByteArray[4] = VolUpM
    ByteArray[5] = VolUpL
    GOSUB SendIt
RETURN
'------------------------------------------------------------------------
VolumeDn:
    ByteArray[3] = VolDnH
    ByteArray[4] = VolDnM
    ByteArray[5] = VolDnL
    GOSUB SendIt
RETURN
'------------------------------------------------------------------------   
SendIt:
    FOR BitCount = 0 to 47
        If ByteArray.0[BitCount] = 1 THEN
            GOSUB One
        ELSE
            GOSUB Zero
        ENDIF
    NEXT
RETURN
'------------------------------------------------------------------------
One:
    PORTB.7 = 1
    PAUSEUS 500
    PORTB.7 = 0
    PAUSEUS 500
RETURN
'------------------------------------------------------------------------
Zero:
    PortB.7 = 0
    PAUSEUS 1000
RETURN


end 'of story !
  
