
; PICBASIC PRO(TM) Compiler 2.50a, (c) 1998, 2007 microEngineering Labs, Inc. All Rights Reserved.  
PM_USED			EQU	1

	INCLUDE	"16F628A.INC"


; Define statements.
#define		OSC		 4           

RAM_START       		EQU	00020h
RAM_END         		EQU	0014Fh
RAM_BANKS       		EQU	00003h
BANK0_START     		EQU	00020h
BANK0_END       		EQU	0007Fh
BANK1_START     		EQU	000A0h
BANK1_END       		EQU	000EFh
BANK2_START     		EQU	00120h
BANK2_END       		EQU	0014Fh
EEPROM_START    		EQU	02100h
EEPROM_END      		EQU	0217Fh

R0              		EQU	RAM_START + 000h
R1              		EQU	RAM_START + 002h
R2              		EQU	RAM_START + 004h
R3              		EQU	RAM_START + 006h
R4              		EQU	RAM_START + 008h
R5              		EQU	RAM_START + 00Ah
R6              		EQU	RAM_START + 00Ch
R7              		EQU	RAM_START + 00Eh
R8              		EQU	RAM_START + 010h
FLAGS           		EQU	RAM_START + 012h
GOP             		EQU	RAM_START + 013h
RM1             		EQU	RAM_START + 014h
RM2             		EQU	RAM_START + 015h
RR1             		EQU	RAM_START + 016h
RR2             		EQU	RAM_START + 017h
_ByteArray       		EQU	RAM_START + 018h
T1              		EQU	RAM_START + 01Eh
T2              		EQU	RAM_START + 020h
_BitCount        		EQU	RAM_START + 022h
_Col             		EQU	RAM_START + 023h
_i               		EQU	RAM_START + 024h
_Key             		EQU	RAM_START + 025h
_KeyTemp         		EQU	RAM_START + 026h
_Row             		EQU	RAM_START + 027h
_RowBit          		EQU	RAM_START + 028h
_PORTL           		EQU	 PORTB
_PORTH           		EQU	 PORTA
_TRISL           		EQU	 TRISB
_TRISH           		EQU	 TRISA
#define _PORTB??7        	 PORTB, 007h
#define _TRISB??7        	 TRISB, 007h
#define _KB_ROW_PORT??0  	 KB_ROW_PORT, 000h
#define _KeyTemp??0      	_KeyTemp, 000h
#define _ByteArray??0    	_ByteArray, 000h

; Constants.
_StartH          		EQU	000D7h
_StartM          		EQU	000DBh
_StartL          		EQU	000ABh
_VolUpH          		EQU	000DBh
_VolUpM          		EQU	000D6h
_VolUpL          		EQU	000D5h
_VolDnH          		EQU	0006Dh
_VolDnM          		EQU	000F6h
_VolDnL          		EQU	000D5h
	INCLUDE	"ALPINE.MAC"
	INCLUDE	"PBPPIC14.LIB"


	ASM?
 DEVICE pic16F628A, INTRC_OSC, WDT_OFF, PWRT_OFF, BOD_OFF, MCLR_ON, LVP_OFF, CPD_OFF, PROTECT_OFF 

	ENDASM?

	MOVE?CB	007h, CMCON
	MOVE?CB	007h, TRISA
	MOVE?CT	000h, _PORTB??7
	MOVE?CT	000h, _TRISB??7
	DDISABLE?	

	ASM?

;        errorlevel 0,-207                                  ; Disable 'found opcode after...' warning

    ;
    ;    Macro Definition
    ;    ================
READKEYPAD macro KeyVar
               L?CALL _KeypadScan
               MOVE?BB _Key,KeyVar
               endm

    ;
    ;    Default settings
    ;    ================
KB_ROW        = 3                                      ; 4 ROW keypad
KB_ROW_PORT   = PORTA                                  ; Keypad ROW on PORTB
KB_ROW_BIT    = 0                                      ; ROW0 = PORTB.0
KB_COL        = 2                                      ; 4 COL keypad
KB_COL_PORT   = PORTB                                  ; Keypad Col on PORTB
KB_COL_BIT    = 0                                      ; COL0 = PORTB.4
DebounceDelay = 0x200                                  ; debounce delay 200mSec
SINGLE_SCAN   = 0                                      ; Scan ;till a key is pressed   
KEYPAD_AUTOREPEAT = 1      
    ;
    ;    Software Definition
    ;    ===================
         ;
         ;    Keypad type definition
         ;    ----------------------
    ifdef KEYPAD_ROW
KB_ROW = KEYPAD_ROW                              ; Assign amount of ROW
          endif
                                   
    ifdef KEYPAD_COL
KB_COL = KEYPAD_COL                              ; Assign amount of COL
          endif
         
         ;
         ;    ROW pins assignement
         ;    --------------------
    ifdef KEYPAD_ROW_PORT
KB_ROW_PORT = KEYPAD_ROW_PORT                    ; Assign ROW to user selected PORT
          endif
                                   
    ifdef KEYPAD_ROW_BIT 
KB_ROW_BIT = KEYPAD_ROW_BIT                      ; Assign ROW0 to user selected BIT
          endif

         ;
         ;    COLUMN pins assignement
         ;    -----------------------
    ifdef KEYPAD_COL_PORT
KB_COL_PORT = KEYPAD_COL_PORT                    ; Assign COL to user selected PORT
          endif         
          
    ifdef KEYPAD_COL_BIT
KB_COL_BIT = KEYPAD_COL_BIT                      ; Assign COL0 to user selected BIT
          endif

         ;
         ;    Keypad debounce delay
         ;    ---------------------
    ifdef KEYPAD_DEBOUNCEMS
DebounceDelay=KEYPAD_DEBOUNCEMS
          endif

         ;
         ;    Single scan or Not
         ;    ------------------
    ifdef SCAN_ONCE
        if (SCAN_ONCE!=1)
SINGLE_SCAN = 0
        else
SINGLE_SCAN = 1
        endif
    endif
    

	ENDASM?


	ASM?

KeyMask = 0xFF  >> (8-KB_COL)                ; use to keep only COL bits
InitialState= 0x0F << KB_ROW_BIT             ; Initial state of ROW column bits
    

	ENDASM?

	GOTO?L	_JumpOverKeyScan

	LABEL?L	_KeypadScan	

	ASM?

    
TRIS_COL = (TRISA + (KB_COL_PORT - PORTA))                 ; Find COL TRIS register => input
             CHK?RP TRIS_COL                               ; Move to correct bank
BitSelect = 0                                              ;


            REPT KB_COL                                    ; Set according TRIS
                   bsf TRIS_COL, KB_COL_BIT+BitSelect      ;     register bits 
BitSelect = BitSelect + 1                                  ;     to input
            ENDM
            
TRIS_ROW = (TRISA + (KB_ROW_PORT - PORTA))                 ; Find ROW TRIS register => output
             CHK?RP TRIS_ROW                               ; Move to correct bank
BitSelect = 0                                              ;
             REPT KB_ROW                                   ; Set according TRIS
                   bcf TRIS_ROW, KB_ROW_BIT + BitSelect    ;     register bits
BitSelect = BitSelect + 1                                  ;     to output 
                   ENDM
        

	ENDASM?


	LABEL?L	_ScanKeypad	
	MOVE?CB	000h, _Key
	MOVE?CB	000h, _Row
	MOVE?CB	000h, _Col
	OR?BCB	KB_ROW_PORT, InitialState, KB_ROW_PORT
	LABEL?L	L00001	
	ADD?BCB	_Row, KB_ROW_BIT, _RowBit
	AIN?CTB	000h, _KB_ROW_PORT??0, _RowBit
	GOSUB?L	_readcol
	CMPEQ?BCL	_KeyTemp, KeyMask, L00003
	LABEL?L	L00005	
	CMPNE?TCL	_KeyTemp??0, 000h, L00007
	MUL?BCB	_Row, KB_COL, _Key
	ADD?BBB	_Key, _Col, _Key
	ADD?BCB	_Key, 001h, _Key
	MOVE?CB	KB_ROW, _Row

	ASM?
 ifndef KEYPAD_AUTOREPEAT           

	ENDASM?

	LABEL?L	L00009	
	GOSUB?L	_readcol
	CMPNE?BCL	_KeyTemp, KeyMask, L00009
	LABEL?L	L00010	

	ASM?
 endif                     

	ENDASM?

	PAUSE?C	DebounceDelay
	LABEL?L	L00007	
	SHIFTR?BCB	_KeyTemp, 001h, _KeyTemp
	ADD?BCB	_Col, 001h, _Col
	CMPNE?BCL	_Col, KB_COL, L00005
	LABEL?L	L00006	
	LABEL?L	L00003	
	AIN?CTB	001h, _KB_ROW_PORT??0, _RowBit
	ADD?BCB	_Row, 001h, _Row
	SUB?CCW	KB_ROW, 001h, T1
	CMPLE?BWL	_Row, T1, L00001
	LABEL?L	L00002	
	CMPEQ?CCB	SINGLE_SCAN, 000h, T1
	CMPEQ?BCB	_Key, 000h, T2
	LAND?BBL	T1, T2, _ScanKeypad
	RETURN?	

	LABEL?L	_readcol	
	SHIFTR?BCB	KB_COL_PORT, KB_COL_BIT, _KeyTemp
	AND?BCB	_KeyTemp, KeyMask, _KeyTemp
	RETURN?	

	LABEL?L	_JumpOverKeyScan	
	DENABLE?	
	MOVE?CB	_StartH, _ByteArray
	MOVE?CB	_StartM, _ByteArray + 00001h
	MOVE?CB	_StartL, _ByteArray + 00002h
	PAUSE?C	003E8h

	LABEL?L	_main	
	GOSUB?L	_KeypadScan
	GOSUB?L	_check
	GOTO?L	_main

	LABEL?L	_check	
	CMPNE?BCL	_Key, 001h, L00013
	GOSUB?L	_VolumeDn
	GOTO?L	L00012
	LABEL?L	L00013	
	CMPNE?BCL	_Key, 003h, L00014
	GOSUB?L	_VolumeUp
	LABEL?L	L00014	
	LABEL?L	L00012	
	PAUSE?C	001F4h
	RETURN?	

	LABEL?L	_VolumeUp	
	MOVE?CB	_VolUpH, _ByteArray + 00003h
	MOVE?CB	_VolUpM, _ByteArray + 00004h
	MOVE?CB	_VolUpL, _ByteArray + 00005h
	GOSUB?L	_SendIt
	RETURN?	

	LABEL?L	_VolumeDn	
	MOVE?CB	_VolDnH, _ByteArray + 00003h
	MOVE?CB	_VolDnM, _ByteArray + 00004h
	MOVE?CB	_VolDnL, _ByteArray + 00005h
	GOSUB?L	_SendIt
	RETURN?	

	LABEL?L	_SendIt	
	MOVE?CB	000h, _BitCount
	LABEL?L	L00015	
	CMPGT?BCL	_BitCount, 02Fh, L00016
	AOUT?TBW	_ByteArray??0, _BitCount, T1
	CMPNE?WCL	T1, 001h, L00017
	GOSUB?L	_One
	GOTO?L	L00018
	LABEL?L	L00017	
	GOSUB?L	_Zero
	LABEL?L	L00018	
	NEXT?BCL	_BitCount, 001h, L00015
	LABEL?L	L00016	
	RETURN?	

	LABEL?L	_One	
	MOVE?CT	001h, _PORTB??7
	PAUSEUS?C	001F4h
	MOVE?CT	000h, _PORTB??7
	PAUSEUS?C	001F4h
	RETURN?	

	LABEL?L	_Zero	
	MOVE?CT	000h, _PORTB??7
	PAUSEUS?C	003E8h
	RETURN?	
	END?	

	END
