
; PICBASIC PRO(TM) Compiler 2.60A, (c) 1998, 2010 microEngineering Labs, Inc. All Rights Reserved. 
_USED			EQU	1

	INCLUDE	"C:\PBP\16F628.INC"


; Define statements.
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00017	DEFINE HSER_CLROERR 1   'USART CLEAR OVERFLOW ERROR
#define		HSER_CLROERR		 1   
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00018	DEFINE HSER_TXSTA 24H   'SET USART TX STAUS REG 
#define		HSER_TXSTA		 24H   
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00019	DEFINE HSER_RCSTA 90H   'SET USART RC STAUS REG 
#define		HSER_RCSTA		 90H   
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00020	DEFINE HSER_BAUD 4800   'SET USART BAUD RATE
#define		HSER_BAUD		 4800   
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00021	define HSER_SPBRG 50    'SET PIC OSC FOR 4800 BAUD
#define		HSER_SPBRG		 50    

RAM_START       		EQU	00020h
RAM_END         		EQU	0014Fh
RAM_BANKS       		EQU	00003h
BANK0_START     		EQU	00020h
BANK0_END       		EQU	0007Fh
BANK1_START     		EQU	000A0h
BANK1_END       		EQU	000EFh
BANK2_START     		EQU	00120h
BANK2_END       		EQU	0014Fh
EEPROM_START    		EQU	02100h
EEPROM_END      		EQU	0217Fh

; C:\PBP\PBPPIC14.RAM      	00012	A00020	R0      VAR     WORD BANK0 SYSTEM       ' System Register
R0              		EQU	RAM_START + 000h
; C:\PBP\PBPPIC14.RAM      	00013	A00022	R1      VAR     WORD BANK0 SYSTEM       ' System Register
R1              		EQU	RAM_START + 002h
; C:\PBP\PBPPIC14.RAM      	00014	A00024	R2      VAR     WORD BANK0 SYSTEM       ' System Register
R2              		EQU	RAM_START + 004h
; C:\PBP\PBPPIC14.RAM      	00015	A00026	R3      VAR     WORD BANK0 SYSTEM       ' System Register
R3              		EQU	RAM_START + 006h
; C:\PBP\PBPPIC14.RAM      	00016	A00028	R4      VAR     WORD BANK0 SYSTEM       ' System Register
R4              		EQU	RAM_START + 008h
; C:\PBP\PBPPIC14.RAM      	00017	A0002A	R5      VAR     WORD BANK0 SYSTEM       ' System Register
R5              		EQU	RAM_START + 00Ah
; C:\PBP\PBPPIC14.RAM      	00018	A0002C	R6      VAR     WORD BANK0 SYSTEM       ' System Register
R6              		EQU	RAM_START + 00Ch
; C:\PBP\PBPPIC14.RAM      	00019	A0002E	R7      VAR     WORD BANK0 SYSTEM       ' System Register
R7              		EQU	RAM_START + 00Eh
; C:\PBP\PBPPIC14.RAM      	00020	A00030	R8      VAR     WORD BANK0 SYSTEM       ' System Register
R8              		EQU	RAM_START + 010h
; C:\PBP\PBPPIC14.RAM      	00026	A00032	FLAGS   VAR     BYTE BANK0 SYSTEM       ' Static flags
FLAGS           		EQU	RAM_START + 012h
; C:\PBP\PBPPIC14.RAM      	00025	A00033	GOP     VAR     BYTE BANK0 SYSTEM       ' Gen Op Parameter
GOP             		EQU	RAM_START + 013h
; C:\PBP\PBPPIC14.RAM      	00022	A00034	RM1     VAR     BYTE BANK0 SYSTEM       ' Pin 1 Mask
RM1             		EQU	RAM_START + 014h
; C:\PBP\PBPPIC14.RAM      	00024	A00035	RM2     VAR     BYTE BANK0 SYSTEM       ' Pin 2 Mask
RM2             		EQU	RAM_START + 015h
; C:\PBP\PBPPIC14.RAM      	00021	A00036	RR1     VAR     BYTE BANK0 SYSTEM       ' Pin 1 Register
RR1             		EQU	RAM_START + 016h
; C:\PBP\PBPPIC14.RAM      	00023	A00037	RR2     VAR     BYTE BANK0 SYSTEM       ' Pin 2 Register
RR2             		EQU	RAM_START + 017h
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00022	A00038	RXDATA VAR BYTE (50)
_RXDATA          		EQU	RAM_START + 018h
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00031	A0006A	LNG VAR BYTE (10)
_LNG             		EQU	RAM_START + 04Ah
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00032	A00074	RMCLNG VAR BYTE (10)
_RMCLNG          		EQU	RAM_START + 054h
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00048	A0007E	ADDRESS vAR WORD
_ADDRESS         		EQU	RAM_START + 05Eh
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00024	A000A0	RMCUTC VAR BYTE (10)
_RMCUTC          		EQU	RAM_START + 080h
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00023	A000AA	UTC VAR BYTE (10)
_UTC             		EQU	RAM_START + 08Ah
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00025	A000B4	LAT VAR BYTE (9)
_LAT             		EQU	RAM_START + 094h
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00026	A000BD	RMCLAT VAR BYTE (9)
_RMCLAT          		EQU	RAM_START + 09Dh
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00033	A000C6	ALT VAR BYTE (7)
_ALT             		EQU	RAM_START + 0A6h
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00037	A000CD	SPD VAR BYTE (5)
_SPD             		EQU	RAM_START + 0ADh
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00038	A000D2	TRK VAR BYTE (5)
_TRK             		EQU	RAM_START + 0B2h
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00036	A000D7	HDP VAR BYTE (3)
_HDP             		EQU	RAM_START + 0B7h
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00049	A000DA	ALTFT VAR WORD
_ALTFT           		EQU	RAM_START + 0BAh
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00029	A000DC	EW VAR BYTE (2)
_EW              		EQU	RAM_START + 0BCh
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00050	A000DE	FEET VAR WORD
_FEET            		EQU	RAM_START + 0BEh
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00027	A000E0	NS VAR BYTE (2)
_NS              		EQU	RAM_START + 0C0h
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00030	A000E2	RMCEW VAR BYTE (2)
_RMCEW           		EQU	RAM_START + 0C2h
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00028	A000E4	RMCNS VAR BYTE (2)
_RMCNS           		EQU	RAM_START + 0C4h
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00035	A000E6	SATS VAR BYTE (2)
_SATS            		EQU	RAM_START + 0C6h
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00001	A000E8	'****************************************************************
T1              		EQU	RAM_START + 0C8h
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00001	A000EA	'****************************************************************
T2              		EQU	RAM_START + 0CAh
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00001	A000EC	'****************************************************************
T3              		EQU	RAM_START + 0CCh
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00001	A000EE	'****************************************************************
T4              		EQU	RAM_START + 0CEh
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00001	A00120	'****************************************************************
T5              		EQU	RAM_START + 00100h
; C:\PBP\BS2DEFS.BAS       	00057	A00122	W0      VAR     WORD
_W0              		EQU	RAM_START + 00102h
; C:\PBP\BS2DEFS.BAS       	00058	A00124	W1      VAR     WORD
_W1              		EQU	RAM_START + 00104h
; C:\PBP\BS2DEFS.BAS       	00067	A00126	W10     VAR     WORD
_W10             		EQU	RAM_START + 00106h
; C:\PBP\BS2DEFS.BAS       	00068	A00128	W11     VAR     WORD
_W11             		EQU	RAM_START + 00108h
; C:\PBP\BS2DEFS.BAS       	00069	A0012A	W12     VAR     WORD
_W12             		EQU	RAM_START + 0010Ah
; C:\PBP\BS2DEFS.BAS       	00059	A0012C	W2      VAR     WORD
_W2              		EQU	RAM_START + 0010Ch
; C:\PBP\BS2DEFS.BAS       	00060	A0012E	W3      VAR     WORD
_W3              		EQU	RAM_START + 0010Eh
; C:\PBP\BS2DEFS.BAS       	00061	A00130	W4      VAR     WORD
_W4              		EQU	RAM_START + 00110h
; C:\PBP\BS2DEFS.BAS       	00062	A00132	W5      VAR     WORD
_W5              		EQU	RAM_START + 00112h
; C:\PBP\BS2DEFS.BAS       	00063	A00134	W6      VAR     WORD
_W6              		EQU	RAM_START + 00114h
; C:\PBP\BS2DEFS.BAS       	00064	A00136	W7      VAR     WORD
_W7              		EQU	RAM_START + 00116h
; C:\PBP\BS2DEFS.BAS       	00065	A00138	W8      VAR     WORD
_W8              		EQU	RAM_START + 00118h
; C:\PBP\BS2DEFS.BAS       	00066	A0013A	W9      VAR     WORD
_W9              		EQU	RAM_START + 0011Ah
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00045	A0013C	BAUDOTDATA VAR BYTE
_BAUDOTDATA      		EQU	RAM_START + 0011Ch
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00047	A0013D	BEACONCOUNT VAR BYTE
_BEACONCOUNT     		EQU	RAM_START + 0011Dh
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00034	A0013E	FQ VAR BYTE (1)
_FQ              		EQU	RAM_START + 0011Eh
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00043	A0013F	I VAR BYTE
_I               		EQU	RAM_START + 0011Fh
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00044	A00140	L VAR BYTE
_L               		EQU	RAM_START + 00120h
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00052	A00141	MPH VAR BYTE
_MPH             		EQU	RAM_START + 00121h
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00001	A00142	'****************************************************************
PB01            		EQU	RAM_START + 00122h
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00051	A00143	SPDMPH VAR BYTE
_SPDMPH          		EQU	RAM_START + 00123h
; C:\PBP\16F628.BAS        	00020	PORTL   VAR     PORTB
_PORTL           		EQU	 PORTB
; C:\PBP\16F628.BAS        	00021	PORTH   VAR     PORTA
_PORTH           		EQU	 PORTA
; C:\PBP\16F628.BAS        	00022	TRISL   VAR     TRISB
_TRISL           		EQU	 TRISB
; C:\PBP\16F628.BAS        	00023	TRISH   VAR     TRISA
_TRISH           		EQU	 TRISA
; C:\PBP\BS2DEFS.BAS       	00014	INS     VAR     PORTL
_INS             		EQU	_PORTL
; C:\PBP\BS2DEFS.BAS       	00015	OUTS    VAR     PORTL
_OUTS            		EQU	_PORTL
; C:\PBP\BS2DEFS.BAS       	00017	INL     VAR     PORTL
_INL             		EQU	_PORTL
; C:\PBP\BS2DEFS.BAS       	00018	INH     VAR     PORTH
_INH             		EQU	_PORTH
; C:\PBP\BS2DEFS.BAS       	00020	OUTL    VAR     PORTL
_OUTL            		EQU	_PORTL
; C:\PBP\BS2DEFS.BAS       	00021	OUTH    VAR     PORTH
_OUTH            		EQU	_PORTH
; C:\PBP\BS2DEFS.BAS       	00071	B0      VAR     W0.LOWBYTE
_B0              		EQU	_W0
; C:\PBP\BS2DEFS.BAS       	00072	B1      VAR     W0.HIGHBYTE
_B1              		EQU	_W0 + 001h
; C:\PBP\BS2DEFS.BAS       	00073	B2      VAR     W1.LOWBYTE
_B2              		EQU	_W1
; C:\PBP\BS2DEFS.BAS       	00074	B3      VAR     W1.HIGHBYTE
_B3              		EQU	_W1 + 001h
; C:\PBP\BS2DEFS.BAS       	00075	B4      VAR     W2.LOWBYTE
_B4              		EQU	_W2
; C:\PBP\BS2DEFS.BAS       	00076	B5      VAR     W2.HIGHBYTE
_B5              		EQU	_W2 + 001h
; C:\PBP\BS2DEFS.BAS       	00077	B6      VAR     W3.LOWBYTE
_B6              		EQU	_W3
; C:\PBP\BS2DEFS.BAS       	00078	B7      VAR     W3.HIGHBYTE
_B7              		EQU	_W3 + 001h
; C:\PBP\BS2DEFS.BAS       	00079	B8      VAR     W4.LOWBYTE
_B8              		EQU	_W4
; C:\PBP\BS2DEFS.BAS       	00080	B9      VAR     W4.HIGHBYTE
_B9              		EQU	_W4 + 001h
; C:\PBP\BS2DEFS.BAS       	00081	B10     VAR     W5.LOWBYTE
_B10             		EQU	_W5
; C:\PBP\BS2DEFS.BAS       	00082	B11     VAR     W5.HIGHBYTE
_B11             		EQU	_W5 + 001h
; C:\PBP\BS2DEFS.BAS       	00083	B12     VAR     W6.LOWBYTE
_B12             		EQU	_W6
; C:\PBP\BS2DEFS.BAS       	00084	B13     VAR     W6.HIGHBYTE
_B13             		EQU	_W6 + 001h
; C:\PBP\BS2DEFS.BAS       	00085	B14     VAR     W7.LOWBYTE
_B14             		EQU	_W7
; C:\PBP\BS2DEFS.BAS       	00086	B15     VAR     W7.HIGHBYTE
_B15             		EQU	_W7 + 001h
; C:\PBP\BS2DEFS.BAS       	00087	B16     VAR     W8.LOWBYTE
_B16             		EQU	_W8
; C:\PBP\BS2DEFS.BAS       	00088	B17     VAR     W8.HIGHBYTE
_B17             		EQU	_W8 + 001h
; C:\PBP\BS2DEFS.BAS       	00089	B18     VAR     W9.LOWBYTE
_B18             		EQU	_W9
; C:\PBP\BS2DEFS.BAS       	00090	B19     VAR     W9.HIGHBYTE
_B19             		EQU	_W9 + 001h
; C:\PBP\BS2DEFS.BAS       	00091	B20     VAR     W10.LOWBYTE
_B20             		EQU	_W10
; C:\PBP\BS2DEFS.BAS       	00092	B21     VAR     W10.HIGHBYTE
_B21             		EQU	_W10 + 001h
; C:\PBP\BS2DEFS.BAS       	00093	B22     VAR     W11.LOWBYTE
_B22             		EQU	_W11
; C:\PBP\BS2DEFS.BAS       	00094	B23     VAR     W11.HIGHBYTE
_B23             		EQU	_W11 + 001h
; C:\PBP\BS2DEFS.BAS       	00095	B24     VAR     W12.LOWBYTE
_B24             		EQU	_W12
; C:\PBP\BS2DEFS.BAS       	00096	B25     VAR     W12.HIGHBYTE
_B25             		EQU	_W12 + 001h
_W0??LOWBYTE     		EQU	_W0
_W0??HIGHBYTE    		EQU	_W0 + 001h
_W1??LOWBYTE     		EQU	_W1
_W1??HIGHBYTE    		EQU	_W1 + 001h
_W2??LOWBYTE     		EQU	_W2
_W2??HIGHBYTE    		EQU	_W2 + 001h
_W3??LOWBYTE     		EQU	_W3
_W3??HIGHBYTE    		EQU	_W3 + 001h
_W4??LOWBYTE     		EQU	_W4
_W4??HIGHBYTE    		EQU	_W4 + 001h
_W5??LOWBYTE     		EQU	_W5
_W5??HIGHBYTE    		EQU	_W5 + 001h
_W6??LOWBYTE     		EQU	_W6
_W6??HIGHBYTE    		EQU	_W6 + 001h
_W7??LOWBYTE     		EQU	_W7
_W7??HIGHBYTE    		EQU	_W7 + 001h
_W8??LOWBYTE     		EQU	_W8
_W8??HIGHBYTE    		EQU	_W8 + 001h
_W9??LOWBYTE     		EQU	_W9
_W9??HIGHBYTE    		EQU	_W9 + 001h
_W10??LOWBYTE    		EQU	_W10
_W10??HIGHBYTE   		EQU	_W10 + 001h
_W11??LOWBYTE    		EQU	_W11
_W11??HIGHBYTE   		EQU	_W11 + 001h
_W12??LOWBYTE    		EQU	_W12
_W12??HIGHBYTE   		EQU	_W12 + 001h
#define _IN0             	_INL??0
#define _IN1             	_INL??1
#define _IN2             	_INL??2
#define _IN3             	_INL??3
#define _IN4             	_INL??4
#define _IN5             	_INL??5
#define _IN6             	_INL??6
#define _IN7             	_INL??7
#define _IN8             	_INH??0
#define _IN9             	_INH??1
#define _IN10            	_INH??2
#define _IN11            	_INH??3
#define _IN12            	_INH??4
#define _IN13            	_INH??5
#define _IN14            	_INH??6
#define _IN15            	_INH??7
#define _OUT0            	_OUTL??0
#define _OUT1            	_OUTL??1
#define _OUT2            	_OUTL??2
#define _OUT3            	_OUTL??3
#define _OUT4            	_OUTL??4
#define _OUT5            	_OUTL??5
#define _OUT6            	_OUTL??6
#define _OUT7            	_OUTL??7
#define _OUT8            	_OUTH??0
#define _OUT9            	_OUTH??1
#define _OUT10           	_OUTH??2
#define _OUT11           	_OUTH??3
#define _OUT12           	_OUTH??4
#define _OUT13           	_OUTH??5
#define _OUT14           	_OUTH??6
#define _OUT15           	_OUTH??7
#define _BIT0            	_B0??0
#define _BIT1            	_B0??1
#define _BIT2            	_B0??2
#define _BIT3            	_B0??3
#define _BIT4            	_B0??4
#define _BIT5            	_B0??5
#define _BIT6            	_B0??6
#define _BIT7            	_B0??7
#define _BIT8            	_B1??0
#define _BIT9            	_B1??1
#define _BIT10           	_B1??2
#define _BIT11           	_B1??3
#define _BIT12           	_B1??4
#define _BIT13           	_B1??5
#define _BIT14           	_B1??6
#define _BIT15           	_B1??7
#define _PTT             	_PORTB??4
#define _O               	_PORTB??5
#define _CUT             	_PORTB??6
#define _BAUDOTBIT       	 PB01, 000h
#define _INL??0          	_INL, 000h
#define _INL??1          	_INL, 001h
#define _INL??2          	_INL, 002h
#define _INL??3          	_INL, 003h
#define _INL??4          	_INL, 004h
#define _INL??5          	_INL, 005h
#define _INL??6          	_INL, 006h
#define _INL??7          	_INL, 007h
#define _INH??0          	_INH, 000h
#define _INH??1          	_INH, 001h
#define _INH??2          	_INH, 002h
#define _INH??3          	_INH, 003h
#define _INH??4          	_INH, 004h
#define _INH??5          	_INH, 005h
#define _INH??6          	_INH, 006h
#define _INH??7          	_INH, 007h
#define _OUTL??0         	_OUTL, 000h
#define _OUTL??1         	_OUTL, 001h
#define _OUTL??2         	_OUTL, 002h
#define _OUTL??3         	_OUTL, 003h
#define _OUTL??4         	_OUTL, 004h
#define _OUTL??5         	_OUTL, 005h
#define _OUTL??6         	_OUTL, 006h
#define _OUTL??7         	_OUTL, 007h
#define _OUTH??0         	_OUTH, 000h
#define _OUTH??1         	_OUTH, 001h
#define _OUTH??2         	_OUTH, 002h
#define _OUTH??3         	_OUTH, 003h
#define _OUTH??4         	_OUTH, 004h
#define _OUTH??5         	_OUTH, 005h
#define _OUTH??6         	_OUTH, 006h
#define _OUTH??7         	_OUTH, 007h
#define _B0??0           	_B0, 000h
#define _B0??1           	_B0, 001h
#define _B0??2           	_B0, 002h
#define _B0??3           	_B0, 003h
#define _B0??4           	_B0, 004h
#define _B0??5           	_B0, 005h
#define _B0??6           	_B0, 006h
#define _B0??7           	_B0, 007h
#define _B1??0           	_B1, 000h
#define _B1??1           	_B1, 001h
#define _B1??2           	_B1, 002h
#define _B1??3           	_B1, 003h
#define _B1??4           	_B1, 004h
#define _B1??5           	_B1, 005h
#define _B1??6           	_B1, 006h
#define _B1??7           	_B1, 007h
#define _PORTB??4        	 PORTB, 004h
#define _PORTB??5        	 PORTB, 005h
#define _PORTB??6        	 PORTB, 006h
#define _BAUDOTDATA??BIT4	_BAUDOTDATA, 004h
#define _BAUDOTDATA??BIT3	_BAUDOTDATA, 003h
#define _BAUDOTDATA??BIT2	_BAUDOTDATA, 002h
#define _BAUDOTDATA??BIT1	_BAUDOTDATA, 001h
#define _BAUDOTDATA??BIT0	_BAUDOTDATA, 000h

; Constants.
_T2400           		EQU	00000h
_T1200           		EQU	00001h
_T9600           		EQU	00002h
_T300            		EQU	00003h
_N2400           		EQU	00004h
_N1200           		EQU	00005h
_N9600           		EQU	00006h
_N300            		EQU	00007h
_OT2400          		EQU	00008h
_OT1200          		EQU	00009h
_OT9600          		EQU	0000Ah
_OT300           		EQU	0000Bh
_ON2400          		EQU	0000Ch
_ON1200          		EQU	0000Dh
_ON9600          		EQU	0000Eh
_ON300           		EQU	0000Fh
_MSBPRE          		EQU	00000h
_LSBPRE          		EQU	00001h
_MSBPOST         		EQU	00002h
_LSBPOST         		EQU	00003h
_LSBFIRST        		EQU	00000h
_MSBFIRST        		EQU	00001h
_CLS             		EQU	00000h
_HOME            		EQU	00001h
_BELL            		EQU	00007h
_BKSP            		EQU	00008h
_TAB             		EQU	00009h
_CR              		EQU	0000Dh
_UnitOn          		EQU	00012h
_UnitOff         		EQU	0001Ah
_UnitsOff        		EQU	0001Ch
_LightsOn        		EQU	00014h
_LightsOff       		EQU	00010h
_Dim             		EQU	0001Eh
_Bright          		EQU	00016h
	INCLUDE	"SARCHAB7.MAC"
	INCLUDE	"C:\PBP\PBPPIC14.LIB"


; C:\PBP\16F628.BAS        	00012	BANK0   $0020, $007F
; C:\PBP\16F628.BAS        	00013	BANK1   $00A0, $00EF
; C:\PBP\16F628.BAS        	00014	BANK2   $0120, $014F
; C:\PBP\16F628.BAS        	00015	EEPROM  $2100, $217F
; C:\PBP\16F628.BAS        	00016	LIBRARY "PBPPIC14"

; C:\PBP\16F628.BAS        	00018	        include "PIC14EXT.BAS"

; C:\PBP\16F628.BAS        	00025	        include "PBPPIC14.RAM"

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00016	INCLUDE "BS2DEFS.BAS"

; C:\PBP\BS2DEFS.BAS       	00012	INCLUDE "MODEDEFS.BAS"  ' Include Mode definitions
; C:\PBP\MODEDEFS.BAS      	00014	Symbol T2400  = 0       ' Driven True
; C:\PBP\MODEDEFS.BAS      	00015	Symbol T1200  = 1       ' Driven True
; C:\PBP\MODEDEFS.BAS      	00016	Symbol T9600  = 2       ' Driven True
; C:\PBP\MODEDEFS.BAS      	00017	Symbol T300   = 3       ' Driven True
; C:\PBP\MODEDEFS.BAS      	00019	Symbol N2400  = 4       ' Driven Inverted
; C:\PBP\MODEDEFS.BAS      	00020	Symbol N1200  = 5       ' Driven Inverted
; C:\PBP\MODEDEFS.BAS      	00021	Symbol N9600  = 6       ' Driven Inverted
; C:\PBP\MODEDEFS.BAS      	00022	Symbol N300   = 7       ' Driven Inverted
; C:\PBP\MODEDEFS.BAS      	00024	Symbol OT2400 = 8       ' Open True
; C:\PBP\MODEDEFS.BAS      	00025	Symbol OT1200 = 9       ' Open True
; C:\PBP\MODEDEFS.BAS      	00026	Symbol OT9600 = 10      ' Open True
; C:\PBP\MODEDEFS.BAS      	00027	Symbol OT300  = 11      ' Open True
; C:\PBP\MODEDEFS.BAS      	00029	Symbol ON2400 = 12      ' Open Inverted
; C:\PBP\MODEDEFS.BAS      	00030	Symbol ON1200 = 13      ' Open Inverted
; C:\PBP\MODEDEFS.BAS      	00031	Symbol ON9600 = 14      ' Open Inverted
; C:\PBP\MODEDEFS.BAS      	00032	Symbol ON300  = 15      ' Open Inverted
; C:\PBP\MODEDEFS.BAS      	00036	Symbol MSBPRE = 0       ' MSB first, sample before clock
; C:\PBP\MODEDEFS.BAS      	00037	Symbol LSBPRE = 1       ' LSB first, sample before clock
; C:\PBP\MODEDEFS.BAS      	00038	Symbol MSBPOST = 2      ' MSB first, sample after clock
; C:\PBP\MODEDEFS.BAS      	00039	Symbol LSBPOST = 3      ' LSB first, sample after clock
; C:\PBP\MODEDEFS.BAS      	00042	Symbol LSBFIRST = 0     ' LSB first
; C:\PBP\MODEDEFS.BAS      	00043	Symbol MSBFIRST = 1     ' MSB first
; C:\PBP\MODEDEFS.BAS      	00047	Symbol CLS = 0
; C:\PBP\MODEDEFS.BAS      	00048	Symbol HOME = 1
; C:\PBP\MODEDEFS.BAS      	00049	Symbol BELL = 7
; C:\PBP\MODEDEFS.BAS      	00050	Symbol BKSP = 8
; C:\PBP\MODEDEFS.BAS      	00051	Symbol TAB = 9
; C:\PBP\MODEDEFS.BAS      	00052	Symbol CR = 13
; C:\PBP\MODEDEFS.BAS      	00056	Symbol UnitOn = %10010
; C:\PBP\MODEDEFS.BAS      	00057	Symbol UnitOff = %11010
; C:\PBP\MODEDEFS.BAS      	00058	Symbol UnitsOff = %11100
; C:\PBP\MODEDEFS.BAS      	00059	Symbol LightsOn = %10100
; C:\PBP\MODEDEFS.BAS      	00060	Symbol LightsOff = %10000
; C:\PBP\MODEDEFS.BAS      	00061	Symbol Dim = %11110
; C:\PBP\MODEDEFS.BAS      	00062	Symbol Bright = %10110
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00017	DEFINE HSER_CLROERR 1   'USART CLEAR OVERFLOW ERROR
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00018	DEFINE HSER_TXSTA 24H   'SET USART TX STAUS REG 
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00019	DEFINE HSER_RCSTA 90H   'SET USART RC STAUS REG 
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00020	DEFINE HSER_BAUD 4800   'SET USART BAUD RATE
; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00021	define HSER_SPBRG 50    'SET PIC OSC FOR 4800 BAUD

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00039	PIR1 = $0C             'ASSIGN USART RX INTERUPT REG 
	MOVE?CB	00Ch, PIR1

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00053	BEACONCOUNT = 1
	MOVE?CB	001h, _BEACONCOUNT

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00056	MAIN:

	LABEL?L	_MAIN	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00057	IF BEACONCOUNT = 5 THEN BEACONCOUNT = 1 
	CMPNE?BCL	_BEACONCOUNT, 005h, L00017
	MOVE?CB	001h, _BEACONCOUNT
	LABEL?L	L00017	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00059	GOSUB READGPS
	GOSUB?L	_READGPS

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00060	GOSUB PUSHTOTALKON
	GOSUB?L	_PUSHTOTALKON

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00061	GOSUB DISPLAYFORMAT
	GOSUB?L	_DISPLAYFORMAT

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00062	GOSUB METRICSAE
	GOSUB?L	_METRICSAE

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00063	GOSUB TXGGARMCDATA
	GOSUB?L	_TXGGARMCDATA

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00065	BEACONCOUNT = BEACONCOUNT + 1
	ADD?BCB	_BEACONCOUNT, 001h, _BEACONCOUNT

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00066	IF BEACONCOUNT = 5 THEN GOSUB BEACON
	CMPNE?BCL	_BEACONCOUNT, 005h, L00019
	GOSUB?L	_BEACON
	LABEL?L	L00019	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00067	IF BEACONCOUNT = 5 THEN GOSUB WEB
	CMPNE?BCL	_BEACONCOUNT, 005h, L00021
	GOSUB?L	_WEB
	LABEL?L	L00021	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00069	GOSUB PUSHTOTALKOFF
	GOSUB?L	_PUSHTOTALKOFF

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00070	GOSUB CUTDWN
	GOSUB?L	_CUTDWN

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00074	GOTO MAIN
	GOTO?L	_MAIN

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00077	READGPS:

	LABEL?L	_READGPS	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00079	    HSERIN [WAIT (71,71,65,44), STR UTC \6]

	LABEL?L	L00001	
	HSERINWAIT?CL	047h, L00001
	HSERINWAIT?CL	047h, L00001
	HSERINWAIT?CL	041h, L00001
	HSERINWAIT?CL	02Ch, L00001
	HSERINCOUNT?C	006h
	HSERINSTR?B	_UTC

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00080	    HSERIN [WAIT (44), STR LAT \9]

	LABEL?L	L00002	
	HSERINWAIT?CL	02Ch, L00002
	HSERINCOUNT?C	009h
	HSERINSTR?B	_LAT

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00081	    HSERIN [WAIT (44), STR NS \1]

	LABEL?L	L00003	
	HSERINWAIT?CL	02Ch, L00003
	HSERINCOUNT?C	001h
	HSERINSTR?B	_NS

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00082	    HSERIN [WAIT (44), STR LNG \10]

	LABEL?L	L00004	
	HSERINWAIT?CL	02Ch, L00004
	HSERINCOUNT?C	00Ah
	HSERINSTR?B	_LNG

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00083	    HSERIN [WAIT (44), STR EW \1]

	LABEL?L	L00005	
	HSERINWAIT?CL	02Ch, L00005
	HSERINCOUNT?C	001h
	HSERINSTR?B	_EW

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00084	    HSERIN [WAIT (44), STR FQ \1]

	LABEL?L	L00006	
	HSERINWAIT?CL	02Ch, L00006
	HSERINCOUNT?C	001h
	HSERINSTR?B	_FQ

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00085	    HSERIN [WAIT (44), STR SATS \2]

	LABEL?L	L00007	
	HSERINWAIT?CL	02Ch, L00007
	HSERINCOUNT?C	002h
	HSERINSTR?B	_SATS

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00086	    HSERIN [WAIT (44), STR HDP \3]

	LABEL?L	L00008	
	HSERINWAIT?CL	02Ch, L00008
	HSERINCOUNT?C	003h
	HSERINSTR?B	_HDP

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00087	    HSERIN [WAIT (44), STR ALT \6\44]

	LABEL?L	L00009	
	HSERINWAIT?CL	02Ch, L00009
	HSERINCOUNT?C	006h
	HSERINCHAR?C	02Ch
	HSERINSTRC?B	_ALT

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00091	    HSERIN [WAIT (82,77,67,44), STR RMCUTC \6]

	LABEL?L	L00010	
	HSERINWAIT?CL	052h, L00010
	HSERINWAIT?CL	04Dh, L00010
	HSERINWAIT?CL	043h, L00010
	HSERINWAIT?CL	02Ch, L00010
	HSERINCOUNT?C	006h
	HSERINSTR?B	_RMCUTC

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00092	    HSERIN [WAIT (44), STR RMCLAT \9]

	LABEL?L	L00011	
	HSERINWAIT?CL	02Ch, L00011
	HSERINCOUNT?C	009h
	HSERINSTR?B	_RMCLAT

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00093	    HSERIN [WAIT (44), STR RMCNS \1]

	LABEL?L	L00012	
	HSERINWAIT?CL	02Ch, L00012
	HSERINCOUNT?C	001h
	HSERINSTR?B	_RMCNS

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00094	    HSERIN [WAIT (44), STR RMCLNG \10]

	LABEL?L	L00013	
	HSERINWAIT?CL	02Ch, L00013
	HSERINCOUNT?C	00Ah
	HSERINSTR?B	_RMCLNG

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00095	    HSERIN [WAIT (44), STR RMCEW \1]

	LABEL?L	L00014	
	HSERINWAIT?CL	02Ch, L00014
	HSERINCOUNT?C	001h
	HSERINSTR?B	_RMCEW

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00096	    HSERIN [WAIT (44), STR SPD \4]

	LABEL?L	L00015	
	HSERINWAIT?CL	02Ch, L00015
	HSERINCOUNT?C	004h
	HSERINSTR?B	_SPD

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00097	    HSERIN [WAIT (44), STR TRK \5]

	LABEL?L	L00016	
	HSERINWAIT?CL	02Ch, L00016
	HSERINCOUNT?C	005h
	HSERINSTR?B	_TRK

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00099	    RETURN
	RETURN?	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00101	PUSHTOTALKON:    

	LABEL?L	_PUSHTOTALKON	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00103	    HIGH PTT
	HIGH?T	_PTT

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00104	    PAUSE 500
	PAUSE?C	001F4h

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00105	    RETURN    
	RETURN?	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00107	PUSHTOTALKOFF:    

	LABEL?L	_PUSHTOTALKOFF	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00109	    LOW PTT
	LOW?T	_PTT

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00110	    PAUSE 500
	PAUSE?C	001F4h

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00111	    RETURN    
	RETURN?	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00113	DISPLAYFORMAT:

	LABEL?L	_DISPLAYFORMAT	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00115	    GOSUB LTR          'SEND LTR
	GOSUB?L	_LTR

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00116	    FOR I = 0 TO 4
	MOVE?CB	000h, _I
	LABEL?L	L00023	
	CMPGT?BCL	_I, 004h, L00024

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00117	    GOSUB TX
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00118	    NEXT I
	NEXT?BCL	_I, 001h, L00023
	LABEL?L	L00024	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00120	    GOSUB FIG          'SEND FIGS
	GOSUB?L	_FIG

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00121	    FOR I = 0 TO 4
	MOVE?CB	000h, _I
	LABEL?L	L00025	
	CMPGT?BCL	_I, 004h, L00026

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00122	    GOSUB TX
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00123	    NEXT I
	NEXT?BCL	_I, 001h, L00025
	LABEL?L	L00026	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00125	    GOSUB CRTN            'SEND CR
	GOSUB?L	_CRTN

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00126	    FOR I = 0 TO 1
	MOVE?CB	000h, _I
	LABEL?L	L00027	
	CMPGT?BCL	_I, 001h, L00028

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00127	    GOSUB TX
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00128	    NEXT I
	NEXT?BCL	_I, 001h, L00027
	LABEL?L	L00028	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00130	    GOSUB LF            'SEND LF
	GOSUB?L	_LF

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00131	    FOR I = 0 TO 1
	MOVE?CB	000h, _I
	LABEL?L	L00029	
	CMPGT?BCL	_I, 001h, L00030

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00132	    GOSUB TX
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00133	    NEXT I
	NEXT?BCL	_I, 001h, L00029
	LABEL?L	L00030	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00135	    RETURN
	RETURN?	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00137	TXGGARMCDATA:

	LABEL?L	_TXGGARMCDATA	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00139	    ADDRESS = $FB0    'UTC ADDRESS
	MOVE?CW	00FB0h, _ADDRESS

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00140	    FOR L = 0 TO 5
	MOVE?CB	000h, _L
	LABEL?L	L00031	
	CMPGT?BCL	_L, 005h, L00032

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00141	    PEEKCODE ADDRESS, BAUDOTDATA
	PEEKCODE?WB	_ADDRESS, _BAUDOTDATA

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00142	    GOSUB TX
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00143	    ADDRESS = ADDRESS + 1
	ADD?WCW	_ADDRESS, 001h, _ADDRESS

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00144	    NEXT L
	NEXT?BCL	_L, 001h, L00031
	LABEL?L	L00032	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00146	    FOR L = 0 TO 5       'MOVE UTC INTO RXDATA
	MOVE?CB	000h, _L
	LABEL?L	L00033	
	CMPGT?BCL	_L, 005h, L00034

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00147	    RXDATA (L) = UTC (L)
	AOUT?BBB	_UTC, _L, T1
	AIN?BBB	T1, _RXDATA, _L

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00148	    GOSUB TRANSLATE      'TRANSLATE ASCII TO BAUDOT
	GOSUB?L	_TRANSLATE

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00149	    GOSUB TX             'TRANSMIT BYTE
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00150	    NEXT L
	NEXT?BCL	_L, 001h, L00033
	LABEL?L	L00034	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00151	    GOSUB CRTN
	GOSUB?L	_CRTN

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00152	    GOSUB TX    
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00153	    GOSUB LF
	GOSUB?L	_LF

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00154	    GOSUB TX
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00158	    ADDRESS = $F60    'LAT ADDRESS
	MOVE?CW	00F60h, _ADDRESS

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00159	    FOR L = 0 TO 5
	MOVE?CB	000h, _L
	LABEL?L	L00035	
	CMPGT?BCL	_L, 005h, L00036

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00160	    PEEKCODE ADDRESS, BAUDOTDATA
	PEEKCODE?WB	_ADDRESS, _BAUDOTDATA

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00161	    GOSUB TX
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00162	    ADDRESS = ADDRESS + 1
	ADD?WCW	_ADDRESS, 001h, _ADDRESS

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00163	    NEXT L
	NEXT?BCL	_L, 001h, L00035
	LABEL?L	L00036	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00165	    FOR L = 0 TO 8        'MOVE LAT INTO RXDATA
	MOVE?CB	000h, _L
	LABEL?L	L00037	
	CMPGT?BCL	_L, 008h, L00038

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00166	    RXDATA (L) = LAT (L)
	AOUT?BBB	_LAT, _L, T1
	AIN?BBB	T1, _RXDATA, _L

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00167	    GOSUB TRANSLATE      'TRANSLATE ASCII TO BAUDOT
	GOSUB?L	_TRANSLATE

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00168	    GOSUB TX             'TRANSMIT BYTE
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00169	    NEXT L
	NEXT?BCL	_L, 001h, L00037
	LABEL?L	L00038	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00170	    GOSUB CRTN
	GOSUB?L	_CRTN

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00171	    GOSUB TX    
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00172	    GOSUB LF
	GOSUB?L	_LF

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00173	    GOSUB TX
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00176	    ADDRESS = $F70    'LNG ADDRESS
	MOVE?CW	00F70h, _ADDRESS

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00177	    FOR L = 0 TO 5
	MOVE?CB	000h, _L
	LABEL?L	L00039	
	CMPGT?BCL	_L, 005h, L00040

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00178	    PEEKCODE ADDRESS, BAUDOTDATA
	PEEKCODE?WB	_ADDRESS, _BAUDOTDATA

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00179	    GOSUB TX
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00180	    ADDRESS = ADDRESS + 1
	ADD?WCW	_ADDRESS, 001h, _ADDRESS

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00181	    NEXT L
	NEXT?BCL	_L, 001h, L00039
	LABEL?L	L00040	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00183	    FOR L = 0 TO 9        'MOVE LNG INTO RXDATA
	MOVE?CB	000h, _L
	LABEL?L	L00041	
	CMPGT?BCL	_L, 009h, L00042

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00184	    RXDATA (L) = LNG (L)
	AOUT?BBB	_LNG, _L, T1
	AIN?BBB	T1, _RXDATA, _L

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00185	    GOSUB TRANSLATE      'TRANSLATE ASCII TO BAUDOT
	GOSUB?L	_TRANSLATE

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00186	    GOSUB TX             'TRANSMIT BYTE
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00187	    NEXT L
	NEXT?BCL	_L, 001h, L00041
	LABEL?L	L00042	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00188	    GOSUB CRTN
	GOSUB?L	_CRTN

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00189	    GOSUB TX    
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00190	    GOSUB LF
	GOSUB?L	_LF

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00191	    GOSUB TX
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00194	    ADDRESS = $F80    'ALT ADDRESS
	MOVE?CW	00F80h, _ADDRESS

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00195	    FOR L = 0 TO 5
	MOVE?CB	000h, _L
	LABEL?L	L00043	
	CMPGT?BCL	_L, 005h, L00044

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00196	    PEEKCODE ADDRESS, BAUDOTDATA
	PEEKCODE?WB	_ADDRESS, _BAUDOTDATA

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00197	    GOSUB TX
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00198	    ADDRESS = ADDRESS + 1
	ADD?WCW	_ADDRESS, 001h, _ADDRESS

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00199	    NEXT L
	NEXT?BCL	_L, 001h, L00043
	LABEL?L	L00044	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00201	    FOR L = 0 TO 5        'MOVE ALT INTO RXDATA
	MOVE?CB	000h, _L
	LABEL?L	L00045	
	CMPGT?BCL	_L, 005h, L00046

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00202	    RXDATA (L) = ALT (L)
	AOUT?BBB	_ALT, _L, T1
	AIN?BBB	T1, _RXDATA, _L

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00203	    GOSUB TRANSLATE      'TRANSLATE ASCII TO BAUDOT
	GOSUB?L	_TRANSLATE

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00204	    GOSUB TX             'TRANSMIT BYTE
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00205	    NEXT L
	NEXT?BCL	_L, 001h, L00045
	LABEL?L	L00046	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00206	    GOSUB CRTN
	GOSUB?L	_CRTN

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00207	    GOSUB TX    
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00208	    GOSUB LF
	GOSUB?L	_LF

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00209	    GOSUB TX
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00212	    ADDRESS = $F90    'SPD ADDRESS
	MOVE?CW	00F90h, _ADDRESS

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00213	    FOR L = 0 TO 5
	MOVE?CB	000h, _L
	LABEL?L	L00047	
	CMPGT?BCL	_L, 005h, L00048

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00214	    PEEKCODE ADDRESS, BAUDOTDATA
	PEEKCODE?WB	_ADDRESS, _BAUDOTDATA

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00215	    GOSUB TX
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00216	    ADDRESS = ADDRESS + 1
	ADD?WCW	_ADDRESS, 001h, _ADDRESS

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00217	    NEXT L
	NEXT?BCL	_L, 001h, L00047
	LABEL?L	L00048	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00220	    FOR L = 0 TO 3        'MOVE SPD INTO RXDATA
	MOVE?CB	000h, _L
	LABEL?L	L00049	
	CMPGT?BCL	_L, 003h, L00050

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00221	    RXDATA (L) = SPD (L)
	AOUT?BBB	_SPD, _L, T1
	AIN?BBB	T1, _RXDATA, _L

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00222	    GOSUB TRANSLATE      'TRANSLATE ASCII TO BAUDOT
	GOSUB?L	_TRANSLATE

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00223	    GOSUB TX             'TRANSMIT BYTE
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00224	    NEXT L
	NEXT?BCL	_L, 001h, L00049
	LABEL?L	L00050	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00225	    GOSUB CRTN
	GOSUB?L	_CRTN

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00226	    GOSUB TX    
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00227	    GOSUB LF
	GOSUB?L	_LF

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00228	    GOSUB TX
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00231	    ADDRESS = $FA0    'TRK ADDRESS
	MOVE?CW	00FA0h, _ADDRESS

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00232	    FOR L = 0 TO 5
	MOVE?CB	000h, _L
	LABEL?L	L00051	
	CMPGT?BCL	_L, 005h, L00052

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00233	    PEEKCODE ADDRESS, BAUDOTDATA
	PEEKCODE?WB	_ADDRESS, _BAUDOTDATA

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00234	    GOSUB TX
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00235	    ADDRESS = ADDRESS + 1
	ADD?WCW	_ADDRESS, 001h, _ADDRESS

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00236	    NEXT L
	NEXT?BCL	_L, 001h, L00051
	LABEL?L	L00052	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00238	    FOR L = 0 TO 4        'MOVE TRK INTO RXDATA
	MOVE?CB	000h, _L
	LABEL?L	L00053	
	CMPGT?BCL	_L, 004h, L00054

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00239	    RXDATA (L) = TRK (L)
	AOUT?BBB	_TRK, _L, T1
	AIN?BBB	T1, _RXDATA, _L

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00240	    GOSUB TRANSLATE      'TRANSLATE ASCII TO BAUDOT
	GOSUB?L	_TRANSLATE

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00241	    GOSUB TX             'TRANSMIT BYTE
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00242	    NEXT L
	NEXT?BCL	_L, 001h, L00053
	LABEL?L	L00054	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00243	    GOSUB CRTN
	GOSUB?L	_CRTN

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00244	    GOSUB TX    
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00245	    GOSUB LF
	GOSUB?L	_LF

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00246	    GOSUB TX
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00248	    RETURN
	RETURN?	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00250	    END
	END?	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00252	    TRANSLATE:

	LABEL?L	_TRANSLATE	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00253	    IF RXDATA (L) =  "0" THEN BAUDOTDATA = 13
	AOUT?BBB	_RXDATA, _L, T1
	CMPNE?BCL	T1, 030h, L00055
	MOVE?CB	00Dh, _BAUDOTDATA
	LABEL?L	L00055	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00254	    IF RXDATA (L) =  "1" THEN BAUDOTDATA = 29
	AOUT?BBB	_RXDATA, _L, T1
	CMPNE?BCL	T1, 031h, L00057
	MOVE?CB	01Dh, _BAUDOTDATA
	LABEL?L	L00057	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00255	    IF RXDATA (L) =  "2" THEN BAUDOTDATA = 25
	AOUT?BBB	_RXDATA, _L, T1
	CMPNE?BCL	T1, 032h, L00059
	MOVE?CB	019h, _BAUDOTDATA
	LABEL?L	L00059	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00256	    IF RXDATA (L) =  "3" THEN BAUDOTDATA = 16
	AOUT?BBB	_RXDATA, _L, T1
	CMPNE?BCL	T1, 033h, L00061
	MOVE?CB	010h, _BAUDOTDATA
	LABEL?L	L00061	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00257	    IF RXDATA (L) =  "4" THEN BAUDOTDATA = 10
	AOUT?BBB	_RXDATA, _L, T1
	CMPNE?BCL	T1, 034h, L00063
	MOVE?CB	00Ah, _BAUDOTDATA
	LABEL?L	L00063	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00258	    IF RXDATA (L) =  "5" THEN BAUDOTDATA = 1
	AOUT?BBB	_RXDATA, _L, T1
	CMPNE?BCL	T1, 035h, L00065
	MOVE?CB	001h, _BAUDOTDATA
	LABEL?L	L00065	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00259	    IF RXDATA (L) =  "6" THEN BAUDOTDATA = 21
	AOUT?BBB	_RXDATA, _L, T1
	CMPNE?BCL	T1, 036h, L00067
	MOVE?CB	015h, _BAUDOTDATA
	LABEL?L	L00067	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00260	    IF RXDATA (L) =  "7" THEN BAUDOTDATA = 28
	AOUT?BBB	_RXDATA, _L, T1
	CMPNE?BCL	T1, 037h, L00069
	MOVE?CB	01Ch, _BAUDOTDATA
	LABEL?L	L00069	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00261	    IF RXDATA (L) =  "8" THEN BAUDOTDATA = 12
	AOUT?BBB	_RXDATA, _L, T1
	CMPNE?BCL	T1, 038h, L00071
	MOVE?CB	00Ch, _BAUDOTDATA
	LABEL?L	L00071	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00262	    IF RXDATA (L) =  "9" THEN BAUDOTDATA = 3
	AOUT?BBB	_RXDATA, _L, T1
	CMPNE?BCL	T1, 039h, L00073
	MOVE?CB	003h, _BAUDOTDATA
	LABEL?L	L00073	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00264	    IF RXDATA (L) =  "," THEN BAUDOTDATA = 6 'Convert "," to SPACE
	AOUT?BBB	_RXDATA, _L, T1
	CMPNE?BCL	T1, 02Ch, L00075
	MOVE?CB	006h, _BAUDOTDATA
	LABEL?L	L00075	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00265	    IF RXDATA (L) =  "." THEN BAUDOTDATA = 7
	AOUT?BBB	_RXDATA, _L, T1
	CMPNE?BCL	T1, 02Eh, L00077
	MOVE?CB	007h, _BAUDOTDATA
	LABEL?L	L00077	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00267	    RETURN
	RETURN?	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00269	    TX:

	LABEL?L	_TX	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00271	    GOSUB SPACE         'SEND START BIT LOW 22mS
	GOSUB?L	_SPACE

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00273	    BAUDOTBIT = BAUDOTDATA.BIT4
	MOVE?TT	_BAUDOTDATA??BIT4, _BAUDOTBIT

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00274	    IF BAUDOTBIT = 0 THEN GOSUB SPACE
	CMPNE?TCL	_BAUDOTBIT, 000h, L00079
	GOSUB?L	_SPACE
	LABEL?L	L00079	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00275	    IF BAUDOTBIT = 1 THEN GOSUB MARK
	CMPNE?TCL	_BAUDOTBIT, 001h, L00081
	GOSUB?L	_MARK
	LABEL?L	L00081	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00277	    BAUDOTBIT = BAUDOTDATA.BIT3
	MOVE?TT	_BAUDOTDATA??BIT3, _BAUDOTBIT

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00278	    IF BAUDOTBIT = 0 THEN GOSUB SPACE
	CMPNE?TCL	_BAUDOTBIT, 000h, L00083
	GOSUB?L	_SPACE
	LABEL?L	L00083	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00279	    IF BAUDOTBIT = 1 THEN GOSUB MARK
	CMPNE?TCL	_BAUDOTBIT, 001h, L00085
	GOSUB?L	_MARK
	LABEL?L	L00085	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00281	    BAUDOTBIT = BAUDOTDATA.BIT2
	MOVE?TT	_BAUDOTDATA??BIT2, _BAUDOTBIT

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00282	    IF BAUDOTBIT = 0 THEN GOSUB SPACE
	CMPNE?TCL	_BAUDOTBIT, 000h, L00087
	GOSUB?L	_SPACE
	LABEL?L	L00087	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00283	    IF BAUDOTBIT = 1 THEN GOSUB MARK
	CMPNE?TCL	_BAUDOTBIT, 001h, L00089
	GOSUB?L	_MARK
	LABEL?L	L00089	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00285	    BAUDOTBIT = BAUDOTDATA.BIT1
	MOVE?TT	_BAUDOTDATA??BIT1, _BAUDOTBIT

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00286	    IF BAUDOTBIT = 0 THEN GOSUB SPACE
	CMPNE?TCL	_BAUDOTBIT, 000h, L00091
	GOSUB?L	_SPACE
	LABEL?L	L00091	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00287	    IF BAUDOTBIT = 1 THEN GOSUB MARK
	CMPNE?TCL	_BAUDOTBIT, 001h, L00093
	GOSUB?L	_MARK
	LABEL?L	L00093	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00289	    BAUDOTBIT = BAUDOTDATA.BIT0
	MOVE?TT	_BAUDOTDATA??BIT0, _BAUDOTBIT

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00290	    IF BAUDOTBIT = 0 THEN GOSUB SPACE
	CMPNE?TCL	_BAUDOTBIT, 000h, L00095
	GOSUB?L	_SPACE
	LABEL?L	L00095	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00291	    IF BAUDOTBIT = 1 THEN GOSUB MARK
	CMPNE?TCL	_BAUDOTBIT, 001h, L00097
	GOSUB?L	_MARK
	LABEL?L	L00097	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00293	    GOSUB STOPBIT       'SEND STOP BIT HIGH 44mS
	GOSUB?L	_STOPBIT

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00295	    RETURN
	RETURN?	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00298	METRICSAE:

	LABEL?L	_METRICSAE	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00300	    IF ALT(4)=46 THEN GOSUB LOWER    'CHECK FOR "."
	CMPNE?BCL	_ALT + 00004h, 02Eh, L00099
	GOSUB?L	_LOWER
	LABEL?L	L00099	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00301	    ALTFT = ((ALT(0)-48)*10000)+ ((ALT(1)-48)*1000)+ ((ALT(2)-48)*100)+ ((ALT(3)-48)*10)+(ALT(4)-48)
	SUB?BCW	_ALT, 030h, T1
	MUL?WCW	T1, 02710h, T1
	SUB?BCW	_ALT + 00001h, 030h, T2
	MUL?WCW	T2, 003E8h, T2
	ADD?WWW	T1, T2, T2
	SUB?BCW	_ALT + 00002h, 030h, T3
	MUL?WCW	T3, 064h, T3
	ADD?WWW	T2, T3, T3
	SUB?BCW	_ALT + 00003h, 030h, T4
	MUL?WCW	T4, 00Ah, T4
	ADD?WWW	T3, T4, T4
	SUB?BCW	_ALT + 00004h, 030h, T5
	ADD?WWW	T4, T5, _ALTFT

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00302	    FEET = (ALTFT */ 845)  'CONVERT METERS TO FEET
	MULMID?WCW	_ALTFT, 0034Dh, _FEET

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00303	    GOSUB KNOTS
	GOSUB?L	_KNOTS

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00304	    RETURN
	RETURN?	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00306	    LOWER:

	LABEL?L	_LOWER	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00307	    ALTFT = ((ALT(0)-48)*1000)+ ((ALT(1)-48)*100)+ ((ALT(2)-48)*10)+ (ALT(3)-48)
	SUB?BCW	_ALT, 030h, T1
	MUL?WCW	T1, 003E8h, T1
	SUB?BCW	_ALT + 00001h, 030h, T2
	MUL?WCW	T2, 064h, T2
	ADD?WWW	T1, T2, T2
	SUB?BCW	_ALT + 00002h, 030h, T3
	MUL?WCW	T3, 00Ah, T3
	ADD?WWW	T2, T3, T3
	SUB?BCW	_ALT + 00003h, 030h, T4
	ADD?WWW	T3, T4, _ALTFT

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00308	    FEET = (ALTFT */ 845)'CONVERT METERS TO FEET
	MULMID?WCW	_ALTFT, 0034Dh, _FEET

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00309	KNOTS:        

	LABEL?L	_KNOTS	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00310	    SPDMPH = ((SPD(0)-48)*10)+ (SPD(1)-48)
	SUB?BCW	_SPD, 030h, T1
	MUL?WCW	T1, 00Ah, T1
	SUB?BCW	_SPD + 00001h, 030h, T2
	ADD?WWB	T1, T2, _SPDMPH

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00311	    MPH = (SPDMPH */ 295) 'CONVERT KNOTS TO MPH
	MULMID?BCB	_SPDMPH, 00127h, _MPH

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00312	    RETURN
	RETURN?	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00314	CUTDWN:

	LABEL?L	_CUTDWN	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00315	    IF FEET > 61000 THEN HIGH PTT    'COUTDOWWN COMMAND SET FOR 61000'
	CMPLE?WCL	_FEET, 0EE48h, L00101
	HIGH?T	_PTT
	LABEL?L	L00101	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00316	    PAUSE 5000                       'SUPPLY CD CURRENT FOR 5 SECONDS
	PAUSE?C	01388h

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00317	    LOW CUT
	LOW?T	_CUT

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00318	    RETURN
	RETURN?	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00322	MARK:

	LABEL?L	_MARK	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00323	low O
	LOW?T	_O

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00324	PAUSE 22
	PAUSE?C	016h

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00325	RETURN
	RETURN?	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00327	SPACE:

	LABEL?L	_SPACE	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00328	high O
	HIGH?T	_O

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00329	PAUSE 22
	PAUSE?C	016h

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00330	RETURN
	RETURN?	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00332	STOPBIT:

	LABEL?L	_STOPBIT	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00333	low O
	LOW?T	_O

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00334	PAUSE 44
	PAUSE?C	02Ch

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00335	RETURN
	RETURN?	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00339	LTR:

	LABEL?L	_LTR	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00340	BAUDOTDATA = 31
	MOVE?CB	01Fh, _BAUDOTDATA

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00341	RETURN  
	RETURN?	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00343	FIG:

	LABEL?L	_FIG	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00344	BAUDOTDATA = 27
	MOVE?CB	01Bh, _BAUDOTDATA

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00345	RETURN 
	RETURN?	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00347	CRTN:

	LABEL?L	_CRTN	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00348	BAUDOTDATA = 8
	MOVE?CB	008h, _BAUDOTDATA

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00349	RETURN 
	RETURN?	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00351	LF:

	LABEL?L	_LF	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00352	BAUDOTDATA = 2
	MOVE?CB	002h, _BAUDOTDATA

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00353	RETURN 
	RETURN?	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00357	BEACON:

	LABEL?L	_BEACON	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00358	    ADDRESS = $F00         'BEACON TEXT STORAGE LOCATION
	MOVE?CW	00F00h, _ADDRESS

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00359	    FOR L = 0 TO 51
	MOVE?CB	000h, _L
	LABEL?L	L00103	
	CMPGT?BCL	_L, 033h, L00104

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00360	    PEEKCODE ADDRESS, BAUDOTDATA
	PEEKCODE?WB	_ADDRESS, _BAUDOTDATA

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00361	    GOSUB TX
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00362	    ADDRESS = ADDRESS + 1
	ADD?WCW	_ADDRESS, 001h, _ADDRESS

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00363	    NEXT L
	NEXT?BCL	_L, 001h, L00103
	LABEL?L	L00104	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00364	    RETURN
	RETURN?	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00366	WEB:   

	LABEL?L	_WEB	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00367	    ADDRESS = $F40         'BEACON TEXT STORAGE LOCATION
	MOVE?CW	00F40h, _ADDRESS

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00368	    FOR L = 0 TO 28
	MOVE?CB	000h, _L
	LABEL?L	L00105	
	CMPGT?BCL	_L, 01Ch, L00106

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00369	    PEEKCODE ADDRESS, BAUDOTDATA
	PEEKCODE?WB	_ADDRESS, _BAUDOTDATA

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00370	    GOSUB TX
	GOSUB?L	_TX

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00371	    ADDRESS = ADDRESS + 1
	ADD?WCW	_ADDRESS, 001h, _ADDRESS

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00372	    NEXT L
	NEXT?BCL	_L, 001h, L00105
	LABEL?L	L00106	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00373	    RETURN
	RETURN?	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00374	END
	END?	

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00376	POKECODE @$F00, 2,8,31,25,27,21,31,24,19,4,20,24,10,14,5,24

	ORG?C	00F00h
	POKECODE?C	002h
	POKECODE?C	008h
	POKECODE?C	01Fh
	POKECODE?C	019h
	POKECODE?C	01Bh
	POKECODE?C	015h
	POKECODE?C	01Fh
	POKECODE?C	018h
	POKECODE?C	013h
	POKECODE?C	004h
	POKECODE?C	014h
	POKECODE?C	018h
	POKECODE?C	00Ah
	POKECODE?C	00Eh
	POKECODE?C	005h
	POKECODE?C	018h

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00377	POKECODE @$F10, 19,4,23,27,29,27,2,8,31,5,22,4,1,10,24,14

	ORG?C	00F10h
	POKECODE?C	013h
	POKECODE?C	004h
	POKECODE?C	017h
	POKECODE?C	01Bh
	POKECODE?C	01Dh
	POKECODE?C	01Bh
	POKECODE?C	002h
	POKECODE?C	008h
	POKECODE?C	01Fh
	POKECODE?C	005h
	POKECODE?C	016h
	POKECODE?C	004h
	POKECODE?C	001h
	POKECODE?C	00Ah
	POKECODE?C	018h
	POKECODE?C	00Eh

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00378	POKECODE @$F20, 30,12,6,11,4,6,16,1,4,3,6,4,27,28,7,29

	ORG?C	00F20h
	POKECODE?C	01Eh
	POKECODE?C	00Ch
	POKECODE?C	006h
	POKECODE?C	00Bh
	POKECODE?C	004h
	POKECODE?C	006h
	POKECODE?C	010h
	POKECODE?C	001h
	POKECODE?C	004h
	POKECODE?C	003h
	POKECODE?C	006h
	POKECODE?C	004h
	POKECODE?C	01Bh
	POKECODE?C	01Ch
	POKECODE?C	007h
	POKECODE?C	01Dh

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00379	POKECODE @$F30, 12,13,2,8

	ORG?C	00F30h
	POKECODE?C	00Ch
	POKECODE?C	00Dh
	POKECODE?C	002h
	POKECODE?C	008h

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00381	POKECODE @$F40, 31,25,25,25,27,7,31,20,24,1,16,9,9,12,1,16

	ORG?C	00F40h
	POKECODE?C	01Fh
	POKECODE?C	019h
	POKECODE?C	019h
	POKECODE?C	019h
	POKECODE?C	01Bh
	POKECODE?C	007h
	POKECODE?C	01Fh
	POKECODE?C	014h
	POKECODE?C	018h
	POKECODE?C	001h
	POKECODE?C	010h
	POKECODE?C	009h
	POKECODE?C	009h
	POKECODE?C	00Ch
	POKECODE?C	001h
	POKECODE?C	010h

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00382	POKECODE @$F50, 24,10,14,27,7,31,14,3,7,4,27,2,8

	ORG?C	00F50h
	POKECODE?C	018h
	POKECODE?C	00Ah
	POKECODE?C	00Eh
	POKECODE?C	01Bh
	POKECODE?C	007h
	POKECODE?C	01Fh
	POKECODE?C	00Eh
	POKECODE?C	003h
	POKECODE?C	007h
	POKECODE?C	004h
	POKECODE?C	01Bh
	POKECODE?C	002h
	POKECODE?C	008h

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00384	POKECODE @$F60, 31,9,24,1,27,14

	ORG?C	00F60h
	POKECODE?C	01Fh
	POKECODE?C	009h
	POKECODE?C	018h
	POKECODE?C	001h
	POKECODE?C	01Bh
	POKECODE?C	00Eh

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00386	POKECODE @$F70, 31,9,3,6,27,14

	ORG?C	00F70h
	POKECODE?C	01Fh
	POKECODE?C	009h
	POKECODE?C	003h
	POKECODE?C	006h
	POKECODE?C	01Bh
	POKECODE?C	00Eh

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00388	POKECODE @$F80, 31,24,9,1,27,14

	ORG?C	00F80h
	POKECODE?C	01Fh
	POKECODE?C	018h
	POKECODE?C	009h
	POKECODE?C	001h
	POKECODE?C	01Bh
	POKECODE?C	00Eh

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00390	POKECODE @$F90, 31,20,13,18,27,14

	ORG?C	00F90h
	POKECODE?C	01Fh
	POKECODE?C	014h
	POKECODE?C	00Dh
	POKECODE?C	012h
	POKECODE?C	01Bh
	POKECODE?C	00Eh

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00392	POKECODE @$FA0, 31,1,10,30,27,14

	ORG?C	00FA0h
	POKECODE?C	01Fh
	POKECODE?C	001h
	POKECODE?C	00Ah
	POKECODE?C	01Eh
	POKECODE?C	01Bh
	POKECODE?C	00Eh

; C:\DOCUME~1\N6VMO\DESKTOP\SARCHAB\SARCHAB7.PBP	00394	POKECODE @$FB0, 31,28,1,14,27,14

	ORG?C	00FB0h
	POKECODE?C	01Fh
	POKECODE?C	01Ch
	POKECODE?C	001h
	POKECODE?C	00Eh
	POKECODE?C	01Bh
	POKECODE?C	00Eh

	END
