; MOUSDESC.ASM
;
; This file contains a set of descriptors for a standard mouse.

#define	EP0_BUFF_SIZE		8	; 8, 16, 32, or 64
#define	MAX_NUM_INT		1	; For tracking Alternate Setting
#define	MAX_EP_NUMBER		1	; UEP1
#define	NUM_CONFIGURATIONS	1
#define	NUM_INTERFACES		1

#define	MODE_PP			_PPBM0
#define	UCFG_VAL		_PUEN|_TRINT|_FS|MODE_PP	; Full-speed
;#define	UCFG_VAL		_PUEN|_TRINT|MODE_PP	; Low-speed

;#define USE_SELF_POWER_SENSE_IO
;#define USE_USB_BUS_SENSE_IO

; DEVICE CLASS USAGE
#define USB_USE_HID

; HID
; Endpoints Allocation
#define	HID_INTF_ID		0x00
#define	HID_UEP			UEP1
#define	HID_BD_OUT		ep1Bo
#define	HID_INT_OUT_EP_SIZE	8
#define	HID_BD_IN		ep1Bi
#define	HID_INT_IN_EP_SIZE	8
#define	HID_NUM_OF_DSC		1

; ******************************************************************
; This table is polled by the host immediately after USB Reset has been released.
; This table defines the maximum packet size EP0 can take.
; See section 9.6.1 of the Rev 1.0 USB specification.
; These fields are application DEPENDENT. Modify these to meet
; your specifications.
; ******************************************************************
DeviceDescriptor
	retlw	(EndDeviceDescriptor-DeviceDescriptor)/2	; bLength Length of this descriptor
	retlw	DSC_DEV		; bDescType This is a DEVICE descriptor
	retlw	0x10		; bcdUSBUSB Revision 1.10 (low byte)
	retlw	0x01		; high byte
	retlw	0x00		; bDeviceClass
	retlw	0x00		; bDeviceSubClass
	retlw	0x00		; bDeviceProtocol
	retlw	EP0_BUFF_SIZE	; bMaxPacketSize for EP0
	retlw	0xD8		; idVendor - 0x04D8 is Microchip Vendor ID (low byte)
	retlw	0x04		; (high byte)
	retlw	0x00		; idProduct (low byte)
	retlw	0x00		; (high byte)
	retlw	0x01		; bcdDevice (low byte)
	retlw	0x00		; (high byte)
	retlw	0x01		; iManufacturer
	retlw	0x02		; iProduct
	retlw	0x03		; iSerialNumber
	retlw	NUM_CONFIGURATIONS	; bNumConfigurations
EndDeviceDescriptor

; ******************************************************************
; This table is retrieved by the host after the address has been set.
; This table defines the configurations available for the device.
; See section 9.6.2 of the Rev 1.0 USB specification (page 184).
; These fields are application DEPENDENT. 
; Modify these to meet your specifications.
; ******************************************************************
; Configuration pointer table
USB_CD_Ptr
Configs
	db	low Config1, high Config1
	db	low Config1, high Config1

; Configuration Descriptor
Config1
	retlw	(Interface1-Config1)/2	; bLength Length of this descriptor
	retlw	DSC_CFG		; bDescType2 = CONFIGURATION
Config1Len
	retlw	low ((EndConfig1-Config1)/2)	; Length of this configuration
	retlw	high ((EndConfig1-Config1)/2)
	retlw	0x01		; bNumInterfaces Number of interfaces
	retlw	0x01		; bConfigValue Configuration Value
	retlw	0x04		; iConfigString Index for this config = #01
	retlw	0xA0		; bmAttributes attributes - bus powered
	retlw	0x50		; Max power consumption (2X mA)
Interface1
	retlw	(HIDDescriptor1-Interface1)/2	; length of descriptor
	retlw	DSC_INTF
	retlw	0x00		; number of interface, 0 based array
	retlw	0x00		; alternate setting
	retlw	0x01		; number of endpoints used in this interface
	retlw	0x03		; interface class - assigned by the USB
	retlw	0x01		; boot device
	retlw	0x02		; interface protocol - mouse
	retlw	0x05		; index to string descriptor that describes this interface
HIDDescriptor1
	retlw	(Endpoint1-HIDDescriptor1)/2	; descriptor size (9 bytes)
	retlw	0x21		; descriptor type (HID)
	retlw	0x00		; HID class release number (1.00)
	retlw	0x01
	retlw	0x00		; Localized country code (none)
	retlw	0x01		; # of HID class descriptor to follow (1)
	retlw	0x22		; Report descriptor type (HID)
ReportDescriptor1Len
	retlw	low ((EndReportDescriptor1-ReportDescriptor1)/2)
	retlw	high ((EndReportDescriptor1-ReportDescriptor1)/2)
Endpoint1
	retlw	(EndConfig1-Endpoint1)/2	; length of descriptor
	retlw	DSC_EP
	retlw	0x81		; EP1, In
	retlw	0x03		; Interrupt
	retlw	0x08		; This should be the size of the endpoint buffer
	retlw	0x00
	retlw	0x0A		; polling interval (10ms)
EndConfig1

ReportDescriptor1
	retlw   0x05
	retlw   0x01    ; usage page (generic desktop)
	retlw   0x09
	retlw   0x02    ; usage (mouse)
	retlw   0xA1
	retlw   0x01    ; collection (application)
	retlw   0x09
	retlw   0x01    ;   usage (pointer)
	retlw   0xA1
	retlw   0x00    ;   collection (linked)
	retlw   0x05
	retlw   0x09    ;     usage page (buttons)
	retlw   0x19
	retlw   0x01    ;     usage minimum (1)
	retlw   0x29
	retlw   0x03    ;     usage maximum (3)
	retlw   0x15
	retlw   0x00    ;     logical minimum (0)
	retlw   0x25
	retlw   0x01    ;     logical maximum (1)
	retlw   0x95
	retlw   0x03    ;     report count (3)
	retlw   0x75
	retlw   0x01    ;     report size (1)
	retlw   0x81
	retlw   0x02    ;     input (3 button bits)
	retlw   0x95
	retlw   0x01    ;     report count (1)
	retlw   0x75
	retlw   0x05    ;     report size (5)
	retlw   0x81
	retlw   0x01    ;     input (constant 5 bit padding)
	retlw   0x05
	retlw   0x01    ;     usage page (generic desktop)
	retlw   0x09
	retlw   0x30    ;     usage (X)
	retlw   0x09
	retlw   0x31    ;     usage (Y)
	retlw   0x15
	retlw   0x81    ;     logical minimum (-127)
	retlw   0x25
	retlw   0x7F    ;     logical maximum (127)
	retlw   0x75
	retlw   0x08    ;     report size (8)
	retlw   0x95
	retlw   0x03    ;     report count (2)
	retlw   0x81
	retlw   0x06    ;     input (2 position bytes X & Y)
	retlw   0xC0    ;   end collection
	retlw   0xC0    ; end collection
EndReportDescriptor1


langids
	retlw   low lang_1
	retlw   high lang_1
	retlw   low lang_2      ; String indexes of different languages
	retlw   high lang_2

lang_1				; English
	retlw   low  String0    ; LangIDs
	retlw   high String0
	retlw   low  String1_l1    
	retlw   high String1_l1
	retlw   low  String2_l1
	retlw   high String2_l1
	retlw   low  String3_l1
	retlw   high String3_l1
	retlw   low  String4_l1
	retlw   high String4_l1
	retlw   low  String5_l1
	retlw   high String5_l1

lang_2
	retlw   low  String0    ; Also point to LangID
	retlw   high String0
	retlw   low  String1_l2
	retlw   high String1_l2
	retlw   low  String2_l2
	retlw   high String2_l2
	retlw   low  String3_l2
	retlw   high String3_l2
	retlw   low  String4_l2
	retlw   high String4_l2
	retlw   low  String5_l2
	retlw   high String5_l2

; String pointer table
USB_SD_Ptr
Strings
	db	low String0, high String0
	db	low String1_l1, high String1_l1
	db	low String2_l1, high String2_l1
	db	low String3_l1, high String3_l1
	db	low String4_l1, high String4_l1
	db	low String5_l1, high String5_l1

String0
	retlw   (String1_l1-String0)/2	; Length of string 
	retlw   DSC_STR		; Descriptor type 3
	retlw   0x09		; Language ID (as defined by MS 0x0409)
	retlw   0x04
	retlw   0x04		; Some other language ID for testing
	retlw   0x08

String1_l1
	retlw   (String2_l1-String1_l1)/2	; Length of string
	retlw   DSC_STR		; Descriptor type 3
	retlw   'M'
	retlw   0x00
	retlw   'i'
	retlw   0x00
	retlw   'c'
	retlw   0x00
	retlw   'r'
	retlw   0x00
	retlw   'o'
	retlw   0x00
	retlw   'c'
	retlw   0x00
	retlw   'h'
	retlw   0x00
	retlw   'i'
	retlw   0x00
	retlw   'p'
	retlw   0x00
String2_l1
	retlw   (String3_l1-String2_l1)/2
	retlw   DSC_STR
	retlw   'P'
	retlw   0x00
	retlw   'I'
	retlw   0x00
	retlw   'C'
	retlw   0x00
	retlw   '1'
	retlw   0x00
	retlw   '8'
	retlw   0x00
	retlw   ' '
	retlw   0x00
	retlw   'U'
	retlw   0x00
	retlw   'S'
	retlw   0x00
	retlw   'B'
	retlw   0x00
	retlw   ' '
	retlw   0x00
	retlw   'M'
	retlw   0x00
	retlw   'o'
	retlw   0x00
	retlw   'u'
	retlw   0x00
	retlw   's'
	retlw   0x00
	retlw   'e'
	retlw   0x00
String3_l1
	retlw   (String4_l1-String3_l1)/2
	retlw   DSC_STR
	retlw   'V'
	retlw   0x00
	retlw   '1'
	retlw   0x00
	retlw   '.'
	retlw   0x00
	retlw   '1'
	retlw   0x00
	retlw   '0'
	retlw   0x00
	retlw	'F'
	retlw	0x00
	retlw	'S'
	retlw	0x00
String4_l1
	retlw   (String5_l1-String4_l1)/2
	retlw   DSC_STR
	retlw   'C'
	retlw   0x00
	retlw   'f'
	retlw   0x00
	retlw	'g'
	retlw   0x00
	retlw	'1'
	retlw   0x00
String5_l1
	retlw   (String6_l1-String5_l1)/2
	retlw   DSC_STR
	retlw   'E'
	retlw   0x00
	retlw   'P'
	retlw   0x00
	retlw   '1'
	retlw   0x00
	retlw   'I'
	retlw   0x00
	retlw   'n'
	retlw   0x00
String6_l1

String1_l2			; Language 2, Chinese. Strings can be totally different than english
	retlw   (String2_l2-String1_l2)/2	; Length of string
	retlw   DSC_STR		; Descriptor type 3
	retlw   'M'
	retlw   0x00
	retlw   'i'
	retlw   0x00
	retlw   'c'
	retlw   0x00
	retlw   'r'
	retlw   0x00
	retlw   'o'
	retlw   0x00
	retlw   'c'
	retlw   0x00
	retlw   'h'
	retlw   0x00
	retlw   'i'
	retlw   0x00
	retlw   'p'
	retlw   0x00
String2_l2
	retlw   (String3_l2-String2_l2)/2
	retlw   DSC_STR
	retlw   'P'
	retlw   0x00
	retlw   'I'
	retlw   0x00
	retlw   'C'
	retlw   0x00
	retlw   '1'
	retlw   0x00
	retlw   '8'
	retlw   0x00
	retlw   ' '
	retlw   0x00
	retlw   'U'
	retlw   0x00
	retlw   'S'
	retlw   0x00
	retlw   'B'
	retlw   0x00
	retlw   ' '
	retlw   0x00
	retlw   'M'
	retlw   0x00
	retlw   'o'
	retlw   0x00
	retlw   'u'
	retlw   0x00
	retlw   's'
	retlw   0x00
	retlw   'e'
	retlw   0x00
String3_l2
	retlw   (String4_l2-String3_l2)/2
	retlw   DSC_STR
	retlw   'V'
	retlw   0x00
	retlw   '1'
	retlw   0x00
	retlw   '.'
	retlw   0x00
	retlw   '1'
	retlw   0x00
	retlw	'F'
	retlw	0x00
	retlw	'S'
	retlw	0x00
String4_l2
	retlw   (String5_l2-String4_l2)/2
	retlw   DSC_STR
	retlw   'C'
	retlw   0x00
	retlw   'f'
	retlw   0x00
	retlw   'g'
	retlw   0x00
	retlw   '1'
	retlw   0x00
String5_l2
	retlw   (String6_l2-String5_l2)/2
	retlw   DSC_STR
	retlw   'E'
	retlw   0x00
	retlw   'P'
	retlw   0x00
	retlw   '1'
	retlw   0x00
	retlw   'I'
	retlw   0x00
	retlw   'n'
	retlw   0x00
String6_l2
