
; PicBasic Pro Compiler 2.45a, (c) 1998, 2004 microEngineering Labs, Inc. All Rights Reserved.  
PM_USED			EQU	1

	INCLUDE	"12F675.INC"


; Define statements.
#define		OSC		 4
#define		DEBUG_REG		 GPIO
#define		DEBUG_BIT		 2
#define		DEBUG_BAUD		 2400
#define		DEBUG_MODE		 0
#define		DEBUG_PACING		 1000

RAM_START       		EQU	00020h
RAM_END         		EQU	0005Fh
RAM_BANKS       		EQU	00001h
BANK0_START     		EQU	00020h
BANK0_END       		EQU	0005Fh
EEPROM_START    		EQU	02100h
EEPROM_END      		EQU	0217Fh

R0              		EQU	RAM_START + 000h
R1              		EQU	RAM_START + 002h
R2              		EQU	RAM_START + 004h
R3              		EQU	RAM_START + 006h
R4              		EQU	RAM_START + 008h
R5              		EQU	RAM_START + 00Ah
R6              		EQU	RAM_START + 00Ch
R7              		EQU	RAM_START + 00Eh
R8              		EQU	RAM_START + 010h
FLAGS           		EQU	RAM_START + 012h
GOP             		EQU	RAM_START + 013h
RM1             		EQU	RAM_START + 014h
RM2             		EQU	RAM_START + 015h
RR1             		EQU	RAM_START + 016h
RR2             		EQU	RAM_START + 017h
_LedNr           		EQU	RAM_START + 018h
_stat            		EQU	RAM_START + 019h
_PORTL           		EQU	 GPIO
_PORTH           		EQU	 GPIO
_TRISL           		EQU	 TRISIO
_TRISH           		EQU	 TRISIO
#define _LedOut          	_GPIO_1
#define _SerialIn        	_GPIO_0
#define _ADCON0_7        	 ADCON0, 007h
#define _GPIO_1          	 GPIO, 001h
#define _GPIO_0          	 GPIO, 000h

; Constants.
_T2400           		EQU	00000h
_T1200           		EQU	00001h
_T9600           		EQU	00002h
_T300            		EQU	00003h
_N2400           		EQU	00004h
_N1200           		EQU	00005h
_N9600           		EQU	00006h
_N300            		EQU	00007h
_OT2400          		EQU	00008h
_OT1200          		EQU	00009h
_OT9600          		EQU	0000Ah
_OT300           		EQU	0000Bh
_ON2400          		EQU	0000Ch
_ON1200          		EQU	0000Dh
_ON9600          		EQU	0000Eh
_ON300           		EQU	0000Fh
_MSBPRE          		EQU	00000h
_LSBPRE          		EQU	00001h
_MSBPOST         		EQU	00002h
_LSBPOST         		EQU	00003h
_LSBFIRST        		EQU	00000h
_MSBFIRST        		EQU	00001h
_CLS             		EQU	00000h
_HOME            		EQU	00001h
_BELL            		EQU	00007h
_BKSP            		EQU	00008h
_TAB             		EQU	00009h
_CR              		EQU	0000Dh
_UnitOn          		EQU	00012h
_UnitOff         		EQU	0001Ah
_UnitsOff        		EQU	0001Ch
_LightsOn        		EQU	00014h
_LightsOff       		EQU	00010h
_Dim             		EQU	0001Eh
_Bright          		EQU	00016h
	INCLUDE	"REMOTE~1.MAC"
	INCLUDE	"PBPPIC14.LIB"


	ASM?
 DEVICE PIC12F675

	ENDASM?

	MOVE?CB	000h, ANSEL
	MOVE?CT	001h, _ADCON0_7
	MOVE?CB	007h, CMCON

	ASM?
 DEVICE PIC12F675, INTRC_OSC; Use internal oscilator

	ENDASM?


	ASM?
 DEVICE PIC12F675, WDT_OFF  ;WATCHDOG

	ENDASM?


	ASM?
 DEVICE PIC12F675, PWRT_OFF ;POWER ON TIMER

	ENDASM?


	ASM?
 DEVICE PIC12F675, BOD_OFF  ;BROWNOUT RESET

	ENDASM?


	ASM?
 DEVICE PIC12F675, MCLR_OFF  

	ENDASM?

	MOVE?CB	0E1h, TRISIO
	MOVE?CB	000h, INTCON
	MOVE?CB	007h, CMCON
	DEBUG?C	00Dh
	DEBUG?C	00Ah
	DEBUG?C	053h
	DEBUG?C	074h
	DEBUG?C	061h
	DEBUG?C	072h
	DEBUG?C	074h
	DEBUG?C	021h
	DEBUG?C	020h
	DEBUG?C	00Dh
	DEBUG?C	00Ah
	MOVE?CT	000h, _LedOut

	LABEL?L	_loop1	
	SERPIN?T	_SerialIn
	SERMODE?C	_T2400

	LABEL?L	L00001	
	SERINQ?CL	061h, L00001
	SERIN?B	_LedNr
	SERIN?B	_stat
	DEBUG?C	04Ch
	DEBUG?C	065h
	DEBUG?C	064h
	DEBUG?C	020h
	DEBUG?C	06Eh
	DEBUG?C	075h
	DEBUG?C	06Dh
	DEBUG?C	062h
	DEBUG?C	065h
	DEBUG?C	072h
	DEBUG?C	020h
	DEBUG?C	03Dh
	DEBUG?C	020h
	DEBUGCOUNT?C	000h
	DEBUGNUM?B	_LedNr
	DEBUGDEC?	
	DEBUG?C	020h
	DEBUG?C	020h
	DEBUG?C	053h
	DEBUG?C	074h
	DEBUG?C	061h
	DEBUG?C	074h
	DEBUG?C	065h
	DEBUG?C	020h
	DEBUG?C	03Dh
	DEBUG?C	020h
	DEBUGCOUNT?C	000h
	DEBUGNUM?B	_stat
	DEBUGDEC?	
	DEBUG?C	00Dh
	DEBUG?C	00Ah
	CMPEQ?BCL	_LedNr, 030h, _outr1
	GOTO?L	_loop1

	LABEL?L	_outr1	
	CMPEQ?BCL	_stat, 031h, _high1
	PAUSE?C	032h
	MOVE?CT	000h, _LedOut
	GOTO?L	_loop1

	LABEL?L	_high1	
	PAUSE?C	032h
	MOVE?CT	001h, _LedOut
	GOTO?L	_loop1
	END?	

	END
