'****************************************************************
'*  Name    : Scroll-clock-thermometer-with-16F877A
'                    with setting procedure
'             by NICULESCU DAN - october, 21, 2011
'****************************************************************
@ DEVICE pic16F877A, XT_OSC, WDT_ON, LVP_OFF, PWRT_ON, BOD_ON
DEFINE OSC 4

INCLUDE "ALLDIGITAL.pbp" 
OPTION_REG.7 = 0
ADCON1 = 7


PORTA = %00000001 'Set all INPUTS to 0 
TRISA = %00000001 'Set PORTA RA0-RA5
PORTB = %00000000 'Set all outputs to 0 (off)
TRISB = %00000000 'Set PORTB to all output
PORTC = %11100000 'Set all outputs to 0 (off) EXCEPT DQ
TRISC = %11100000 'Set PORTC
PORTD = %00000000 'Set all outputs to 0 (off)
TRISD = %00000000 'Set PORTB to all output

	DecButton var PORTC.6	' Press to Decrement Button
	SetButton var PORTC.7	' Press to Set/memorise Button
	IncButton var PORTC.5	' Press to Increment Button

Debounce con 250
              
DQ     var  PortA.0

SDA Var PORTC.0 ' DS1307 SDA pin #5
SCL Var PORTC.1 ' DS1307 SCL pin #6

'***************************************************************************************
 eeprom 0, [%10100001,%01111010,%01110110,%01101110,%10100001]      '0
 eeprom 5, [%11111111,%01111101,%00000000,%01111111,%11111111]      '1
 eeprom 10,[%01111101,%00111110,%01101110,%01110110,%01111001]      '2
 eeprom 15,[%10111101,%01111110,%01110110,%01110110,%10101001]      '3
 eeprom 20,[%11100111,%11101011,%11101101,%00000000,%11101111]      '4
 eeprom 25,[%10111000,%01111010,%01111010,%01111010,%10100110]      '5
 eeprom 30,[%10100001,%01110110,%01110110,%01110110,%10101101]      '6
 eeprom 35,[%11111110,%00001110,%11110110,%11111010,%11111100]      '7
 eeprom 40,[%10001001,%01110110,%01110110,%01110110,%10001001]      '8
 eeprom 45,[%11111001,%01110110,%01110110,%01110110,%10001001]      '9

    counter           var      byte
    scan              var      byte
    scroll            var      byte
    leddata           var      byte[75]    'Column Data for display 75 columns
    temperature       var      Word        'reading from sensor
    Sign              var      BIT
    tempA             var      byte        'Stores First digit (High)
    tempB             var      byte        'stores Second digit (Mid)
    tempC             var      byte        'stores Third digit (low)
    n                 var      byte

DB       Var BYTE[8] ' Data byte array
RTCSec   Var DB[0]   ' alias individual bytes in array
RTCDay   Var DB[3]
RTCDate  Var DB[4]
RTCMonth Var DB[5]
RTCYear  Var DB[6]

 
	CounterA var byte	' General purpose Variable
	CounterB var byte	' General purpose Variable
	CounterC var byte	' General purpose Variable
	CounterD var byte	' General purpose Variable
    ore     var word
    minute  var word
    oraa    var byte
    orab    var byte
    minutea var byte
    minuteb var byte

    
DS18B20_12bit     CON %01111111

	RTCMin var byte		' Minutes
	RTCHour var byte		' Hours
	RTCCtrl var byte		' Control 
	SetSec var byte		' Seconds
	SetMin var byte		' Minutes
	SetDecMin Var byte
	SetHour var byte		' Hours
	SetDecHour var byte
	TimeOut var word		' Variable for SetUp Menu Time-Out

	ButtonRepeat con 200	' Timeperiod in mS for Edit Buttons auto-repeat

DisplayLoop:
Clear
	If SetButton=0 then
		Gosub SetButtonRelease
		goto Setup
		endif
' Init Sensor 
 OWOUT DQ, 1, [$CC, $4E, 0, 0, DS18B20_12bit]
 OWOut DQ, 1, [$CC, $48]                   
 OWOut DQ, 1, [$CC, $B8] 
 OWOut DQ, 1, [$CC, $BE] 
 Pause 50
 OWIn DQ, 2, [temperature.byte0, temperature.byte1]
 Pause 50 
                 
 OWOut DQ, 1, [$CC, $44] 
 OWOut DQ, 1, [$CC, $BE]
 OWIn DQ, 2, [temperature.byte0, temperature.byte1]         
    Sign = temperature.15
    temperature= ABS(temperature)
    temperature=((temperature >> 4)*100) + ((temperature & $F) * 100 >> 4)
    if sign then temperature= -temperature
  
    tempA = temperature DIG 3
    tempB = temperature DIG 2
    tempC = temperature DIG 1
                         
if tempA = 0 then
    FOR counter = 0 TO 4
    leddata [counter+8] = %11111111
    next
    else
    for counter = 0 to 4
        READ tempA*5+counter,leddata [counter+8]     'stores 1st digit in leddata locations 8,9,10,11,12    
    NEXT 
endif    
    FOR counter = 0 TO 4
        READ tempB*5+counter,leddata [counter+14]    'stores 2nd digit in leddata locations 14,15,16,17,18
    NEXT
    
    FOR counter = 0 TO 4
        READ tempC*5+counter,leddata [counter+23]    'stores 3rd digit in leddata locations 23,24,25,26,27
    NEXT   

    gosub read_1307

    oraa =  ore dig 1
    orab =  ore dig 0
    minutea =  minute dig 1
    minuteb =  minute dig 0
    
    FOR counter = 0 TO 4
        READ oraa*5+counter,leddata [counter+41]    
    NEXT 
    
    FOR counter = 0 TO 4
        READ orab*5+counter,leddata [counter+47]    
    NEXT 



    FOR counter = 0 TO 4
        READ minutea*5+counter,leddata [counter+57]    'stores tens minutes digit in leddata locations 
    NEXT
    
    FOR counter = 0 TO 4
        READ minuteb*5+counter,leddata [counter+63]    'stores unit minutes digit in leddata locations 
    NEXT 

for n=0 to 7
leddata [n] = %11111111
next n
    leddata [13] = %11111111
    leddata [19] = %11111111
    leddata [20] = %00111111    ' DECIMAL POINT
    leddata [21] = %00111111
    leddata [22] = %11111111
    leddata [28] = %11111111
    leddata [29] = %11111100    ' degrees c
    leddata [30] = %11111100
    leddata [31] = %11100011
    leddata [32] = %10111101    
    leddata [33] = %10111101
    leddata [34] = %10111101
    leddata [35] = %11111111
    leddata [36] = %11111111
    leddata [37] = %11111111
    leddata [38] = %11111111
    leddata [39] = %11111111
    leddata [40] = %11111111
    leddata [46] = %11111111
    leddata [52] = %11111111
    leddata [53] = %11111111      
    leddata [54] = %10111011
    leddata [55] = %11111111
    leddata [56] = %11111111
    leddata [62] = %11111111
    leddata [68] = %11111111
    leddata [69] = %11111111
    leddata [70] = %11111111
    leddata [71] = %11111111
    leddata [72] = %11111111
    leddata [73] = %11111111
    leddata [74] = %11111111
    leddata [75] = %11111111
	'
	'	Display RTC
	'	-----------
LOOPing:
FOR scroll = 0 TO 70
    FOR scan = 0 TO 7
        PORTB=%11111111
        PAUSE 1
        PORTD = 1
        FOR counter = 0 TO 7
            PORTB = leddata [counter]          
            PAUSE 1          
            PORTD = PORTD * 2
        NEXT
    NEXT
    FOR counter = 0 TO 70
        leddata [counter] = leddata [counter+1]
    NEXT
NEXT
	'
	Pause 250		' Repeat about 4 times/sec
Goto DisplayLoop

	'
	'	Clock and Calandar Settings
	'	===========================
		'
		'	Initial Default Settings
		'	------------------------
		'
SetupPreset:
	RTCSec =$00		' Seconds preset to 00
	RTCMin =$00		' Minutes preset to 15
	RTCHour=$13		' Hours preset to 13'00
	RTCCtrl=$10		' Control preset to output 1 second 'Tick' on SQWpin 
		'
		'	Convert the Current BCD Data to Something easier to Edit
		'	--------------------------------------------------------
Setup:
	SetHour=SetHour*10+(RTCHour&$0F)
	SetMin=((RTCMin>>4)&$0F)*10+(RTCMin&$0F)
	CounterC=0		' Set to Start of Setup (seven steps from 0 to 6)
	TimeOut=0		' Zero the Time-Out counter
		'	------------------
SetupEntryLoop:
oraa = setDechour 
orab = sethour 
minutea = setDecmin 
minuteb = setmin
gosub staticx
			'
			'	Decrement Button Pressed
			'	------------------------
	If DecButton=0 then
				'
				'	Decrement Tens Hours
				'	---------------
		If CounterC=0 then	
			If SetDecHour=0 then
				SetDecHour=2
				else
				SetDecHour=SetDecHour-1
			endif
		endif
				'
				'	Decrement Units Hours
				'	---------------
		If CounterC=1 then
            IF SetHour=0 THEN
                SetHour= 9
                else	
				SetHour=SetHour-1
			Endif
		endif				
                '
				'	Decrement Tens Minutes
				'	-----------------
		If CounterC=2 then
			If SetDecMin=0 then
				SetDecMin=5
				else
				SetDecMin=SetDecMin-1
			endif
		endif
                                   
                '
				'	Decrement Units Minutes
				'	-----------------
		If CounterC=3 then
			If SetMin=0 then
				SetMin=9
				else
				SetMin=SetMin-1
			endif
		endif
			
		Pause ButtonRepeat
		TimeOut=0
		Goto SetupEntryLoop
		endif
			'
			'	Increment Button Pressed
			'	------------------------
			' 	This is just like Decrement but opposite...
	If IncButton=0 then
				'
				'
				'	Increment Tens Hours
				'	---------------
		If CounterC=0 then	
			If SetDecHour=2 then
				SetDecHour=0
				else
				SetDecHour=SetDecHour+1
			endif
		endif
				'
				'	Increment Units Hours
				'	---------------
		If CounterC=1 then
            IF SetHour=9 THEN
                SetHour=0
                else	
				SetHour=SetHour+1
			Endif
		endif				
                '
				'	Increment Tens Minutes
				'	-----------------
		If CounterC=2 then
			If SetDecMin=5 then
				SetDecMin=0
				else
				SetDecMin=SetDecMin+1
			endif
		endif
                                   
                '
				'	Increment Units Minutes
				'	-----------------
		If CounterC=3 then
			If SetMin=9 then
				SetMin=0
				else
				SetMin=SetMin+1
			endif
		endif

		Pause ButtonRepeat
		TimeOut=0
		Goto SetupEntryLoop
		endif
			'
			'	Set Button Pressed
			'	------------------
	If SetButton=0 then
		CounterC=CounterC+1
				' Increment Menu Item
		TimeOut=0
		If CounterC>3 then
				'    Save Data if all edit items exhaused
				'
				'	Save Hours to BCD DS1307's Format
				'	---------------------------------------
			CounterA= (SetDecHour *10)+ SetHour  
			Gosub ConvertBCD
			RTCHour=CounterB			
         		'
				'	Save Minutes to BCD DS1307's Format
				'	---------------------------------------
			CounterA= (SetDecMin *10) + SetMin 
			Gosub ConvertBCD
			RTCMin=CounterB
				'
				'	Do the Business
				'	---------------
			I2CWrite SDA,SCL,$D0,$00,[RTCSec,RTCMin,RTCHour,RTCDay,RTCMonth,RTCYear,RTCCtrl]
			Pause 1000
			Gosub SetButtonRelease
			Goto DisplayLoop
			endif
		Gosub SetButtonRelease
		Goto SetupEntryLoop	' Loop for Next Menu Item
		endif
		'
		'	Menu TimeOut Counter
		'	--------------------
	Pause 1			' Kill 1mS 
	TimeOut=TimeOut+1
	If TimeOut>2000 then goto DisplayLoop
				' User paused too long
				' Return User to Time & Date Display
				' This will however bounce the User to the original
				' Setup Menu start point if the DS1307 has not 
				' been initialised
	Goto SetupEntryLoop	' Loop for Button Press

	'
read_1307:                              				' Read time Secs,Mins,Hours,Day,Date,Month,Year,Control
    I2CREAD SDA,SCL,$D1,$00,[STR DB\8]  				' Read 8 bytes from DS1307
ore     = (db[2] & $F )+((db[2]>>4)*10) 				' Hex to Dec hour
minute  = (db[1] & $F )+((db[1]>>4)*10) 				' Hex to Dec minutes
RETURN

	'
	'	Subroutine Converts back to BCD
	'	-------------------------------
		' CounterA is the entry variable
		' CounterB holds the converted BCD result on exit
ConvertBCD:
	CounterB=CounterA DIG 1
	CounterB=CounterB<<4
	CounterB=CounterB+CounterA DIG 0
	Return

SetButtonRelease:
	While SetButton=0:Wend
	Pause 250	' Small pause to kill any Key-Bounce
	Return

	
staticx:
if counterc=0 then
    portb=0
    portd=0
    pause 1
    FOR counter = 0 TO 4
        READ oraa*5+counter,leddata [counter]    
    NEXT 
        PORTB=%11111111
        PORTD = 1
        FOR counter = 0 TO 4
           PORTB = leddata [counter]       
           PORTD = PORTD * 2
        leddata [counter] = leddata [counter+1]
        NEXT
endif 

if counterc=1 then
    portb=0
    portd=0
    pause 1
    FOR counter = 0 TO 4
        READ orab*5+counter,leddata [counter]    
    NEXT 
        PORTB=%11111111
        PORTD = 1
        FOR counter = 0 TO 4
           PORTB = leddata [counter]       
           PORTD = PORTD * 2
        leddata [counter] = leddata [counter+1]
        NEXT
endif       

if counterc=2 then
    portb=0
    portd=0
    pause 1
    FOR counter = 0 TO 4
        READ minutea*5+counter,leddata [counter]    
    NEXT 
        PORTB=%11111111
        PORTD = 1
        FOR counter = 0 TO 4
           PORTB = leddata [counter]       
           PORTD = PORTD * 2
        leddata [counter] = leddata [counter+1]
        NEXT
endif       

if counterc=3 then
    portb=0
    portd=0
    pause 1
    FOR counter = 0 TO 4
        READ minuteb*5+counter,leddata [counter]    
    NEXT 
        PORTB=%11111111
        PORTD = 1
        FOR counter = 0 TO 4
           PORTB = leddata [counter]       
           PORTD = PORTD * 2
        leddata [counter] = leddata [counter+1]
        NEXT
endif 
return

End        ; of story




