
; PICBASIC PRO(TM) Compiler 2.60LA, (c) 1998, 2009 microEngineering Labs, Inc. All Rights Reserved. 
_USED			EQU	1

	INCLUDE	"C:\PBP\18F4550.INC"


; Define statements.
#define		OSC		    20    

RAM_START       		EQU	00000h
RAM_END         		EQU	007FFh
RAM_BANKS       		EQU	00008h
BANK0_START     		EQU	00060h
BANK0_END       		EQU	000FFh
BANK1_START     		EQU	00100h
BANK1_END       		EQU	001FFh
BANK2_START     		EQU	00200h
BANK2_END       		EQU	002FFh
BANK3_START     		EQU	00300h
BANK3_END       		EQU	003FFh
BANK4_START     		EQU	00400h
BANK4_END       		EQU	004FFh
BANK5_START     		EQU	00500h
BANK5_END       		EQU	005FFh
BANK6_START     		EQU	00600h
BANK6_END       		EQU	006FFh
BANK7_START     		EQU	00700h
BANK7_END       		EQU	007FFh
BANKA_START     		EQU	00000h
BANKA_END       		EQU	0005Fh

FLAGS           		EQU	RAM_START + 000h
GOP             		EQU	RAM_START + 001h
R4              		EQU	RAM_START + 002h
R5              		EQU	RAM_START + 004h
R6              		EQU	RAM_START + 006h
R7              		EQU	RAM_START + 008h
R8              		EQU	RAM_START + 00Ah
RM1             		EQU	RAM_START + 00Ch
RM2             		EQU	RAM_START + 00Dh
RR1             		EQU	RAM_START + 00Eh
RR2             		EQU	RAM_START + 00Fh
RS1             		EQU	RAM_START + 010h
RS2             		EQU	RAM_START + 011h
R0              		EQU	RAM_START + 012h
R1              		EQU	RAM_START + 016h
R2              		EQU	RAM_START + 01Ah
R3              		EQU	RAM_START + 01Eh
T1              		EQU	RAM_START + 022h
T2              		EQU	RAM_START + 026h
T3              		EQU	RAM_START + 02Ah
T4              		EQU	RAM_START + 02Eh
PB01            		EQU	RAM_START + 032h
_DISK_BytesPerSec		EQU	RAM_START + 033h
_DISK_fatsize    		EQU	RAM_START + 035h
_DISK_maxroot    		EQU	RAM_START + 037h
_FAT_c           		EQU	RAM_START + 039h
_FAT_ccls        		EQU	RAM_START + 03Bh
_FAT_cls         		EQU	RAM_START + 03Dh
_FAT_cluster     		EQU	RAM_START + 03Fh
_FAT_count       		EQU	RAM_START + 041h
_FAT_curEntry    		EQU	RAM_START + 043h
_FAT_fHandle     		EQU	RAM_START + 045h
_FAT_n           		EQU	RAM_START + 047h
_FAT_p           		EQU	RAM_START + 049h
_FAT_pos         		EQU	RAM_START + 04Bh
_FAT_RootDirSectors		EQU	RAM_START + 04Dh
_FAT_rwCount     		EQU	RAM_START + 04Fh
_FAT_v           		EQU	RAM_START + 051h
_FILE_attributes 		EQU	RAM_START + 053h
_FILE_ccls       		EQU	RAM_START + 055h
_FILE_chk        		EQU	RAM_START + 057h
_FILE_cluster    		EQU	RAM_START + 059h
_FILE_date       		EQU	RAM_START + 05Bh
_FILE_dirccls    		EQU	RAM_START + 05Dh
_DISK_fatcopy    		EQU	RAM_START + 05Fh
_DISK_mount      		EQU	RAM_START + 060h
_FILE_dirclus    		EQU	RAM_START + 061h
_FILE_entry      		EQU	RAM_START + 063h
_FILE_pos        		EQU	RAM_START + 065h
_FILE_sec        		EQU	RAM_START + 067h
_FILE_time       		EQU	RAM_START + 069h
_SDC_index       		EQU	RAM_START + 06Bh
_SDC_timeout1    		EQU	RAM_START + 06Dh
_DISK_SecPerClus 		EQU	RAM_START + 06Fh
_DISK_type       		EQU	RAM_START + 070h
_FAT_a           		EQU	RAM_START + 071h
_FAT_character   		EQU	RAM_START + 072h
_FAT_day         		EQU	RAM_START + 073h
_FAT_error       		EQU	RAM_START + 074h
_FAT_ForceRead   		EQU	RAM_START + 075h
_FAT_hours       		EQU	RAM_START + 076h
_FAT_i           		EQU	RAM_START + 077h
_FAT_minutes     		EQU	RAM_START + 078h
_FAT_mode        		EQU	RAM_START + 079h
_FAT_month       		EQU	RAM_START + 07Ah
_FAT_numofclus   		EQU	RAM_START + 07Bh
_FAT_offset2     		EQU	RAM_START + 07Ch
_FAT_seconds     		EQU	RAM_START + 07Dh
_FAT_status      		EQU	RAM_START + 07Eh
_FAT_test        		EQU	RAM_START + 07Fh
_FAT_year        		EQU	RAM_START + 080h
_SDC_cmd         		EQU	RAM_START + 081h
_SDC_CmdCode     		EQU	RAM_START + 082h
_SDC_CRC         		EQU	RAM_START + 083h
_SDC_data_in     		EQU	RAM_START + 084h
_SDC_data_out    		EQU	RAM_START + 085h
_SDC_moredataexpected		EQU	RAM_START + 086h
_SDC_response    		EQU	RAM_START + 087h
_SDC_status      		EQU	RAM_START + 088h
_SDC_UseHardSPI  		EQU	RAM_START + 089h
_DISK_data       		EQU	RAM_START + 08Ah
_DISK_fat        		EQU	RAM_START + 08Eh
_DISK_firsts     		EQU	RAM_START + 092h
_DISK_maxcls     		EQU	RAM_START + 096h
_DISK_root       		EQU	RAM_START + 09Ah
_FAT_offset      		EQU	RAM_START + 09Eh
_FAT_sector      		EQU	RAM_START + 0A2h
_FAT_seek        		EQU	RAM_START + 0A6h
_FAT_size        		EQU	RAM_START + 0AAh
_FAT_TotSec      		EQU	RAM_START + 0AEh
_FILE_seek       		EQU	RAM_START + 0B2h
_FILE_size       		EQU	RAM_START + 0B6h
_SDC_address     		EQU	RAM_START + 0BAh
_SDC_sector_addr 		EQU	RAM_START + 0BEh
_SDC_timeout     		EQU	RAM_START + 0C2h
_FAT_FileName    		EQU	RAM_START + 0C6h
_FAT_FileName1   		EQU	RAM_START + 0D1h
_FAT_FileName2   		EQU	RAM_START + 0DCh
_FILE_name       		EQU	RAM_START + 0E7h
_DIRL            		EQU	RAM_START + 0F4h
_FAT_dest        		EQU	RAM_START + 00114h
_SDC_buffer      		EQU	RAM_START + 00314h
_DIR_FileSize    		EQU	_DIRL + 01Ch
_DISK_buffer     		EQU	_SDC_buffer
_FAT_src         		EQU	_FAT_dest
_DIRW            		EQU	_DIRL
_DIR_CrtTime     		EQU	_DIRW + 00Eh
_DIR_CrtDate     		EQU	_DIRW + 010h
_DIR_LstAccDate  		EQU	_DIRW + 012h
_DIR_FstClusHI   		EQU	_DIRW + 014h
_DIR_WrtTime     		EQU	_DIRW + 016h
_DIR_WrtDate     		EQU	_DIRW + 018h
_DIR_FstClusLO   		EQU	_DIRW + 01Ah
_DIRL??WORD0     		EQU	_DIRL
_PORTL           		EQU	 PORTB
_PORTH           		EQU	 PORTC
_TRISL           		EQU	 TRISB
_TRISH           		EQU	 TRISC
_DIRB            		EQU	_DIRL
_DIR_Name        		EQU	_DIRB
_DIR_Extension   		EQU	_DIRB + 008h
_DIR_Attr        		EQU	_DIRB + 00Bh
_DIR_NTRes       		EQU	_DIRB + 00Ch
_DIR_CrtTimeTenth		EQU	_DIRB + 00Dh
_DIRL??BYTE0     		EQU	_DIRL
_SDC_address??BYTE3		EQU	_SDC_address + 003h
_SDC_address??BYTE2		EQU	_SDC_address + 002h
_SDC_address??BYTE1		EQU	_SDC_address + 001h
_SDC_address??BYTE0		EQU	_SDC_address
_DISK_firsts??BYTE0		EQU	_DISK_firsts
_DISK_firsts??BYTE1		EQU	_DISK_firsts + 001h
_DISK_firsts??BYTE2		EQU	_DISK_firsts + 002h
_DISK_firsts??BYTE3		EQU	_DISK_firsts + 003h
_DISK_BytesPerSec??BYTE0		EQU	_DISK_BytesPerSec
_DISK_BytesPerSec??BYTE1		EQU	_DISK_BytesPerSec + 001h
_DISK_maxroot??BYTE0		EQU	_DISK_maxroot
_DISK_maxroot??BYTE1		EQU	_DISK_maxroot + 001h
_DISK_fatsize??BYTE0		EQU	_DISK_fatsize
_DISK_fatsize??BYTE1		EQU	_DISK_fatsize + 001h
_FAT_TotSec??BYTE0		EQU	_FAT_TotSec
_FAT_TotSec??BYTE1		EQU	_FAT_TotSec + 001h
_FAT_TotSec??BYTE2		EQU	_FAT_TotSec + 002h
_FAT_TotSec??BYTE3		EQU	_FAT_TotSec + 003h
_FAT_ccls??BYTE0 		EQU	_FAT_ccls
_FAT_ccls??BYTE1 		EQU	_FAT_ccls + 001h
_FAT_c??BYTE0    		EQU	_FAT_c
_FAT_c??BYTE1    		EQU	_FAT_c + 001h
_FAT_v??BYTE0    		EQU	_FAT_v
_FAT_v??BYTE1    		EQU	_FAT_v + 001h
#define _SD_WE           	_PORTA??4
#define _SD_WE_TRIS      	_TRISA??4
#define _SDI             	_PORTB??0
#define _SDI_TRIS        	_TRISB??0
#define _SCL             	_PORTB??1
#define _SCL_TRIS        	_TRISB??1
#define _SD_CS           	_PORTB??3
#define _SD_CS_TRIS      	_TRISB??3
#define _SD_CD           	_PORTB??4
#define _SD_CD_TRIS      	_TRISB??4
#define _SDO             	_PORTC??7
#define _SDO_TRIS        	_TRISC??7
#define _SSPEN           	_SSPCON1??5
#define _WCOL            	_SSPCON1??7
#define _BF              	_SSPSTAT??0
#define _SSPIF           	_PIR1??3
#define _FILE_Flags_write	 PB01, 001h
#define _FILE_Flags_FileWriteEOF	 PB01, 000h
#define _PORTA??4        	 PORTA, 004h
#define _TRISA??4        	 TRISA, 004h
#define _PORTB??0        	 PORTB, 000h
#define _TRISB??0        	 TRISB, 000h
#define _PORTB??1        	 PORTB, 001h
#define _TRISB??1        	 TRISB, 001h
#define _PORTB??3        	 PORTB, 003h
#define _TRISB??3        	 TRISB, 003h
#define _PORTB??4        	 PORTB, 004h
#define _TRISB??4        	 TRISB, 004h
#define _PORTC??7        	 PORTC, 007h
#define _TRISC??7        	 TRISC, 007h
#define _SSPCON1??5      	 SSPCON1, 005h
#define _SSPCON1??7      	 SSPCON1, 007h
#define _SSPSTAT??0      	 SSPSTAT, 000h
#define _PIR1??3         	 PIR1, 003h
#define _PORTC??6        	 PORTC, 006h

; Constants.
_USBMEMORYADDRESS		EQU	00400h
_MEDIA_SECTOR_SIZE		EQU	00200h
_GO_IDLE_STATE   		EQU	00000h
_SEND_OP_COND    		EQU	00001h
_SET_BLOCKLEN    		EQU	00002h
_READ_SINGLE_BLOCK		EQU	00003h
_WRITE_SINGLE_BLOCK		EQU	00004h
_CRC_ON_OFF      		EQU	00005h
_NODATA          		EQU	00000h
_MOREDATA        		EQU	00001h
_DATA_START_TOKEN		EQU	000FEh
_DATA_ACCEPTED   		EQU	00005h
_SDC_FLOATING_BUS		EQU	000FFh
_SDC_BAD_RESPONSE		EQU	000FFh
_sdcValid        		EQU	00000h
_sdcCardInitCommFailure		EQU	00001h
_sdcCardNotInitFailure		EQU	00002h
_sdcCardInitTimeout		EQU	00003h
_sdcCardBadCmd   		EQU	00005h
_sdcCardTimeout  		EQU	00006h
_sdcCardDataRejected		EQU	00008h
_FAT_BUFFER_SIZE 		EQU	00200h
_CE_GOOD         		EQU	00000h
_CE_ERASE_FAIL   		EQU	00001h
_CE_NOT_PRESENT  		EQU	00002h
_CE_NOT_FORMATTED		EQU	00003h
_CE_BAD_PARTITION		EQU	00004h
_CE_UNSUPPORTED_FS		EQU	00005h
_CE_INIT_ERROR   		EQU	00006h
_CE_NOT_INIT     		EQU	00007h
_CE_BAD_SECTOR_READ		EQU	00008h
_CE_WRITE_ERROR  		EQU	00009h
_CE_INVALID_CLUSTER		EQU	0000Ah
_CE_FILE_NOT_FOUND		EQU	0000Bh
_CE_DIR_NOT_FOUND		EQU	0000Ch
_CE_BAD_FILE     		EQU	0000Dh
_CE_DONE         		EQU	0000Eh
_CE_COULD_NOT_GET_CLUSTER		EQU	0000Fh
_CE_FILENAME_2_LONG		EQU	00010h
_CE_FILENAME_EXISTS		EQU	00011h
_CE_INVALID_FILENAME		EQU	00012h
_CE_DELETE_DIR   		EQU	00013h
_CE_DIR_FULL     		EQU	00014h
_CE_DISK_FULL    		EQU	00015h
_CE_DIR_NOT_EMPTY		EQU	00016h
_CE_NONSUPPORTED_SIZE		EQU	00017h
_CE_WRITE_PROTECTED		EQU	00018h
_CE_FILENOTOPENED		EQU	00019h
_CE_SEEK_ERROR   		EQU	0001Ah
_CE_BADCACHEREAD 		EQU	0001Bh
_CE_CARDFAT32    		EQU	0001Ch
_CE_READONLY     		EQU	0001Dh
_CE_CARDFAT12    		EQU	0001Eh
_CE_WRITEONLY    		EQU	0001Fh
_CE_INVALID_ARGUMENT		EQU	00020h
_CE_FAT_EOF      		EQU	0003Ch
_CE_EOF          		EQU	0003Dh
_DIR_NAMESIZE    		EQU	00008h
_DIR_EXTENSIONSIZE		EQU	00003h
_FALSE           		EQU	00000h
_TRUE            		EQU	00001h
_NUMBER_OF_BYTES_IN_DIR_ENTRY		EQU	00020h
_DIRENTRIES_PER_SECTOR		EQU	00010h
_ATTR_MASK       		EQU	0003Fh
_ATTR_READ_ONLY  		EQU	00001h
_ATTR_HIDDEN     		EQU	00002h
_ATTR_SYSTEM     		EQU	00004h
_ATTR_VOLUME     		EQU	00008h
_ATTR_LONG_NAME  		EQU	0000Fh
_ATTR_DIRECTORY  		EQU	00010h
_ATTR_ARCHIVE    		EQU	00020h
_DIR_DEL         		EQU	000E5h
_DIR_EMPTY       		EQU	00000h
_FOUND           		EQU	00000h
_ERASED          		EQU	00000h
_NOT_FOUND       		EQU	00001h
_NO_MORE         		EQU	00002h
_WRITE_ERROR     		EQU	00003h
_FAT12           		EQU	00001h
_FAT16           		EQU	00002h
_FAT32           		EQU	00003h
_FILE_NAME_SIZE  		EQU	0000Bh
_CLUSTER_EMPTY   		EQU	00000h
_CLUSTER_FAIL    		EQU	0FFFFh
_END_CLUSTER     		EQU	0FFF7h
_LAST_CLUSTER    		EQU	0FFF8h
_LAST_CLUSTER_FAT16		EQU	0FFF8h
	INCLUDE	"NRU.MAC"
	INCLUDE	"C:\PBP\PBPPI18L.LIB"

	MOVE?CB	_TRUE, _SDC_UseHardSPI
	MOVE?CB	_FALSE, _DISK_mount
	MOVE?CB	072h, _FAT_mode
	MOVE?CW	000h, _FAT_count
	GOTO?L	_SkipSD

	LABEL?L	_InitIO	
	MOVE?CT	001h, _SD_CS
	MOVE?CT	000h, _SD_CS_TRIS
	MOVE?CT	001h, _SD_CD_TRIS
	MOVE?CT	001h, _SD_WE_TRIS
	MOVE?CT	001h, _SDO
	MOVE?CT	000h, _SDO_TRIS
	MOVE?CT	001h, _SDI_TRIS
	MOVE?CT	001h, _SCL
	MOVE?CT	000h, _SCL_TRIS
	RETURN?	

	LABEL?L	_OpenSPIM	
	CMPF?BL	_SDC_UseHardSPI, L00004
	MOVE?CB	000h, SSPSTAT
	MOVE?CB	012h, SSPCON1
	MOVE?CT	001h, _SSPEN
	LABEL?L	L00004	
	RETURN?	

	LABEL?L	_OpenSPIMFast	
	CMPF?BL	_SDC_UseHardSPI, L00006
	MOVE?CB	000h, SSPSTAT
	MOVE?CB	010h, SSPCON1
	MOVE?CT	001h, _SSPEN
	LABEL?L	L00006	
	RETURN?	

	LABEL?L	_CloseSPIM	
	CMPF?BL	_SDC_UseHardSPI, L00008
	MOVE?CT	000h, _SSPEN
	LABEL?L	L00008	
	RETURN?	

	LABEL?L	_ReadMedia	
	CMPF?BL	_SDC_UseHardSPI, L00010
	MOVE?BB	SSPBUF, _SDC_data_in
	MOVE?CT	000h, _SSPIF
	MOVE?CB	0FFh, SSPBUF
	LABEL?L	L00012	
	CMPT?TL	_SSPIF, L00013
	GOTO?L	L00012
	LABEL?L	L00013	
	MOVE?BB	SSPBUF, _SDC_data_in
	GOTO?L	L00011
	LABEL?L	L00010	
	MOVE?CT	001h, _SDO
	SHIFTDATA?T	_SDI
	SHIFTCLOCK?T	_SCL
	SHIFTMODE?C	006h
	SHIFTIN?BC	_SDC_data_in, 008h
	LABEL?L	L00011	
	RETURN?	

	LABEL?L	_SendCRC	

	LABEL?L	_ReadCRC	
	MOVE?CB	0FFh, _SDC_data_out
	GOSUB?L	_WriteSPIM

	LABEL?L	_Send8ClkCycles	
	MOVE?CB	0FFh, _SDC_data_out

	LABEL?L	_WriteSPIM	
	CMPF?BL	_SDC_UseHardSPI, L00014
	MOVE?BB	SSPBUF, _SDC_data_in
	MOVE?CT	000h, _SSPIF
	MOVE?BB	_SDC_data_out, SSPBUF
	CMPF?TL	_WCOL, L00016
	RETURN?	
	LABEL?L	L00016	
	LABEL?L	L00018	
	CMPT?TL	_SSPIF, L00019
	GOTO?L	L00018
	LABEL?L	L00019	
	GOTO?L	L00015
	LABEL?L	L00014	
	SHIFTDATA?T	_SDO
	SHIFTCLOCK?T	_SCL
	SHIFTMODE?C	005h
	SHIFTOUT?BC	_SDC_data_out, 008h
	LABEL?L	L00015	
	RETURN?	

	LABEL?L	_sdmmc_cmdtable	
	LOOKUP?BCLB	_SDC_cmd, 006h, L00001, _SDC_CmdCode
	LURET?C	040h
	LURET?C	041h
	LURET?C	050h
	LURET?C	051h
	LURET?C	058h
	LURET?C	07Bh

	LABEL?L	L00001	
	LOOKUP?BCLB	_SDC_cmd, 006h, L00002, _SDC_CRC
	LURET?C	095h
	LURET?C	0F9h
	LURET?C	0FFh
	LURET?C	0FFh
	LURET?C	0FFh
	LURET?C	025h

	LABEL?L	L00002	
	LOOKUP?BCLB	_SDC_cmd, 006h, L00003, _SDC_moredataexpected
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	001h
	LURET?C	001h
	LURET?C	000h

	LABEL?L	L00003	
	RETURN?	

	LABEL?L	_SendSDCCmd	
	MOVE?CT	000h, _SD_CS
	GOSUB?L	_sdmmc_cmdtable
	MOVE?BB	_SDC_CmdCode, _SDC_data_out
	GOSUB?L	_WriteSPIM
	MOVE?BB	_SDC_address??BYTE3, _SDC_data_out
	GOSUB?L	_WriteSPIM
	MOVE?BB	_SDC_address??BYTE2, _SDC_data_out
	GOSUB?L	_WriteSPIM
	MOVE?BB	_SDC_address??BYTE1, _SDC_data_out
	GOSUB?L	_WriteSPIM
	MOVE?BB	_SDC_address??BYTE0, _SDC_data_out
	GOSUB?L	_WriteSPIM
	MOVE?BB	_SDC_CRC, _SDC_data_out
	GOSUB?L	_WriteSPIM
	MOVE?CN	008h, _SDC_timeout
	LABEL?L	L00020	
	CMPLT?NCL	_SDC_timeout, 000h, L00021
	GOSUB?L	_ReadMedia
	MOVE?BB	_SDC_data_in, _SDC_response
	CMPEQ?BCL	_SDC_response, _SDC_FLOATING_BUS, L00022
	MOVE?CN	000h, _SDC_timeout
	LABEL?L	L00022	
	NEXTM?NCL	_SDC_timeout, 001h, L00020
	LABEL?L	L00021	
	GOSUB?L	_Send8ClkCycles
	CMPT?BL	_SDC_moredataexpected, L00024
	MOVE?CT	001h, _SD_CS
	LABEL?L	L00024	
	RETURN?	

	LABEL?L	_SectorRead	
	MOVE?CB	_sdcValid, _SDC_status
	MOVE?CB	_READ_SINGLE_BLOCK, _SDC_cmd
	SHIFTL?NCN	_SDC_sector_addr, 009h, _SDC_address
	GOSUB?L	_SendSDCCmd
	CMPEQ?BCL	_SDC_response, 000h, L00026
	GOSUB?L	_SendSDCCmd
	CMPEQ?BCL	_SDC_response, 000h, L00028
	MOVE?CB	_sdcCardBadCmd, _SDC_status
	MOVE?CT	001h, _SD_CS
	RETURN?	
	LABEL?L	L00028	
	LABEL?L	L00026	
	PAUSEUS?C	028h
	MOVE?CN	002FFh, _SDC_timeout
	LABEL?L	L00030	
	CMPLT?NCL	_SDC_timeout, 000h, L00031
	GOSUB?L	_ReadMedia
	PAUSEUS?C	028h
	CMPEQ?BCL	_SDC_data_in, _SDC_FLOATING_BUS, L00032
	MOVE?CN	000h, _SDC_timeout
	LABEL?L	L00032	
	NEXTM?NCL	_SDC_timeout, 001h, L00030
	LABEL?L	L00031	
	CMPEQ?BCL	_SDC_data_in, _DATA_START_TOKEN, L00034
	MOVE?CB	_sdcCardTimeout, _SDC_status
	GOTO?L	L00035
	LABEL?L	L00034	
	MOVE?CW	000h, _SDC_index
	LABEL?L	L00036	
	CMPGT?WCL	_SDC_index, 001FFh, L00037
	GOSUB?L	_ReadMedia
	AIN?BBW	_SDC_data_in, _SDC_buffer, _SDC_index
	NEXT?WCL	_SDC_index, 001h, L00036
	LABEL?L	L00037	
	GOSUB?L	_ReadCRC
	GOSUB?L	_Send8ClkCycles
	LABEL?L	L00035	
	MOVE?CT	001h, _SD_CS
	RETURN?	

	LABEL?L	_SectorWrite	
	CMPNE?NCL	_SDC_address, 000h, L00038
	MOVE?CB	_sdcCardBadCmd, _SDC_status
	GOTO?L	L00039
	LABEL?L	L00038	
	MOVE?CB	_sdcValid, _SDC_status
	MOVE?CB	_WRITE_SINGLE_BLOCK, _SDC_cmd
	SHIFTL?NCN	_SDC_sector_addr, 009h, _SDC_address
	GOSUB?L	_SendSDCCmd
	CMPEQ?BCL	_SDC_response, 000h, L00040
	MOVE?CB	_sdcCardBadCmd, _SDC_status
	GOTO?L	L00041
	LABEL?L	L00040	
	MOVE?CB	_DATA_START_TOKEN, _SDC_data_out
	GOSUB?L	_WriteSPIM
	MOVE?CW	000h, _SDC_index
	LABEL?L	L00042	
	CMPGT?WCL	_SDC_index, 001FFh, L00043
	AOUT?BWB	_SDC_buffer, _SDC_index, _SDC_data_out
	GOSUB?L	_WriteSPIM
	NEXT?WCL	_SDC_index, 001h, L00042
	LABEL?L	L00043	
	GOSUB?L	_SendCRC
	GOSUB?L	_ReadMedia
	AND?BCN	_SDC_data_in, 00Fh, T1
	CMPEQ?NCL	T1, _DATA_ACCEPTED, L00044
	MOVE?CB	_sdcCardDataRejected, _SDC_status
	GOTO?L	L00045
	LABEL?L	L00044	
	MOVE?CN	0FFFFh, _SDC_timeout
	LABEL?L	L00046	
	CMPLT?NCL	_SDC_timeout, 000h, L00047
	GOSUB?L	_ReadMedia
	CMPEQ?BCL	_SDC_data_in, 000h, L00048
	MOVE?CN	000h, _SDC_timeout
	LABEL?L	L00048	
	NEXTM?NCL	_SDC_timeout, 001h, L00046
	LABEL?L	L00047	
	CMPNE?BCL	_SDC_data_in, 000h, L00050
	MOVE?CB	_sdcCardTimeout, _SDC_status
	LABEL?L	L00050	
	LABEL?L	L00045	
	GOSUB?L	_Send8ClkCycles
	LABEL?L	L00041	
	LABEL?L	L00039	
	MOVE?CT	001h, _SD_CS
	RETURN?	

	LABEL?L	_MediaInitialize	
	MOVE?CB	_sdcValid, _SDC_status
	GOSUB?L	_InitIO
	PAUSE?C	001h
	GOSUB?L	_OpenSPIM
	PAUSE?C	001h
	MOVE?CW	001h, _SDC_timeout1
	LABEL?L	L00052	
	CMPGT?WCL	_SDC_timeout1, 00Ah, L00053
	GOSUB?L	_Send8ClkCycles
	NEXT?WCL	_SDC_timeout1, 001h, L00052
	LABEL?L	L00053	
	MOVE?CT	000h, _SD_CS
	PAUSE?C	001h
	MOVE?CB	_GO_IDLE_STATE, _SDC_cmd
	MOVE?CN	000h, _SDC_address
	GOSUB?L	_SendSDCCmd
	CMPNE?BCL	_SDC_response, _SDC_BAD_RESPONSE, L00054
	MOVE?CB	_sdcCardInitCommFailure, _SDC_status
	GOTO?L	_InitError
	LABEL?L	L00054	
	AND?BCN	_SDC_response, 0F7h, T1
	CMPEQ?NCL	T1, 001h, L00056
	MOVE?CB	_sdcCardNotInitFailure, _SDC_status
	GOTO?L	_InitError
	LABEL?L	L00056	
	MOVE?CW	00FFFh, _SDC_timeout1
	LABEL?L	L00058	
	CMPLT?WCL	_SDC_timeout1, 000h, L00059
	MOVE?CB	_SEND_OP_COND, _SDC_cmd
	MOVE?CN	000h, _SDC_address
	GOSUB?L	_SendSDCCmd
	CMPNE?BCL	_SDC_response, 000h, L00060
	MOVE?CW	000h, _SDC_timeout1
	LABEL?L	L00060	
	NEXTM?WCL	_SDC_timeout1, 001h, L00058
	LABEL?L	L00059	
	CMPEQ?BCL	_SDC_response, 000h, L00062
	MOVE?CB	_sdcCardInitTimeout, _SDC_status
	GOTO?L	_InitError
	LABEL?L	L00062	
	PAUSE?C	002h
	GOSUB?L	_OpenSPIMFast
	MOVE?CB	_CRC_ON_OFF, _SDC_cmd
	MOVE?CN	000h, _SDC_address
	GOSUB?L	_SendSDCCmd
	MOVE?CB	_SET_BLOCKLEN, _SDC_cmd
	MOVE?CN	_MEDIA_SECTOR_SIZE, _SDC_address
	GOSUB?L	_SendSDCCmd
	MOVE?CW	0FFh, _SDC_timeout1
	LABEL?L	L00064	
	CMPLT?WCL	_SDC_timeout1, 000h, L00065
	MOVE?CN	000h, _SDC_sector_addr
	GOSUB?L	_SectorRead
	CMPNE?BCL	_SDC_status, _sdcValid, L00066
	MOVE?CW	000h, _SDC_timeout1
	LABEL?L	L00066	
	NEXTM?WCL	_SDC_timeout1, 001h, L00064
	LABEL?L	L00065	
	CMPEQ?BCL	_SDC_status, _sdcValid, L00068
	MOVE?CB	_sdcCardNotInitFailure, _SDC_status
	GOTO?L	_InitError
	LABEL?L	L00068	
	RETURN?	

	LABEL?L	_InitError	
	MOVE?CT	001h, _SD_CS
	RETURN?	

	LABEL?L	_ShutdownMedia	
	MOVE?CT	001h, _SD_CS
	GOTO?L	_CloseSPIM

	LABEL?L	_LoadMBR	
	MOVE?CB	_CE_GOOD, _FAT_error
	MOVE?CN	000h, _SDC_sector_addr
	GOSUB?L	_SectorRead
	CMPEQ?BCL	_SDC_status, _sdcValid, L00070
	MOVE?CB	_CE_BAD_SECTOR_READ, _FAT_error
	RETURN?	
	LABEL?L	L00070	
	CMPNE?BCB	_DISK_buffer + 001FEh, 055h, T1
	CMPNE?BCB	_DISK_buffer + 001FFh, 0AAh, T2
	LOR?BBN	T1, T2, T2
	CMPF?NL	T2, L00072
	MOVE?CB	_CE_BAD_PARTITION, _FAT_error
	RETURN?	
	LABEL?L	L00072	
	MOVE?BB	_DISK_buffer + 001C6h, _DISK_firsts??BYTE0
	MOVE?BB	_DISK_buffer + 001C7h, _DISK_firsts??BYTE1
	MOVE?BB	_DISK_buffer + 001C8h, _DISK_firsts??BYTE2
	MOVE?BB	_DISK_buffer + 001C9h, _DISK_firsts??BYTE3
	CMPNE?BCL	_DISK_buffer + 001C2h, 001h, L00076
	MOVE?CB	_FAT12, _DISK_type
	MOVE?CB	_CE_CARDFAT12, _FAT_error
	GOTO?L	L00075
	LABEL?L	L00076	
	CMPEQ?BCL	_DISK_buffer + 001C2h, 00Eh, L00077
	CMPEQ?BCL	_DISK_buffer + 001C2h, 006h, L00078
	CMPNE?BCL	_DISK_buffer + 001C2h, 004h, L00079

	LABEL?L	L00077	

	LABEL?L	L00078	
	MOVE?CB	_FAT16, _DISK_type
	GOTO?L	L00075
	LABEL?L	L00079	
	CMPEQ?BCL	_DISK_buffer + 001C2h, 00Ch, L00080
	CMPNE?BCL	_DISK_buffer + 001C2h, 00Bh, L00081

	LABEL?L	L00080	
	MOVE?CB	_FAT32, _DISK_type
	MOVE?CB	_CE_CARDFAT32, _FAT_error
	GOTO?L	L00075
	LABEL?L	L00081	
	MOVE?CB	_CE_BAD_PARTITION, _FAT_error
	LABEL?L	L00075	
	RETURN?	

	LABEL?L	_LoadBootSector	
	MOVE?CB	_CE_GOOD, _FAT_error
	MOVE?NN	_DISK_firsts, _SDC_sector_addr
	GOSUB?L	_SectorRead
	CMPEQ?BCL	_SDC_status, _sdcValid, L00082
	MOVE?CB	_CE_BAD_SECTOR_READ, _FAT_error
	RETURN?	
	LABEL?L	L00082	
	CMPNE?BCB	_DISK_buffer + 001FEh, 055h, T1
	CMPNE?BCB	_DISK_buffer + 001FFh, 0AAh, T2
	LOR?BBN	T1, T2, T2
	CMPF?NL	T2, L00084
	MOVE?CB	_CE_NOT_FORMATTED, _FAT_error
	RETURN?	
	LABEL?L	L00084	
	MOVE?BB	_DISK_buffer + 0000Bh, _DISK_BytesPerSec??BYTE0
	MOVE?BB	_DISK_buffer + 0000Ch, _DISK_BytesPerSec??BYTE1
	CMPEQ?WCB	_DISK_BytesPerSec, 000h, T1
	AND?WCN	_DISK_BytesPerSec, 001h, T2
	CMPEQ?NCB	T2, 001h, T2
	LOR?BBN	T1, T2, T2
	CMPF?NL	T2, L00086
	MOVE?CB	_CE_NOT_FORMATTED, _FAT_error
	RETURN?	
	LABEL?L	L00086	
	MOVE?BB	_DISK_buffer + 0000Dh, _DISK_SecPerClus
	SHIFTL?BCN	_DISK_buffer + 0000Fh, 008h, T1
	ADD?BNN	_DISK_buffer + 0000Eh, T1, T1
	ADD?NNN	_DISK_firsts, T1, _DISK_fat
	MOVE?BB	_DISK_buffer + 00010h, _DISK_fatcopy
	MOVE?BB	_DISK_buffer + 00011h, _DISK_maxroot??BYTE0
	MOVE?BB	_DISK_buffer + 00012h, _DISK_maxroot??BYTE1
	MOVE?BB	_DISK_buffer + 00016h, _DISK_fatsize??BYTE0
	MOVE?BB	_DISK_buffer + 00017h, _DISK_fatsize??BYTE1
	MUL?BWN	_DISK_fatcopy, _DISK_fatsize, T1
	ADD?NNN	_DISK_fat, T1, _DISK_root
	MUL?WCN	_DISK_maxroot, _NUMBER_OF_BYTES_IN_DIR_ENTRY, T1
	SUB?WCN	_DISK_BytesPerSec, 001h, T2
	ADD?NNN	T1, T2, T2
	DIV?NWW	T2, _DISK_BytesPerSec, _FAT_RootDirSectors
	MOVE?BB	_DISK_buffer + 00020h, _FAT_TotSec??BYTE0
	MOVE?BB	_DISK_buffer + 00021h, _FAT_TotSec??BYTE1
	MOVE?BB	_DISK_buffer + 00022h, _FAT_TotSec??BYTE2
	MOVE?BB	_DISK_buffer + 00023h, _FAT_TotSec??BYTE3
	ADD?NWN	_DISK_root, _FAT_RootDirSectors, T1
	ADD?NNN	T1, _DISK_firsts, T1
	ADD?NCN	T1, 002h, T1
	SUB?NNN	_FAT_TotSec, T1, T1
	DIV?NBN	T1, _DISK_SecPerClus, _DISK_maxcls
	CMPGE?NCL	_DISK_maxcls, 00FF5h, L00088
	MOVE?CB	_FAT12, _DISK_type
	MOVE?CB	_CE_CARDFAT12, _FAT_error
	GOTO?L	L00089
	LABEL?L	L00088	
	CMPGE?NCL	_DISK_maxcls, 0FFF5h, L00090
	MOVE?CB	_FAT16, _DISK_type
	GOTO?L	L00091
	LABEL?L	L00090	
	MOVE?CB	_FAT32, _DISK_type
	MOVE?CB	_CE_CARDFAT32, _FAT_error
	LABEL?L	L00091	
	LABEL?L	L00089	
	SHIFTR?WCN	_DISK_maxroot, 004h, T1
	ADD?NNN	_DISK_root, T1, _DISK_data
	CMPEQ?WCL	_DISK_BytesPerSec, _MEDIA_SECTOR_SIZE, L00092
	MOVE?CB	_CE_NOT_FORMATTED, _FAT_error
	LABEL?L	L00092	
	RETURN?	

	LABEL?L	_DISKmount	
	MOVE?CB	_FALSE, _DISK_mount
	GOSUB?L	_MediaInitialize
	CMPEQ?BCL	_SDC_status, _sdcValid, L00094
	MOVE?CB	_CE_INIT_ERROR, _FAT_error
	GOTO?L	L00095
	LABEL?L	L00094	
	GOSUB?L	_LoadMBR
	CMPNE?BCL	_FAT_error, _CE_GOOD, L00096
	GOSUB?L	_LoadBootSector
	CMPNE?BCL	_FAT_error, _CE_GOOD, L00098
	MOVE?CB	_TRUE, _DISK_mount
	LABEL?L	L00098	
	LABEL?L	L00096	
	LABEL?L	L00095	
	RETURN?	

	LABEL?L	_FATreadQueued	
	CMPNE?BCL	_FAT_ccls??BYTE0, 000h, _FATreadQ

	LABEL?L	_FATread	
	ADD?NBN	_DISK_fat, _FAT_ccls??BYTE1, _SDC_sector_addr
	GOSUB?L	_SectorRead
	CMPEQ?BCL	_SDC_status, _sdcValid, L00100
	MOVE?CW	_CLUSTER_FAIL, _FAT_c
	RETURN?	
	LABEL?L	L00100	

	LABEL?L	_FATreadQ	
	SHIFTL?BCN	_FAT_ccls??BYTE0, 001h, T1
	AOUT?BNB	_DISK_buffer, T1, _FAT_c??BYTE0
	SHIFTL?BCN	_FAT_ccls??BYTE0, 001h, T1
	ADD?NCN	T1, 001h, T1
	AOUT?BNB	_DISK_buffer, T1, _FAT_c??BYTE1
	CMPLT?WCL	_FAT_c, _LAST_CLUSTER, L00102
	MOVE?CW	_LAST_CLUSTER, _FAT_c
	LABEL?L	L00102	
	RETURN?	

	LABEL?L	_FATwrite	
	MOVE?CW	000h, _FAT_c
	MUL?WCW	_FAT_ccls, 002h, _FAT_p
	ADD?NBN	_DISK_fat, _FAT_ccls??BYTE1, _SDC_sector_addr
	GOSUB?L	_SectorRead
	CMPEQ?BCL	_SDC_status, _sdcValid, L00104
	MOVE?CW	_CLUSTER_FAIL, _FAT_c
	RETURN?	
	LABEL?L	L00104	
	AND?WCW	_FAT_p, 001FFh, _FAT_p
	AIN?BBW	_FAT_v??BYTE0, _DISK_buffer, _FAT_p
	ADD?WCN	_FAT_p, 001h, T1
	AIN?BBN	_FAT_v??BYTE1, _DISK_buffer, T1
	GOSUB?L	_SectorWrite
	CMPEQ?BCL	_SDC_status, _sdcValid, L00106
	MOVE?CW	_CLUSTER_FAIL, _FAT_c
	RETURN?	
	LABEL?L	L00106	
	ADD?NWN	_SDC_sector_addr, _DISK_fatsize, _SDC_sector_addr
	GOSUB?L	_SectorWrite
	CMPEQ?BCL	_SDC_status, _sdcValid, L00108
	MOVE?CW	_CLUSTER_FAIL, _FAT_c
	RETURN?	
	LABEL?L	L00108	
	RETURN?	

	LABEL?L	_Cluster2Sector	
	CMPEQ?WCB	_FAT_cluster, 000h, T1
	CMPEQ?WCB	_FAT_cluster, 001h, T2
	LOR?BBN	T1, T2, T2
	CMPF?NL	T2, L00110
	ADD?NWN	_DISK_root, _FAT_cluster, _FAT_sector
	GOTO?L	L00111
	LABEL?L	L00110	
	SUB?WCN	_FAT_cluster, 002h, T1
	MUL?NBN	T1, _DISK_SecPerClus, T1
	ADD?NNN	T1, _DISK_data, _FAT_sector
	LABEL?L	L00111	
	RETURN?	

	LABEL?L	_FATfindEmptyCluster	
	MOVE?WW	_FILE_ccls, _FAT_ccls
	CMPGE?WCL	_FAT_ccls, 002h, L00112
	MOVE?CW	002h, _FAT_ccls
	LABEL?L	L00112	
	MOVE?WW	_FAT_ccls, _FAT_cls
	GOSUB?L	_FATread
	LABEL?L	L00114	
	CMPF?WL	_FAT_ccls, L00115
	GOSUB?L	_FATreadQueued
	CMPNE?WCL	_FAT_c, _CLUSTER_FAIL, L00116
	MOVE?CW	000h, _FAT_c
	RETURN?	
	LABEL?L	L00116	
	CMPNE?WCL	_FAT_c, _CLUSTER_EMPTY, L00118
	MOVE?WW	_FAT_ccls, _FAT_c
	RETURN?	
	LABEL?L	L00118	
	ADD?WCW	_FAT_ccls, 001h, _FAT_ccls
	CMPEQ?WCB	_FAT_c, _END_CLUSTER, T1
	CMPGE?WNB	_FAT_ccls, _DISK_maxcls, T2
	LOR?BBN	T1, T2, T2
	CMPF?NL	T2, L00120
	MOVE?CW	002h, _FAT_ccls
	LABEL?L	L00120	
	CMPNE?WWL	_FAT_ccls, _FAT_cls, L00122
	MOVE?CW	000h, _FAT_c
	RETURN?	
	LABEL?L	L00122	
	GOTO?L	L00114
	LABEL?L	L00115	
	MOVE?WW	_FAT_ccls, _FAT_c
	RETURN?	

	LABEL?L	_FILEallocate_new_cluster	
	GOSUB?L	_FATfindEmptyCluster
	CMPNE?WCL	_FAT_c, 000h, L00124
	MOVE?CB	_CE_DISK_FULL, _FAT_error
	RETURN?	
	LABEL?L	L00124	
	MOVE?CW	_LAST_CLUSTER_FAT16, _FAT_v
	MOVE?WW	_FAT_c, _FAT_ccls
	GOSUB?L	_FATwrite
	CMPNE?WCL	_FAT_c, _CLUSTER_FAIL, L00126
	MOVE?CB	_CE_WRITE_ERROR, _FAT_error
	RETURN?	
	LABEL?L	L00126	
	MOVE?WW	_FAT_ccls, _FAT_v
	MOVE?WW	_FILE_ccls, _FAT_ccls
	GOSUB?L	_FATwrite
	CMPNE?WCL	_FAT_c, _CLUSTER_FAIL, L00128
	MOVE?CB	_CE_WRITE_ERROR, _FAT_error
	RETURN?	
	LABEL?L	L00128	
	MOVE?WW	_FAT_v, _FILE_ccls
	MOVE?CB	_CE_GOOD, _FAT_error
	RETURN?	

	LABEL?L	_EraseCluster	
	MOVE?CB	_CE_GOOD, _FAT_error
	GOSUB?L	_Cluster2Sector
	MOVE?CW	000h, _FAT_n
	LABEL?L	L00130	
	CMPGT?WCL	_FAT_n, 001FFh, L00131
	AIN?CBW	000h, _DISK_buffer, _FAT_n
	NEXT?WCL	_FAT_n, 001h, L00130
	LABEL?L	L00131	
	MOVE?NN	_FAT_sector, _SDC_sector_addr
	MOVE?CB	001h, _FAT_i
	LABEL?L	L00132	
	CMPGT?BBL	_FAT_i, _DISK_SecPerClus, L00133
	GOSUB?L	_SectorWrite
	CMPEQ?BCL	_SDC_status, _sdcValid, L00134
	MOVE?CB	_CE_WRITE_ERROR, _FAT_error
	RETURN?	
	LABEL?L	L00134	
	ADD?NCN	_SDC_sector_addr, 001h, _SDC_sector_addr
	NEXT?BCL	_FAT_i, 001h, L00132
	LABEL?L	L00133	
	RETURN?	

	LABEL?L	_FILECreateHeadCluster	
	GOSUB?L	_FATfindEmptyCluster
	CMPNE?WCL	_FAT_c, 000h, L00136
	MOVE?CB	_CE_DISK_FULL, _FAT_error
	GOTO?L	L00137
	LABEL?L	L00136	
	MOVE?CW	_LAST_CLUSTER_FAT16, _FAT_v
	MOVE?WW	_FAT_c, _FAT_ccls
	GOSUB?L	_FATwrite
	CMPNE?WCL	_FAT_c, _CLUSTER_FAIL, L00138
	MOVE?CB	_CE_WRITE_ERROR, _FAT_error
	RETURN?	
	LABEL?L	L00138	
	MOVE?WW	_FAT_ccls, _FAT_cluster
	GOSUB?L	_EraseCluster
	LABEL?L	L00137	
	RETURN?	

	LABEL?L	_Write_File_Entry	
	MOVE?CB	000h, _FAT_i
	LABEL?L	L00140	
	CMPGT?BCL	_FAT_i, 01Fh, L00141
	MOD?WCN	_FAT_fHandle, _DIRENTRIES_PER_SECTOR, T2
	SHIFTL?NCN	T2, 005h, T2
	ADD?BNN	_FAT_i, T2, T2
	AOUT?BBB	_DIRB, _FAT_i, T1
	AIN?BBN	T1, _DISK_buffer, T2
	NEXT?BCL	_FAT_i, 001h, L00140
	LABEL?L	L00141	
	MOVE?WW	_FILE_dirccls, _FAT_cluster
	SHIFTR?WCB	_FAT_fHandle, 004h, _FAT_offset2
	CMPEQ?WCL	_FAT_cluster, 000h, L00142
	MOD?BBB	_FAT_offset2, _DISK_SecPerClus, _FAT_offset2
	LABEL?L	L00142	
	GOSUB?L	_Cluster2Sector
	ADD?NBN	_FAT_sector, _FAT_offset2, _SDC_sector_addr
	GOSUB?L	_SectorWrite
	CMPEQ?BCL	_SDC_status, _sdcValid, L00144
	MOVE?CB	_FALSE, _FAT_status
	GOTO?L	L00145
	LABEL?L	L00144	
	MOVE?CB	_TRUE, _FAT_status
	LABEL?L	L00145	
	RETURN?	

	LABEL?L	_CopyDirEntry	
	MOVE?CB	000h, _FAT_i
	LABEL?L	L00146	
	CMPGT?BCL	_FAT_i, 01Fh, L00147
	MOD?WCN	_FAT_curEntry, _DIRENTRIES_PER_SECTOR, T1
	SHIFTL?NCN	T1, 005h, T1
	ADD?BNN	_FAT_i, T1, T1
	AOUT?BNB	_DISK_buffer, T1, T1
	AIN?BBB	T1, _DIRB, _FAT_i
	NEXT?BCL	_FAT_i, 001h, L00146
	LABEL?L	L00147	
	RETURN?	

	LABEL?L	_Cache_File_Entry	
	MOVE?CB	_TRUE, _FAT_status
	MOVE?WW	_FAT_fHandle, _FAT_curEntry
	MOVE?WW	_FILE_dirclus, _FAT_cluster
	MOVE?WW	_FILE_dirccls, _FAT_ccls
	SHIFTR?WCB	_FAT_curEntry, 004h, _FAT_offset2
	CMPEQ?WCL	_FAT_cluster, 000h, L00148
	MOD?BBB	_FAT_offset2, _DISK_SecPerClus, _FAT_offset2
	LABEL?L	L00148	
	AND?WCN	_FAT_curEntry, 00Fh, T1
	CMPEQ?NCB	T1, 000h, T1
	LOR?BBN	_FAT_ForceRead, T1, T1
	CMPF?NL	T1, L00150
	CMPEQ?BCB	_FAT_offset2, 000h, T1
	CMPGE?WCB	_FAT_curEntry, _DIRENTRIES_PER_SECTOR, T2
	LAND?BBN	T1, T2, T2
	LOR?NBN	T2, _FAT_ForceRead, T2
	CMPF?NL	T2, L00152
	CMPNE?WCL	_FAT_cluster, 000h, L00154
	MOVE?CW	000h, _FAT_ccls
	GOTO?L	L00155
	LABEL?L	L00154	
	CMPF?BL	_FAT_ForceRead, L00156
	MUL?CBN	_DIRENTRIES_PER_SECTOR, _DISK_SecPerClus, T1
	DIV?WNB	_FAT_curEntry, T1, _FAT_numofclus
	GOTO?L	L00157
	LABEL?L	L00156	
	MOVE?CB	001h, _FAT_numofclus
	LABEL?L	L00157	
	LABEL?L	L00158	
	CMPF?BL	_FAT_numofclus, L00159
	GOSUB?L	_FATread
	MOVE?WW	_FAT_c, _FAT_ccls
	CMPGE?WCL	_FAT_ccls, _LAST_CLUSTER, _CFEexitwhile
	SUB?BCB	_FAT_numofclus, 001h, _FAT_numofclus
	GOTO?L	L00158
	LABEL?L	L00159	

	LABEL?L	_CFEexitwhile	
	LABEL?L	L00155	
	LABEL?L	L00152	
	CMPGE?WCL	_FAT_ccls, _LAST_CLUSTER, L00160
	MOVE?WW	_FAT_ccls, _FILE_dirccls
	MOVE?WW	_FAT_ccls, _FAT_cluster
	GOSUB?L	_Cluster2Sector
	CMPEQ?WCB	_FAT_ccls, 000h, T1
	ADD?NBN	_FAT_sector, _FAT_offset2, T2
	CMPGE?NNB	T2, _DISK_data, T2
	LAND?BBN	T1, T2, T2
	CMPF?NL	T2, L00162
	MOVE?CB	_FALSE, _FAT_status
	GOTO?L	L00163
	LABEL?L	L00162	
	ADD?NBN	_FAT_sector, _FAT_offset2, _SDC_sector_addr
	GOSUB?L	_SectorRead
	CMPEQ?BCL	_SDC_status, _sdcValid, L00164
	MOVE?CB	_FALSE, _FAT_status
	GOTO?L	L00165
	LABEL?L	L00164	
	CMPF?BL	_FAT_ForceRead, L00166
	GOSUB?L	_CopyDirEntry
	GOTO?L	L00167
	LABEL?L	L00166	
	MOVE?CW	000h, _FAT_curEntry
	GOSUB?L	_CopyDirEntry
	LABEL?L	L00167	
	LABEL?L	L00165	
	LABEL?L	L00163	
	GOTO?L	L00161
	LABEL?L	L00160	
	MOVE?CB	_FALSE, _FAT_status
	LABEL?L	L00161	
	GOTO?L	L00151
	LABEL?L	L00150	
	GOSUB?L	_CopyDirEntry
	LABEL?L	L00151	
	RETURN?	

	LABEL?L	_LoadDirAttrib	
	MOVE?WW	_FILE_dirclus, _FILE_dirccls
	MOVE?CB	_TRUE, _FAT_ForceRead
	GOSUB?L	_Cache_File_Entry
	CMPNE?BCL	_FAT_status, _FALSE, L00168
	RETURN?	
	LABEL?L	L00168	
	MOVE?BB	_DIR_Name, _FAT_a
	CMPEQ?BCB	_FAT_a, _DIR_EMPTY, T1
	CMPEQ?BCB	_FAT_a, _DIR_DEL, T2
	LOR?BBN	T1, T2, T2
	CMPF?NL	T2, L00170
	MOVE?CB	_FALSE, _FAT_status
	RETURN?	
	GOTO?L	L00171
	LABEL?L	L00170	
	MOVE?BB	_DIR_Attr, _FAT_a
	LABEL?L	L00172	
	CMPNE?BCL	_FAT_a, _ATTR_LONG_NAME, L00173
	ADD?WCW	_FAT_fHandle, 001h, _FAT_fHandle
	MOVE?CB	_FALSE, _FAT_ForceRead
	GOSUB?L	_Cache_File_Entry
	CMPNE?BCL	_FAT_status, _FALSE, L00174
	RETURN?	
	LABEL?L	L00174	
	MOVE?BB	_DIR_Attr, _FAT_a
	GOTO?L	L00172
	LABEL?L	L00173	
	LABEL?L	L00171	
	RETURN?	

	LABEL?L	_CreateFirstCluster	
	MOVE?WW	_FILE_entry, _FAT_fHandle
	GOSUB?L	_FILECreateHeadCluster
	MOVE?WW	_FAT_cluster, _FAT_cls
	CMPNE?BCL	_FAT_error, _CE_GOOD, L00176
	GOSUB?L	_LoadDirAttrib
	MOVE?WW	_FAT_cls, _DIR_FstClusLO
	MOVE?CW	000h, _DIR_FstClusHI
	GOSUB?L	_Write_File_Entry
	CMPEQ?BCL	_FAT_status, _TRUE, L00178
	MOVE?CB	_CE_WRITE_ERROR, _FAT_error
	LABEL?L	L00178	
	LABEL?L	L00176	
	RETURN?	

	LABEL?L	_FILEget_next_cluster	
	MOVE?WW	_FILE_ccls, _FAT_ccls
	GOSUB?L	_FATread
	MOVE?CB	_CE_GOOD, _FAT_error
	CMPNE?WCL	_FAT_c, _CLUSTER_FAIL, L00180
	MOVE?CB	_CE_BAD_SECTOR_READ, _FAT_error
	GOTO?L	L00181
	LABEL?L	L00180	
	CMPLT?WNL	_FAT_c, _DISK_maxcls, L00182
	MOVE?CB	_CE_INVALID_CLUSTER, _FAT_error
	LABEL?L	L00182	
	CMPLT?WCL	_FAT_c, _LAST_CLUSTER, L00184
	MOVE?CB	_CE_FAT_EOF, _FAT_error
	RETURN?	
	LABEL?L	L00184	
	LABEL?L	L00181	
	MOVE?WW	_FAT_c, _FILE_ccls
	RETURN?	

	LABEL?L	_Fill_File_Object	
	AND?WCN	_FAT_fHandle, 00Fh, T1
	CMPEQ?NCB	T1, 000h, T1
	CMPNE?WCB	_FAT_fHandle, 000h, T2
	LAND?BBN	T1, T2, T2
	CMPF?NL	T2, L00186
	MOVE?WW	_FILE_dirclus, _FILE_dirccls
	MOVE?CB	_TRUE, _FAT_ForceRead
	GOTO?L	L00187
	LABEL?L	L00186	
	MOVE?CB	_FALSE, _FAT_ForceRead
	LABEL?L	L00187	
	GOSUB?L	_Cache_File_Entry
	MOVE?BB	_DIR_Name, _FAT_a
	CMPEQ?BCB	_FAT_status, _FALSE, T1
	CMPEQ?BCB	_FAT_a, _DIR_EMPTY, T2
	LOR?BBN	T1, T2, T2
	CMPF?NL	T2, L00188
	MOVE?CB	_NO_MORE, _FAT_status
	RETURN?	
	LABEL?L	L00188	
	CMPNE?BCL	_FAT_a, _DIR_DEL, L00190
	MOVE?CB	_NOT_FOUND, _FAT_status
	RETURN?	
	LABEL?L	L00190	
	MOVE?CB	_FOUND, _FAT_status
	MOVE?CB	000h, _FAT_i
	LABEL?L	L00192	
	CMPGT?BCL	_FAT_i, 00Ah, L00193
	AOUT?BBB	_DIR_Name, _FAT_i, T1
	AIN?BBB	T1, _FILE_name, _FAT_i
	NEXT?BCL	_FAT_i, 001h, L00192
	LABEL?L	L00193	
	MOVE?WW	_FAT_fHandle, _FILE_entry
	MOVE?NN	_DIR_FileSize, _FILE_size
	MOVE?WW	_DIR_FstClusLO, _FILE_cluster
	MOVE?BW	_DIR_Attr, _FILE_attributes
	MOVE?WW	_DIR_WrtTime, _FILE_time
	MOVE?WW	_DIR_WrtDate, _FILE_date
	RETURN?	

	LABEL?L	_FILEfind	
	MOVE?WW	_FILE_entry, _FAT_fHandle
	MOVE?CB	_CE_FILE_NOT_FOUND, _FAT_error
	MOVE?WW	_FILE_dirclus, _FILE_dirccls
	CMPEQ?WCB	_FAT_fHandle, 000h, T1
	AND?WCN	_FAT_fHandle, 00Fh, T2
	CMPNE?NCB	T2, 000h, T2
	LOR?BBN	T1, T2, T2
	CMPF?NL	T2, L00194
	MOVE?CB	_TRUE, _FAT_ForceRead
	GOSUB?L	_Cache_File_Entry
	CMPNE?BCL	_FAT_status, _FALSE, L00196
	MOVE?CB	_CE_BADCACHEREAD, _FAT_error
	RETURN?	
	LABEL?L	L00196	
	LABEL?L	L00194	
	LABEL?L	L00198	
	CMPF?CL	001h, L00199
	CMPEQ?BCL	_FAT_error, _CE_GOOD, L00200
	GOSUB?L	_Fill_File_Object
	CMPNE?BCL	_FAT_status, _NO_MORE, L00202
	GOTO?L	_Ffexitwhile
	LABEL?L	L00202	
	GOTO?L	L00201
	LABEL?L	L00200	
	GOTO?L	_Ffexitwhile
	LABEL?L	L00201	
	CMPNE?BCL	_FAT_status, _FOUND, L00204
	AND?WCB	_FILE_attributes, _ATTR_MASK, _FAT_a
	CMPNE?BCB	_FAT_a, _ATTR_VOLUME, T1
	AND?BCN	_FAT_a, _ATTR_HIDDEN, T2
	CMPNE?NCB	T2, _ATTR_HIDDEN, T2
	LAND?BBN	T1, T2, T2
	CMPF?NL	T2, L00206
	MOVE?CB	_CE_GOOD, _FAT_error
	MOVE?CB	000h, _FAT_i
	LABEL?L	L00208	
	CMPGT?BCL	_FAT_i, 00Ah, L00209
	AOUT?BBB	_FILE_name, _FAT_i, _FAT_character
	CMPGE?BCB	_FAT_character, 041h, T1
	CMPLE?BCB	_FAT_character, 05Ah, T2
	LAND?BBN	T1, T2, T2
	CMPF?NL	T2, L00210
	ADD?BCB	_FAT_character, 020h, _FAT_character
	LABEL?L	L00210	
	AOUT?BBB	_FAT_FileName, _FAT_i, _FAT_test
	CMPGE?BCB	_FAT_test, 041h, T1
	CMPLE?BCB	_FAT_test, 05Ah, T2
	LAND?BBN	T1, T2, T2
	CMPF?NL	T2, L00212
	ADD?BCB	_FAT_test, 020h, _FAT_test
	LABEL?L	L00212	
	CMPEQ?BBL	_FAT_character, _FAT_test, L00214
	MOVE?CB	_CE_FILE_NOT_FOUND, _FAT_error
	GOTO?L	_Ffexitfor
	LABEL?L	L00214	
	NEXT?BCL	_FAT_i, 001h, L00208
	LABEL?L	L00209	

	LABEL?L	_Ffexitfor	
	LABEL?L	L00206	
	LABEL?L	L00204	
	ADD?WCW	_FAT_fHandle, 001h, _FAT_fHandle
	GOTO?L	L00198
	LABEL?L	L00199	

	LABEL?L	_Ffexitwhile	
	RETURN?	

	LABEL?L	_FindEmptyEntries	
	MOVE?WW	_FILE_dirclus, _FILE_dirccls
	MOVE?CB	_TRUE, _FAT_ForceRead
	LABEL?L	L00216	
	CMPF?CL	001h, L00217
	GOSUB?L	_Cache_File_Entry
	MOVE?CB	_FALSE, _FAT_ForceRead
	CMPNE?BCL	_FAT_status, _FALSE, L00218
	RETURN?	
	LABEL?L	L00218	
	MOVE?BB	_DIR_Name, _FAT_a
	CMPEQ?BCB	_FAT_a, _DIR_DEL, T1
	CMPEQ?BCB	_FAT_a, _DIR_EMPTY, T2
	LOR?BBN	T1, T2, T2
	CMPF?NL	T2, L00220
	RETURN?	
	LABEL?L	L00220	
	ADD?WCW	_FAT_fHandle, 001h, _FAT_fHandle
	GOTO?L	L00216
	LABEL?L	L00217	

	LABEL?L	_PopulateEntries	
	MOVE?CB	_CE_GOOD, _FAT_error
	MOVE?WW	_FILE_dirclus, _FILE_dirccls
	MOVE?CB	_TRUE, _FAT_ForceRead
	GOSUB?L	_Cache_File_Entry
	CMPNE?BCL	_FAT_status, _FALSE, L00222
	MOVE?CB	_CE_BADCACHEREAD, _FAT_error
	RETURN?	
	LABEL?L	L00222	
	MOVE?CB	000h, _FAT_i
	LABEL?L	L00224	
	CMPGT?BCL	_FAT_i, 00Ah, L00225
	AOUT?BBB	_FAT_FileName, _FAT_i, T1
	AIN?BBB	T1, _DIR_Name, _FAT_i
	NEXT?BCL	_FAT_i, 001h, L00224
	LABEL?L	L00225	
	MOVE?CB	_ATTR_ARCHIVE, _DIR_Attr
	MOVE?CB	000h, _DIR_NTRes
	MOVE?CW	000h, _DIR_FstClusHI
	MOVE?CW	000h, _DIR_FstClusLO
	MOVE?CN	000h, _DIR_FileSize
	MOVE?CB	000h, _DIR_CrtTimeTenth
	SHIFTL?BCN	_FAT_minutes, 005h, T1
	OR?BNN	_FAT_seconds, T1, T1
	SHIFTL?BCN	_FAT_hours, 00Bh, T2
	OR?NNW	T1, T2, _DIR_CrtTime
	SHIFTL?BCN	_FAT_month, 005h, T1
	OR?BNN	_FAT_day, T1, T1
	SHIFTL?BCN	_FAT_year, 009h, T2
	OR?NNW	T1, T2, _DIR_CrtDate
	MOVE?WW	_DIR_CrtDate, _DIR_LstAccDate
	MOVE?WW	_DIR_CrtTime, _DIR_WrtTime
	MOVE?WW	_DIR_CrtDate, _DIR_WrtDate
	MOVE?NN	_DIR_FileSize, _FILE_size
	MOVE?WW	_DIR_CrtTime, _FILE_time
	MOVE?WW	_DIR_CrtDate, _FILE_date
	MOVE?BW	_DIR_Attr, _FILE_attributes
	MOVE?WW	_FAT_fHandle, _FILE_entry
	GOSUB?L	_Write_File_Entry
	CMPEQ?BCL	_FAT_status, _TRUE, L00226
	MOVE?CB	_CE_WRITE_ERROR, _FAT_error
	LABEL?L	L00226	
	RETURN?	

	LABEL?L	_CreateFileEntry	
	MOVE?CW	000h, _FAT_fHandle
	GOSUB?L	_FindEmptyEntries
	CMPF?BL	_FAT_status, L00228
	GOSUB?L	_PopulateEntries
	CMPNE?BCL	_FAT_error, _CE_GOOD, L00230
	GOSUB?L	_CreateFirstCluster
	LABEL?L	L00230	
	GOTO?L	L00229
	LABEL?L	L00228	
	MOVE?CB	_CE_DIR_FULL, _FAT_error
	LABEL?L	L00229	
	RETURN?	

	LABEL?L	_FAT_erase_cluster_chain	
	MOVE?CB	_TRUE, _FAT_status
	CMPEQ?WCB	_FAT_cluster, 000h, T1
	CMPEQ?WCB	_FAT_cluster, 001h, T2
	LOR?BBN	T1, T2, T2
	CMPF?NL	T2, L00232
	RETURN?	
	LABEL?L	L00232	
	MOVE?CB	_TRUE, _FAT_a
	LABEL?L	L00234	
	CMPNE?BCL	_FAT_a, _TRUE, L00235
	MOVE?WW	_FAT_cluster, _FAT_ccls
	GOSUB?L	_FATread
	CMPNE?WCL	_FAT_c, _CLUSTER_FAIL, L00236
	MOVE?CB	_FALSE, _FAT_status
	RETURN?	
	LABEL?L	L00236	
	CMPEQ?WCB	_FAT_c, 000h, T1
	CMPEQ?WCB	_FAT_c, 001h, T2
	LOR?BBN	T1, T2, T2
	CMPF?NL	T2, L00238
	RETURN?	
	LABEL?L	L00238	
	CMPLT?WCL	_FAT_c, _LAST_CLUSTER, L00240
	MOVE?CB	_FALSE, _FAT_a
	LABEL?L	L00240	
	MOVE?WW	_FAT_c, _FAT_cluster
	MOVE?CW	_CLUSTER_EMPTY, _FAT_v
	GOSUB?L	_FATwrite
	CMPNE?WCL	_FAT_c, _CLUSTER_FAIL, L00242
	MOVE?CB	_FALSE, _FAT_status
	RETURN?	
	LABEL?L	L00242	
	GOTO?L	L00234
	LABEL?L	L00235	
	RETURN?	

	LABEL?L	_FILEerase	
	MOVE?WW	_FILE_dirclus, _FILE_dirccls
	MOVE?CB	_TRUE, _FAT_ForceRead
	GOSUB?L	_Cache_File_Entry
	CMPNE?BCL	_FAT_status, _FALSE, L00244
	MOVE?CB	_CE_BADCACHEREAD, _FAT_error
	RETURN?	
	LABEL?L	L00244	
	MOVE?BB	_DIR_Name, _FAT_a
	CMPEQ?BCB	_FAT_a, _DIR_EMPTY, T1
	CMPEQ?BCB	_FAT_a, _DIR_DEL, T2
	LOR?BBN	T1, T2, T2
	CMPF?NL	T2, L00246
	MOVE?CB	_CE_FILE_NOT_FOUND, _FAT_error
	RETURN?	
	LABEL?L	L00246	
	MOVE?CB	_DIR_DEL, _DIR_Name
	GOSUB?L	_Write_File_Entry
	CMPNE?BCL	_FAT_status, _FALSE, L00248
	MOVE?CB	_CE_ERASE_FAIL, _FAT_error
	RETURN?	
	LABEL?L	L00248	
	CMPEQ?WCL	_DIR_FstClusLO, 000h, L00250
	MOVE?WW	_DIR_FstClusLO, _FAT_cluster
	GOSUB?L	_FAT_erase_cluster_chain
	CMPNE?BCL	_FAT_status, _FALSE, L00252
	MOVE?CB	_CE_ERASE_FAIL, _FAT_error
	RETURN?	
	LABEL?L	L00252	
	LABEL?L	L00250	
	MOVE?CB	_CE_GOOD, _FAT_error
	RETURN?	

	LABEL?L	_FILEopen	
	MOVE?CB	_CE_GOOD, _FAT_error
	MOVE?WW	_FILE_dirclus, _FILE_dirccls
	CMPEQ?WCB	_FAT_fHandle, 000h, T1
	AND?WCN	_FAT_fHandle, 00Fh, T2
	CMPNE?NCB	T2, 000h, T2
	LOR?BBN	T1, T2, T2
	CMPF?NL	T2, L00254
	MOVE?CB	_TRUE, _FAT_ForceRead
	GOSUB?L	_Cache_File_Entry
	CMPNE?BCL	_FAT_status, _FALSE, L00256
	MOVE?CB	_CE_BADCACHEREAD, _FAT_error
	RETURN?	
	LABEL?L	L00256	
	LABEL?L	L00254	
	GOSUB?L	_Fill_File_Object
	CMPEQ?BCL	_FAT_status, _FOUND, L00258
	MOVE?CB	_CE_FILE_NOT_FOUND, _FAT_error
	RETURN?	
	LABEL?L	L00258	
	MOVE?CN	000h, _FILE_seek
	MOVE?WW	_FILE_cluster, _FILE_ccls
	MOVE?CW	000h, _FILE_sec
	MOVE?CW	000h, _FILE_pos
	MOVE?WW	_FILE_ccls, _FAT_cluster
	GOSUB?L	_Cluster2Sector
	MOVE?NN	_FAT_sector, _SDC_sector_addr
	GOSUB?L	_SectorRead
	CMPEQ?BCL	_SDC_status, _sdcValid, L00260
	MOVE?CB	_CE_BAD_SECTOR_READ, _FAT_error
	RETURN?	
	LABEL?L	L00260	
	MOVE?CT	_FALSE, _FILE_Flags_FileWriteEOF
	CMPEQ?BCB	_FAT_mode, 077h, T1
	CMPEQ?BCB	_FAT_mode, 057h, T2
	LOR?BBN	T1, T2, T2
	CMPEQ?BCB	_FAT_mode, 061h, T3
	LOR?NBN	T2, T3, T3
	CMPEQ?BCB	_FAT_mode, 041h, T4
	LOR?NBN	T3, T4, T4
	CMPF?NL	T4, L00262
	MOVE?CT	001h, _FILE_Flags_write
	GOTO?L	L00263
	LABEL?L	L00262	
	MOVE?CT	000h, _FILE_Flags_write
	LABEL?L	L00263	
	RETURN?	

	LABEL?L	_FINDfirst	
	MOVE?CW	000h, _FILE_dirclus
	MOVE?CW	0FFFFFFFFh, _FAT_fHandle

	LABEL?L	_FINDnext	
	MOVE?WW	_FILE_dirclus, _FILE_dirccls
	MOVE?CB	_TRUE, _FAT_ForceRead
	LABEL?L	L00264	
	CMPF?CL	001h, L00265
	ADD?WCW	_FAT_fHandle, 001h, _FAT_fHandle
	GOSUB?L	_Cache_File_Entry
	MOVE?CB	_FALSE, _FAT_ForceRead
	MOVE?BB	_DIR_Name, _FAT_a
	CMPEQ?BCB	_FAT_status, _FALSE, T1
	CMPEQ?BCB	_FAT_a, _DIR_EMPTY, T2
	LOR?BBN	T1, T2, T2
	CMPF?NL	T2, L00266
	MOVE?CB	_CE_FILE_NOT_FOUND, _FAT_error
	RETURN?	
	LABEL?L	L00266	
	CMPEQ?BCL	_FAT_a, _DIR_DEL, L00268
	AND?BCB	_DIR_Attr, _ATTR_MASK, _FAT_a
	CMPNE?BCB	_FAT_a, _ATTR_VOLUME, T1
	CMPNE?BCB	_FAT_a, _ATTR_LONG_NAME, T2
	LAND?BBN	T1, T2, T2
	AND?BCN	_FAT_a, _ATTR_HIDDEN, T3
	CMPNE?NCB	T3, _ATTR_HIDDEN, T3
	LAND?NBN	T2, T3, T3
	CMPF?NL	T3, L00270
	MOVE?CB	000h, _FAT_i
	LABEL?L	L00272	
	CMPGT?BCL	_FAT_i, 00Ah, L00273
	AOUT?BBB	_DIR_Name, _FAT_i, T1
	AIN?BBB	T1, _FAT_FileName, _FAT_i
	NEXT?BCL	_FAT_i, 001h, L00272
	LABEL?L	L00273	
	MOVE?CB	_CE_GOOD, _FAT_error
	RETURN?	
	LABEL?L	L00270	
	LABEL?L	L00268	
	GOTO?L	L00264
	LABEL?L	L00265	

	LABEL?L	_FSInit	
	GOTO?L	_DISKmount

	LABEL?L	_FSExit	
	GOSUB?L	_ShutdownMedia
	MOVE?CB	_FALSE, _DISK_mount
	RETURN?	

	LABEL?L	_FSfopen	
	CMPNE?BCL	_DISK_mount, _FALSE, L00274
	MOVE?CB	_CE_NOT_INIT, _FAT_error
	RETURN?	
	LABEL?L	L00274	
	CMPEQ?BCB	_FAT_mode, 077h, T1
	CMPEQ?BCB	_FAT_mode, 057h, T2
	LOR?BBN	T1, T2, T2
	CMPEQ?BCB	_FAT_mode, 061h, T3
	LOR?NBN	T2, T3, T3
	CMPEQ?BCB	_FAT_mode, 041h, T4
	LOR?NBN	T3, T4, T4
	CMPF?NL	T4, L00276
	CMPF?TL	_SD_WE, L00278
	MOVE?CB	_CE_WRITE_PROTECTED, _FAT_error
	RETURN?	
	LABEL?L	L00278	
	LABEL?L	L00276	
	MOVE?CW	000h, _FILE_cluster
	MOVE?CW	000h, _FILE_ccls
	MOVE?CW	000h, _FILE_entry
	MOVE?CW	000h, _FILE_dirclus
	GOSUB?L	_FILEfind
	CMPNE?BCL	_FAT_error, _CE_GOOD, L00280
	CMPEQ?BCL	_FAT_mode, 077h, L00284
	CMPNE?BCL	_FAT_mode, 057h, L00285

	LABEL?L	L00284	

	LABEL?L	_FSfopenw	
	MOVE?WW	_FILE_entry, _FAT_fHandle
	GOSUB?L	_FILEerase
	CMPEQ?BCL	_FAT_error, _CE_GOOD, L00286
	RETURN?	
	LABEL?L	L00286	
	GOSUB?L	_CreateFileEntry
	CMPEQ?BCL	_FAT_error, _CE_GOOD, L00288
	RETURN?	
	LABEL?L	L00288	
	GOSUB?L	_FILEopen
	CMPEQ?BCL	_FAT_error, _CE_GOOD, L00290
	RETURN?	
	LABEL?L	L00290	
	AND?WCN	_FILE_attributes, _ATTR_DIRECTORY, T1
	CMPF?NL	T1, L00292
	MOVE?CB	_CE_INVALID_ARGUMENT, _FAT_error
	RETURN?	
	LABEL?L	L00292	
	GOTO?L	L00283
	LABEL?L	L00285	
	CMPEQ?BCL	_FAT_mode, 061h, L00294
	CMPNE?BCL	_FAT_mode, 041h, L00295

	LABEL?L	L00294	
	CMPNE?NCL	_FILE_size, 000h, L00296
	GOTO?L	_FSfopenw
	LABEL?L	L00296	
	MOVE?WW	_FILE_entry, _FAT_fHandle
	GOSUB?L	_FILEopen
	CMPEQ?BCL	_FAT_error, _CE_GOOD, L00298
	RETURN?	
	LABEL?L	L00298	
	AND?WCN	_FILE_attributes, _ATTR_DIRECTORY, T1
	CMPF?NL	T1, L00300
	MOVE?CB	_CE_INVALID_ARGUMENT, _FAT_error
	RETURN?	
	LABEL?L	L00300	
	MOVE?NN	_FILE_size, _FAT_offset
	GOSUB?L	_FSfseek
	GOTO?L	L00283
	LABEL?L	L00295	
	MOVE?WW	_FILE_entry, _FAT_fHandle
	GOSUB?L	_FILEopen
	AND?WCN	_FILE_attributes, _ATTR_DIRECTORY, T1
	CMPF?NL	T1, L00302
	MOVE?CB	_CE_INVALID_ARGUMENT, _FAT_error
	RETURN?	
	LABEL?L	L00302	
	LABEL?L	L00283	
	GOTO?L	L00281
	LABEL?L	L00280	
	CMPEQ?BCB	_FAT_mode, 077h, T1
	CMPEQ?BCB	_FAT_mode, 057h, T2
	LOR?BBN	T1, T2, T2
	CMPEQ?BCB	_FAT_mode, 061h, T3
	LOR?NBN	T2, T3, T3
	CMPEQ?BCB	_FAT_mode, 041h, T4
	LOR?NBN	T3, T4, T4
	CMPF?NL	T4, L00304
	GOSUB?L	_CreateFileEntry
	CMPEQ?BCL	_FAT_error, _CE_GOOD, L00306
	RETURN?	
	LABEL?L	L00306	
	GOSUB?L	_FILEopen
	CMPEQ?BCL	_FAT_error, _CE_GOOD, L00308
	RETURN?	
	LABEL?L	L00308	
	AND?WCN	_FILE_attributes, _ATTR_DIRECTORY, T1
	CMPF?NL	T1, L00310
	MOVE?CB	_CE_INVALID_ARGUMENT, _FAT_error
	RETURN?	
	LABEL?L	L00310	
	GOTO?L	L00305
	LABEL?L	L00304	
	MOVE?CB	_CE_FILE_NOT_FOUND, _FAT_error
	LABEL?L	L00305	
	LABEL?L	L00281	
	RETURN?	

	LABEL?L	_FSfclose	
	MOVE?CB	_CE_GOOD, _FAT_error
	CMPF?TL	_FILE_Flags_write, L00312
	MOVE?WW	_FILE_entry, _FAT_fHandle
	GOSUB?L	_LoadDirAttrib
	CMPNE?BCL	_FAT_status, _FALSE, L00314
	MOVE?CB	_CE_BADCACHEREAD, _FAT_error
	LABEL?L	L00314	
	SHIFTL?BCN	_FAT_minutes, 005h, T1
	OR?BNN	_FAT_seconds, T1, T1
	SHIFTL?BCN	_FAT_hours, 00Bh, T2
	OR?NNW	T1, T2, _DIR_WrtTime
	SHIFTL?BCN	_FAT_month, 005h, T1
	OR?BNN	_FAT_day, T1, T1
	SHIFTL?BCN	_FAT_year, 009h, T2
	OR?NNW	T1, T2, _DIR_WrtDate
	MOVE?NN	_FILE_size, _DIR_FileSize
	MOVE?WB	_FILE_attributes, _DIR_Attr
	GOSUB?L	_Write_File_Entry
	CMPNE?BCL	_FAT_status, _FALSE, L00316
	MOVE?CB	_CE_WRITE_ERROR, _FAT_error
	LABEL?L	L00316	
	MOVE?CT	000h, _FILE_Flags_write
	LABEL?L	L00312	
	RETURN?	

	LABEL?L	_FSfread	
	MOVE?CB	_CE_GOOD, _FAT_error
	MOVE?CW	000h, _FAT_rwCount
	MOVE?WW	_FILE_pos, _FAT_pos
	MOVE?NN	_FILE_seek, _FAT_seek
	LABEL?L	L00318	
	CMPEQ?BCB	_FAT_error, _CE_GOOD, T1
	CMPGT?WCB	_FAT_count, 000h, T2
	LAND?BBN	T1, T2, T2
	CMPF?NL	T2, L00319
	CMPLT?NNL	_FAT_seek, _FILE_size, L00320
	MOVE?CB	_CE_EOF, _FAT_error
	GOTO?L	L00321
	LABEL?L	L00320	
	CMPLT?WCL	_FAT_pos, _MEDIA_SECTOR_SIZE, L00322
	MOVE?CW	000h, _FAT_pos
	ADD?WCW	_FILE_sec, 001h, _FILE_sec
	CMPLT?WBL	_FILE_sec, _DISK_SecPerClus, L00324
	MOVE?CW	000h, _FILE_sec
	GOSUB?L	_FILEget_next_cluster
	LABEL?L	L00324	
	CMPNE?BCL	_FAT_error, _CE_GOOD, L00326
	MOVE?WW	_FILE_ccls, _FAT_cluster
	GOSUB?L	_Cluster2Sector
	ADD?NWN	_FAT_sector, _FILE_sec, _SDC_sector_addr
	GOSUB?L	_SectorRead
	CMPEQ?BCL	_SDC_status, _sdcValid, L00328
	MOVE?CB	_CE_BAD_SECTOR_READ, _FAT_error
	LABEL?L	L00328	
	LABEL?L	L00326	
	LABEL?L	L00322	
	CMPNE?BCL	_FAT_error, _CE_GOOD, L00330
	CMPGE?WCL	_FAT_rwCount, _FAT_BUFFER_SIZE, L00332
	AOUT?BWB	_DISK_buffer, _FAT_pos, T1
	AIN?BBW	T1, _FAT_dest, _FAT_rwCount
	ADD?WCW	_FAT_rwCount, 001h, _FAT_rwCount
	LABEL?L	L00332	
	ADD?WCW	_FAT_pos, 001h, _FAT_pos
	ADD?NCN	_FAT_seek, 001h, _FAT_seek
	SUB?WCW	_FAT_count, 001h, _FAT_count
	LABEL?L	L00330	
	LABEL?L	L00321	
	GOTO?L	L00318
	LABEL?L	L00319	
	MOVE?WW	_FAT_pos, _FILE_pos
	MOVE?NN	_FAT_seek, _FILE_seek
	RETURN?	

	LABEL?L	_FSfwrite	
	MOVE?CB	_CE_GOOD, _FAT_error
	MOVE?CW	000h, _FAT_rwCount
	CMPT?TL	_FILE_Flags_write, L00334
	MOVE?CB	_CE_WRITE_ERROR, _FAT_error
	RETURN?	
	LABEL?L	L00334	
	CMPF?TL	_SD_WE, L00336
	MOVE?CB	_CE_WRITE_PROTECTED, _FAT_error
	RETURN?	
	LABEL?L	L00336	
	CMPNE?WCL	_FAT_count, 000h, L00338
	RETURN?	
	LABEL?L	L00338	
	MOVE?WW	_FILE_pos, _FAT_pos
	MOVE?NN	_FILE_seek, _FAT_seek
	MOVE?WW	_FILE_ccls, _FAT_cluster
	GOSUB?L	_Cluster2Sector
	ADD?NWN	_FAT_sector, _FILE_sec, _SDC_sector_addr
	GOSUB?L	_SectorRead
	CMPEQ?BCL	_SDC_status, _sdcValid, L00340
	MOVE?CB	_CE_BAD_SECTOR_READ, _FAT_error
	LABEL?L	L00340	
	MOVE?NN	_FILE_size, _FAT_size
	LABEL?L	L00342	
	CMPEQ?BCB	_FAT_error, _CE_GOOD, T1
	CMPGT?WCB	_FAT_count, 000h, T2
	LAND?BBN	T1, T2, T2
	CMPF?NL	T2, L00343
	CMPLT?NNL	_FAT_seek, _FAT_size, L00344
	MOVE?CT	_TRUE, _FILE_Flags_FileWriteEOF
	LABEL?L	L00344	
	CMPLT?WCL	_FAT_pos, _MEDIA_SECTOR_SIZE, L00346
	GOSUB?L	_SectorWrite
	CMPEQ?BCL	_SDC_status, _sdcValid, L00348
	MOVE?CB	_CE_WRITE_ERROR, _FAT_error
	LABEL?L	L00348	
	MOVE?CW	000h, _FAT_pos
	ADD?WCW	_FILE_sec, 001h, _FILE_sec
	CMPLT?WBL	_FILE_sec, _DISK_SecPerClus, L00350
	MOVE?CW	000h, _FILE_sec
	CMPF?TL	_FILE_Flags_FileWriteEOF, L00352
	GOSUB?L	_FILEallocate_new_cluster
	GOTO?L	L00353
	LABEL?L	L00352	
	GOSUB?L	_FILEget_next_cluster
	LABEL?L	L00353	
	LABEL?L	L00350	
	CMPNE?BCL	_FAT_error, _CE_DISK_FULL, L00354
	RETURN?	
	LABEL?L	L00354	
	CMPNE?BCL	_FAT_error, _CE_GOOD, L00356
	MOVE?WW	_FILE_ccls, _FAT_cluster
	GOSUB?L	_Cluster2Sector
	ADD?NWN	_FAT_sector, _FILE_sec, _SDC_sector_addr
	GOSUB?L	_SectorRead
	CMPEQ?BCL	_SDC_status, _sdcValid, L00358
	MOVE?CB	_CE_BAD_SECTOR_READ, _FAT_error
	LABEL?L	L00358	
	LABEL?L	L00356	
	LABEL?L	L00346	
	CMPNE?BCL	_FAT_error, _CE_GOOD, L00360
	CMPGE?WCL	_FAT_rwCount, _FAT_BUFFER_SIZE, L00362
	AOUT?BWB	_FAT_src, _FAT_rwCount, T1
	AIN?BBW	T1, _DISK_buffer, _FAT_pos
	ADD?WCW	_FAT_rwCount, 001h, _FAT_rwCount
	LABEL?L	L00362	
	ADD?WCW	_FAT_pos, 001h, _FAT_pos
	ADD?NCN	_FAT_seek, 001h, _FAT_seek
	SUB?WCW	_FAT_count, 001h, _FAT_count
	LABEL?L	L00360	
	CMPF?TL	_FILE_Flags_FileWriteEOF, L00364
	ADD?NCN	_FAT_size, 001h, _FAT_size
	LABEL?L	L00364	
	GOTO?L	L00342
	LABEL?L	L00343	
	CMPNE?BCL	_FAT_error, _CE_GOOD, L00366
	MOVE?WW	_FILE_ccls, _FAT_cluster
	GOSUB?L	_Cluster2Sector
	ADD?NWN	_FAT_sector, _FILE_sec, _SDC_sector_addr
	GOSUB?L	_SectorWrite
	CMPEQ?BCL	_SDC_status, _sdcValid, L00368
	MOVE?CB	_CE_WRITE_ERROR, _FAT_error
	LABEL?L	L00368	
	LABEL?L	L00366	
	MOVE?WW	_FAT_pos, _FILE_pos
	MOVE?NN	_FAT_seek, _FILE_seek
	MOVE?NN	_FAT_size, _FILE_size
	RETURN?	

	LABEL?L	_FSremove	
	CMPNE?BCL	_DISK_mount, _FALSE, L00370
	MOVE?CB	_CE_NOT_INIT, _FAT_error
	RETURN?	
	LABEL?L	L00370	
	CMPF?TL	_SD_WE, L00372
	MOVE?CB	_CE_WRITE_PROTECTED, _FAT_error
	RETURN?	
	LABEL?L	L00372	
	MOVE?CW	000h, _FILE_entry
	MOVE?CW	000h, _FILE_dirclus
	GOSUB?L	_FILEfind
	CMPEQ?BCL	_FAT_error, _CE_GOOD, L00374
	RETURN?	
	LABEL?L	L00374	
	MOVE?CB	_TRUE, _FAT_ForceRead
	GOSUB?L	_Cache_File_Entry
	CMPNE?BCL	_FAT_status, _FALSE, L00376
	MOVE?CB	_CE_BADCACHEREAD, _FAT_error
	RETURN?	
	LABEL?L	L00376	
	AND?BCN	_DIR_Attr, _ATTR_DIRECTORY, T1
	CMPF?NL	T1, L00378
	MOVE?CB	_CE_INVALID_ARGUMENT, _FAT_error
	RETURN?	
	LABEL?L	L00378	
	MOVE?WW	_FILE_entry, _FAT_fHandle
	GOSUB?L	_FILEerase
	RETURN?	

	LABEL?L	_FSrename	
	CMPNE?BCL	_DISK_mount, _FALSE, L00380
	MOVE?CB	_CE_NOT_INIT, _FAT_error
	RETURN?	
	LABEL?L	L00380	
	CMPF?TL	_SD_WE, L00382
	MOVE?CB	_CE_WRITE_PROTECTED, _FAT_error
	RETURN?	
	LABEL?L	L00382	
	MOVE?CW	000h, _FILE_entry
	MOVE?CW	000h, _FILE_dirclus
	MOVE?CB	000h, _FAT_i
	LABEL?L	L00384	
	CMPGT?BCL	_FAT_i, 00Ah, L00385
	AOUT?BBB	_FAT_FileName, _FAT_i, T1
	AIN?BBB	T1, _FAT_FileName1, _FAT_i
	NEXT?BCL	_FAT_i, 001h, L00384
	LABEL?L	L00385	
	MOVE?CB	000h, _FAT_i
	LABEL?L	L00386	
	CMPGT?BCL	_FAT_i, 00Ah, L00387
	AOUT?BBB	_FAT_FileName2, _FAT_i, T1
	AIN?BBB	T1, _FAT_FileName, _FAT_i
	NEXT?BCL	_FAT_i, 001h, L00386
	LABEL?L	L00387	
	GOSUB?L	_FILEfind
	CMPNE?BCL	_FAT_error, _CE_GOOD, L00388
	MOVE?CB	_CE_FILENAME_EXISTS, _FAT_error
	RETURN?	
	LABEL?L	L00388	
	MOVE?CW	000h, _FILE_entry
	MOVE?CW	000h, _FILE_dirclus
	MOVE?CB	000h, _FAT_i
	LABEL?L	L00390	
	CMPGT?BCL	_FAT_i, 00Ah, L00391
	AOUT?BBB	_FAT_FileName1, _FAT_i, T1
	AIN?BBB	T1, _FAT_FileName, _FAT_i
	NEXT?BCL	_FAT_i, 001h, L00390
	LABEL?L	L00391	
	GOSUB?L	_FILEfind
	CMPNE?BCL	_FAT_error, _CE_GOOD, L00392
	MOVE?WW	_FILE_entry, _FAT_fHandle
	GOSUB?L	_LoadDirAttrib
	CMPNE?BCL	_FAT_status, _FALSE, L00394
	MOVE?CB	_CE_WRITE_ERROR, _FAT_error
	LABEL?L	L00394	
	MOVE?CB	000h, _FAT_i
	LABEL?L	L00396	
	CMPGT?BCL	_FAT_i, 00Ah, L00397
	AOUT?BBB	_FAT_FileName2, _FAT_i, T1
	AIN?BBB	T1, _DIR_Name, _FAT_i
	NEXT?BCL	_FAT_i, 001h, L00396
	LABEL?L	L00397	
	GOSUB?L	_Write_File_Entry
	CMPNE?BCL	_FAT_status, _FALSE, L00398
	MOVE?CB	_CE_WRITE_ERROR, _FAT_error
	LABEL?L	L00398	
	LABEL?L	L00392	
	RETURN?	

	LABEL?L	_FSfeof	
	MOVE?CB	_FALSE, _FAT_status
	CMPLT?NNL	_FILE_seek, _FILE_size, L00400
	MOVE?CB	_TRUE, _FAT_status
	LABEL?L	L00400	
	RETURN?	

	LABEL?L	_FSrewind	
	MOVE?CN	000h, _FILE_seek
	MOVE?CW	000h, _FILE_pos
	MOVE?CW	000h, _FILE_sec
	MOVE?WW	_FILE_cluster, _FILE_ccls
	RETURN?	

	LABEL?L	_FSfseek	
	CMPLE?NNL	_FAT_offset, _FILE_size, L00402
	MOVE?CB	_CE_INVALID_ARGUMENT, _FAT_error
	RETURN?	
	LABEL?L	L00402	
	MOVE?WW	_FILE_cluster, _FILE_ccls
	MOVE?CT	_FALSE, _FILE_Flags_FileWriteEOF
	MOVE?NN	_FAT_offset, _FILE_seek
	DIV?NCN	_FAT_offset, _MEDIA_SECTOR_SIZE, _FAT_sector
	MUL?NCN	_FAT_sector, _MEDIA_SECTOR_SIZE, T1
	SUB?NNW	_FAT_offset, T1, _FILE_pos
	DIV?NBW	_FAT_sector, _DISK_SecPerClus, _FAT_n
	MUL?WBN	_FAT_n, _DISK_SecPerClus, T1
	SUB?NNW	_FAT_sector, T1, _FILE_sec
	LABEL?L	L00404	
	CMPLE?WCL	_FAT_n, 000h, L00405
	GOSUB?L	_FILEget_next_cluster
	CMPEQ?BCL	_FAT_error, _CE_GOOD, L00406
	CMPNE?BCL	_FAT_error, _CE_FAT_EOF, L00408
	CMPF?TL	_FILE_Flags_write, L00410
	GOSUB?L	_FILEallocate_new_cluster
	CMPEQ?BCL	_FAT_error, _CE_GOOD, L00412
	MOVE?CB	_CE_COULD_NOT_GET_CLUSTER, _FAT_error
	RETURN?	
	LABEL?L	L00412	
	GOTO?L	L00411
	LABEL?L	L00410	
	MOVE?CW	_MEDIA_SECTOR_SIZE, _FILE_pos
	SUB?BCW	_DISK_SecPerClus, 001h, _FILE_sec
	LABEL?L	L00411	
	GOTO?L	L00409
	LABEL?L	L00408	
	MOVE?CB	_CE_COULD_NOT_GET_CLUSTER, _FAT_error
	RETURN?	
	LABEL?L	L00409	
	LABEL?L	L00406	
	SUB?WCW	_FAT_n, 001h, _FAT_n
	GOTO?L	L00404
	LABEL?L	L00405	
	MOVE?WW	_FILE_ccls, _FAT_cluster
	GOSUB?L	_Cluster2Sector
	ADD?NWN	_FAT_sector, _FILE_sec, _SDC_sector_addr
	GOSUB?L	_SectorRead
	CMPEQ?BCL	_SDC_status, _sdcValid, L00414
	MOVE?CB	_CE_BAD_SECTOR_READ, _FAT_error
	GOTO?L	L00415
	LABEL?L	L00414	
	MOVE?CB	_CE_GOOD, _FAT_error
	LABEL?L	L00415	
	RETURN?	

	LABEL?L	_FSftell	
	MOVE?NN	_FILE_seek, _FAT_seek
	RETURN?	

	LABEL?L	_SkipSD	
	MOVE?CB	_TRUE, _SDC_UseHardSPI
	MOVE?CB	00Fh, ADCON1
	PAUSE?C	064h
	GOSUB?L	_FSInit
	SEROUT2DPIN?T	_PORTC??6
	SEROUT2MODE?C	054h
	SEROUT2PACE?C	000h
	SEROUT2?C	049h
	SEROUT2?C	06Eh
	SEROUT2?C	069h
	SEROUT2?C	074h
	SEROUT2?C	03Ah
	SEROUT2?C	020h
	SEROUT2COUNT?C	000h
	SEROUT2NUM?B	_FAT_error
	SEROUT2DEC?	
	SEROUT2?C	020h
	SEROUT2COUNT?C	000h
	SEROUT2NUM?B	_SDC_status
	SEROUT2DEC?	
	SEROUT2?C	020h
	SEROUT2COUNT?C	000h
	SEROUT2NUM?B	_SDC_response
	SEROUT2DEC?	
	SEROUT2?C	00Dh
	SEROUT2?C	00Ah
	CMPEQ?BCL	_FAT_error, 000h, L00416
	STOP?	
	LABEL?L	L00416	
	GOSUB?L	_FINDfirst
	LABEL?L	L00418	
	CMPNE?BCL	_FAT_error, 000h, L00419
	SEROUT2DPIN?T	_PORTC??6
	SEROUT2MODE?C	054h
	SEROUT2PACE?C	000h
	SEROUT2COUNT?C	00Bh
	SEROUT2STRN?B	_FAT_FileName
	SEROUT2?C	00Dh
	SEROUT2?C	00Ah
	GOSUB?L	_FINDnext
	GOTO?L	L00418
	LABEL?L	L00419	
	MOVE?CB	054h, _FAT_FileName
	MOVE?CB	045h, _FAT_FileName + 00001h
	MOVE?CB	053h, _FAT_FileName + 00002h
	MOVE?CB	054h, _FAT_FileName + 00003h
	MOVE?CB	031h, _FAT_FileName + 00004h
	MOVE?CB	020h, _FAT_FileName + 00005h
	MOVE?CB	020h, _FAT_FileName + 00006h
	MOVE?CB	020h, _FAT_FileName + 00007h
	MOVE?CB	054h, _FAT_FileName + 00008h
	MOVE?CB	058h, _FAT_FileName + 00009h
	MOVE?CB	054h, _FAT_FileName + 0000Ah
	MOVE?CB	005h, _FAT_seconds
	MOVE?CB	01Eh, _FAT_minutes
	MOVE?CB	008h, _FAT_hours
	MOVE?CB	001h, _FAT_day
	MOVE?CB	001h, _FAT_month
	MOVE?CB	01Ch, _FAT_year
	MOVE?CB	077h, _FAT_mode
	GOSUB?L	_FSfopen
	SEROUT2DPIN?T	_PORTC??6
	SEROUT2MODE?C	054h
	SEROUT2PACE?C	000h
	SEROUT2?C	04Fh
	SEROUT2?C	070h
	SEROUT2?C	065h
	SEROUT2?C	06Eh
	SEROUT2?C	020h
	SEROUT2?C	066h
	SEROUT2?C	06Fh
	SEROUT2?C	072h
	SEROUT2?C	020h
	SEROUT2?C	077h
	SEROUT2?C	072h
	SEROUT2?C	069h
	SEROUT2?C	074h
	SEROUT2?C	065h
	SEROUT2?C	03Ah
	SEROUT2?C	020h
	SEROUT2COUNT?C	000h
	SEROUT2NUM?B	_FAT_error
	SEROUT2DEC?	
	SEROUT2?C	00Dh
	SEROUT2?C	00Ah
	CMPEQ?BCL	_FAT_error, 000h, L00420
	STOP?	
	LABEL?L	L00420	
	MOVE?CB	041h, _FAT_src
	MOVE?CB	042h, _FAT_src + 00001h
	MOVE?CB	043h, _FAT_src + 00002h
	MOVE?CW	003h, _FAT_count
	GOSUB?L	_FSfwrite
	SEROUT2DPIN?T	_PORTC??6
	SEROUT2MODE?C	054h
	SEROUT2PACE?C	000h
	SEROUT2?C	057h
	SEROUT2?C	072h
	SEROUT2?C	069h
	SEROUT2?C	074h
	SEROUT2?C	065h
	SEROUT2?C	020h
	SEROUT2COUNT?C	000h
	SEROUT2NUM?B	_FAT_error
	SEROUT2DEC?	
	SEROUT2?C	00Dh
	SEROUT2?C	00Ah
	CMPEQ?BCL	_FAT_error, 000h, L00422
	STOP?	
	LABEL?L	L00422	
	GOSUB?L	_FSfclose
	SEROUT2DPIN?T	_PORTC??6
	SEROUT2MODE?C	054h
	SEROUT2PACE?C	000h
	SEROUT2?C	043h
	SEROUT2?C	06Ch
	SEROUT2?C	06Fh
	SEROUT2?C	073h
	SEROUT2?C	065h
	SEROUT2?C	020h
	SEROUT2COUNT?C	000h
	SEROUT2NUM?B	_FAT_error
	SEROUT2DEC?	
	SEROUT2?C	00Dh
	SEROUT2?C	00Ah
	CMPEQ?BCL	_FAT_error, 000h, L00424
	STOP?	
	LABEL?L	L00424	
	MOVE?CB	072h, _FAT_mode
	GOSUB?L	_FSfopen
	SEROUT2DPIN?T	_PORTC??6
	SEROUT2MODE?C	054h
	SEROUT2PACE?C	000h
	SEROUT2?C	04Fh
	SEROUT2?C	070h
	SEROUT2?C	065h
	SEROUT2?C	06Eh
	SEROUT2?C	03Ah
	SEROUT2?C	020h
	SEROUT2COUNT?C	000h
	SEROUT2NUM?B	_FAT_error
	SEROUT2DEC?	
	SEROUT2?C	00Dh
	SEROUT2?C	00Ah
	CMPEQ?BCL	_FAT_error, 000h, L00426
	STOP?	
	LABEL?L	L00426	
	MOVE?CW	001h, _FAT_count
	GOSUB?L	_FSfread
	LABEL?L	L00428	
	CMPNE?BCL	_FAT_error, 000h, L00429
	SEROUT2DPIN?T	_PORTC??6
	SEROUT2MODE?C	054h
	SEROUT2PACE?C	000h
	SEROUT2?B	_FAT_dest
	MOVE?CW	001h, _FAT_count
	GOSUB?L	_FSfread
	GOTO?L	L00428
	LABEL?L	L00429	
	SEROUT2DPIN?T	_PORTC??6
	SEROUT2MODE?C	054h
	SEROUT2PACE?C	000h
	SEROUT2?C	052h
	SEROUT2?C	065h
	SEROUT2?C	061h
	SEROUT2?C	064h
	SEROUT2?C	03Ah
	SEROUT2?C	020h
	SEROUT2COUNT?C	000h
	SEROUT2NUM?B	_FAT_error
	SEROUT2DEC?	
	SEROUT2?C	00Dh
	SEROUT2?C	00Ah
	END?	

	END
