'******************************************************************************
'******************************************************************************
'                              AceTachy2
'                      Tachymtre LCD pour avions
'******************************************************************************
'******************************************************************************
' PIC 16F84A @ 4Mhz
'
' V 1.0 du 26/07/2004 - 960 pas
' 2 Gammes de Mesure
' V 2.0 du 16/08/2004 - Passage  2 gammes auto. - 994 pas
' 
'
'******************************************************************************
'******************************************************************************


	DEFINE BUTTON_PAUSE 250
	
	DEFINE LCD_DREG PORTB	'configuration ports pour afficheur
	DEFINE LCD_DBIT 4
	DEFINE LCD_RSREG PORTB
	DEFINE LCD_RSBIT 3
	DEFINE LCD_EREG PORTB
	DEFINE LCD_EBIT 2
	DEFINE LCD_BITS 4
	DEFINE LCD_LINES 2
	
	PORTA = 0
	PORTB = 0
	TRISA = %00000001
	TRISB = %00000011  

	
	
	CHOIX		var PORTA.0
	SIGNAL2		var PORTB.0 'entre 1 / 1
	SIGNAL1		var PORTB.1 'entre 1 / 10
'	SIGNAL1		var PORTB.0	'Pour esssai
'	SIGNAL2		var PORTB.1	'Pour essai
	
	Change		var Bit
	
	Coeff		var Byte
	Delay		var Byte
	Helice		var Byte
	Scale		var Byte
	N			var Byte
	Chr			var Byte
		
	Duree		var Word
	Duree1		var Word
	Duree2		var Word
	Dummy		var Word
	Dureetot	var Word
	Vitesse		var Word
	
	CLEAR
	
	READ 1,Helice

'******************************************************************************
'Message d'Accueil
'******************************************************************************

	LCDOUT $FE,1, "ACETACHY", $FE, $C0, "REV 2.0"
	
	PAUSE 2000
	
	LCDOUT $FE,1, "**BONS**", $Fe, $C0, "**VOLS**"
	
	PAUSE 2000
	
'******************************************************************************
'Visualisation Hlice
'******************************************************************************
visu:

	LCDOUT $FE, 1, " HELICE"
	LCDOUT $FE, $C0, "  PALES"
	
	SELECT CASE Helice
	
		CASE 0
		
			LCDOUT $FE,$C0, "2"
		
		CASE 1
	
			LCDOUT $FE,$C0, "3"
		
		CASE 2
		
			LCDOUT $FE,$C0, "4"
		
		CASE ELSE
		
			Helice = 0
			GOTO visu
		
	END SELECT
	
	PAUSE 2000
	
	
'******************************************************************************
'Modification Hlice
'******************************************************************************
modif:

	BUTTON CHOIX,0,255,0,delay,0,nochange
	
		Change = 1
	
		Helice = Helice + 1 : Helice = Helice // 3
		
	GOTO visu
	
'******************************************************************************
'Mode compte-tours
'******************************************************************************

nochange:

	IF Change THEN
	
	WRITE 1, Helice
	Change = 0
	
	ENDIF
	
	
'*****************************************************************************	
'Boucle de calibre
'*****************************************************************************	
'calib:
	
	PULSIN Signal2,1,duree1
	RCTIME Signal2,0,duree2
	
	duree = duree1 + duree2
	
'Vitesse Hors Gamme **********************************************************
	
		IF duree < 94 THEN highrpm 'vitesse > 30 000 tr/mn - 2 pales
		
'Vitesse Gamme Haute *********************************************************
							  
			Scale = 1
								  
		IF duree < 3330   THEN 'Vitesse > 1000 t/mn - 2 pales
			
			Scale = 10
			
			PULSIN Signal1,1,duree1
			RCTIME Signal1,0,duree2
			
			duree = duree1 + duree2	
				
		ENDIF
					
			IF ( duree1 >= duree OR duree2 >= duree) THEN Highrpm	
				
	

'*****************************************************************************
'Gamme mesurable *************************************************************
'Mesure:
'*****************************************************************************

	dureetot = 0
	N = 1
	
	REPEAT
	
		duree = 0
		
	IF Scale = 	1 THEN
		
		PULSIN Signal2,1,duree1
		RCTIME Signal2,0,duree2
	
	ELSE
	
		PULSIN Signal1,1,duree1
		RCTIME Signal1,0,duree2
		
	ENDIF
		
		
		IF ( duree1 = 0  OR duree2 = 0 ) THEN Erreur
		
		duree = duree1 + duree2 
		
		dureetot = dureetot + duree
		
		N = N + 1
	
	UNTIL dureetot > ( 65535 - duree )
	
	N = N - 1
	 
	GOTO calcul
	
	
'******************************************************************************	
calcul:
'******************************************************************************

	
	Dureetot = dureetot / 2 ' DIV 32= MAXI 32767 en diviseur!!!

'Correction nb de pales 

	Dummy = 1000 * Scale / ( helice + 2 )
	Dummy = 3000 * Dummy
	Vitesse = DIV32 dureetot

	
'Correction de Gamme

	vitesse = vitesse * N 
	
	dureetot = 0
	
'******************************************************************************
'Affichage
'******************************************************************************	
		
	SELECT CASE Vitesse
	
		CASE is < 100
		
			CHR = 4
	
		CASE is < 1000
			
			CHR = 3
			
		CASE is < 10000	
		
			CHR = 2
		
		CASE is > 9999
		
			CHR = 1
	
	END SELECT
	
	LCDOUT $FE, 1, REP " "\CHR, #Vitesse, $Fe, $C0, " Tr/mn"
	
	PAUSE 500
	
	GOTO Modif
	
'******************************************************************************
'Conditions d'erreur
'******************************************************************************

Erreur:

	LCDOUT $FE, $C0,"*ERREUR*" 

	GOTO Ligne1
	
Highrpm:

	LCDOUT $FE, 1,$FE, $C0, " H/L RPM" 
	
Ligne1:

LCDOUT $FE, 2, "********"

	PAUSE 2000
	
	GOTO Modif

	END
