
    ' Pulse counter 
    ' =============
    '
    ' File name : Count_Display.bas
    ' Company : Mister E 
    ' Programmer : Steve Monfette
    ' Date : 27/12/2004
    ' Device : PIC16F84A-20/P
    '
    '
    ' This program display to 3 x 7 segments dislay the result of 
    ' pulses count on PORTA.4 pin/sec.
    '
    '
    ' Hardware connection :
    ' ---------------------
    '      1. 3 X 7 segments display on PORTB<7:0> 
    '      2. 3 X PNP transistor on PORTA<3:0> to drive common anode 
    '         of each 7 segments display
    '
    '
    ' Programming mode and PIC define
    ' -------------------------------
    '
	@ __config _HS_OSC & _WDT_ON & _PWRTE_ON 
    ' HS oscillator 
    ' Enable watch dog timer
    ' Enable power up timer
    '
    DEFINE OSC 20 ' use 20 MHZ oscillator


    ' I/O Definition
    ' --------------
    '
    TRISA = %11111000 ' PORTA  : <2:0> outputs to common Anode of 7 segment 
                      '                1. PORTA.0 More significant
                      '                2. PORTA.2 Less significant
                      '        : PORTA.4 input for signal
                      '
    TRISB = 0         ' PORTB connected to 7 segments
                      '       B0 : segment a
                      '       B1 : segment b
                      '       B2 : segment c
                      '       B3 : segment d
                      '       B4 : segment e
                      '       B5 : segment f
                      '       B6 : segment g
                      '       B7 : segment decimal dot 
                      

    ' Internal EEPROM definition
    ' --------------------------
    '
    data @0,192,249,164,176,153,146,130,248,128,144 ' table to convert
                                                    ' numbers to 7 segments
                                                    ' pattern output when
                                                    ' drive invert
                                                    


    ' Interrupt and register definition
    ' ---------------------------------
    '
    OPTION_REG = %1111000   ' TMR0 clock source : RA4/T0CKI
                            ' increment on low to high transition
                            ' Prescaler assign to WDT
                            ' WDT rate 1:1
                            '
    INTCON = %10100000      ' Enable global interrupt
                            ' Disable EE write interrupt
                            ' Enable TMR0 overflow interrupt

        
    ' Variable definition
    ' -------------------
    '
    DisplayPort  var PORTB   ' Port for 7 Segments     
    ClockInput   var PORTA.4 ' Input pin for signal
    _7Seg1       con 14      ' enable more significant 7 segment display
    _7Seg2       con 13      ' enable mid significant 7 segment display
    _7Seg3       con 11      ' enable less significant 7 segment display
    Digit_1	     var byte    ' Hundreds digit
    Digit_2	     var byte    ' Tenth digit
    Digit_3	     var byte    ' Unit digit
    ToBeDisplay	 var word    ' Result of count to be send to 7 segment display
    Display      var byte    ' Temp variable
    DisplayLoop  var byte    ' 
    Delay        var word    ' Variable for Delay loop
    OverFlowVar  var word	 '
    Thousands	 var bit	 ' Flag for count >= 1000 & < 10 000 
    TenThousands var bit	 ' Flag for count >= 10 000

    ' Variable and software initialisation
    ' ------------------------------------
    '
    tobedisplay = 0 ' set initial value of count
    TMR0 = 0        ' reset prescaller 
    on interrupt goto SetVarToBeDisplay
    
MainLoop:

    ' MainLoop
    ' ---------
    '
    ' 1. display the result of the count on RA4 pin
    ' 2. refresh display
    ' 3. reset Timer0 
    ' 4. reload prescaler.
    '
    ' Duration of the procedure : 1 sec 
    '           fine tuned by DelayBetweenEachDisplay Sub
    '
    ' Looping 1 sec and get results of the pulse count in
    ' TMR0 + OverFlowVar
    '
    DisplayRefresh:
	'
    ' Testing amount of count
    ' -----------------------
    '
    ' Get the result of count and place decimal point flag
    ' on the according 7 segments
    '
    If tobedisplay>=1000 then
    	tobedisplay=tobedisplay/10
    	if tobedisplay>=1000 then
    		tobedisplay=tobedisplay/10
    		Thousands=0
    		TenThousands=1
    	else
    		TenThousands=0
    		thousands=1
    	endif
     else
    	thousands=0
    	tenthousands=0
    endif
    '
    ' convert digit to 7 segment output pattern
    ' -----------------------------------------
    display=ToBeDisplay dig 2 ' Read hundreds digit
    read display,digit_1      ' Convert hundreds
	if thousands==1 then digit_1=digit_1 & $7F ' enable decimal dot
	                                           ' by clearing PORTB.7

    display=ToBeDisplay dig 1 ' Read tenths digit
    read display,digit_2      ' Convert tenths
    if tenthousands==1 then digit_2=digit_2 & $7F ' enable decimal dot                          '
                                                  ' by clearing PORTB.7
                                                  
    display=ToBeDisplay dig 0 ' Read units digit
    read display,digit_3      ' Convert units
    '
    '
    ' Send digit to 7 segments
    ' ------------------------
    for displayloop = 0 to 111 ' loop for about 1 sec

        ' display hundreds
        ' ----------------
        PORTA=_7seg1        ' enable hundreds 7 segment
        displayport=digit_1 ' display
        gosub DelayBetweenEachDigit
        
        ' display tenth
        ' -------------
        PORTA=_7seg2        ' enable tenth 7 segment
        displayport=digit_2 ' display
        gosub DelayBetweenEachDigit
        
        ' display units
        ' -------------
        PORTA=_7seg3        ' enable unit 7 segment
        displayport=digit_3 ' display
        gosub DelayBetweenEachDigit
        
    next
    tobedisplay = OverFlowVar + TMR0
    OverFlowVar = 0 ' Reset OverFlowVar
    TMR0 = 0        ' reset prescaller
    goto DisplayRefresh


DelayBetweenEachDigit:

    ' DelayBetweenEachDigit
    ' ---------------------
    ' Produce delay of about 3 mSec 
    '
    ' Fine tuned with MPLAB StopWatch to get MainLoop = 1 sec
    '
	for delay=1 to 307
	    @ nop
	next
	@ nop
	@ nop
	@ nop
	@ nop
	@ nop
	@ nop
	@ nop
    return


    disable
SetVarToBeDisplay:
    '
    ' SetVarToBeDisplay
    ' -----------------
    ' interrupt routine of TMR0 overflow
    '
    ' Reset prescaller
    ' Reset overflow flag
    '
    OverFlowVar = OverFlowVar + 256 
    INTCON.2 = 0 ' clear overflow flag
    TMR0 = 0     ' reload TMR0
    resume
    enable    

