'************************************************************************
'*									*
'*                TERMO-CLOCK WITH NOKIA 3310 DISPLAY			*
'*			   AND DS18B20 SENSOR				*
'*									*
'*               CREATED AND DEVELOPED BY NICULESCU DAN			*	
'*	                      2009 - 2010				*
'*									*	
'************************************************************************

@ DEVICE pic16F648A, XT_OSC, WDT_OFF, PWRT_OFF, BOD_OFF, MCLR_ON, LVP_OFF, CPD_OFF, PROTECT_OFF     

Define  NO_CLRWDT 1
DEFINE  OSC 4                            

        TRISB = %00001110        			'portB configuration  0=out 1=in
        TRISA = %10100010        			'portA configuration
        PortA = %11100010        
        CMCON = 7                		
        VRCON = 0                		
        INTCON = 0              

OPTION_REG=%00000111   					'weak pullups on, TMRO prescale = 256
    
RST         var  PortA.4   				'pin 3   Output   reset display
SDIN        var  PortA.3   				'pin 2   Output   master data out        
SCK         var  PortA.2   				'pin 1   Output   Spi clock
DQ          var  PortA.1   				'pin 18  I/O      DQ DS18b20    
D_C         var  PortB.0   				'pin 6   Output   command/data sel. register

Symbol Hrs_button  =  PORTB.1       			' HH button
Symbol Mins_button =  PORTB.2       			' MM button
Symbol Start_button = PORTB.3

HzTimer VAR Word       					'1/2 second counter (2 Hz)    
HH VAR Byte  						' Hours 1-12
MM VAR ByTE  						' Minutes 0-59
SS VAR Byte  						' Seconds 0-59
col VAR Bit  						' colon 1=on, 0=0ff

HzTimer=$7A12        					'for 1/2 Sec
HH=00:MM=00:SS=00:col=0 				'initial conditions
            temperature     var  Word	
            TempC           var  Byte
            Float           var  Byte
            Dummy           var  Byte
            Flag            var  Byte          
            SignBit         var  Flag.0
            Minus           var  Byte   
            LcdReg          var  byte        
            x               var  byte
            y               var  byte
            Offset          var  byte
            Char            var  byte
            a               var  byte
            PosX            VAR  Byte
            PosY            VAR  Byte
            Chr             VAR  Byte
            LcdData         VAR  Byte
            V		    Var  Word		 	' Var. for display
            B1              Var  Byte            	' Byte for TargetTemp calculation 
            B2              Var  Byte            	' Byte for TargetTemp calculation
            Mode 	    Var  Byte            	' 0=Temp. display, 1=Set Temp, 2=Set Hysteresis
            Sign            Var  Byte
DS18B20_12bit 	CON %01111111           ' 750ms,   0.0625C  
'====================================================================           
                
 '                  DATA  @0,$3E,$51,$49,$45,$3E,_       ';// 0         'CIFRE MAI SCURTE              
  '                          $00,$42,$7F,$40,$00,_       ';// 1    
   '                         $42,$61,$51,$49,$46,_       ';// 2     
    '                        $21,$41,$45,$4B,$31,_       ';// 3    
     '                       $18,$14,$12,$7F,$10,_       ';// 4    
      '                      $27,$45,$45,$45,$39,_       ';// 5    
       '                     $3C,$4A,$49,$49,$30,_       ';// 6    
        '                    $01,$71,$09,$05,$03,_       ';// 7    
         '                   $36,$49,$49,$49,$36,_       ';// 8    
          '                  $06,$49,$49,$29,$1E,_       ';// 9 
           '                 $08,$08,$3E,$08,$08,_       ';// +   10
            '                $08,$08,$08,$08,$08,_       ';// -   11
             '               $00,$60,$60,$00,$00,_       ';// .   12
              '              $00,$66,$66,$00,$00,_       ';// :    
               '             $00,$00,$00,$00,$00,_       ';// SPACE	
		    '            $3E,$7F,$41,$7F,$3E,_       ';// 0   02              
                 '           $00,$42,$7F,$7F,$40,_       ';// 1   03
                  '          $62,$71,$59,$4F,$46,_       ';// 2   04
                   '         $22,$41,$49,$7F,$36,_       ';// 3   05
                    '        $1C,$12,$11,$7F,$7F,_       ';// 4   06
                     '       $27,$47,$45,$7D,$39,_       ';// 5   07
                      '      $3E,$7F,$49,$49,$32,_       ';// 6   08
                       '     $01,$71,$79,$0F,$07,_       ';// 7   09
                        '    $36,$7F,$49,$7F,$36,_       ';// 8   10
                         '   $26,$49,$49,$7F,$3E         ';// 9   11    
'====================================================================
                   DATA  @0,$7E,$91,$89,$85,$7E,_       ';// 0            'BIGGER Characters
                            $00,$82,$FF,$80,$00,_       ';// 1    
                            $82,$C1,$A1,$91,$8E,_       ';// 2     
                            $42,$81,$89,$89,$76,_       ';// 3    
                            $18,$14,$12,$FF,$10,_       ';// 4    
                            $4F,$89,$89,$89,$71,_       ';// 5    
                            $7E,$89,$89,$89,$72,_       ';// 6    
                            $01,$E1,$11,$09,$07,_       ';// 7    
                            $76,$89,$89,$89,$76,_       ';// 8    
                            $46,$89,$89,$89,$7E,_       ';// 9 
                            $08,$08,$3E,$08,$08,_       ';// +   10
                            $08,$08,$08,$08,$08,_       ';// -   11
                            $00,$C0,$C0,$00,$00,_       ';// .   12
                            $00,$66,$66,$00,$00,_       ';// :   13
			          $00,$00,$00,$00,$00,_       ';// SPACE	
			          $7E,$91,$89,$FF,$7E,_       ';// 0   02              
                            $00,$82,$FF,$FF,$80,_       ';// 1   03
                            $C2,$E1,$B1,$9F,$8E,_       ';// 2   04
                            $42,$89,$89,$FF,$76,_       ';// 3   05
                            $18,$14,$12,$FF,$FF,_       ';// 4   06
                            $4F,$8F,$89,$F9,$71,_       ';// 5   07
                            $7E,$FF,$89,$89,$72,_       ';// 6   08
                            $01,$F1,$F9,$0F,$07,_       ';// 7   09
                            $76,$89,$89,$FF,$76,_       ';// 8   10
                            $4E,$91,$91,$FF,$7E         ';// 9   11    

'====================================================================           
                pause 100
                RST = 1
                PortB = 0                      
                LcdReg  =  %00100001          		'LCD Extended Commands.
                call    PrintCtrlLcd
                LcdReg  =  $C8                		'Set LCD Vop (Contrast).Initial $c5
                call    PrintCtrlLcd
                LcdReg  =  %00000110          		'Set Temp coefficent.
                call    PrintCtrlLcd
                LcdReg  =  %00010011          		'LCD bias mode 1:48.
                call    PrintCtrlLcd
                LcdReg  =  %00100000          		'LCD Standard Commands, Horizontal addressing mode.
                call    PrintCtrlLcd
                LcdReg  =  $0C                		'LCD in normal mode.  $0D inverse

Call    PrintCtrlLcd                 
Call CursorHome               
Gosub LCD_Clear
   
'======================================================================



OPTION_REG.7=1    'Turn off weak pullups
PORTB.1=0         'Set PORTb.1 low
TMR0=0	      'Reset TMRO
INTCON.2= 0       'Clear TMRO overflow flag


Main:
' Init Temperature Sensor 
 OWOUT DQ, 1, [$CC, $4E, 0, 0, DS18B20_12bit]
 OWOut DQ, 1, [$CC, $48]       		    		'Start temperature conversion
 OWOut DQ, 1, [$CC, $B8] 
 OWOut DQ, 1, [$CC, $BE] 
 Pause 50
 OWIn DQ, 2, [temperature.byte0, temperature.byte1]
 Pause 50 

Call BorderLine
    
ClockLoop: IF INTCON.2=0 THEN ClockLoop 		'Wait for TMRO overflow
INTCON.2=0 'Clear TMRO overflow flag


SetLoop:
   If Mins_button=0 then                         
      MM=MM+1
        IF MM=60 THEN
          MM=0
        EndIf
   Endif

   If Hrs_button=0 then                
      HH=HH+1
        IF HH=24 then
          HH=0
        ENDIF
   EndIf
   
   If Start_button=0 then                
      SS=0
   EndIf

'Goto SetLoop


HzTimer = HzTimer - $1000  'decrement timer
IF HzTimer<$1000  THEN
    IF Col=1 THEN 'update time'
        SS=SS+1
        IF SS=60 THEN
            SS=0 
            MM=MM+1
            IF MM=60 THEN
                MM=0
                HH=HH+1
                IF HH=24 THEN
                    HH=0
                ENDIF
            ENDIF
         ENDIF

'==================================== display time with :
                LcdReg  =  %10100000 + 15               ' cursor  X
                call    PrintCtrlLcd
                LcdReg  =  %01000010 + 1                ' cursor  Y 
                call    PrintCtrlLcd
'================= now display time                  
		If (HH dig 1)= 0 then                  
                	char =  14           
                	call    PrintChar
			  else
		    	char= (HH dig 1) + 15
                	call    PrintChar
            	endif
                char = (HH dig 0) + 15
                call    PrintChar
                
                Char = 13   
                call    PrintChar
            
                Char =  (MM Dig 1) + 15           
                call    PrintChar
                Char = (MM dig 0)  + 15
                call    PrintChar 
                
  '              Char = 10
  '              call PrintChar
                                            
  '              Char =  (SS dig 1)       
  '              Call    PrintChar
  '              Char = (SS dig 0) 
  '              call    PrintChar   
         ELSE
'==================================== display time without :
                LcdReg  =  %10100000 + 15               ' cursor  X
                call    PrintCtrlLcd
                LcdReg  =  %01000010 + 1                ' cursor  Y 
                call    PrintCtrlLcd
'================= now display time
		If (HH dig 1)= 0 then                  
                	char =  14           
                	call    PrintChar
			  else
		    	char= (HH dig 1)  + 15
                	call    PrintChar
                endif
                char = (HH dig 0) + 15
                call    PrintChar
                
                Char = 14   
                call    PrintChar
            
                Char =  (MM Dig 1)  + 15         
                call    PrintChar
                Char = (MM dig 0)  + 15
                call    PrintChar 
                
'                Char = 11
'                call PrintChar
                                            
'                Char =  (SS dig 1)       
'                Call    PrintChar
'                Char = (SS dig 0) 
'                call    PrintChar   
    ENDIF
    Col=Col+1
    HzTimer=HzTimer+$7A12
ELSE

'====================================================================
 OWOut DQ, 1, [$CC, $44] 
 
 WaitLoop:
 While not DQ
 Wend

 OWOut DQ, 1, [$CC, $BE]
 OWIn DQ, 2, [temperature.byte0, temperature.byte1]         
                SignBit = 0
                if  temperature.15 then  
                    temperature  = ~ temperature + 1 
                    SignBit = 1 
                endif  
                
Dummy = 625 * Temperature
TempC = DIV32 10
TempC = (Temperature & $7FF) >> 4
Float = ((Temperature.Lowbyte & $0F ) * 25 )>>2
Temperature=TempC*100 + Float         
 If SignBit then
  V= 10000 - Temperature                 		' 25 C=12500  0 C=10000  -10 C=9000 
  SignBit = 0
 else
  V= 10000 + Temperature
 EndIf
 If V >= 10000 then                      		' Above 0 C.      
  Temperature=V-10000                   
 Else                                   
  Temperature=10000-V                    		' Below 0 C. 
 EndIf

 
 GoSub SelectSign                        		' +/blank/- Sign 

                
'================= setting cursor for display the temperature 1
                LcdReg  =  %10001000                    ' cursor  X
                call    PrintCtrlLcd
                LcdReg  =  %01000010 + 1                ' cursor  Y
                call    PrintCtrlLcd
'================= now display temperature 1
  
                    if Sign = "-"  then 
                         Char = 11   ' - minus
                    	 else
                         Char = 10
                    endif
                    call    PrintChar 
                Char = (temperature dig 3) 
                if char = 0 then
                char = 14
                endif     
                call    PrintChar
                Char = (temperature dig 2)            
                call    PrintChar
                Char = 12                       
                call    PrintChar
                Char = (temperature dig 1)      
                Call    PrintChar 

           
ENDIF

Goto ClockLoop 
'================== L C D ===========================================                

CursorHome:     LcdReg  =  %10000000            	' cursor Home
                call    PrintCtrlLcd
                LcdReg  =  %01000000            	' cursor Home
                call    PrintCtrlLcd
                return

PrintChar:   offset = Char * 5          
             
                for a = 1 to 5                
                    read offset, LcdReg
                    call  PrintDataLcd
                    offset = offset + 1
                next a
                LcdReg = 0
                call    PrintDataLcd
                return
                                    
PrintCtrlLcd:   D_C = 0                             

PrintDataLcd:   for x = 1 to 8                
                    SDIN = LcdReg.7              
                    SCK = 1
                    LcdReg = LcdReg << 1
                    SCK = 0
                next x               
                D_C = 1
                return               
                
LCD_Clear:
  PosX=0:PosY=0:GOSUB LCD_GotoXY
  HIGH D_C
  FOR Chr=1 TO 252
      LcdData=0:GOSUB LCD_ByteOut
      LcdData=0:GOSUB LCD_ByteOut
  NEXT Chr
RETURN

LCD_GotoXY:
  LOW D_C
  LcdData=%01000000 | PosY :GOSUB LCD_ByteOut
  LcdData=%10000000 | PosX :GOSUB LCD_ByteOut
RETURN

LCD_ByteOut:
  SHIFTOUT SDIN,SCK,1,[LcdData]
RETURN         


SelectSign:
 If v = 10000 then                      		' Temperature = 0 C.
  Sign=" " 				        	' No sign
 Else 
  If v < 10000 then              	    		' <> 0
   Sign="-"				        	' Temperature below 0 C.	
  Else
   Sign="+"				        	' Temperature above 0 C.
  EndIf
 EndIf
Return
'====================================================================
BorderLine: 
'===================================  RAND 0
                LcdReg  =  %10000000            	' cursor  X  
               call    PrintCtrlLcd
                LcdReg  =  %01000000            	' cursor  Y
               call    PrintCtrlLcd
                 for y = 0 to 83                   
  				          
LOokup y, [$FF,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,_         ' Up-side "DIGITAL"
           $01,$01,$01,$F9,$F9,$F9,$09,$09,$F9,$F9,$F1,$01,_
           $01,$F9,$F9,$F9,$01,$01,$F1,$F9,$F9,$09,$09,$19,_
           $19,$11,$01,$01,$F9,$F9,$F9,$01,$09,$09,$09,$F9,_
	     $F9,$F9,$09,$09,$09,$01,$F1,$F9,$F9,$09,$09,$F9,_
           $F9,$F1,$01,$01,$F9,$F9,$F9,$01,$01,$01,$01,$01,_
           $01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$01,$FF] ,LcdReg       
                   call    PrintDataLcd
                    next y
'===================================  RAND 1                                
                LcdReg  =  %10000000            	' cursor  X  
               call    PrintCtrlLcd
                LcdReg  =  %01000001            	' cursor  Y
               call    PrintCtrlLcd
                 for y = 0 to 83                   
		                     				                   
LOokup y, [$FF,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,_         ' down-side "DIGITAL"
           $00,$00,$00,$1F,$1F,$1F,$10,$10,$1F,$1F,$0F,$00,_
	     $00,$1F,$1F,$1F,$00,$00,$0F,$1F,$1F,$10,$11,$1F,_
	     $1F,$0F,$00,$00,$1F,$1F,$1F,$00,$00,$00,$00,$1F,_
	     $1F,$1F,$00,$00,$00,$00,$1F,$1F,$1F,$01,$01,$1F,_
           $1F,$1F,$00,$00,$1F,$1F,$1F,$10,$10,$10,$10,$00,_
           $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FF] ,LcdReg		                                           
                   call    PrintDataLcd
                    next y               
                           
                           
'===================================  RAND 2
                LcdReg  =  %10000000            	' cursor  X  
               call    PrintCtrlLcd
                LcdReg  =  %01000010            	' cursor  Y
               call    PrintCtrlLcd
                 for y = 0 to 83    
                 
LOokup y, [$FF,$00,$00,$00,$FF,$01,$01,$00,$01,$01,$3F,$01,_
           $01,$00,$3F,$25,$25,$25,$00,$3F,$02,$0C,$02,$3F,_
           $00,$3F,$09,$09,$06,$00,$01,$01,$01,$01,$01,$01,_
	     $01,$01,$02,$04,$08,$10,$20,$E0,$20,$20,$20,$20,_
           $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$01,$01,_
           $3F,$01,$01,$00,$3F,$00,$3F,$02,$0C,$02,$3F,$00,_
           $3F,$25,$25,$25,$00,$20,$20,$E0,$C0,$00,$00,$FF] , LcdReg 
                   call    PrintDataLcd
                    next y
   
'===================================  RAND 3
                LcdReg  =  %10000000            	' cursor  X  
               call    PrintCtrlLcd
                LcdReg  =  %01000011            	' cursor  Y
               call    PrintCtrlLcd
                 for y = 0 to 4    
                 LOokup y, [$FF,$00,$00,$00,$FF] , LcdReg 
               call    PrintDataLcd
                  next y

                LcdReg  =  %10000000 + 79       	' cursor  X  
               call    PrintCtrlLcd
                LcdReg  =  %01000011            	' cursor  Y
               call    PrintCtrlLcd
                 for y = 0 to 4    
                 LOokup y, [$FF,$FF,$00,$00,$FF] , LcdReg 
               call    PrintDataLcd    
                   next y   

                LcdReg  =  %10000000 + 43       	' cursor  X  
               call    PrintCtrlLcd
                LcdReg  =  %01000011            	' cursor  Y
              call    PrintCtrlLcd
                for y = 0 to 1    
                LOokup y, [$FF] , LcdReg 
              call    PrintDataLcd    
                 next y   
'===================================  RAND 4               
                LcdReg  =  %10000000            	' cursor  X  
               call    PrintCtrlLcd
                LcdReg  =  %01000100            	' cursor  Y
               call    PrintCtrlLcd
                 for y = 0 to 83    
              
LOokup y, [$FF,$00,$00,$00,$03,$06,$06,$06,$06,$06,$06,$06,_
           $06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,_
           $06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,_
           $06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,_
           $06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,_
           $06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,$06,_
           $06,$06,$06,$06,$06,$06,$06,$07,$07,$00,$00,$FF] , LcdReg
                   call    PrintDataLcd
                    next y
                 

'===================================  JOS                
                LcdReg  =  %10000000            	' cursor  X  
               call    PrintCtrlLcd
                LcdReg  =  %01000101            	' cursor  Y
               call    PrintCtrlLcd
                 for y = 0 to 83                   
                
LOokup y, [$FF,$80,$80,$80,$80,$80,$FE,$CA,$CA,$B4,$80,$8E,_		' BY
           $D0,$D0,$BE,$80,$80,$80,$80,$FE,$88,$90,$FE,$80,_            ' NICULESCU
           $FE,$80,$BC,$C2,$C2,$A4,$80,$BE,$C0,$C0,$BE,$80,_            ' DAN
           $FE,$C0,$C0,$C0,$80,$FE,$CA,$CA,$C2,$80,$A4,$CA,_
           $CA,$B0,$80,$BC,$C2,$C2,$A4,$80,$BE,$C0,$C0,$BE,_
           $80,$80,$80,$80,$FE,$C2,$C2,$BC,$80,$FC,$92,$92,_
           $FC,$80,$FE,$88,$90,$FE,$80,$80,$80,$80,$80,$FF] ,LcdReg
                   call    PrintDataLcd
                    next y 

Return

'====================================================================

END                                 			' of program
