; ***************************************
; * Proximity kaart 2 RS-232 vahengu   *
; * felc@edu.ttu.ee					    *
; * viimane bugfix: 21.1.2004			*
; * enable otca tegemine 19.3.2004		*
; * 30.8.RS232_TX vaid saatel output	*
; * 2.9.:viimane bugfix: loeb ja vljastab siis kui lubatakse*
; * Rohkem ei muuda!
; * 20.9.:ja ikka muudame: leitud viga bcd2asciis - unustas 2 esimest numbrit. nd ok!
; * loeb kaardi ja kui ENable=1, saadab "ID xxxxxx0D" kiirusega 4800,n,8,1. Selline tkk siis tuli vlja!
; 19.4.2005.: nullib loetu kuni antakse enable, siis "puhtalt lehelt"
; 6.10.2005.: aeg pikemaks (65mS), pan kiiremini lugeda...Loebki! Kogu algo ringi mcit.Vist funkab...
; 7.10.: OK lpux! Loeb ruttu!
; ***************************************    
	INCLUDE "P12F629.inc"
; ***** Definitions ***** 
; ***** constants *******
#define MaxBits		1ah							; niimitut bitti ootame
#define MaxBytes	4							; niimitut baiti ootame
#define T1timeL		00h;0CFh					; lugejale pikem viide: 65mS
#define T1timeH		00h;77h;7Ah;8A
; ***** Hardware ******** 
;#define Dat0			GPIO,5					; Wiegandi D0 juhe (RF-10 lugejal roheline)
;#define Dat1	      	GPIO,4	                ; Wiegandi D1 juhe (RF-10 lugejal valge)
#define	RS232_TX		GPIO,0					; Daata vlja
#define	enable			GPIO,1					; info vljastamise lubamine (kui 1)
; ***** various flags ***
#define	pulss			flags,2					; 1 kui pulss algas/kestab
#define	viga			flags,0					; 1 kui aega linud le 30mS aga bitid pole kohal
#define dataok		    flags,1                 ; 1 kui 26 bitti vastu vetud
#define CARRY           STATUS,C 
#define ZERO            STATUS,Z 
#define	pank			STATUS,RP0

#define	Dat0			dataport,5
#define	Dat1			dataport,4
; ***** RESET *****          
				org     0000h  
 	__CONFIG _INTRC_OSC_NOCLKOUT & _PWRTE_ON & _BODEN_ON & _MCLRE_OFF & _WDT_OFF & _CP_OFF & _CPD_OFF   
	
; ***** Variables Definitions *****    
RAMbase         equ     20h            
	cblock  	RAMbase                 
				flags                 
				temp0                 
				temp1                 
				temp2                 
				temp3 
				temp4                 
				temp5 
				tmp
				baitcount
				bitcount
				H_byte
				L_byte
				R0
				R1;2b
				R2
				count
				temp
				dataport
				rsbitcount
				rscount
		endc 
Reset         
				goto    Main_Start       		; Alustame siis...
; ***** INTERRUPT *****  
; *************************************************************
; * T1 loeb pulsside kestust. >65mS => viga, lipp psti		  *
; *************************************************************
Interrupt         
				org     0004h 
Push;    		movwf   W_Temp           		; Save W         
;				swapf   STATUS,W         
;				movwf   S_Temp           		; Save STATUS         
;				bcf     STATUS,RP0      		; Select Bank 0 
Disable_Int         	
				bcf     INTCON,GIE       		; keela katckestused        
				btfsc   INTCON,GIE       		       
				goto    Disable_Int      		
         
				btfsc	INTCON,GPIF				; mingi daataots liigutas ennast?
				goto	daatatuleb				; jepp
				btfsc   PIR1,TMR1IF      		; Taimer1 (pulsiseeria pikkus)?         
				goto    Timer_Int        		; jah, anna viga
Pop     			
;				swapf   S_Temp,W         
;				movwf   STATUS           		; Return STATUS         
;				swapf   W_Temp,F         
;				swapf   W_Temp,W         		; Return W         
				retfie                   		; vlja siit, jta intsid lubatux (GIE  !)

; ***** GPIF datasisendite Interrupt *****  
daatatuleb
				bsf		T1CON,TMR1ON			; taimer 1 paketi kestust valvama
				movf	GPIO,W
				movwf	dataport
				bcf		INTCON,GPIF
				movf	baitcount,W 			; arvuta jooxva biti salvestamiseks vajaliku registri aadress
				sublw	temp3+1
				movwf	FSR						; kirjutame sinna kaudselt
				btfss	Dat0					; daata 0 liigutas?
				goto	data0					; ttle 
; **** data 1 liigutas ****
				btfss	Dat1					; daata 1 liigutas?
				goto	data1					; ttle
				goto	Pop
data2:			movf	count,W					; 8 bitti tehtud?
				btfsc	ZERO
				goto	data6					; jah, lae uuesti
				decf	count					; ei, vhenda
				goto	data7

data6
				movlw	7						; jah, taasta count
				movwf	count
				decf	baitcount
data7	
				decfsz	bitcount
				goto	Pop;data9
data8
				bsf		dataok					; valmis!
				bcf		CARRY
				rlf		temp3,1					; korrigeerib viimast baiti
				rlf		temp3,1
				rlf		temp3,1
				rlf		temp3,1
				rlf		temp3,1
				rlf		temp3,1
				
data9								
				movf	GPIO,W					; read port to reset int condition
				bcf		INTCON,GPIF
				goto 	Pop
; **** data 1 ots liigutas ****
data1:			bsf		CARRY					; saime he
				goto	data0b					; kirjuta
; **** data 0 ots liigutas ****
data0:			bcf		CARRY				; saime nulli
; **** kirjutab dataflagis oleva pulsi mllu ****
data0b:			rlf		INDF,F					; nihuta kaardi bitt registrisse card_dat_x sisse
				goto	data2					; jtkame

; **** aeg sai otsa aga pulsse ikka pole (kiki)				
Timer_Int                                            
				bcf     STATUS,RP0      		; pank 0		 
				bcf		T1CON,TMR1ON			; stop taimer 1
				bcf     PIR1,T1IF    			; katkestuse nue maha   
				bsf		viga        			; vea lipp psti
				bsf     STATUS,RP0      		; pank 1		 
 				bcf     PIE1,T1IE 	    		; keela Timer1 Interruptsid
				bcf     STATUS,RP0      		; pank 0		 
				goto	Pop
   
; ************************* 
; ***** Main Program ****** 
; *************************  
Main_Start
				call	Init					; majapidamine korda
;				movlw	'I'
;				call	senddata
;				movlw	'D'
;				call	senddata
main_loop         
;				btfss	enable
;				goto	main_loop
				btfsc	viga					; kik ok?
				goto	Main_Start				; siis tmba vesi peale
				btfss	dataok					; kaart loetud?
				goto	main_loop				; siis tmba ikkagi vesi peale
;				bsf		enable
				call	process					; tee kaardi numbriks
				call	convert					; tee BCD-ks
				call	bcd2ASCII				; tee ASCII-ks
main_wait		btfss	enable					; kas meil lubatakse sna vtta?
				goto	Main_Start;main_wait				; oota luba --------------------- 19.4.2005 update!
;				bsf		pank
;				bcf		TRISIO,0				; RS_232 vljundiks
;				bcf		pank
;				bsf		GPIO,0
				call	send_rs232				; saada baidid teele
;				bsf		pank
;				bsf		TRISIO,0				; RS_232 sisendiks tagasi
;				bcf		pank
;				bsf		GPIO,0
				call	Dly
				call	Dly
;				bsf		enable
				goto	Main_Start				; jlle vesi peale...
; *************************  

Init          
; **** kalibreeri sisemine gener ****
				bsf     STATUS,RP0      		 
				call 	3FFh 					
				movwf 	OSCCAL 					; Kalibreeri sisemine taktigene
; **** taimerid ****
				bcf     STATUS,RP0      		; pank 0 
				bcf     INTCON,T0IE     		; keela Timer0 Interruptsid
				bcf     INTCON,T0IF            
				bcf		T1CON,TMR1ON			; stop taimer 1
				bsf     STATUS,RP0      		; pank 1
 				bcf     PIE1,T1IE 	    		; keela Timer1 Interruptsid
				bcf     STATUS,RP0      		; pank 0
				bcf     PIR1,T1IF    		
				movlw	T1timeL					; lae T1
				movwf	TMR1L
				movlw	T1timeH
				movwf	TMR1H
; **** WDT-d ei pruugi **** 
				clrwdt                    		; WDT nullida 
; **** konf ****
				bsf     STATUS,RP0      		; pank 1 
				movlw   b'00000000'         
				movwf   OPTION_REG      		; 1:1 prescaler T0-le, sisemine takt, WPU lubatud 
; **** pordid ****
				bcf     STATUS,RP0      		; pank 0 
				clrf	GPIO					; pordid nulli
				movlw 	07h 					; analoog komparaator vlja
				movwf 	CMCON 
				bsf     STATUS,RP0      		; pank 1 
				movlw	3eh;3FH;3Eh						; RS_232 sisend, muud kah (1 ka)
				movwf 	TRISIO 
				movlw	3Fh;3CH;3Eh						; WPU-d
				movwf	WPU
				movlw	30h						; int on change kaardilugeja otstele
				movwf	IOCB
				bcf     STATUS,RP0      		; pank 0 
				movlw	3Fh						; port sellisesse lhteseisu
				movwf 	GPIO 
; **** variaablid ****
				clrf	temp0	      		
				clrf	temp1	      		
				clrf	temp2	      		
				clrf	temp3
				clrf	temp4	      		
				clrf	temp5
				movlw	MaxBits	      		
				movwf	bitcount
				movlw	MaxBytes
				movwf	baitcount
				movlw	7
				movwf	count
				bcf		viga
				bcf		dataok	  
				clrf	flags    		
; **** katkestused ****
				bsf		INTCON,PEIE				; luba peripheral ints
				bcf		INTCON,T0IE				; clear int. flags
				movf	GPIO,W					; read port to reset int condition
				bcf		INTCON,GPIF				; port change flag
				bsf		INTCON,GPIE				; enable port on change int
; **** Timer 1 ****
				movlw	b'00000100'				; 1/1 prescaler, int osc, seisma
				movwf	T1CON
				bcf		PIR1,TMR1IF				; letit. lipp
				bsf     STATUS,RP0      		; pank 1 
				bsf		PIE1,TMR1IE				; luba T1 int
				bcf     STATUS,RP0      		; pank 0 
; **** lubame intsid ****
				bsf     INTCON,GIE        		; Enable Interrupts Global 
    			return  

; ***** tee temp0...temp3 kaardi numbrikse *****  
process         								; esiteks teisendame saadud joru igeks binary koodiks
				bcf		CARRY					; valmistume 1. baidi lugemiseks
				rlf		temp0,1					; viskame EVEN paarsuse biti le parda
				bcf		CARRY					; valmistume 2. baidi lugemiseks
				rlf		temp1,1					; jlle nihe
				btfsc	CARRY					; kas temp0-i tuleb 1 vi 0 ?
				bsf		temp0,0					; oli 1
				bcf		CARRY					; nii vi naa, jtkame 3.baidiga
				rlf		temp2,1					; jlle nihe
				btfsc	CARRY					; kas temp1-i tuleb 1 vi 0 ?
				bsf		temp1,0					; oli 1
				bcf		CARRY					; jtkame 4.baidiga
				rlf		temp3,1					; nihe...
				btfsc	CARRY					; kas temp2-i tuleb 1 vi 0 ?
				bsf		temp2,0					; oli 1
				return
;binary number olemas (temp1 ja temp2), teeme BCDks
convert
				movf	temp1,W
				movwf	H_byte
				movf	temp2,W
				movwf	L_byte
B2_BCD 
				bcf 	STATUS,0 ; clear the carry bit
				movlw 	.16
				movwf 	count
				clrf 	R0
				clrf 	R1
				clrf 	R2
loop16 			rlf 	L_byte, F
				rlf 	H_byte, F
				rlf 	R2, F
				rlf 	R1, F
				rlf 	R0, F
				decfsz 	count, F
				goto 	adjDEC
				return;
adjDEC 			
				movlw 	R2
				movwf 	FSR
				call 	adjBCD

				movlw 	R1
				movwf 	FSR
				call 	adjBCD
				movlw 	R0
				movwf 	FSR
				call 	adjBCD
				goto 	loop16

adjBCD 			
				movlw 	3
				addwf 	0,W
				movwf 	temp
				btfsc 	temp,3 ; test if result > 7
				movwf 	0
				movlw 	30
				addwf 	0,W
				movwf 	temp
				btfsc 	temp,7 ; test if result > 7
				movwf 	0 ; save as MSD
				return;
bcd2ASCII
				movf	R0,W
				movwf	temp
				swapf	R0,F					; nihuta
				movlw	0Fh
				andwf	R0,F
				movlw	30h
				addwf	R0,F
				movf	R0,W					; seivime puhvrisse
				movwf	temp0					; 1.bait ASCIIs
				movf	temp,W
				movwf	R0						; taasta
				movlw	0Fh
				andwf	R0,F
				movlw	30h
				addwf	R0,W
				movwf	temp1					; 2.bait ASCIIs

				movf	R1,W		;seivime
				movwf	temp
				swapf	R1,F		; nihuta
				movlw	0Fh
				andwf	R1,F
				movlw	30h
				addwf	R1,F
				movf	R1,W		; seivime puhvrisse
				movwf	temp2		; 3.bait ASCIIs
				movf	temp,W
				movwf	R1			; taasta
				movlw	0Fh
				andwf	R1,F
				movlw	30h
				addwf	R1,W
				movwf	temp3		; 4.bait ASCIIs

				movf	R2,W		;seivime
				movwf	temp
				swapf	R2,F		; nihuta
				movlw	0Fh
				andwf	R2,F
				movlw	30h
				addwf	R2,W
				movwf	temp4		; 5.bait ASCIIs
				movf	temp,W
				movwf	R2			; taasta
				movlw	0Fh
				andwf	R2,F
				movlw	30h
				addwf	R2,W
				movwf	temp5		; 6.bait ASCIIs		
				return
; ***** saada temp0...temp3 RS232-e *****  
send_rs232:         
				movlw	'I'
				call	senddata
				movlw	'D'
				call	senddata
				movlw	' '
				call	senddata
				movf	temp0,W
				call	senddata
				movf	temp1,W
				call	senddata
				movf	temp2,W
				call	senddata
				movf	temp3,W
				call	senddata
				movf	temp4,W
				call	senddata
				movf	temp5,W
				call	senddata
				movlw	0Dh
				call	senddata
				return  

; ***** RS232: Saada W porti GP0 *****  
senddata         
				movwf   tmp         
;				SEL_BANK_1         
;				bcf     TRISB,3         		; Set port B3 to output         
;				SEL_BANK_0   
;       
				movlw   08h         
				movwf   rsbitcount     			; 8 Bitti
          
				bcf     RS232_TX        		;  Start Bit         
				call    Wait_Bit  

Send_RS232_Loop         
				btfsc   tmp,0         
				goto    RS232_TX_1         
				goto    RS232_TX_0  

RS232_TX_1         
				bsf     RS232_TX         
				goto    RS232_Cont  
RS232_TX_0         
				bcf     RS232_TX         
				goto    RS232_Cont  
RS232_Cont         
				call    Wait_Bit         
				rrf     tmp,1         
				decfsz  rsbitcount,1         
				goto    Send_RS232_Loop          

				bsf     RS232_TX         
				call    Wait_Bit          
				call    Wait_Bit          
				call    Wait_Bit          
				return 
; ***** Wiide *****  
Dly
				movlw	0FFh
				movwf	rsbitcount
dly1
				call	Wait_Bit
				decfsz	rsbitcount,1
				goto	dly1
				return
Wait_Bit         
				movlw   .65         
				movwf   rscount 
W196u_Loop         
				decfsz  rscount,1   				; 1         
				goto 	W196u_Loop         		; 2         
				return  


; ***** Reset 12F629 *****          
				org     01FFh         
				goto    Reset					; taassnd...         

				org		03FFh
				retlw	b'10010100'				; dummy OSCCAL
	END  
