'****************************************************************
'*  Name    : UNTITLED.BAS                                      *
'*  Author  : Koos du Preez                                     *
'*  Notice  : Copyright (c) 2005 Trio Sagteware                 *
'*          : All Rights Reserved                               *
'*  Date    : 2005-02-20                                        *
'*  Version : 1.0                                               *
'*  Notes   :                                                   *
'*          :                                                   *
'****************************************************************

    INCLUDE "modedefs.bas"                      'Standard Include for some variables.
    DEFINE OSC                  4              'Oscilator speed.    
    
    '--------- LCD Constants --------
    DEFINE LCD_DREG             PORTD           ' Set LCD Data port.
    DEFINE LCD_DBIT             4               ' Set starting Data bit (0 or 4) if 4-bit bus.
    DEFINE LCD_RSREG            PORTE           ' Set LCD Register Select port.
    DEFINE LCD_RSBIT            1               ' Set LCD Register Select bit.
    DEFINE LCD_EREG             PORTE           ' Set LCD Enable port.
    DEFINE LCD_EBIT             2               ' Set LCD Enable bit.
    DEFINE LCD_BITS             4               ' Set LCD bus size (4 or 8 bits).
    DEFINE LCD_LINES            2               ' Set number of lines on LCD.
    DEFINE LCD_RWREG            PORTA           ' Set LCD Read / Write Port.
    DEFINE LCD_RWBIT            5               ' Set LCD Read / Write Bit.
    
    Lcd_Vdd         Var         PORTE.0         ' Set LCD Power Pin.
    Lcd_Command     Con         254             ' $FE Used to send a Command to LCD.
    Line1_Begin     Con         0               ' Point to beginning of line 1.    
    Key_Col         Var         BYTE            ' Keypad column.
    Key_Row         Var         BYTE            ' Keypad row.
    Key_Val         Var         BYTE            ' Key value.
    sKey            Var         BYTE            ' Key String Value.
    SWITCHPIN       VAR         PORTD.1
    
BootupSystemLCD:
    ADCON1 = 7                                  ' PortA = digital I/O
    OPTION_REG.7 = 0                            ' Enable PORTB pull-ups
    high SWITCHPIN
    '------Startup LCD-------------
    Low     Lcd_Vdd
    Pause   500
    High    Lcd_Vdd
    Pause   50    

MainMenu:
    LCDOUT  Lcd_Command,$0F                     ' Command $0F set Blinking cursor on.
    LCDOUT  Lcd_Command,Line1_Begin             ' Move Cursor to Beginning of Second Line.
    
checkKeyDown:
    PAUSE 50                                    ' Debounce key-input
WaitForKeysUp:                                  ' Wait for all keys up
    PORTB = 0                                   ' All output-pins low
    TRISB = $f0                                 ' Bottom 4-pins out, top 4-pins in
    IF ((PORTB >> 4) != $f) THEN 
        goto WaitForKeysUp  ' If keys down, loop
    else
        PAUSE 50                                    ' Debounce key-input
checkKeyPress:                                  ' Wait for keypress
        '-----------Check for Keypress-----------------
        FOR Key_Row = 0 TO 3                        ' 4 rows in keypad
            PORTB = 0                               ' All output-pins low
            TRISB = (DCD Key_Row) ^ $ff             ' Set one row pin to output
            Key_Col = PORTB >> 4                    ' Read columns
            IF Key_Col != $f THEN                   ' If any keydown, exit
                Key_Val = (Key_Row * 4) + (NCD (Key_Col ^ $f))
                LOOKUP Key_Val,[" 147S<ORE369.2580"],sKey
                LCDOUT Lcd_Command, 1
                LCDOUT Lcd_Command, Line1_Begin, sKey
                pause 50
                goto checkKeyDown
            endif
        NEXT Key_Row
        GOTO checkKeyPress                          ' No keys down, go look again       
    endif
End
