
; PICBASIC PRO(TM) Compiler 2.60LA, (c) 1998, 2009 microEngineering Labs, Inc. All Rights Reserved. 
_USED			EQU	1

	INCLUDE	"C:\PBP2.60\18F4550.INC"

RAM_START       		EQU	00000h
RAM_END         		EQU	007FFh
RAM_BANKS       		EQU	00008h
BANK0_START     		EQU	00060h
BANK0_END       		EQU	000FFh
BANK1_START     		EQU	00100h
BANK1_END       		EQU	001FFh
BANK2_START     		EQU	00200h
BANK2_END       		EQU	002FFh
BANK3_START     		EQU	00300h
BANK3_END       		EQU	003FFh
BANK4_START     		EQU	00400h
BANK4_END       		EQU	004FFh
BANK5_START     		EQU	00500h
BANK5_END       		EQU	005FFh
BANK6_START     		EQU	00600h
BANK6_END       		EQU	006FFh
BANK7_START     		EQU	00700h
BANK7_END       		EQU	007FFh
BANKA_START     		EQU	00000h
BANKA_END       		EQU	0005Fh

; C:\PBP2.60\PBPPI18L.RAM  	00028	A00000	FLAGS   VAR     BYTE BANKA SYSTEM       ' Static flags
FLAGS           		EQU	RAM_START + 000h
; C:\PBP2.60\PBPPI18L.RAM  	00027	A00001	GOP     VAR     BYTE BANKA SYSTEM       ' Gen Op Parameter
GOP             		EQU	RAM_START + 001h
; C:\PBP2.60\PBPPI18L.RAM  	00016	A00002	R4      VAR     WORD BANKA SYSTEM       ' System Register
R4              		EQU	RAM_START + 002h
; C:\PBP2.60\PBPPI18L.RAM  	00017	A00004	R5      VAR     WORD BANKA SYSTEM       ' System Register
R5              		EQU	RAM_START + 004h
; C:\PBP2.60\PBPPI18L.RAM  	00018	A00006	R6      VAR     WORD BANKA SYSTEM       ' System Register
R6              		EQU	RAM_START + 006h
; C:\PBP2.60\PBPPI18L.RAM  	00019	A00008	R7      VAR     WORD BANKA SYSTEM       ' System Register
R7              		EQU	RAM_START + 008h
; C:\PBP2.60\PBPPI18L.RAM  	00020	A0000A	R8      VAR     WORD BANKA SYSTEM       ' System Register
R8              		EQU	RAM_START + 00Ah
; C:\PBP2.60\PBPPI18L.RAM  	00023	A0000C	RM1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Mask
RM1             		EQU	RAM_START + 00Ch
; C:\PBP2.60\PBPPI18L.RAM  	00026	A0000D	RM2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Mask
RM2             		EQU	RAM_START + 00Dh
; C:\PBP2.60\PBPPI18L.RAM  	00021	A0000E	RR1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Register
RR1             		EQU	RAM_START + 00Eh
; C:\PBP2.60\PBPPI18L.RAM  	00024	A0000F	RR2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Register
RR2             		EQU	RAM_START + 00Fh
; C:\PBP2.60\PBPPI18L.RAM  	00022	A00010	RS1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Bank
RS1             		EQU	RAM_START + 010h
; C:\PBP2.60\PBPPI18L.RAM  	00025	A00011	RS2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Bank
RS2             		EQU	RAM_START + 011h
; C:\PBP2.60\PBPPI18L.RAM  	00012	A00012	R0      VAR     LONG BANKA SYSTEM       ' System Register
R0              		EQU	RAM_START + 012h
; C:\PBP2.60\PBPPI18L.RAM  	00013	A00016	R1      VAR     LONG BANKA SYSTEM       ' System Register
R1              		EQU	RAM_START + 016h
; C:\PBP2.60\PBPPI18L.RAM  	00014	A0001A	R2      VAR     LONG BANKA SYSTEM       ' System Register
R2              		EQU	RAM_START + 01Ah
; C:\PBP2.60\PBPPI18L.RAM  	00015	A0001E	R3      VAR     LONG BANKA SYSTEM       ' System Register
R3              		EQU	RAM_START + 01Eh
; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00001	A00022	'/*******************************************************************************
T1              		EQU	RAM_START + 022h
; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00080	A00026	ang         var word     'bank0
_ang             		EQU	RAM_START + 026h
; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00082	A00028	tr_dx       var word     'bank0
_tr_dx           		EQU	RAM_START + 028h
; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00081	A0002A	tr_dy       var word     'bank0
_tr_dy           		EQU	RAM_START + 02Ah
; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00078	A0002C	tr_x        var word     'bank0
_tr_x            		EQU	RAM_START + 02Ch
; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00079	A0002E	tr_y        var word     'bank0
_tr_y            		EQU	RAM_START + 02Eh
; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00077	A00030	quad        var byte     'BANK0
_quad            		EQU	RAM_START + 030h
; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00075	A00031	tr_i        var byte     'BANK0
_tr_i            		EQU	RAM_START + 031h
; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00076	A00032	tr_j        Var byte    ' BANK0
_tr_j            		EQU	RAM_START + 032h
; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00084	A00033	dummy2 var long
_dummy2          		EQU	RAM_START + 033h
; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00083	A00037	atans       var word[15]'bank0
_atans           		EQU	RAM_START + 037h
; C:\PBP2.60\18F4550.BAL   	00026	PORTL   VAR     PORTB
_PORTL           		EQU	 PORTB
; C:\PBP2.60\18F4550.BAL   	00027	PORTH   VAR     PORTC
_PORTH           		EQU	 PORTC
; C:\PBP2.60\18F4550.BAL   	00028	TRISL   VAR     TRISB
_TRISL           		EQU	 TRISB
; C:\PBP2.60\18F4550.BAL   	00029	TRISH   VAR     TRISC
_TRISH           		EQU	 TRISC

; Constants.
_USBMEMORYADDRESS		EQU	00400h
	INCLUDE	"TRIG.MAC"
	INCLUDE	"C:\PBP2.60\PBPPI18L.LIB"


; C:\PBP2.60\18F4550.BAL   	00012	BANKA   $0000, $005F
; C:\PBP2.60\18F4550.BAL   	00013	BANK0   $0060, $00FF
; C:\PBP2.60\18F4550.BAL   	00014	BANK1   $0100, $01FF
; C:\PBP2.60\18F4550.BAL   	00015	BANK2   $0200, $02FF
; C:\PBP2.60\18F4550.BAL   	00016	BANK3   $0300, $03FF
; C:\PBP2.60\18F4550.BAL   	00017	BANK4   $0400, $04FF
; C:\PBP2.60\18F4550.BAL   	00018	BANK5   $0500, $05FF
; C:\PBP2.60\18F4550.BAL   	00019	BANK6   $0600, $06FF
; C:\PBP2.60\18F4550.BAL   	00020	BANK7   $0700, $07FF
; C:\PBP2.60\18F4550.BAL   	00022	LIBRARY "PBPPI18L"

; C:\PBP2.60\18F4550.BAL   	00024	        include "PIC18EXT.BAS"

; C:\PBP2.60\18F4550.BAL   	00031	        include "PBPPI18L.RAM"
; C:\PBP2.60\18F4550.BAL   	00032	USBMEMORYADDRESS Con	$400	' USB RAM starts here

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00085	atans(0) = 16384
	MOVE?CW	04000h, _atans

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00086	atans(1) = 9672
	MOVE?CW	025C8h, _atans + 00002h

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00087	atans(2) = 5110
	MOVE?CW	013F6h, _atans + 00004h

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00088	atans(3) = 2594
	MOVE?CW	00A22h, _atans + 00006h

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00089	atans(4) = 1302
	MOVE?CW	00516h, _atans + 00008h

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00090	atans(5) = 652
	MOVE?CW	0028Ch, _atans + 0000Ah

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00091	atans(6) = 326
	MOVE?CW	00146h, _atans + 0000Ch

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00092	atans(7) = 163
	MOVE?CW	0A3h, _atans + 0000Eh

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00093	atans(8) = 81
	MOVE?CW	051h, _atans + 00010h

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00094	atans(9) = 41
	MOVE?CW	029h, _atans + 00012h

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00095	atans(10) = 20
	MOVE?CW	014h, _atans + 00014h

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00096	atans(11) = 10
	MOVE?CW	00Ah, _atans + 00016h

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00097	atans(12) = 5
	MOVE?CW	005h, _atans + 00018h

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00098	atans(13) = 3
	MOVE?CW	003h, _atans + 0001Ah

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00099	atans(14) = 1
	MOVE?CW	001h, _atans + 0001Ch
; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00101	goto main

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00103	atan2:

	LABEL?L	_atan2	

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00104	    asm

	ASM?

        call atan2_sqrt
    

	ENDASM?


; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00108	    If ang < 16384 then tr_y = 16383 - ang
	CMPGE?WCL	_ang, 04000h, L00001
	SUB?CWW	03FFFh, _ang, _tr_y
	LABEL?L	L00001	

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00109	    if ang > 16383 then 
	CMPLE?WCL	_ang, 03FFFh, L00003

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00110	        tr_y = 65535 - ang     
	SUB?CWW	0FFFFh, _ang, _tr_y

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00111	        tr_y = tr_y + 16383     'correct 90 degrees for radian   
	ADD?WCW	_tr_y, 03FFFh, _tr_y

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00112	    endif
	LABEL?L	L00003	

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00113	    dummy2 = tr_y * 256     'divides radians to get degrees within 57ppm
	MUL?WCN	_tr_y, 00100h, _dummy2

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00114	    tr_y = dummy2/466    'degrees.dd is y, radians is ang 
	DIV?NCW	_dummy2, 001D2h, _tr_y

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00116	return
	RETURN?	

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00118	sincos:

	LABEL?L	_sincos	

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00120	    if ang < 9001 then ang = 9000 - ang
	CMPGE?WCL	_ang, 02329h, L00005
	SUB?CWW	02328h, _ang, _ang
	LABEL?L	L00005	

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00121	    if ang > 9000 then ang = 36000 - (36000 - ang)
	CMPLE?WCL	_ang, 02328h, L00007
	SUB?CWN	08CA0h, _ang, T1
	SUB?CNW	08CA0h, T1, _ang
	LABEL?L	L00007	

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00122	    dummy2 = ang * 466
	MUL?WCN	_ang, 001D2h, _dummy2

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00123	    ang = dummy2/256
	DIV?NCW	_dummy2, 00100h, _ang

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00125	    asm

	ASM?

        call sin_cos
    

	ENDASM?


; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00128	return
	RETURN?	

; C:\PBP2.60\USB18\_TFT\PICBAS~1\TRIG.INC	00130	asm

	ASM?


; Calculates the sine and cosine of the given angle
sin_cos:

  ; Initialize _x to 18218
  movlw 0x2a
  movwf _tr_x
  movlw 0x47
  movwf _tr_x+1

  ; Initialize _y to 0
  clrf _tr_y
  clrf _tr_y+1

  ; Initialize _quad to 0
  clrf _quad

  ; Check if the angle is greater than 16383 (90)
sc_check_greaterthan:
  btfss _ang+1, 7
  btfss _ang+1, 6
  bra sc_check_lessthan
  bra sc_adjust_quad2
  
  ; Check if the angle is less than -16384 (-90)
sc_check_lessthan:
  btfsc _ang+1, 7
  btfsc _ang+1, 6
  bra sc_setup_end

  ; If the angle is in quadrant 3, adjust it to quadrant 4
sc_adjust_quad3:
  negf _ang
  bc sc_negate_quad3
  comf _ang+1
  bra sc_adjust_end

  ; If the low byte negation causes a carry, negate the upper byte
sc_negate_quad3:
  negf _ang+1
  bra sc_adjust_end

  ; If the angle is in quadrant 2, adjust it to quadrant 1
sc_adjust_quad2:
  comf _ang
  comf _ang+1

  ; Toggle the sign bit and set the '_quad' flag
sc_adjust_end:
  btg _ang+1, 7
  setf _quad

  ; Multiply the angle by 2 to get better resolution
sc_setup_end:
  bcf STATUS, 0
  rlcf _ang
  rlcf _ang+1

  ; Set up the main loop
sc_loop_start:
  clrf _tr_i
  lfsr FSR0, _atans

    ; The main loop label
sc_loop:
    movff _tr_x, _tr_dy
    movff _tr_x+1, _tr_dy+1
    movff _tr_i, _tr_j
    movf _tr_j
    bz sc_bs_x_done

      ; Loop to shift _tr_dy right
sc_bs_x_loop:
      bcf STATUS, 0
      rrcf _tr_dy+1
      rrcf _tr_dy
      btfsc _tr_x+1, 7
      bsf _tr_dy+1, 7
      decfsz _tr_j
      bra sc_bs_x_loop

    ; Calculate what needs to be added to _tr_x
sc_bs_x_done:
    movff _tr_y, _tr_dx
    movff _tr_y+1, _tr_dx+1
    movff _tr_i, _tr_j
    movf _tr_j
    bz sc_do_rotation

      ; Loop to shift _tr_dx right
sc_bs_y_loop:
      bcf STATUS, 0
      rrcf _tr_dx+1
      rrcf _tr_dx
      btfsc _tr_y+1, 7
      bsf _tr_dx+1, 7
      decfsz _tr_j
      bra sc_bs_y_loop

    ; Perform adding operations on _tr_x, _tr_y and _ang
sc_do_rotation:
    btfss _ang+1, 7
    bra sc_sub_angle

    ; If _ang is negative
    movf POSTINC0, W
    addwf _ang
    movf POSTINC0, W
    addwfc _ang+1
    movf _tr_dx, W
    addwf _tr_x
    movf _tr_dx+1, W
    addwfc _tr_x+1
    movf _tr_dy, W
    subwf _tr_y
    movf _tr_dy+1, W
    subwfb _tr_y+1
    bra sc_loop_bottom

    ; If _ang is positive
sc_sub_angle:
    movf POSTINC0, W
    subwf _ang
    movf POSTINC0, W
    subwfb _ang+1
    movf _tr_dx, W
    subwf _tr_x
    movf _tr_dx+1, W
    subwfb _tr_x+1
    movf _tr_dy, W
    addwf _tr_y
    movf _tr_dy+1, W
    addwfc _tr_y+1

    ; Increment the counter and exit the loop if done
sc_loop_bottom:
    incf _tr_i
    movlw 0x0f
    cpfseq _tr_i
    bra sc_loop

  ; Negate _tr_x if it was initially in quadrant 2 or 3
sc_finished:
  btfss _quad, 7
  bra sc_output
  negf _tr_x
  bc sc_negate_x
  comf _tr_x+1
  bra sc_output

  ; If the low byte negation causes a carry, negate the upper byte
sc_negate_x:
  negf _tr_x+1

  ; Output the calculated _tr_x and _tr_y values
sc_output:

  return

; Calculates the magnitude and direction of the given ordered pair
atan2_sqrt:

  ; Initialize _ang to 0
  clrf _ang
  clrf _ang+1

  ; Initialize _quad to 0
  clrf _quad

  ; If the point is in quadrant 2 or 3, make _tr_x positive and set flag
as_check_negative:
  btfss _tr_x+1, 7
  bra as_shift_x
  setf _quad
  negf _tr_x
  bc as_negate_x
  comf _tr_x+1
  bra as_shift_x

  ; If the low byte negation causes a carry, negate the upper byte
as_negate_x:
  negf _tr_x+1

  ; Divide the _tr_x coordinate by 2 to prevent overflowing
as_shift_x:
  bcf STATUS, 0
  rrcf _tr_x+1
  rrcf _tr_x

  ; Divide the _tr_y coordinate by 2 to prevent overflowing
as_shift_y:
  bcf STATUS, 0
  rrcf _tr_y+1
  rrcf _tr_y
  btfsc _tr_y+1, 6
  bsf _tr_y+1, 7

  ; Set up the main loop
as_loop_start:
  clrf _tr_i
  lfsr FSR0, _atans

    ; The main loop label
as_loop:
    movff _tr_x, _tr_dy
    movff _tr_x+1, _tr_dy+1
    movff _tr_i, _tr_j
    movf _tr_j
    bz as_bs_x_done

      ; Loop to shift _tr_dy right
as_bs_x_loop:
      bcf STATUS, 0
      rrcf _tr_dy+1
      rrcf _tr_dy
      btfsc _tr_x+1, 7
      bsf _tr_dy+1, 7
      decfsz _tr_j
      bra as_bs_x_loop

    ; Calculate what needs to be added to _tr_x
as_bs_x_done:
    movff _tr_y, _tr_dx
    movff _tr_y+1, _tr_dx+1
    movff _tr_i, _tr_j
    movf _tr_j
    bz as_do_rotation

      ; Loop to shift _tr_dx right
as_bs_y_loop:
      bcf STATUS, 0
      rrcf _tr_dx+1
      rrcf _tr_dx
      btfsc _tr_y+1, 7
      bsf _tr_dx+1, 7
      decfsz _tr_j
      bra as_bs_y_loop

    ; Perform adding operations on _tr_x, _tr_y and _ang, shifting the _atans right one
as_do_rotation:
    movff POSTINC0, PRODL
    movff POSTINC0, PRODH
    bcf STATUS, 0
    rrcf PRODH
    rrcf PRODL
    btfsc  _tr_y+1, 7
    bra as_sub_angle

    ; If _tr_y is positive
    movf PRODL, W
    addwf _ang
    movf PRODH, W
    addwfc _ang+1
    movf _tr_dx, W
    addwf _tr_x
    movf _tr_dx+1, W
    addwfc _tr_x+1
    movf _tr_dy, W
    subwf _tr_y
    movf _tr_dy+1, W
    subwfb _tr_y+1
    bra as_loop_bottom

    ; If _tr_y is negative
as_sub_angle:
    movf PRODL, W
    subwf _ang
    movf PRODH, W
    subwfb _ang+1
    movf _tr_dx, W
    subwf _tr_x
    movf _tr_dx+1, W
    subwfb _tr_x+1
    movf _tr_dy, W
    addwf _tr_y
    movf _tr_dy+1, W
    addwfc _tr_y+1

    ; Increment the counter and exit the loop if done
as_loop_bottom:
    incf _tr_i
    movlw 0x0e
    cpfseq _tr_i
    bra as_loop

  ; Multiply the _tr_x value by 19898 and divide by 2^14 to scale it
as_scale_x:
  movff _tr_x, _tr_dx
  movff _tr_x+1, _tr_dx+1
  movlw 0xba
  mulwf _tr_dx
  movff PRODH, _tr_x
  movlw 0x4d
  mulwf _tr_dx+1
  movff PRODH, _tr_dy
  movff PRODL, _tr_x+1
  movlw 0xba
  mulwf _tr_dx+1
  movf PRODL, W
  addwf _tr_x, F
  movf PRODH, W
  addwfc _tr_x+1, F
  clrf WREG
  addwfc _tr_dy, F
  movlw 0x4d
  mulwf _tr_dx
  movf PRODL, W
  addwf _tr_x, F
  movf PRODH, W
  addwfc _tr_x+1, F
  clrf WREG
  addwfc _tr_dy, F
  movlw 0x06
  movwf _tr_j
as_scale_bs_loop:
    bcf STATUS, 0
    rrcf _tr_dy
    rrcf _tr_x+1
    rrcf _tr_x
    decfsz _tr_j
    bra as_scale_bs_loop

  ; Check if the quadrant was originally changed
as_check_quad:
  btfss _quad, 7
  bra as_output
  btfss _ang+1,7
  bra as_adjust_quad1

  ; If the angle is in quadrant 4, adjust it to quadrant 3
as_adjust_quad4:
  negf _ang
  bc as_negate_quad4
  comf _ang+1
  bra as_adjust_end

  ; If the low byte negation causes a carry, negate the upper byte
as_negate_quad4:
  negf _ang+1
  bra as_adjust_end

  ; If the angle is in quadrant 1, adjust it to quadrant 2
as_adjust_quad1:
  comf _ang
  comf _ang+1

  ; Toggle the sign bit
as_adjust_end:
  btg _ang+1, 7

  ; Output the calculated angle and hypotenuse values
as_output:

  return



	ENDASM?


	END
