'****************************************************************
'*  Name    : Clock.BAS                                         *
'*  Author  : Dave Cutliff                                      *
'*  Notice  : Copyright (c) 2011                                *
'*          : All Rights Reserved                               *
'*  Date    : 1/28/2011                                         *
'*  Version : 1.0                                               *
'*  Notes   :                                                   *
'*          :                                                   *
'****************************************************************

'Temp variables used
tmp_x VAR long
tmp_y VAR long
tmp_xb VAR long
tmp_yb VAR long
tmp_x = 0
tmp_y = 0
tmp_xb = 0
tmp_yb = 0
Stemp var byte
stemp1    var byte
BradToDegrees var word
stemp1 = 0
stemp = 0     
gl_cs	= 0		'Chip select active
Pg    var byte   'Page variable for menu
pg = 1

in_dat   VAR    BYTE		'In coming byte data
in_ser   VAR    BYTE[15]        'In coming data buffer
in_lsb   VAR    BYTE            'In coming lsb of word
in_msb   VAR    BYTE            'In coming msb of word
gl_chr   VAR    BYTE            'Character byte
eep_addr VAR    WORD		'External eeprom address
hex_nibble VAR  BYTE		'Var used for incoming data

'Terminal variables
in_array VAR    BYTE[40]		'In coming array
in_ctl	 VAR    BYTE[8]			'In coming control array
buff_count	VAR	BYTE		'General counter
gl_delay	VAR     BYTE		'Delay variable
gl_idx		VAR     BYTE		'General use
gl_idy		VAR     BYTE            'General use
'cnt         var     word

'Variables used
gl_cmd		var	BYTE
gl_byte		var	BYTE
gl_cur      var BYTE
'gl_i		var	word
'gl_j		var BYTE
'gl_k		var	BYTE
'gl_l        var word
'gl_m        var word
'gl_x		var	WORD
'gl_y		var	WORD
'gl_addr		var	WORD
'gl_w        var WORD
'gl_read		var BYTE
'gl_old		var BYTE
'pix_x		var WORD
'pix_y		var	WORD
'gl_addrlo	var WORD
'gl_addrhi	var WORD
'gl_nib		var	BYTE
'gl_pix		var BYTE
'gl_rstflag	var	BYTE
'gl_word    var  word
'Line variables
'x         var byte
'y         var byte
'k         var word
'l         var byte
'h         var byte
'w         var word
'wLow      var byte
'whigh     var byte
'Rctl      var byte
'Raddr     var byte
'row       var byte
'i         var byte
'i2         var byte
'j2         var byte
'B          var bit
'TP_X       var byte
'TP_Y       var byte
'TP_DP      var byte

'currentX   var long
'currentY  var long
'Xinc      var long
'Yinc      var long
'Dx        var long
'Dy        var long
'TwoDx     var long
'TwoDy     var long
'TwoDxErr     var long
'TwoDyErr     var long
'Clock hand variables
'convert var long
'radius var long
'degree var long
'DegToBrads var byte
'screen2    var byte
'screen2 = 0
'SecNew  var    byte
'SecOld  var    byte
'Circle constants and variables
'gl_pi			con	2	'PI as an integer
'glc_x			var     byte	'Calculation var
'glc_y			var     BYTE	'Calculation var
'glc_s			var     WORD	'Slope
'glc_cx			var     BYTE	'Center x
'glc_cy  		var     BYTE	'Center y
'glc_r			var     BYTE	'Radius
'gl_x1			var     word
'gl_x2           var     word
'gl_y1           var     word
'gl_y2           var     word
's_tick          var     BYTE


goto skipclock
'###############################################################################
DrawSec:
      'Table for coodinates for the end of the line of each sec
      lookup j-1,[170,180,189,199,208,216,224,231,237,242,247,250,253,254,255,_
      254,253,250,247,242,237,231,224,216,207,199,189,180,170,160,150,140,131,121,_
      112,104,96,89,83,78,73,70,67,66,65,66,67,70,73,78,83,89,96,104,113,121,131,140,150,160], gl_x2    

      lookup j-1,[26,27,30,33,38,43,49,56,64,73,81,91,100,110,120,130,140,149,159,_
      168,176,184,191,197,202,207,210,213,214,215,214,213,210,207,202,197,191,_
      184,176,167,159,149,140,130,120,110,100,91,81,72,64,56,49,43,38,33,30,27,26,25], gl_y2
    gl_x1=160
    gl_y1=120
    gosub gl_line

return

DrawCLK:
    gosub gl_grfclr
    
    for j = 0 to 3       ' Draws circles
    glc_cx = 160
    glc_cy = 120
    LookUp j,[101,100,99,2],gl_byte
    glc_r  = gl_byte
    
    gosub gl_circ
    next j
    gosub clkrose  'Prints clock face numbers



 ' Minute hand    convert RTC BCD to Dec
bcdmin = rtcmin & $70
bcdmin = bcdmin >>4
bcdmin = bcdmin * 10
bcdmin = bcdmin + (rtcmin & $0F)
'bcdmin = 20
j = bcdmin
      'Table for coodinates for the end of the line of each minute
      lookup j,[160,169,179,188,197,205,213,220,227,233,238,242,246,248,250,250,_
      250,248,246,242,238,233,227,220,213,205,197,188,179,169,160,151,141,132,123,_
      115,107,100,93,87,82,78,74,72,70,70,70,72,74,78,82,87,93,100,107,115,123,132,141,151], gl_x2    

      lookup j,[30,30,32,34,38,42,47,53,60,67,75,83,92,101,111,120,129,139,148,_
      157,165,173,180,187,193,198,202,206,208,210,210,210,208,206,202,198,193,187,_
      180,173,165,157,148,139,129,120,111,101,92,83,75,67,60,53,47,42,38,34,32,30], gl_y2
    gl_x1=160
    gl_y1=120
    gosub gl_line

  'Hour hand   convert RTC BCD to Dec
bcdhr = rtchour & $70
bcdhr = bcdhr >>4
bcdhr = bcdhr * 10
bcdhr = bcdhr + (rtchour & $0F)
if bcdhr > 12 then
bcdhr = bcdhr - 12
endif
'bcdhr = 9
j = (bcdhr * 5) + (bcdmin/12)
      'Table for coodinates for the end of the line of each hour
      '''lookup j-1,[193,216,225,216,192,160,127,104,95,104,128,160], gl_x2    
lookup j-1,[167,174,180,186,193,198,203,208,213,216,219,222,224,225,225,225,224,_
222,219,216,213,208,203,198,192,186,180,174,167,160,153,146,140,134,127,122,117,_
112,107,104,101,98,96,95,95,95,96,98,101,104,107,112,117,122,128,134,140,146,153,160], gl_x2
      '''lookup j-1,[64,88,120,153,176,185,176,152,120,87,64,55], gl_y2
lookup j-1,[55,56,58,61,64,67,72,77,82,88,94,100,106,113,120,127,134,140,146,153,_
158,163,168,173,176,179,182,184,185,185,185,184,182,179,176,173,168,163,158,152,_
146,140,134,127,120,113,106,100,94,87,82,77,72,67,64,61,58,56,55,55], gl_y2

    gl_x1=160
    gl_y1=120
    gosub gl_line
       
       


return
ClkRose:
	gl_addr = (40*9)+ 10     
	gl_cur  = SYS_CUR_DIR_RT
	GoSub gl_setaddr
	gl_cmd =SYS_MWRITE
	GoSub send_cmd
	For gl_i = 0 to 20
		LookUp gl_i,["10                  2"],gl_byte
		GoSub send_dat
	Next gl_i


	gl_addr = (40*21)+ 10     
	gl_cur  = SYS_CUR_DIR_RT
	GoSub gl_setaddr
	gl_cmd =SYS_MWRITE
	GoSub send_cmd
	For gl_i = 0 to 19
		LookUp gl_i,["8                  4"],gl_byte
		GoSub send_dat
	Next gl_i

   
	gl_addr = (40*5)+ 14     
	gl_cur  = SYS_CUR_DIR_RT
	GoSub gl_setaddr
	gl_cmd =SYS_MWRITE
	GoSub send_cmd
	For gl_i = 0 to 11
		LookUp gl_i,["11         1"],gl_byte
		GoSub send_dat
	Next gl_i

	gl_addr = (40*24)+ 14     
	gl_cur  = SYS_CUR_DIR_RT
	GoSub gl_setaddr
	gl_cmd =SYS_MWRITE
	GoSub send_cmd
	For gl_i = 0 to 12
		LookUp gl_i,["7           5"],gl_byte
		GoSub send_dat
	Next gl_i
	

    gl_addr = (40*3)+ 19    'Line 3 
	gl_cur  = SYS_CUR_DIR_RT
	GoSub gl_setaddr
	gl_cmd =SYS_MWRITE   'MWRITE
	GoSub send_cmd
         j = $12
         gl_byte = ((j>>4)&$0F) +48    ' 1
        GoSub send_dat        
        gl_byte = (j&$0f) +48         '2  
        GoSub send_dat

    gl_addr = (40*26)+ 20    ' line 26
	gl_cur  = SYS_CUR_DIR_RT
	GoSub gl_setaddr
	gl_cmd =SYS_MWRITE   'MWRITE
	GoSub send_cmd
        gl_byte = 6 +48               ' 6 o'clock
        GoSub send_dat        

    gl_addr = (40*15)+ 8    ' line 15
	gl_cur  = SYS_CUR_DIR_RT
	GoSub gl_setaddr
	gl_cmd =SYS_MWRITE   'MWRITE
	GoSub send_cmd
        gl_byte = 9 +48              ' 9 o'clock
        GoSub send_dat 
        
            gl_addr = (40*15)+ 31    'line 15 
	gl_cur  = SYS_CUR_DIR_RT
	GoSub gl_setaddr
	gl_cmd =SYS_MWRITE   'MWRITE
	GoSub send_cmd
        gl_byte = 3 +48             ' 3 o'clock
        GoSub send_dat 

return



UpDateClock:
	    I2Cread i2cdat,i2cclk,$D0,$00,[RTCSec,RTCMin,RTCHour,RTCWDay,RTCDay,RTCMonth,RTCYear,RTCCtrl]
		Pause 500
    gl_addr = lcd_l3 + 5   'Line 3 
	gl_cur  = SYS_CUR_DIR_RT
	GoSub gl_setaddr
    gl_cmd =SYS_MWRITE
	GoSub send_cmd
         gl_byte = ((RTCmonth>>4)&$0F)+48   'month
        GoSub send_dat
        gl_byte = (RTCmonth&$0F) +48    'month
        GoSub send_dat
        gl_byte = "/"     'space
        GoSub send_dat
        gl_byte = ((RTCDay>>4)&$0F)+48   'day
        GoSub send_dat
        gl_byte = (RTCDay&$0F) +48    'day
        GoSub send_dat
        gl_byte = "/"     'space
        GoSub send_dat
        gl_byte = "2"     '2
        GoSub send_dat
        gl_byte = "0"     '0
        GoSub send_dat
        gl_byte = ((RTCYear>>4)&$0F) +$30   'year
        GoSub send_dat       
        gl_byte = (RTCYear&$0F) +$30   'year
        GoSub send_dat 
	gl_addr = lcd_l5 + 5   'Line 3 
	gl_cur  = SYS_CUR_DIR_RT
	GoSub gl_setaddr
    gl_cmd =SYS_MWRITE
	GoSub send_cmd
        gl_byte = ((rtchour>>4)&$0F) +$30    'hour
        GoSub send_dat        
        gl_byte = (rtchour&$0F) +48     'hour
        GoSub send_dat
        gl_byte = ":"     'space
        GoSub send_dat
        gl_byte = ((rtcmin>>4)&$0F) +$30    'min
        GoSub send_dat        
        gl_byte = (rtcmin&$0f) +48     'min
        GoSub send_dat     
''''        ++++++++++++++ TEST ++++++++++++++++++++++
'''        for countera = 0 to 5
'''            rtcmin = $01 'countera
'''            lookup countera,[$09,$10,$11,$12,$01,$02],rtchour
'''            rtcmin = $00
'''            gosub drawclk
'''            pause 250
'''       next countera
''''        ++++++++++++++ TEST ++++++++++++++++++++++        
        
        if rtcminold != rtcmin then    ' if minute has incremented then draw clock
           gosub DrawCLK
           rtcminold = rtcmin
        endif
return
SkipClock:
