'****************************************************************
'*  Name    : ReEnterPBP-18LP.bas                               *
'*  Author  : Darrel Taylor / Timothy Box                       *
'*  Date    : MAR 18, 2006                                      *
'*  Version : 1.4  MAR 24, 2008                                 *
'*  Notes   : Allows re-entry to PBP from a Low Priority        *
'*          :                               ASM interrupt       *
'*          : Must have DT_INTS-18.bas loaded first             *
'****************************************************************
'*  Versions:                                                   *
'*   1.4  MAR 24, 2008                                          *
'*       Corrects an initialization problem affecting the first *
'*         pass system var save. Found by dcorraliza            *
'*       Fixed T7 "Warning" error. Found by Kamikaze47          *
'*   1.3  Aug 26, 2007                                          *
'*       Update for PBP 2.50 using LONG's with PBPL             *
'*   1.2  JUL 18, 2006                                          *
'*       Modified to handle smaller BANKA in the newer chips    *
'****************************************************************
DISABLE DEBUG

DEFINE   ReEnterLPused  1
VarsSaved_L   VAR BIT
VarsSaved_L = 0  ; corrects initilization problem found by dcorraliza

goto OverReEnterL
   
' Save locations for PBP system Vars during Low Priority Interrupts
LP_Vars  VAR  WORD[34]        ; group vars together for less banking
    R0_SaveL      VAR LP_Vars[0]
    R1_SaveL      VAR LP_Vars[2]
    R2_SaveL      VAR LP_Vars[4]
    R3_SaveL      VAR LP_Vars[6]
    R4_SaveL      VAR LP_Vars[8]
    R5_SaveL      VAR LP_Vars[9]
    R6_SaveL      VAR LP_Vars[10]
    R7_SaveL      VAR LP_Vars[11]
    R8_SaveL      VAR LP_Vars[12]
    Flag_GOP_L    VAR LP_Vars[13]
      Flags_SaveL   VAR Flag_GOP_L.lowbyte
      GOP_SaveL     VAR Flag_GOP_L.highbyte
    RM_L          VAR LP_Vars[14]
      RM1_SaveL     VAR RM_L.lowbyte
      RM2_SaveL     VAR RM_L.highbyte
    RR_L          VAR LP_Vars[15]
      RR1_SaveL     VAR RR_L.lowbyte
      RR2_SaveL     VAR RR_L.highbyte
    RS_L          VAR LP_Vars[16]
      RS1_SaveL     VAR RS_L.lowbyte
      RS2_SaveL     VAR RS_L.highbyte
    T1_SaveL      VAR LP_Vars[17]
    T2_SaveL      VAR LP_Vars[19]
    T3_SaveL      VAR LP_Vars[21]
    T4_SaveL      VAR LP_Vars[23]
    T5_SaveL      VAR LP_Vars[25]
    T6_SaveL      VAR LP_Vars[27]
    T7_SaveL      VAR LP_Vars[29]
    TBLPTRU_L     VAR LP_Vars[31]
      TBLPTRU_SaveL VAR TBLPTRU_L.lowbyte
    TBLPTR_L      VAR LP_Vars[32]
      TBLPTRH_SaveL VAR TBLPTR_L.highbyte
      TBLPTRL_SaveL VAR TBLPTR_L.lowbyte
    Product_L     VAR LP_Vars[33]
   
SavePBP_L:               ' Save all PBP system Vars Low Priority
  if VarsSaved_L = 0 then
    R0_SaveL = R0
    R1_SaveL = R1
    R2_SaveL = R2
    R3_SaveL = R3
    asm
        if (PBPLongs_Used == 1)
            MOVE?WW  R0+2, _R0_SaveL+2
            MOVE?WW  R1+2, _R1_SaveL+2
            MOVE?WW  R2+2, _R2_SaveL+2
            MOVE?WW  R3+2, _R3_SaveL+2
        endif
    endasm
    R4_SaveL = R4
    R5_SaveL = R5
    R6_SaveL = R6
    R7_SaveL = R7
    R8_SaveL = R8
    Flags_SaveL = FLAGS
    GOP_SaveL = GOP
    RM1_SaveL = RM1
    RM2_SaveL = RM2
    RR1_SaveL = RR1
    RR2_SaveL = RR2
@ if Save_TBLPTR == 1
    TBLPTRU_SaveL = TBLPTRU
    TBLPTRH_SaveL = TBLPTRH
    TBLPTRL_SaveL = TBLPTRL
@ endif
    ASM
        ifdef RS1
            MOVE?BB    RS1, _RS1_SaveL
        endif
        ifdef RS2
            MOVE?BB    RS2, _RS2_SaveL
        endif
        ifdef MUL
            MOVE?WW    PRODL, _Product_L
        endif
        ifdef T1
            MOVE?WW    T1, _T1_SaveL
            if (PBPLongs_Used == 1)
                MOVE?WW  T1+2, _T1_SaveL+2
            endif
        endif
        ifdef T2
            MOVE?WW    T2, _T2_SaveL
            if (PBPLongs_Used == 1)
                MOVE?WW  T2+2, _T2_SaveL+2
            endif
        endif
        ifdef T3
            MOVE?WW    T3, _T3_SaveL
            if (PBPLongs_Used == 1)
                MOVE?WW  T3+2, _T3_SaveL+2
            endif
        endif
        ifdef T4
            MOVE?WW    T4, _T4_SaveL
            if (PBPLongs_Used == 1)
                MOVE?WW  T4+2, _T4_SaveL+2
            endif
        endif
        ifdef T5
            MOVE?WW    T5, _T5_SaveL
            if (PBPLongs_Used == 1)
                MOVE?WW  T5+2, _T5_SaveL+2
            endif
        endif
        ifdef T6
            MOVE?WW    T6, _T6_SaveL
            if (PBPLongs_Used == 1)
                MOVE?WW  T6+2, _T6_SaveL+2
            endif
        endif
        ifdef T7
            MOVE?WW    T7, _T7_SaveL
            if (PBPLongs_Used == 1)
                MOVE?WW  T7+2, _T7_SaveL+2
            endif
        endif
    ENDASM   
    VarsSaved_L = 1
  endif
@ INT_RETURN

RestorePBP_L:
  if VarsSaved_L = 1 then
    R0 = R0_SaveL
    R1 = R1_SaveL
    R2 = R2_SaveL
    R3 = R3_SaveL
    asm
        if (PBPLongs_Used == 1)
            MOVE?WW  _R0_SaveL+2, R0+2
            MOVE?WW  _R1_SaveL+2, R1+2 
            MOVE?WW  _R2_SaveL+2, R2+2 
            MOVE?WW  _R3_SaveL+2, R3+2 
        endif
    endasm
    R4 = R4_SaveL
    R5 = R5_SaveL
    R6 = R6_SaveL
    R7 = R7_SaveL
    R8 = R8_SaveL
    FLAGS = Flags_SaveL
    GOP = GOP_SaveL
    RM1 = RM1_SaveL
    RM2 = RM2_SaveL
    RR1 = RR1_SaveL
    RR2 = RR2_SaveL
@ if Save_TBLPTR == 1
    TBLPTRU = TBLPTRU_SaveL
    TBLPTRH = TBLPTRH_SaveL
    TBLPTRL = TBLPTRL_SaveL
@ endif
    ASM
        ifdef RS1
            MOVE?BB    _RS1_SaveL, RS1
        endif
        ifdef RS2
            MOVE?BB    _RS2_SaveL, RS2
        endif
        ifdef MUL
            MOVE?WW    _Product_L, PRODL
        endif
        ifdef T1
            MOVE?WW    _T1_SaveL, T1
            if (PBPLongs_Used == 1)
                MOVE?WW  _T1_SaveL+2, T1+2 
            endif
        endif
        ifdef T2
            MOVE?WW    _T2_SaveL, T2
            if (PBPLongs_Used == 1)
                MOVE?WW  _T2_SaveL+2, T2+2 
            endif
        endif
        ifdef T3
            MOVE?WW    _T3_SaveL, T3
            if (PBPLongs_Used == 1)
                MOVE?WW  _T3_SaveL+2, T3+2 
            endif
        endif
        ifdef T4
            MOVE?WW    _T4_SaveL, T4
            if (PBPLongs_Used == 1)
                MOVE?WW  _T4_SaveL+2, T4+2 
            endif
        endif
        ifdef T5
            MOVE?WW    _T5_SaveL, T5
            if (PBPLongs_Used == 1)
                MOVE?WW  _T5_SaveL+2, T5+2 
            endif
        endif
        ifdef T6
            MOVE?WW    _T6_SaveL, T6
            if (PBPLongs_Used == 1)
                MOVE?WW  _T6_SaveL+2, T6+2 
            endif
        endif
        ifdef T7
            MOVE?WW    _T7_SaveL, T7
            if (PBPLongs_Used == 1)
                MOVE?WW  _T7_SaveL+2, T7+2 
            endif
        endif
        ifdef T8
            ifndef NO_T7_WARNING
                ifndef ReEnterHPused
                    messg "Temp variables exceeding T7"
                endif
            endif
        endif
    ENDASM   
    VarsSaved_L = 0
  ENDIF
@ INT_RETURN

OverReEnterL:
ENABLE DEBUG
