'*****************************************************************
'*  Name    : LCD_3310.INC                                       *
'*  Date    : 29.4.2009                                          *
'*  Version : 3.1 with string and variable write macros          *
'*  Notes   : LCD command library for Nokia 3310 or similar LCD  *
'*          : New Single line string and variable macro for      *
'*          : write to LCD makes using the Nokia_3310 much easier*                                     
'*****************************************************************

' LCD Commands are:
'   Lcd_Init
'   Lcd_GotoXY                                             
'   Lcd_Clear                                      
'   Lcd_Home                                               
'   Lcd_Contrast
'   Scr_Normal                                            
'   Scr_Invert  
'   @ PrintStr x,y, "string goes here" 'will auto wrap to next line if needed
'   @ PrintVar x,y, _anyvariablehere
'you can manually position x,y and manually print characters by the following:
'   PosX = 0   'move to position 0 of 83 (char best viewed at spacing of 6)
'   PosY = 1   'move to second line of 6
'   Gosub Lcd_GotoXY 'this must be specified BEFORE stating Lcd_Data 
'   Lcd_Data = "H"   
'   Gosub Lcd_SendChar
                                           

'-------------------------------------------------------------------------------
'LCD Common Variables for 3310 and 7110 LCD
PosX            var Byte        'Variable for Position X
PosY            var Byte        'Variable for Position Y
FC              var Byte [6]    'Variable 6 bytes = 1 character
Lcd_Data        var Byte        'LCD command or data
ColumnNum       var byte        'Column number
CharNum         var byte        'character number
VarData         var word        'variable to print to lcd
n               var byte        'for next variable
digits          var bit        'number of digits in VarData

'for @ printstr
Addr  VAR WORD
Char  VAR byte 'lcdchardata[0]
'-------------------------------------------------------------------------------
'Port Mapping                   'Change to match your application
Lcd_CLK         VAR Portc.3     'LCD Clock
Lcd_DC          VAR Portf.6     'LCD Data/Command
Lcd_SCE          VAR Portf.7     'LCD Chip Enable
Lcd_RES         VAR Portd.3     'LCD Reset
'Lcd_VCC         VAR Porte.2     'LCD Power (always powered for this hardware)
Lcd_SDO         VAR Portc.5     'LCD Data

'initialize display-----------------------------------------------
pause 25
gosub Lcd_Init                     'Initialize LCD
gosub Lcd_Clear                     'Clear contents of screen
'-----------------------------------------------------------------

goto jump_lcd
'-------------------------------------------------------------------------------
Lcd_Init:                                       'Initialize LCD, run 1st this!                 
    Low Lcd_RES                                 'Reset LCD (HW reset)
    pause 1 
    High Lcd_RES                             'Release Reset
    Low Lcd_SCE                                  'Chip Select
    Low Lcd_DC                                  'Command/Data
     
  Lcd_Data= $21: GOSUB Lcd_SendByte       ' LCD EXTENDED COMMANDS
  Lcd_Data= $c8: GOSUB Lcd_SendByte       ' SET LCD Vop (CONTRAST)
  Lcd_Data= $06: GOSUB Lcd_SendByte       ' SET TEMP COEFFICENT
  Lcd_Data= $13: GOSUB Lcd_Sendbyte       ' LCD BIAS MODE
  Lcd_Data= $20: GOSUB Lcd_Sendbyte       ' LCD STANDARD COMMANDS
  lcd_data= $08: gosub lcd_sendbyte       ' LCD blank
  Lcd_Data= $0c: GOSUB Lcd_sendbyte       ' LCD IN NORMAL MODE
    Return

'-------------------------------------------------------------------------------
'@ printstr macro function from Darrel and edited to work for this lcd
'format should look like this: @ PrintStr x,y, "your text string goes here"
ASM
PrintStr macro x, y, Str
    local TheString, OverStr
    goto OverStr
TheString
    data  Str, 0
OverStr
    MOVE?CB  x, _PosX
    MOVE?CB  y, _PosY
    MOVE?CW  TheString, _Addr
    L?CALL   _StringOut
    endm
ENDASM

StringOut:
    Readcode Addr, Char           ' Get a character
    if Char = 0 then StringDone   ' Look for Null char, Stop if found
    Gosub Lcd_GotoXY
    Lcd_Data = Char
    
    gosub Lcd_SendChar          'puttext
    Addr = Addr + 1               ' Point to next character
    PosX = PosX + 6
    if PosX > 78 then           'If end of line, cycle to next line
        PosY = PosY + 1           
        PosX = 0
    endif
    goto StringOut                ' Continue with rest of the string
  StringDone:
return
'_______________________________________________________________________________
'@ PrintVar macro function 
'format should look like this: @ PrintVar x,y, _anyvariable
ASM
PrintVar macro x, y, Variable ;input values from: @PrintVar 0,1, _anyvariable  
    local OverVar                
    goto OverVar                
OverVar
    MOVE?CB  x, _PosX           ;move x from above statement to PosX
    MOVE?CB  y, _PosY           ;move y from above statement to PosY
    MOVE?WW  Variable, _VarData ;move variable in statement to VarData
    L?CALL   _VariableOut       ;call VariableOut function
    endm
ENDASM

VariableOut:
    @ bcf _digits
    for n = 4 to 0 step -1        'cycles through all possible digts of number
        Gosub Lcd_GotoXY          'place character at position PosX and PosY
        Lcd_Data = (VarData dig n) + 48 'digit number n to character str format
        if Lcd_data = 48 and digits = 0 then SkipChar 'skip if first char is 0
        @ bsf _digits             ;show that one character has been printed
        gosub Lcd_SendChar        'print char to screen
        PosX = PosX + 6           'next x position for character
SkipChar:        
    next n
return
'-------------------------------------------------------------------------------
Lcd_GotoXY:                                             'Goto XY coordinates
    Low Lcd_DC
    Lcd_Data=%01000000 | PosY :Gosub Lcd_SendByte	
    Lcd_Data=%10000000 | PosX :Gosub Lcd_SendByte	
    Return

Lcd_Clear:                                              'Clear display
    Gosub Lcd_Home
    High Lcd_DC
    For ColumnNum = 1 to 84                             'Send empty character 
    SHiftOUT Lcd_SDO, Lcd_CLK, MSBFIRST, [0,0,0,0,0,0]  '14 per page           
    Next ColumnNum                                          '6 rows
    High Lcd_DC                                             '14 * 6 = 84
    Return

Lcd_Home:                                               'Cursor home
    PosX=0:PosY=0:Gosub Lcd_GotoXY
    Return

Lcd_Contrast:                                           'Contrast
    Low Lcd_DC
    Lcd_Data= %11010001: Gosub Lcd_SendByte             'Contrast might need 
    Return                                              'fine tunig

Scr_Normal:                                             'Normal screen mode
    Low Lcd_DC
    Lcd_Data= %00001100:Gosub Lcd_SendByte
    return

Scr_Invert:                                             'Invert screen mode
    Low Lcd_DC                                
    Lcd_Data= %00001101:Gosub Lcd_SendByte    
    return

Lcd_SendByte:                                      'Send command or data to LCD
    SHiftOUT Lcd_SDO, Lcd_CLK, MSBFIRST, [Lcd_Data]
    Return


'-------------------------------------------------------------------------------    
' This part demonstrates how to write to LCD
'@ StartSize (lcddata)
Lcd_SendChar:
    lookdown Lcd_data,[" !\#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ"],CharNum'[\]^_`abcdefghijklmnopqrstuvwxyz{|}~"],CharNum
    Lcd_data = CharNum +32   
    sELECT CASE lcd_data
    Case 32                   
    	FC(0)=$00:FC(1)=$00:FC(2)=$00:FC(3)=$00:FC(4)=$00 ' // sp
    Case 33                   
    	FC(0)=$00:FC(1)=$00:FC(2)=$2f:FC(3)=$00:FC(4)=$00 ' // !
    Case 34                   
    	FC(0)=$00:FC(1)=$07:FC(2)=$00:FC(3)=$07:FC(4)=$00 ' // " (use \)
    Case 35                   
    	FC(0)=$14:FC(1)=$7f:FC(2)=$14:FC(3)=$7f:FC(4)=$14 ' // #
    Case 36                   
    	FC(0)=$24:FC(1)=$2a:FC(2)=$7f:FC(3)=$2a:FC(4)=$12 ' // $
    Case 37                   
    	FC(0)=$c4:FC(1)=$c8:FC(2)=$10:FC(3)=$26:FC(4)=$46 ' // %
    Case 38                   
    	FC(0)=$36:FC(1)=$49:FC(2)=$55:FC(3)=$22:FC(4)=$50 ' // &
    Case 39                   
    	FC(0)=$00:FC(1)=$05:FC(2)=$03:FC(3)=$00:FC(4)=$00 ' // '
    Case 40                   
    	FC(0)=$00:FC(1)=$1c:FC(2)=$22:FC(3)=$41:FC(4)=$00 ' // (
    Case 41                   
    	FC(0)=$00:FC(1)=$41:FC(2)=$22:FC(3)=$1c:FC(4)=$00 ' // )
    Case 42                   
    	FC(0)=$14:FC(1)=$08:FC(2)=$3E:FC(3)=$08:FC(4)=$14 ' // *
    Case 43                   
    	FC(0)=$08:FC(1)=$08:FC(2)=$3E:FC(3)=$08:FC(4)=$08 ' // +
    Case 44                   
    	FC(0)=$00:FC(1)=$00:FC(2)=$50:FC(3)=$30:FC(4)=$00 ' // 
    Case 45                   
    	FC(0)=$10:FC(1)=$10:FC(2)=$10:FC(3)=$10:FC(4)=$10 ' // -
    Case 46                   
    	FC(0)=$00:FC(1)=$60:FC(2)=$60:FC(3)=$00:FC(4)=$00 ' // .
    Case 47                   
    	FC(0)=$20:FC(1)=$10:FC(2)=$08:FC(3)=$04:FC(4)=$02 ' // /
    Case 48                   
    	FC(0)=$3E:FC(1)=$51:FC(2)=$49:FC(3)=$45:FC(4)=$3E ' // 0
    Case 49                   
    	FC(0)=$00:FC(1)=$42:FC(2)=$7F:FC(3)=$40:FC(4)=$00 ' // 1
    Case 50                   
    	FC(0)=$42:FC(1)=$61:FC(2)=$51:FC(3)=$49:FC(4)=$46 ' // 2
    Case 51                   
    	FC(0)=$21:FC(1)=$41:FC(2)=$45:FC(3)=$4B:FC(4)=$31 ' // 3
    Case 52                   
    	FC(0)=$18:FC(1)=$14:FC(2)=$12:FC(3)=$7F:FC(4)=$10 ' // 4
    Case 53                   
    	FC(0)=$27:FC(1)=$45:FC(2)=$45:FC(3)=$45:FC(4)=$39 ' // 5
    Case 54                   
    	FC(0)=$3C:FC(1)=$4A:FC(2)=$49:FC(3)=$49:FC(4)=$30 ' // 6
    Case 55                   
    	FC(0)=$01:FC(1)=$71:FC(2)=$09:FC(3)=$05:FC(4)=$03 ' // 7
    Case 56                   
    	FC(0)=$36:FC(1)=$49:FC(2)=$49:FC(3)=$49:FC(4)=$36 ' // 8
    Case 57                   
    	FC(0)=$06:FC(1)=$49:FC(2)=$49:FC(3)=$29:FC(4)=$1E ' // 9
    Case 58                   
    	FC(0)=$00:FC(1)=$36:FC(2)=$36:FC(3)=$00:FC(4)=$00 ' // :
    Case 59                   
    	FC(0)=$00:FC(1)=$56:FC(2)=$36:FC(3)=$00:FC(4)=$00 ' // ";"
    Case 60                   
    	FC(0)=$08:FC(1)=$14:FC(2)=$22:FC(3)=$41:FC(4)=$00 ' // <
    Case 61                   
    	FC(0)=$14:FC(1)=$14:FC(2)=$14:FC(3)=$14:FC(4)=$14 ' // =
    Case 62                   
    	FC(0)=$00:FC(1)=$41:FC(2)=$22:FC(3)=$14:FC(4)=$08 ' // >
    Case 63                   
    	FC(0)=$02:FC(1)=$01:FC(2)=$51:FC(3)=$09:FC(4)=$06 ' // ?
    Case 64                   
    	FC(0)=$32:FC(1)=$49:FC(2)=$59:FC(3)=$51:FC(4)=$3E ' // @
    Case 65                   
    	FC(0)=$7E:FC(1)=$11:FC(2)=$11:FC(3)=$11:FC(4)=$7E ' // A
    Case 66                   
    	FC(0)=$7F:FC(1)=$49:FC(2)=$49:FC(3)=$49:FC(4)=$36 ' // B
    Case 67                   
    	FC(0)=$3E:FC(1)=$41:FC(2)=$41:FC(3)=$41:FC(4)=$22 ' // C
    Case 68                   
    	FC(0)=$7F:FC(1)=$41:FC(2)=$41:FC(3)=$22:FC(4)=$1C ' // D
    Case 69                   
    	FC(0)=$7F:FC(1)=$49:FC(2)=$49:FC(3)=$49:FC(4)=$41 ' // E
    Case 70                   
    	FC(0)=$7F:FC(1)=$09:FC(2)=$09:FC(3)=$09:FC(4)=$01 ' // F
    Case 71                   
    	FC(0)=$3E:FC(1)=$41:FC(2)=$49:FC(3)=$49:FC(4)=$7A ' // G
    Case 72                   
    	FC(0)=$7F:FC(1)=$08:FC(2)=$08:FC(3)=$08:FC(4)=$7F ' // H
    Case 73                   
    	FC(0)=$00:FC(1)=$41:FC(2)=$7F:FC(3)=$41:FC(4)=$00 ' // I
    Case 74                   
    	FC(0)=$20:FC(1)=$40:FC(2)=$41:FC(3)=$3F:FC(4)=$01 ' // J
    Case 75                   
    	FC(0)=$7F:FC(1)=$08:FC(2)=$14:FC(3)=$22:FC(4)=$41 ' // K
    Case 76                   
    	FC(0)=$7F:FC(1)=$40:FC(2)=$40:FC(3)=$40:FC(4)=$40 ' // L
    Case 77                   
    	FC(0)=$7F:FC(1)=$02:FC(2)=$0C:FC(3)=$02:FC(4)=$7F ' // M
    Case 78                   
    	FC(0)=$7F:FC(1)=$04:FC(2)=$08:FC(3)=$10:FC(4)=$7F ' // N
    Case 79                   
    	FC(0)=$3E:FC(1)=$41:FC(2)=$41:FC(3)=$41:FC(4)=$3E ' // O
    Case 80                   
    	FC(0)=$7F:FC(1)=$09:FC(2)=$09:FC(3)=$09:FC(4)=$06 ' // P
    Case 81                   
    	FC(0)=$3E:FC(1)=$41:FC(2)=$51:FC(3)=$21:FC(4)=$5E ' // Q
    Case 82                   
    	FC(0)=$7F:FC(1)=$09:FC(2)=$19:FC(3)=$29:FC(4)=$46 ' // R
    Case 83                   
    	FC(0)=$46:FC(1)=$49:FC(2)=$49:FC(3)=$49:FC(4)=$31 ' // S
    Case 84                   
    	FC(0)=$01:FC(1)=$01:FC(2)=$7F:FC(3)=$01:FC(4)=$01 ' // T
    Case 85                   
    	FC(0)=$3F:FC(1)=$40:FC(2)=$40:FC(3)=$40:FC(4)=$3F ' // U
    Case 86                   
    	FC(0)=$1F:FC(1)=$20:FC(2)=$40:FC(3)=$20:FC(4)=$1F ' // V
    Case 87                   
    	FC(0)=$3F:FC(1)=$40:FC(2)=$38:FC(3)=$40:FC(4)=$3F ' // W
    Case 88                   
    	FC(0)=$63:FC(1)=$14:FC(2)=$08:FC(3)=$14:FC(4)=$63 ' // X
    Case 89                   
    	FC(0)=$07:FC(1)=$08:FC(2)=$70:FC(3)=$08:FC(4)=$07 ' // Y
    Case 90                   
    	FC(0)=$61:FC(1)=$51:FC(2)=$49:FC(3)=$45:FC(4)=$43 ' // Z
'    Case 91                   
'    	FC(0)=$00:FC(1)=$7F:FC(2)=$41:FC(3)=$41:FC(4)=$00 ' // [
'    Case 92                   
'        FC(0)=$02:FC(1)=$04:FC(2)=$08:FC(3)=$10:FC(4)=$20 ' // \  (we are using this for " above)
'    Case 93                   
'    	FC(0)=$00:FC(1)=$41:FC(2)=$41:FC(3)=$7F:FC(4)=$00 ' // ]
'    Case 94                   
'    	FC(0)=$04:FC(1)=$02:FC(2)=$01:FC(3)=$02:FC(4)=$04 ' // ^
'    Case 95                   
'    	FC(0)=$40:FC(1)=$40:FC(2)=$40:FC(3)=$40:FC(4)=$40 ' // _
'    Case 96                   
'    	FC(0)=$00:FC(1)=$01:FC(2)=$02:FC(3)=$04:FC(4)=$00 ' // '
'    Case 97                   
'    	FC(0)=$20:FC(1)=$54:FC(2)=$54:FC(3)=$54:FC(4)=$78 ' // a
'    Case 98                   
'    	FC(0)=$7F:FC(1)=$48:FC(2)=$44:FC(3)=$44:FC(4)=$38 ' // b
'    Case 99                   
'    	FC(0)=$38:FC(1)=$44:FC(2)=$44:FC(3)=$44:FC(4)=$20 ' // c
'    Case 100                   
'    	FC(0)=$38:FC(1)=$44:FC(2)=$44:FC(3)=$48:FC(4)=$7F ' // d
'    Case 101                   
'    	FC(0)=$38:FC(1)=$54:FC(2)=$54:FC(3)=$54:FC(4)=$18 ' // e
'    Case 102                   
'    	FC(0)=$08:FC(1)=$7E:FC(2)=$09:FC(3)=$01:FC(4)=$02 ' // f
'    Case 103                   
'    	FC(0)=$0C:FC(1)=$52:FC(2)=$52:FC(3)=$52:FC(4)=$3E ' // g
'    Case 104                   
'    	FC(0)=$7F:FC(1)=$08:FC(2)=$04:FC(3)=$04:FC(4)=$78 ' // h
'    Case 105                   
'    	FC(0)=$00:FC(1)=$44:FC(2)=$7D:FC(3)=$40:FC(4)=$00 ' // i
'    Case 106                   
'    	FC(0)=$20:FC(1)=$40:FC(2)=$44:FC(3)=$3D:FC(4)=$00 ' // j
'    Case 107                   
'    	FC(0)=$7F:FC(1)=$10:FC(2)=$28:FC(3)=$44:FC(4)=$00 ' // k
'    Case 108                   
'    	FC(0)=$00:FC(1)=$41:FC(2)=$7F:FC(3)=$40:FC(4)=$00 ' // l
'    Case 109                   
'    	FC(0)=$7C:FC(1)=$04:FC(2)=$18:FC(3)=$04:FC(4)=$78 ' // m
'    Case 110                   
'    	FC(0)=$7C:FC(1)=$08:FC(2)=$04:FC(3)=$04:FC(4)=$78 ' // n
'    Case 111                   
'    	FC(0)=$38:FC(1)=$44:FC(2)=$44:FC(3)=$44:FC(4)=$38 ' // o
'    Case 112                   
'    	FC(0)=$7C:FC(1)=$14:FC(2)=$14:FC(3)=$14:FC(4)=$08 ' // p
'    Case 113                   
'    	FC(0)=$08:FC(1)=$14:FC(2)=$14:FC(3)=$18:FC(4)=$7C ' // q
'    Case 114                   
'    	FC(0)=$7C:FC(1)=$08:FC(2)=$04:FC(3)=$04:FC(4)=$08 ' // r
'    Case 115                   
'    	FC(0)=$48:FC(1)=$54:FC(2)=$54:FC(3)=$54:FC(4)=$20 ' // s
'    Case 116                   
'    	FC(0)=$04:FC(1)=$3F:FC(2)=$44:FC(3)=$40:FC(4)=$20 ' // t
'    Case 117                   
'    	FC(0)=$3C:FC(1)=$40:FC(2)=$40:FC(3)=$20:FC(4)=$7C ' // u
'    Case 118                   
'    	FC(0)=$1C:FC(1)=$20:FC(2)=$40:FC(3)=$20:FC(4)=$1C ' // v
'    Case 119                   
'    	FC(0)=$3C:FC(1)=$40:FC(2)=$30:FC(3)=$40:FC(4)=$3C ' // w
'    Case 120                    
'    	FC(0)=$44:FC(1)=$28:FC(2)=$10:FC(3)=$28:FC(4)=$44 ' // x 
'    Case 121                    
'    	FC(0)=$0C:FC(1)=$50:FC(2)=$50:FC(3)=$50:FC(4)=$3C ' // y 
'    Case 122                    
'    	FC(0)=$44:FC(1)=$64:FC(2)=$54:FC(3)=$4C:FC(4)=$44 ' // z 
'    case 123
'        FC(0)=$00:FC(1)=$08:FC(2)=$36:FC(3)=$41:FC(4)=$00'  // {
'    case 124
'        FC(0)=$00:FC(1)=$00:FC(2)=$7F:FC(3)=$00:FC(4)=$00 ' // |
'    case 125
'        FC(0)=$00:FC(1)=$41:FC(2)=$36:FC(3)=$08:FC(4)=$00'  // }    
'    case 126
'        FC(0)=$10:FC(1)=$08:FC(2)=$08:FC(3)=$10:FC(4)=$08'  // ~
    'case 127
    '    FC(0)=$10:FC(1)=$08:FC(2)=$08:FC(3)=$10:FC(4)=$08'  // DEL        
    'Case 128
   ' 	FC(0)=$55:FC(1)=$2A:FC(2)=$55:FC(3)=$2A:FC(4)=$55 ' // 55 (shaded)
    end SELECT
Write_LCD:
    High Lcd_DC
    SHiftOUT Lcd_SDO , Lcd_CLK , MSBFIRST, [ FC(0),FC(1),FC(2),FC(3),FC(4),$00 ]
    Low Lcd_DC
    Return
'@ EndSize (lcddata)
'-------------------------------------------------------------------------------
Write_Graphics:
    High Lcd_DC
    SHiftOUT Lcd_SDO , Lcd_CLK , MSBFIRST, [ FC(0),FC(1),FC(2),FC(3),FC(4),FC(5) ]
    Low Lcd_DC
    Return
jump_lcd:
