'****************************************************************
'*  Name    : PIC_2VXe.BAS                                      *
'*  Author  : Bert Mathis                                       *
'*  Date    : 9/28/2005                                         *
'*  Version : .9A                                               *
'*  Notes   : Alpha Version                                     *
'*          : mathisbr@hotmail.com                              *
'****************************************************************

Include "umfpuV2-spi.bas" ' This file is included with the umFPU and includes
                          ' support routines for MELabs PicBasicPro compiler
define DEBUG_REG PORTB
DEFINE DEBUGIN_REG PORTB
define DEBUG_BIT 4
DEFINE DEBUGIN_BIT 5
define DEBUG_BAUD 9600
DEFINE DEBUGIN_BAUD 9600
define DEBUG_MODE 1
DEFINE DEBUGIN_MODE 1
DEFINE DEBUG_PACING 1000
DEFINE DEBUGIN_PACING 1000

VXE_CS              VAR     PORTB.0 
VXE_SCLK            VAR     PORTB.1
VXE_DATAIN          VAR     PORTB.2
VXE_DATAOUT         var     PORTB.3
FPU_CS              VAR     PORTA.1
FPU_SCLK            VAR     PORTA.0
FPU_DATAIN          VAR     PORTA.7
FPU_DATAOUT         VAR     PORTA.6

'Common Constants
SyncFlag            con     0xAA '0xAA
Terminator          con     0x00 'Send this at the end of each frame

'Component Identifiers
XRaw                con     0x01 
YRaw                con     0x02
XCal                con     0x03
YCal                Con     0x04
Heading             Con     0x05
Magnitude           Con     0x06    
Temperature         Con     0x07
Distortion          Con     0x08
CalStatus           Con     0x09

'Frame Types
GetModInfo          Con     0x01
ModInfoResp         con     0x02
SetDataComponents   CON     0x03
GetData             CON     0x04
DataResp            Con     0x05
SetConfig           con     0x06
GetConfig           Con     0x07
ConfigResp          CON     0x08
SaveConfig          Con     0x09
StartCal            Con     0x0A
StopCal             Con     0x0B
GetCalData          con     0x0C
CalDataResp         Con     0x0D
SetCalData          Con     0x0E

'Config Identifiers
Declination         CON     0x01
TrueNorth           Con     0x02
CalSampleFreq       Con     0x03
SampleFreq          Con     0x04
Period              Con     0x05
BigEndian           Con     0x06
DampingSize         Con     0x07

'Variables
ParamCount          VAR     BYTE  
Sync                VAR     BYTE
FrameType           VAR     BYTE
ModuleType          VAR     BYTE [4]
FirmwareVer         Var     BYTE [4]
ParamCountByte      VAR     BYTE 
ComponentID         VAR     BYTE
DistortionValue     var     byte
CalStatusValue      Var     Byte
TrueNorthByte       Var     BYTe
CalSampleFreqByte   Var     byte
SampleFreqByte      Var     byte
ASICPeriodByte      var     byte
BigEndianByte       var     byte
ConfigID            VAr     byte
ConfigValue         Var     Byte
CalByteLength       Var     byte
MenuVar             Var     Byte
FloatByte           VAR     BYTE [4]
SInt32Byte          Var     Byte [4]
DeclinationByte     VAR     BYTE [6]

Initialize:
VXE_CS = LOW 'I used 4 lines for SPI on both ext devices. This can be simplified or
FPU_CS = LOW 'rearranged. Example: both device cs tied to ground and omit cs code
DEBUG [13, 10, 10, 10, "PIC_V2Xe_V_.9A"]
GoSub Fpu_Reset
IF fpu_status <> SyncChar THEN 'No comunications to FPU
    DEBUG ["uM-FPU not detected."]
    Goto Initialize
ELSE
    GOSUB Print_Version 'display version string
ENDIF
DEBUG [13, 10, "-------------------" 13, 10]

Main:
GOsub SendSetDataComponentsFrame  
Gosub SendGetDataFrame
Gosub ReadFrame
DebugIn 50, Main, [MenuVar] ' goto main after 50 milliseconds
If MenuVar = "A" Then 
    Goto Config
End If
Goto Main ' Should never get here

SendSetDataComponentsFrame:
Read 1, GetXRaw 'These get from int eeprom
Read 2, GetYRaw
Read 3, GetXCal
Read 4, GetYCal
Read 5, GetHeading
Read 6, GetMagnitude
Read 7, GetTemperature
Read 8, GetDistortion
Read 9, GetCalStatus
ParamCount = GetXRaw + GetYRaw + GetXCal + GetYCal + GetHeading_
    + GetMagnitude + GetTemperature + GetDistortion + GetCalStatus
Shiftout VXE_DATAOUT, VXE_SCLK, 1, [SyncFlag, SetDataComponents, ParamCount]
If GetXRaw = 1 Then
    Shiftout VXE_DATAOUT, VXE_SCLK, 1, [XRaw]
End If
If GetYRaw = 1 Then
    shiftout VXE_DATAOUT, VXE_SCLK, 1, [YRaw]
eND IF
IF GetXCal = 1 tHEN
    SHIFTOUT VXE_DATAOUT, VXE_SCLK, 1, [XCal]
END IF
IF GetYCal = 1 THEN
    SHIFTOUT VXE_DATAOUT, VXE_SCLK, 1, [YCal]
eND IF
IF GetHeading = 1 tHEN
    SHIFTOUT VXE_DATAOUT, VXE_SCLK, 1, [HEading]
eND IF
IF GetMagnitude = 1 THEN
    SHIFTOUT VXE_DATAOUT, VXE_SCLK, 1, [Magnitude]
eND IF
IF GetTemperature = 1 THEN
    SHIFTOUT VXE_DATAOUT, VXE_SCLK, 1, [Temperature]
END IF 
IF GetDistortion = 1 THEN
    SHIFTOUT VXE_DATAOUT, VXE_SCLK, 1, [Distortion]
END IF
IF GetCalStatus = 1 THEN
    SHIFTOUT VXE_DATAOUT, VXE_SCLK, 1, [CalStatus]
END IF
shiftout VXE_DATAOUT, VXE_SCLK, 1, [Terminator]
Return 

SendGetDataFrame:
Shiftout VXE_DATAOUT, VXE_SCLK, 1, [SyncFlag, GetData, Terminator]
return
    
ReadFrame:
Shiftin VXE_DATAIN, VXE_SCLK, 0, [Sync]
If Sync = SyncFlag Then 'Proceed
    Else
    Goto ReadFrame
End If
Shiftin VXE_DATAOUT, VXE_SCLK, 0, [FrameType]
Select Case FrameType
    Case ModInfoResp
        GoSub ModInfoRespFrame
    Case DataResp
        GoSub DataRespFrame
    Case ConfigResp
        Gosub ConfigRespFrame
    Case CalDataResp
        Gosub CalDataRespFrame
End SELECT   
REturn
    
ModInfoRespFrame:
Shiftin VXE_DATAIN, VXE_SCLK, 0, [ModuleType[0], ModuleType[1],_
    ModuleType[2], ModuleType[3], FirmwareVer[0], FirmwareVer[1],_
    FirmwareVer[2], FirmwareVer[3], TerminatorByte]
DEBUG [13, "ModuleType=", ModuleType[0], ModuleType[1],_
    ModuleType[2], ModuleType[3], 13, 10]
Debug [13, "FirmwareVer=", FirmwareVer[0], FirmwareVer[1],_
    FirmwareVer[2], FirmwareVer[3], 13, 10]
Debug [13, "0 - Exit"]
GoSub ExitLoop
Return

DataRespFrame:
Shiftin VXE_DATAIN, VXE_SCLK, 0, [ParamCountByte]
For i = 1 to ParamCountByte
shiftin VXE_DATAIN, VXE_SCLK, 0, [ComponentID]
Select Case ComponentID
    Case XRaw
        Serout PIC_SEROUT, 2, [13, "XRaw="]
        GoSub ConvertSInt32
    Case  YRaw
        Serout PIC_SEROUT, 2, [13, "YRaw="]
        GoSub ConvertSInt32
    Case XCal
        Serout PIC_SEROUT, 2, [13, "XCal="]
        GoSub FloatToString
    Case YCal
        Serout PIC_SEROUT, 2, [13, "YCal="]
        GoSub FloatToString
    Case Heading
        Serout PIC_SEROUT, 2, [13, "Heading="]
        GoSub FloatToString
    Case Magnitude
        Serout PIC_SEROUT, 2, [13, "Magnitude="]
        GoSub FloatToString
    Case Temperature
        Serout PIC_SEROUT, 2, [13, "Temperature="]
        GoSub FloatToString
    Case Distortion
        ShiftIN VXE_DATAIN, VXE_SCLK, 0, DistortionValue
        Serout PIC_SEROUT, 2, [13, "Distortion="]
        If DistortionValue = 1 Then
            Debug ["True"]
        Else 
            Debug ["False"]
        End If
    Case Calstatus
        ShiftIN VXE_DATAIN, VXE_SCLK, 0, CalStatusValue
        Serout PIC_SEROUT, 2, [13, "CalStatus=", CalStatusValue, 13, 10]
        If CalStatusValue=1 Then
            Debug ["True"]
        Else 
            Debug ["False"]
        End If
End Select
Debug [13]
NExt i
ShiftIn VXE_DATAIN, VXE_SCLK, 0, [TerminatorByte]
RETURN

ConvertSInt32:
ShiftIN VXE_DATAIN, VXE_SCLK, 0, [SInt32Byte[0], SInt32Byte[1],_
    SInt32Byte[2], SInt32Byte[3]]
ShiftOut FPU_DATAOUT, VXE_SCLK, 1, [LWRITEA+2, SInt32Byte[0],_
    SInt32Byte[1], SInt32Byte[2], SInt32Byte[3]]
GoSub Fpu_wait
Format = 8
GoSub Print_LongFormat
Return

FloatToString:
ShiftIn VXE_DATAIN, VXE_SCLK, 0, [FloatByte[0], FloatByte[1],_
    FloatByte[2], FloatByte[3]]
ShiftOut FPU_DATAOUT, FPU_SCLK, 1, [WRITEA+1, FloatByte[0],_
    FloatByte[1], FloatByte[2], FloatByte[3]]
GoSub Fpu_wait 'Make sure fpu is ready
format = 84 ' 8 digits total, 4 of the 8 are after deciaml
GoSub Print_FloatFormat ' Send Float in above format to debug destination
Return

CalDataRespFrame:
Shiftin VXE_DATAIN, VXE_SCLK, 0, [CalByteLength]
ShiftIn VXE_DATAIN, VXE_SCLK, 0, [FloatByte[0], FloatByte[1], FloatByte[2]_
    FloatByte[3]]
Debug [13, "XOffset="]
Gosub FloatToString
ShiftIn VXE_DATAIN, VXE_SCLK, 0, [FloatByte[0], FloatByte[1], FloatByte[2]_
    FloatByte[3]]
Debug [13, "YOffset="]
Gosub FloatToString
ShiftIn VXE_DATAIN, VXE_SCLK, 0, [FloatByte[0], FloatByte[1], FloatByte[2]_
    FloatByte[3]]
Debug [13, "XGain="]
Gosub FloatToString
ShiftIn VXE_DATAIN, VXE_SCLK, 0, [FloatByte[0], FloatByte[1], FloatByte[2]_
    FloatByte[3]]
Debug [13, "YGain="]
Gosub FloatToString
ShiftIn VXE_DATAIN, VXE_SCLK, 0, [FloatByte[0], FloatByte[1], FloatByte[2]_
    FloatByte[3]]
Debug [13, "Phi="]
Gosub FloatToString
ShiftIn VXE_DATAIN, VXE_SCLK, 0, [FloatByte[0], FloatByte[1], FloatByte[2]_
    FloatByte[3]]
Debug [13, "CalMagnitude="]
Gosub FloatToString
DEBUG [13, "0 - Exit"]
Gosub ExitLoop
Return

Config:   
Debug [13, "Vector V2Xe Configuration", 13]
Debug [13, "Select Command:"]
Debug [13, "1 - Define Outputs"]
Debug [13, "2 - Calibration Menu"]
Debug [13, "3 - Component Menu"]
Debug [13, "4 - Module Info"]
Debug [13, "0 - Exit Configuration"]
DebugIn [MenuVar]
Select Case MenuVar
    Case 1
        Goto DefineOutputs
    Case 2 
        goto CalibrationMenu
    Case 3 
        goto ComponentMenu
    Case 4
        Goto ModuleInfo
    Case 0
        Goto Main
End Select
Goto Config

DefineOutputs:
Read 1, GetXRaw
Read 2, GetYRaw
Read 3, GetXCal
Read 4, GetYCal
Read 5, GetHeading
Read 6, GetMagnitude
Read 7, GetTemperature
Read 8, GetDistortion
Read 9, GetCalStatus
Debug [13, "1=Enabled 0=Disabled"]
Debug ["Select number to change state"]
Debug [13, "1 - XRaw=", GetXRaw]
Debug [13, "2 - YRaw=", GetYRaw]
Debug [13, "3 - XCal=", GetXCal]
Debug [13, "4 - YCal=", GetYCal]
Debug [13, "5 - Heading=", GetHeading]
Debug [13, "6 - Magnitude=", GetMagnitude]
Debug [13, "7 - Temperature=", GetTemperature]
Debug [13, "8 - Distortion=", GetDistortion]
Debug [13, "9 - CalStatus=", GetCalStatus]
Debug [13, "0 - Back To Main"]
Debugin [MenuVar]
Select Case MenuVar
    Case 1 
        If GetXRaw = 1 Then
            Write 1, 0
        Else
            Write 1, 1
        End If
        Goto DefineOutputs
    Case 2
        If GetYRaw = 1 Then 
            Write 2, 0
        Else
            Write 2, 1
        End If
    Case 3 
        If GetXCal = 1 Then
            Write 3, 0
        Else
            Write 3, 0
        End If
        Goto DefineOutputs
    Case 4
        If GetYRaw = 1 Then
            Write 4, 0
        Else
            Write 4, 1
        End If
        Goto DefineOutputs
    Case 5
        If GetHeading = 1 Then
            Write 5, 0
        Else
            Write 5, 1
        End If
        Goto DefineOutputs
    Case 6
        If GetMagnitude = 1 Then
            Write 6, 0
        Else
            Write 6, 1
        End If
        Goto DefineOutputs
    Case 7
        If GetTemperature = 1 Then
            Write 7, 0
        Else
            Write 7, 1
        End If
        Goto DefineOutputs
    Case 8
        If GetDistortion = 1 Then
            Write 8, 0
        Else
            Write 8, 1
        End If
        Goto DefineOutputs
    Case 9
        If GetCalStatus = 1 Then
            Write 9, 0
        Else
            Write 9, 1
        End If
        Goto DefineOutputs
    Case 0 
        GOSUB SendSetDataComponentsFrame
        Goto Config
End Select 
Goto DefineOutputs

CalibrationMenu:
Debug [13, ["CALIBRATION MENU"]
Debug [13, ["1 - Start Calibration"]
Debug [13, ["2 - Stop Calibration"]
Debug [13, ["3 - Get Calibration Data"]
Debug [13, ["0 - Exit To Main"]
DebugIn [MenuVar]
Select Case MenuVar
    Case 1
        Gosub StartCalFrame
    Case 2 
        Gosub StopCalFrame
    Case 3
        Gosub GetCaldata
        Gosub ReadFrame
    Case 0
        Goto Config
End Select    
Goto CalibrationMenu
    
StartCalFrame:
Shiftout VXE_DATAOUT, VXE_SCLK, 1,[SyncFlag, StartCal, Terminator]
RETURN 

StopCalFrame:
Shiftout VXE_DATAOUT, VXE_SCLK, 1, [SyncFlag, StopCal, Terminator]
RETURN

GetCalDataFrame:
Shiftout VXE_DATAOUT, VXE_SCLK, 1, [SyncFlag, GetCalData, Terminator]
RETURN 

ComponentMenu:
Debug [13, "COMPONENT MENU"]
Debug [13, "1 - Get Configuration"]
debug [13, "2 - Set Configuration"]
debug [13, "0 - Exit to Main"]
Debugin [MenuVar]
Select Case MenuVar
    Case 1
        Goto GetConfigMenu
    Case 2 
        Goto SetConfigMenu
    Case 0
        Goto Config
End Select
Goto ComponentMenu

GetConfigMenu:
Debug [13, "GET CONFIG MENU"]
Debug [13, "1 - Get Declination"]
Debug [13, "2 - Get TrueNorth"]
Debug [13, "3 - Get CalSampleFreq"]
Debug [13, "4 - Get SampleFreq"]
Debug [13, "5 - Get ASIC Period"]
Debug [13, "6 - Get BigEndian"]
Debug [13, "7 - Get Damping Size"]
Debug [13, "0 - Exit"]
Debugin [MenuVar]
Select Case MenuVar
    Case 1
        ConfigID = Declination
        Gosub GetConfigFrame
        GOSUB ReadFrame
    Case 2 
        ConfigID = TrueNorth
        GOSUB GetConfigFrame
        GOsub ReadFrame
    Case 3 
        ConfigID = CalSampleFreq
        GOSUB GetConfigFrame
        GOsub ReadFrame
    Case 4 
        ConfigID = SampleFreq
        GOSUB GetConfigFrame
        GOsub ReadFrame
    Case 5 
        ConfigID = Period
        GOSUB GetConfigFrame
        GOsub ReadFrame            
    Case 6 
        ConfigID = BigEndian
        GOSUB GetConfigFrame
        GOsub ReadFrame            
    Case 7 
        ConfigID = DampingSize
        GOSUB GetConfigFrame
        GOsub ReadFrame            
    Case 0 
        Goto ComponentMenu
End Select 
Goto GetConfigMenu
    
GetConfigFrame:
Shiftout VXE_DATAOUT, VXE_SCLK, 1, [SyncFlag, GetConfig, ConfigID, Terminator]
RETURN 

ConfigRespFrame:
Shiftin VXE_DATAIN, VXE_SCLK, 0, [ConfigID, FloatByte[0], FloatByte[1],_
    FloatByte[2], FloatByte[3], TeminatorByte]
Select Case ConfigID
    Case Declination
        DEBUG [13, "Declination="]
        GoSub FloatToString
    Case TrueNorth
        Debug [13, "TrueNorth="]
        GoSub FloatToString
    Case CalSampleFreq
        Debug [13, "CalSampleFreq="]
        GoSub FloatToString
    Case SampleFreq
        Debug [13, "SampleFreq="]
        GoSub FloatToString
    Case Period
        Debug [13, "Period="]
        GoSub FloatToString
    Case BigEndian
        Debug [13, "BigEndian="]
        GoSub FloatToString
    Case DampingSize
        Debug [13, "DampingSize="]
        GoSub FloatToString
End select
Debug [13, "0 - Exit"]
Gosub ExitLoop
Return

ExitLoop:
DebugIn [MenuVar]
If MenuVar = 0 Then
    Return
End If
goto ExitLoop
        
SetConfigMenu:
Debug [13, "SET CONFIG MENU"]
Debug [13, "1 - Set Declination"]
Debug [13, "2 - Set TrueNorth"]
Debug [13, "3 - Set CalSampleFreq"]
Debug [13, "4 - Set SampleFreq"]
Debug [13, "5 - Set ASIC Period"]
Debug [13, "6 - Set BigEndian"]
Debug [13, "7 - Set Damping Size"]
Debug [13, "0 - Exit"]
Debugin [MenuVar]
Select Case MenuVar
    Case 1
        Debug [13, "Enter Declination In Fomat XXX.xx"]
        Debug [13, "Where X=Degrees and x=Minutes"]
        Debugin [STR DeclinationByte\6]
        ShiftOut FPU_DATAOUT, FPU_SCLK, 1, [3, ATOF, DeclinationByte, 0, FSET]
        ShiftOut FPU_DATAOUT, FPU_SCLK, 1, [XOP, READFLOAT]
        ShiftIn FPU_DATAIN, FPU_SCLK, 0, [FloatByte[0], FloatByte[1],_
            FloatByte[2], FloatByte[3]]
        ShiftOut VXE_DATAOUT, VXE_SCLK, 1, [SyncFlag, SetConfig, Declination,_
            FloatByte[0], FloatByte[1], FloatByte[2], FloatByte[3], Terminator]
        Goto SetConfigMenu
    Case 2 
        Debug [13, "Enter TrueNorth Boolean, where"]
        Debug [13, "0=False and 1=True:"]
        DEBUGIN [TrueNorthByte]
        If TrueNorthByte <> 0 OR TrueNorthByte <> 1 Then
            Goto SetConfigMenu
        Else
            ShiftOut VXE_DATAOUT, VXE_SCLK, 1, [SyncFlag, SetConfig, TrueNorth,_
            TrueNorthByte, Terminator] 
        End If
        Goto SetConfigMenu
    Case 3 
        Debug [13, "Enter Calibration Sample Freq"]
        Debug [13, "With a Value 1-8"]
        DEBUGIN [CalSampleFreqByte]
        If CalSampleFreqByte < 1 OR CalSampleFreqByte > 8 Then
            Goto SetConfigMenu
        Else
            ShiftOut VXE_DATAOUT, VXE_SCLK, 1, [SyncFlag, SetConfig,_
                CalSampleFreq, CalSampleFreqByte, Terminator] 
        End If
        Goto SetConfigMenu
    Case 4 
        Debug [13, "Enter Sample Freq", 13]
        Debug [13, "With a Value 0-8", 13, 10]
        DEBUGIN [SampleFreqByte]
        If SampleFreqByte < 0 OR SampleFreqByte > 8 Then
            Goto SetConfigMenu
        Else
            ShiftOut VXE_DATAOUT, VXE_SCLK, 1, [SyncFlag, SetConfig,_
                SampleFreq, SampleFreqByte, Terminator] 
        End If
        Goto SetConfigMenu
    Case 5 
        Debug [13, "Enter Asic Period"]
        Debug [13, "With a Value 1-8"]
        DEBUGIN [AsicPeriodByte]
        If AsicPeriodByte < 1 OR AsicPeriodByte > 8 Then
            Goto SetConfigMenu
        Else
            ShiftOut VXE_DATAOUT, VXE_SCLK, 1, [SyncFlag, SetConfig,_
                AsicPeriod, AsicPeriodByte, Terminator] 
        End If
        Goto SetConfigMenu            
    Case 6 
        Debug [13, "Enter BigEndian Boolean, where"]
        Debug [13, "0=False and 1=True:"]
        DEBUGIN [BigEndianByte]
        If BigEndianByte <> 0 OR BigEndianByte <>1 Then
            Goto SetConfigMenu
        Else
            ShiftOut VXE_DATAOUT, VXE_SCLK, 1, [SyncFlag, SetConfig, BigEndian,_
            BigEndianByte, Terminator] 
        End If
        Goto SetConfigMenu            
    Case 7 
        Debug [13, "Enter Damping Size"]
        Debug [13, "With a Value 1-8"]
        DEBUGIN [DampingSizeByte]
        If DampingSizeByte < 1 OR DampingSizeByte > 8 Then
            Goto SetConfigMenu
        Else
            ShiftOut VXE_DATAOUT, VXE_SCLK, 1, [SyncFlag, SetConfig,_
                DampingSize, DampingSizeByte, Terminator] 
        End If
        Goto SetConfigMenu            
    Case 0     
        Goto ComponentMenu
    End select
    Goto SetConfigMenu

