'****************************************************************
'*  Name    : Clock_test.BAS                                    *
'*  Author  : Dawit TAmrat                                      *
'*  Notice  : Copyright (c) 2005 [select VIEW...EDITOR OPTIONS] *
'*          : All Rights Reserved                               *
'*  Date    : 9/20/2005                                         *
'*  Version : 1.0                                               *
'*  Notes   :                                                   *
'*          :                                                   *
'****************************************************************
'****************************************************************
DEFINE  INTHAND myint
@ device intrc_osc_noclkout   ;rc_osc_(no)clkout,HS/XT/LP_osc,intrc_OSC_(NO)clkout,ec_osc 
@ device wdt_off
@ device lvp_off
@ device pwrt_on
@ device cpd_off
@ device bod_off
@ device mclr_off
@ device PROTECT_OFF

'__________________________________________________________________________________
' This is important for using Asembly interrupt.It is used for saving working data-
' so that we could be able to resume from the interrupt.                          -
'---------------------------------------------------------------------------------
wsave   VAR     BYTE $20 system
wsave1  VAR     BYTE $a0 system  ' Necessary for devices with RAM in bank1
wsave2  VAR     BYTE $120 system ' Necessary for devices with RAM in bank2
ssave   VAR     BYTE bank0 system
psave   VAR     BYTE bank0 system



'These are User variables
'------------------------

Two_Sec	 VAR    byte bank0	 ' make sure that the variables are in bank 0 if they are 
                             'to be used in the asembely interrupt handler
Bat_Day  var    byte         'Battery charging may be extended to next day
Bat_HOUR VAR    BYTE bank0   'Battery charge hour
'Hour     var    byte bank0   'Timer 1 hour
'Minute   var    byte bank0   'Timer 1 minute
Temp     var    byte bank0   'Temporary variable used by Asembly
Time     var    word bank0   'Time formate 1st two hex 4 hour last 2 hex 4 minute
'Vip_Time var    word         'Vip time duration
Hour     var    time.highbyte'The 2nd byte from right of the word Time is used 4 hour 
Minute   var    time.lowbyte 'The 1st byte from right of the word Time is used 4 minute
Day      var    word         'we need only 9 bit to express 365 days of the year          
VipStatus      var bit       'Vip sensor.if it is on,it is a vip Picture
BatCharg_State var Bit       'This is for remembering charging status when power off
Counter        var byte      'Picture counter .No. of picture on board   
Rcpot          var byte      'The 1 to 255 scale that is selected with the 50k Pot
Delay          var word      'The time delay that is created with Rcpot (1sec- 65sec)                         
Charger        var porta.0   '>Battery charger pin
'Compin1        var porta.1  '<comparator input 1
'Compin2        var porta.2  '<reference comparator in 2.
GND_cont       var porta.3   '>this pin control both relays and Light.
Light_pin      var porta.4   '> Light control pin
MainPWR_on_pin var porta.5   '< 0=Main Power off,Battrey on indicator ,MCLR is disabled      
Motor_selector var porta.6   '>Output that goes to the motor selector relay(1=upper,0=down).
Stopsensor     var porta.7   '<Sensor_2 is responsible for all picture stop
Reversensor    var portb.0   '<Sensor_1 is responsible only for reverse toggel from the outside              
Motor          var portb.1   '>Motor power
upp_Break      var portb.2   '>Left break
dwn_Break      var portb.3   '>Right break
Pot_pin        var portb.4   '>50k pot pin
Vip_Led        var portb.5   '>Vip indicating led
'Realtime_osc1  var portb.6
'Realtime_osc2  var portb.7



' **************
' *Device setup*
' **************
PIE1.6 = 0                  'disable the comparator before mesing with cmcon & vrcon
VRCON = %10001011           'Voltage Refernece enabled and voltage = 2.97
pause 10                    'for stabiliazing
CMCON = %10000101           'Single comparator enabled RA0 & RA3 are free for I/O
PAUSE 10
PIR1.6 = 0                  'clear over due interrupt flag
PIE1.6 = 1                  'enable comparator flag
pcon.3=1                    '1=Internal oscillator 4mhz ,0=37khz
T1con =%00001111	        ' Turn on Timer1 with prescaler = 1
Pir1.0 = 0                  'disable comp & timr1 int flag
trisb = %00000001           
trisa = %10100110           'PortA 1&2 are analog input ,the rest are digital I/O
PIE1.0 = 1                  ' Enable TMR1 overflow and Comparator interrupt
INTCON 	= %11010000	        ' Enable global ,peripheral , external interrupts                 
'option_reg.6 = 0            ' disable the external int flag
'OPTION_REG = %00111111      ' Enable PORTB pull-ups



porta.1 = 0
porta.2 = 0
porta.5 = 0
porta.7 = 0
portb.0 = 0
Day = 0                      '*** Day adjustemnt
hour = 12
minute = 13                 '*** Time adjustment 12:13
Motor_selector = 1           'it also shows the direction of the motor (1=upper,0=down)
Vip_led = 0                 'make sure vip duration is zero  
Light_pin = 0                'make sure light is off
BatCharg_State = 0           'nothing is rememberd about the bat state
GoTo Start	                 ' jump over the asm interrupt handler and start the programe


'======================================= 
'||Assembly language interrupt handler ||
'=======================================
Asm
myint 


; comment the following if the device has grater than 2k of code space
;These are the working data saving process.

		movwf	wsave			; Save W
		swapf	STATUS, W		; Swap STATUS to W (swap avoids changing STATUS)
		clrf	STATUS			; Clear STATUS
		movwf	ssave			; Save swapped STATUS
		movf	PCLATH, W		; Move PCLATH to W
		movwf	psave			; Save PCLATH

;CHEECK THE RIGHT INTERRUPT , AND DECIDE WHAT TO DO
  
         BTFSC PIR1, TMR1IF          ; Timer1 overflow interrupt?
         GOTO TM1_INT                ;if yes do TM1_INT
         Goto Unsave                 ; NO, Then it is UNAUTORIZED INTERRUPT.EXIT


; Set the high register of Timer1 to cause an interrupt every
; 32768 counts (65536-32768=32768 or $8000). At 32.768khz, prescale
; set to 1, this equates to a tick every Second. 
         
TM1_INT  ;movlw	080h			    ; Prepare to set TMR1 high register
	     ;movwf	TMR1H      			; Set TMR1H to 80h
         incf	_Two_sec,F			; INCREMENT every two Second 
  	     bcf     PIR1, TMR1IF		; Clear interrupt flag
         Goto Unsave                ;unsave the working register and exit

;With comparator interrup,the CMCON will be read, the inerrupt will be disabled
;temporarly then 8 hour will be added to the Hour var and the result will be stored 
;in the Bat_hour var.  

                  
            
;These are the working data restoring process.
            
Unsave  movf    psave, W	    ; restore the state of everything
        movwf   PCLATH
        swapf   ssave, W
        movwf   STATUS
        swapf   wsave, F
        swapf   wsave, W
        retfie   			    ; Return from interrupt
EndAsm

Start:
gosub Get_time
if time = $0c0f then   'when time is 12:15 ??? do...
   vip_led = 1
   pause 5000 
   vip_led = 0
   pause 500
   vip_led =1
   pause 5000
   vip_led =0
endif



Get_time:
 	' Update the time when needed. The Two_Sec variable will
 	' overflow if you don't update within 8.5 Minutes.  
 	
	PIE1.0 = 0				        ' Mask the interrupt while we're messing with Two_Sec
	minute = minute + (Two_Sec/30)	' Add the accumulated minutes
	Two_Sec = Two_Sec // 30		    ' Retain the left-over seconds
	PIE1.0 = 1				        ' Interrupt is enabled
	hour = hour + (minute / 60)	    ' Add the accumulated hours
	minute = minute // 60	        ' Retain the left-over minutes
	day = day + (hour/24)           ' Add the accumulated days
	hour = hour //24                ' Retain the left-over hour
	Return
	
