
; PicBasic Pro Compiler 2.45a, (c) 1998, 2004 microEngineering Labs, Inc. All Rights Reserved.  
PM_USED			EQU	1

	INCLUDE	"16F628.INC"


; Define statements.
#define		INTHAND		 myint

RAM_START       		EQU	00020h
RAM_END         		EQU	0014Fh
RAM_BANKS       		EQU	00003h
BANK0_START     		EQU	00020h
BANK0_END       		EQU	0007Fh
BANK1_START     		EQU	000A0h
BANK1_END       		EQU	000EFh
BANK2_START     		EQU	00120h
BANK2_END       		EQU	0014Fh
EEPROM_START    		EQU	02100h
EEPROM_END      		EQU	0217Fh

wsave           		EQU	RAM_START + 000h
R0              		EQU	RAM_START + 001h
R1              		EQU	RAM_START + 003h
R2              		EQU	RAM_START + 005h
R3              		EQU	RAM_START + 007h
R4              		EQU	RAM_START + 009h
R5              		EQU	RAM_START + 00Bh
R6              		EQU	RAM_START + 00Dh
R7              		EQU	RAM_START + 00Fh
R8              		EQU	RAM_START + 011h
T1              		EQU	RAM_START + 013h
_Time            		EQU	RAM_START + 015h
_Bat_HOUR        		EQU	RAM_START + 017h
FLAGS           		EQU	RAM_START + 018h
GOP             		EQU	RAM_START + 019h
psave           		EQU	RAM_START + 01Ah
RM1             		EQU	RAM_START + 01Bh
RM2             		EQU	RAM_START + 01Ch
RR1             		EQU	RAM_START + 01Dh
RR2             		EQU	RAM_START + 01Eh
ssave           		EQU	RAM_START + 01Fh
_Temp            		EQU	RAM_START + 020h
_Two_Sec         		EQU	RAM_START + 021h
_Day             		EQU	RAM_START + 022h
_Delay           		EQU	RAM_START + 024h
_Bat_Day         		EQU	RAM_START + 026h
_Counter         		EQU	RAM_START + 027h
PB01            		EQU	RAM_START + 028h
_Rcpot           		EQU	RAM_START + 029h
wsave1          		EQU	RAM_START + 080h
wsave2          		EQU	RAM_START + 00100h
_PORTL           		EQU	 PORTB
_PORTH           		EQU	 PORTA
_TRISL           		EQU	 TRISB
_TRISH           		EQU	 TRISA
_Hour            		EQU	_Time + 001h
_Minute          		EQU	_Time
_Time_HIGHBYTE   		EQU	_Time + 001h
_Time_LOWBYTE    		EQU	_Time
#define _VipStatus       	 PB01, 001h
#define _BatCharg_State  	 PB01, 000h
#define _Charger         	_PORTA_0
#define _GND_cont        	_PORTA_3
#define _Light_pin       	_PORTA_4
#define _MainPWR_on_pin  	_PORTA_5
#define _Motor_selector  	_PORTA_6
#define _Stopsensor      	_PORTA_7
#define _Reversensor     	_PORTB_0
#define _Motor           	_PORTB_1
#define _upp_Break       	_PORTB_2
#define _dwn_Break       	_PORTB_3
#define _Pot_pin         	_PORTB_4
#define _Vip_Led         	_PORTB_5
#define _PORTA_0         	 PORTA, 000h
#define _PORTA_3         	 PORTA, 003h
#define _PORTA_4         	 PORTA, 004h
#define _PORTA_5         	 PORTA, 005h
#define _PORTA_6         	 PORTA, 006h
#define _PORTA_7         	 PORTA, 007h
#define _PORTB_0         	 PORTB, 000h
#define _PORTB_1         	 PORTB, 001h
#define _PORTB_2         	 PORTB, 002h
#define _PORTB_3         	 PORTB, 003h
#define _PORTB_4         	 PORTB, 004h
#define _PORTB_5         	 PORTB, 005h
#define _PIE1_6          	 PIE1, 006h
#define _PIR1_6          	 PIR1, 006h
#define _PCON_3          	 PCON, 003h
#define _PIR1_0          	 PIR1, 000h
#define _PIE1_0          	 PIE1, 000h
#define _PORTA_1         	 PORTA, 001h
#define _PORTA_2         	 PORTA, 002h
	INCLUDE	"PART_T~1.MAC"
	INCLUDE	"PBPPIC14.LIB"


	ASM?
 device intrc_osc_noclkout   ;rc_osc_(no)clkout,HS/XT/LP_osc,intrc_OSC_(NO)clkout,ec_osc 

	ENDASM?


	ASM?
 device wdt_off

	ENDASM?


	ASM?
 device lvp_off

	ENDASM?


	ASM?
 device pwrt_on

	ENDASM?


	ASM?
 device cpd_off

	ENDASM?


	ASM?
 device bod_off

	ENDASM?


	ASM?
 device mclr_off

	ENDASM?


	ASM?
 device PROTECT_OFF

	ENDASM?

	MOVE?CT	000h, _PIE1_6
	MOVE?CB	08Bh, VRCON
	PAUSE?C	00Ah
	MOVE?CB	085h, CMCON
	PAUSE?C	00Ah
	MOVE?CT	000h, _PIR1_6
	MOVE?CT	001h, _PIE1_6
	MOVE?CT	001h, _PCON_3
	MOVE?CB	00Fh, T1CON
	MOVE?CT	000h, _PIR1_0
	MOVE?CB	001h, TRISB
	MOVE?CB	0A6h, TRISA
	MOVE?CT	001h, _PIE1_0
	MOVE?CB	0D0h, INTCON
	MOVE?CT	000h, _PORTA_1
	MOVE?CT	000h, _PORTA_2
	MOVE?CT	000h, _PORTA_5
	MOVE?CT	000h, _PORTA_7
	MOVE?CT	000h, _PORTB_0
	MOVE?CW	000h, _Day
	MOVE?CB	00Ch, _Hour
	MOVE?CB	00Dh, _Minute
	MOVE?CT	001h, _Motor_selector
	MOVE?CT	000h, _Vip_Led
	MOVE?CT	000h, _Light_pin
	MOVE?CT	000h, _BatCharg_State
	GOTO?L	_Start

	ASM?

myint 


; comment the following if the device has grater than 2k of code space
;These are the working data saving process.

		movwf	wsave			; Save W
		swapf	STATUS, W		; Swap STATUS to W (swap avoids changing STATUS)
		clrf	STATUS			; Clear STATUS
		movwf	ssave			; Save swapped STATUS
		movf	PCLATH, W		; Move PCLATH to W
		movwf	psave			; Save PCLATH

;CHEECK THE RIGHT INTERRUPT , AND DECIDE WHAT TO DO
  
         BTFSC PIR1, TMR1IF          ; Timer1 overflow interrupt?
         GOTO TM1_INT                ;if yes do TM1_INT
         Goto Unsave                 ; NO, Then it is UNAUTORIZED INTERRUPT.EXIT


; Set the high register of Timer1 to cause an interrupt every
; 32768 counts (65536-32768=32768 or $8000). At 32.768khz, prescale
; set to 1, this equates to a tick every Second. 
         
TM1_INT  ;movlw	080h			    ; Prepare to set TMR1 high register
	     ;movwf	TMR1H      			; Set TMR1H to 80h
         incf	_Two_sec,F			; INCREMENT every two Second 
  	     bcf     PIR1, TMR1IF		; Clear interrupt flag
         Goto Unsave                ;unsave the working register and exit

;With comparator interrup,the CMCON will be read, the inerrupt will be disabled
;temporarly then 8 hour will be added to the Hour var and the result will be stored 
;in the Bat_hour var.  

                  
            
;These are the working data restoring process.
            
Unsave  movf    psave, W	    ; restore the state of everything
        movwf   PCLATH
        swapf   ssave, W
        movwf   STATUS
        swapf   wsave, F
        swapf   wsave, W
        retfie   			    ; Return from interrupt


	ENDASM?


	LABEL?L	_Start	
	GOSUB?L	_Get_time
	CMPNE?WCL	_Time, 00C0Fh, L00001
	MOVE?CT	001h, _Vip_Led
	PAUSE?C	01388h
	MOVE?CT	000h, _Vip_Led
	PAUSE?C	001F4h
	MOVE?CT	001h, _Vip_Led
	PAUSE?C	01388h
	MOVE?CT	000h, _Vip_Led
	LABEL?L	L00001	

	LABEL?L	_Get_time	
	MOVE?CT	000h, _PIE1_0
	DIV?BCW	_Two_Sec, 01Eh, T1
	ADD?BWB	_Minute, T1, _Minute
	MOD?BCB	_Two_Sec, 01Eh, _Two_Sec
	MOVE?CT	001h, _PIE1_0
	DIV?BCW	_Minute, 03Ch, T1
	ADD?BWB	_Hour, T1, _Hour
	MOD?BCB	_Minute, 03Ch, _Minute
	DIV?BCW	_Hour, 018h, T1
	ADD?WWW	_Day, T1, _Day
	MOD?BCB	_Hour, 018h, _Hour
	RETURN?	

	END
