
#define	EP0_BUFF_SIZE		8	; 8, 16, 32, or 64
#define	MAX_NUM_INT		1	; For tracking Alternate Setting
#define	MAX_EP_NUMBER		1	; UEP1
#define	NUM_CONFIGURATIONS	1
#define	NUM_INTERFACES		1

#define	MODE_PP			_PPBM0
#define	UCFG_VAL		_PUEN|_TRINT|_FS|MODE_PP	; Full-speed
;#define UCFG_VAL		_PUEN|_TRINT|MODE_PP		; Low-speed

;#define USE_SELF_POWER_SENSE_IO
;#define USE_USB_BUS_SENSE_IO

; DEVICE CLASS USAGE
#define USB_USE_HID

; HID
; Endpoints Allocation
#define	HID_INTF_ID			0x00
#define	HID_UEP				UEP1
#define	HID_BD_OUT			ep1Bo
#define	HID_INT_OUT_EP_SIZE	8
#define	HID_BD_IN			ep1Bi
#define	HID_INT_IN_EP_SIZE	8
#define	HID_NUM_OF_DSC		1



; ******************************************************************
; This table is polled by the host immediately after USB Reset has been released.
; This table defines the maximum packet size EP0 can take.
; See section 9.6.1 of the Rev 1.0 USB specification.
; These fields are application DEPENDENT. Modify these to meet
; your specifications.
; ******************************************************************
DeviceDescriptor
	retlw	0x12    	; Length of this descriptor
	retlw	DSC_DEV 	; Descriptor type - This is a DEVICE descriptor
	retlw	0x00		; USB Revision (low byte)
	retlw	0x02		;              (high byte)
	retlw	0x00		; Device class	- 0 means each interface operates independently
	retlw	0x00		; Device subclass
	retlw	0x00		; Device protocol
	retlw	0x08		; Max Packet Size - inited in UsbInit()
	retlw	0x81		; Vendor ID  (low byte)
	retlw	0x17		;            (high byte)
	retlw	0x6F		; Product ID (low byte)
	retlw	0x09		;            (high byte)
	retlw	0x00		; bcdDevice
	retlw	0x00
	retlw	0x01		; Manufacturer Index
	retlw	0x02		; Product Index
	retlw	0x00		; Serial Number Index
	retlw	0x01		; bNumConfigurations
EndDeviceDescriptor



; ******************************************************************
; This table is retrieved by the host after the address has been set.
; This table defines the configurations available for the device.
; See section 9.6.2 of the Rev 1.0 USB specification (page 184).
; These fields are application DEPENDENT. 
; Modify these to meet your specifications.
; ******************************************************************
; Configuration pointer table
USB_CD_Ptr
Configs
	db	low Config1, high Config1
	db	low Config1, high Config1

; Configuration Descriptor
Config1
	retlw	0x09		; bLength	Length of this descriptor
	retlw	0x02		; bDescType,	2 = CONFIGURATION
Config1Len
;	retlw	0x22		; Length of this configuration
;	retlw	0x00
	retlw	low ((EndConfig1-Config1)/2)	; Length of this configuration
	retlw	high ((EndConfig1-Config1)/2)	

	retlw	0x01		; Number of interfaces
	retlw	0x01		; Configuration Value
	retlw	0x04		; String index for this config = #01
	retlw	0x80		; Attributes (A0 = Bus Powered, Remote Wakeup)
	retlw	0x32		; Max power consumption (2x mA)
Interface1
	retlw	0x09		; length of descriptor
	retlw	DSC_INTF
	retlw	0x00		; number of interface, 0 based array
	retlw	0x00		; alternate setting
	retlw	0x01		; number of endpoints used in this interface
	retlw	0x03		; interface class - assigned by the USB
	retlw	0x00		; 1 = boot device
	retlw	0x00		; interface protocol - 1=keyboard
	retlw	0x05		; index to string descriptor that describes this interface
HIDDescriptor1
	retlw	0x09		; descriptor size (9 bytes)
	retlw	0x21		; descriptor type (HID)
	retlw	0x11		; HID class release number (1.11)
	retlw	0x01
	retlw	0x00		; Localized country code (none)
	retlw	0x01		; # of HID class descriptor to follow (1)
	retlw	0x22		; Report descriptor type (HID)
ReportDescriptor1Len
	retlw	low ((EndReportDescriptor1-ReportDescriptor1)/2)
	retlw	high ((EndReportDescriptor1-ReportDescriptor1)/2)
Endpoint1
	retlw	0x07		; length of descriptor
	retlw	DSC_EP
	retlw	0x81		; EP1, In
	retlw	0x03		; Interrupt
	retlw	0x01		; This should be the size of the endpoint buffer (low)
	retlw	0x00		; (high)
	retlw	0x0A		; polling interval (10ms)
EndConfig1



ReportDescriptor1
	; Report descriptor for media remote controller
	; --------------------------------------------------------------
	;  This descriptor defines a ONE byte report, of this bitmap
	;   bit
	;    0  : Prev Track
	;    1  : Next Track
	;    2  : Play/Pause
	;    3  : Stop
	;    4  : Eject
	;    5  : Mute
	;    6  : Volume Up
	;    7  : Volume Down
	

	retlw 0x05
	retlw 0x0C		; USAGE_PAGE (Consumer Devices)
	retlw 0x09
	retlw 0x01		; USAGE (Consumer Control)
	retlw 0xA1
	retlw 0x01		; COLLECTION (Application)
	retlw 0x15
	retlw 0x00		;   LOGICAL_MINIMUM (0)
	retlw 0x25
	retlw 0x01		;   LOGICAL_MAXIMUM (1)
	retlw 0x75
	retlw 0x01		;   REPORT_SIZE (1)    - each field occupies 1 bit
	retlw 0x95
	retlw 0x05		;   REPORT_COUNT (5)
	retlw 0x09
	retlw 0xb6		;   USAGE (Scan Previous Track)
	retlw 0x09
	retlw 0xB5		;   USAGE (Scan Next Track)
	retlw 0x09
	retlw 0xCD		;   USAGE (Play/Pause)
	retlw 0x09
	retlw 0xB7		;   USAGE (Stop)
	retlw 0x09
	retlw 0xB8		;   USAGE (Eject)
	retlw 0x09
	retlw 0xe2		;   USAGE (Mute)
	retlw 0x81
	retlw 0x06		;   INPUT (Data,Var,Rel)  - relative inputs
	retlw 0x95
	retlw 0x02		;   REPORT_COUNT (2)
	retlw 0x09
	retlw 0xe9		;   USAGE (Volume Up)
	retlw 0x09
	retlw 0xea		;   USAGE (Volume Down)
	retlw 0x81
	retlw 0x02		;   INPUT (Data,Var,Abs)  - absolute inputs
	retlw 0x95
	retlw 0x01		;   REPORT_COUNT (1)
	retlw 0x81
	retlw 0x01		;   INPUT (Cnst,Ary,Abs)
	retlw 0xc0		; END_COLLECTION

	retlw 0x75
	retlw 0x02		; REPORT_SIZE (2)
	retlw 0x95
	retlw 0x01		; REPORT_COUNT (1)
	retlw 0x15
	retlw 0x01		; LOGICAL_MINIMUM (1)
	retlw 0x25
	retlw 0x03		; LOGICAL_MAXIMUM (3)
	retlw 0x05

	retlw 0x0C		; USAGE_PAGE (Consumer Devices)
	retlw 0x19
	retlw 0xB0		; USAGE_MINIMUM (Play)
	retlw 0xA1
	retlw 0x02		; COLLECTION (Logical)
	retlw 0x05
	retlw 0x08		;	USAGE_PAGE (LEDs)
	retlw 0x05
	retlw 0x08		;	USAGE_PAGE (LEDs)
	retlw 0x09
	retlw 0x3C		;	USAGE (Usage Multi Mode Indicator)
	retlw 0xA1
	retlw 0x02		;	COLLECTION (Logical)
	retlw 0x09
	retlw 0x3D		;		USAGE (Indicator On)
	retlw 0x09
	retlw 0x3F		;		USAGE (Indicator Slow Blink)
	retlw 0x09
	retlw 0x41		;		USAGE (Indicator Off)
	retlw 0xB1
	retlw 0x40		;		FEATURE (Data, Array, Null)
	retlw 0xC0		;	END_COLLECTION
	retlw 0x09
	retlw 0x47		;	USAGE (Usage Indicator Color)
	retlw 0xA1
	retlw 0x02		;	COLLECTION (Logical)
	retlw 0x09
	retlw 0x48		;		USAGE (Red)
	retlw 0x09
	retlw 0x49		;		USAGE (Green)
	retlw 0x09
	retlw 0x4A		;		USAGE (Amber)
	retlw 0xB1
	retlw 0x40		;		FEATURE (Data, Array, Null)
	retlw 0xC0		;	END_COLLECTION
	retlw 0xC0		; END_COLLECTION

	retlw 0x05
	retlw 0x0C		; USAGE_PAGE (Consumer Devices)
	retlw 0x19
	retlw 0xB7		; USAGE_MINIMUM (Stop)
	retlw 0xA1
	retlw 0x02		; COLLECTION (Logical)
	retlw 0x05
	retlw 0x08		;	USAGE_PAGE (LEDs)
	retlw 0x09
	retlw 0x3C		;	USAGE (Usage Multi Mode Indicator)
	retlw 0xA1
	retlw 0x02		;	COLLECTION (Logical)
	retlw 0x09
	retlw 0x3D		;		USAGE (Indicator On)
	retlw 0x09
	retlw 0x3F		;		USAGE (Indicator Slow Blink)
	retlw 0x09
	retlw 0x41		;		USAGE (Indicator Off)
	retlw 0xB1
	retlw 0x40		;		FEATURE (Data, Array, Null)
	retlw 0xC0		;	END_COLLECTION
	retlw 0x09
	retlw 0x47		;	USAGE (Usage Indicator Color)
	retlw 0xA1
	retlw 0x02		;	COLLECTION (Logical)
	retlw 0x09
	retlw 0x48		;		USAGE (Red)
	retlw 0x09
	retlw 0x49		;		USAGE (Green)
	retlw 0x09
	retlw 0x4A		;		USAGE (Amber)
	retlw 0xB1
	retlw 0x40		;		FEATURE (Data, Array, Null)
	retlw 0xC0		;	END_COLLECTION
	retlw 0xC0		; END_COLLECTION

EndReportDescriptor1


langids
	retlw   low lang_1
	retlw   high lang_1

lang_1				; English
	retlw   low  String0	; LangIDs
	retlw   high String0
	retlw   low  String1_l1    
	retlw   high String1_l1
	retlw   low  String2_l1
	retlw   high String2_l1
	retlw   low  String3_l1
	retlw   high String3_l1
	retlw   low  String4_l1
	retlw   high String4_l1
	retlw   low  String5_l1
	retlw   high String5_l1


; String pointer table
USB_SD_Ptr
Strings
	db	low String0, high String0
	db	low String1_l1, high String1_l1
	db	low String2_l1, high String2_l1
	db	low String3_l1, high String3_l1
	db	low String4_l1, high String4_l1
	db	low String5_l1, high String5_l1

String0
	retlw	0x04		; Length of string
	retlw	DSC_STR		; Descriptor type 3
	retlw	0x09		; Language ID (as defined by MS 0x0409)
	retlw	0x04

; Company Name
String1_l1
	retlw	0x1E
	retlw	DSC_STR
	retlw   'M'
	retlw   0x00
	retlw   'C'
	retlw   0x00
	retlw   'S'
	retlw   0x00
	retlw   ' '
	retlw   0x00
	retlw   'C'
	retlw   0x00
	retlw   'o'
	retlw   0x00
	retlw   'n'
	retlw   0x00
	retlw   's'
	retlw   0x00
	retlw   'u'
	retlw   0x00
	retlw   'l'
	retlw   0x00
	retlw   't'
	retlw   0x00
	retlw   'i'
	retlw   0x00
	retlw   'n'
	retlw   0x00
	retlw   'g'
	retlw   0x00

; product name	
String2_l1
	retlw	0x1E
	retlw	DSC_STR
	retlw   'H'
	retlw   0x00
	retlw   'I'
	retlw   0x00
	retlw   'D'
	retlw   0x00
	retlw   ' '
	retlw   0x00
	retlw   'U'
	retlw   0x00
	retlw   'S'
	retlw   0x00
	retlw   'B'
	retlw   0x00
	retlw   ' '
	retlw   0x00
	retlw   'K'
	retlw   0x00
	retlw   'e'
	retlw   0x00
	retlw   'y'
	retlw   0x00
	retlw   'p'
	retlw   0x00
	retlw   'a'
	retlw   0x00
	retlw   'd'
	retlw   0x00

; serial number
String3_l1
	retlw	0x12	
	retlw	DSC_STR
	retlw   '0'
	retlw   0x00
	retlw   '0'
	retlw   0x00
	retlw   '0'
	retlw   0x00
	retlw   '0'
	retlw   0x00
	retlw   '0'
	retlw   0x00
	retlw   '0'
	retlw   0x00
	retlw   '0'
	retlw   0x00
	retlw   '0'
	retlw   0x00

String4_l1
	retlw   0x0A
	retlw   DSC_STR
	retlw   'C'
	retlw   0x00
	retlw   'f'
	retlw   0x00
	retlw	'g'
	retlw   0x00
	retlw	'1'
	retlw   0x00

String5_l1
	retlw   0x0C
	retlw   DSC_STR
	retlw   'E'
	retlw   0x00
	retlw   'P'
	retlw   0x00
	retlw   '1'
	retlw   0x00
	retlw   'I'
	retlw   0x00
	retlw   'n'
	retlw   0x00

String6_l1
