;******************************************************************
; Ethernet MINI DRIVER for PIC BASIC PRO 
; Author: Peter Best and Fred Eady
; Version: 1.0
; Date: 08/22/07
; Description: NUTS & VOLTS VERSION 1.0
;
; THESE ARE BASIC DRIVER ROUTINES AND ARE NOT INTENDED TO BE USED IN
; A PRODUCTION ENVIRONMENT. EDTP OFFERS THESE DRIVER ROUTINES AS-IS
; AND IS NOT RESPONSIBLE FOR ANY MISUSE OR MISAPPLICATION OF THIS 
; CODE.
;
; 7/24/2007		FE/PB Brought up ARP,ICMP and UDP for EDTP test panel
; 8/22/2007		FE    Brought up DHCP
; 10/25/2007	FE	  Brought up TCP and HTTP
;******************************************************************

include "mini.inc"
http_ok_msg:
@ da "HTTP/1.1 200 OK \r\n Content-Type: text/html\r\n\r\n<html><head><title> NUTS AND VOLTS </title></head><body><b><H2>PBPL IS ON THE NET!</H2></b></body></html>",0
telnet_banner:
@ da "EDTP 67J60 PBPL Telnet Driver> ",0
'------------GetAddress Macro - Location insensitive -------------------------
ASM
GetAddress macro Label, Wout       ; Returns the Address of a Label as a Word
    CHK?RP Wout
    movlw low Label
    movwf Wout
    movlw High Label
    movwf Wout + 1
	endm
ENDASM

;******************************************************************
;*	Port Definitions
;*   This address is used by TCP and the Telnet function.
;*   This can be changed to any valid port number as long as
;*   you modify your code to recognize the new port number.
;******************************************************************
MY_PORT_ADDRESS      	CON	$4EEA  ; 20202 DECIMAL
MCHP_UDP_PORT_ADDRESS	CON $765F  ;30303 DECIMAL
WEB_SVR_ADDRESS			CON $0050  ;80 DECIMAL
;******************************************************************
;*	GENERAL GLOBAL VARIABLES
;******************************************************************
tx_cnt			var word
tx_end			var word
tx_status		var byte[6]
hdrlen			var word
hdr_chksum		var long
chksum16		var word
acc3			var word
acc2			var word
acc1			var word
acc0			var word
arg3			var byte
arg2			var byte
arg1			var byte
arg0			var byte
i16				var word
i8				var byte
j8				var byte
data8			var byte
data16			var word
data_H			var byte
data_L			var byte
rgstr			var byte
low_byte		var byte
high_byte		var byte
temp			var byte
offsetval		var word
chksum_lo		var word
chksum_hi		var word
msgtype			var byte
msglen			var byte
binarynumber	var word
ptr				var word
packetptr		var word
b2a				var byte
scratch8		var byte
scratchpad		var byte[16]
portaddr		var word
flashaddr		var word
flashchar		var byte
forever 		con 1
;******************************************************************
;*	Flags
;******************************************************************
tcpflags 	var byte
bsynflag 	var tcpflags.0 
bfinflag	var tcpflags.1
bentryflag	var tcpflags.2
barpflag	var tcpflags.3
bhexflag	var tcpflags.4
bhttpflag	var tcpflags.5

dhcpflags var byte
bbound		var	dhcpflags.0  
bofferrec	var dhcpflags.1  
bdone		var dhcpflags.2
btrashit	var dhcpflags.3
bnewdhcppkt	var dhcpflags.4
bleaseflag	var dhcpflags.5
;******************************************************************
;*	FRAME HANDLER VARIABLES
;******************************************************************
bufferptr		var word
txlen			var word	
rxlen			var word
new_rdptr 		var word
;******************************************************************
;*	HTTP DEFINITIONS
;******************************************************************
i_http			var word
http_temp		var byte[6]
;******************************************************************
;*	ARP DEFINITIONS
;******************************************************************
i_arp			var word
;******************************************************************
;*	ICMP DEFINITIONS
;******************************************************************
i_icmp			var word
;******************************************************************
;*	UDP DEFINITIONS
;******************************************************************
i_udp			var word
;******************************************************************
;*	TCP DEFINITIONS
;******************************************************************
i_tcp			var word
tcplen			var word
tcpdatalen_in	var word
tcpdatalen_out	var word
my_seqnum		var long
client_seqnum	var long
incoming_ack	var long
expected_ack	var long
aux_data		var byte[16]
ISN				var word
ip_packet_len	var word
;******************************************************************
;*	DHCP Definitions
;******************************************************************
i_dhcp			var word
dhcpmsgchar 	var byte
dhcpreturncode 	var	byte
dhcpmsgtype		var byte
leasetime 		var word
lease_timer 	var word

DHCP_CLIENT_PORT					CON	$44
DHCP_SERVER_PORT					CON	$43

BOOT_REQUEST    					CON	$01
BOOT_REPLY      					CON	$02
HW_TYPE         					CON	$01
HW_TYPE_LEN							CON	$06

DHCP_MESSAGE_TYPE					CON	$35
DHCP_MESSAGE_TYPE_LEN				CON	$01

DHCP_UNKNOWN_MESSAGE				CON	$00

DHCP_DISCOVER_MESSAGE           	CON	$01
DHCP_OFFER_MESSAGE					CON	$02
DHCP_REQUEST_MESSAGE				CON	$03
DHCP_DECLINE_MESSAGE 				CON	$04
DHCP_ACK_MESSAGE					CON	$05
DHCP_NAK_MESSAGE					CON	$06
DHCP_RELEASE_MESSAGE            	CON	$07

DHCP_SERVER_IDENTIFIER          	CON	$36
DHCP_SERVER_IDENTIFIER_LEN      	CON	$04

DHCP_PARAM_REQUEST_LIST         	CON	$37
DHCP_PARAM_REQUEST_LIST_LEN     	CON	$02
DHCP_PARAM_REQUEST_IP_ADDRESS       CON	$32
DHCP_PARAM_REQUEST_IP_ADDRESS_LEN   CON	$04
DHCP_SUBNET_MASK					CON	$01
DHCP_ROUTER     					CON	$03
DHCP_IP_LEASE_TIME              	CON	$33
DHCP_END_OPTION 					CON	$FF
;******************************************************************
;*	DHCP STATES
;******************************************************************
DHCPSTATE 		var	byte
DHCP_ENTRY		con $01					
DHCP_INIT		con $02					
DHCP_WAIT		con $03
DHCP_BROADCAST	con $04
DHCP_DISCOVER	con $05
DHCP_REQUEST	con $06
DHCP_BIND		con $07
DHCP_BOUND		con $08
DHCP_DISABLED	con $09
;******************************************************************
;*	ETHERNET BUFFER DEFINITIONS 
;******************************************************************
MAXFRAME		CON	1518
TX_BUFFER_SIZE	CON	1518
TXEND			CON TX_BUFFER_SIZE + 8
TXSTART			CON	8192 - TXEND
RXSTART			CON	$0000
RXSTOPMOD		CON TXSTART - 2
RXSTOP			CON	RXSTOPMOD | $0001
RXSIZEMOD		CON	RXSTART + 1
RXSIZE			CON	RXSTOP-RXSIZEMOD
;******************************************************************
;*	IP ADDRESS DEFINITION
;*   These are the default Ethernet Module IP addresses.
;*   You may change these to any valid aDEFINEress.
;******************************************************************
ipaddrascii 				var byte[3]
ipaddrc  					var byte[4]
ipaddrc[0] = 192
ipaddrc[1] = 168
ipaddrc[2] = 0
ipaddrc[3] = 150
tempipaddrc 				var byte[4]
svridc 						var byte[4]
gwayipaddrc 				var byte[4]
tempgwayipaddrc 			var byte[4]
subnetmaskc 				var byte[4]
tempsubnetmaskc 			var byte[4]
tempsvridc 					var byte[4]
templeasetimec 				var byte[4]
broadcastipaddrc  			var byte[4]
broadcastipaddrc[0] = 192
broadcastipaddrc[1] = 168
broadcastipaddrc[2] = 0
broadcastipaddrc[3] = 255
;******************************************************************
;*	HARDWARE (MAC) ADDRESS DEFINITION
;*   This is the default Ethernet Module hardware address.
;*   You may change this to any valid address.
;******************************************************************
svrmacaddrc		var byte[6]
macaddrc		var	byte[6]
remotemacaddrc	var byte[6] 
macaddrc[0] = 0
macaddrc[1] = 0
macaddrc[2] = "E"
macaddrc[3] = "D"
macaddrc[4] = "T"
macaddrc[5] = "P"
;******************************************************************
;*	Receive Ring Buffer Header Layout
;*   This is the 6-byte header that resides infront of the
;*   data packet in the receive buffer.
;******************************************************************
tx_control_byte	   	CON	$0E
packetheader	var byte[6]
nextpacket_low    	CON	$00
nextpacket_high   	CON	$01
rec_bytecnt_low    	CON	$02
rec_bytecnt_high   	CON	$03
rec_status_low 	   	CON	$04
rec_status_high	   	CON	$05
;******************************************************************
;*	Ethernet Header Layout
;******************************************************************
;udp_packet	var byte[100]                   
packet		var byte[1500]                
enetpacketDest0	   	CON	$00  ;destination mac address
enetpacketDest1	   	CON	$01
enetpacketDest2	   	CON	$02
enetpacketDest3	   	CON	$03
enetpacketDest4	   	CON	$04
enetpacketDest5	   	CON	$05
enetpacketSrc0	   	CON	$06  ;source mac address
enetpacketSrc1	   	CON	$07
enetpacketSrc2	   	CON	$08
enetpacketSrc3	   	CON	$09
enetpacketSrc4	   	CON	$0A
enetpacketSrc5	   	CON	$0B
enetpacketType0	   	CON	$0C  ;type/length field
enetpacketType1	   	CON	$0D
enetpacketData     	CON	$0E  ;IP data area begins here
;******************************************************************
;*	ARP Layout
;******************************************************************
arp_hwtype		   CON	$0E
arp_prtype		   CON	$10
arp_hwlen		   CON	$12
arp_prlen		   CON	$13
arp_op			   CON	$14	  ;arp request or response
arp_shaddr		   CON	$16   ;arp source mac address
arp_sipaddr		   CON	$1C   ;arp source ip address
arp_thaddr		   CON	$20   ;arp target mac address
arp_tipaddr		   CON	$26   ;arp target ip address
;******************************************************************
;*	IP Header Layout
;******************************************************************
ip_vers_len		   CON	$0E	;IP version and header length 1a19
ip_tos			   CON	$0F	;IP type of service
ip_pktlen		   CON	$10	;packet length
ip_id			   CON	$12	;datagram id
ip_frag_offset	   CON	$14	;fragment offset
ip_ttl			   CON	$16	;time to live
ip_proto		   CON	$17	;protocol (ICMP=1, TCP=6, UDP=11)
ip_hdr_cksum	   CON	$18	;header checksum 1a23
ip_srcaddr		   CON	$1A	;IP address of source
ip_destaddr		   CON	$1E	;IP addess of destination
ip_data			   CON	$22	;IP data area
;******************************************************************
;*	TCP Header Layout
;******************************************************************
TCP_srcport		   CON	$22	;TCP source port
TCP_destport   	   CON	$24	;TCP destination port
TCP_seqnum  	   CON	$26	;sequence number
TCP_acknum	       CON	$2A	;acknowledgement number
TCP_hdrflags	   CON	$2E	;4-bit header len and flags
TCP_window		   CON	$30	;window size
TCP_cksum		   CON	$32	;TCP checksum
TCP_urgentptr      CON	$34	;urgent pointer
TCP_data           CON	$36 ;option/data
;******************************************************************
;*	TCP Flags
;*   IN flags represent incoming bits
;*   OUT flags represent outgoing bits
;******************************************************************
FIN_IN             CON  $01
SYN_IN             CON  $02
RST_IN             CON  $04
PSH_IN             CON  $08
ACK_IN             CON  $10
URG_IN             CON  $20
FIN_OUT            CON  $01 
SYN_OUT            CON  $02 
RST_OUT            CON  $04 
PSH_OUT            CON  $08 
ACK_OUT            CON  $10 
URG_OUT            CON  $20
;******************************************************************
;*	IP Protocol Types
;******************************************************************
PROT_ICMP			   CON $01
PROT_TCP			   CON $06
PROT_UDP			   CON $11
;******************************************************************
;*	ICMP Header
;******************************************************************
ICMP_type			   CON ip_data
ICMP_code			   CON ICMP_type+1
ICMP_cksum			   CON ICMP_code+1
ICMP_id				   CON ICMP_cksum+2
ICMP_seqnum			   CON ICMP_id+2
ICMP_data              CON ICMP_seqnum+2
;******************************************************************
;*	UDP Header
;******************************************************************
UDP_srcport			   CON ip_data
UDP_destport		   CON UDP_srcport+2
UDP_len				   CON UDP_destport+2
UDP_cksum			   CON UDP_len+2
UDP_data			   CON UDP_cksum+2
;******************************************************************
;*	DHCP Message
;******************************************************************
DHCP_op					CON  UDP_data
DHCP_htype				CON  DHCP_op+1
DHCP_hlen				CON  DHCP_htype+1
DHCP_hops				CON  DHCP_hlen+1
DHCP_xid				CON  DHCP_hops+1
DHCP_secs				CON  DHCP_xid+4
DHCP_flags				CON  DHCP_secs+2
DHCP_ciaddr				CON  DHCP_flags+2
DHCP_yiaddr				CON  DHCP_ciaddr+4
DHCP_siaddr				CON  DHCP_yiaddr+4
DHCP_giaddr				CON  DHCP_siaddr+4
DHCP_chaddr				CON  DHCP_giaddr+4
DHCP_sname				CON  DHCP_chaddr+16
DHCP_file				CON  DHCP_sname+64
DHCP_options			CON  DHCP_file+128
DHCP_message_end		CON  DHCP_options+312

LED0			var LATF.1
;TIMER VARIABLES
milliseconds	var word
msecs_timer 	var word
clock_timer 	var word
hours			var byte
mins			var byte
secs			var byte
secs_timer		var byte
;EUSART VARIABLES
tmphead			var byte
tmptail			var byte
returncode		var word
recvchar_ret	var byte
sendchar_ret	var byte
CharInQueue_ret	var byte
;*****************************************************************
;*	USART Definitions
;******************************************************************
BAUD	CON		57600		;desired baud rate
DEFINE OSC		25			;oscillator frequency
DIVIDER CON 	43	;81			;((unsigned int)(FOSC/(16 * BAUD) -1))
;1,2,4,8,16,32,64,128 or 256 bytes 
USART_RX_BUFFER_SIZE  CON 256      
USART_RX_BUFFER_MASK CON  USART_RX_BUFFER_SIZE - 1 
; 1,2,4,8,16,32,64,128 or 256 bytes 
USART_TX_BUFFER_SIZE  CON 256      
USART_TX_BUFFER_MASK CON USART_TX_BUFFER_SIZE - 1 

USART_RxBuf		var	byte[USART_RX_BUFFER_SIZE]
USART_TxBuf		var byte[USART_TX_BUFFER_SIZE]
USART_TxHead	var byte
USART_TxTail	var byte
USART_RxHead	var byte
USART_RxTail	var byte
;******************************************************************
;*	MAIN PROGRAM
;******************************************************************
on interrupt goto int_handler

	OSCTUNE = $40
;******************************************************************
;*	CONFIGURE AND START TIMER2
;* SET TO OVERFLOW EVERY 1mS
;******************************************************************
 	hours = 12
	mins = $00 
	secs = $00 
  	milliseconds = 0
	T2CON = $79 
	PR2 = $A3 		
	TMR2ON = 1
	TMR2IE = 1
	gosub init_EUSART
	gosub init_IO
	gosub init_67J60
	DHCPSTATE = DHCP_ENTRY
	gosub init_DHCP

	while forever
	 if (EPKTCNT != 0)  then
		gosub get_frame
	 endif
	 gosub dhcp_state_engine
	wend
end
;******************************************************************
;*	INTERRUPT HANDLER
;******************************************************************
	Disable
int_handler:
	if((TMR2IF == 1) && (TMR2IE == 1)) then
   		TMR2IF = 0
        msecs_timer = msecs_timer + 1
		clock_timer = clock_timer + 1
 
	if(1000 == clock_timer) then
			clock_timer = 0
			secs = secs + 1
            secs_timer = secs_timer + 1
		    bleaseflag = 1
			toggle LED0
	endif
  
	if(60 == secs) then
			secs = 0
		 	mins = mins + 1
	endif

	if(60 == mins) then
			mins = 0
			hours = hours + 1
	endif

	if(24 == hours) then
		    hours = 0
	endif	
endif
	
  	if(RC1IF == 1) then
   		data8 = RCREG1                   ; read the received data 
                                		; calculate buffer index 
   		tmphead = ( USART_RxHead + 1 ) & USART_RX_BUFFER_MASK
   		USART_RxHead = tmphead        ; store new index 
  	endif

   	if ( tmphead == USART_RxTail ) then
     ; ERROR! Receive buffer overflow 
	endif                                
   USART_RxBuf[tmphead] = data8   ; store received data in buffer 
  
  if(TRMT == 1) then
                                ; check if all data is transmitted  
	if ( USART_TxHead != USART_TxTail ) then
                                ; calculate buffer index  
     tmptail = ( USART_TxTail + 1 ) & USART_TX_BUFFER_MASK
     USART_TxTail = tmptail      ; store new index  

    TXREG1 = USART_TxBuf[tmptail]  ; start transmition  
   
   	else
   
     TX1IE = 0         ; disable TX interrupt  
	endif
  endif
	resume
	enable

;******************************************************************
;*	Init USART Function
;******************************************************************
init_EUSART:
  	BRGH = 1 
  	SYNC = 0
  	SPBRG1 = DIVIDER 	;load baud rate divisor	
  	TRISC7 = 1 			;receive pin
  	TRISC6 = 1 			;transmit pin
  	TXSTA1 = $04 		;high speed baud rate
  	RCSTA1 = $80 		;enable serial port and serial port pins

  
  	USART_RxTail = $00 	;flush receive buffer 
  	USART_RxHead = $00 
  	USART_TxTail = $00 	;flush transmit buffer
  	USART_TxHead = $00 
  	RC1IP = 1 			;receive interrupt = high priority
  	TX1IP = 1 			;transmit interrupt = high priority
  	RC1IE = 1 			;enable receive interrupt
  	PEIE = 1 				;enable all unmasked peripheral interrupts
  	GIE = 1 				;enable all unmasked interrupts
  	CREN = 1 				;enable USART1 receiver
  	TX1IE = 0 			;disable USART1 transmit interrupt
  	TXEN = 1 				;transmitter enabled
  	SPEN = 1 
	hserout[13,10]
	hserout[13,10,"EUSART Initialized"]
	pause 10
	return
recvchar:
  ; wait for incomming data
  
	while  USART_RxHead == USART_RxTail  
	wend
                                ; calculate buffer index  
  	tmptail = ( USART_RxTail + 1 ) & USART_RX_BUFFER_MASK
  	USART_RxTail = tmptail        ; store new index  
  	recvchar_ret = USART_RxBuf[tmptail]   ; return data  
  	return 

sendchar:
    ; calculate buffer index 
  	tmphead = ( USART_TxHead + 1 ) & USART_TX_BUFFER_MASK
                                ; wait for free space in buffer 
	while  tmphead == USART_TxTail  
	wend
                                ; store data in buffer 
  	USART_TxBuf[tmphead] = data8;
  	USART_TxHead = tmphead;        ; store new index 

  	TX1IE = 1            ; enable TX interrupt 
  	sendchar_ret = data8
  	return 

CharInQueue:
  	if(USART_RxHead != USART_RxTail) then
  		CharInQueue_ret = 1
  	else
  		CharInQueue_ret = 0
  	endif
  	return 
init_IO:
	TRISA = %11111100 
	TRISB = %11111111 
	TRISC = %01010111 
	TRISD = %11111011 
	TRISF = $00 
	LATF = $FF 
	dhcpflags = 0
	tcpflags = 0
	hserout[13,10,"I/O Initialized"]
	pause 10
	return
init_67J60:
	;Enable Ethernet
	ETHEN = 1 

	while !PHYRDY
	wend

	msecs_timer = 0 
 	while msecs_timer < 2
@	nop
 	wend
 
	LATF = $00 
	
	RXEN = 0 
   	TXRTS = 0 

	packetheader[nextpacket_low] = RXSTART & $00FF 			;LOW_BYTE(RXSTART) 
	packetheader[nextpacket_high] = (RXSTART & $FF00) >> 8 	;HIGH_BYTE(RXSTART) 

	ERXSTL = RXSTART & $00FF		;LOW_BYTE(RXSTART) 
	ERXSTH = (RXSTART & $FF00) >> 8 	;HIGH_BYTE(RXSTART) 
	ERXRDPTL = RXSTOP & $00FF 		;LOW_BYTE(RXSTOP) 
	ERXRDPTH = (RXSTOP & $FF00) >> 8 ;HIGH_BYTE(RXSTOP) 
	ERXNDL = RXSTOP & $00FF 		;LOW_BYTE(RXSTOP) 
	ERXNDH = (RXSTOP & $FF00) >> 8 	;HIGH_BYTE(RXSTOP) 
	ETXSTL =  TXSTART & $00FF 		;LOW_BYTE(TXSTART) 
	ETXSTH =  (TXSTART & $FF00) >> 8 ;HIGH_BYTE(TXSTART) 

	MACON1 =  MACON1_TXPAUS | MACON1_RXPAUS | MACON1_MARXEN 
@	nop
	; Pad packets to 60 bytes, add CRC, and check Type/Length field
	MACON3 =  MACON3_PADCFG0 | MACON3_TXCRCEN | MACON3_FRMLNEN 
@	nop
    ; Allow infinite deferals if the medium is continuously busy 
    ; (do not time out a transmission if the half duplex medium is 
    ; completely saturated with other people's data)
    MACON4 =  MACON4_DEFER 
@	nop

	MAIPGL =  $12 
@	nop
	MAIPGH =  $0C 
@	nop
	MAMXFLL =  MAXFRAME & $00FF 		;LOW_BYTE(MAXFRAME) 	
@	nop
	MAMXFLH =  (MAXFRAME & $FF00) >> 8 	;HIGH_BYTE(MAXFRAME) 
@	nop

    MAADR1 =  macaddrc[0] 
@	nop
    MAADR2 =  macaddrc[1] 
@	nop
    MAADR3 =  macaddrc[2] 
@	nop
   MAADR4 =  macaddrc[3] 
@	nop
    MAADR5 =  macaddrc[4] 
@	nop
    MAADR6 =  macaddrc[5] 
@	nop

	rgstr = PHCON2
	data16 = $0110
	gosub wr_phy		;wr_phy(PHCON2, $0110) 
	rgstr = PHCON1
	data16 = $0000
	gosub wr_phy		;wr_phy(PHCON1,$0000) 
	rgstr = PHLCON
	data16 = $0472
	gosub wr_phy		;wr_phy(PHLCON, $0472) 	

	; Set the back-to-back inter-packet gap time to IEEE specified 
	; requirements.  The meaning of the MABBIPG value changes with the duplex
	; state, so it must be updated in this function.
	; In full duplex, $15 represents 9.6us  $12 is 9.6us in half duplex
	
	MABBIPG = $12 	

	; Enable packet reception
	RXEN =1 
    EIE = $00 
    
;	FOR TEST ONLY
;	rgstr = PHCON2 
;	gosub rd_phy
;@	nop 
;	rgstr = PHCON1 
;	gosub rd_phy
;@	nop 
;	rgstr = PHLCON 
;	gosub rd_phy
;@	nop 
   
	hserout[13,10,"Ethernet Initialized",13,10] 
	RETURN
;******************************************************************
;*	rd_phy
;******************************************************************
rd_phy:
	; Set the right address and start the register read operation
	MIREGADR = rgstr
@	nop
	MICMD = MICMD_MIIRD
@	nop
	; Loop to wait until the PHY register has been read through the MII
	while BUSY
	wend
	; Stop reading
	MICMD = $00
@	nop
	; Obtain results and return
	low_byte = MIRDL
	high_byte = MIRDH
	returncode = (high_byte << 8) | low_byte
	return
;******************************************************************
;*	wr_phy
;******************************************************************
wr_phy:
	; Write the register address
	MIREGADR = rgstr;
@	nop
	; Write the data
	; Order is important: write low byte first, high byte last
	MIWRL = data16 & $00FF 	;LOW_BYTE(data)
@	nop
	MIWRH = (data16 & $FF00) >> 8	;HIGH_BYTE(data 
@	nop
	; Wait until the PHY register has been written
	while BUSY
	wend
	return
;******************************************************************
;*	Get A Frame From the Buffer
;*   This routine removes an Ethernet frame from the receive buffer
;*   ring.
;******************************************************************
get_frame:

	;banksel(ERDPTL 
	ERDPTL = packetheader[nextpacket_low]
	ERDPTH = packetheader[nextpacket_high]

	bufferptr = -1
	i16 = 0
	while i16 < 6
		bufferptr = bufferptr + 1
		i16 = i16 + 1
		packetheader[bufferptr] = EDATA 
	wend
 
	rxlen = (packetheader[rec_bytecnt_high] << 8) | packetheader[rec_bytecnt_low]
	
	bufferptr = -1
	i16 = rxlen 
	while i16
		bufferptr = bufferptr + 1
		i16 = i16 - 1
		packet[bufferptr] = EDATA 
	wend
	
	new_rdptr = ((packetheader[nextpacket_high] << 8) | packetheader[nextpacket_low]) - 1
	if ((new_rdptr > 8191) || (new_rdptr > RXSTOP)) then
		new_rdptr = RXSTOP
	endif
	 
	ECON2 = ECON2 | ECON2_PKTDEC
	
	;banksel(ERXRDPTL 
	ERXRDPTL = new_rdptr & $00FF		
	ERXRDPTH = (new_rdptr & $FF00) >> 8	

   	;process an incoming ARP request packet
   	if ((packet[enetpacketType0] == $08) && (packet[enetpacketType1] == $06))  then
	   if ((packet[arp_hwtype+1] == $01) 		&&_
       	(packet[arp_prtype] == $08) 			&&_ 
	   	(packet[arp_prtype+1] == $00) 		&&_
       	(packet[arp_hwlen] == $06) 			&&_ 
	   	(packet[arp_prlen] == $04) 			&&_
       	(packet[arp_tipaddr]   == ipaddrc[0]) &&_
       	(packet[arp_tipaddr+1] == ipaddrc[1]) &&_
       	(packet[arp_tipaddr+2] == ipaddrc[2]) &&_
       	(packet[arp_tipaddr+3] == ipaddrc[3])) then
		select case (packet[arp_op+1])
			case $01
				gosub arp_reply
			case $02
       			for i8 = 0 to 5
		 		 remotemacaddrc[i8] = packet[arp_shaddr+i8] 
				next i8
				barpflag = 1
		end select		
	   endif	
	 endif

   	;process an IP packet
   		if ((packet[enetpacketType0] == $08)      &&_ 
		  (packet[enetpacketType1] == $00) 	   	 &&_
          (packet[ip_destaddr]   == ipaddrc[0])  &&_
          (packet[ip_destaddr+1] == ipaddrc[1])  &&_
          (packet[ip_destaddr+2] == ipaddrc[2])  &&_
          (packet[ip_destaddr+3] == ipaddrc[3]))  then
      	select case packet[ip_proto]
	      case PROT_ICMP
	      	gosub icmp
	      case PROT_UDP
    	  	if (packet[UDP_srcport] == DHCP_SERVER_PORT) then
    	  	 	gosub dhcp_state_engine
    	  	else
    	  	 	gosub udp
    	  	endif
    	  case PROT_TCP
    	  	 gosub tcp
		 end select
		endif
  	;process a DHCP message
   	 	if ((packet[enetpacketType0] == $08)	&&_ 
		  (packet[enetpacketType1] == $00) 	&&_
          (packet[ip_destaddr]   == $FF)  	&&_
          (packet[ip_destaddr+1] == $FF)  	&&_
          (packet[ip_destaddr+2] == $FF)  	&&_
          (packet[ip_destaddr+3] == $FF)	&&_
          (packet[ip_proto] == PROT_UDP)) then

		  bnewdhcppkt = 1
    	  gosub dhcp_state_engine
	 	endif
	return

disable_TMR2int:
  	TMR2IE = 0
return
enable_TMR2int:
	TMR2IE = 1
return
disable_TMR3int:
	TMR3IE = 0
return
enable_TMR3int:
	TMR3IE = 1
return

enable_GLOBALint:
	IPEN = 0
	GIE = 1				
    PEIE = 1
return
disable_GLOBALint:
	IPEN = 0
	GIE = 0				
    PEIE = 0
return

arp_reply:
;******************************************************************
;*	Perform ARP Response
;*   This routine supplies a requesting computer with the
;*   Ethernet modules's MAC (hardware) address.
;******************************************************************

	tx_end = TXSTART 
   ;load beginning page for transmit buffer
    ;banksel(EWRPTL 
	EWRPTL = TXSTART & $00FF
	EWRPTH = (TXSTART & $FF00) >> 8

   ;write control byte
	EDATA = tx_control_byte 
	tx_end = tx_end + 1

   ;write destination MAC address
   for i_arp = 0 to 5
      EDATA = packet[enetpacketSrc0+i_arp] 
	  tx_end = tx_end + 1
	next i_arp
	  
   ;write source MAC address
   for i_arp = 0 to 5
      EDATA = macaddrc[i_arp] 
	  tx_end = tx_end + 1
	next i_arp

   ;write typelen hwtype prtype hwlen prlen op:
   ;addr = &packet[enetpacketType0]
   packet[arp_op+1] = $02
   for i_arp = 0 to 9
      EDATA = packet[enetpacketType0+i_arp] 
	  tx_end = tx_end + 1
	next i_arp
   ;write ethernet module MAC address
   for i_arp = 0 to 5
      EDATA = macaddrc[i_arp] 
	  tx_end = tx_end + 1
	next i_arp
   ;write ethernet module IP address
      for i_arp = 0 to 3
      	 EDATA = ipaddrc[i_arp] 
	     tx_end = tx_end + 1
	next i_arp

   ;write remote MAC address
   for i_arp = 0 to 5
      EDATA = packet[enetpacketSrc0+i_arp] 
	  tx_end = tx_end + 1
	next i_arp

   ;write remote IP address
   for i_arp = 0 to 3
      EDATA = packet[arp_sipaddr+i_arp] 
	  tx_end = tx_end + 1
	next i_arp
	;banksel(ETXNDL 
	ETXNDL = tx_end & $00FF 
	ETXNDH = (tx_end & $FF00) >> 8 

   ;send the contents of the transmit buffer onto the network
	if (TXERIF) then
	 TXERIF = 0 
     TXRST = 1 
   	 TXRST = 0 
	endif
	TXIF = 0 
   	TXRTS = 1 
	;while(1 == (ECON1 & ECON1_TXRTS))
	while ECON1 & ECON1_TXRTS
	wend
return

icmp:
;******************************************************************
;*	Perform ICMP Function
;*   This routine responds to a ping.
;******************************************************************
   ;set echo reply
   packet[ICMP_type]=$00
   packet[ICMP_code]=$00

   ;clear the ICMP checksum
   packet[ICMP_cksum]=$00
   packet[ICMP_cksum+1]=$00

   ;setup the IP header
   gosub setipaddrs

   hdrlen = ((packet[ip_pktlen] << 8) + packet[ip_pktlen+1]) - ((packet[ip_vers_len] & $0F) * 4)
   ;addr = &packet[ICMP_type]
	i_icmp = 0
	gosub clrcrc
	while(hdrlen > 1)
		arg1=packet[ICMP_type+i_icmp]
		i_icmp = i_icmp + 1
		arg0=packet[ICMP_type+i_icmp]
		i_icmp = i_icmp + 1
		acc0 = acc0 + arg0
		gosub ripple_crc
		acc1 = acc1 + arg1
		gosub ripple_crc
		hdrlen = hdrlen - 2
	wend
      if(hdrlen > 0) then
        arg1=packet[ICMP_type+i_icmp]
        arg0=$00
		acc0 = acc0 + arg0
		gosub ripple_crc
		acc1 = acc1 + arg1
		gosub ripple_crc
	 endif
		acc0 = acc0 + acc2
		gosub ripple_crc
		acc1 = acc1 + acc3
		gosub ripple_crc
   chksum16= ~((acc1 << 8) + acc0) 
   packet[ICMP_cksum] = (chksum16 & $FF00) >> 8
   packet[ICMP_cksum+1] = chksum16 & $00FF
   ;send the ICMP packet along on its way
	tx_end = TXSTART
   ;load beginning page for transmit buffer
    ;banksel(EWRPTL) 
	EWRPTL = TXSTART & $00FF
	EWRPTH = (TXSTART & $FF00) >> 8

   ;write control byte
	EDATA = tx_control_byte
	tx_end = tx_end + 1

	tx_end = (tx_end) + (packetheader[rec_bytecnt_high] << 8) + (packetheader[rec_bytecnt_low] - 4) 
	;banksel(ETXNDL) 
	ETXNDL = tx_end & $00FF 
	ETXNDH = (tx_end & $FF00) >> 8 
	
	i_icmp = 0
	while(tx_end)
		EDATA = packet[0 + i_icmp]
		i_icmp = i_icmp + 1
		tx_end = tx_end - 1
	wend		

   ;send the contents of the transmit buffer onto the network
	if (TXERIF) then
	 TXERIF = 0 
     TXRST = 1 
   	 TXRST = 0 
	endif
	TXIF = 0
  	TXRTS = 1
	;while(1 == (ECON1 & ECON1_TXRTS))
	while ECON1 & ECON1_TXRTS
	wend
return
setipaddrs:
;******************************************************************
;*	SETIPADDRS
;*   This subroutine builds the IP header.
;******************************************************************
   ;move IP source address to destination address
   packet[ip_destaddr]=packet[ip_srcaddr]
   packet[ip_destaddr+1]=packet[ip_srcaddr+1]
   packet[ip_destaddr+2]=packet[ip_srcaddr+2]
   packet[ip_destaddr+3]=packet[ip_srcaddr+3]
   ;make ethernet module IP address source address
   packet[ip_srcaddr]=ipaddrc[0]
   packet[ip_srcaddr+1]=ipaddrc[1]
   packet[ip_srcaddr+2]=ipaddrc[2]
   packet[ip_srcaddr+3]=ipaddrc[3]
   ;move hardware source address to destinatin address
   packet[enetpacketDest0]=packet[enetpacketSrc0]
   packet[enetpacketDest1]=packet[enetpacketSrc1]
   packet[enetpacketDest2]=packet[enetpacketSrc2]
   packet[enetpacketDest3]=packet[enetpacketSrc3]
   packet[enetpacketDest4]=packet[enetpacketSrc4]
   packet[enetpacketDest5]=packet[enetpacketSrc5]
   ;make ethernet module mac address the source address
   packet[enetpacketSrc0]=macaddrc[0]
   packet[enetpacketSrc1]=macaddrc[1]
   packet[enetpacketSrc2]=macaddrc[2]
   packet[enetpacketSrc3]=macaddrc[3]
   packet[enetpacketSrc4]=macaddrc[4]
   packet[enetpacketSrc5]=macaddrc[5]

   ;calculate the IP header checksum
   packet[ip_hdr_cksum]=$00
   packet[ip_hdr_cksum+1]=$00

   hdrlen = (packet[ip_vers_len] & $0F) * 4
   ;addr = &packet[ip_vers_len]
	i16 = 0
	gosub clrcrc
	while(hdrlen > 1)
		arg1=packet[ip_vers_len+i16]
		i16 = i16 + 1
		arg0=packet[ip_vers_len+i16]
		i16 = i16 + 1
		acc0 = acc0 + arg0
		gosub ripple_crc
		acc1 = acc1 + arg1
		gosub ripple_crc
		hdrlen = hdrlen - 2
	wend
      if(hdrlen > 0) then
        arg1=packet[ip_vers_len+i16]
        arg0=$00
		acc0 = acc0 + arg0
		gosub ripple_crc
		acc1 = acc1 + arg1
		gosub ripple_crc
	 endif
		acc0 = acc0 + acc2
		gosub ripple_crc
		acc1 = acc1 + acc3
		gosub ripple_crc
   chksum16= ~((acc1 << 8) + acc0) 
   packet[ip_hdr_cksum] = (chksum16 & $FF00) >> 8
   packet[ip_hdr_cksum+1] = chksum16 & $00FF
return


udp:
;******************************************************************
;*	UDP Function
;*   This function uses a Visual Basic UDP program to echo the
;*   data back to the VB program .
;******************************************************************
 	
   ;port 7 is the well-known echo port
   if((packet[UDP_destport] == $00) && (packet[UDP_destport+1] ==$07)) then
      ;build the IP header
      gosub setipaddrs

      ;swap the UDP source and destination ports
      temp = packet[UDP_srcport]
      packet[UDP_srcport] = packet[UDP_destport]
      packet[UDP_destport] = temp 

      temp = packet[UDP_srcport+1]
      packet[UDP_srcport+1] = packet[UDP_destport+1]
      packet[UDP_destport+1] = temp 

      ;calculate the UDP checksum
      packet[UDP_cksum] = $00 
      packet[UDP_cksum+1] = $00 

      hdrlen = $08 
      ;addr = &packet[ip_srcaddr]
	i16 = 0
	gosub clrcrc
	while(hdrlen > 1)
		arg1=packet[ip_srcaddr+i16]
		i16 = i16 + 1
		arg0=packet[ip_srcaddr+i16]
		i16 = i16 + 1
		acc0 = acc0 + arg0
		gosub ripple_crc
		acc1 = acc1 + arg1
		gosub ripple_crc
		hdrlen = hdrlen - 2
	wend
      if(hdrlen > 0) then
        arg1=packet[ip_srcaddr+i16]
        arg0=$00
		acc0 = acc0 + arg0
		gosub ripple_crc
		acc1 = acc1 + arg1
		gosub ripple_crc
	 endif

		acc0 = acc0 + packet[ip_proto]
		gosub ripple_crc

		acc0 = acc0 + packet[UDP_len+1]
		gosub ripple_crc
		acc1 = acc1 + packet[UDP_len]
		gosub ripple_crc

	hdrlen = (packet[UDP_len] << 8) + packet[UDP_len+1]
	i16 = 0
	while(hdrlen > 1)
		arg1=packet[UDP_srcport+i16]
		i16 = i16 + 1
		arg0=packet[UDP_srcport+i16]
		i16 = i16 + 1
		acc0 = acc0 + arg0
		gosub ripple_crc
		acc1 = acc1 + arg1
		gosub ripple_crc
		hdrlen = hdrlen - 2
	wend
      if(hdrlen > 0) then
        arg1=packet[UDP_srcport+i16]
        arg0=$00
		acc0 = acc0 + arg0
		gosub ripple_crc
		acc1 = acc1 + arg1
		gosub ripple_crc
	 endif

		acc0 = acc0 + acc2
		gosub ripple_crc
		acc1 = acc1 + acc3
		gosub ripple_crc

   chksum16= ~((acc1 << 8) + acc0) 
   packet[UDP_cksum] = (chksum16 & $FF00) >> 8
   packet[UDP_cksum+1] = chksum16 & $00FF
      ;echo the incoming data back to the VB program
	tx_end = TXSTART 
   ;load beginning page for transmit buffer
    ;banksel(EWRPTL) 
	EWRPTL = TXSTART & $00FF
	EWRPTH = (TXSTART & $FF00) >> 8

   ;write control byte
	EDATA = tx_control_byte 
	tx_end = tx_end + 1

	tx_end = tx_end + (((packetheader[rec_bytecnt_high] << 8) + packetheader[rec_bytecnt_low]) - 4) 
	;banksel(ETXNDL) 
	ETXNDL = tx_end & $00FF 
	ETXNDH = (tx_end & $FF00) >> 8 

	i_udp = 0
	while(tx_end)
		EDATA = packet[0 + i_udp]
		i_udp = i_udp + 1
		tx_end = tx_end - 1
	wend		

   ;send the contents of the transmit buffer onto the network
	if (TXERIF) then
	 TXERIF = 0 
     TXRST = 1 
   	 TXRST = 0 
	endif
	TXIF = 0
  	TXRTS = 1
	;while(1 == (ECON1 & ECON1_TXRTS))
	while ECON1 & ECON1_TXRTS
	wend
	endif
return
;******************************************************************
;*	Application Code
;*   Your application code goes here.
;******************************************************************
application_code:

   if  (aux_data[0] == $0D)  then
@ 		GetAddress _telnet_banner, _flashaddr        ;Get address of String
		i_tcp = 0
		tcpdatalen_out = 0
		repeat
	   		Readcode flashaddr, flashchar        ' Get a character
			packet[TCP_data+i_tcp] = flashchar
			i_tcp = i_tcp + 1
			tcpdatalen_out = tcpdatalen_out + 1
		    flashaddr = flashaddr + 1               ' Point to next character
		until flashchar = 0
   else
      tcpdatalen_out = tcpdatalen_in 
   endif
return
;******************************************************************
;*	TCP Function
;*   This function uses TCP protocol to act as a Telnet server on
;*   port 8088 decimal.  The application function is called with
;*   every incoming character.
;******************************************************************
tcp:


   ;assemble the destination port address from the incoming packet
   portaddr = (packet[TCP_destport] << 8) + packet[TCP_destport+1]  

   ;calculate the length of the data coming in with the packet
   ;tcpdatalen_in = incoming packet length - incoming ip header length - incoming tcp header length
   tcpdatalen_in = ((packet[ip_pktlen] << 8) + packet[ip_pktlen+1]) - ((packet[ip_vers_len] & $0F) * 4) - (((packet[TCP_hdrflags] & $F0) >> 4) * 4)
	
	if tcpdatalen_in then 
		hserout[13,10,"TCPDATA_IN"]
	endif

   select case portaddr
   
   case MY_PORT_ADDRESS

   ;If an ACK is received and the destination port address is valid and no data is in the packet
   if((packet[TCP_hdrflags+1] & ACK_IN) && (tcpdatalen_in == $0000)) then
      ;assemble the acknowledgment number from the incoming packet
      incoming_ack =(packet[TCP_acknum] << 24) + (packet[TCP_acknum+1] << 16) + (packet[TCP_acknum+2] << 8) + packet[TCP_acknum+3]
      ;if the incoming packet is a result of session establishment
      if(bsynflag) then
         ;clear the SYN flag
         bsynflag = 0
         ;the incoming acknowledgment is my new sequence number
         my_seqnum = incoming_ack

         ;send the Telnet server banner
         ;limit the Telnet banner character count to 40 decimal
@ 		GetAddress _telnet_banner, _flashaddr        ;Get address of String
		i_tcp = 0
		tcpdatalen_out = 0
		repeat
	   		Readcode flashaddr, flashchar        ' Get a character
			packet[TCP_data+i_tcp] = flashchar
			i_tcp = i_tcp + 1
			tcpdatalen_out = tcpdatalen_out + 1
		    flashaddr = flashaddr + 1               ' Point to next character
		until flashchar = 0

                ;j8 = telnet_banner_size
                ;for i8 = 0 to (j8 - 1)
 				 ; packet[TCP_data+i8] = telnet_banner[i8]
				;next i8
         ;length of the banner message
         	   ;tcpdatalen_out = j8

         ;expect to get an acknowledgment of the banner message
         expected_ack = my_seqnum + tcpdatalen_out

         ;send the TCP/IP packet
         gosub send_tcp_packet
	  endif
   endif

   ;if an ack is received and the port address is valid and there is data in the incoming packet
   if((packet[TCP_hdrflags+1] & ACK_IN) && (tcpdatalen_in)) then
      for i8 = 0 to tcpdatalen_in - 1
         ;receive the data and put it into the incoming data buffer
         aux_data[i8] = packet[TCP_data+i8]
	  next i8

         ;run the TCP application
         gosub application_code

      ;assemble the acknowledgment number from the incoming packet
      incoming_ack = (packet[TCP_acknum] << 24) + (packet[TCP_acknum+1] << 16) + (packet[TCP_acknum+2] << 8) +packet[TCP_acknum+3]

      ;check for the number of bytes acknowledged
      ;determine how many bytes are outstanding and adjust the outgoing sequence number accordingly
      if(incoming_ack <= expected_ack) then
         my_seqnum = expected_ack - (expected_ack - incoming_ack)
	  endif
      ;my expected acknowledgement number
      expected_ack = my_seqnum +tcpdatalen_out


      gosub send_tcp_packet 
	endif

   ;this code segment processes the incoming SYN from the Telnet client
   ;and sends back the initial sequence number (ISN) and acknowledges
   ;the incoming SYN packet
   if(packet[TCP_hdrflags+1] & SYN_IN)  then
      hserout[13,10,"SYN IN"]
      tcpdatalen_in = $01
      bsynflag = 1

      gosub setipaddrs  

      temp = packet[TCP_srcport] 
      packet[TCP_srcport] = packet[TCP_destport] 
      packet[TCP_destport] = temp 

      temp = packet[TCP_srcport+1] 
      packet[TCP_srcport+1] = packet[TCP_destport+1] 
      packet[TCP_destport+1] = temp 

      gosub assemble_ack

	  ISN = ISN + 1
      if((ISN == $0000) || (ISN == $FFFF)) then
         ISN = $1234 
	  endif
      my_seqnum = (ISN << 16) + $FFFF

      ;set_packet32(TCP_seqnum,my_seqnum) 
	  packet[TCP_seqnum] = (my_seqnum & $FF000000) >> 24
	  packet[TCP_seqnum+1] = (my_seqnum & $00FF0000) >> 16
	  packet[TCP_seqnum+2] = (my_seqnum & $0000FF00) >> 8
	  packet[TCP_seqnum+3] = (my_seqnum & $000000FF) 

      packet[TCP_hdrflags+1] = $00
      packet[TCP_hdrflags+1] = packet[TCP_hdrflags+1] | SYN_OUT
      packet[TCP_hdrflags+1] = packet[TCP_hdrflags+1] | ACK_OUT

      packet[TCP_cksum] = $00
      packet[TCP_cksum+1] = $00

      hdr_chksum = 0
      hdrlen = $08 
      ;addr = &packet[ip_srcaddr] 
	  i_tcp = 0

	  while hdrlen > 1
	  	data_H = packet[ip_srcaddr+i_tcp]
		i_tcp = i_tcp + 1
	  	data_L = packet[ip_srcaddr+i_tcp]
		i_tcp = i_tcp + 1
		chksum16 = (data_H << 8) + data_L
		hdr_chksum = hdr_chksum + chksum16
		hdrlen = hdrlen -2
	  wend
	  if (hdrlen > 0) then
	  	data_H = packet[ip_srcaddr+i_tcp]
		data_L = 0
		chksum16 = (data_H << 8) + data_L
		hdr_chksum = hdr_chksum + chksum16
	  endif
	
	   
      hdr_chksum = hdr_chksum + packet[ip_proto]
      tcplen = ((packet[ip_pktlen] << 8) + packet[ip_pktlen+1]) - ((packet[ip_vers_len] & $0F) * 4)
      hdr_chksum = hdr_chksum + tcplen 
      hdrlen = tcplen 
      ;addr = &packet[TCP_srcport] 
      ;cksum()
	  i_tcp = 0

	  while hdrlen > 1
	  	data_H = packet[TCP_srcport+i_tcp]
		i_tcp = i_tcp + 1
	  	data_L = packet[TCP_srcport+i_tcp]
		i_tcp = i_tcp + 1
		chksum16 = (data_H << 8) + data_L
		hdr_chksum = hdr_chksum + chksum16
		hdrlen = hdrlen -2
	  wend
	  if (hdrlen > 0) then
	  	data_H = packet[TCP_srcport+i_tcp]
		data_L = 0
		chksum16 = (data_H << 8) + data_L
		hdr_chksum = hdr_chksum + chksum16
	  endif

      chksum16 = ~(hdr_chksum + ((hdr_chksum & $FFFF0000) >> 16))
      packet[TCP_cksum] = (chksum16 & $FF00) >> 8
      packet[TCP_cksum+1] = chksum16 & $00FF

 	tx_end = TXSTART 
   ;load beginning page for transmit buffer
    ;banksel(EWRPTL) 
	EWRPTL = TXSTART & $00FF
	EWRPTH = (TXSTART & $FF00) >> 8

   ;write control byte
	EDATA = tx_control_byte 
	tx_end = tx_end + 1

	tx_end = tx_end + rxlen
	;banksel(ETXNDL) 
	ETXNDL = tx_end & $00FF 
	ETXNDH = (tx_end & $FF00) >> 8 

	tx_cnt = tx_end - TXSTART

 
	;bufferptr = packet
	i_tcp = 0
	while tx_cnt 
		EDATA = packet[0 + i_tcp] 
		i_tcp = i_tcp + 1
		tx_cnt = tx_cnt - 1
	wend	

   ;send the contents of the transmit buffer onto the network
	if (TXERIF) then
	
	 TXERIF = 0 
     TXRST = 1 
   	 TXRST = 0 
	endif
	TXIF = 0 
   	TXRTS = 1 
	while ECON1 & ECON1_TXRTS
	wend
	hserout[13,10,"SENT SYN ACK"]
	endif

   ;this code segment processes a FIN from the Telnet client
   ;and acknowledges the FIN and any incoming data.
   if (packet[TCP_hdrflags+1] & FIN_IN) then
    
      if(tcpdatalen_in) then
         for i8 = 0 to tcpdatalen_in - 1
            aux_data[i8] = packet[TCP_data+i8] 
            gosub application_code
         next i8
	  endif

      bfinflag = 1

      tcpdatalen_in = tcpdatalen_in + 1

      incoming_ack = (packet[TCP_acknum] << 24) + (packet[TCP_acknum+1] << 16) + (packet[TCP_acknum+2] << 8) + packet[TCP_acknum+3]
      if(incoming_ack <= expected_ack) then
         my_seqnum = expected_ack - (expected_ack - incoming_ack) 
	  endif
      expected_ack = my_seqnum +tcpdatalen_out 
      gosub send_tcp_packet
	endif
;*******************************************************************************
	case WEB_SVR_ADDRESS

   if (packet[TCP_hdrflags+1] & RST_IN) then
	hserout[13,10,"RST_IN"]
	tcpflags = 0
	tcpdatalen_in = 0
   endif

   if((packet[TCP_hdrflags+1] & ACK_IN) && (tcpdatalen_in == $0000)) then
	hserout[13,10,"ACK_IN NO DATA"]
      ;assemble the acknowledgment number from the incoming packet
      incoming_ack =(packet[TCP_acknum] << 24) + (packet[TCP_acknum+1] << 16) + (packet[TCP_acknum+2] << 8) + packet[TCP_acknum+3]
      ;if the incoming packet is a result of session establishment
      if(bsynflag) then
         ;clear the SYN flag
         bsynflag = 0

          ;the incoming acknowledgment is my new sequence number
        my_seqnum = incoming_ack

		tcpdatalen_out = 0
         ;expect to get an acknowledgment of the banner message
         expected_ack = my_seqnum + tcpdatalen_out

	  endif
	if(bhttpflag) then
		bfinflag = 1
		tcpdatalen_out = 0
		gosub send_tcp_packet
	endif
   endif

   ;if an ack is received and the port address is valid and there is data in the incoming packet
   if((packet[TCP_hdrflags+1] & ACK_IN) &&_
	  (packet[TCP_hdrflags+1] & PSH_IN) &&_
	  (tcpdatalen_in)) then
	hserout[13,10,"ACK_IN DATA"]
		temp = 5
		i_http = 0
		while temp
			http_temp[i_http] = packet[TCP_data+i_http]
			i_http = i_http + 1
			temp = temp - 1
		wend
	 if((http_temp[0] == "G") &&_
	    (http_temp[1] == "E") &&_
		(http_temp[2] == "T") &&_
		(http_temp[3] == $20) &&_
		(http_temp[4] == "/")) then
		hserout[13,10,"DECODED GET /"]
@ 		GetAddress _http_ok_msg, _flashaddr        ;Get address of String
		i_http = 0
		tcpdatalen_out = 0
		repeat
	   		Readcode flashaddr, flashchar        ' Get a character
			packet[TCP_data+i_http] = flashchar
			i_http = i_http + 1
			tcpdatalen_out = tcpdatalen_out + 1
		    flashaddr = flashaddr + 1               ' Point to next character
		until flashchar = 0
		bhttpflag = 1
		bfinflag = 1
      incoming_ack = (packet[TCP_acknum] << 24) + (packet[TCP_acknum+1] << 16) + (packet[TCP_acknum+2] << 8) + packet[TCP_acknum+3]
      if(incoming_ack <= expected_ack) then
         my_seqnum = expected_ack - (expected_ack - incoming_ack) 
	  endif
      expected_ack = my_seqnum +tcpdatalen_out 
      gosub send_tcp_packet
	endif
   endif

   ;this code segment processes the incoming SYN from the HTTP client
   ;and sends back the initial sequence number (ISN) and acknowledges
   ;the incoming SYN packet
   if(packet[TCP_hdrflags+1] & SYN_IN)  then
      hserout[13,10,"SYN IN"]
      tcpdatalen_in = $01
      bsynflag = 1

      gosub setipaddrs  

      temp = packet[TCP_srcport] 
      packet[TCP_srcport] = packet[TCP_destport] 
      packet[TCP_destport] = temp 

      temp = packet[TCP_srcport+1] 
      packet[TCP_srcport+1] = packet[TCP_destport+1] 
      packet[TCP_destport+1] = temp 

      gosub assemble_ack

	  ISN = ISN + 1
      if((ISN == $0000) || (ISN == $FFFF)) then
         ISN = $1234 
	  endif
      my_seqnum = (ISN << 16) + $FFFF

      ;set_packet32(TCP_seqnum,my_seqnum) 
	  packet[TCP_seqnum] = (my_seqnum & $FF000000) >> 24
	  packet[TCP_seqnum+1] = (my_seqnum & $00FF0000) >> 16
	  packet[TCP_seqnum+2] = (my_seqnum & $0000FF00) >> 8
	  packet[TCP_seqnum+3] = (my_seqnum & $000000FF) 

      packet[TCP_hdrflags+1] = $00
      packet[TCP_hdrflags+1] = packet[TCP_hdrflags+1] | SYN_OUT
      packet[TCP_hdrflags+1] = packet[TCP_hdrflags+1] | ACK_OUT

      packet[TCP_cksum] = $00
      packet[TCP_cksum+1] = $00

      hdr_chksum = 0
      hdrlen = $08 
      ;addr = &packet[ip_srcaddr] 
	  i_tcp = 0

	  while hdrlen > 1
	  	data_H = packet[ip_srcaddr+i_tcp]
		i_tcp = i_tcp + 1
	  	data_L = packet[ip_srcaddr+i_tcp]
		i_tcp = i_tcp + 1
		chksum16 = (data_H << 8) + data_L
		hdr_chksum = hdr_chksum + chksum16
		hdrlen = hdrlen -2
	  wend
	  if (hdrlen > 0) then
	  	data_H = packet[ip_srcaddr+i_tcp]
		data_L = 0
		chksum16 = (data_H << 8) + data_L
		hdr_chksum = hdr_chksum + chksum16
	  endif
	
	   
      hdr_chksum = hdr_chksum + packet[ip_proto]
      tcplen = ((packet[ip_pktlen] << 8) + packet[ip_pktlen+1]) - ((packet[ip_vers_len] & $0F) * 4)
      hdr_chksum = hdr_chksum + tcplen 
      hdrlen = tcplen 
      ;addr = &packet[TCP_srcport];
      ;cksum()
	  i_tcp = 0

	  while hdrlen > 1
	  	data_H = packet[TCP_srcport+i_tcp]
		i_tcp = i_tcp + 1
	  	data_L = packet[TCP_srcport+i_tcp]
		i_tcp = i_tcp + 1
		chksum16 = (data_H << 8) + data_L
		hdr_chksum = hdr_chksum + chksum16
		hdrlen = hdrlen -2
	  wend
	  if (hdrlen > 0) then
	  	data_H = packet[TCP_srcport+i_tcp]
		data_L = 0
		chksum16 = (data_H << 8) + data_L
		hdr_chksum = hdr_chksum + chksum16
	  endif

      chksum16 = ~(hdr_chksum + ((hdr_chksum & $FFFF0000) >> 16))
      packet[TCP_cksum] = (chksum16 & $FF00) >> 8
      packet[TCP_cksum+1] = chksum16 & $00FF

 	tx_end = TXSTART;
   ;load beginning page for transmit buffer
    ;banksel(EWRPTL);
	EWRPTL = TXSTART & $00FF
	EWRPTH = (TXSTART & $FF00) >> 8

   ;write control byte
	EDATA = tx_control_byte 
	tx_end = tx_end + 1

	tx_end = tx_end + rxlen
	;banksel(ETXNDL);
	ETXNDL = tx_end & $00FF 
	ETXNDH = (tx_end & $FF00) >> 8 

	tx_cnt = tx_end - TXSTART

 
	;bufferptr = packet
	i_tcp = 0
	while tx_cnt 
		EDATA = packet[0 + i_tcp] 
		i_tcp = i_tcp + 1
		tx_cnt = tx_cnt - 1
	wend	

   ;send the contents of the transmit buffer onto the network
	if (TXERIF) then
	
	 TXERIF = 0 
     TXRST = 1 
   	 TXRST = 0 
	endif
	TXIF = 0 
   	TXRTS = 1 
	while ECON1 & ECON1_TXRTS
	wend
	hserout[13,10,"SENT SYN ACK"]
	endif

;case else
	;tcpflags = 0
	;tcpdatalen_in = 0

end select
return
;******************************************************************
;*	Assemble the Acknowledgment
;*   This function assembles the acknowledgment to send to
;*   to the client by adding the received data count to the
;*   client's incoming sequence number.
;******************************************************************
assemble_ack:

   client_seqnum= (packet[TCP_seqnum] << 24) + (packet[TCP_seqnum+1] << 16) + (packet[TCP_seqnum+2] << 8) + packet[TCP_seqnum+3]
   client_seqnum = client_seqnum + tcpdatalen_in 
   ;set_packet32(TCP_acknum,client_seqnum);
	  packet[TCP_acknum] = (client_seqnum & $FF000000) >> 24
	  packet[TCP_acknum+1] = (client_seqnum & $00FF0000) >> 16
	  packet[TCP_acknum+2] = (client_seqnum & $0000FF00) >> 8
	  packet[TCP_acknum+3] = (client_seqnum & $000000FF) 

return
;******************************************************************
;*	Send TCP Packet
;*   This routine assembles and sends a complete TCP/IP packet.
;*   40 bytes of IP and TCP header data is assumed.
;******************************************************************
 send_tcp_packet:

   ;count IP and TCP header bytes.. Total = 40 bytes
   ip_packet_len = 40 + tcpdatalen_out
   packet[ip_pktlen] = (ip_packet_len  & $FF00) >> 8
   packet[ip_pktlen+1] = ip_packet_len & $00FF
   gosub setipaddrs

   temp = packet[TCP_srcport] 
   packet[TCP_srcport] = packet[TCP_destport] 
   packet[TCP_destport] = temp 
   temp = packet[TCP_srcport+1] 
   packet[TCP_srcport+1] = packet[TCP_destport+1] 
   packet[TCP_destport+1] = temp 

   gosub assemble_ack
	    ;set_packet32(TCP_seqnum,my_seqnum) 
	 packet[TCP_seqnum] = (my_seqnum & $FF000000) >> 24
	 packet[TCP_seqnum+1] = (my_seqnum & $00FF0000) >> 16
	 packet[TCP_seqnum+2] = (my_seqnum & $0000FF00) >> 8
	 packet[TCP_seqnum+3] = (my_seqnum & $000000FF) 


   packet[TCP_hdrflags+1] = $00 
   packet[TCP_hdrflags+1] = packet[TCP_hdrflags+1] | ACK_OUT
   if(bfinflag) then
      packet[TCP_hdrflags+1] = packet[TCP_hdrflags+1] | FIN_OUT 
      bfinflag = 0
   endif

   packet[TCP_cksum] = $00 
   packet[TCP_cksum+1] = $00 

      hdr_chksum = 0
      hdrlen = $08 
      ;addr = &packet[ip_srcaddr] 
	  i_tcp = 0

	  while hdrlen > 1
	  	data_H = packet[ip_srcaddr+i_tcp]
		i_tcp = i_tcp + 1
	  	data_L = packet[ip_srcaddr+i_tcp]
		i_tcp = i_tcp + 1
		chksum16 = (data_H << 8) + data_L
		hdr_chksum = hdr_chksum + chksum16
		hdrlen = hdrlen -2
	  wend
	  if (hdrlen > 0) then
	  	data_H = packet[ip_srcaddr+i_tcp]
		data_L = 0
		chksum16 = (data_H << 8) + data_L
		hdr_chksum = hdr_chksum + chksum16
	  endif
   hdr_chksum = hdr_chksum + packet[ip_proto]
   tcplen = ip_packet_len - ((packet[ip_vers_len] & $0F) * 4)
   hdr_chksum = hdr_chksum + tcplen
   hdrlen = tcplen
   ;addr = &packet[TCP_srcport]
	  i_tcp = 0

	  while hdrlen > 1
	  	data_H = packet[TCP_srcport+i_tcp]
		i_tcp = i_tcp + 1
	  	data_L = packet[TCP_srcport+i_tcp]
		i_tcp = i_tcp + 1
		chksum16 = (data_H << 8) + data_L
		hdr_chksum = hdr_chksum + chksum16
		hdrlen = hdrlen -2
	  wend
	  if (hdrlen > 0) then
	  	data_H = packet[TCP_srcport+i_tcp]
		data_L = 0
		chksum16 = (data_H << 8) + data_L
		hdr_chksum = hdr_chksum + chksum16
	  endif

      chksum16 = ~(hdr_chksum + ((hdr_chksum & $FFFF0000) >> 16))
      packet[TCP_cksum] = (chksum16 & $FF00) >> 8
      packet[TCP_cksum+1] = chksum16 & $00FF

   txlen = ip_packet_len + 14 
   if(txlen < 60) then
      txlen = 60
   endif

 	tx_end = TXSTART;
   ;load beginning page for transmit buffer
    ;banksel(EWRPTL);
	EWRPTL = TXSTART & $00FF
	EWRPTH = (TXSTART & $FF00) >> 8

   ;write control byte
	EDATA = tx_control_byte 
	tx_end = tx_end + 1

	tx_end = tx_end + txlen
	;banksel(ETXNDL);
	ETXNDL = tx_end & $00FF 
	ETXNDH = (tx_end & $FF00) >> 8 

	tx_cnt = tx_end - TXSTART

	;bufferptr = packet
	i_tcp = 0
	while tx_cnt 
		EDATA = packet[0 + i_tcp] 
		i_tcp = i_tcp + 1
		tx_cnt = tx_cnt - 1
	wend	

   ;send the contents of the transmit buffer onto the network
	if (TXERIF) then
	
	 TXERIF = 0 
     TXRST = 1 
   	 TXRST = 0 
	endif
	TXIF = 0 
   	TXRTS = 1 
	;while(1 == (ECON1 & ECON1_TXRTS))
	while ECON1 & ECON1_TXRTS
	wend
return

ripple_crc:
		if (acc0 > $FF) then
		 acc1 = acc1 + 1
		 acc0 = acc0 & $00FF
		endif
		if (acc1 > $FF) then
		 acc2 = acc2 + 1
		 acc1 = acc1 & $00FF
		endif
		if (acc2 > $FF) then
		 acc3 = acc3 + 1
		 acc2 = acc2 & $00FF
		endif
		if (acc3 > $FF) then
		 hserout[13,10,"CHECKSUM OVERFLOW ERROR",13,10]
		endif
		return
clrcrc:
	acc0 = 0
	acc1 = 0
	acc2 = 0
	acc3 = 0
	arg0 = 0
	arg1 = 0
	arg2 = 0
	arg3 = 0
	return
;******************************************************************
;*	INITIALIZE DHCP STATE MACHINE
;******************************************************************
init_DHCP:

	if (DHCPSTATE == DHCP_DISABLED) then
		return 
	endif	
	dhcpflags = 0 
	DHCPSTATE = 0
	DHCPSTATE = DHCP_ENTRY
return

;******************************************************************
;*	DHCP STATE MACHINE
;******************************************************************
dhcp_state_engine:

		if (DHCPSTATE == DHCP_DISABLED) then
		return
		endif

		if (DHCPSTATE == DHCP_ENTRY) then
			hserout[13,10,"DHCP RESET.."]
			for i8 = 0 to 3
				tempipaddrc[i8] = $00 
			next i8
			DHCPSTATE = DHCP_INIT
		endif
		if (DHCPSTATE == DHCP_INIT) then
			hserout[13,10,"DHCP INIT.."]	
			for i8 = 0 to 5
				svrmacaddrc[i8] = $FF 
			next i8
			for i8 = 0 to 3
				svridc[i8] = $FF 
			next i8
			msecs_timer = 0 
			DHCPSTATE = DHCP_WAIT
		endif
		if (DHCPSTATE == DHCP_WAIT) then
			if(msecs_timer >= 2000) then
				DHCPSTATE = DHCP_BROADCAST
			endif
		goto breaker
		endif
		if (DHCPSTATE == DHCP_BROADCAST) then
			leasetime = 60 
			if (bbound) then
				DHCPSTATE = DHCP_REQUEST 
			else
				dhcpmsgtype = DHCP_DISCOVER_MESSAGE
				gosub send_dhcp
				msecs_timer = 0 
				DHCPSTATE = DHCP_DISCOVER 
				hserout[13,10,"SENT DISCOVER MESSAGE.."]
			endif
		goto breaker
		endif
		if (DHCPSTATE == DHCP_DISCOVER) then
			if(msecs_timer >= 2000) then
				DHCPSTATE = DHCP_BROADCAST
				return 
			endif
			if (bnewdhcppkt) then
				gosub receive_dhcp 
				if (msgtype == DHCP_OFFER_MESSAGE) then
					DHCPSTATE = DHCP_REQUEST
					hserout[13,10,"RECEIVED DHCP OFFER MESSAGE.."]
				endif
				bnewdhcppkt = 0
				endif
			goto breaker 
			endif
		if (DHCPSTATE == DHCP_REQUEST) then
			dhcpmsgtype = DHCP_REQUEST_MESSAGE
			gosub send_dhcp 
			msecs_timer = 0 
			DHCPSTATE = DHCP_BIND
			hserout[13,10,"SENT DHCP REQUEST MESSAGE.."]
		goto breaker
		endif
		if (DHCPSTATE == DHCP_BIND) then
			if (bnewdhcppkt) then
				gosub receive_dhcp
				bnewdhcppkt = 0	
			endif
			if(msgtype == DHCP_NAK_MESSAGE) then
				hserout[13,10,"RECEIVED DHCP NAK MESSAGE.."]
				gosub init_DHCP 
				return 
			endif
			if(msgtype == DHCP_ACK_MESSAGE) then
				hserout[13,10,"RECEIVED DHCP ACK MESSAGE.."]
				lease_timer = 0 
				DHCPSTATE = DHCP_BOUND
				for i16 = 0 to 3
					ipaddrc[i16] = tempipaddrc[i16] 
					subnetmaskc[i16] = tempsubnetmaskc[i16] 
					gwayipaddrc[i16] = tempgwayipaddrc[i16] 
				next i16
				bbound = 1
				hserout[13,10,"NEW IP ADDRESS IS "]
				for j8 = 0 to 3
						binarynumber = ipaddrc[j8]
						gosub binary_to_ascii
			            if (ipaddrascii[0] != $30) then
							hserout[ipaddrascii[0]]
						endif

			            if ((ipaddrascii[0] == $30) && (ipaddrascii[1] == $30)) then
							scratch8 = 0
						else
							hserout[ipaddrascii[1]]
						endif
						hserout[ipaddrascii[2],$2E]
					next j8	
				hserout[13,10,"NEW GATEWAY ADDRESS IS "]
				for j8 = 0 to 3
						binarynumber = gwayipaddrc[j8]
						gosub binary_to_ascii
			            if (ipaddrascii[0] != $30) then
							hserout[ipaddrascii[0]]
						endif

			            if ((ipaddrascii[0] == $30) && (ipaddrascii[1] == $30)) then
							scratch8 = 0
						else
							hserout[ipaddrascii[1]]
						endif
						hserout[ipaddrascii[2],$2E]
					next j8	
				hserout[13,10,"NEW SUBNET MASK IS "]
				for j8 = 0 to 3
						binarynumber = subnetmaskc[j8]
						gosub binary_to_ascii
			            if (ipaddrascii[0] != $30) then
							hserout[ipaddrascii[0]]
						endif

			            if ((ipaddrascii[0] == $30) && (ipaddrascii[1] == $30)) then
							scratch8 = 0
						else
							hserout[ipaddrascii[1]]
						endif
						hserout[ipaddrascii[2],$2E]
					next j8	
				gosub send_dhcp_bound_datagram
				return 
			endif
			if (msecs_timer >= 2000) then
			DHCPSTATE =	DHCP_BROADCAST
			endif
		goto breaker
		endif
		if (DHCPSTATE == DHCP_BOUND) then
			if (bleaseflag) then
				bleaseflag = 0
				templeasetimec[3] = templeasetimec[3] - 1
				if (templeasetimec[3] == $FF) then 
					templeasetimec[2] = templeasetimec[2] - 1
				endif
				if (templeasetimec[2] == $FF) then
					templeasetimec[1] = templeasetimec[1] - 1
				endif
				if (templeasetimec[1] == $FF) then
					templeasetimec[0] = templeasetimec[0] - 1
				endif
				if ((templeasetimec[0] == 0) && _
				   (templeasetimec[1] == 0) && _
				   (templeasetimec[2] == 0) && _
				   (templeasetimec[3] == 0)) then
						hserout[13,10,"DHCP LEASE TIME EXPIRED.."]
						DHCPSTATE = DHCP_INIT
				endif
			endif
		endif
breaker:
return
;******************************************************************
;*	SEND A DHCP MESSAGE ROUTINE
;******************************************************************
send_dhcp:;(char dhcpmsgtype)
	
	tx_end = 0
   ;load beginning page for transmit buffer
	EWRPTL = TXSTART & $00FF
	EWRPTH = (TXSTART & $FF00) >> 8
	
	EDATA =  $0E   			;write control byte
	for i8 = 0 to 5  		;write destination MAC address	
		EDATA = $FF 
	next i8	

	for i8 = 0 to 5
		EDATA = macaddrc[i8] 
	next i8

	EDATA =  $08 		;write 0800 type field
	EDATA =  $00 
	tx_end = tx_end + 15 
	
	;BEGIN IP HEADER
	EDATA =  $45 		;write 4500 vers/len field
	EDATA =  $00 
	EDATA =  $00 		;write packet length $0114
	EDATA =  $00 
	EDATA =  $00 		;write id field
	EDATA =  $01 
	EDATA =  $00 		;write flags/frag offset
	EDATA =  $00 
	EDATA =  $64 		;write time to live
	EDATA =  $11 		;write protocol type (UDP)
	EDATA =  $00 		;write IP hdr checksum ($0000)
	EDATA =  $00 
	for i8 = 0 to 3		;write source IP address
		EDATA =  $00 
	next i8
	for i8 = 0 to 3		;write destination IP address
		EDATA =  $FF 
	next i8
	tx_end = tx_end + 20 
	;END IP HEADER
	
	;START UDP HEADER
	EDATA =  $00 		;write UDP source port (68)
	EDATA =  $44 
	EDATA =  $00 		;write UDP destination port (67)
	EDATA =  $43 
	EDATA =  $00 		;write UDP length 
	EDATA =  $00 
	EDATA =  $00 		;write UDP checksum (no checksum)
	EDATA =  $00 
	tx_end = tx_end + 8 
	;END UDP HEADER
	


 ;  0                   1                   2                   3
 ;  0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
 ;  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 ;  |     op (1)    |   htype (1)   |   hlen (1)    |   hops (1)    |
 ;  +---------------+---------------+---------------+---------------+
 ;  |                            xid (4)                            |
 ;  +-------------------------------+-------------------------------+
 ;  |           secs (2)            |           flags (2)           |
 ;  +-------------------------------+-------------------------------+
 ;  |                          ciaddr  (4)                          |
 ;  +---------------------------------------------------------------+
 ;  |                          yiaddr  (4)                          |
 ;  +---------------------------------------------------------------+
 ;  |                          siaddr  (4)                          |
 ;  +---------------------------------------------------------------+
 ;  |                          giaddr  (4)                          |
 ;  +---------------------------------------------------------------+
 ;  |                                                               |
 ;  |                          chaddr  (16)                         |
 ;  |                                                               |
 ;  |                                                               |
 ;  +---------------------------------------------------------------+
 ;  |                                                               |
 ;  |                          sname   (64)                         |
 ;  +---------------------------------------------------------------+
 ;  |                                                               |
 ;  |                          file    (128)                        |
 ;  +---------------------------------------------------------------+
 ;  |                                                               |
 ;  |                          options (312)                        |
 ;  +---------------------------------------------------------------+



	;BEGIN DHCP MESSAGE
	EDATA =  BOOT_REQUEST 			;write DHCP boot record type (request)
	EDATA =  HW_TYPE 				;write DHCP hw address type (10Mb Ethernet)
	EDATA =  HW_TYPE_LEN 			;write DHCP hw address length (6)
	EDATA =  $00 					;write DHCP hops (0)
	EDATA =  $01 					;write DHCP transaction id (01020304)
	EDATA =  $02 		
	EDATA =  $03 		
	EDATA =  $04 		
	EDATA =  $00 					;write DHCP elapsed boot time (0)
	EDATA =  $00 		
	EDATA =  $80 					;write DHCP flags (8000)
	EDATA =  $00 		
  									;write ciaddr,yiaddr,siaddr,giaddr	
	for i8 = 0 to 15		
		EDATA =  $00 
	next i8
	for i8 = 0 to 5				;write source MAC address to chaddr		
		EDATA = macaddrc[i8]
	next i8
	for i8 = 0 to 201   			;write remaining 10 bytes of $00 to chaddr
		EDATA =  $00				;write 64 bytes of $00 to sname
	next i8							;write 128 bytes of $00 to file					
	tx_end = tx_end + 236   
	EDATA =  $63 					;write DHCP magic cookie (63825363)
	EDATA =  $82 		
	EDATA =  $53 		
	EDATA =  $63 		
	EDATA =  DHCP_MESSAGE_TYPE 		;write DHCP message type 
	EDATA =  DHCP_MESSAGE_TYPE_LEN 	 	
	EDATA =  dhcpmsgtype 		
	tx_end = tx_end + 7 
	if(dhcpmsgtype == DHCP_DISCOVER_MESSAGE) then
		bofferrec = 0
	endif
	if((dhcpmsgtype !=  DHCP_DISCOVER_MESSAGE) && _
					   (tempipaddrc[0] != $00) && _
					   (tempipaddrc[1] != $00) && _
					   (tempipaddrc[2] != $00) && _
					   (tempipaddrc[3] != $00 )) then
			EDATA =  DHCP_SERVER_IDENTIFIER 	   
			EDATA =  DHCP_SERVER_IDENTIFIER_LEN 		
			for i8 = 0 to 3   			;write server ip address (server id)
				EDATA = svridc[i8];
			next i8
		tx_end = tx_end + 6 
	endif
	EDATA =  DHCP_PARAM_REQUEST_LIST 		;write DHCP parameter list (2 entries)
	EDATA =  DHCP_PARAM_REQUEST_LIST_LEN 		
	EDATA =  DHCP_SUBNET_MASK 		;client's subnet mask
	EDATA =  DHCP_ROUTER 		;routers on the client's subnet	
	tx_end = tx_end + 4 
	if(dhcpmsgtype == DHCP_REQUEST_MESSAGE) then
			EDATA =  DHCP_PARAM_REQUEST_IP_ADDRESS 	   
			EDATA =  DHCP_PARAM_REQUEST_IP_ADDRESS_LEN 		
			for i8 = 0 to 3   			;write requested ip address 
				EDATA = tempipaddrc[i8]
			next i8
		tx_end = tx_end + 6 
	endif

	EDATA = $FF 		;end of options	
	tx_end = tx_end + 1 
	;DHCP MESSAGE END
	
	; write ip header total length
	EWRPTL = (TXSTART & $00FF) + $11
	EWRPTH = ((TXSTART & $FF00) >> 8) + $00
	
	i16 = tx_end - 15 	
	EDATA =  (i16 & $FF00 ) >> 8   
	EDATA =  i16 & $00FF 

	; write udp header total length
    ;banksel(EWRPTL);
	EWRPTL = (TXSTART & $00FF) + $27
	EWRPTH = ((TXSTART & $FF00) >> 8) + $00
	
	i16 = tx_end - 35;	
	EDATA =  (i16 & $FF00 ) >> 8   
	EDATA =  i16 & $00FF 

	;compute ip header checksum
    hdrlen = ($45 & $0F) * 4 		;hdrlen = 20 bytes
	offsetval = TXSTART+15		;beginning of IP header
	EDMASTL = offsetval & $00FF
	EDMASTH = (offsetval & $FF00) >> 8
	offsetval = offsetval + (hdrlen-1) 
	EDMANDL = offsetval & $00FF
	EDMANDH = (offsetval & $FF00) >> 8
	ECON1 =  ECON1 | (ECON1_CSUMEN | ECON1_DMAST) 
    while(ECON1 & ECON1_DMAST) 
	wend
    chksum_lo =  EDMACSL 
    chksum_hi =  EDMACSH 
   
    ;write ip checksum values to TX buffer
    offsetval = TXSTART + 25
    EWRPTL = offsetval & $00FF
    EWRPTH = (offsetval & $FF00) >> 8
	EDATA =  chksum_hi 
	EDATA =  chksum_lo 
    tx_end = tx_end + (TXSTART-1) 
	ETXNDL = tx_end & $00FF
	ETXNDH = (tx_end & $FF00) >> 8

   ;send the contents of the transmit buffer onto the network
	if (TXERIF) then
	
	 TXERIF = 0 
     TXRST = 1 
   	 TXRST = 0 
	endif
	TXIF = 0 
   	TXRTS = 1 
	;while(1 == (ECON1 & ECON1_TXRTS))
	while ECON1 & ECON1_TXRTS
	wend
return
;******************************************************************
;*	RECEIVE DHCP MESSAGE ROUTINE
;******************************************************************
receive_dhcp:

	msgtype = DHCP_UNKNOWN_MESSAGE
	bdone = 0
	if (packet[DHCP_op] == BOOT_REPLY)  then
		if(bofferrec == 0) then
			for i8 = 0 to 3
				tempipaddrc[i8] = packet[DHCP_yiaddr+i8] 
			next i8
		endif
	endif
		if ((packet[DHCP_chaddr] == macaddrc[0]) && _
			   (packet[DHCP_chaddr+1] == macaddrc[1]) && _
			   (packet[DHCP_chaddr+2] == macaddrc[2]) && _
			   (packet[DHCP_chaddr+3] == macaddrc[3]) && _
			   (packet[DHCP_chaddr+4] == macaddrc[4]) && _
 			   (packet[DHCP_chaddr+5] == macaddrc[5])) then
				   packetptr = 4
				   REPEAT
					   dhcpmsgchar = packet[DHCP_options+packetptr]:packetptr = packetptr + 1
					  	select case dhcpmsgchar 
						   case DHCP_MESSAGE_TYPE 
					   		msglen = packet[DHCP_options+packetptr]:packetptr = packetptr + 1
					   		if (msglen == $01)  then
						   		msgtype = packet[DHCP_options+packetptr]:packetptr = packetptr + 1
						   		if ((bofferrec) && (msgtype == DHCP_OFFER_MESSAGE)) then
							   		btrashit = 1
								else
							 		btrashit = 1
								endif
							endif

							case DHCP_SERVER_IDENTIFIER 
					   		msglen = packet[DHCP_options+packetptr]:packetptr = packetptr + 1
					   		if (msglen == $04)  then
								for i8 = 0 to 3
									tempsvridc[i8] = packet[DHCP_options+packetptr]:packetptr = packetptr + 1
								next i8
							 else
							 	btrashit = 1
							endif
							
							case DHCP_SUBNET_MASK 
					   		msglen = packet[DHCP_options+packetptr]:packetptr = packetptr + 1
					   		if (msglen == $04)  then
								for i8 = 0 to 3
									tempsubnetmaskc[i8] = packet[DHCP_options+packetptr]:packetptr = packetptr + 1
								next i8
							 else
							 	btrashit = 1
							endif
							
							case DHCP_IP_LEASE_TIME:
					   		msglen = packet[DHCP_options+packetptr]:packetptr = packetptr + 1
					   		if (msglen == $04)  then
						   		if (bofferrec) then
							   		for i8 = 0 to 3
							   			packetptr = packetptr + 1
									next i8
							   	else
									for i8 = 0 to 3
										templeasetimec[i8] = packet[DHCP_options+packetptr]:packetptr = packetptr + 1
									next i8
								endif
							endif
							;leasetime = make32(templeasetimec[0],templeasetimec[1],templeasetimec[2],templeasetimec[3]);
							
							if (templeasetimec[2] >= $07)  then ;renew 30 minutes before the lease expires
								for i16 = 0 to 1799
									templeasetimec[3] = templeasetimec[3] - 1
									if (templeasetimec[3] == $FF) then 
										templeasetimec[2] = templeasetimec[2] - 1
									endif
									if (templeasetimec[2] == $FF) then
										templeasetimec[1] = templeasetimec[1] - 1
									endif
									if (templeasetimec[1] == $FF) then
										templeasetimec[0] = templeasetimec[0] - 1
									endif
								next i16
									 
							 else
							 	btrashit = 1
							endif
							
							case DHCP_ROUTER 
					   		msglen = packet[DHCP_options+packetptr]:packetptr = packetptr + 1
					   		if (msglen >= $04)  then
						   		if (bofferrec) then
							   		for i8 = 0 to 3
							   			packetptr = packetptr + 1
									next i8
							   	else
									for i8 = 0 to 3
										tempgwayipaddrc[i8] = packet[DHCP_options+packetptr]:packetptr = packetptr + 1
									next i8
								endif
							 else
							 	 btrashit = 1
							 	 msglen = msglen - 4 
								 repeat
							 		packetptr = packetptr + 1
									msglen = msglen - 1
								 until msglen = 0
							endif

							case DHCP_END_OPTION 
								bdone = 1
							
							
							case else
					   			msglen = packet[DHCP_options+packetptr]:packetptr = packetptr + 1
								 repeat
							 		packetptr = packetptr + 1
									msglen = msglen - 1
								 until msglen = 0
						end select
				   
				  UNTIL bdone = 1
		endif

		if (msgtype == DHCP_OFFER_MESSAGE) then
			for i8 = 0 to 3
					svridc[i8] = tempsvridc[i8]
			next i8
			bofferrec = 1
		else
			if(( svridc[0] != tempsvridc[0]) || _
				(svridc[1] != tempsvridc[1]) || _
				(svridc[2] != tempsvridc[2]) || _
				(svridc[3] != tempsvridc[3] )) then
					msgtype = DHCP_UNKNOWN_MESSAGE 
			endif
		endif
	if (btrashit) then
		bnewdhcppkt = 0
	endif
	return 	   
;******************************************************************
;*	  SEND DHCP BOUND MESSAGE VIA BROADCAST UDP
;******************************************************************
send_dhcp_bound_datagram:

	tx_end = 0 
   ;load beginning page for transmit buffer
	EWRPTL = TXSTART & $00FF
	EWRPTH = (TXSTART & $FF00) >> 8
	
	EDATA =  $0E   			;write control byte
	for i8 = 0 to 5  		;write destination MAC address	
		EDATA = $FF 
	next i8	

	for i8 = 0 to 5
		EDATA = macaddrc[i8] 
	next i8

	EDATA =  $08 		;write 0800 type field
	EDATA =  $00 
	tx_end = tx_end + 15 
	
	;BEGIN IP HEADER
	EDATA =  $45 		;write 4500 vers/len field
	EDATA =  $00 
	EDATA =  $00 		;write packet length $0114
	EDATA =  $00 
	EDATA =  $00 		;write id field
	EDATA =  $01 
	EDATA =  $00 		;write flags/frag offset
	EDATA =  $00 
	EDATA =  $64 		;write time to live
	EDATA =  $11 		;write protocol type (UDP)
	EDATA =  $00 		;write IP hdr checksum ($0000)
	EDATA =  $00 
	for i8 = 0 to 3		;write source IP address
		EDATA =  ipaddrc[i8] 
	next i8
	for i8 = 0 to 3		;write destination IP address
		EDATA =  broadcastipaddrc[i8] 
	next i8
	tx_end = tx_end + 20 
	;END IP HEADER
	
	;START UPD HEADER
	EDATA =  (MY_PORT_ADDRESS & $FF00) >> 8		;write UDP source port (8088 decimal)
	EDATA =  MY_PORT_ADDRESS & $00FF
	EDATA =  (MCHP_UDP_PORT_ADDRESS & $FF00) >> 8		;write UDP destination port (30303 decimal)
	EDATA =  MCHP_UDP_PORT_ADDRESS & $00FF
	EDATA =  $00 		;write UDP length 
	EDATA =  $00 
	EDATA =  $00 		;write UDP checksum (no checksum)
	EDATA =  $00 
	tx_end = tx_end +  8 
	;END UDP HEADER
	
    ;START UDP DATA
    ;write MAC address message
    i8 = 36 
    tx_end = tx_end +  i8;
	EDATA = $13
	EDATA = $10
	EDATA =	"M"
	EDATA =	"Y"
	EDATA =	" "
	EDATA =	"M"
	EDATA =	"A"
	EDATA =	"C"
	EDATA =	" "
	EDATA =	"A"
	EDATA =	"D"
	EDATA =	"D"
	EDATA =	"R"
	EDATA =	"E"
	EDATA =	"S"
	EDATA =	"S"
	EDATA =	" "
	EDATA =	"="
	EDATA =	" "
	EDATA =	"0"
	EDATA =	"0"
	EDATA =	"-"
	EDATA =	"0"
	EDATA =	"0"
	EDATA =	"-"
	EDATA =	"4"
	EDATA =	"6"
	EDATA =	"-"
	EDATA =	"5"
	EDATA =	"4"
	EDATA =	"-"
	EDATA =	"4"
	EDATA =	"9"
	EDATA =	"-"
	EDATA =	"4"
	EDATA =	"9"

	;write IP address message	
    i8 = 19;
    tx_end = tx_end +  i8;
	EDATA = $13
	EDATA = $10
	EDATA =	"N"
	EDATA =	"E"
	EDATA =	"W"
	EDATA =	" "
	EDATA =	"I"
	EDATA =	"P"
	EDATA =	" "
	EDATA =	"A"
	EDATA =	"D"
	EDATA =	"D"
	EDATA =	"R"
	EDATA =	"E"
	EDATA =	"S"
	EDATA =	"S"
	EDATA =	" "
	EDATA =	"="
	EDATA =	" "

	for i8 = 0 to 3
			binarynumber = ipaddrc[i8]
			gosub binary_to_ascii
			j8 = 3
            tx_end = tx_end + j8
			ptr = 0
            if (ipaddrascii[0] == $30) then
	        	tx_end = tx_end - 1
	            j8 = j8 - 1
	            ptr = ptr + 1
	        endif
	        if ((ipaddrascii[1] == $30)  && (ipaddrascii[0] == $30)) then
	           	tx_end = tx_end - 1
	            j8 = j8 - 1
	            ptr = ptr + 1
            endif	
			repeat
				EDATA =  ipaddrascii[ptr]:ptr = ptr + 1 ;write MINI IP address 
				j8 = j8 - 1
			until j8 = 0
			if (i8 < 3) then
				EDATA =  $2E	;write . period
				tx_end = tx_end +  1 
			endif
		next i8	
	;write gateway address message				
     i8 = 27
     tx_end = tx_end +  i8
	EDATA = $13
	EDATA = $10
	EDATA =	"N"
	EDATA =	"E"
	EDATA =	"W"
	EDATA =	" "
	EDATA =	"G"
	EDATA =	"A"
	EDATA =	"T"
	EDATA =	"E"
	EDATA =	"W"
	EDATA =	"A"
	EDATA =	"Y"
	EDATA =	" "
	EDATA =	"A"
	EDATA =	"D"
	EDATA =	"D"
	EDATA =	"R"
	EDATA =	"E"
	EDATA =	"S"
	EDATA =	"S"
	EDATA =	" "
	EDATA =	"="
	EDATA =	" "

	for i8 = 0 to 3
			binarynumber = gwayipaddrc[i8]
			gosub binary_to_ascii
			j8 = 3
            tx_end = tx_end + j8
			ptr = 0
            if (ipaddrascii[0] == $30) then
	        	tx_end = tx_end - 1
	            j8 = j8 - 1
	            ptr = ptr + 1
	        endif
	        if ((ipaddrascii[1] == $30)  && (ipaddrascii[0] == $30)) then
	           	tx_end = tx_end - 1
	            j8 = j8 - 1
	            ptr = ptr + 1
            endif	
			repeat
				EDATA =  ipaddrascii[ptr]:ptr = ptr + 1 ;write MINI IP address 
				j8 = j8 - 1
			until j8 = 0
			if (i8 < 3) then
				EDATA =  $2E	;write . period
				tx_end = tx_end +  1 
			endif
		next i8	
	
	;write subnet mask address message				
     i8 = 20 
     tx_end = tx_end +  i8 
	EDATA = $13
	EDATA = $10
	EDATA =	"N"
	EDATA =	"E"
	EDATA =	"W"
	EDATA =	" "
	EDATA =	"S"
	EDATA =	"U"
	EDATA =	"B"
	EDATA =	"N"
	EDATA =	"E"
	EDATA =	"T"
	EDATA =	" "
	EDATA =	"M"
	EDATA =	"A"
	EDATA =	"S"
	EDATA =	"K"
	EDATA =	" "
	EDATA =	"="
	EDATA =	" "

	for i8 = 0 to 3
			binarynumber = subnetmaskc[i8]
			gosub binary_to_ascii
			j8 = 3
            tx_end = tx_end + j8
			ptr = 0
            if (ipaddrascii[0] == $30) then
	        	tx_end = tx_end - 1
	            j8 = j8 - 1
	            ptr = ptr + 1
	        endif
	        if ((ipaddrascii[1] == $30)  && (ipaddrascii[0] == $30)) then
	           	tx_end = tx_end - 1
	            j8 = j8 - 1
	            ptr = ptr + 1
            endif	
			repeat
				EDATA =  ipaddrascii[ptr]:ptr = ptr + 1 ;write MINI IP address 
				j8 = j8 - 1
			until j8 = 0
			if (i8 < 3) then
				EDATA =  $2E	;write . period
				tx_end = tx_end +  1 
			endif
		next i8	
	;read_xmit_buffer();
	;++i;
	
	; write ip header total length
	EWRPTL = (TXSTART & $00FF) + $11
	EWRPTH = ((TXSTART & $FF00) >> 8) + $00
	
	i16 = tx_end - 15 	
	EDATA =  (i16 & $FF00 ) >> 8   
	EDATA =  i16 & $00FF 

	; write udp header total length
    ;banksel(EWRPTL);
	EWRPTL = (TXSTART & $00FF) + $27
	EWRPTH = ((TXSTART & $FF00) >> 8) + $00
	
	i16 = tx_end - 35;	
	EDATA =  (i16 & $FF00 ) >> 8   
	EDATA =  i16 & $00FF 

	;compute ip header checksum
    hdrlen = ($45 & $0F) * 4 		;hdrlen = 20 bytes
	offsetval = TXSTART+15		;beginning of IP header
	EDMASTL = offsetval & $00FF
	EDMASTH = (offsetval & $FF00) >> 8
	offsetval = offsetval + (hdrlen-1) 
	EDMANDL = offsetval & $00FF
	EDMANDH = (offsetval & $FF00) >> 8
	ECON1 =  ECON1 | (ECON1_CSUMEN | ECON1_DMAST) 
    while(ECON1 & ECON1_DMAST) 
	wend
    chksum_lo =  EDMACSL 
    chksum_hi =  EDMACSH 
   
    ;write ip checksum values to TX buffer
    offsetval = TXSTART + 25
    EWRPTL = offsetval & $00FF
    EWRPTH = (offsetval & $FF00) >> 8
	EDATA =  chksum_hi 
	EDATA =  chksum_lo 
    tx_end = tx_end + (TXSTART-1) 
	ETXNDL = tx_end & $00FF
	ETXNDH = (tx_end & $FF00) >> 8

   ;send the contents of the transmit buffer onto the network
	if (TXERIF) then
	
	 TXERIF = 0 
     TXRST = 1 
   	 TXRST = 0 
	endif
	TXIF = 0 
   	TXRTS = 1 
	;while(1 == (ECON1 & ECON1_TXRTS))
	while ECON1 & ECON1_TXRTS
	wend
return

;******************************************************************
;*	BINARY TO ASCII CONVERSION
;*  INPUT = binarynumber
;*  OUTPUT = ipaddrascii[0:2]
;******************************************************************
binary_to_ascii:;(unsigned int binarynumber)
	
	for b2a = 0 to 2
		ipaddrascii[b2a] = $30 
	next b2a
	if (binarynumber > 255) then 
		return
	endif

	if (binarynumber >= 100) then
	repeat			
		binarynumber = binarynumber - 100 
		ipaddrascii[0] = ipaddrascii[0] +  1 
	until binarynumber < 100
	endif

	if (binarynumber >= 10) then
	repeat
		binarynumber = binarynumber - 10 
		ipaddrascii[1] = ipaddrascii[1] +  1 
	until binarynumber < 10
	endif
		ipaddrascii[2] = ipaddrascii[2] + (binarynumber & $00FF) 
return

