
; HI-TECH Software PICC-18 Assembler  eader file.
; Definitions based on C  eader file: pic18f97j60. .

; NOTE: PICC-18 assembler option -P is required to preprocess assembler sources. 

;******************************************************************************
;* PH Register Locations
;******************************************************************************/
PHCON1	CON	$00
PHSTAT1	CON	$01
PHID1	CON	$02
PHID2	CON	$03
PHCON2	CON	$10
PHSTAT2	CON	$11
PHIE	CON	$12
PHIR	CON	$13
PHLCON	CON	$14
;******************************************************************************
;* Individual Register Bits
;******************************************************************************/
; ETH/MAC/MII bits

; EIE bits ----------
 	EIE_PKTIE		CON %01000000
 	EIE_DMAIE		CON %00100000
 	EIE_LINKIE		CON %00010000
 	EIE_TXIE		CON %00001000
 	EIE_TXERIE		CON %00000010
 	EIE_RXERIE		CON %00000001

; EIR bits ----------
 	EIR_PKTIF		CON %01000000
 	EIR_DMAIF		CON %00100000
 	EIR_LINKIF		CON %00010000
 	EIR_TXIF		CON %00001000
 	EIR_TXERIF		CON %00000010
 	EIR_RXERIF		CON %00000001
	
; ESTAT bits ---------
 	ESTAT_BUFER		CON %01000000
 	ESTAT_RXBUSY	CON %00000100
 	ESTAT_TXABRT	CON %00000010
 	ESTAT_PHYRDY	CON %00000001
	
; ECON2 bits --------
 	ECON2_AUTOINC	CON %10000000
 	ECON2_PKTDEC	CON %01000000
 	ECON2_ETHEN		CON %00100000
	
; ECON1 bits --------
 	ECON1_TXRST		CON %10000000
 	ECON1_RXRST		CON %01000000
 	ECON1_DMAST		CON %00100000
 	ECON1_CSUMEN	CON %00010000
 	ECON1_TXRTS		CON %00001000
 	ECON1_RXEN		CON %00000100
	
; ERXFCON bits ------
 	ERXFCON_UCEN	CON %10000000
 	ERXFCON_ANDOR	CON %01000000
 	ERXFCON_CRCEN	CON %00100000
 	ERXFCON_PMEN	CON %00010000
 	ERXFCON_MPEN	CON %00001000
 	ERXFCON_HTEN	CON %00000100
 	ERXFCON_MCEN	CON %00000010
 	ERXFCON_BCEN	CON %00000001
	
; MACON1 bits --------
 	MACON1_LOOPBK	CON %00010000
 	MACON1_TXPAUS	CON %00001000
 	MACON1_RXPAUS	CON %00000100
 	MACON1_PASSALL	CON %00000010
 	MACON1_MARXEN	CON %00000001
	
; MACON3 bits --------
 	MACON3_PADCFG2	CON %10000000
 	MACON3_PADCFG1	CON %01000000
 	MACON3_PADCFG0	CON %00100000
 	MACON3_TXCRCEN	CON %00010000
 	MACON3_PHDREN	CON %00001000
 	MACON3_HFRMEN	CON %00000100
 	MACON3_FRMLNEN	CON %00000010
 	MACON3_FULDPX	CON %00000001
	
; MACON4 bits --------
 	MACON4_DEFER	CON %01000000
 	MACON4_BPEN		CON %00100000
 	MACON4_NOBKOFF	CON %00010000
	
; MICMD bits ---------
 	MICMD_MIISCAN	CON %00000010
 	MICMD_MIIRD		CON %00000001

; MISTAT bits --------
 	MISTAT_NVALID	CON %00000100
 	MISTAT_SCAN		CON %00000010
 	MISTAT_BUSY		CON %00000001
	
; EFLOCON bits -----
 	EFLOCON_FULDPXS	CON %00000100
 	EFLOCON_FCEN1	CON %00000010
 	EFLOCON_FCEN0	CON %00000001



; PHY bits

; PHCON1 bits ----------
 	PHCON1_PRST		CON %1000000000000000
 	PHCON1_PLOOPBK	CON %0100000000000000
 	PHCON1_PPWRSV	CON %0000100000000000
 	PHCON1_PDPXMD	CON %0000000100000000

; PHSTAT1 bits --------
 	PHSTAT1_PFDPX	CON %0001000000000000
 	PHSTAT1_PHDPX	CON %0000100000000000
 	PHSTAT1_LLSTAT	CON %0000000000000100
 	PHSTAT1_JBSTAT	CON %0000000000000010

; PHID2 bits --------
 	PHID2_PID24		CON %1000000000000000
 	PHID2_PID23		CON %0100000000000000
 	PHID2_PID22		CON %0010000000000000
 	PHID2_PID21		CON %0001000000000000
 	PHID2_PID20		CON %0000100000000000
 	PHID2_PID19		CON %0000010000000000
 	PHID2_PPN5		CON %0000001000000000
 	PHID2_PPN4		CON %0000000100000000
 	PHID2_PPN3		CON %0000000010000000
 	PHID2_PPN2		CON %0000000001000000
 	PHID2_PPN1		CON %0000000000100000
 	PHID2_PPN0		CON %0000000000010000
 	PHID2_PREV3		CON %0000000000001000
 	PHID2_PREV2		CON %0000000000000100
 	PHID2_PREV1		CON %0000000000000010
 	PHID2_PREV0		CON %0000000000000001

; PHCON2 bits ----------
 	PHCON2_FRCLNK	CON %0100000000000000
 	PHCON2_TXDIS	CON %0010000000000000
 	PHCON2_JABBER	CON %0000010000000000
 	PHCON2_HDLDIS	CON %0000000100000000
  	PHCON2_RXAPDIS 	CON %0000000000010000

; PHSTAT2 bits --------
 	PHSTAT2_TXSTAT	CON %0010000000000000
 	PHSTAT2_RXSTAT	CON %0001000000000000
 	PHSTAT2_COLSTAT	CON %0000100000000000
 	PHSTAT2_LSTAT	CON %0000010000000000
 	PHSTAT2_DPXSTAT	CON %0000001000000000
 	PHSTAT2_PLRITY	CON %0000000000100000

; PHIE bits -----------
 	PHIE_PLNKIE		CON %0000000000010000
 	PHIE_PGEIE		CON %0000000000000010

; PHIR bits -----------
 	PHIR_PLNKIF		CON %0000000000010000
 	PHIR_PGIF		CON %0000000000000100

; PHLCON bits -------
 	PHLCON_LACFG3	CON %0000100000000000
 	PHLCON_LACFG2	CON %0000010000000000
 	PHLCON_LACFG1	CON %0000001000000000
 	PHLCON_LACFG0	CON %0000000100000000
 	PHLCON_LBCFG3	CON %0000000010000000
 	PHLCON_LBCFG2	CON %0000000001000000
 	PHLCON_LBCFG1	CON %0000000000100000
 	PHLCON_LBCFG0	CON %0000000000010000
 	PHLCON_LFRQ1	CON %0000000000001000
 	PHLCON_LFRQ0	CON %0000000000000100
 	PHLCON_STRCH	CON %0000000000000010


; Bit variables associates with in SFRs
 RXEN	 VAR ECON1.2
 TXRTS   VAR ECON1.3
 CSUMEN	 VAR ECON1.4
 DMAST	 VAR ECON1.5
 RXRST	 VAR ECON1.6
 TXRST	 VAR ECON1.7
 STKUNF	 VAR STKPTR.6
 STKFUL	 VAR STKPTR.7
 RBIF	 VAR INTCON.0
 INT0IF	 VAR INTCON.1
 TMR0IF	 VAR INTCON.2
 RBIE	 VAR INTCON.3
 INT0IE	 VAR INTCON.4
 TMR0IE	 VAR INTCON.5
 PEIE	 VAR INTCON.6
 GIE	 VAR INTCON.7
 GIEL	 VAR INTCON.6
 GIEH	 VAR INTCON.7
 RBIP	 VAR INTCON2.0
 INT3IP	 VAR INTCON2.1
 TMR0IP	 VAR INTCON2.2
 INTEDG3 VAR INTCON2.3
 INTEDG2 VAR INTCON2.4
 INTEDG1 VAR INTCON2.5
 INTEDG0 VAR INTCON2.6
 RBPU	 VAR INTCON2.7
 INT1IF	 VAR INTCON3.0
 INT2IF	 VAR INTCON3.1
 INT3IF	 VAR INTCON3.2
 INT1IE	 VAR INTCON3.3
 INT2IE	 VAR INTCON3.4
 INT3IE	 VAR INTCON3.5
 INT1IP	 VAR INTCON3.6
 INT2IP	 VAR INTCON3.7
 CARRY	 VAR STATUS.0
 DC	 	 VAR STATUS.1
 ZERO    VAR STATUS.2
 OV	 	 VAR STATUS.3
 NEGATIVE VAR 	STATUS.4
 T0PS0 VAR 	T0CON.0
 T0PS1 VAR 	T0CON.1
 T0PS2 VAR 	T0CON.2
 PSA VAR 	T0CON.3
 T0SE VAR 	T0CON.4
 T0CS VAR 	T0CON.5
 T08BIT VAR 	T0CON.6
 TMR0ON VAR 	T0CON.7
 SCS0 VAR 	OSCCON.0
 SCS1 VAR 	OSCCON.1
 OSTS VAR 	OSCCON.3
 IDLEN VAR 	OSCCON.7
 SWDTEN VAR 	WDTCON.0
 BOR VAR 	RCON.0
 POR VAR 	RCON.1
 PD VAR 	RCON.2
 RCON_T0 VAR 	RCON.3
 RI VAR 	RCON.4
 IPEN VAR 	RCON.7
 TMR1ON VAR 	T1CON.0
 TMR1CS VAR 	T1CON.1
 T1SYNC VAR 	T1CON.2
 T1OSCEN VAR 	T1CON.3
 T1CKPS0 VAR 	T1CON.4
 T1CKPS1 VAR 	T1CON.5
 T1RUN VAR 	T1CON.6
 T1RD16 VAR 	T1CON.7
 T2CKPS0 VAR 	T2CON.0
 T2CKPS1 VAR 	T2CON.1
 TMR2ON VAR 	T2CON.2
 T2OUTPS0 VAR 	T2CON.3
 T2OUTPS1 VAR 	T2CON.4
 T2OUTPS2 VAR 	T2CON.5
 T2OUTPS3 VAR 	T2CON.6
 BF VAR 	SSP1STAT.0
 UA VAR 	SSP1STAT.1
 RW VAR 	SSP1STAT.2
 START VAR 	SSP1STAT.3
 SSP1STAT_STOP VAR 	SSP1STAT.4
 DA VAR 	SSP1STAT.5
 CKE VAR 	SSP1STAT.6
 SMP VAR 	SSP1STAT.7
 SSPM0 VAR 	SSP1CON1.0
 SSPM1 VAR 	SSP1CON1.1
 SSPM2 VAR 	SSP1CON1.2
 SSPM3 VAR 	SSP1CON1.3
 CKP VAR 	SSP1CON1.4
 SSPEN VAR 	SSP1CON1.5
 SSPOV VAR 	SSP1CON1.6
 WCOL VAR 	SSP1CON1.7
 SEN VAR 	SSP1CON2.0
 RSEN VAR 	SSP1CON2.1
 PEN VAR 	SSP1CON2.2
 RCEN VAR 	SSP1CON2.3
 ACKEN VAR 	SSP1CON2.4
 ACKDT VAR 	SSP1CON2.5
 ACKSTAT VAR 	SSP1CON2.6
 GCEN VAR 	SSP1CON2.7
 ADMSK1 VAR 	SSP1CON2.1
 ADMSK2 VAR 	SSP1CON2.2
 ADMSK3 VAR 	SSP1CON2.3
 ADMSK4 VAR 	SSP1CON2.4
 ADMSK5 VAR 	SSP1CON2.5
 ADON VAR 	ADCON0.0
 GODONE VAR 	ADCON0.1
 CHS0 VAR 	ADCON0.2
 CHS1 VAR 	ADCON0.3
 CHS2 VAR 	ADCON0.4
 CHS3 VAR 	ADCON0.5
 ADCAL VAR 	ADCON0.7
 PCFG0 VAR 	ADCON1.0
 PCFG1 VAR 	ADCON1.1
 PCFG2 VAR 	ADCON1.2
 PCFG3 VAR 	ADCON1.3
 VCFG0 VAR 	ADCON1.4
 VCFG1 VAR 	ADCON1.5
 ADCS0 VAR 	ADCON2.0
 ADCS1 VAR 	ADCON2.1
 ADCS2 VAR 	ADCON2.2
 ACQT0 VAR 	ADCON2.3
 ACQT1 VAR 	ADCON2.4
 ACQT2 VAR 	ADCON2.5
 ADFM VAR 	ADCON2.7
 CCP1M0 VAR 	CCP1CON.0
 CCP1M1 VAR 	CCP1CON.1
 CCP1M2 VAR 	CCP1CON.2
 CCP1M3 VAR 	CCP1CON.3
 DC1B0 VAR 	CCP1CON.4
 DC1B1 VAR 	CCP1CON.5
 P1M0 VAR 	CCP1CON.6
 P1M1 VAR 	CCP1CON.7
 CCP2M0 VAR 	CCP2CON.0
 CCP2M1 VAR 	CCP2CON.1
 CCP2M2 VAR 	CCP2CON.2
 CCP2M3 VAR 	CCP2CON.3
 DC2B0 VAR 	CCP2CON.4
 DC2B1 VAR 	CCP2CON.5
 P2M0 VAR 	CCP2CON.6
 P2M1 VAR 	CCP2CON.7
 CCP3M0 VAR 	CCP3CON.0
 CCP3M1 VAR CCP3CON.1
 CCP3M2 VAR 	CCP3CON.2
 CCP3M3 VAR 	CCP3CON.3
 DC3B0 VAR 	CCP3CON.4
 DC3B1 VAR 	CCP3CON.5
 P3M0 VAR 	CCP3CON.6
 P3M1 VAR 	CCP3CON.7
 PSS1BD0 VAR 	ECCP1AS.0
 PSS1BD1 VAR 	ECCP1AS.1
 PSS1AC0 VAR 	ECCP1AS.2
 PSS1AC1 VAR 	ECCP1AS.3
 ECCP1AS0 VAR 	ECCP1AS.4
 ECCP1AS1 VAR 	ECCP1AS.5
 ECCP1AS2 VAR 	ECCP1AS.6
 ECCP1ASE VAR 	ECCP1AS.7
 CVR0 VAR 	CVRCON.0
 CVR1 VAR 	CVRCON.1
 CVR2 VAR 	CVRCON.2
 CVR3 VAR 	CVRCON.3
 CVRSS VAR 	CVRCON.4
 CVRR VAR 	CVRCON.5
 CVROE VAR 	CVRCON.6
 CVREN VAR 	CVRCON.7
 CM0 VAR 	CMCON.0
 CMEN0 VAR 	CMCON.0
 CM1 VAR 	CMCON.1
 CMEN1 VAR 	CMCON.1
 CM2 VAR 	CMCON.2
 CMEN2 VAR 	CMCON.2
 CIS VAR 	CMCON.3
 C1INV VAR 	CMCON.4
 C2INV VAR 	CMCON.5
 C1OUT VAR 	CMCON.6
 C2OUT VAR 	CMCON.7
 TMR3ON VAR 	T3CON.0
 TMR3CS VAR 	T3CON.1
 T3SYNC VAR 	T3CON.2
 T3CCP1 VAR 	T3CON.3
 T3CKPS0 VAR 	T3CON.4
 T3CKPS1 VAR 	T3CON.5
 T3CCP2 VAR 	T3CON.6
 T3RD16 VAR 	T3CON.7
 PSPMODE VAR 	PSPCON.4
 IBOV VAR 	PSPCON.5
 OBF VAR 	PSPCON.6
 IBF VAR 	PSPCON.7
 TX9D VAR 	TXSTA1.0
 TX9D1 VAR 	TXSTA1.0
 TRMT VAR 	TXSTA1.1
 TRMT1 VAR 	TXSTA1.1
 BRGH VAR 	TXSTA1.2
 BRGH1 VAR 	TXSTA1.2
 SENDB VAR 	TXSTA1.3
 SENDB1 VAR 	TXSTA1.3
 SYNC VAR 	TXSTA1.4
 SYNC1 VAR 	TXSTA1.4
 TXEN VAR 	TXSTA1.5
 TXEN1 VAR 	TXSTA1.5
 TX9 VAR 	TXSTA1.6
 TX91 VAR 	TXSTA1.6
 CSRC VAR 	TXSTA1.7
 CSRC1 VAR 	TXSTA1.7
 RX9D VAR 	RCSTA1.0
 OERR VAR 	RCSTA1.1
 FERR VAR 	RCSTA1.2
 ADDEN VAR 	RCSTA1.3
 CREN VAR 	RCSTA1.4
 SREN VAR 	RCSTA1.5
 RX9 VAR 	RCSTA1.6
 SPEN VAR 	RCSTA1.7
 WR VAR 	EECON1.1
 WREN VAR 	EECON1.2
 WRERR VAR 	EECON1.3
 FREE VAR 	EECON1.4
 CCP3IP VAR 	IPR3.0
 CCP4IP VAR IPR3.1
 CCP5IP VAR 	IPR3.2
 TMR4IP VAR 	IPR3.3
 TX2IP VAR 	IPR3.4
 RC2IP VAR 	IPR3.5
 BCL2IP VAR 	IPR3.6
 SSP2IP VAR 	IPR3.7
 CCP3IF VAR 	PIR3.0
 CCP4IF VAR 	PIR3.1
 CCP5IF VAR 	PIR3.2
 TMR4IF VAR 	PIR3.3
 TX2IF VAR 	PIR3.4
 RC2IF VAR 	PIR3.5
 BCL2IF VAR 	PIR3.6
 SSP2IF VAR 	PIR3.7
 CCP3IE VAR 	PIE3.0
 CCP4IE VAR 	PIE3.1
 CCP5IE VAR 	PIE3.2
 TMR4IE VAR 	PIE3.3
 TX2IE VAR 	PIE3.4
 RC2IE VAR 	PIE3.5
 BCL2IE VAR 	PIE3.6
 SSP2IE VAR 	PIE3.7
 CCP2IP VAR 	IPR2.0
 TMR3IP VAR 	IPR2.1
 BCL1IP VAR 	IPR2.3
 ETHIP VAR 	IPR2.5
 CMIP VAR 	IPR2.6
 OSCFIP VAR 	IPR2.7
 CCP2IF VAR 	PIR2.0
 TMR3IF VAR 	PIR2.1
 BCL1IF VAR 	PIR2.3
 ETHIF VAR 	PIR2.5
 CMIF VAR 	PIR2.6
 OSCFIF VAR 	PIR2.7
 CCP2IE VAR 	PIE2.0
 TMR3IE VAR 	PIE2.1
 BCL1IE VAR 	PIE2.3
 ETHIE VAR 	PIE2.5
 CMIE VAR 	PIE2.6
 OSCFIE VAR 	PIE2.7
 TMR1IP VAR 	IPR1.0
 TMR2IP VAR 	IPR1.1
 CCP1IP VAR 	IPR1.2
 SSP1IP VAR 	IPR1.3
 TX1IP VAR 	IPR1.4
 TXIP VAR 	IPR1.4
 RC1IP VAR 	IPR1.5
 RCIP VAR 	IPR1.5
 ADIP VAR 	IPR1.6
 PSPIP VAR 	IPR1.7
 TMR1IF VAR 	PIR1.0
 TMR2IF VAR PIR1.1
 CCP1IF VAR 	PIR1.2
 SSP1IF VAR 	PIR1.3
 TX1IF VAR 	PIR1.4
 TXIF VAR 	PIR1.4
 RC1IF VAR 	PIR1.5
 RCIF VAR 	PIR1.5
 ADIF VAR 	PIR1.6
 PSPIF VAR 	PIR1.7
 TMR1IE VAR 	PIE1.0
 TMR2IE VAR PIE1.1
 CCP1IE VAR 	PIE1.2
 SSP1IE VAR 	PIE1.3
 TX1IE VAR 	PIE1.4
 TXIE VAR 	PIE1.4
 RC1IE VAR 	PIE1.5
 RCIE VAR 	PIE1.5
 ADIE VAR 	PIE1.6
 PSPIE VAR 	PIE1.7
 WM0 VAR 	MEMCON.0
 WM1 VAR 	MEMCON.1
 WAIT0 VAR 	MEMCON.4
 WAIT1 VAR 	MEMCON.5
 EBDIS VAR 	MEMCON.7
 PPRE VAR 	OSCTUNE.4
 PPST0 VAR 	OSCTUNE.5
 PLLEN VAR 	OSCTUNE.6
 PPST1 VAR 	OSCTUNE.7
 TRISJ0 VAR 	TRISJ.0
 TRISJ1 VAR 	TRISJ.1
 TRISJ2 VAR 	TRISJ.2
 TRISJ3 VAR 	TRISJ.3
 TRISJ4 VAR 	TRISJ.4
 TRISJ5 VAR 	TRISJ.5
 TRISJ6 VAR 	TRISJ.6
 TRISJ7 VAR 	TRISJ.7
 TRISH0 VAR 	TRISH.0
 TRISH1 VAR 	TRISH.1
 TRISH2 VAR 	TRISH.2
 TRISH3 VAR 	TRISH.3
 TRISH4 VAR 	TRISH.4
 TRISH5 VAR 	TRISH.5
 TRISH6 VAR 	TRISH.6
 TRISH7 VAR 	TRISH.7
 TRISG0 VAR 	TRISG.0
 TRISG1 VAR 	TRISG.1
 TRISG2 VAR 	TRISG.2
 TRISG3 VAR 	TRISG.3
 TRISG4 VAR 	TRISG.4
 TRISG5 VAR 	TRISG.5
 TRISG6 VAR 	TRISG.6
 TRISG7 VAR 	TRISG.7
 TRISF0 VAR 	TRISF.0
 TRISF1 VAR 	TRISF.1
 TRISF2 VAR 	TRISF.2
 TRISF3 VAR 	TRISF.3
 TRISF4 VAR 	TRISF.4
 TRISF5 VAR 	TRISF.5
 TRISF6 VAR 	TRISF.6
 TRISF7 VAR 	TRISF.7
 TRISE0 VAR 	TRISE.0
 TRISE1 VAR 	TRISE.1
 TRISE2 VAR 	TRISE.2
 TRISE3 VAR 	TRISE.3
 TRISE4 VAR 	TRISE.4
 TRISE5 VAR 	TRISE.5
 TRISE6 VAR 	TRISE.6
 TRISE7 VAR 	TRISE.7
 TRISD0 VAR 	TRISD.0
 TRISD1 VAR 	TRISD.1
 TRISD2 VAR 	TRISD.2
 TRISD3 VAR 	TRISD.3
 TRISD4 VAR 	TRISD.4
 TRISD5 VAR 	TRISD.5
 TRISD6 VAR 	TRISD.6
 TRISD7 VAR 	TRISD.7
 TRISC0 VAR 	TRISC.0
 TRISC1 VAR 	TRISC.1
 TRISC2 VAR 	TRISC.2
 TRISC3 VAR 	TRISC.3
 TRISC4 VAR 	TRISC.4
 TRISC5 VAR 	TRISC.5
 TRISC6 VAR 	TRISC.6
 TRISC7 VAR 	TRISC.7
 TRISB0 VAR 	TRISB.0
 TRISB1 VAR 	TRISB.1
 TRISB2 VAR 	TRISB.2
 TRISB3 VAR 	TRISB.3
 TRISB4 VAR 	TRISB.4
 TRISB5 VAR 	TRISB.5
 TRISB6 VAR 	TRISB.6
 TRISB7 VAR 	TRISB.7
 TRISA0 VAR 	TRISA.0
 TRISA1 VAR 	TRISA.1
 TRISA2 VAR 	TRISA.2
 TRISA3 VAR 	TRISA.3
 TRISA4 VAR 	TRISA.4
 TRISA5 VAR 	TRISA.5
 LATJ0 VAR 	LATJ.0
 LATJ1 VAR 	LATJ.1
 LATJ2 VAR 	LATJ.2
 LATJ3 VAR 	LATJ.3
 LATJ4 VAR 	LATJ.4
 LATJ5 VAR 	LATJ.5
 LATJ6 VAR 	LATJ.6
 LATJ7 VAR 	LATJ.7
 LATH0 VAR 	LATH.0
 LATH1 VAR 	LATH.1
 LATH2 VAR 	LATH.2
 LATH3 VAR 	LATH.3
 LATH4 VAR 	LATH.4
 LATH5 VAR 	LATH.5
 LATH6 VAR 	LATH.6
 LATH7 VAR 	LATH.7
 LATG0 VAR 	LATG.0
 LATG1 VAR 	LATG.1
 LATG2 VAR 	LATG.2
 LATG3 VAR 	LATG.3
 LATG4 VAR 	LATG.4
 LATG5 VAR 	LATG.5
 LATG6 VAR 	LATG.6
 LATG7 VAR 	LATG.7
 LATF0 VAR 	LATF.0
 LATF1 VAR 	LATF.1
 LATF2 VAR 	LATF.2
 LATF3 VAR 	LATF.3
 LATF4 VAR 	LATF.4
 LATF5 VAR 	LATF.5
 LATF6 VAR 	LATF.6
 LATF7 VAR 	LATF.7
 LATE0 VAR 	LATE.0
 LATE1 VAR 	LATE.1
 LATE2 VAR 	LATE.2
 LATE3 VAR 	LATE.3
 LATE4 VAR 	LATE.4
 LATE5 VAR 	LATE.5
 LATE6 VAR 	LATE.6
 LATE7 VAR 	LATE.7
 LATD0 VAR 	LATD.0
 LATD1 VAR 	LATD.1
 LATD2 VAR 	LATD.2
 LATD3 VAR 	LATD.3
 LATD4 VAR 	LATD.4
 LATD5 VAR 	LATD.5
 LATD6 VAR 	LATD.6
 LATD7 VAR 	LATD.7
 LATC0 VAR 	LATC.0
 LATC1 VAR 	LATC.1
 LATC2 VAR 	LATC.2
 LATC3 VAR 	LATC.3
 LATC4 VAR 	LATC.4
 LATC5 VAR 	LATC.5
 LATC6 VAR 	LATC.6
 LATC7 VAR 	LATC.7
 LATB0 VAR 	LATB.0
 LATB1 VAR 	LATB.1
 LATB2 VAR 	LATB.2
 LATB3 VAR 	LATB.3
 LATB4 VAR 	LATB.4
 LATB5 VAR 	LATB.5
 LATB6 VAR 	LATB.6
 LATB7 VAR 	LATB.7
 LATA0 VAR 	LATA.0
 LATA1 VAR 	LATA.1
 LATA2 VAR 	LATA.2
 LATA3 VAR 	LATA.3
 LATA4 VAR 	LATA.4
 LATA5 VAR 	LATA.5
 REPU VAR 	LATA.6
 RDPU VAR 	LATA.7
 RJ0 VAR 	PORTJ.0
 RJ1 VAR 	PORTJ.1
 RJ2 VAR 	PORTJ.2
 RJ3 VAR 	PORTJ.3
 RJ4 VAR 	PORTJ.4
 RJ5 VAR 	PORTJ.5
 RJ6 VAR 	PORTJ.6
 RJ7 VAR 	PORTJ.7
 RH0 VAR 	PORTH.0
 RH1 VAR 	PORTH.1
 RH2 VAR 	PORTH.2
 RH3 VAR 	PORTH.3
 RH4 VAR 	PORTH.4
 RH5 VAR 	PORTH.5
 RH6 VAR 	PORTH.6
 RH7 VAR 	PORTH.7
 RG0 VAR 	PORTG.0
 RG1 VAR 	PORTG.1
 RG2 VAR 	PORTG.2
 RG3 VAR 	PORTG.3
 RG4 VAR 	PORTG.4
 RG5 VAR 	PORTG.5
 RG6 VAR 	PORTG.6
 RG7 VAR 	PORTG.7
 RF0 VAR 	PORTF.0
 RF1 VAR 	PORTF.1
 RF2 VAR 	PORTF.2
 RF3 VAR 	PORTF.3
 RF4 VAR 	PORTF.4
 RF5 VAR 	PORTF.5
 RF6 VAR 	PORTF.6
 RF7 VAR 	PORTF.7
 RE0 VAR 	PORTE.0
 RE1 VAR 	PORTE.1
 RE2 VAR 	PORTE.2
 RE3 VAR 	PORTE.3
 RE4 VAR 	PORTE.4
 RE5 VAR 	PORTE.5
 RE6 VAR 	PORTE.6
 RE7 VAR 	PORTE.7
 RD0 VAR 	PORTD.0
 RD1 VAR 	PORTD.1
 RD2 VAR 	PORTD.2
 RD3 VAR 	PORTD.3
 RD4 VAR 	PORTD.4
 RD5 VAR 	PORTD.5
 RD6 VAR 	PORTD.6
 RD7 VAR 	PORTD.7
 RC0 VAR 	PORTC.0
 RC1 VAR 	PORTC.1
 RC2 VAR 	PORTC.2
 RC3 VAR 	PORTC.3
 RC4 VAR 	PORTC.4
 RC5 VAR 	PORTC.5
 RC6 VAR 	PORTC.6
 RC7 VAR 	PORTC.7
 RB0 VAR 	PORTB.0
 RB1 VAR 	PORTB.1
 RB2 VAR 	PORTB.2
 RB3 VAR 	PORTB.3
 RB4 VAR 	PORTB.4
 RB5 VAR 	PORTB.5
 RB6 VAR 	PORTB.6
 RB7 VAR 	PORTB.7
 RA0 VAR 	PORTA.0
 RA1 VAR 	PORTA.1
 RA2 VAR 	PORTA.2
 RA3 VAR 	PORTA.3
 RA4 VAR 	PORTA.4
 RA5 VAR 	PORTA.5
 RJPU VAR 	PORTA.7
 ABDEN VAR 	BAUDCON1.0
 WUE VAR 	BAUDCON1.1
 BRG16 VAR 	BAUDCON1.3
 TXCKP VAR 	BAUDCON1.4
 RXDTP VAR 	BAUDCON1.5
 RCIDL VAR 	BAUDCON1.6
 ABDOVF VAR 	BAUDCON1.7
 ABDEN1 VAR 	BAUDCON1.0
 WUE1 VAR 	BAUDCON1.1
 BRG161 VAR 	BAUDCON1.3
 TXCKP1 VAR 	BAUDCON1.4
 RXDTP1 VAR 	BAUDCON1.5
 RCIDL1 VAR 	BAUDCON1.6
 ABDOVF1 VAR 	BAUDCON1.7
 ABDEN2 VAR 	BAUDCON2.0
 WUE2 VAR 	BAUDCON2.1
 BRG162 VAR 	BAUDCON2.3
 TXCKP2 VAR 	BAUDCON2.4
 RXDTP2 VAR 	BAUDCON2.5
 RCIDL2 VAR 	BAUDCON2.6
 ABDOVF2 VAR 	BAUDCON2.7
 P1DC0 VAR 	ECCP1DEL.0
 P1DC1 VAR 	ECCP1DEL.1
 P1DC2 VAR 	ECCP1DEL.2
 P1DC3 VAR 	ECCP1DEL.3
 P1DC4 VAR 	ECCP1DEL.4
 P1DC5 VAR 	ECCP1DEL.5
 P1DC6 VAR 	ECCP1DEL.6
 P1RSEN VAR 	ECCP1DEL.7
 T4CKPS0 VAR 	T4CON.0
 T4CKPS1 VAR 	T4CON.1
 TMR4ON VAR 	T4CON.2
 T4OUTPS0 VAR 	T4CON.3
 T4OUTPS1 VAR 	T4CON.4
 T4OUTPS2 VAR 	T4CON.5
 T4OUTPS3 VAR 	T4CON.6
 CCP4M0 VAR 	CCP4CON.0
 CCP4M1 VAR CCP4CON.1
 CCP4M2 VAR 	CCP4CON.2
 CCP4M3 VAR 	CCP4CON.3
 DC4B0 VAR 	CCP4CON.4
 DC4B1 VAR 	CCP4CON.5
 CCP5M0 VAR 	CCP5CON.0
 CCP5M1	 VAR CCP5CON.1
 CCP5M2 VAR 	CCP5CON.2
 CCP5M3 VAR 	CCP5CON.3
 DC5B0 VAR 	CCP5CON.4
 DC5B1 VAR 	CCP5CON.5
 TX9D2 VAR 	TXSTA2.0
 TRMT2 VAR 	TXSTA2.1
 BRGH2 VAR 	TXSTA2.2
 SENDB2 VAR 	TXSTA2.3
 SYNC2 VAR 	TXSTA2.4
 TXEN2 VAR 	TXSTA2.5
 TX92 VAR 	TXSTA2.6
 CSRC2 VAR 	TXSTA2.7
 RX9D2 VAR 	RCSTA2.0
 OERR2 VAR 	RCSTA2.1
 FERR2 VAR 	RCSTA2.2
 ADDEN2 VAR 	RCSTA2.3
 CREN2 VAR 	RCSTA2.4
 SREN2 VAR 	RCSTA2.5
 RX92 VAR 	RCSTA2.6
 SPEN2 VAR 	RCSTA2.7
 PSS3BD0 VAR 	ECCP3AS.0
 PSS3BD1 VAR 	ECCP3AS.1
 PSS3AC0 VAR 	ECCP3AS.2
 PSS3AC1 VAR 	ECCP3AS.3
 ECCP3AS0 VAR 	ECCP3AS.4
 ECCP3AS1 VAR 	ECCP3AS.5
 ECCP3AS2 VAR 	ECCP3AS.6
 ECCP3ASE VAR 	ECCP3AS.7
 P3DC0 VAR 	ECCP3DEL.0
 P3DC1 VAR 	ECCP3DEL.1
 P3DC2 VAR 	ECCP3DEL.2
 P3DC3 VAR 	ECCP3DEL.3
 P3DC4 VAR 	ECCP3DEL.4
 P3DC5 VAR 	ECCP3DEL.5
 P3DC6 VAR 	ECCP3DEL.6
 P3RSEN VAR 	ECCP3DEL.7
 PSS2BD0 VAR 	ECCP2AS.0
 PSS2BD1 VAR 	ECCP2AS.1
 PSS2AC0 VAR 	ECCP2AS.2
 PSS2AC1 VAR 	ECCP2AS.3
 ECCP2AS0 VAR 	ECCP2AS.4
 ECCP2AS1 VAR 	ECCP2AS.5
 ECCP2AS2 VAR 	ECCP2AS.6
 ECCP2ASE VAR 	ECCP2AS.7
 P2DC0 VAR 	ECCP2DEL.0
 P2DC1 VAR 	ECCP2DEL.1
 P2DC2 VAR 	ECCP2DEL.2
 P2DC3 VAR 	ECCP2DEL.3
 P2DC4 VAR 	ECCP2DEL.4
 P2DC5 VAR 	ECCP2DEL.5
 P2DC6 VAR 	ECCP2DEL.6
 P2RSEN VAR 	ECCP2DEL.7
 BF2 VAR 	SSP2STAT.0
 UA2 VAR 	SSP2STAT.1
 RW2 VAR 	SSP2STAT.2
 START2 VAR 	SSP2STAT.3
 STOP2 VAR 	SSP2STAT.4
 DA2 VAR 	SSP2STAT.5
 CKE2 VAR 	SSP2STAT.6
 SMP2 VAR 	SSP2STAT.7
 SSPM02 VAR 	SSP2CON1.0
 SSPM12 VAR 	SSP2CON1.1
 SSPM22 VAR 	SSP2CON1.2
 SSPM32 VAR 	SSP2CON1.3
 CKP2 VAR 	SSP2CON1.4
 SSPEN2 VAR 	SSP2CON1.5
 SSPOV2 VAR 	SSP2CON1.6
 WCOL2 VAR 	SSP2CON1.7
 SEN2 VAR 	SSP2CON2.0
 RSEN2 VAR 	SSP2CON2.1
 PEN2 VAR 	SSP2CON2.2
 RCEN2 VAR 	SSP2CON2.3
 ACKEN2 VAR 	SSP2CON2.4
 ACKDT2	 VAR SSP2CON2.5
 ACKSTAT2 VAR 	SSP2CON2.6
 GCEN2	 VAR SSP2CON2.7
 ADMSK12 VAR 	SSP2CON2.1
 ADMSK22 VAR 	SSP2CON2.2
 ADMSK32 VAR 	SSP2CON2.3
 ADMSK42 VAR 	SSP2CON2.4
 ADMSK52 VAR 	SSP2CON2.5
 ETHEN VAR 	ECON2.5
 PKTDEC VAR 	ECON2.6
 AUTOINC VAR 	ECON2.7
 PHYRDY VAR 	ESTAT.0
 TXABRT VAR 	ESTAT.1
 RXBUSY VAR 	ESTAT.2
 LATECOL VAR 	ESTAT.4
 BUFER VAR 	ESTAT.6
 RXERIE VAR 	EIE.0
 TXERIE VAR 	EIE.1
 TXERIF VAR	EIR.1
 ETXIE VAR 	EIE.3
 LINKIE VAR 	EIE.4
 DMAIE VAR 	EIE.5
 PKTIE VAR 	EIE.6
 BCEN VAR 	ERXFCON.0
 MCEN VAR 	ERXFCON.1
 HTEN VAR 	ERXFCON.2
 MPEN VAR 	ERXFCON.3
 ;PMEN VAR 	ERXFCON.4
 CRCEN VAR 	ERXFCON.5
 ANDOR VAR 	ERXFCON.6
 UCEN VAR 	ERXFCON.7
 MIIRD VAR 	MICMD.0
 MIISCAN VAR 	MICMD.1
 RSTMII VAR 	MICON.7
 NOBKOFF VAR 	MACON4.4
 BPEN VAR 	MACON4.5
 DEFER VAR 	MACON4.6
 FULDPX VAR 	MACON3.0
 FRMLNEN VAR 	MACON3.1
 HFRMEN VAR 	MACON3.2
 PHDRLEN VAR 	MACON3.3
 TXCRCEN VAR 	MACON3.4
 PADCFG0 VAR 	MACON3.5
 PADCFG1 VAR 	MACON3.6
 PADCFG2 VAR 	MACON3.7
 MARXEN VAR 	MACON1.0
 PASSALL VAR 	MACON1.1
 RXPAUS VAR 	MACON1.2
 TXPAUS VAR 	MACON1.3
 FCEN0 VAR 	EFLOCON.0
 FCEN1 VAR 	EFLOCON.1
 FULDPXS VAR 	EFLOCON.2
 BUSY VAR 	MISTAT.0
 SCAN VAR 	MISTAT.1
 NVALID VAR 	MISTAT.2
