;****************************************************************
;*  18F67J60.INC                                                *
;*                                                              *
;*  By        : Leonard Zerman, Jeff Schmoyer                   *
;*  Notice    : Copyright (c) 2006 microEngineering Labs, Inc.  *
;*              All Rights Reserved                             *
;*  Date      : 06/05/06                                        *
;*  Version   : 2.47                                            *
;*  Notes     : @PB = Modified by Peter Best 05/12/07           *
;****************************************************************
        NOLIST
    ifdef PM_USED
        LIST
        "Error: PM does not support this device.  Use MPASM."
        NOLIST
    else
        LIST
        LIST p = 18F67J60, r = dec, w = -311, f = inhx32
        INCLUDE "P18F67J60.INC"	; MPASM  Header
;==========================================================================
;
;   IMPORTANT: For the PIC18 devices, the __CONFIG directive has been
;              superseded by the CONFIG directive.  The following settings
;              are available for this device.
;
;   Background Debugger Enable bit
      CONFIG DEBUG = ON           ;Background debugger enabled; RB6 and RB7 are dedicated to In-Circuit Debug
; 	  CONFIG DEBUG = OFF          ;Background debugger disabled; RB6 and RB7 configured as general purpose I/O pins
;
;   Extended Instruction Set Enable bit
      CONFIG XINST = OFF          ;Instruction set extension and Indexed Addressing mode disabled (Legacy mode)
;     CONFIG XINST = ON           ;Instruction set extension and Indexed Addressing mode enabled
;
;   Stack Overflow/Underflow Reset Enable bit
;     CONFIG STVR = OFF           ;Reset on stack overflow/underflow disabled
      CONFIG STVR = ON            ;Reset on stack overflow/underflow enabled
;
;   Watchdog Timer Enable bit
      CONFIG WDT = OFF            ;WDT disabled (control is placed on SWDTEN bit)
;     CONFIG WDT = ON             ;WDT enabled
;
;   Code Protection bit
;     CONFIG CP0 = ON             ;Program memory is code-protected
      CONFIG CP0 = OFF            ;Program memory is not code-protected
;
;   Fail-Safe Clock Monitor Enable bit
      CONFIG FCMEN = OFF          ;Fail-Safe Clock Monitor disabled
;     CONFIG FCMEN = ON           ;Fail-Safe Clock Monitor enabled
;
;   Two-Speed Start-up (Internal/External Oscillator Switchover) Control bit
      CONFIG IESO = OFF           ;Two-Speed Start-up disabled
;     CONFIG IESO = ON            ;Two-Speed Start-up enabled
;
;   Default/Reset System Clock Select bit
;     CONFIG FOSC2 = OFF          ;INTRC enabled as system clock when OSCCON<1:0> = 00
      CONFIG FOSC2 = ON           ;Clock selected by FOSC1:FOSC0 as system clock is enabled when OSCCON<1:0> = 00
;
;   Oscillator Selection bits
;     CONFIG FOSC = HS            ;HS oscillator
      CONFIG FOSC = HSPLL         ;HS oscillator, PLL enabled and under software control
;     CONFIG FOSC = EC            ;EC oscillator, CLKO function on OSC2
;     CONFIG FOSC = ECPLL         ;EC oscillator, PLL enabled and under software control, CLKO function on OSC2
;
;   Watchdog Timer Postscale Select bits
;     CONFIG WDTPS = 1            ;1:1
;     CONFIG WDTPS = 2            ;1:2
;     CONFIG WDTPS = 4            ;1:4
;     CONFIG WDTPS = 8            ;1:8
;     CONFIG WDTPS = 16           ;1:16
;     CONFIG WDTPS = 32           ;1:32
;     CONFIG WDTPS = 64           ;1:64
;     CONFIG WDTPS = 128          ;1:128
;     CONFIG WDTPS = 256          ;1:256
;     CONFIG WDTPS = 512          ;1:512
;     CONFIG WDTPS = 1024         ;1:1024
;     CONFIG WDTPS = 2048         ;1:2048
;     CONFIG WDTPS = 4096         ;1:4096
;     CONFIG WDTPS = 8192         ;1:8192
;     CONFIG WDTPS = 16384        ;1:16384
;     CONFIG WDTPS = 32768        ;1:32768
;
;   Ethernet LED Enable bit
;     CONFIG ETHLED = OFF         ;RA0/RA1 function as I/O regardless of Ethernet module status
      CONFIG ETHLED = ON          ;RA0/RA1 are multiplexed with LEDA/LEDB when Ethernet module is enabled and function as I/O when Ethernet is disabled
;
;==========================================================================

        ;CONFIG XINST = OFF
		;CONFIG FOSC = HS	;@PB
		;CONFIG WDT = OFF	;@PB
        NOLIST
    endif
    ifndef TXIF
TXIF	EQU	TX1IF
    endif
        LIST
BLOCK_SIZE	EQU	64
