
; PICBASIC PRO(TM) Compiler 2.60A, (c) 1998, 2010 microEngineering Labs, Inc. All Rights Reserved. 
MPASMWIN_USED			EQU	1

	INCLUDE	"C:\PIC\PBP260A\12F683.INC"


; Define statements.
#define		CCP1_REG		 GPIO
#define		CCP1_BIT		 2
#define		OSC		 8
#define		INTHAND		 INT_CODE                 

RAM_START       		EQU	00020h
RAM_END         		EQU	000BFh
RAM_BANKS       		EQU	00002h
BANK0_START     		EQU	00020h
BANK0_END       		EQU	0007Fh
BANK1_START     		EQU	000A0h
BANK1_END       		EQU	000BFh
EEPROM_START    		EQU	02100h
EEPROM_END      		EQU	021FFh

wsave           		EQU	RAM_START + 000h
R0              		EQU	RAM_START + 001h
R1              		EQU	RAM_START + 003h
R2              		EQU	RAM_START + 005h
R3              		EQU	RAM_START + 007h
R4              		EQU	RAM_START + 009h
R5              		EQU	RAM_START + 00Bh
R6              		EQU	RAM_START + 00Dh
R7              		EQU	RAM_START + 00Fh
R8              		EQU	RAM_START + 011h
_TMR1_OFF_TICKS  		EQU	RAM_START + 013h
_TMR1_OFF_VAL    		EQU	RAM_START + 015h
_TMR1_ON_TICKS   		EQU	RAM_START + 017h
_TMR1_ON_VAL     		EQU	RAM_START + 019h
_DataFlags       		EQU	RAM_START + 01Bh
FLAGS           		EQU	RAM_START + 01Ch
GOP             		EQU	RAM_START + 01Dh
_PicOSC          		EQU	RAM_START + 01Eh
psave           		EQU	RAM_START + 01Fh
RM1             		EQU	RAM_START + 020h
RM2             		EQU	RAM_START + 021h
RR1             		EQU	RAM_START + 022h
RR2             		EQU	RAM_START + 023h
ssave           		EQU	RAM_START + 024h
_ActuS           		EQU	RAM_START + 025h
_Freq            		EQU	RAM_START + 027h
T1              		EQU	RAM_START + 029h
T2              		EQU	RAM_START + 02Bh
_Ticks           		EQU	RAM_START + 02Dh
_TP              		EQU	RAM_START + 02Fh
_uS              		EQU	RAM_START + 031h
_W1              		EQU	RAM_START + 033h
_W2              		EQU	RAM_START + 035h
_ActuSdec        		EQU	RAM_START + 037h
_DutyCycle       		EQU	RAM_START + 038h
_HPWMduty        		EQU	RAM_START + 039h
_LastHPWMduty    		EQU	RAM_START + 03Ah
_Prescaler       		EQU	RAM_START + 03Bh
_SSPWMduty       		EQU	RAM_START + 03Ch
_uSdec           		EQU	RAM_START + 03Dh
wsave1          		EQU	RAM_START + 080h
_PORTL           		EQU	 GPIO
_PORTH           		EQU	 GPIO
_TRISL           		EQU	 TRISIO
_TRISH           		EQU	 TRISIO
_y               		EQU	_TP
_TP??LOWBYTE     		EQU	_TP
#define _SPWMpin         	_GPIO??5
#define _Valid           	_DataFlags??0
#define _SPWMenabled     	_DataFlags??1
#define _SPWMstate       	_DataFlags??2
#define _GIE             	_INTCON??7
#define _PEIE            	_INTCON??6
#define _TMR1IE          	_PIE1??0
#define _TMR1ON          	_T1CON??0
#define _GPIO??5         	 GPIO, 005h
#define _DataFlags??0    	_DataFlags, 000h
#define _DataFlags??1    	_DataFlags, 001h
#define _DataFlags??2    	_DataFlags, 002h
#define _INTCON??7       	 INTCON, 007h
#define _INTCON??6       	 INTCON, 006h
#define _PIE1??0         	 PIE1, 000h
#define _T1CON??0        	 T1CON, 000h

; Constants.
_HPWMfreq        		EQU	04E20h
	INCLUDE	"RETEP_2PWM.MAC"
	INCLUDE	"C:\PIC\PBP260A\PBPPIC14.LIB"

	GOTO?L	_GetOsc

	ASM?

INT_CODE
      if (CODE_SIZE <= 2)
        movwf   wsave              ; copy W to wsave register
        swapf   STATUS,W           ; swap status reg to be saved into W
        clrf    STATUS             ; change to bank 0 regardless of current bank
        movwf   ssave              ; save status reg to a bank 0 register
        movf    PCLATH,w           ; move PCLATH reg to be saved into W reg
        movwf   psave       ;6     ; save PCLATH reg to a bank 0 register
      endif
        
        btfss   PIR1, TMR1IF       ; is TMR1IF set?   Timer1 Interrupt Flag
        GOTO  NoTimerInt           ; No.  Bypass timer load
        btfss   _Valid             ; Is Freq valid?
        GOTO  NoSPWM               ; No.  Halt SPWM
        btfss   _SPWMenabled       ; is Software PWM enabled?
        GOTO  NoSPWM               ; No.  Halt SPWM
                                   ; Yes, then Set output and reload Timer1
        btfss   _SPWMstate         ; Is Output High?
        GOTO  TurnON      ;9/15    ; No.

TurnOFF
        bcf     _SPWMpin            ; Set SPWMpin Low
        bcf     _SPWMstate          ;
        BCF     T1CON,TMR1ON        ; Turn off timer
        MOVF    _TMR1_OFF_VAL,W     ;  1
        ADDWF   TMR1L,F             ;  1    ; reload timer with correct value
        BTFSC   STATUS,C            ;  1/2
        INCF    TMR1H,F             ;  1
        MOVF    _TMR1_OFF_VAL+1,W   ;  1
        ADDWF   TMR1H,F             ;  1
        BSF     T1CON,TMR1ON        ;  1    ; Turn it back on
        GOTO  TimerDone   ;12/27

TurnON  
        bsf     _SPWMpin            ; Set on SPWMpin High
        bsf     _SPWMstate          ;
        bcf     T1CON,TMR1ON        ; Turn off timer
        MOVF    _TMR1_ON_VAL,W      ;  1
        ADDWF   TMR1L,F             ;  1    ; reload timer with correct value
        BTFSC   STATUS,C            ;  1/2
        INCF    TMR1H,F             ;  1
        MOVF    _TMR1_ON_VAL+1,W    ;  1
        ADDWF   TMR1H,F             ;  1
        bsf     T1CON,TMR1ON        ;  1    ; Turn it back on
        GOTO  TimerDone
NoSPWM
        bcf     T1CON,TMR1ON        ; Turn off timer
        bcf     _SPWMpin            ; Idle SPWMpin Low
TimerDone        
        bcf     PIR1, TMR1IF ; 1/28         ; Clear Timer1 Interrupt Flag
NoTimerInt    
        Movf    psave,w             ; Restore the PCLATH reg
        Movwf   PCLATH
        swapf   ssave,w             ; Restore the STATUS reg			
        movwf   STATUS
        swapf   wsave,f
        swapf   wsave,w    ; 6/34   ; Restore W reg
       
    Retfie                          ; Exit the interrupt routine	



	ENDASM?


	LABEL?L	_StartSPWM	
	LOW?T	_SPWMpin
	MOVE?CT	001h, _GIE
	MOVE?CT	001h, _PEIE
	MOVE?CB	0FFh, TMR1H
	MOVE?CB	0FFh, TMR1L

	LABEL?L	_SetSPWM	
	CMPEQ?BCL	_DutyCycle, 000h, _StopSPWM
	CMPGE?BCL	_DutyCycle, 064h, _IdleHigh
	GOSUB?L	_CalcSPWM
	CMPNE?TCL	_Valid, 001h, L00003
	MOVE?CT	001h, _SPWMenabled
	LOOKDOWN?BCLB	_Prescaler, 004h, L00001, _y
	LDRET?C	001h
	LDRET?C	002h
	LDRET?C	004h
	LDRET?C	008h

	LABEL?L	L00001	
	LOOKUP?BCLB	_y, 004h, L00002, _y
	LURET?C	000h
	LURET?C	001h
	LURET?C	002h
	LURET?C	003h

	LABEL?L	L00002	
	SHIFTL?BCW	_y, 004h, T1
	ADD?WCB	T1, 001h, _y
	SUB?CWW	0FFFFh, _TMR1_ON_TICKS, T1
	ADD?WCW	T1, 008h, _TMR1_ON_VAL
	SUB?CWW	0FFFFh, _TMR1_OFF_TICKS, T1
	ADD?WCW	T1, 008h, _TMR1_OFF_VAL
	MOVE?CT	001h, _TMR1IE
	MOVE?BB	_y, T1CON
	GOTO?L	L00004
	LABEL?L	L00003	
	GOTO?L	_StopSPWM
	LABEL?L	L00004	
	RETURN?	

	LABEL?L	_StopSPWM	
	MOVE?CT	000h, _TMR1IE
	MOVE?CT	000h, _TMR1ON
	LOW?T	_SPWMpin
	MOVE?CT	000h, _SPWMstate
	MOVE?CT	000h, _SPWMenabled
	RETURN?	

	LABEL?L	_IdleHigh	
	GOSUB?L	_StopSPWM
	HIGH?T	_SPWMpin
	RETURN?	

	LABEL?L	_CalcSPWM	
	MOVE?CB	001h, _Prescaler
	MOVE?CT	001h, _Valid
	MOVE?CW	000h, _TMR1_ON_TICKS
	MOVE?CW	000h, _TMR1_OFF_TICKS
	MOVE?CW	003E8h, _W2
	MUL?WWW	_W2, _W2, _W1
	DIV32?WW	_Freq, _uS
	CMPNE?WCL	_uS, 0FFFFh, L00005
	MOVE?CT	000h, _Valid
	GOTO?L	_CalcDone
	LABEL?L	L00005	
	MOVE?CB	000h, _uSdec
	CMPGE?WCL	_uS, 01996h, L00007
	MOVE?CW	02710h, _W1
	MUL?WWW	_W1, _W2, _W1
	DIV32?WW	_Freq, _W1
	DIG?WCB	_W1, 000h, _uSdec
	LABEL?L	L00007	

	LABEL?L	_TryPrescaler	
	CMPGE?WCL	_uS, 01996h, L00009
	MUL?WCW	_uS, 00Ah, T1
	ADD?WBW	T1, _uSdec, _W1
	MUL?BCW	_Prescaler, 064h, _TP
	GOTO?L	L00010
	LABEL?L	L00009	
	MOVE?WW	_uS, _W1
	MUL?BCW	_Prescaler, 00Ah, _TP
	LABEL?L	L00010	
	CMPEQ?BCB	_PicOSC, 004h, T1
	CMPGT?BCB	_uSdec, 005h, T2
	LAND?BBW	T1, T2, T2
	CMPF?WL	T2, L00011
	ADD?WCW	_W1, 00Ah, _W1
	LABEL?L	L00011	
	MUL?BCW	_PicOSC, 00Ah, T1
	DIV?WCW	T1, 004h, _W2
	MUL?WWW	_W1, _W2, _Ticks
	DIV32?WW	_TP, _Ticks
	MUL?WCW	_TP, 064h, _TP
	MUL?WWW	_W1, _W2, _W1
	DIV32?WW	_TP, _W1
	DIV?WCW	_Ticks, 064h, T1
	CMPEQ?WWL	T1, _W1, L00013
	MUL?BCB	_Prescaler, 002h, _Prescaler
	CMPLE?BCL	_Prescaler, 008h, L00015
	MOVE?CT	000h, _Valid
	GOTO?L	_CalcDone
	LABEL?L	L00015	
	GOTO?L	_TryPrescaler
	LABEL?L	L00013	
	MUL?WBW	_Ticks, _DutyCycle, _W1
	DIV32?CW	064h, _TMR1_ON_TICKS
	SUB?WWW	_Ticks, _TMR1_ON_TICKS, _TMR1_OFF_TICKS

	LABEL?L	_CalcDone	
	RETURN?	

	LABEL?L	_GetOsc	

	ASM?

    ifdef OSC
       MOVE?CB   OSC, _PicOSC
    else
       MOVE?CB   4, _PicOSC
    endif
  

	ENDASM?

	MOVE?CW	007D0h, _Freq
	MOVE?CB	070h, OSCCON
	MOVE?CB	003h, ANSEL
	MOVE?CB	00Ah, _DutyCycle
	GOSUB?L	_StartSPWM
	HPWM?CCC	001h, 07Fh, _HPWMfreq

	LABEL?L	_Main	
	ADCIN?CB	000h, _HPWMduty
	ADCIN?CB	001h, _SSPWMduty
	CMPEQ?BBL	_HPWMduty, _LastHPWMduty, L00017
	MOVE?BB	_HPWMduty, _LastHPWMduty
	HPWM?CBC	001h, _HPWMduty, _HPWMfreq
	LABEL?L	L00017	
	MUL?BCW	_SSPWMduty, 050h, T1
	DIV?WCW	T1, 00100h, T1
	ADD?WCB	T1, 00Ah, _DutyCycle
	GOSUB?L	_SetSPWM
	GOTO?L	_Main

	END
