'****************************************************************
'*  Name    : SSPWM.INC          Slow Software PWM              *
'*  Author  : Darrel Taylor                                     *
'*  Date    : 5/1/2003                                          *
'*  Version : 1.0                                               *
'*  Notes   :                                                   *
'*          :                                                   *
'****************************************************************

DEFINE INTHAND INT_CODE                 ' Tell PBP Where the code starts on an interrupt

wsave       VAR BYTE    $20     SYSTEM          '$20 Save location for the W register if in bank0
wsave1      VAR BYTE    $A0     SYSTEM          ' Save location for the W register if in bank1
;wsave2      VAR BYTE    $120    SYSTEM          ' Save location for the W register if in bank2
;wsave3      VAR BYTE    $1A0    SYSTEM          ' Save location for the W register if in bank3
ssave       VAR BYTE    Bank0   SYSTEM          ' Save location for the STATUS register
psave       VAR BYTE    Bank0   SYSTEM          ' Save location for the PCLATH register

Freq                var word                    ' SPWM Frequency
W1                  var word                    ' Temporary variable
W2                  var word                    ' Temporary variable
TP                  var word                    ' Temporary variable
y                   var TP.lowbyte              ' Temporary variable shared
uS                  var word                    ' Time for 1 cycle in MicroSeconds
uSdec               var byte                    ' .1us digit
ActuS               var word                    ' Actual cycle time after integer math
ActuSdec            var byte                    ' Actual cycle time .1us digit
Ticks               var word                    ' # of Timer Ticks to = us
PicOSC              var byte Bank0              ' OSC value, Usable in PBP
Prescaler           var byte                    ' Timer1 Prescale value
DutyCycle           var byte   ' As %, 0 - 100   0 = Always Off   100 = Always On
TMR1_ON_TICKS       var word Bank0    ' # of Tmr ticks for On Time
TMR1_OFF_TICKS      var word Bank0    ' # of Tmr ticks for Off Time
TMR1_ON_VAL         var word Bank0    ' # to load TMR1 for On Time
TMR1_OFF_VAL        var word Bank0    ' # to load TMR1 for Off Time

DataFlags           var byte Bank0
Valid               var DataFlags.0   ' 1 if Freq is valid - Set by CalcSPWM:
SPWMenabled         var DataFlags.1   ' shows if SPWM is running or not
SPWMstate           var DataFlags.2   ' Current state of SPWM output high or low

GIE                 var INTCON.7
PEIE                var INTCON.6
TMR1IE              var PIE1.0
TMR1ON              var T1CON.0

goto GetOsc

' ------------------------------------------------------------------------
asm
INT_CODE
      if (CODE_SIZE <= 2)
        movwf   wsave              ; copy W to wsave register
        swapf   STATUS,W           ; swap status reg to be saved into W
        clrf    STATUS             ; change to bank 0 regardless of current bank
        movwf   ssave              ; save status reg to a bank 0 register
        movf    PCLATH,w           ; move PCLATH reg to be saved into W reg
        movwf   psave       ;6     ; save PCLATH reg to a bank 0 register
      endif
        
        btfss   PIR1, TMR1IF       ; is TMR1IF set?   Timer1 Interrupt Flag
        GOTO  NoTimerInt           ; No.  Bypass timer load
        btfss   _Valid             ; Is Freq valid?
        GOTO  NoSPWM               ; No.  Halt SPWM
        btfss   _SPWMenabled       ; is Software PWM enabled?
        GOTO  NoSPWM               ; No.  Halt SPWM
                                   ; Yes, then Set output and reload Timer1
        btfss   _SPWMstate         ; Is Output High?
        GOTO  TurnON      ;9/15    ; No.

TurnOFF
        bcf     _SPWMpin            ; Set SPWMpin Low
        bcf     _SPWMstate          ;
        BCF     T1CON,TMR1ON        ; Turn off timer
        MOVF    _TMR1_OFF_VAL,W     ;  1
        ADDWF   TMR1L,F             ;  1    ; reload timer with correct value
        BTFSC   STATUS,C            ;  1/2
        INCF    TMR1H,F             ;  1
        MOVF    _TMR1_OFF_VAL+1,W   ;  1
        ADDWF   TMR1H,F             ;  1
        BSF     T1CON,TMR1ON        ;  1    ; Turn it back on
        GOTO  TimerDone   ;12/27

TurnON  
        bsf     _SPWMpin            ; Set on SPWMpin High
        bsf     _SPWMstate          ;
        bcf     T1CON,TMR1ON        ; Turn off timer
        MOVF    _TMR1_ON_VAL,W      ;  1
        ADDWF   TMR1L,F             ;  1    ; reload timer with correct value
        BTFSC   STATUS,C            ;  1/2
        INCF    TMR1H,F             ;  1
        MOVF    _TMR1_ON_VAL+1,W    ;  1
        ADDWF   TMR1H,F             ;  1
        bsf     T1CON,TMR1ON        ;  1    ; Turn it back on
        GOTO  TimerDone
NoSPWM
        bcf     T1CON,TMR1ON        ; Turn off timer
        bcf     _SPWMpin            ; Idle SPWMpin Low
TimerDone        
        bcf     PIR1, TMR1IF ; 1/28         ; Clear Timer1 Interrupt Flag
NoTimerInt    
        Movf    psave,w             ; Restore the PCLATH reg
        Movwf   PCLATH
        swapf   ssave,w             ; Restore the STATUS reg			
        movwf   STATUS
        swapf   wsave,f
        swapf   wsave,w    ; 6/34   ; Restore W reg
       
    Retfie                          ; Exit the interrupt routine	

endasm
' ------------------------------------------------------------------------

StartSPWM:  ' Set Freq and DutyCycle before calling
    low SPWMpin     ' Set SPWMpin to Output and idle Low
    GIE = 1
    PEIE = 1
    TMR1H = 255    ' Load TMR1 with 65535, First tick will cause
    TMR1L = 255    ' an interrupt that will load TMR1_???_VAL 

SetSPWM:   ' Set Freq and DutyCycle before calling
    if DutyCycle = 0 then StopSPWM
    if DutyCycle >= 100 then IdleHigh
    gosub CalcSPWM
    if Valid = 1 then
      SPWMenabled = 1
      lookdown Prescaler,[1,2,4,8],y
      lookup y,[0,1,2,3],y
      y = (y << 4) + 1
      TMR1_ON_VAL = 65535 - TMR1_ON_TICKS + 8
      TMR1_OFF_VAL = 65535 - TMR1_OFF_TICKS + 8
      TMR1IE = 1
      T1CON = y     ; Set Timer1 prescaler and turn Timer1 on
    else
      goto StopSPWM 
    endif
return

StopSPWM
    TMR1IE = 0
    TMR1ON = 0
    low SPWMpin             ' Idle output Low
    SPWMstate = 0
    SPWMenabled = 0
return

IdleHigh:                   ' Idle output High
    gosub StopSPWM          ' First, stop the timer
    high  SPWMpin           ' Set output High
return

CalcSPWM:
    Prescaler = 1
    Valid = 1
    TMR1_ON_TICKS = 0
    TMR1_OFF_TICKS = 0

    W2 = 1000    
    W1 = W2 * W2           ' Load internal registers with 1,000,000
    uS = Div32 Freq        ' solves (1/Freq)*1000000  Full Cycle time in uS
    if uS = 65535 then
        Valid = 0
        goto CalcDone
    endif
    uSdec = 0
    if uS < 6550 then      ' get .1uS value
       W1 = 10000
       W1 = W1 * W2        ' 10,000,000
       W1 = Div32 Freq
       uSdec = W1 dig 0
    endif

TryPrescaler:
    if uS < 6550 then
       W1 = uS * 10 + uSdec
       TP = Prescaler * 100
    else
       W1 = uS
       TP = Prescaler * 10
    endif   
    if (PicOsc = 4) and (uSdec > 5) then W1 = W1 + 10
    W2 = PicOSC * 10 / 4
    Ticks = W1 * W2
    Ticks = div32 TP

    TP = TP * 100
    W1 = W1 * W2
    W1 = div32 TP
    if Ticks /100 <> W1 then 
      Prescaler = Prescaler * 2
      if Prescaler > 8 then
        Valid = 0
        goto CalcDone
      endif
      goto TryPrescaler 
    endif
    

    W1 = Ticks * DutyCycle          ' Calc # of Ticks for ON and OFF periods
    TMR1_ON_TICKS = div32 100
    TMR1_OFF_TICKS = Ticks - TMR1_ON_TICKS 
  CalcDone:
return

GetOsc:                  ' Retreive defined OSC value on Reset
  asm
    ifdef OSC
       MOVE?CB   OSC, _PicOSC
    else
       MOVE?CB   4, _PicOSC
    endif
  endasm


