
; PicBasic Pro Compiler 2.42a, (c) 1998, 2002 microEngineering Labs, Inc. All Rights Reserved. 
PM_USED			EQU	1

	INCLUDE	"16F628.INC"


; Define statements.
#define		INTHAND		 _ClockCount    

RAM_START       		EQU	00020h
RAM_END         		EQU	0014Fh
RAM_BANKS       		EQU	00003h
BANK0_START     		EQU	00020h
BANK0_END       		EQU	0007Fh
BANK1_START     		EQU	000A0h
BANK1_END       		EQU	000EFh
BANK2_START     		EQU	00120h
BANK2_END       		EQU	0014Fh
EEPROM_START    		EQU	02100h
EEPROM_END      		EQU	0217Fh

wsave           		EQU	RAM_START + 000h
R0              		EQU	RAM_START + 001h
R1              		EQU	RAM_START + 003h
R2              		EQU	RAM_START + 005h
R3              		EQU	RAM_START + 007h
R4              		EQU	RAM_START + 009h
R5              		EQU	RAM_START + 00Bh
R6              		EQU	RAM_START + 00Dh
R7              		EQU	RAM_START + 00Fh
R8              		EQU	RAM_START + 011h
FLAGS           		EQU	RAM_START + 013h
fsave           		EQU	RAM_START + 014h
GOP             		EQU	RAM_START + 015h
psave           		EQU	RAM_START + 016h
RM1             		EQU	RAM_START + 017h
RM2             		EQU	RAM_START + 018h
RR1             		EQU	RAM_START + 019h
RR2             		EQU	RAM_START + 01Ah
ssave           		EQU	RAM_START + 01Bh
_Days            		EQU	RAM_START + 01Ch
_R0save          		EQU	RAM_START + 01Eh
_R1save          		EQU	RAM_START + 020h
_d1              		EQU	RAM_START + 022h
_d2              		EQU	RAM_START + 023h
_Hours           		EQU	RAM_START + 024h
_Minutes         		EQU	RAM_START + 025h
PB01            		EQU	RAM_START + 026h
_Seconds         		EQU	RAM_START + 027h
_Ticks           		EQU	RAM_START + 028h
_value           		EQU	RAM_START + 029h
wsave1          		EQU	RAM_START + 080h
wsave2          		EQU	RAM_START + 00100h
_PORTL           		EQU	 PORTB
_PORTH           		EQU	 PORTA
_TRISL           		EQU	 TRISB
_TRISH           		EQU	 TRISA
#define _SecondsChanged  	 PB01, 003h
#define _MinutesChanged  	 PB01, 002h
#define _HoursChanged    	 PB01, 001h
#define _DaysChanged     	 PB01, 000h
#define _T1CON_0         	 T1CON, 000h
#define _T1CON_1         	 T1CON, 001h
#define _T1CON_3         	 T1CON, 003h
#define _PIR1_0          	 PIR1, 000h
#define _PIE1_0          	 PIE1, 000h
#define _INTCON_6        	 INTCON, 006h
#define _INTCON_7        	 INTCON, 007h
#define _PORTA_0         	 PORTA, 000h
#define _PORTA_1         	 PORTA, 001h
	INCLUDE	"CLOCK_RT.MAC"
	INCLUDE	"PBPPIC14.LIB"


	ASM?

INT_START  macro
    IF (CODE_SIZE <= 2)
        movwf   wsave            ; copy W to wsave register
        swapf   STATUS,W         ; swap status reg to be saved into W
        clrf    STATUS           ; change to bank 0 regardless of current bank
        movwf   ssave            ; save status reg to a bank 0 register
        movf    PCLATH,w         ; move PCLATH reg to be saved into W reg
        movwf   psave            ; save PCLATH reg to a bank 0 register
	EndIF
    movf      FSR,W              ; move FSR reg to be saved into W reg
    movwf     fsave              ; save FSR reg to a bank 0 register
    endm


	ENDASM?


	ASM?

INT_RETURN   macro
    MOVF    fsave,W              ; Restore the FSR reg 
    MOVWF   FSR
    Movf    psave,w              ; Restore the PCLATH reg
    Movwf   PCLATH
    swapf   ssave,w              ; Restore the STATUS reg			
    movwf   STATUS
    swapf   wsave,f
    swapf   wsave,w              ; Restore W reg
    Retfie                       ; Exit the interrupt routine	
    endm


	ENDASM?

	MOVE?CT	001h, _SecondsChanged
	MOVE?CT	001h, _MinutesChanged
	GOTO?L	_OverElapsed

	ASM?

  IF OSC == 4                       ; Constants for 100hz interrupt from Timer1
TimerConst = 0D8F7h                 ; Executed at compile time only
  EndIF
  If OSC == 8
TimerConst = 0B1E7h
  EndIF
  If OSC == 10
TimerConst = 09E5Fh
  EndIF
  If OSC == 20
TimerConst = 03CB7h
  EndIF
  
; -----------------  ADD TimerConst to TMR1H:TMR1L
ADD2_TIMER   macro
    CHK?RP  T1CON
    BCF     T1CON,TMR1ON           ; Turn off timer
    MOVLW   LOW(TimerConst)        ;  1
    ADDWF   TMR1L,F                ;  1    ; reload timer with correct value
    BTFSC   STATUS,C               ;  1/2
    INCF    TMR1H,F                ;  1
    MOVLW   HIGH(TimerConst)       ;  1
    ADDWF   TMR1H,F                ;  1
    endm

; -----------------  ADD TimerConst to TMR1H:TMR1L and restart TIMER1 
RELOAD_TIMER  macro
    ADD2_TIMER
    BSF     T1CON,TMR1ON           ;  1    ; Turn TIMER1 back on
    CHK?RP  PIR1
    bcf     PIR1, TMR1IF           ; Clear Timer1 Interrupt Flag
    endm

; -----------------  Load TimerConst into TMR1H:TMR1L 
LOAD_TIMER  macro


	ENDASM?

	MOVE?CT	000h, _T1CON_0
	MOVE?CB	000h, TMR1L
	MOVE?CB	000h, TMR1H

	ASM?

    ADD2_TIMER
    endm


	ENDASM?


	LABEL?L	_ClockCount	

	ASM?
 INT_START                    

	ENDASM?


	ASM?
 RELOAD_TIMER                    ; Reload TIMER1

	ENDASM?

	MOVE?WW	R0, _R0save
	MOVE?WW	R1, _R1save
	ADD?BCB	_Ticks, 001h, _Ticks
	CMPNE?BCL	_Ticks, 064h, L00001
	SUB?BCB	_Ticks, 064h, _Ticks
	ADD?BCB	_Seconds, 001h, _Seconds
	MOVE?CT	001h, _SecondsChanged
	CMPNE?BCL	_Seconds, 03Ch, L00003
	ADD?BCB	_Minutes, 001h, _Minutes
	MOVE?CT	001h, _MinutesChanged
	MOVE?CB	000h, _Seconds
	LABEL?L	L00003	
	CMPNE?BCL	_Minutes, 03Ch, L00005
	ADD?BCB	_Hours, 001h, _Hours
	MOVE?CT	001h, _HoursChanged
	MOVE?CB	000h, _Minutes
	LABEL?L	L00005	
	CMPNE?BCL	_Hours, 018h, L00007
	ADD?WCW	_Days, 001h, _Days
	MOVE?CT	001h, _DaysChanged
	MOVE?CB	000h, _Hours
	LABEL?L	L00007	
	LABEL?L	L00001	
	MOVE?WW	_R1save, R1
	MOVE?WW	_R0save, R0

	ASM?
 INT_RETURN                      ; Restore context and return from interrupt

	ENDASM?


	LABEL?L	_StartTimer	
	MOVE?CT	000h, _T1CON_1
	MOVE?CT	000h, _T1CON_3
	MOVE?CT	000h, _PIR1_0
	MOVE?CT	001h, _PIE1_0
	MOVE?CT	001h, _INTCON_6
	MOVE?CT	001h, _INTCON_7
	MOVE?CT	001h, _T1CON_0
	RETURN?	

	LABEL?L	_StopTimer	
	MOVE?CT	000h, _T1CON_0
	RETURN?	

	LABEL?L	_ResetTime	
	MOVE?TW	_T1CON_0, _R0save
	MOVE?CT	000h, _T1CON_0
	MOVE?CB	000h, TMR1L
	MOVE?CB	000h, TMR1H

	ASM?
   LOAD_TIMER                    ; Load TimerConst

	ENDASM?

	MOVE?WT	_R0save, _T1CON_0
	MOVE?CB	000h, _Ticks
	MOVE?CB	000h, _Seconds
	MOVE?CB	000h, _Minutes
	MOVE?CB	000h, _Hours
	MOVE?CW	000h, _Days
	MOVE?CT	001h, _SecondsChanged
	RETURN?	

	LABEL?L	_OverElapsed	
	MOVE?CB	000h, TRISB
	MOVE?CB	0FCh, TRISA
	MOVE?CB	007h, CMCON
	MOVE?CT	000h, _SecondsChanged
	MOVE?CB	000h, _d1
	MOVE?CB	000h, _d2
	MOVE?CB	000h, _value

	LABEL?L	_start	
	CMPNE?TCL	_SecondsChanged, 001h, L00009
	GOSUB?L	_update
	MOVE?CT	000h, _SecondsChanged
	LABEL?L	L00009	
	GOSUB?L	_resetdraw
	MOVE?CT	001h, _PORTA_0
	MOVE?CT	000h, _PORTA_1
	MOVE?BB	_d1, _value
	GOSUB?L	_draw
	GOSUB?L	_resetdraw
	MOVE?CT	001h, _PORTA_1
	MOVE?CT	000h, _PORTA_0
	MOVE?BB	_d2, _value
	GOSUB?L	_draw
	GOTO?L	_start

	LABEL?L	_update	
	CMPNE?BCL	_d1, 009h, L00011
	MOVE?CB	000h, _d1
	CMPNE?BCL	_d2, 005h, L00013
	MOVE?CB	000h, _d2
	GOTO?L	L00014
	LABEL?L	L00013	
	ADD?BCB	_d2, 001h, _d2
	LABEL?L	L00014	
	GOTO?L	L00012
	LABEL?L	L00011	
	ADD?BCB	_d1, 001h, _d1
	LABEL?L	L00012	
	RETURN?	

	LABEL?L	_draw	
	CMPNE?BCL	_value, 000h, L00017
	MOVE?CB	0C0h, PORTB
	GOTO?L	L00016
	LABEL?L	L00017	
	CMPNE?BCL	_value, 001h, L00018
	MOVE?CB	0F9h, PORTB
	GOTO?L	L00016
	LABEL?L	L00018	
	CMPNE?BCL	_value, 002h, L00019
	MOVE?CB	0A4h, PORTB
	GOTO?L	L00016
	LABEL?L	L00019	
	CMPNE?BCL	_value, 003h, L00020
	MOVE?CB	0B0h, PORTB
	GOTO?L	L00016
	LABEL?L	L00020	
	CMPNE?BCL	_value, 004h, L00021
	MOVE?CB	099h, PORTB
	GOTO?L	L00016
	LABEL?L	L00021	
	CMPNE?BCL	_value, 005h, L00022
	MOVE?CB	092h, PORTB
	GOTO?L	L00016
	LABEL?L	L00022	
	CMPNE?BCL	_value, 006h, L00023
	MOVE?CB	083h, PORTB
	GOTO?L	L00016
	LABEL?L	L00023	
	CMPNE?BCL	_value, 007h, L00024
	MOVE?CB	0F8h, PORTB
	GOTO?L	L00016
	LABEL?L	L00024	
	CMPNE?BCL	_value, 008h, L00025
	MOVE?CB	080h, PORTB
	GOTO?L	L00016
	LABEL?L	L00025	
	CMPNE?BCL	_value, 009h, L00026
	MOVE?CB	098h, PORTB
	LABEL?L	L00026	
	LABEL?L	L00016	
	RETURN?	

	LABEL?L	_resetdraw	
	MOVE?CB	0FFh, PORTB
	RETURN?	

	END
