'****************************************************************
'*  Name    : ASM_INTS.PBP                                      *
'*  Author  : Darrel Taylor                                     *
'*  Notice  : Copyright (c) 2003                                *
'*  Date    : JAN 4, 2003                                       *
'****************************************************************

wsave       var byte    $20     SYSTEM          ' location for W if in bank0

' --- IF any of these three lines cause an error ??  Simply Comment them out to fix the problem ----
wsave1      var byte    $A0     SYSTEM          ' location for W if in bank1
wsave2      var byte    $120    SYSTEM          ' location for W if in bank2
'wsave3      var byte    $1A0    SYSTEM          ' location for W if in bank3
' ------------------------------------------------------------------------------

ssave       var byte    BANK0   SYSTEM          ' location for STATUS register
psave       var byte    BANK0   SYSTEM          ' location for PCLATH register
fsave       var byte    BANK0   SYSTEM          ' location for FSR register

Asm
INT_START  macro
    IF (CODE_SIZE <= 2)
        movwf   wsave            ; copy W to wsave register
        swapf   STATUS,W         ; swap status reg to be saved into W
        clrf    STATUS           ; change to bank 0 regardless of current bank
        movwf   ssave            ; save status reg to a bank 0 register
        movf    PCLATH,w         ; move PCLATH reg to be saved into W reg
        movwf   psave            ; save PCLATH reg to a bank 0 register
	EndIF
    movf      FSR,W              ; move FSR reg to be saved into W reg
    movwf     fsave              ; save FSR reg to a bank 0 register
    endm
EndAsm

Asm
INT_RETURN   macro
    MOVF    fsave,W              ; Restore the FSR reg 
    MOVWF   FSR
    Movf    psave,w              ; Restore the PCLATH reg
    Movwf   PCLATH
    swapf   ssave,w              ; Restore the STATUS reg			
    movwf   STATUS
    swapf   wsave,f
    swapf   wsave,w              ; Restore W reg
    Retfie                       ; Exit the interrupt routine	
    endm
EndAsm


