'*****************************************************************************
' ServoPicKit2
' Utilisation de la 44 pin demo board Pickit2
' 2414 Lignes
'*****************************************************************************
'
' 7 leds Bargraph on PortD
' Potentiometer on PortA.0
' Button on PortB.0
' measure input on PORTC.1
' Output signal on PORTC.2

@ ERRORLEVEL - 306

@	__CONFIG _CONFIG1, _DEBUG_ON & _LVP_OFF &_FCMEN_OFF & _IESO_OFF & _BOR_ON & _CP_OFF & _MCLRE_OFF & _PWRTE_ON & _WDT_OFF &_INTRC_OSC_NOCLKOUT
  
@	__CONFIG _CONFIG2, _WRT_OFF & _BOR40V

DEFINE OSC 8 					' Internal osc. 8Mhz
DEFINE BUTTON_PAUSE 18
DEFINE ADC_BITS 10
DEFINE PULSIN_MAX 6000			' 30 ms max frame

ADCON0	 	= %11000001
ADCON1		= %10000000			' Right justified
ANSEL		= %00000001
ANSELH		= %00000000

OPTION_REG	= %10000000

PORTA 	= 0
PORTB	= 0
PORTC	= 0
PORTD 	= %00001000 			' Free PortB.7, central Led lit.

TRISA 	= %11111111
TRISB 	= %00000001
TRISC	= %11111111 'CCP1&2 ( RC2/RC1 ) Default - will follow selected function
TRISD	= 0

Potar		var PORTA.0

Bouton  	var PORTB.0

Signalin	var PORTC.1
Signalout 	var PORTC.2

pos 		var WORD
Value		var WORD
TValue		var WORD

dir 		var BYTE
delay		var BYTE
Buttoncount	var BYTE
I			var BYTE

cycle_		var BIT

Potar_		CON 0
Speed		CON 10
Mintravel	CON 10
Neutral     CON 1500 ' 1300 ( Robbe ), 1500 ( Graupner ), 1520 ( Futaba ), 
					 ' 1600 ( Lextronic ), 1700 ( Multiplex ), 1800 ( Kraft )
ValueN		CON Neutral/5

CLEAR

pos 		= Neutral



ON INTERRUPT GOTO Switch

INTCON 		= %10010000

'*****************************************************************************
mainloop:

SELECT CASE Buttoncount

	'********************************
	CASE 0 '  servo position fixed by pot
	
CASE00:				
			IF ABS( TValue/10 - 511 ) > 50 THEN
			 
				GOSUB ReadPot					'Force default to center

				LOW Signalout
				PULSOUT Signalout, ValueN		'Send servo Signal  
				PAUSE 18						'  !!! 8 Mhz !!!
				GOTO CASE00
				
			ENDIF
					 
			WHILE 1
			
				GOSUB ReadPot
				
				Value = TValue / 10
				Value = Value MIN (Neutral-500)
									
				pos = (Neutral + 500) - Value
	
				GOSUB OutSig
				LOW Signalout
				PULSOUT Signalout, pos /5			'Send servo Signal 
				PAUSE 18							'   !!! 8 Mhz !!!
				
			WEND
				
	'*****************************
	CASE 1 ' Allers et retours, vitesse rgle par potar
	
CASE01:
			FOR pos = pos to (Neutral +500) STEP Value
			
				GOSUB ReadPot
				Value = ( TValue / 200 ) MAX 2		
				GOSUB OutSig
				LOW Signalout
				PULSOUT Signalout, pos /5			'Send servo Signal
				PAUSE 18							'   !!! 8 Mhz !!!
				
				IF ABS(pos - Neutral) < 2 THEN
				
					Pos = Neutral
					GOSUB OutSig					
					
					FOR I = 1 to 25
					
						LOW Signalout
						PULSOUT Signalout, pos /5	'Send servo Signal
						PAUSE 18					'   !!! 8 Mhz !!!
						
					NEXT I
				ENDIF
			NEXT pos
			
			pos = (Neutral+500)
			GOSUB OutSig 
			FOR I = 1 to 25
			
				LOW Signalout
				PULSOUT Signalout, (ValueN+100)			' Send servo Signal 
				PAUSE 18						'    !!! 8 Mhz !!!
				
			NEXT I
		
		
			FOR pos = (Neutral+500) to (Neutral-500) STEP -Value
		
				GOSUB ReadPot
				Value = ( TValue / 200 ) MAX 2
				GOSUB Outsig
				LOW Signalout
				PULSOUT Signalout, pos /5			'Send servo Signal 
				PAUSE 18							' !!! 8 Mhz !!!
				
				IF ABS(pos - Neutral) < 2 THEN
				
					Pos = Neutral
					GOSUB OutSig					
					
					FOR I = 1 to 25
					
						LOW Signalout
						PULSOUT Signalout, pos /5	' Send servo Signal 
						PAUSE 18					'  !!! 8 Mhz !!!
						
					NEXT I
				ENDIF	
			NEXT pos

			pos = (Neutral-500)
			GOSUB OutSig 			
			FOR I = 1 to 25
			
				LOW Signalout
				PULSOUT Signalout, (ValueN-100)	' Send servo Signal 
				PAUSE 19						'   !!! 8 Mhz !!!
				
			NEXT I			
			
		GOTO CASE01
	
	'***********************************		
	CASE 2 ' Back and forth, fixed speed, symmetrical travel fixed by pot
	
    	WHILE 1        
			
			GOSUB ReadPot 							' read 10 travel samples
				
			Value = ( TValue / 20 )MAX Mintravel	' half Travel  500s max
			
			FOR Pos = Neutral to (Neutral + Value) Step Speed 
						
				GOSUB OutSig
				LOW Signalout
				PULSOUT Signalout, pos /5			'Send servo Signal 
				PAUSE 18                            ' !!! 8 Mhz !!!
				
			NEXT Pos
			
			GOSUB ReadPot							' update travel
			Value = ( TValue / 20 ) MAX Mintravel				
			
			FOR pos = (Neutral + Value) to (Neutral - Value ) STEP - Speed
		

				GOSUB Outsig
				LOW Signalout
				PULSOUT Signalout, pos /5			'Send servo Signal
				PAUSE 18 							' !!! 8 Mhz !!!
				
			NEXT pos

			GOSUB ReadPot 							' read 10 travel samples
				
			Value = ( TValue / 20 )MAX Mintravel	' half Travel  500s max
			
			FOR Pos = (Neutral - Value) to Neutral Step Speed 
						
				GOSUB OutSig
				LOW Signalout
				PULSOUT Signalout, pos /5			'Send servo Signal
				PAUSE 18                            ' !!! 8 Mhz !!!
				
			NEXT Pos
			
		WEND	
	
	
	'***********************************
	CASE 3 ' Signal Measuring ,
	
			Value = 0
						
			WHILE 1
			
					PULSIN Signalin, 1, Value
					
					IF Value < (ValueN-100) OR Value > (ValueN+100) THEN 
					
						GOSUB OutofRange
						
					ELSE
								
					    Pos = Value*5
						GOSUB Outsig
					
					ENDIF
					
			WEND
			
	
END SELECT

Goto Mainloop 

'*****************************************************************************
'*****************************************************************************
' Subroutines
'*****************************************************************************
'*****************************************************************************

Outsig:

SELECT CASE pos			' Bargraph ON

	Case (Neutral -500)
	
		PortD = %01100001

	Case is <= (Neutral -423)'1077
	
		PortD = %01000000
		
	Case is <= (Neutral - 346 )'1154
	
		PortD = %01100000
		
	Case is <= (Neutral - 269 )'1231
	
		PortD = %00100000
		
	Case is <= (Neutral - 192 )'1308
	
		PortD = %00110000
		
	Case is <= (Neutral - 115 )'1385	
	
		PortD = %00010000
		
	Case is <= (Neutral - 38 )'1462
	
		PortD = %00011000
		
	Case is < (Neutral - 2 )'1498
	
		PortD = %01001000
		
'*****************************************************************************		
	Case is < (Neutral + 3)					' Center position
	
		PortD = %01001001
'*****************************************************************************
			
	Case is <= (Neutral + 39 )'1539
	
		PortD = %00001001
		
	Case is <= (Neutral + 116 )'1616
	
		PortD = %00001100
		
	Case is <= (Neutral + 193 )'1693
	
		PortD = %00000100
	
	Case is <= (Neutral + 270 )'1770
	
		PortD = %00000110
			
	Case is <= (Neutral + 347 )'1847
	
		PortD = %00000010
		
	Case is <= (Neutral + 423 )'1923
	
		PortD = %00000011
		
	Case is < (Neutral + 500)'2000
	
		PortD = %00000001
		
	Case (Neutral + 500)'2000
	
		PortD = %01000011
		
END SELECT
		
RETURN

'******************************************************************************
'******************************************************************************
OutofRange:

IF Value >= 130 AND Value <= 470 THEN ' si 650-1000 s ou 2000-2350 s
	
	Value = Value * 5

	SELECT CASE Value			'Allumage Bargraph
	
'******************************************************************************
' Signal < 1000 s
'******************************************************************************
	
		Case is < (Neutral - 300 )'700
		
			PortD = %11000000
	
		Case is <= (Neutral - 250 )'750
		
			PortD = %10100000
			
		Case is <= (Neutral -200 )'800
		
			PortD = %10010000
			
		Case is <= (Neutral -150 )'850
		
			PortD = %10001000
			
		Case is <= (Neutral -100 )'900
		
			PortD = %10000100
			
		Case is <= (Neutral - 50 )'950	
		
			PortD = %10000010
			
		Case is <= Neutral 
		
			PortD = %10000011
				
'*****************************************************************************		
' Signal > 2000 s
'*****************************************************************************
				
		Case is <= (Neutral + 50 )'2050
		
			PortD = %11000001
			
		Case is <= (Neutral + 100 )'2100
		
			PortD = %01000001
			
		Case is <= (Neutral + 150 )'2150
		
			PortD = %00100001
		
		Case is <= (Neutral + 200 )'2200
		
			PortD = %00010001
				
		Case is <= (Neutral + 250)'2250
		
			PortD = %00001001
			
		Case is <= (Neutral + 300 )'2300
		
			PortD = %00000101
			
		Case is <= (Neutral + 350 )'2350
		
			PortD = %00000011
			
	END SELECT
	
ELSE

'******************************************************************************
' Wrong signal
'******************************************************************************
    
    IF Value <> 0 THEN
    
    	PORTD = %01011010					'Out of range
    	
	ELSE
	
		PORTD = 255							' Not a R/C signal 
		
	ENDIF
	
	Delay = (Delay + 1)// 4
	
	IF Delay = 0 THEN PORTD = PORTD ^ 255	' Blink the leds
		
ENDIF
			
RETURN

'******************************************************************************
'******************************************************************************
ReadPot:

TValue = 0

FOR I = 1 to 10
	ADCIN Potar_, Value
	TValue = TValue + Value
NEXT I


RETURN

'******************************************************************************
'******************************************************************************
DISABLE
Switch: 						' Traitement interruption

IF Bouton THEN 					' some bouncing or real push ???
   PAUSE 150
   IF Bouton THEN Bailout
ENDIF

	TRISC = 255                 ' signal output OFF
	
	CCP1CON = CCP1CON & $F0		' Stop CCPs activity
	CCP2CON = CCP2CON & $F0
	
	Buttoncount = ( Buttoncount + 1 )//4
	
	SELECT CASE Buttoncount
	
		CASE 0
				PORTD = %00001000
				
		CASE 1
				PORTD = %00001100
				
		CASE 2 
				PORTD = %00011100
				
		CASE 3 
				PORTD = %00011110
				
	END SELECT
	
	WHILE ! Bouton : WEND  		' Wait for Button release
	Pos 	= Neutral
	INTCON.1 = 0
	
RESUME MainLoop
	
Bailout:

	INTCON.1 = 0
	RESUME

ENABLE

END

