'
' Read a file from a MultiMedia Card formatted as FAT16
'
' For 16-bit (18F) devices only using version 3.1.6 onwards of the PROTON+ compiler
'
'	
' MMC Card Declarations      
'
	Symbol MMC_SDO = PORTC.5		' SPI DO to MMC DI
    Symbol MMC_SDI = PORTC.4		' SPI DI to MMC DO
    Symbol MMC_CLK = PORTC.3		' SPI CLK to MMC CLK
    Symbol MMC_CS = PORTC.0			' SPI CS to MMC CS  
'
' MMC variables
'
	Dim MMC_COMMAND as Byte SYSTEM
    Dim MMC_ADDRESS as Dword SYSTEM
    Dim MMC_BYTEOUT as Byte SYSTEM
    Dim MMC_CRC as Byte SYSTEM
    Dim MMC_BYTEIN as Byte SYSTEM
    Dim MMC_RESPONSE_REQ as Byte SYSTEM
    Dim MMC_INIT_TIMEOUT as MMC_BYTEOUT				' Re-use MMC_BYTEOUT as the INIT subroutine's timeout outer loop
    Dim MMC_TIMEOUT as Byte SYSTEM
    
    Dim MMC_FLAGS as Byte SYSTEM
    Dim MMC_INIT_STATUS as MMC_FLAGS.0
    Dim MMC_READ_STATUS as MMC_FLAGS.1
    Dim MMC_COMMAND_RETURN as PRODL				' Return value from the MMC_COMMAND subroutine
    Dim MMC_SKIP_LOOP as Byte SYSTEM
                    
    Dim MMC_SKIP_COUNT as WREG
    
	Dim BPB_START_SECTOR as Word SYSTEM
	Dim BPB_RES_SECTOR_COUNT as Word
	Dim BPB_FAT_START as Word               			' Starting Sector of the FAT
	Dim BPB_NUM_FATS as Byte SYSTEM               		' Number of FATs
	Dim BPB_SECTORS_PER_CLUSTER as Byte      			' Number of sectors per cluster (should be 4 or 8)
	Dim BPB_FAT_SIZE as Word                			' Size of FAT	
	Dim BPB_ROOT_DIR_ENTRY_COUNT as Word
    
    Dim SECTOR_READ_LOOP as BPB_START_SECTOR 
    Dim FAT_BYTEOUT as BPB_NUM_FATS

	Dim FAT_START_SECTOR as Word
    Dim FAT_FIRST_DATA_SECTOR as Word        			' Data starting sector
	Dim FAT_ROOT_DIR_START_SECTOR as Word     			' First sector of root directory
	Dim FAT_ROOT_DIR_NUM_SECTORS as Word      			' Number of sectors allocated to root directory

	Dim CWD_CURRSECTOR as DWord SYSTEM
	Dim CWD_CURR_SECTOR_NUM_IN_CLUSTER as Byte
    Dim CWD_FILENUMBER as Word SYSTEM
    Dim CWD_RESPONSE as Byte SYSTEM
'
' Current File state
'
	Dim FAT_FILE_ATTR as Byte
	Dim FILE_START_CLUSTER as Word
	Dim FILE_CURRENT_CLUSTER as Word SYSTEM
	Dim FAT_FILESIZE as DWord
	Dim FILE_CURR_SECTOR_NUMIN_CLUSTER as Byte SYSTEM
	Dim FILE_CURRENT_BYTE as DWord
	Dim FAT_FILE_NUMBER as Word SYSTEM
	Dim FAT_BYTEIN as Byte SYSTEM
    Dim FAT_FREESPACE as DWord

    Dim LIST_RESPONSE as Byte SYSTEM

	Dim MMC_IS_INSERTED as Bit 								' MMC card state
    Dim FAT_RESPONSE as Bit
    Dim STARTED_LISTING_DIR as Bit
    
    Dim PP7 as Dword SYSTEM
    Dim CURRENT_SECTOR as PP7								' The sector we're currently reading/writing
	Dim PP0 as Word SYSTEM
    Dim FAT_ENTRY as PP0
     
	Dim LIST_INNER_LOOP as FAT_FILE_NUMBER					' Alias to variable FAT_FILE_NUMBER
    Dim LIST_OUTER_LOOP as CWD_FILENUMBER					' Alias to variable CWD_FILENUMBER
    Dim FAT_INNER_LOOP as Word
    
    Dim SECTOR_BYTE_COUNTER as Word SYSTEM					' Counts the bytes read from the sector
    Dim SECTOR_FINISH_LOOP as Word SYSTEM					' Forms a loop to read the remaining bytes from the sector

WARNINGS = OFF   
    RESERVE_RAM 1024										' Reserve some RAM at the top of memory 
    Dim FAT_FILENAME as String * 12 at __START_OF_RESERVE_RAM
	Dim FAT_INTERNAL_FILENAME as String * 12 at __START_OF_RESERVE_RAM + 14
	Dim SECTOR_BUFFER1[512] as Byte at __START_OF_RESERVE_RAM		' \ Two specially large arrays for play buffers
    Dim SECTOR_BUFFER2[512] as Byte at __START_OF_RESERVE_RAM + 512	' /
WARNINGS = ON
'
' WAV File Info aliased to the very first sector read from the WAV file
'
	Dim WAV_SIZE_DUM as SECTOR_BUFFER1#4
    Dim WAV_SIZE_DUMH as SECTOR_BUFFER1#5
    Dim WAV_SIZE_DUMHH as SECTOR_BUFFER1#6
    Dim WAV_SIZE_DUMHHH as SECTOR_BUFFER1#7
    Dim WAV_SIZE as WAV_SIZE_DUM.Dword
    
    Dim WAV_NUMBER_OF_CHANNELS as SECTOR_BUFFER1#22
    Dim WAV_SAMPLE_DUM as SECTOR_BUFFER1#24
    Dim WAV_SAMPLE_DUMH as SECTOR_BUFFER1#25
    Dim WAV_SAMPLE_RATE as WAV_SAMPLE_DUM.Word
    
    Dim WAV_BITS_PER_SAMPLE as SECTOR_BUFFER1#34
    
    Dim FAT_FSR0 as FSR0L.Word
    Dim FAT_FSR1 as FSR1L.Word

    Symbol FAT_IS_DIR = $10
	Symbol FAT_END_OF_DIR = $02
	Symbol FAT_FILE_DELETED  = $E5
	Symbol FAT_LONG_FILENAME = $03
'
' MMC Commands
'    
    Symbol MMC_CMD0 = $40									' GO_IDLE_STATE Resets the MultiMediaCard
	Symbol MMC_CMD1 = $41									' SEND_OP_COND Activates the cards initialization process.
	Symbol MMC_CMD17 = $51									' READ_SINGLE_BLOCK Reads a block of 512 bytes
    
UNSIGNED_DWORDS = ON										' Turn off the extra code for signed DWORD variables    
'--------------------------------------------------------------------------------------------    
    Goto OVER_FAT_READ_SUBS									' Jump over the subroutines
 
    Include "SPI_MODE0.INC"									' Load the fast bit-bashed SPI macros into memory
    
REMINDERS = OFF
'--------------------------------------------------------------------------------------------
' Initialise the MMC card
'
' Input		: None
' Output	: MMC_INIT_STATUS will return 0 if an error occured
' Notes		: Once the unit is powered up with the MultiMedia Card inserted
'			: this subroutine will initialise it to SPI Mode. 
'			: The initialisation process is as follows:
'			   Send 80 clock pulses to start bus communication.
'			   Assert the Chip Select pin active low.
'			   Send CMD0 (GO_IDLE_STATE)
'			   Wait for a valid response
'			   Send CMD1 (SEND_OP_CONDITION)
'			   Wait for a valid response
'			   Repeat from CMD1 until response shows ready
'
MMC_INIT:
    MMC_INIT_STATUS = 0									' Default to an ERROR status
    High MMC_CS											' Set CS line as Output high
    Low MMC_SDO											' Set SDO (DataOut) line as Output Low
    Low MMC_CLK											' Set CLK line as Output low
    Input MMC_SDI                                      	' Set SDI (DataIn) line as an Input  
    MMC_RESPONSE_REQ = 0								' We're looking for a response of 0 from the MMC_COMMAND subroutine
    MMC_COMMAND = $FF : MMC_ADDRESS = $FF : MMC_CRC = $FF : Gosub MMC_SEND_COMMAND
    MMC_RESPONSE_REQ = 1								' We're looking for a response of 1 from the MMC_COMMAND subroutine
    Clear MMC_CS										' \
    MMC_COMMAND = MMC_CMD0								'  \
    MMC_ADDRESS = 0										'    Place the MMC into SPI mode
    MMC_CRC = $95										'  /  
    Gosub MMC_SEND_COMMAND								' /
    If MMC_COMMAND_RETURN = MMC_RESPONSE_REQ Then
    	MMC_RESPONSE_REQ = 0					
        MMC_INIT_TIMEOUT = 255
MMC_INIT_TIMEOUT_LOOP:        							' Create a timeout loop
        	MMC_COMMAND = MMC_CMD1 : MMC_ADDRESS = 0 : MMC_CRC = $FF : Gosub MMC_SEND_COMMAND									
    		If MMC_COMMAND_RETURN = MMC_RESPONSE_REQ Then
    			SPI_OUT0 $FF							' Send 1 byte for delay
    			MMC_INIT_STATUS = 1						' Indicate a good initialise
    			Goto EXIT_MMC_INIT						' Exit the loop
    		Endif
    	Djnz MMC_INIT_TIMEOUT,MMC_INIT_TIMEOUT_LOOP
    Endif
EXIT_MMC_INIT:
    Set MMC_CS											' Bring the CS line high
    Return  
'--------------------------------------------------------------------------------------------
' Point to a sector within the MMC card for reading
'
' Input		: CURRENT_SECTOR Points to the sector to read
' Output	: MMC_READ_STATUS will return 0 if an error occured
' Notes		: A sector read operation must follow this subroutine 
'  
MMC_SECTOR_READ:
'
' Read the remaining bytes in the sector
'    
    If SECTOR_BYTE_COUNTER != 512 Then
    	SECTOR_FINISH_LOOP = 512 - SECTOR_BYTE_COUNTER
        While SECTOR_FINISH_LOOP > 0
        	SPI_IN0
      		Dec SECTOR_FINISH_LOOP
		Wend       
	Endif
MMC_READ_SECTOR_WITH_BYPASS:
    SPI_IN0												' \ Read the CRC and discard it
    SPI_IN0												' /
    Set MMC_CS   										' Bring the CS line high                                                  
	SPI_OUT0 $FF										' Clock the MMC
    
    Clear SECTOR_BYTE_COUNTER							' Clear the sector byte counter
    MMC_READ_STATUS = 0    								' Default to an ERROR status
    MMC_RESPONSE_REQ = 0
    Clear MMC_CS
    MMC_COMMAND = MMC_CMD17: MMC_ADDRESS = CURRENT_SECTOR << 9: MMC_CRC = $FF: Gosub MMC_SEND_COMMAND   
	If MMC_COMMAND_RETURN = MMC_RESPONSE_REQ Then
		MMC_TIMEOUT = 255
MMC_SECTOR_READ_LOOP:
    		MMC_COMMAND_RETURN = SPI_IN0
        	If MMC_COMMAND_RETURN.0 = 0 Then MMC_READ_STATUS = 1: Return
    	Djnz MMC_TIMEOUT,MMC_SECTOR_READ_LOOP
	Endif
    Set MMC_CS												' Bring the CS line high
    Return
'--------------------------------------------------------------------------------------------
' Send a command to the MMC card
'
' Input		: MMC_COMMAND holds the single byte command to send to the card
'			: MMC_ADDRESS holds the 4-byte address to send to the card
'			: MMC_CRC holds the single byte CRC to send to the card
' Output	: MMC_COMMAND_RETURN (PRODL) will hold the response from the card
'			: Otherwise it will return holding 255 if an error occured
' Notes		:
'
MMC_SEND_COMMAND: 
    SPI_OUT0 MMC_COMMAND
    SPI_OUT0 MMC_ADDRESS.Byte3
    SPI_OUT0 MMC_ADDRESS.Byte2
    SPI_OUT0 MMC_ADDRESS.Byte1
    SPI_OUT0 MMC_ADDRESS.Byte0
    SPI_OUT0 MMC_CRC
                 
    MMC_TIMEOUT = 255
MMC_COMMAND_TIMEOUT_LOOP:
    	MMC_COMMAND_RETURN = SPI_IN0
        If MMC_COMMAND_RETURN = MMC_RESPONSE_REQ Then Return
    Djnz MMC_TIMEOUT,MMC_COMMAND_TIMEOUT_LOOP
    MMC_COMMAND_RETURN = 255								' If we reached here indicate an error condition
    Return 
'----------------------------------------------------------------------------------------------------------
' After enabling the card, use this to extract the drive info and find the FAT and ROOT directory
' Returns with FAT_RESPONSE holding 0 if a card is not inserted or the card cannot be read
'
' Notes		: In order to save code space, it assumes that there are 512 bytes per sector
'
FAT_INIT MACRO
		Gosub __FAT_INIT
	ENDM

__FAT_INIT:
    
    Delayms 100
    STARTED_LISTING_DIR = 0
    Gosub MMC_INIT												' Initialise the MMC card
    FAT_RESPONSE = 1											' Default to everything OK
    If MMC_INIT_STATUS = 0 Then
    	FAT_RESPONSE = 0
        Return
    Endif
'
' Get the Master Boot Record
' 
    SECTOR_BYTE_COUNTER = 0
    CURRENT_SECTOR = 0: Gosub MMC_SECTOR_READ
'
' Go to the first MBR record
'
  	MMC_SKIP_COUNT = $E3: Gosub MMC_SKIP_BYTES
    MMC_SKIP_COUNT = $E3: Gosub MMC_SKIP_BYTES
'
' Read the boot sector location from Master Boot Record
'
  	BPB_START_SECTOR = SPI_IN0 1          			
  	CURRENT_SECTOR = BPB_START_SECTOR : Gosub MMC_SECTOR_READ
  	MMC_SKIP_COUNT = 13: Gosub MMC_SKIP_BYTES 							' Skip jumpboot, OEM Name and bytes per sector 
	
    BPB_SECTORS_PER_CLUSTER = SPI_IN0 1
	BPB_RES_SECTOR_COUNT = SPI_IN0 1
	BPB_NUM_FATS = SPI_IN0 1
	BPB_ROOT_DIR_ENTRY_COUNT = SPI_IN0 1
  	MMC_SKIP_COUNT = 3: Gosub MMC_SKIP_BYTES  							' Skip total number of sectors and media 
  	BPB_FAT_SIZE = SPI_IN0 1
'
' Uncomment for a dignaostic of the FAT format
'    
    'Hrsout "START SECTOR = ", Dec BPB_START_SECTOR,13
    'Hrsout "SECTORS PER CLUSTER = ", Dec BPB_SECTORS_PER_CLUSTER,13
    'Hrsout "NUM OF FATS = ", Dec BPB_NUM_FATS,13
    'Hrsout "ROOT_DIR_ENTRY_COUNT = ", Dec BPB_ROOT_DIR_ENTRY_COUNT,13
    'Hrsout "FAT SIZE = ", Dec BPB_FAT_SIZE,13   
'
' Calculate the location of the FAT and ROOT directory
'
  	FAT_START_SECTOR = BPB_START_SECTOR + BPB_RES_SECTOR_COUNT
	FAT_ROOT_DIR_NUM_SECTORS = BPB_ROOT_DIR_ENTRY_COUNT * 32
	FAT_ROOT_DIR_NUM_SECTORS = FAT_ROOT_DIR_NUM_SECTORS + 511			' \
	FAT_ROOT_DIR_NUM_SECTORS = FAT_ROOT_DIR_NUM_SECTORS / 512			' / Assumes 512 bytes per sector   
	FAT_ROOT_DIR_START_SECTOR = BPB_NUM_FATS * BPB_FAT_SIZE
	FAT_ROOT_DIR_START_SECTOR = FAT_ROOT_DIR_START_SECTOR + FAT_START_SECTOR
	FAT_FIRST_DATA_SECTOR = FAT_ROOT_DIR_START_SECTOR + FAT_ROOT_DIR_NUM_SECTORS
	Return 

'----------------------------------------------------------------------------------------------------------
' Find the sector of the current file and place it into SECTOR_BUFFER1
'
' Input		: None
' Output	: Array SECTOR_BUFFER1 holds the sector read
'			: FAT_RESPONSE holds 0 when End Of File reached
'			: PRODL holds the contents of the last byte in the buffer
' Notes		: Jumps to routine "LOAD_THE_BUFFER"
'
FAT_READ_SECTOR1:  
    FAT_FSR0 = Varptr SECTOR_BUFFER1									' Point FSR0L\H to the start of SECTOR_BUFFER1
	Goto LOAD_THE_BUFFER												' Load the sector into the buffer
    
'----------------------------------------------------------------------------------------------------------
' Find the sector of the current file and place it into SECTOR_BUFFER2
'
' Input		: None
' Output	: Array SECTOR_BUFFER2 holds the sector read
'			: FAT_RESPONSE holds 0 when End Of File reached
'			: PRODL holds the contents of the last byte in the buffer
' Notes		: None
'
FAT_READ_SECTOR2:     
    FAT_FSR0 = Varptr SECTOR_BUFFER2									' Point FSR0L\H to the start of SECTOR_BUFFER2
'
' Actually load the buffer pointed to by FAT_FSR0
'
LOAD_THE_BUFFER:
	Gosub LOCATE_SECTOR													' Locate the sector to load 
    FAT_RESPONSE = 1													' Default to End Of File not found
    For FAT_INNER_LOOP = 511 to 0 Step -1								' Form a loop for all the bytes in the buffer. i.e. 512
		Inc FILE_CURRENT_BYTE											' Increment the overall byte count     
		POSTINC0 = SPI_IN0    											' Read a byte from the MMC and place it into the buffer 
    Next
    If FILE_CURRENT_BYTE >= FAT_FILESIZE Then 							' Have we reached End Of File ?
        FAT_RESPONSE = 0												' Yes. So Indicate End Of File reached
    Endif
	Return
    
'----------------------------------------------------------------------------------------------------------
' Locate the sector to load
'
' Input		: None
' Output	: None
' Notes		: Part of the FAT_READ_SECTORx subroutines
'
LOCATE_SECTOR:
'
' Get the current sector indicated
'
	If FILE_CURR_SECTOR_NUMIN_CLUSTER = BPB_SECTORS_PER_CLUSTER Then
		CURRENT_SECTOR = FILE_CURRENT_CLUSTER / 256
        CURRENT_SECTOR = CURRENT_SECTOR + FAT_START_SECTOR  			' Find the FAT sector to read (cluster * 2) / 512)
		Gosub MMC_READ_SECTOR_WITH_BYPASS								' Point to the sector within the MMC
		MMC_SKIP_COUNT = FILE_CURRENT_CLUSTER.Lowbyte: Gosub MMC_SKIP_BYTES  ' Skip over that many entries (each entry is 16-bits)
		MMC_SKIP_COUNT = FILE_CURRENT_CLUSTER.Lowbyte: Gosub MMC_SKIP_BYTES
        FILE_CURRENT_CLUSTER = SPI_IN0  1
		FILE_CURR_SECTOR_NUMIN_CLUSTER = 0
	Endif
	Gosub FAT_CONVERTCLUSTERTOSECTOR 									' Find the working sector within the current cluster
	Inc FILE_CURR_SECTOR_NUMIN_CLUSTER
    Return
'----------------------------------------------------------------------------------------------------------
' Open a file for reading
' 
' Input		: String FAT_FILENAME holds the file to open
' Output	: Returns with FAT_RESPONSE holding 0 if an error occured
' Notes		: Seperates the extension from the filename by looking for the "."
'			: Then pads the filename with spaces if required
'
FAT_OPEN_FILE MACRO PARAMETER1
    #if((PRM_1 == CHAR) || (PRM_1 == LABEL))
    	Movlw 	(PARAMETER1 >> 8)
        Movwf 	TBLPTRH
        Movlw 	(PARAMETER1 & 255)
        Movwf 	TBLPTRL
        Lfsr 	0,FAT_FILENAME
        Clrf 	EECON1
        Bsf 	EECON1,EEPGD
        Clrf 	WREG
        Tblrd*+
        Movf 	TABLAT,W
        Movwf 	POSTINC0
        Bz		$ + 6
        Decfsz	WREG,F
        Bra 	$ - 10
        Num_Word FAT_FILENAME,PP0
    #endif
    #if((PRM_1 == WORD) || (PRM_1 == DWORD))
        Word_Word 	PARAMETER1,TBLPTRL
        Lfsr 	0,FAT_FILENAME
        Clrf 	EECON1
        Bsf 	EECON1,EEPGD
        Clrf 	WREG
        Tblrd*+
        Movf 	TABLAT,W
        Movwf 	POSTINC0
        Bz		$ + 6
        Decfsz	WREG,F
        Bra 	$ - 10
        Num_Word FAT_FILENAME,PP0
    #endif
    #if((PRM_1 == NUM8) || (PRM_1 == NUM16) || (PRM_1 == NUM16) || (PRM_1 == STRING))
    	Num_Word PARAMETER1,PP0
    #endif
    Gosub __FAT_OPEN_FILE
	ENDM
    
__FAT_OPEN_FILE:
'
' Remove the "." and pad the filename with spaces
'    
    FAT_FSR0 = PP0											' Point FSR0 to the start of FAT_FILENAME
    FAT_FSR1 = Varptr FAT_INTERNAL_FILENAME  				' Point FSR1 to the start of FAT_INTERNAL_FILENAME
    PRODL = 0												' Clear the loop counter
    For PRODH = 11 to 0 Step -1								' Create a loop to scan FAT_FILENAME
    	Inc PRODL											' Increment the loop counter
        POSTINC1 = POSTINC0									' Copy FILENAME into FAT_INTERNAL_FILENAME 
        If INDF0 = "." Then Break     						' Exit the loop when . found      
    Next   
    For PRODH = PRODL to 7									' Create a loop to pad out with spaces
    	POSTINC1 = " "										' Pad it
    Next   
    WREG = POSTINC0											' Discard the "."
    For PRODH = 8 to 10										' Create a loop for the rest of FILENAME
    	POSTINC1 = POSTINC0									' Copy FILENAME into FAT_INTERNAL_FILENAME
    Next	
    INDF1 = 0												' Add a null to FAT_INTERNAL_FILENAME	 
    FAT_FSR0 = PP0											' Point FSR0 to the start of FAT_FILENAME
    FAT_FSR1 = Varptr FAT_INTERNAL_FILENAME  				' Point FSR1 to the start of FAT_INTERNAL_FILENAME
    For PRODH = 12 to 0 Step -1								' Create a loop to scan FAT_INTERNAL_FILENAME
        POSTINC0 = POSTINC1									' Copy FAT_INTERNAL_FILENAME into FAT_FILENAME      
    Next   
    FAT_FILENAME = Toupper FAT_FILENAME						' Convert the filename to UPPER case    
    FAT_RESPONSE = 0									' Default to an error situation
'
' Look in the Current Working Directory for a file with a given name
' Upon exiting the loop, FAT_FILE_NUMBER will hold the number of the file
'
	FAT_FILE_NUMBER = 0
	While 1 = 1															' Form a loop to scan the files
		CWD_FILENUMBER = FAT_FILE_NUMBER
		Gosub FAT_LOAD_FILE_IN_CWD		
		If CWD_RESPONSE = FAT_END_OF_DIR Then Return					' Exit the subroutine if file not found
		If CWD_RESPONSE <> FAT_FILE_DELETED Then If CWD_RESPONSE <> FAT_LONG_FILENAME Then
			If FAT_INTERNAL_FILENAME = FAT_FILENAME Then Break			' Compare file names
		Endif
		Inc FAT_FILE_NUMBER
	Wend  
	FILE_CURRENT_BYTE = 0
	FILE_CURR_SECTOR_NUMIN_CLUSTER = 0
	FILE_CURRENT_CLUSTER = FILE_START_CLUSTER
    FAT_RESPONSE = 1
'
' Find the working sector within the current cluster
'
FAT_CONVERTCLUSTERTOSECTOR:
    CURRENT_SECTOR = FILE_CURRENT_CLUSTER - 2    						' First two FAT entries are not data!
	CURRENT_SECTOR = CURRENT_SECTOR * BPB_SECTORS_PER_CLUSTER			' Find the sector num relative to the data start
    CURRENT_SECTOR = CURRENT_SECTOR + FAT_FIRST_DATA_SECTOR				' Find absolute sector number
	CURRENT_SECTOR = CURRENT_SECTOR + FILE_CURR_SECTOR_NUMIN_CLUSTER	' Add the offset sector within the cluster
    Goto MMC_SECTOR_READ												' Point to the sector within the MMC. Exit via the subroutine
    
'----------------------------------------------------------------------------------------------------------
' Return with the files in the current directory
'
' Input		: None
' Output	: String FAT_INTERNAL_FILENAME holds the name of the file
'			: FAT_FILESIZE holds the size of the file (in bytes)
'			: FAT_FREESPACE holds the remaining bytes on the disk (in kB)
'			: LIST_RESPONSE holds the state of the directory
'			: 255 for an error
'			: 0 for End Of Directory
'			: 1 for Valid File
'			: 2 for a Directory Name
'
' Notes		:
'
FAT_LIST_DIR MACRO
		Gosub __FAT_LIST_DIR
	ENDM

#ifdef FAT_LIST_DIR#REQ
__FAT_LIST_DIR:
'
' Find the amount of free clusters (i.e. those with 0 as the value in FAT)
'
	LIST_RESPONSE = 255
    If STARTED_LISTING_DIR = 0 Then
    	FAT_FREESPACE = 0
    	LIST_OUTER_LOOP = 0
    	Repeat
      		CURRENT_SECTOR = FAT_START_SECTOR + LIST_OUTER_LOOP
      		Gosub MMC_SECTOR_READ
      		For LIST_INNER_LOOP = 255 to 0 step -1
				FAT_ENTRY = SPI_IN0 1
         		If FAT_ENTRY = 0 Then Inc FAT_FREESPACE
     		Next
        	Inc LIST_OUTER_LOOP
		Until LIST_OUTER_LOOP > BPB_FAT_SIZE
    	FAT_FREESPACE = FAT_FREESPACE * 2
    	STARTED_LISTING_DIR = 1
        FAT_FILE_NUMBER = 0
    Else
		CWD_FILENUMBER = FAT_FILE_NUMBER
		Gosub FAT_LOAD_FILE_IN_CWD       
    	If CWD_RESPONSE = FAT_END_OF_DIR Then						' Have we reached the end of the directory ?
	   		STARTED_LISTING_DIR = 0
            LIST_RESPONSE = 0
            Return
    	Endif
    	If CWD_RESPONSE <> FAT_FILE_DELETED Then If CWD_RESPONSE <> FAT_LONG_FILENAME Then ' Is it a valid file name ?
			If Byte (FAT_FILE_ATTR & FAT_IS_DIR) > 0 Then			' Is it a directory ?
                LIST_RESPONSE = 2									' Yes.. So indicate a directory
  			Else
                LIST_RESPONSE = 1									' Otherwise it's a standard file name
			Endif
        Endif
    	Inc FAT_FILE_NUMBER											' Move to the next file in the directory
    Endif
    Return
#endif

'----------------------------------------------------------------------------------------------------------
' Attempt to load a file from the Current Working Directory with slot number CWD_FILENUMBER
' Returns CWD_RESPONSE
'
FAT_LOAD_FILE_IN_CWD:
	CWD_CURRSECTOR = FAT_ROOT_DIR_START_SECTOR
    CWD_CURR_SECTOR_NUM_IN_CLUSTER = 0
	If CWD_FILENUMBER > 16 Then
    	While CWD_FILENUMBER > 16
         	Inc CWD_CURRSECTOR 										' Root is a special case, all the sectors are in a row.
      		CWD_FILENUMBER = CWD_FILENUMBER - 16	
    	Wend
	Endif
'
' Start reading the directory sector
'
    CURRENT_SECTOR = CWD_CURRSECTOR : Gosub MMC_SECTOR_READ
  	MMC_SKIP_COUNT = CWD_FILENUMBER << 4: Gosub MMC_SKIP_BYTES		' \
	MMC_SKIP_COUNT = CWD_FILENUMBER << 4: Gosub MMC_SKIP_BYTES		' / Perform a 16-bit skip
    
  	FAT_BYTEIN = SPI_IN0 1
  	If FAT_BYTEIN = 0 Then											' End of directory ?
		CWD_RESPONSE = FAT_END_OF_DIR								' Yes. So indicate it
		Return														' Exit the subroutine prematurely
	Endif
  	If FAT_BYTEIN = FAT_FILE_DELETED Then							' Deleted file ?
		CWD_RESPONSE = FAT_FILE_DELETED								' Yes. So indicate it
		Return														' Exit the subroutine prematurely
	Endif
'
' Read file information from the directory
'
	FAT_FSR0 = Varptr FAT_INTERNAL_FILENAME							' Point FSR0L\H to the FAT_INTERNAL_FILENAME String
	POSTINC0 = FAT_BYTEIN
    FAT_BYTEIN = 0
    Repeat
        POSTINC0 = SPI_IN0 1
        Inc FAT_BYTEIN
    Until FAT_BYTEIN > 9
	POSTINC0 = 0													' Add a NULL    
    FAT_INTERNAL_FILENAME = Toupper FAT_INTERNAL_FILENAME			' Convert the file name to UPPER case
    
	FAT_FILE_ATTR =  SPI_IN0 1 
	If FAT_FILE_ATTR = $0F	Then									' Long filename ?
		CWD_RESPONSE = FAT_LONG_FILENAME							' Yes. So indicate it
		Return														' Exit the subroutine prematurely
	Endif
	MMC_SKIP_COUNT = 14
    Gosub MMC_SKIP_BYTES
	FILE_START_CLUSTER = SPI_IN0 1
	FILE_CURRENT_CLUSTER = FILE_START_CLUSTER
	FAT_FILESIZE = SPI_IN0 1
	FILE_CURR_SECTOR_NUMIN_CLUSTER = 0
	CWD_RESPONSE = 1
  	Return
    
'----------------------------------------------------------------------------------------------------------
' Skip x amount of bytes within the current sector
'
' Input		: MMC_SKIP_COUNT (WREG) holds the amount of skips (dummy reads) to perform
' Output	: SPI_IN0 macro counts the bytes skipped and places in variable SECTOR_BYTE_COUNTER
' Notes		: None
'
MMC_SKIP_BYTES: 	
    MMC_SKIP_LOOP = MMC_SKIP_COUNT
   	While MMC_SKIP_LOOP > 0
      	SPI_IN0 1
      	Dec MMC_SKIP_LOOP
	Wend
	Return     
UNSIGNED_DWORDS = OFF												' Re-enable the extra code for signed DWORD variables
REMINDERS = ON														' Re-enable REMINDER messages

'----------------------------------------------------------------------------------------------------------
OVER_FAT_READ_SUBS:
