'
' Read a file from a Multi Media Card (MMC) formatted as FAT16
' And play a WAV file using an interrupt driven double buffer
'
' The PICmicro's Hardware PWM is used as an 8-bit DAC for the audio output
'
' For 16-bit (18F) devices only using version 3.1.7 onwards of the PROTON+ compiler
'
	OPTIMISER_LEVEL = 6
	Device = 18F252
    REMINDERS = OFF
    XTAL = 8											' Set the initial frequency to 8MHz
    PLL_REQ = TRUE										' Multiply it by 4 to make 32MHz operating frequency
    REMINDERS = ON

    ON_HARDWARE_INTERRUPT Goto DOUBLE_BUFFER_INTERRUPT	' Point the hardware interrupt vector to "DOUBLE_BUFFER_INTERRUPT"
    
    Symbol TIMER1 = TMR1L.Word							' Create a WORD variable from the TMR1L\H registers			
	Symbol TMR1IF = PIR1.0								' Timer1 interrupt overflow flag
	Symbol GIE = INTCON.7								' Global interrupts Enable\Disable
    
    Dim BUSY_PLAYING_BUFFER as Bit
    Dim USE_BUFFER2 as Bit
    Dim LOAD_BUFFER1 as Bit
    Dim LOAD_BUFFER2 as Bit
    Dim PLAY_BUFFER as Bit   
    Dim BUFFER_POSITION as Word SYSTEM
    
    Dim FILE_NUMBER as Byte
    Dim FILE_SELECT as Word
    Dim AMOUNT_OF_FILES as Byte
    
    Dim FSR0 as FSR0L.Word								' Create a word variable from registers FSR0L\H
    Dim FSR2 as FSR2L.Word								' Create a word variable from registers FSR2L\H
    
    Symbol TRUE = 1
    Symbol FALSE = 0
    
'----------------------------------------------------------------------------------------------------------   
    Delayms 200											' Wait for things to stabilise
    ALL_DIGITAL = TRUE									' Set PORTA and PORTE to all digital
REMINDERS = OFF    
    Include "WAV_READ_MMC.INC"							' Load the MMC FAT16 WAV file reading subroutines into memory
REMINDERS = ON
	   
    Goto MAIN_PROGRAM									' Jump over the interrupt subroutine
    
'----------------------------------------------------------------------------------------------------------
' Timer1 hardware interrupt handler to play from two buffers and output via the hardware PWM port
'
' Input		: PLAY_BUFFER = TRUE (1) if the interrupt is to start reading and outputting the buffer
' Output	: None
' Notes		: Uses registers FSR2L\H as a buffer pointer for fast access
'
DOUBLE_BUFFER_INTERRUPT:
    TIMER1 = 65186										' Load Timer1 with a value to trigger the interrupt for a 22.05KHz sample file
    If PLAY_BUFFER = True Then							' Is the file to be played ?    
    	If USE_BUFFER2 = True Then						' Yes. So are we reading from buffer 2 ?
        	FSR2 = Varptr SECTOR_BUFFER2				' Yes. So point FSR2L\H to SECTOR_BUFFER2 
    	Else											' Otherwise.. Play from buffer 1
        	FSR2 = Varptr SECTOR_BUFFER1				' And point FSR2L\H to SECTOR_BUFFER1
    	Endif  
    	FSR2 = FSR2 + BUFFER_POSITION					' Add the buffer position to FSR2L\H
        CCP1CON = CCP1CON & %11001111					' \
        WREG = INDF2 << 4								'  \  
		WREG = WREG & %00110000							'  / Load bits 4 and 5 of CCP1CON with bits 0 and 1 of INDF2
		CCP1CON = CCP1CON | WREG						' /
        CCPR1L = INDF2 >> 2								' Load CCPR1L with the remaining 6 Most Significant bits shifted into place
        Inc BUFFER_POSITION								' Move up the buffer
    	If BUFFER_POSITION.9 = 1 Then 					' End of buffer reached ? (i.e. 512)
        	BUFFER_POSITION.HighByte = 0				' Yes. So clear BUFFER_POSITION. The low byte is already clear
        	Btg USE_BUFFER2 							' and use the other buffer 
        	BUSY_PLAYING_BUFFER = False					' Indicate that playing has stopped and a buffer needs loading
    	Else											' Otherwise...
        	Bra $ + 2									' \ Waste 3 cycles to balance the timing of the interrupt
            Nop											' / 
        Endif
    Endif
    Clear	TMR1IF										' Clear the Timer1 interrupt flag
    Retfie 	FAST										' Exit the interrupt, restoring WREG, STATUS and BSR   
'----------------------------------------------------------------------------------------------------------
' The main program loop starts here
MAIN_PROGRAM:
    Input PORTC.2											' Disable the HPWM output while things are being setup
    Clear													' Clear all RAM before starting
'
' Initialise the MMC and the FAT16 system
'    
    Repeat
    	FAT_INIT											' Read the FAT root and extract the info from it
    Until FAT_RESPONSE = True								' Keep reading the root until the MMC card initialises
'
' Setup a Timer1 overflow hardware interrupt
'      
	T1CON = %00000001                         				' Turn on Timer1, 16-bit, prescaler = 1:1
    PIR1 = %00000000										' Clear the Timer1 interrupt flag
    PIE1 = %00000001										' Enable Timer1 as a peripheral interrupt source
    TIMER1 = 0                                				' Clear Timer1    
    INTCON = %11000000                       				' Enable Global and Peripheral interrupts
'
' Setup the Hardware PWM generator for 64KHz to 80KHz frequency at approx 8-bits resolution using a 32MHz oscillator
'                    
    T2CON = %00000100 										' Turn on Timer2 with a Prescaler value of 1:1
    PR2 = 89												' Set PWM frequency to 88KHz, 8.5 bits of resolution (Better for 22.05KHz samples)
    CCPR1L = 0												' Reset the CCPR1L register
    CCP1CON = %00001100										' Turn on PWM Module 1 by setting bits 2 and 3 of CCP1CON   
    
    AMOUNT_OF_FILES = Lread NUMBER_OF_FILES					' Find out how many files there are
    FILE_SELECT = FILE_NAMES_TABLE							' Pre-select the first file in the LDATA table

	While 1 = 1      										' Create an infinite loop
    	FAT_OPEN_FILE [FILE_SELECT] 						' Open a file for reading
		If FAT_RESPONSE = True Then							' Only proceed if the file was found      	
        	Gosub FAT_READ_SECTOR1							' Discard the first sector containing the WAV files's header info
            Gosub FAT_READ_SECTOR1							' Pre-Read a sector into the first buffer
        	Gosub FAT_READ_SECTOR2							' Pre-Read a sector into the second buffer
            BUFFER_POSITION = 0								' Make sure the buffer position is 0
        	BUSY_PLAYING_BUFFER = True						' Force a "no sector read" situation to start with
        	USE_BUFFER2 = False								' Start with playing from SECTOR_BUFFER1         
        	Output PORTC.2 									' Enable PORTC.2 (CCP1) as output for PWM
            PLAY_BUFFER = True								' Enable the buffer playing interrupt          
        	While 1 = 1										' Create a loop to read the file into the buffers
				If BUSY_PLAYING_BUFFER = False Then 		' Does a buffer require loading from the MMC ?
                    If USE_BUFFER2 = False Then				' Yes. So is it buffer 2 being played ?
                		Gosub FAT_READ_SECTOR2				' No. So load buffer 2
            		Else									' Otherwise...
                		Gosub FAT_READ_SECTOR1				' Load buffer 1
                	Endif
                    BUSY_PLAYING_BUFFER = True				' Indicate to the interrupt that the buffer has been loaded
                    If FAT_RESPONSE = False Then Break		' Exit the play loop if the End Of File is reached
            	Endif
            Wend
    		Input PORTC.2									' Disable the HPWM output while another file is being setup      
   			PLAY_BUFFER = False								' Disable the buffer playing interrupt
        Endif
        Inc FILE_NUMBER										' Increment the file counter
        If FILE_NUMBER > AMOUNT_OF_FILES Then 				' Have we reached the last file ?
        	FILE_NUMBER = 0									' Yes. So reset the file counter
            FILE_SELECT = FILE_NAMES_TABLE					' Select the first file in the table
        Else												' Otherwise...
        	FILE_SELECT = FILE_SELECT + 13					' Point to the next file label in the LDATA table
        Endif
    	Delayms 500											' Delay between files being played
	Wend
'-------------------------------------------------------------------------------
'
' File name data
' 
NUMBER_OF_FILES:  LDATA		1
FILE_NAMES_TABLE: LDATA 	"TEST    .WAV",0

                  