'
' This file contains an Implementation of a Software Mode 0 Master SPI interface.
'
REMINDERS = OFF 
'-----------------------------------------------------------------------------
' transmits one byte <WREG> using the SPI protocol mode 0
' SCK is idle-low, and bits are latched on SCK rising.
		
SPI_OUT0	MACRO BYTEIN	
        #if(PRM_COUNT >= 1)
        	#if((PRM_1 == NUM8) || (PRM_1 == NUM16) || (PRM_1 == NUM32))
                Num_Wreg BYTEIN
        	#else
@        		Movf BYTEIN,W
        	#endif
        #else
        	Movlw 0 
        #endif 
        Gosub _SPI_OUT_MODE_0
		ENDM 
        
#ifdef SPI_OUT0#REQ
'
' Input		: WREG = 8-bit value to send
' 			: MMC_CLK is the PORT.BIT of the SPI Clock pin
'			: MMC_SDI is the PORT.BIT of the SPI Data IN Pin
'			: MMC_SDO is the PORT.BIT of the SPI Data OUT Pin
' Output	: PRODL = 8-bit value received
'
_SPI_OUT_MODE_0:      
	Movwf PRODL 							' Transfer WREG into PRODL
	PRODH = 8								' Single byte SPI loop
SPI_OUT_MODE0_LP:
		MMC_SDO = PRODL & $80 				' Put current outgoing bit on MMC_SDO
		PRODL = PRODL << 1 					' Shift next bit into MSB
		Set MMC_CLK							' Set MMC_CLK high
		PRODL = PRODL | MMC_SDI 			' Capture current bit on MMC_SDI
   		Clear MMC_CLK 						' Pull MMC_CLK low
 	Djnz PRODH,SPI_OUT_MODE0_LP				' Do 8-bits
	Return	
#endif
'-----------------------------------------------------------------------------
' Receives one byte <WREG> using the SPI protocol mode 0 
' SCK is idle-low, and bits are latched on SCK rising.
' 
' If a parameter is present, the amount of bytes received is incremented in SECTOR_BYTE_COUNTER
'		
SPI_IN0	MACRO PARAMETER_1       
        #if(PRM_COUNT == 1)
        	Gosub _SPI_IN_MODE_0_COUNT
        #else
        	Gosub _SPI_IN_MODE_0
        #endif
        #if(SPI_IN0_RETURN == 1)
        	#if(RETURN_TYPE == BYTE)
            	#if((RETURN_VAR != WREG) && (RETURN_VAR != PRODL))
            	Wreg_Byte RETURN_VAR
				#endif
            #endif
            #if(RETURN_TYPE == WORD)
            	Wreg_Byte RETURN_VAR
                #if(PRM_COUNT == 1)
        			Gosub _SPI_IN_MODE_0_COUNT
        		#else
        			Gosub _SPI_IN_MODE_0
        		#endif
                Wreg_Byte RETURN_VAR + 1
            #endif
            #if(RETURN_TYPE == DWORD)
            	Wreg_Byte RETURN_VAR
                #if(PRM_COUNT == 1)
        			Gosub _SPI_IN_MODE_0_COUNT
        		#else
        			Gosub _SPI_IN_MODE_0
        		#endif
                Wreg_Byte RETURN_VAR + 1
                #if(PRM_COUNT == 1)
        			Gosub _SPI_IN_MODE_0_COUNT
        		#else
        			Gosub _SPI_IN_MODE_0
        		#endif
                Wreg_Byte RETURN_VAR + 2
                #if(PRM_COUNT == 1)
        			Gosub _SPI_IN_MODE_0_COUNT
        		#else
        			Gosub _SPI_IN_MODE_0
        		#endif
                Wreg_Byte RETURN_VAR + 3
            #endif
        #endif
		ENDM 
                
#ifdef SPI_IN0#REQ
'
' Input		: MMC_CLK is the PORT.BIT of the SPI Clock pin
'			: MMC_SDI is the PORT.BIT of the SPI Data IN Pin
'			: MMC_SDO is the PORT.BIT of the SPI Data OUT Pin
' Output	: PRODL = 8-bit value received
'
_SPI_IN_MODE_0_COUNT:
	Inc SECTOR_BYTE_COUNTER					' Increment the byte counter
_SPI_IN_MODE_0:
	PRODH = 8								' Single byte SPI loop
SPI_IN_MODE0_LP:
		PRODL = PRODL << 1 					' Shift next bit into MSB
		Set MMC_CLK							' Set MMC_CLK high
		PRODL = PRODL | MMC_SDI 			' Capture current bit on MMC_SDI
		Clear MMC_CLK 						' Pull MMC_CLK low
	Djnz PRODH,SPI_IN_MODE0_LP				' Do 8-bits
 	Movf PRODL,W							' Transfer PRODL into WREG
	Return	
#endif
REMINDERS = ON