' Name        : ADCIN10_1934X.pbp
' Compiler    : PICBASIC PRO Compiler 2.6
' Assembler   : MPASM
' Target PIC  : 40-pin 16F1934 or similar
' Hardware    : LAB-X1 Experimenter Board
' Oscillator  : 4MHz external crystal
' Keywords    : ADCIN, LCDOUT
' Description : PICBASIC PRO program to display result of
' 10-bit A/D conversion on LCD. Connect analog input to
' channel-0 (RA0).
'

' Define LCD registers and bits
Define LCD_DREG  PORTC
Define LCD_DBIT  4
Define LCD_RSREG PORTC
Define LCD_RSBIT 0
Define LCD_EREG  PORTC
Define LCD_EBIT  1

' Define ADCIN parameters
Define  ADC_BITS     10   ' Set number of bits in result
Define  ADC_CLOCK    4    ' Set clock source Fosc/4
Define  ADC_SAMPLEUS 50   ' Set sampling time in uS

adval Var Word            ' Create adval to store result

data $00,$3C,$78,$2C,$58,$20,$70,$FF,$00,$00,$00,$01,$02,$03,$03,$03

   Gosub Init             ' Hardware initialization routine
 
mainloop:
   Adcin 0, adval         ' Read channel 0 to adval
   Lcdout $fe, 1          ' Clear LCD
   Lcdout "Value: ", DEC adval ' Display the decimal value  

   Pause 100              ' Wait .1 second
   Goto mainloop          ' Do it forever

   Init:
   ANSELA = 1    ' Set PortA 0 to analog POT input
   ANSELB = 0    ' portb all digital
 
;   ANSELD = 0    ' portd all digital
;   ANSELE = 0    ' porte all digital
   
   ADCON1 = %11000000  ' Right justify for 10-bit, Fosc/4, +Vref/-Vref = Vdd/gnd
   
   OPTION_REG.7 = 0 ' Enable PORTB pullups
    TRISC = 0
;   TRISD = 0        ' PORTD all outputs
   
   Pause 100        ' Wait for LCD to start
   Return           ' Return to caller
     
   End