
clear

DEFINE OSC 16                             ; 16 MHZ HS CRYSTAL

OSCCON = %01110000
ADCON0= %00000000                         ; PORT A ALL DIGITAL       
ANSEL0= %00000000                         ; PORT A ALL DIGITAL
TRISA = %00000000                         ;
TRISB = %11111100                         ;
TRISC = %10111000                         ;
                                          ;
LATA = %00000000                          ;
LATB = %00000000                          ;
LATC = %00000000                          ;



'VARIABLE DECLARATION
bMenuPos    var Byte     'Main menu position
bSubMenuPos var Byte     'Sub menu position
BTN_NEXT    var PORTB.4  'Next button
BTN_PREV    var PORTB.5  'Previous button
BTN_PLUS    var PORTB.6  'Plus button
BTN_MINUS   var PORTB.7  'Minus button
SQUATS_WT  VAR  Byte
SQUATS_RP  VAR  Byte
PULLDOWN_WT  VAR  Byte
PULLDOWN_RP  VAR  Byte
LATRAISE_WT  VAR  Byte
LATRAISE_RP  VAR  Byte
OVHEADPRESS_WT  VAR  Byte
OVHEADPRESS_RP  VAR  Byte
PREACHERCURL_WT  VAR  Byte
PREACHERCURL_RP  VAR  Byte
PUSHDOWN_WT  VAR  Byte
PUSHDOWN_RP  VAR  Byte
PECDECK_WT  VAR  Byte
PECDECK_RP  VAR  Byte
CABLESHRUG_WT  VAR  Byte
CABLESHRUG_RP  VAR  Byte
CALFRAISES_WT  VAR  Byte
CALFRAISES_RP  VAR  Byte
DBWRISTCURL_WT  VAR  Byte
DBWRISTCURL_RP  VAR  Byte
DECLINESITUP_WT  VAR  Byte
DECLINESITUP_RP  VAR  Byte
'END OF VARIABLE DECLARATION

DEFINE LCD_DREG PORTA
DEFINE LCD_DBIT 0
DEFINE LCD_BITS 4
DEFINE LCD_RSREG PORTC
DEFINE LCD_RSBIT 0
DEFINE LCD_EREG PORTC
DEFINE LCD_EBIT 1

    
PAUSE 500

LCDOUT $FE, $01

LCDOUT $FE, $80, " FITNESS GYM ASSIST"
LCDOUT $FE, $C0, " COPYRIGHT DAVID M"

PAUSE 1000

MAIN
   
GOSUB DisplayMainMenu
GOTO MAIN


'SUB ROUTINES

'******************************************************
'ROUTINE DisplayMainMenu
'This routine handles the display of the main menu choices
'All you need is to call from your main program this routine,
'and have the button ports setup,
'******************************************************
DisplayMainMenu:
   bMenuPos=1   'This is the default menu option
DisplayMainMenuLoop:
   IF bMenuPos=1 THEN
      LCDOUT $FE,1,"SQUATS WT"
   ENDIF
   IF bMenuPos=2 THEN
      LCDOUT $FE,1,"SQUATS RP"
   ENDIF
   IF bMenuPos=3 THEN
      LCDOUT $FE,1,"PULLDOWN WT"
   ENDIF
   IF bMenuPos=4 THEN
      LCDOUT $FE,1,"PULLDOWN RP"
   ENDIF
   IF bMenuPos=5 THEN
      LCDOUT $FE,1,"LAT RAISE WT"
   ENDIF
   IF bMenuPos=6 THEN
      LCDOUT $FE,1,"LAT RAISE RP"
   ENDIF
   IF bMenuPos=7 THEN
      LCDOUT $FE,1,"OVHEAD PRESS WT"
   ENDIF
   IF bMenuPos=8 THEN
      LCDOUT $FE,1,"OVHEAD PRESS RP"
   ENDIF
   IF bMenuPos=9 THEN
      LCDOUT $FE,1,"PREACHER CURL WT"
   ENDIF
   IF bMenuPos=10 THEN
      LCDOUT $FE,1,"PREACHER CURL RP"
   ENDIF
   IF bMenuPos=11 THEN
      LCDOUT $FE,1,"PUSHDOWN WT"
   ENDIF
   IF bMenuPos=12 THEN
      LCDOUT $FE,1,"PUSHDOWN RP"
   ENDIF
   IF bMenuPos=13 THEN
      LCDOUT $FE,1,"PEC DECK WT"
   ENDIF
   IF bMenuPos=14 THEN
      LCDOUT $FE,1,"PEC DECK RP"
   ENDIF
   IF bMenuPos=15 THEN
      LCDOUT $FE,1,"CABLE SHRUG WT"
   ENDIF
   IF bMenuPos=16 THEN
      LCDOUT $FE,1,"CABLE SHRUG RP"
   ENDIF
   IF bMenuPos=17 THEN
      LCDOUT $FE,1,"CALF RAISES WT"
   ENDIF
   IF bMenuPos=18 THEN
      LCDOUT $FE,1,"CALF RAISES RP"
   ENDIF
   IF bMenuPos=19 THEN
      LCDOUT $FE,1,"DBWRIST CURL WT"
   ENDIF
   IF bMenuPos=20 THEN
      LCDOUT $FE,1,"DBWRIST CURL RP"
   ENDIF
   IF bMenuPos=21 THEN
      LCDOUT $FE,1,"DECLINE SITUP WT"
   ENDIF
   IF bMenuPos=22 THEN
      LCDOUT $FE,1,"DECLINE SITUP RP"
   ENDIF
RB_MainMenuLoop:
' BTN_PLUS is the Next Choice button
   IF BTN_PLUS=0 THEN
      WHILE BTN_PLUS=0
      WEND 'PAUSE 200
      bMenuPos=bMenuPos+1
      IF bMenuPos>22 THEN
         bMenuPos=1
      ENDIF
      Goto DisplayMainMenuLoop
   ENDIF
' BTN_PREV is the Exit button
   IF BTN_PREV=0 THEN
      WHILE BTN_PREV=0
      WEND 'PAUSE 200
      RETURN
   ENDIF
' BTN_NEXT is the Goto SubMenu Choice button
   IF BTN_NEXT=0 THEN
      WHILE BTN_NEXT=0
      WEND 'PAUSE 200
      GoSub DisplaySubMenu
      Goto DisplayMainMenuLoop
   ENDIF
Goto RB_MainMenuLoop:
'******************************************************
'ROUTINE DisplaySubMenu
'This routine handles the display of the sub menu choices
'******************************************************
DisplaySubMenu:
   bSubMenuPos=1   'This is the default menu option
DisplaySubMenuLoop:
   IF bMenuPos=1 AND bSubMenuPos=1 THEN
      LCDOUT $FE,1,"SQUATS WT ADJ"
   ENDIF
   IF bMenuPos=2 AND bSubMenuPos=1 THEN
      LCDOUT $FE,1,"SQUATS RP ADJ"
   ENDIF
   IF bMenuPos=3 AND bSubMenuPos=1 THEN
      LCDOUT $FE,1,"PULLDOWN WT ADJ"
   ENDIF
   IF bMenuPos=4 AND bSubMenuPos=1 THEN
      LCDOUT $FE,1,"PULLDOWN RP ADJ"
   ENDIF
   IF bMenuPos=5 AND bSubMenuPos=1 THEN
      LCDOUT $FE,1,"LAT RAISE WT ADJ"
   ENDIF
   IF bMenuPos=6 AND bSubMenuPos=1 THEN
      LCDOUT $FE,1,"LAT RAISE RP ADJ"
   ENDIF
   IF bMenuPos=7 AND bSubMenuPos=1 THEN
      LCDOUT $FE,1,"OVHEAD PRESS WT"
   ENDIF
   IF bMenuPos=8 AND bSubMenuPos=1 THEN
      LCDOUT $FE,1,"OVHEAD PRESS RP ADJ"
   ENDIF
   IF bMenuPos=9 AND bSubMenuPos=1 THEN
      LCDOUT $FE,1,"PREACHER CURL WT ADJ"
   ENDIF
   IF bMenuPos=10 AND bSubMenuPos=1 THEN
      LCDOUT $FE,1,"PREACHER CURL RP ADJ"
   ENDIF
   IF bMenuPos=11 AND bSubMenuPos=1 THEN
      LCDOUT $FE,1,"PUSHDOWN WT ADJ"
   ENDIF
   IF bMenuPos=12 AND bSubMenuPos=1 THEN
      LCDOUT $FE,1,"PUSHDOWN RP ADJ"
   ENDIF
   IF bMenuPos=13 AND bSubMenuPos=1 THEN
      LCDOUT $FE,1,"PEC DECK WT ADJ"
   ENDIF
   IF bMenuPos=14 AND bSubMenuPos=1 THEN
      LCDOUT $FE,1,"PEC DECK RP ADJ"
   ENDIF
   IF bMenuPos=15 AND bSubMenuPos=1 THEN
      LCDOUT $FE,1,"CABLE SHRUG WT ADJ"
   ENDIF
   IF bMenuPos=16 AND bSubMenuPos=1 THEN
      LCDOUT $FE,1,"CABLE SHRUG RP ADJ"
   ENDIF
   IF bMenuPos=17 AND bSubMenuPos=1 THEN
      LCDOUT $FE,1,"CALF RAISES WT ADJ"
   ENDIF
   IF bMenuPos=18 AND bSubMenuPos=1 THEN
      LCDOUT $FE,1,"CALF RAISES RP ADJ"
   ENDIF
   IF bMenuPos=19 AND bSubMenuPos=1 THEN
      LCDOUT $FE,1,"DBWRIST CURL WT ADJ"
   ENDIF
   IF bMenuPos=20 AND bSubMenuPos=1 THEN
      LCDOUT $FE,1,"DBWRIST CURL RP ADJ"
   ENDIF
   IF bMenuPos=21 AND bSubMenuPos=1 THEN
      LCDOUT $FE,1,"DECLINE SITUP WT ADJ"
   ENDIF
   IF bMenuPos=22 AND bSubMenuPos=1 THEN
      LCDOUT $FE,1,"DECLINE SITUP RP ADJ"
   ENDIF
RB_SUBMenuLoop:
' BTN_PLUS is the Next Choice button
   IF BTN_PLUS=0 THEN
      WHILE BTN_PLUS=0
      WEND 'PAUSE 200
      bSubMenuPos=bSubMenuPos+1
      IF bMenuPos=1 AND bSubMenuPos>1 THEN
         bSubMenuPos=1
      ENDIF
      IF bMenuPos=2 AND bSubMenuPos>1 THEN
         bSubMenuPos=1
      ENDIF
      IF bMenuPos=3 AND bSubMenuPos>1 THEN
         bSubMenuPos=1
      ENDIF
      IF bMenuPos=4 AND bSubMenuPos>1 THEN
         bSubMenuPos=1
      ENDIF
      IF bMenuPos=5 AND bSubMenuPos>1 THEN
         bSubMenuPos=1
      ENDIF
      IF bMenuPos=6 AND bSubMenuPos>1 THEN
         bSubMenuPos=1
      ENDIF
      IF bMenuPos=7 AND bSubMenuPos>1 THEN
         bSubMenuPos=1
      ENDIF
      IF bMenuPos=8 AND bSubMenuPos>1 THEN
         bSubMenuPos=1
      ENDIF
      IF bMenuPos=9 AND bSubMenuPos>1 THEN
         bSubMenuPos=1
      ENDIF
      IF bMenuPos=10 AND bSubMenuPos>1 THEN
         bSubMenuPos=1
      ENDIF
      IF bMenuPos=11 AND bSubMenuPos>1 THEN
         bSubMenuPos=1
      ENDIF
      IF bMenuPos=12 AND bSubMenuPos>1 THEN
         bSubMenuPos=1
      ENDIF
      IF bMenuPos=13 AND bSubMenuPos>1 THEN
         bSubMenuPos=1
      ENDIF
      IF bMenuPos=14 AND bSubMenuPos>1 THEN
         bSubMenuPos=1
      ENDIF
      IF bMenuPos=15 AND bSubMenuPos>1 THEN
         bSubMenuPos=1
      ENDIF
      IF bMenuPos=16 AND bSubMenuPos>1 THEN
         bSubMenuPos=1
      ENDIF
      IF bMenuPos=17 AND bSubMenuPos>1 THEN
         bSubMenuPos=1
      ENDIF
      IF bMenuPos=18 AND bSubMenuPos>1 THEN
         bSubMenuPos=1
      ENDIF
      IF bMenuPos=19 AND bSubMenuPos>1 THEN
         bSubMenuPos=1
      ENDIF
      IF bMenuPos=20 AND bSubMenuPos>1 THEN
         bSubMenuPos=1
      ENDIF
      IF bMenuPos=21 AND bSubMenuPos>1 THEN
         bSubMenuPos=1
      ENDIF
      IF bMenuPos=22 AND bSubMenuPos>1 THEN
         bSubMenuPos=1
      ENDIF
      GoTo DisplaySubMenuLoop
   ENDIF
' BTN_PREV is the Exit button
   IF BTN_PREV=0 THEN
      WHILE BTN_PREV=0
      WEND 'PAUSE 200
      RETURN
   ENDIF
' BTN_NEXT is the Goto SubMenu Choice button
   IF BTN_NEXT=0 THEN
      WHILE BTN_NEXT=0
      WEND 'PAUSE 200
      IF bMenuPos=1 AND bSubMenuPos=1 THEN
         GoSub SUB_1_1
      ENDIF
      IF bMenuPos=2 AND bSubMenuPos=1 THEN
         GoSub SUB_2_1
      ENDIF
      IF bMenuPos=3 AND bSubMenuPos=1 THEN
         GoSub SUB_3_1
      ENDIF
      IF bMenuPos=4 AND bSubMenuPos=1 THEN
         GoSub SUB_4_1
      ENDIF
      IF bMenuPos=5 AND bSubMenuPos=1 THEN
         GoSub SUB_5_1
      ENDIF
      IF bMenuPos=6 AND bSubMenuPos=1 THEN
         GoSub SUB_6_1
      ENDIF
      IF bMenuPos=7 AND bSubMenuPos=1 THEN
         GoSub SUB_7_1
      ENDIF
      IF bMenuPos=8 AND bSubMenuPos=1 THEN
         GoSub SUB_8_1
      ENDIF
      IF bMenuPos=9 AND bSubMenuPos=1 THEN
         GoSub SUB_9_1
      ENDIF
      IF bMenuPos=10 AND bSubMenuPos=1 THEN
         GoSub SUB_10_1
      ENDIF
      IF bMenuPos=11 AND bSubMenuPos=1 THEN
         GoSub SUB_11_1
      ENDIF
      IF bMenuPos=12 AND bSubMenuPos=1 THEN
         GoSub SUB_12_1
      ENDIF
      IF bMenuPos=13 AND bSubMenuPos=1 THEN
         GoSub SUB_13_1
      ENDIF
      IF bMenuPos=14 AND bSubMenuPos=1 THEN
         GoSub SUB_14_1
      ENDIF
      IF bMenuPos=15 AND bSubMenuPos=1 THEN
         GoSub SUB_15_1
      ENDIF
      IF bMenuPos=16 AND bSubMenuPos=1 THEN
         GoSub SUB_16_1
      ENDIF
      IF bMenuPos=17 AND bSubMenuPos=1 THEN
         GoSub SUB_17_1
      ENDIF
      IF bMenuPos=18 AND bSubMenuPos=1 THEN
         GoSub SUB_18_1
      ENDIF
      IF bMenuPos=19 AND bSubMenuPos=1 THEN
         GoSub SUB_19_1
      ENDIF
      IF bMenuPos=20 AND bSubMenuPos=1 THEN
         GoSub SUB_20_1
      ENDIF
      IF bMenuPos=21 AND bSubMenuPos=1 THEN
         GoSub SUB_21_1
      ENDIF
      IF bMenuPos=22 AND bSubMenuPos=1 THEN
         GoSub SUB_22_1
      ENDIF
      GoTo DisplaySubMenuLoop
   ENDIF
GoTo RB_SUBMenuLoop
'*************** SUB SUB_1_1*********
SUB_1_1:
'First read the variables from eprom
   READ 1,SQUATS_WT
SUB_1_1MDLoop:
   LCDOUT $FE,192,"                ",$FE,192,DEC SQUATS_WT
SUB_1_1MLoop:
   IF BTN_PLUS=0 THEN
      WHILE BTN_PLUS=0
      WEND 'PAUSE 100
      IF SQUATS_WT>=255 THEN
         SQUATS_WT=0
      ELSE
         SQUATS_WT=SQUATS_WT+1
      ENDIF
      GoTo SUB_1_1MDLoop
   ENDIF
   IF BTN_MINUS=0 THEN
      WHILE BTN_MINUS=0
      WEND 'PAUSE 100
      IF SQUATS_WT<=0 THEN
         SQUATS_WT=255
      ELSE
         SQUATS_WT=SQUATS_WT-1
      ENDIF
      GoTo SUB_1_1MDLoop
   ENDIF
   IF BTN_PREV=0 THEN
      WHILE BTN_PREV=0
      WEND 'PAUSE 100
      WRITE 1,SQUATS_WT
      RETURN
   ENDIF
GoTo SUB_1_1MLoop
'RETURN
'*************** SUB SUB_2_1*********
SUB_2_1:
'First read the variables from eprom
   READ 2,SQUATS_RP
SUB_2_1MDLoop:
   LCDOUT $FE,192,"                ",$FE,192,DEC SQUATS_RP
SUB_2_1MLoop:
   IF BTN_PLUS=0 THEN
      WHILE BTN_PLUS=0
      WEND 'PAUSE 100
      IF SQUATS_RP>=255 THEN
         SQUATS_RP=0
      ELSE
         SQUATS_RP=SQUATS_RP+1
      ENDIF
      GoTo SUB_2_1MDLoop
   ENDIF
   IF BTN_MINUS=0 THEN
      WHILE BTN_MINUS=0
      WEND 'PAUSE 100
      IF SQUATS_RP<=0 THEN
         SQUATS_RP=255
      ELSE
         SQUATS_RP=SQUATS_RP-1
      ENDIF
      GoTo SUB_2_1MDLoop
   ENDIF
   IF BTN_PREV=0 THEN
      WHILE BTN_PREV=0
      WEND 'PAUSE 100
      WRITE 2,SQUATS_RP
      RETURN
   ENDIF
GoTo SUB_2_1MLoop
'RETURN
'*************** SUB SUB_3_1*********
SUB_3_1:
'First read the variables from eprom
   READ 3,PULLDOWN_WT
SUB_3_1MDLoop:
   LCDOUT $FE,192,"                ",$FE,192,DEC PULLDOWN_WT
SUB_3_1MLoop:
   IF BTN_PLUS=0 THEN
      WHILE BTN_PLUS=0
      WEND 'PAUSE 100
      IF PULLDOWN_WT>=255 THEN
         PULLDOWN_WT=0
      ELSE
         PULLDOWN_WT=PULLDOWN_WT+1
      ENDIF
      GoTo SUB_3_1MDLoop
   ENDIF
   IF BTN_MINUS=0 THEN
      WHILE BTN_MINUS=0
      WEND 'PAUSE 100
      IF PULLDOWN_WT<=0 THEN
         PULLDOWN_WT=255
      ELSE
         PULLDOWN_WT=PULLDOWN_WT-1
      ENDIF
      GoTo SUB_3_1MDLoop
   ENDIF
   IF BTN_PREV=0 THEN
      WHILE BTN_PREV=0
      WEND 'PAUSE 100
      WRITE 3,PULLDOWN_WT
      RETURN
   ENDIF
GoTo SUB_3_1MLoop
'RETURN
'*************** SUB SUB_4_1*********
SUB_4_1:
'First read the variables from eprom
   READ 4,PULLDOWN_RP
SUB_4_1MDLoop:
   LCDOUT $FE,192,"                ",$FE,192,DEC PULLDOWN_RP
SUB_4_1MLoop:
   IF BTN_PLUS=0 THEN
      WHILE BTN_PLUS=0
      WEND 'PAUSE 100
      IF PULLDOWN_RP>=255 THEN
         PULLDOWN_RP=0
      ELSE
         PULLDOWN_RP=PULLDOWN_RP+1
      ENDIF
      GoTo SUB_4_1MDLoop
   ENDIF
   IF BTN_MINUS=0 THEN
      WHILE BTN_MINUS=0
      WEND 'PAUSE 100
      IF PULLDOWN_RP<=0 THEN
         PULLDOWN_RP=255
      ELSE
         PULLDOWN_RP=PULLDOWN_RP-1
      ENDIF
      GoTo SUB_4_1MDLoop
   ENDIF
   IF BTN_PREV=0 THEN
      WHILE BTN_PREV=0
      WEND 'PAUSE 100
      WRITE 4,PULLDOWN_RP
      RETURN
   ENDIF
GoTo SUB_4_1MLoop
'RETURN
'*************** SUB SUB_5_1*********
SUB_5_1:
'First read the variables from eprom
   READ 5,LATRAISE_WT
SUB_5_1MDLoop:
   LCDOUT $FE,192,"                ",$FE,192,DEC LATRAISE_WT
SUB_5_1MLoop:
   IF BTN_PLUS=0 THEN
      WHILE BTN_PLUS=0
      WEND 'PAUSE 100
      IF LATRAISE_WT>=255 THEN
         LATRAISE_WT=0
      ELSE
         LATRAISE_WT=LATRAISE_WT+1
      ENDIF
      GoTo SUB_5_1MDLoop
   ENDIF
   IF BTN_MINUS=0 THEN
      WHILE BTN_PREV=0
      WEND 'PAUSE 100
      IF LATRAISE_WT<=0 THEN
         LATRAISE_WT=255
      ELSE
         LATRAISE_WT=LATRAISE_WT-1
      ENDIF
      GoTo SUB_5_1MDLoop
   ENDIF
   IF BTN_PREV=0 THEN
      WHILE BTN_PREV=0
      WEND 'PAUSE 100
      WRITE 5,LATRAISE_WT
      RETURN
   ENDIF
GoTo SUB_5_1MLoop
'RETURN
'*************** SUB SUB_6_1*********
SUB_6_1:
'First read the variables from eprom
   READ 6,LATRAISE_RP
SUB_6_1MDLoop:
   LCDOUT $FE,192,"                ",$FE,192,DEC LATRAISE_RP
SUB_6_1MLoop:
   IF BTN_PLUS=0 THEN
      WHILE BTN_PLUS=0
      WEND 'PAUSE 100
      IF LATRAISE_RP>=255 THEN
         LATRAISE_RP=0
      ELSE
         LATRAISE_RP=LATRAISE_RP+1
      ENDIF
      GoTo SUB_6_1MDLoop
   ENDIF
   IF BTN_MINUS=0 THEN
      WHILE BTN_MINUS=0
      WEND 'PAUSE 100
      IF LATRAISE_RP<=0 THEN
         LATRAISE_RP=255
      ELSE
         LATRAISE_RP=LATRAISE_RP-1
      ENDIF
      GoTo SUB_6_1MDLoop
   ENDIF
   IF BTN_PREV=0 THEN
      WHILE BTN_PREV=0
      WEND 'PAUSE 100
      WRITE 6,LATRAISE_RP
      RETURN
   ENDIF
GoTo SUB_6_1MLoop
'RETURN
'*************** SUB SUB_7_1*********
SUB_7_1:
'First read the variables from eprom
   READ 7,OVHEADPRESS_WT
SUB_7_1MDLoop:
   LCDOUT $FE,192,"                ",$FE,192,DEC OVHEADPRESS_WT
SUB_7_1MLoop:
   IF BTN_PLUS=0 THEN
      WHILE BTN_PLUS=0
      WEND 'PAUSE 100
      IF OVHEADPRESS_WT>=255 THEN
         OVHEADPRESS_WT=0
      ELSE
         OVHEADPRESS_WT=OVHEADPRESS_WT+1
      ENDIF
      GoTo SUB_7_1MDLoop
   ENDIF
   IF BTN_MINUS=0 THEN
      WHILE BTN_MINUS=0
      WEND 'PAUSE 100
      IF OVHEADPRESS_WT<=0 THEN
         OVHEADPRESS_WT=255
      ELSE
         OVHEADPRESS_WT=OVHEADPRESS_WT-1
      ENDIF
      GoTo SUB_7_1MDLoop
   ENDIF
   IF BTN_PREV=0 THEN
      WHILE BTN_PREV=0
      WEND 'PAUSE 100
      WRITE 7,OVHEADPRESS_WT
      RETURN
   ENDIF
GoTo SUB_7_1MLoop
'RETURN
'*************** SUB SUB_8_1*********
SUB_8_1:
'First read the variables from eprom
   READ 8,OVHEADPRESS_RP
SUB_8_1MDLoop:
   LCDOUT $FE,192,"                ",$FE,192,DEC OVHEADPRESS_RP
SUB_8_1MLoop:
   IF BTN_PLUS=0 THEN
      WHILE BTN_PLUS=0
      WEND 'PAUSE 100
      IF OVHEADPRESS_RP>=255 THEN
         OVHEADPRESS_RP=0
      ELSE
         OVHEADPRESS_RP=OVHEADPRESS_RP+1
      ENDIF
      GoTo SUB_8_1MDLoop
   ENDIF
   IF BTN_MINUS=0 THEN
      WHILE BTN_MINUS=0
      WEND 'PAUSE 100
      IF OVHEADPRESS_RP<=0 THEN
         OVHEADPRESS_RP=255
      ELSE
         OVHEADPRESS_RP=OVHEADPRESS_RP-1
      ENDIF
      GoTo SUB_8_1MDLoop
   ENDIF
   IF BTN_PREV=0 THEN
      WHILE BTN_PREV=0
      WEND 'PAUSE 100
      WRITE 8,OVHEADPRESS_RP
      RETURN
   ENDIF
GoTo SUB_8_1MLoop
'RETURN
'*************** SUB SUB_9_1*********
SUB_9_1:
'First read the variables from eprom
   READ 9,PREACHERCURL_WT
SUB_9_1MDLoop:
   LCDOUT $FE,192,"                ",$FE,192,DEC PREACHERCURL_WT
SUB_9_1MLoop:
   IF BTN_PLUS=0 THEN
      WHILE BTN_PLUS=0
      WEND 'PAUSE 100
      IF PREACHERCURL_WT>=255 THEN
         PREACHERCURL_WT=0
      ELSE
         PREACHERCURL_WT=PREACHERCURL_WT+1
      ENDIF
      GoTo SUB_9_1MDLoop
   ENDIF
   IF BTN_MINUS=0 THEN
      WHILE BTN_MINUS=0
      WEND 'PAUSE 100
      IF PREACHERCURL_WT<=0 THEN
         PREACHERCURL_WT=255
      ELSE
         PREACHERCURL_WT=PREACHERCURL_WT-1
      ENDIF
      GoTo SUB_9_1MDLoop
   ENDIF
   IF BTN_PREV=0 THEN
      WHILE BTN_PREV=0
      WEND 'PAUSE 100
      WRITE 9,PREACHERCURL_WT
      RETURN
   ENDIF
GoTo SUB_9_1MLoop
'RETURN
'*************** SUB SUB_10_1*********
SUB_10_1:
'First read the variables from eprom
   READ 10,PREACHERCURL_RP
SUB_10_1MDLoop:
   LCDOUT $FE,192,"                ",$FE,192,DEC PREACHERCURL_RP
SUB_10_1MLoop:
   IF BTN_PLUS=0 THEN
      WHILE BTN_PLUS=0
      WEND 'PAUSE 100
      IF PREACHERCURL_RP>=255 THEN
         PREACHERCURL_RP=0
      ELSE
         PREACHERCURL_RP=PREACHERCURL_RP+1
      ENDIF
      GoTo SUB_10_1MDLoop
   ENDIF
   IF BTN_MINUS=0 THEN
      WHILE BTN_MINUS=0
      WEND 'PAUSE 100
      IF PREACHERCURL_RP<=0 THEN
         PREACHERCURL_RP=255
      ELSE
         PREACHERCURL_RP=PREACHERCURL_RP-1
      ENDIF
      GoTo SUB_10_1MDLoop
   ENDIF
   IF BTN_PREV=0 THEN
      WHILE BTN_PREV=0
      WEND 'PAUSE 100
      WRITE 10,PREACHERCURL_RP
      RETURN
   ENDIF
GoTo SUB_10_1MLoop
'RETURN
'*************** SUB SUB_11_1*********
SUB_11_1:
'First read the variables from eprom
   READ 11,PUSHDOWN_WT
SUB_11_1MDLoop:
   LCDOUT $FE,192,"                ",$FE,192,DEC PUSHDOWN_WT
SUB_11_1MLoop:
   IF BTN_PLUS=0 THEN
      WHILE BTN_PLUS=0
      WEND 'PAUSE 100
      IF PUSHDOWN_WT>=255 THEN
         PUSHDOWN_WT=0
      ELSE
         PUSHDOWN_WT=PUSHDOWN_WT+1
      ENDIF
      GoTo SUB_11_1MDLoop
   ENDIF
   IF BTN_MINUS=0 THEN
      WHILE BTN_MINUS=0
      WEND 'PAUSE 100
      IF PUSHDOWN_WT<=0 THEN
         PUSHDOWN_WT=255
      ELSE
         PUSHDOWN_WT=PUSHDOWN_WT-1
      ENDIF
      GoTo SUB_11_1MDLoop
   ENDIF
   IF BTN_PREV=0 THEN
      WHILE BTN_PREV=0
      WEND 'PAUSE 100
      WRITE 11,PUSHDOWN_WT
      RETURN
   ENDIF
GoTo SUB_11_1MLoop
'RETURN
'*************** SUB SUB_12_1*********
SUB_12_1:
'First read the variables from eprom
   READ 12,PUSHDOWN_RP
SUB_12_1MDLoop:
   LCDOUT $FE,192,"                ",$FE,192,DEC PUSHDOWN_RP
SUB_12_1MLoop:
   IF BTN_PLUS=0 THEN
      WHILE BTN_PLUS=0
      WEND 'PAUSE 100
      IF PUSHDOWN_RP>=255 THEN
         PUSHDOWN_RP=0
      ELSE
         PUSHDOWN_RP=PUSHDOWN_RP+1
      ENDIF
      GoTo SUB_12_1MDLoop
   ENDIF
   IF BTN_MINUS=0 THEN
      WHILE BTN_MINUS=0
      WEND 'PAUSE 100
      IF PUSHDOWN_RP<=0 THEN
         PUSHDOWN_RP=255
      ELSE
         PUSHDOWN_RP=PUSHDOWN_RP-1
      ENDIF
      GoTo SUB_12_1MDLoop
   ENDIF
   IF BTN_PREV=0 THEN
      WHILE BTN_PREV=0
      WEND 'PAUSE 100
      WRITE 12,PUSHDOWN_RP
      RETURN
   ENDIF
GoTo SUB_12_1MLoop
'RETURN
'*************** SUB SUB_13_1*********
SUB_13_1:
'First read the variables from eprom
   READ 13,PECDECK_WT
SUB_13_1MDLoop:
   LCDOUT $FE,192,"                ",$FE,192,DEC PECDECK_WT
SUB_13_1MLoop:
   IF BTN_PLUS=0 THEN
      WHILE BTN_PLUS=0
      WEND 'PAUSE 100
      IF PECDECK_WT>=255 THEN
         PECDECK_WT=0
      ELSE
         PECDECK_WT=PECDECK_WT+1
      ENDIF
      GoTo SUB_13_1MDLoop
   ENDIF
   IF BTN_MINUS=0 THEN
      WHILE BTN_MINUS=0
      WEND 'PAUSE 100
      IF PECDECK_WT<=0 THEN
         PECDECK_WT=255
      ELSE
         PECDECK_WT=PECDECK_WT-1
      ENDIF
      GoTo SUB_13_1MDLoop
   ENDIF
   IF BTN_PREV=0 THEN
      WHILE BTN_PREV=0
      WEND 'PAUSE 100
      WRITE 13,PECDECK_WT
      RETURN
   ENDIF
GoTo SUB_13_1MLoop
'RETURN
'*************** SUB SUB_14_1*********
SUB_14_1:
'First read the variables from eprom
   READ 14,PECDECK_RP
SUB_14_1MDLoop:
   LCDOUT $FE,192,"                ",$FE,192,DEC PECDECK_RP
SUB_14_1MLoop:
   IF BTN_PLUS=0 THEN
      WHILE BTN_PLUS=0
      WEND 'PAUSE 100
      IF PECDECK_RP>=255 THEN
         PECDECK_RP=0
      ELSE
         PECDECK_RP=PECDECK_RP+1
      ENDIF
      GoTo SUB_14_1MDLoop
   ENDIF
   IF BTN_MINUS=0 THEN
      WHILE BTN_MINUS=0
      WEND 'PAUSE 100
      IF PECDECK_RP<=0 THEN
         PECDECK_RP=255
      ELSE
         PECDECK_RP=PECDECK_RP-1
      ENDIF
      GoTo SUB_14_1MDLoop
   ENDIF
   IF BTN_PREV=0 THEN
      WHILE BTN_PREV=0
      WEND 'PAUSE 100
      WRITE 14,PECDECK_RP
      RETURN
   ENDIF
GoTo SUB_14_1MLoop
'RETURN
'*************** SUB SUB_15_1*********
SUB_15_1:
'First read the variables from eprom
   READ 15,CABLESHRUG_WT
SUB_15_1MDLoop:
   LCDOUT $FE,192,"                ",$FE,192,DEC CABLESHRUG_WT
SUB_15_1MLoop:
   IF BTN_PLUS=0 THEN
      WHILE BTN_PLUS=0
      WEND 'PAUSE 100
      IF CABLESHRUG_WT>=255 THEN
         CABLESHRUG_WT=0
      ELSE
         CABLESHRUG_WT=CABLESHRUG_WT+1
      ENDIF
      GoTo SUB_15_1MDLoop
   ENDIF
   IF BTN_MINUS=0 THEN
      WHILE BTN_MINUS=0
      WEND 'PAUSE 100
      IF CABLESHRUG_WT<=0 THEN
         CABLESHRUG_WT=255
      ELSE
         CABLESHRUG_WT=CABLESHRUG_WT-1
      ENDIF
      GoTo SUB_15_1MDLoop
   ENDIF
   IF BTN_PREV=0 THEN
      WHILE BTN_PREV=0
      WEND 'PAUSE 100
      WRITE 15,CABLESHRUG_WT
      RETURN
   ENDIF
GoTo SUB_15_1MLoop
'RETURN
'*************** SUB SUB_16_1*********
SUB_16_1:
'First read the variables from eprom
   READ 16,CABLESHRUG_RP
SUB_16_1MDLoop:
   LCDOUT $FE,192,"                ",$FE,192,DEC CABLESHRUG_RP
SUB_16_1MLoop:
   IF BTN_PLUS=0 THEN
      WHILE BTN_PLUS=0
      WEND 'PAUSE 100
      IF CABLESHRUG_RP>=255 THEN
         CABLESHRUG_RP=0
      ELSE
         CABLESHRUG_RP=CABLESHRUG_RP+1
      ENDIF
      GoTo SUB_16_1MDLoop
   ENDIF
   IF BTN_MINUS=0 THEN
      WHILE BTN_MINUS=0
      WEND 'PAUSE 100
      IF CABLESHRUG_RP<=0 THEN
         CABLESHRUG_RP=255
      ELSE
         CABLESHRUG_RP=CABLESHRUG_RP-1
      ENDIF
      GoTo SUB_16_1MDLoop
   ENDIF
   IF BTN_PREV=0 THEN
      WHILE BTN_PREV=0
      WEND 'PAUSE 100
      WRITE 16,CABLESHRUG_RP
      RETURN
   ENDIF
GoTo SUB_16_1MLoop
'RETURN
'*************** SUB SUB_17_1*********
SUB_17_1:
'First read the variables from eprom
   READ 17,CALFRAISES_WT
SUB_17_1MDLoop:
   LCDOUT $FE,192,"                ",$FE,192,DEC CALFRAISES_WT
SUB_17_1MLoop:
   IF BTN_PLUS=0 THEN
      WHILE BTN_PLUS=0
      WEND 'PAUSE 100
      IF CALFRAISES_WT>=255 THEN
         CALFRAISES_WT=0
      ELSE
         CALFRAISES_WT=CALFRAISES_WT+1
      ENDIF
      GoTo SUB_17_1MDLoop
   ENDIF
   IF BTN_MINUS=0 THEN
      WHILE BTN_MINUS=0
      WEND 'PAUSE 100
      IF CALFRAISES_WT<=0 THEN
         CALFRAISES_WT=255
      ELSE
         CALFRAISES_WT=CALFRAISES_WT-1
      ENDIF
      GoTo SUB_17_1MDLoop
   ENDIF
   IF BTN_PREV=0 THEN
      WHILE BTN_PREV=0
      WEND 'PAUSE 100
      WRITE 17,CALFRAISES_WT
      RETURN
   ENDIF
GoTo SUB_17_1MLoop
'RETURN
'*************** SUB SUB_18_1*********
SUB_18_1:
'First read the variables from eprom
   READ 18,CALFRAISES_RP
SUB_18_1MDLoop:
   LCDOUT $FE,192,"                ",$FE,192,DEC CALFRAISES_RP
SUB_18_1MLoop:
   IF BTN_PLUS=0 THEN
      WHILE BTN_PLUS=0
      WEND 'PAUSE 100
      IF CALFRAISES_RP>=255 THEN
         CALFRAISES_RP=0
      ELSE
         CALFRAISES_RP=CALFRAISES_RP+1
      ENDIF
      GoTo SUB_18_1MDLoop
   ENDIF
   IF BTN_MINUS=0 THEN
      WHILE BTN_MINUS=0
      WEND 'PAUSE 100
      IF CALFRAISES_RP<=0 THEN
         CALFRAISES_RP=255
      ELSE
         CALFRAISES_RP=CALFRAISES_RP-1
      ENDIF
      GoTo SUB_18_1MDLoop
   ENDIF
   IF BTN_PREV=0 THEN
      WHILE BTN_PREV=0
      WEND 'PAUSE 100
      WRITE 18,CALFRAISES_RP
      RETURN
   ENDIF
GoTo SUB_18_1MLoop
'RETURN
'*************** SUB SUB_19_1*********
SUB_19_1:
'First read the variables from eprom
   READ 19,DBWRISTCURL_WT
SUB_19_1MDLoop:
   LCDOUT $FE,192,"                ",$FE,192,DEC DBWRISTCURL_WT
SUB_19_1MLoop:
   IF BTN_PLUS=0 THEN
      WHILE BTN_PLUS=0
      WEND 'PAUSE 100
      IF DBWRISTCURL_WT>=255 THEN
         DBWRISTCURL_WT=0
      ELSE
         DBWRISTCURL_WT=DBWRISTCURL_WT+1
      ENDIF
      GoTo SUB_19_1MDLoop
   ENDIF
   IF BTN_MINUS=0 THEN
      WHILE BTN_MINUS=0
      WEND 'PAUSE 100
      IF DBWRISTCURL_WT<=0 THEN
         DBWRISTCURL_WT=255
      ELSE
         DBWRISTCURL_WT=DBWRISTCURL_WT-1
      ENDIF
      GoTo SUB_19_1MDLoop
   ENDIF
   IF BTN_PREV=0 THEN
      WHILE BTN_PREV=0
      WEND 'PAUSE 100
      WRITE 19,DBWRISTCURL_WT
      RETURN
   ENDIF
GoTo SUB_19_1MLoop
'RETURN
'*************** SUB SUB_20_1*********
SUB_20_1:
'First read the variables from eprom
   READ 20,DBWRISTCURL_RP
SUB_20_1MDLoop:
   LCDOUT $FE,192,"                ",$FE,192,DEC DBWRISTCURL_RP
SUB_20_1MLoop:
   IF BTN_PLUS=0 THEN
      WHILE BTN_PLUS=0
      WEND 'PAUSE 100
      IF DBWRISTCURL_RP>=255 THEN
         DBWRISTCURL_RP=0
      ELSE
         DBWRISTCURL_RP=DBWRISTCURL_RP+1
      ENDIF
      GoTo SUB_20_1MDLoop
   ENDIF
   IF BTN_MINUS=0 THEN
      WHILE BTN_MINUS=0
      WEND 'PAUSE 100
      IF DBWRISTCURL_RP<=0 THEN
         DBWRISTCURL_RP=255
      ELSE
         DBWRISTCURL_RP=DBWRISTCURL_RP-1
      ENDIF
      GoTo SUB_20_1MDLoop
   ENDIF
   IF BTN_PREV=0 THEN
      WHILE BTN_PREV=0
      WEND 'PAUSE 100
      WRITE 20,DBWRISTCURL_RP
      RETURN
   ENDIF
GoTo SUB_20_1MLoop
'RETURN
'*************** SUB SUB_21_1*********
SUB_21_1:
'First read the variables from eprom
   READ 21,DECLINESITUP_WT
SUB_21_1MDLoop:
   LCDOUT $FE,192,"                ",$FE,192,DEC DECLINESITUP_WT
SUB_21_1MLoop:
   IF BTN_PLUS=0 THEN
      WHILE BTN_PLUS=0
      WEND 'PAUSE 100
      IF DECLINESITUP_WT>=255 THEN
         DECLINESITUP_WT=0
      ELSE
         DECLINESITUP_WT=DECLINESITUP_WT+1
      ENDIF
      GoTo SUB_21_1MDLoop
   ENDIF
   IF BTN_MINUS=0 THEN
      WHILE BTN_MINUS=0
      WEND 'PAUSE 100
      IF DECLINESITUP_WT<=0 THEN
         DECLINESITUP_WT=255
      ELSE
         DECLINESITUP_WT=DECLINESITUP_WT-1
      ENDIF
      GoTo SUB_21_1MDLoop
   ENDIF
   IF BTN_PREV=0 THEN
      WHILE BTN_PREV=0
      WEND 'PAUSE 100
      WRITE 21,DECLINESITUP_WT
      RETURN
   ENDIF
GoTo SUB_21_1MLoop
'RETURN
'*************** SUB SUB_22_1*********
SUB_22_1:
'First read the variables from eprom
   READ 22,DECLINESITUP_RP
SUB_22_1MDLoop:
   LCDOUT $FE,192,"                ",$FE,192,DEC DECLINESITUP_RP
SUB_22_1MLoop:
   IF BTN_PLUS=0 THEN
      WHILE BTN_PLUS=0
      WEND 'PAUSE 100
      IF DECLINESITUP_RP>=255 THEN
         DECLINESITUP_RP=0
      ELSE
         DECLINESITUP_RP=DECLINESITUP_RP+1
      ENDIF
      GoTo SUB_22_1MDLoop
   ENDIF
   IF BTN_MINUS=0 THEN
      WHILE BTN_MINUS=0
      WEND 'PAUSE 100
      IF DECLINESITUP_RP<=0 THEN
         DECLINESITUP_RP=255
      ELSE
         DECLINESITUP_RP=DECLINESITUP_RP-1
      ENDIF
      GoTo SUB_22_1MDLoop
   ENDIF
   IF BTN_PREV=0 THEN
      WHILE BTN_PREV=0
      WEND 'PAUSE 100
      WRITE 22,DECLINESITUP_RP
      RETURN
   ENDIF
GoTo SUB_22_1MLoop
'RETURN

   END