'****************************************************************
'*  Name    : MAX6953TEST.BAS                                   *
'*  Author  : Nikos Geronikolos                                 *
'*  Notice  : Copyright (c) 2005 Nikos Geronikolos              *
'*          : All Rights Reserved                               *
'*  Date    : 2005                                              *
'*  Version : V2.0                                              *
'*  Notes   :                                                   *
'*          :                                                   *
'****************************************************************
@ DEVICE pic16F628A, HS_OSC
@ DEVICE pic16F628A, PROTECT_ON

INCLUDE "MODEDEFS.BAS"

DEFINE  OSC 16
DEFINE  HSER_BAUD 38400 
DEFINE  HSER_CLROERR 1  ' Automatically clear over-run errors
DEFINE  HSER_RCSTA 90h	' Enable USART receive
DEFINE  HSER_TXSTA 64h
DEFINE  I2C_SLOW    1
DEFINE  HSER_EVEN   1
DEFINE  HSER_BITS   9


INTCON  = 0			    ' Disable interrupts 
CMCON = 7
TRISA = %00011100       ' A.0,A.1=OUTPUT A.2,A.3,A.4=INPUT
TRISB = %11111111       ; 1=INPUT 0=OUTPUT
SYMBOL SDA0 = PORTB.4
SYMBOL SCL0 = PORTB.5

DISPLAYCONTROLBYTE1     VAR BYTE
DISPLAYCONTROLBYTE2     VAR BYTE
DISPLAYADDRESSBYTE      VAR BYTE
DISPLAYDATABYTE         VAR BYTE
DIGIT0BOTHPLANESADDRESS VAR BYTE
DIGIT1BOTHPLANESADDRESS VAR BYTE
DIGIT2BOTHPLANESADDRESS VAR BYTE
DIGIT3BOTHPLANESADDRESS VAR BYTE
ASCII                   VAR BYTE    
n                       VAR BYTE  
X                       VAR BYTE    
J                       VAR BYTE  
M                       VAR BYTE 
L                       VAR BYTE    
K                       VAR BYTE    
RCIF                    VAR PIR1.5
SerData                 VAR BYTE[18]
i                       VAR BYTE
GP                      VAR BYTE        ' GP variable
OERR                    VAR RCSTA.1     ' Alias USART over-run bit
CREN                    VAR RCSTA.4     ' Alias USART continuous receive enable bit

CTRL                    VAR BYTE
ADDR                    VAR BYTE
DTA                     VAR BYTE
Pointer                 VAR BYTE
RomAddr                 VAR BYTE

I = 0
ASCII = 65
L = 47
J = 48
M = 48
K = 48
DISPLAYCONTROLBYTE1 = %10100000 ;1o MAX6953 AD0,AD1=GND
DISPLAYCONTROLBYTE2 = %10100010 ;2o MAX6953 AD1=GND,AD0=Vcc
DIGIT0BOTHPLANESADDRESS = %01100000
DIGIT1BOTHPLANESADDRESS = %01100001
DIGIT2BOTHPLANESADDRESS = %01100010
DIGIT3BOTHPLANESADDRESS = %01100011

PAUSE 100
           
;BRING DISPLAY OUT OF SHUTDOWN MODE
DISPLAYADDRESSBYTE = $04
DISPLAYDATABYTE = $01
CTRL=DISPLAYCONTROLBYTE1:ADDR=DISPLAYADDRESSBYTE:DTA=DISPLAYDATABYTE:GOSUB I2COUT
CTRL=DISPLAYCONTROLBYTE2:ADDR=DISPLAYADDRESSBYTE:DTA=DISPLAYDATABYTE:GOSUB I2COUT

;BRING DIGITS 0 AND 2 TO MAX BRIGHTNESS
DISPLAYADDRESSBYTE = $01
DISPLAYDATABYTE = $FF
CTRL=DISPLAYCONTROLBYTE1:ADDR=DISPLAYADDRESSBYTE:DTA=DISPLAYDATABYTE:GOSUB I2COUT
CTRL=DISPLAYCONTROLBYTE2:ADDR=DISPLAYADDRESSBYTE:DTA=DISPLAYDATABYTE:GOSUB I2COUT

;BRING DIGITS 1 AND 3 TO MAX BRIGHTNESS
DISPLAYADDRESSBYTE = $02
DISPLAYDATABYTE = $FF
CTRL=DISPLAYCONTROLBYTE1:ADDR=DISPLAYADDRESSBYTE:DTA=DISPLAYDATABYTE:GOSUB I2COUT
CTRL=DISPLAYCONTROLBYTE2:ADDR=DISPLAYADDRESSBYTE:DTA=DISPLAYDATABYTE:GOSUB I2COUT

READ 12,x
MAIN1:  
        romaddr=16
        GOSUB READrom
        GOSUB OUT                           ;KRATA THN TELEYTAIA APIKONISI
        
MAIN:    IF PORTB.6 = 1 THEN STATIC          ;CHECK STATIC OR DYNAMIC
         if PORTA.3 = 1 AND PORTA.4 = 1 then menu
             
DYNAMIC: IF RCIF = 1 THEN 
        HSERIN 150,MAIN,[WAIT(X),STR SERDATA\17]
        GOSUB OUT
        GOSUB SERTALLY
        ENDIF
        GOTO MAIN
        
SERTALLY: SerData[0] = SerData[0] & %00000011
        
        PORTA.0 =0
        PORTA.1=0
        if SerData[0]=%00000001 then 
        PORTA.0=1
        endif
        if SerData[0]=%00000010 then
        PORTA.1=1
        ENDIF
        RETURN
        
PARATALLY: IF  PORTB.3 = 1 THEN      ;PORTB.3=PARALLEL TALLY1
        PORTA.0=1
        ELSE
        pORTA.0=0
        ENDIF
        IF  PORTB.7 = 1 then       ;PORTB.7=PARALLEL TALLY2
        PORTA.1=1
        ELSE
        PORTA.1=0
        endif
        return
        
        
STATIC: 
        Romaddr=24
        GOSUB READrom
        GOSUB OUT
        PAUSE 2000
        GOSUB PLAY
RT:     IF PORTB.6 = 0 THEN MAIN1
        if PORTA.3 = 1 then
			if PORTA.4 = 1 then menu
		endif
        IF PORTB.0 = 0 THEN 
        GOSUB PARATALLY        ;PORTB.0=1 SERIALL TALLY
        else 
        IF RCIF = 1 THEN      
        HSERIN 150,RT,[WAIT(X), STR SERDATA\1]
        GOSUB SERTALLY
        ENDIF
        endif
        GOTO RT
        
NAME:   GOSUB PLAY
        If PORTA.2=1 then
		I = I + 1
		IF I > 8 THEN I = 1
		pause 500
NICK:	WHILE PORTA.3 = 1
        ASCII = ASCII+1
        IF ASCII > 127 THEN ASCII = 8
        SerData[i] = ASCII
        GOSUB OUT
        PAUSE 500
        WEND
        WHILE PORTA.4 = 1
		ASCII = ASCII-1
        IF ASCII < 8 THEN ASCII = 127
        SerData[i] = ASCII
        GOSUB OUT
        PAUSE 500
        WEND
		else
		GOTO NICK
		endif
        for gp=0 to 7     
        write GP,Serdata[GP+1]
        NEXT GP
      

		if PORTA.3 = 1 then
			if PORTA.4 = 1 then ok
		endif
		GOTO NAME

MENU:   
        romaddr=32
        GOSUB READrom
        GOSUB OUT
        
        N = 0
IPOMENU:PAUSE 200
        
        if PORTA.3 = 1 then
            n = n + 1
            IF N = 5 THEN
               N = 1
            ENDIF
            IF N = 3 then 
				if pORTB.6 = 0 THEN N = 4
            ENDIF
        endif
        
        if PORTA.4 = 1 then
            n = n - 1
            IF N = 0 THEN
                N = 4
            ENDIF
            IF N = 3 then
				if PORTB.6 = 0 THEN N = 2
            ENDIF
        endif
        
        select case N
        case    1
                romaddr=40
                GOSUB READrom

                GOSUB OUT
        case    2
                romaddr=48
                GOSUB READrom
                GOSUB OUT
        case    3
                ROMADDR=56
                GOSUB READrom
                GOSUB OUT       
        case    4
                Romaddr=64
                GOSUB READrom
                GOSUB OUT   
        END SELECT
        IF  n = 1 then 
			if PORTA.2 = 1 then ADDRESS
		ENDIF
        IF  n = 2 THEN
			IF PORTA.2 = 1 then DISPLAY
		ENDIF           
        IF  n = 3 THEN
			IF PORTA.2 = 1 then NAME
        ENDIF
		IF  n = 4 THEN 
			IF PORTA.2 = 1 then EXIT
        ENDIF
		GOTO IPOMENU
         
ADDRESS:READ 9,l
        READ 10,m
        READ 11,j
        romaddr=96
        GOSUB READrom
        SerData[6] = j
        SerData[7] = m
        SerData[8] = l
        GOSUB out
        
NICK1:	pause 350
        WHILE PORTA.3 = 1
        L = L + 1
        IF L > 57 THEN 
            L = 48
            M = M + 1
        ENDIF
        IF M > 57 THEN 
            M = 48
            J = J + 1
        ENDIF
        if j > 49 then
            j = 48
        endif
        IF J = 49 THEN
			IF M = 50 THEN 
				IF L = 56 THEN        ;mexri to 127 meta 000
            		J = 48
            		M = 48
            		L = 48
        		ENDIF
  		ENDIF
  		ENDIF
        SerData[8] = L
        SerData[7] = M
        SerData[6] = J
        GOSUB OUT
        pause 300
        WEND

        WHILE PORTA.4 = 1
        L = L - 1
        IF L < 48 THEN 
            L = 57
            M = M - 1
        ENDIF
        IF M < 48 THEN 
            M = 57
            J = J - 1
        ENDIF
        if j < 48 then
            j = 49
        endif
        IF J = 49 THEN 
			IF M = 57 THEN
				IF L = 57  THEN
      	      		J = 49
        	    	M = 50
            		L = 55
        		ENDIF
  		ENDIF
  		ENDIF
        SerData[8] = L
        SerData[7] = M
        SerData[6] = J
        GOSUB OUT
        pause 300
        WEND
		
        
        X = 128 + 100*(J -48) + 10*(M - 48) + (L -48) 
        write 12,x
        write 9,l
        write 10,m
        write 11,j
        IF PORTA.2 = 1 THEN
			IF PORTB.6 = 0 THEN CONNECT    ;DYNAMIC MODE
        ENDIF
		IF PORTA.2 = 1 THEN
			IF PORTB.6 = 1 THEN OK    ;STATIC MODE
        ENDIF
		GOTO NICK1
       
DISPLAY:READ 8,k
        romaddr=72
        GOSUB READrom      
        SerData[8] = k
        GOSUB out
        PAUSE 200
        
NICK2:  WHILE PORTA.3 = 1
        K = K + 1
        IF K > 56 THEN 
        K = 49
        ENDIF
        SerData[8] = K
        GOSUB OUT
        PAUSE 300
        GOTO SELECTK
        WEND
        
        WHILE PORTA.4 = 1
        K = K - 1        
        IF K < 49 THEN 
        K = 56
        ENDIF
        SerData[8] = K
        GOSUB OUT
        PAUSE 300
        GOTO SELECTK
        WEND

SELECTK: 
        SELECT CASE K
        CASE    49
                DISPLAYDATABYTE = $00
        CASE    50
                DISPLAYDATABYTE = $22
        CASE    51
                DISPLAYDATABYTE = $44
        CASE    52
                DISPLAYDATABYTE = $66
        CASE    53
                DISPLAYDATABYTE = $88
        CASE    54
                DISPLAYDATABYTE = $BB
        CASE    55
                DISPLAYDATABYTE = $DD
        CASE    56
                DISPLAYDATABYTE = $FF
END SELECT
        
;BRING DIGITS 0 AND 2 TO K BRIGHTNESS
DISPLAYADDRESSBYTE = $01
CTRL=DISPLAYCONTROLBYTE1:ADDR= DISPLAYADDRESSBYTE:DTA=DISPLAYDATABYTE:GOSUB I2COUT

CTRL=DISPLAYCONTROLBYTE2:ADDR=DISPLAYADDRESSBYTE:DTA=DISPLAYDATABYTE:GOSUB I2COUT
;BRING DIGITS 1 AND 3 TO K BRIGHTNESS
DISPLAYADDRESSBYTE = $02
CTRL=DISPLAYCONTROLBYTE1:ADDR=DISPLAYADDRESSBYTE:DTA=DISPLAYDATABYTE:GOSUB I2COUT

CTRL=DISPLAYCONTROLBYTE2:ADDR=DISPLAYADDRESSBYTE:DTA=DISPLAYDATABYTE:GOSUB I2COUT

write 8,k
IF PORTA.2 = 1 THEN
	IF PORTB.6 = 0 THEN CONNECT    ;DYNAMIC MODE
ENDIF
IF PORTA.2 = 1 THEN
	IF PORTB.6 = 1 THEN OK    ;STATIC MODE
ENDIF
GOTO NICK2
        

EXIT:


CONNECT:
        romaddr=80
        GOSUB READrom
        GOSUB out
        GOTO MAIN

OK:     
        romaddr=88
        GOSUB READrom
        GOSUB out
        pause 2000
        GOSUB PLAY
        goto rt
        
        
        
PLAY:   
        for gp=0 to 7
        READ gp,serdata[gp+1]
        next gp
        GOSUB out
        RETURN
OUT:

CTRL=DISPLAYCONTROLBYTE1:ADDR=DIGIT0BOTHPLANESADDRESS:DTA=SerData[1]:GOSUB I2COUT

CTRL=DISPLAYCONTROLBYTE1:ADDR=DIGIT1BOTHPLANESADDRESS:DTA=SerData[2]:GOSUB I2COUT

CTRL=DISPLAYCONTROLBYTE1:ADDR=DIGIT2BOTHPLANESADDRESS:DTA=SerData[3]:GOSUB I2cout

CTRL=DISPLAYCONTROLBYTE1:ADDR=DIGIT3BOTHPLANESADDRESS:DTA=SerData[4]:GOSUB I2Cout

CTRL=DISPLAYCONTROLBYTE2:ADDR=DIGIT0BOTHPLANESADDRESS:DTA=SerData[5]:GOSUB I2COUT

CTrL=DISPLAYCONTROLBYTE2:ADDR=DIGIT1BOTHPLANESADDRESS:DTA=SerData[6]:GOSUB I2Cout

CTRL=DISPLAYCONTROLBYTE2:ADDR=DIGIT2BOTHPLANESADDRESS:DTA=SerData[7]:GOSUB I2COUT

CTRL=DISPLAYCONTROLBYTE2:ADDR=DIGIT3BOTHPLANESADDRESS:DTA=SerData[8]:GOSUB i2COUT

RETURN

I2COUT:
I2CWRITE SDA0, SCL0, CTRL, ADDR, [DTA]
return

READROM:
Pointer=1
for gp=Romaddr to Romaddr+7
READ RomAddr,serdata[pointer]
pointer=pointer+1
next gp
return

' *** EEPROM Data Table -------------
DATA @16," ","C","O","N","N","E","C","T"                                                        
DATA @24," ","S","T","A","T","I","C"," "        
DATA @32," "," ","M","E","N","U"," "," "        
DATA @40,"A","D","D","R","E","S","S"," "                
DATA @48,"D","I","S","P","L","A","Y"," "
DATA @56," "," ","N","A","M","E"," "," "
DATA @64," "," ","E","X","I","T"," "," "        
DATA @72,"B","R","I","G","H","T",":"," "                
DATA @80," ","C","O","N","N","E","C","T"
DATA @88," "," ","O",".","K"," "," "," " 
DATA @96,"A","D","D","R",":"," "," "," " 

' *** -------------------------------       
