'****************************************************************
'*  Name    : MAX6953TEST.BAS                                   *
'*  Author  : Nikos Geronikolos                                 *
'*  Notice  : Copyright (c) 2005 Nikos Geronikolos              *
'*          : All Rights Reserved                               *
'*  Date    : 2005                                              *
'*  Version : V1.0                                              *
'*  Notes   :                                                   *
'*          :                                                   *
'****************************************************************
@ DEVICE pic16F628A, HS_OSC
@ DEVICE pic16F628A, PROTECT_ON

INCLUDE "MODEDEFS.BAS"

DEFINE  OSC 16
DEFINE  HSER_BAUD 38400 
DEFINE  HSER_CLROERR 1  ' Automatically clear over-run errors
DEFINE  HSER_RCSTA 90h	' Enable USART receive
DEFINE  HSER_TXSTA 64h
DEFINE  I2C_SLOW    1
DEFINE  HSER_EVEN   1
DEFINE  HSER_BITS   9


INTCON  = 0			    ' Disable interrupts 
CMCON = 7
TRISA = %00011100       ' A.0,A.1=OUTPUT A.2,A.3,A.4=INPUT
TRISB = %11111111       ; 1=INPUT 0=OUTPUT
SYMBOL SDA0 = PORTB.4
SYMBOL SCL0 = PORTB.5

DISPLAYCONTROLBYTE1 VAR BYTE
DISPLAYCONTROLBYTE2 VAR BYTE
DISPLAYADDRESSBYTE VAR BYTE
DISPLAYDATABYTE VAR BYTE
DIGIT0BOTHPLANESADDRESS VAR BYTE
DIGIT1BOTHPLANESADDRESS VAR BYTE
DIGIT2BOTHPLANESADDRESS VAR BYTE
DIGIT3BOTHPLANESADDRESS VAR BYTE
ASCII   VAR BYTE    
n var byte  
X   VAR BYTE    
J VAR BYTE  
M VAR BYTE 
L   VAR BYTE    
K   VAR BYTE    
RCIF      VAR PIR1.5
SerData   VAR BYTE[18]
i         var byte
GP      VAR BYTE        ' GP variable
OERR    VAR RCSTA.1     ' Alias USART over-run bit
CREN    VAR RCSTA.4     ' Alias USART continuous receive enable bit

I = 0
ASCII = 65
L = 47
J = 48
M = 48
K = 48
DISPLAYCONTROLBYTE1 = %10100000 ;1o MAX6953 AD0,AD1=GND
DISPLAYCONTROLBYTE2 = %10100010 ;2o MAX6953 AD1=GND,AD0=Vcc
DIGIT0BOTHPLANESADDRESS = %01100000
DIGIT1BOTHPLANESADDRESS = %01100001
DIGIT2BOTHPLANESADDRESS = %01100010
DIGIT3BOTHPLANESADDRESS = %01100011

PAUSE 100
           
;DISPLAYADDRESSBYTE = $05
;GR  = RAM08 MAX6953
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE1, DISPLAYADDRESSBYTE, [$A8,%01111111,%00000001,%00000001,%00000001,%00000001]     
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE2, DISPLAYADDRESSBYTE, [$A8,%01111111,%00000001,%00000001,%00000001,%00000001] 
;GR  = RAM09
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE1, DISPLAYADDRESSBYTE, [$AD,%01111100,%01000010,%01000001,%01000010,%01111100]     
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE2, DISPLAYADDRESSBYTE, [$AD,%01111100,%01000010,%01000001,%01000010,%01111100] 
;GR  = RAM10
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE1, DISPLAYADDRESSBYTE, [$B2,%00111110,%01001001,%01001001,%01001001,%00111110]     
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE2, DISPLAYADDRESSBYTE, [$B2,%00111110,%01001001,%01001001,%01001001,%00111110] 
;GR  = RAM11
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE1, DISPLAYADDRESSBYTE, [$B7,%01111000,%00000100,%00000010,%00000100,%01111000]     
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE2, DISPLAYADDRESSBYTE, [$B7,%01111000,%00000100,%00000010,%00000100,%01111000] 
;GR  = RAM12
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE1, DISPLAYADDRESSBYTE, [$BC,%01111111,%00000001,%00000001,%00000001,%01111111]     
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE2, DISPLAYADDRESSBYTE, [$BC,%01111111,%00000001,%00000001,%00000001,%01111111] 
;GR  = RAM13
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE1, DISPLAYADDRESSBYTE, [$C1,%00011100,%00100010,%01111111,%00100010,%00011100]     
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE2, DISPLAYADDRESSBYTE, [$C1,%00011100,%00100010,%01111111,%00100010,%00011100] 
;GR  = RAM14
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE1, DISPLAYADDRESSBYTE, [$C6,%00001110,%00010000,%01111111,%00010000,%00001110]     
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE2, DISPLAYADDRESSBYTE, [$C6,%00001110,%00010000,%01111111,%00010000,%00001110] 
;GR  = RAM15
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE1, DISPLAYADDRESSBYTE, [$CB,%01001110,%01010001,%01010001,%01010001,%01001110]     
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE2, DISPLAYADDRESSBYTE, [$CB,%01001110,%01010001,%01010001,%01010001,%01001110] 
;GR  = RAM16
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE1, DISPLAYADDRESSBYTE, [$D0,%00100010,%01010100,%01001000,%01010100,%00100010]     
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE2, DISPLAYADDRESSBYTE, [$D0,%00100010,%01010100,%01001000,%01010100,%00100010] 
;GR  = RAM17
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE1, DISPLAYADDRESSBYTE, [$D5,%00110001,%01001011,%01000101,%01001001,%00110000]     
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE2, DISPLAYADDRESSBYTE, [$D5,%00110001,%01001011,%01000101,%01001001,%00110000] 
;GR  = RAM18
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE1, DISPLAYADDRESSBYTE, [$DA,%01000010,%00100001,%00010001,%00001010,%01111100]     
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE2, DISPLAYADDRESSBYTE, [$DA,%01000010,%00100001,%00010001,%00001010,%01111100] 
;GR  = RAM19
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE1, DISPLAYADDRESSBYTE, [$DF,%01111100,%00000100,%00000100,%00000100,%01111100]     
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE2, DISPLAYADDRESSBYTE, [$DF,%01111100,%00000100,%00000100,%00000100,%01111100] 
;GR  = RAM20
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE1, DISPLAYADDRESSBYTE, [$E4,%00011000,%00100000,%01111100,%00100100,%00011000]     
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE2, DISPLAYADDRESSBYTE, [$E4,%00011000,%00100000,%01111100,%00100100,%00011000] 
;GR  = RAM21
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE1, DISPLAYADDRESSBYTE, [$E9,%00001100,%00010000,%01111110,%00010000,%00001100]     
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE2, DISPLAYADDRESSBYTE, [$E9,%00001100,%00010000,%01111110,%00010000,%00001100] 
;GR  = RAM22
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE1, DISPLAYADDRESSBYTE, [$EE,%00111100,%01001010,%01001010,%00111100,%00000000]     
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE2, DISPLAYADDRESSBYTE, [$EE,%00111100,%01001010,%01001010,%00111100,%00000000] 
;GR  = RAM23
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE1, DISPLAYADDRESSBYTE, [$F3,%00111000,%01000000,%00100000,%01000000,%00111000]     
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE2, DISPLAYADDRESSBYTE, [$F3,%00111000,%01000000,%00100000,%01000000,%00111000] 


;BRING DISPLAY OUT OF SHUTDOWN MODE
DISPLAYADDRESSBYTE = $04
DISPLAYDATABYTE = $01
I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE1, DISPLAYADDRESSBYTE, [DISPLAYDATABYTE]
I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE2, DISPLAYADDRESSBYTE, [DISPLAYDATABYTE]

;BRING DIGITS 0 AND 2 TO MAX BRIGHTNESS
DISPLAYADDRESSBYTE = $01
DISPLAYDATABYTE = $FF
I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE1, DISPLAYADDRESSBYTE, [DISPLAYDATABYTE]
I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE2, DISPLAYADDRESSBYTE, [DISPLAYDATABYTE]

;BRING DIGITS 1 AND 3 TO MAX BRIGHTNESS
DISPLAYADDRESSBYTE = $02
DISPLAYDATABYTE = $FF
I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE1, DISPLAYADDRESSBYTE, [DISPLAYDATABYTE]
I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE2, DISPLAYADDRESSBYTE, [DISPLAYDATABYTE]

;BRING DISPLAY INTO TEST MODE FOR ONE SECOND (ALL DOTS LIT)
;DISPLAYADDRESSBYTE = $07
;DISPLAYDATABYTE = $FF
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE1, DISPLAYADDRESSBYTE, [DISPLAYDATABYTE]
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE2, DISPLAYADDRESSBYTE, [DISPLAYDATABYTE]
;PAUSE 1000

;BRING DISPLAY OUT OF TEST MODE
;DISPLAYADDRESSBYTE = $07
;DISPLAYDATABYTE = $FE
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE1, DISPLAYADDRESSBYTE, [DISPLAYDATABYTE]
;I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE2, DISPLAYADDRESSBYTE, [DISPLAYDATABYTE]

read 12,x
MAIN1:  SerData[1] =" "
        SerData[2] ="C"
        SerData[3] ="O"
        SerData[4] ="N"
        SerData[5] ="N"
        SerData[6] ="E"
        SerData[7] ="C"
        SerData[8] ="T"
        GOSUB OUT                           ;KRATA THN TELEYTAIA APIKONISI
        
MAIN:    IF PORTB.6 = 1 THEN STATIC          ;CHECK STATIC OR DYNAMIC
         if PORTA.3 = 1 AND PORTA.4 = 1 then menu
             
DYNAMIC: IF RCIF = 1 THEN 
        HSERIN 150,MAIN,[WAIT(X),STR SERDATA\17]
        GOSUB OUT
        gosub SERTALLY
        ENDIF
        GOTO MAIN
        
SERTALLY: SerData[0] = SerData[0] & %00000011
        
        PORTA.0 =0
        PORTA.1=0
        if SerData[0]=%00000001 then 
        PORTA.0=1
        endif
        if SerData[0]=%00000010 then
        PORTA.1=1
        ENDIF
        RETURN
        
PARATALLY: IF  PORTB.3 = 1 THEN      ;PORTB.3=PARALLEL TALLY1
        PORTA.0=1
        ELSE
        pORTA.0=0
        ENDIF
        IF  PORTB.7 = 1 then       ;PORTB.7=PARALLEL TALLY2
        PORTA.1=1
        ELSE
        PORTA.1=0
        endif
        return
        
        
STATIC: SerData[1] =" "
        SerData[2] ="S"
        SerData[3] ="T"
        SerData[4] ="A"
        SerData[5] ="T"
        SerData[6] ="I"
        SerData[7] ="C"
        SerData[8] =" "
        GOSUB OUT
        PAUSE 2000
        GOSUB PLAY
RT:     IF PORTB.6 = 0 THEN MAIN1
        if PORTA.3 = 1 then
			if PORTA.4 = 1 then menu
		endif
        IF PORTB.0 = 0 THEN 
        gosub PARATALLY        ;PORTB.0=1 SERIALL TALLY
        else 
        IF RCIF = 1 THEN      
        HSERIN 150,RT,[WAIT(X), STR SERDATA\1]
        GOSUB SERTALLY
        ENDIF
        endif
        GOTO RT
        
NAME:   GOSUB PLAY
        If PORTA.2=1 then
		I = I + 1
		IF I > 8 THEN I = 1
		pause 500
NICK:	WHILE PORTA.3 = 1
        ASCII = ASCII+1
        IF ASCII > 127 THEN ASCII = 8
        SerData[i] = ASCII
        GOSUB OUT
        PAUSE 500
        WEND
        WHILE PORTA.4 = 1
		ASCII = ASCII-1
        IF ASCII < 8 THEN ASCII = 127
        SerData[i] = ASCII
        GOSUB OUT
        PAUSE 500
        WEND
		else
		GOTO NICK
		endif
		write 0,SerData[1]         ;wtite to the on-chip eeprom SerData
        write 1,SerData[2]         ;etsi oste na min xanontai ta data
        write 2,SerData[3]         ;se periptosi diakopis reumatos
        write 3,SerData[4]
        write 4,SerData[5]
        write 5,SerData[6]
        write 6,SerData[7]
        write 7,SerData[8]

		if PORTA.3 = 1 then
			if PORTA.4 = 1 then ok
		endif
		GOTO NAME

MENU:   SerData[1] =" "
        SerData[2] =" "
        SerData[3] ="M"
        SerData[4] ="E"
        SerData[5] ="N"
        SerData[6] ="U"
        SerData[7] =" "
        SerData[8] =" "
        GOSUB OUT
        
        N = 0
IPOMENU:PAUSE 200
        
        if PORTA.3 = 1 then
            n = n + 1
            IF N = 5 THEN
               N = 1
            ENDIF
            IF N = 3 then 
				if pORTB.6 = 0 THEN N = 4
            ENDIF
        endif
        
        if PORTA.4 = 1 then
            n = n - 1
            IF N = 0 THEN
                N = 4
            ENDIF
            IF N = 3 then
				if PORTB.6 = 0 THEN N = 2
            ENDIF
        endif
        
        select case N
        case    1
                SerData[1] ="A"
                SerData[2] ="D"
                SerData[3] ="D"
                SerData[4] ="R"
                SerData[5] ="E"
                SerData[6] ="S"
                SerData[7] ="S"
                SerData[8] =" "
                GOSUB OUT
        case    2
                SerData[1] ="D"
                SerData[2] ="I"
                SerData[3] ="S"
                SerData[4] ="P"
                SerData[5] ="L"
                SerData[6] ="A"
                SerData[7] ="Y"
                SerData[8] =" "
                GOSUB OUT
        case    3
                SerData[1] =" "
                SerData[2] =" "
                SerData[3] ="N"
                SerData[4] ="A"
                SerData[5] ="M"
                SerData[6] ="E"
                SerData[7] =" "
                SerData[8] =" "
                GOSUB OUT       
        case    4
                SerData[1] =" "
                SerData[2] =" "
                SerData[3] ="E"
                SerData[4] ="X"
                SerData[5] ="I"
                SerData[6] ="T"
                SerData[7] =" "
                SerData[8] =" "
                GOSUB OUT   
        END SELECT
        IF  n = 1 then 
			if PORTA.2 = 1 then ADDRESS
		ENDIF
        IF  n = 2 THEN
			IF PORTA.2 = 1 then DISPLAY
		ENDIF           
        IF  n = 3 THEN
			IF PORTA.2 = 1 then NAME
        ENDIF
		IF  n = 4 THEN 
			IF PORTA.2 = 1 then EXIT
        ENDIF
		GOTO IPOMENU
         
ADDRESS:read 9,l
        read 10,m
        read 11,j
        SerData[1] ="A"
        SerData[2] ="D"
        SerData[3] ="D"
        SerData[4] ="R"
        SerData[5] =":"
        SerData[6] = j
        SerData[7] = m
        SerData[8] = l
        gosub out
        
NICK1:	pause 350
        WHILE PORTA.3 = 1
        L = L + 1
        IF L > 57 THEN 
            L = 48
            M = M + 1
        ENDIF
        IF M > 57 THEN 
            M = 48
            J = J + 1
        ENDIF
        if j > 49 then
            j = 48
        endif
        IF J = 49 THEN
			IF M = 50 THEN 
				IF L = 56 THEN        ;mexri to 127 meta 000
            		J = 48
            		M = 48
            		L = 48
        		ENDIF
  		ENDIF
  		ENDIF
        SerData[8] = L
        SerData[7] = M
        SerData[6] = J
        GOSUB OUT
        pause 300
        WEND

        WHILE PORTA.4 = 1
        L = L - 1
        IF L < 48 THEN 
            L = 57
            M = M - 1
        ENDIF
        IF M < 48 THEN 
            M = 57
            J = J - 1
        ENDIF
        if j < 48 then
            j = 49
        endif
        IF J = 49 THEN 
			IF M = 57 THEN
				IF L = 57  THEN
      	      		J = 49
        	    	M = 50
            		L = 55
        		ENDIF
  		ENDIF
  		ENDIF
        SerData[8] = L
        SerData[7] = M
        SerData[6] = J
        GOSUB OUT
        pause 300
        WEND
		
        
        X = 128 + 100*(J -48) + 10*(M - 48) + (L -48) 
        write 12,x
        write 9,l
        write 10,m
        write 11,j
        IF PORTA.2 = 1 THEN
			IF PORTB.6 = 0 THEN CONNECT    ;DYNAMIC MODE
        ENDIF
		IF PORTA.2 = 1 THEN
			IF PORTB.6 = 1 THEN OK    ;STATIC MODE
        ENDIF
		GOTO NICK1
       
DISPLAY:read 8,k 
        SerData[1] ="B"
        SerData[2] ="R"
        SerData[3] ="I"
        SerData[4] ="G"
        SerData[5] ="H"
        SerData[6] ="T"
        SerData[7] =":"
        SerData[8] = k
        gosub out
        PAUSE 200
        
NICK2:  WHILE PORTA.3 = 1
        K = K + 1
        IF K > 56 THEN 
        K = 49
        ENDIF
        SerData[8] = K
        GOSUB OUT
        PAUSE 300
        GOTO SELECTK
        WEND
        
        WHILE PORTA.4 = 1
        K = K - 1        
        IF K < 49 THEN 
        K = 56
        ENDIF
        SerData[8] = K
        GOSUB OUT
        PAUSE 300
        GOTO SELECTK
        WEND

SELECTK: SELECT CASE K
        CASE    49
                DISPLAYDATABYTE = $00
        CASE    50
                DISPLAYDATABYTE = $22
        CASE    51
                DISPLAYDATABYTE = $44
        CASE    52
                DISPLAYDATABYTE = $66
        CASE    53
                DISPLAYDATABYTE = $88
        CASE    54
                DISPLAYDATABYTE = $BB
        CASE    55
                DISPLAYDATABYTE = $DD
        CASE    56
                DISPLAYDATABYTE = $FF
END SELECT
        
;BRING DIGITS 0 AND 2 TO K BRIGHTNESS
DISPLAYADDRESSBYTE = $01
I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE1, DISPLAYADDRESSBYTE, [DISPLAYDATABYTE]
I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE2, DISPLAYADDRESSBYTE, [DISPLAYDATABYTE]

;BRING DIGITS 1 AND 3 TO K BRIGHTNESS
DISPLAYADDRESSBYTE = $02
I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE1, DISPLAYADDRESSBYTE, [DISPLAYDATABYTE]
I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE2, DISPLAYADDRESSBYTE, [DISPLAYDATABYTE]

write 8,k
IF PORTA.2 = 1 THEN
	IF PORTB.6 = 0 THEN CONNECT    ;DYNAMIC MODE
ENDIF
IF PORTA.2 = 1 THEN
	IF PORTB.6 = 1 THEN OK    ;STATIC MODE
ENDIF
GOTO NICK2
        

EXIT:


CONNECT:SerData[1] =" "
        SerData[2] ="C"
        SerData[3] ="O"
        SerData[4] ="N"
        SerData[5] ="N"
        SerData[6] ="E"
        SerData[7] ="C"
        SerData[8] ="T"
        gosub out
        GOTO MAIN

OK:     SerData[1] =" "
        SerData[2] =" "
        SerData[3] ="O"
        SerData[4] ="."
        SerData[5] ="K"
        SerData[6] =" "
        SerData[7] =" "
        SerData[8] =" "
        gosub out
        pause 2000
        GOSUB PLAY
        goto rt
        
        
        
PLAY:   read 0,SerData[1]         
        read 1,SerData[2]         
        read 2,SerData[3]         
        read 3,SerData[4]
        read 4,SerData[5]
        read 5,SerData[6]
        read 6,SerData[7]
        read 7,SerData[8]
        gosub out
        RETURN
OUT:

I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE1, DIGIT0BOTHPLANESADDRESS, [SerData[1]]

I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE1, DIGIT1BOTHPLANESADDRESS, [SerData[2]]
 
I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE1, DIGIT2BOTHPLANESADDRESS, [SerData[3]]

I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE1, DIGIT3BOTHPLANESADDRESS, [SerData[4]]


I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE2, DIGIT0BOTHPLANESADDRESS, [SerData[5]]

I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE2, DIGIT1BOTHPLANESADDRESS, [SerData[6]]

I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE2, DIGIT2BOTHPLANESADDRESS, [SerData[7]]

I2CWRITE SDA0, SCL0, DISPLAYCONTROLBYTE2, DIGIT3BOTHPLANESADDRESS, [SerData[8]]


RETURN

