'****************************************************************
'*  Name    : USB_TST.BAS                                       *
'*  Author  : B. Reynolds                                       *
'*  Notice  : Copyright (c) 2010 http://www.Rentron.com         *
'*          : All Rights Reserved                               *
'*  Date    : 3/25/2010                                         *
'*  Version : 1.0                                               *
'*  Notes   : Using the Microchip USB HID Boot-Loader with PBP  *
'*          : and DT_INTS.                                      *
'****************************************************************
    
   ' Using the Microchip MCHPFSUSB v2.1 HID USB Bootloader with PBP & DT INTS.
    
   ' Place a 10K pull-up on RB4 with a switch to ground RB4 when pressed. 
    
   ' Loader mode. Press & hold switch on RB4, then press/release reset switch on /MCLR.
   ' Now release switch on RB4.
    
   ' LEDs on PORTD.0 & D.1 will blink on/off quickly showiing you're in loader mode
   ' and the MCHPFSUSB v2.1 HID PC bootloader software should now recognize your board.
    
   ' Open & load your compiled code, with the loader software, then press/release
   ' the switch on /MCLR, or click Reset Device on the loader software.
   
   ' Your code should now be running. 
    
   DEFINE OSC 48                   ' Loader configured for 20MHz OSC on USB board
   DEFINE RESET_ORG 0x1000         ' User code start location for HID loader  
    
   INCLUDE "DT_INTS-18.bas"        ' Base Interrupt System
   INCLUDE "ReEnterPBP-18.bas"     ' Include if using PBP interrupts                                           

   LED1   VAR PORTD.0
   Loops  VAR BYTE
    
   '   Hardware configuration
   '   ====================== 
   ADCON1  =   %00001111       ' All Digital                         


ASM
INT_LIST  macro     ; IntSource,    Label,     Type, ResetFlag?
        INT_Handler  TMR1_INT,  _ToggleLED1,   PBP,   yes
    endm
    INT_CREATE               ; Creates the interrupt processor
ENDASM    


T1CON = $31                ; Prescaler = 8, TMR1ON
@ INT_ENABLE  TMR1_INT     ; Enable Timer 1 interrupts

   OSCCON = %01110000     ; Switch to internal whenever you want by just
                          ; flipping OSCCON.1 to 1.
                          ; To run at 48MHz, flip OSCCON.1 back to 0..
Main:
   FOR Loops = 1 TO 6    ' we'll run at 48MHz here
     TOGGLE PORTD.1
     Pause 500
   NEXT Loops
  
   OSCCON.1 = 1          ' we'll run at 8MHz on internal osc here 
   FOR Loops = 1 TO 6
     TOGGLE PORTD.1
     Pause 500
   NEXT Loops
   
   OSCCON.1 = 0          ' flip switch back to 48MHz
   GOTO Main

'---[TMR1 - interrupt handler]--------------------------------------------------
ToggleLED1:
   TOGGLE LED1
@ INT_RETURN

    END
