'*************************************
'*  Title   : R/C Lights 2/Plane     *
'*  Coder   : AS                     *
'*  Notice  : Copyright (c) 2007 AZ  *
'*  Date    : 14/11/2008  v.3.1        *
'*  1012 Lines						 *
'*************************************
'
' Enhancements / V2
'
' 1) No more compulsory side for switch .... just program !!!
' 1) jumper used to program the device: no more time issues ...
' 2) Valid pulses are now only 800 - 2200 s for best glitches filtering
' 3) Entering Fail - safe mode need > 16 falses pulses per ~ 5-6 sec period
'    Each pulse is strobed if glitches appear.
' 4) Leaving Fail safe mode needs some 5-6 secs ( better shows glitches )


' ****************************************************************************
' Signal : OFF ----------> Strob + Wing ON -----------> Strob + Wing + Land ON
'                              POS 1                             POS 2
'
' Strob rate : POS 2 side  = double flash - OFF Side = single Flash

'@ DEVICE pic12F675, INTRC_OSC_NOCLKOUT
'@ DEVICE pic12F675, WDT_OFF
'@ DEVICE pic12F675, PWRT_OFF
'@ DEVICE pic12F675, MCLR_OFF
'@ DEVICE pic12F675, BOD_ON

 @    __config _INTRC_OSC_NOCLKOUT & _WDT_ON & _PWRTE_ON & _MCLRE_OFF & _CP_OFF & _BODEN_ON

'*****************************************************************************
'                             IMPORTANT ADVICE !!!
'
' !!! Re-using chips without clearing the EEPROM can cause program locking !!!
'
' !!!       ALWAYS PROGRAM $FFs or REAL VALUES  to used locations          !!!
'
'*****************************************************************************
	

'DATA @1,$FF,$FF,$FF,$FF	'series initial values ( programming needed ! )
DATA @1,130,170,0,160  		'initial eeprom values for test

DEFINE OSC 4
DEFINE OSCCAL_1K 1
DEFINE PULSIN_MAX 3000
DEFINE BUTTON_PAUSE 250

ADCON0		= 0
ANSEL		= 0
CMCON		= 7

'OPTION_REG.7 = 0   	'enable Pull-Ups

GPIO 		= 0			'All pins LOW IF outputted - no startup bug.
TRISIO 		=%00101000  'set GPIO3 & GPIO5 as inputs

                                              
wing_led    VAR GPIO.0
land_led    VAR GPIO.1
strob_led   VAR GPIO.2
servoin     VAR GPIO.3
Valid		VAR GPIO.4
set         VAR GPIO.5

x           VAR byte
delay		VAR byte
Sample		VAR byte
Bad			VAR byte
Measure		VAR byte
servoval    VAR byte    'servo in signal ( 0 - 255 @4 Mhz ! )
servomes	VAR byte
pos1        VAR byte    'threshold of lights on
pos2        VAR byte    'threshold of landing lights on
pos3        VAR byte    '(not used - future use)
strob_off   VAR byte    'strobe blink off time (ms) ( 0 - 160 )

Side 		VAR bit		' Commutating side

strob_on    CON 80      'strobe blink on time(ms) ( 80 )
floor		CON 10		'(strobe min level - not used)
gap			CON 2		'Offset for commut.

Led			VAR wing_led
Error		VAR land_led

'*****************************************************************************
init:
'*****************************************************************************

	Pause 400 ' Stabilisation at startup
	
'******************************************************************************
' EEPROM Downloading
'******************************************************************************

	READ 1,pos1,pos2,Strob_off
	
'	Read 1,pos1
'	Read 2,pos2
'	Read 4,Strob_off

	IF ( pos1 <> $FF ) AND ( pos2 <> $FF ) AND ( Strob_off <> $FF ) _
	 AND Set THEN Coldstart
	
'******************************************************************************
' Programming pulse measurements
'******************************************************************************

	IF NOT Set Then Measurepos1

'******************************************************************************
'  IF Memory values not programmed, Check if set jumper in position and lock
'******************************************************************************
oubli: 

	error = 1
	Pause 50
	error = 0
	Pause 50

	GoTo oubli

	
'*****************************************************************************
Measurepos1:			' We enter the Programming mode ... with pos1
'*****************************************************************************
  
FOR x = 1 TO 4		' All lights blink 4 Times
	
		 wing_led	= 1
 		 land_led	= 1
 		 strob_led	= 1
		
		PAUSE 200
		
		 wing_led	= 0
 		 land_led	= 0
 		 strob_led	= 0
		
		PAUSE 300
		
	next x

Measurepos10:
	
	led = 1 : error = 1

Measurepos11:

	Pause 50
	led = 0 : error = 0



'******************************************************************************
' CALIBRATING ON value ( Pos1 )
'******************************************************************************


 	pos1	 	= 0
 
	For Sample = 1 TO 16

	PulsIn Servoin,1,Measure

	IF ( Measure < 80 ) OR ( Measure > 220 ) Then
	error = 1
	GoTo Measurepos11
	EndIF
	

	IF pos1 = $00 Then prems

	IF ( Measure < (Pos1 -1)) OR ( Measure > (Pos1 +1)) Then
	error = 1
	GoTo Measurepos11
	EndIF

prems:	Pos1 = Measure
	
	Next Sample

'******************************************************************************
' Take SET Jumper OFF
'******************************************************************************

	delay = 0
	Button SET,0,255,0,delay,1,Measurepos10
	

'******************************************************************************
JumperBack: ' Place SET jumper back
'******************************************************************************


	delay = 0
	Button Set,0,255,0,delay,0,JumperBack


	led = 1  ' OK with wing lights
	Pause 500
	
	
'******************************************************************************
MeasurePos2: ' We measure Pos2
'******************************************************************************

	led = 1 : error = 1
	
MeasurePos21:

	Pause 35
	led = 0 : error = 0


'******************************************************************************
'CALIBRATING Pos2
'******************************************************************************

 	pos2	 	= 0
 	side	  	= 0

	For Sample = 1 TO 16

	PulsIn Servoin,1,Measure

	IF ( Measure < 80 ) OR ( Measure > 220 ) Then
	error = 1
	GoTo MeasurePos21
	EndIF

	IF Pos2 = $00 Then prems1

	IF ( Measure < (Pos2 -1)) OR ( Measure > (Pos2 +1)) Then
	error = 1
	GoTo MeasurePos21
	EndIF

prems1:
	Pos2 = Measure

	Next Sample
	
'******************************************************************************
' Take SET Jumper OFF
'******************************************************************************

	delay = 0
	Button Set,0,255,0,delay,1,MeasurePos2
	
'******************************************************************************
JumperBack1: ' Place SET jumper back
'******************************************************************************

	delay = 0
	Button Set,0,255,0,delay,0,JumperBack1

'*****************************************************************************
'Fixing switching side
'*****************************************************************************
	
	IF Pos2 > Pos1 Then
	
		side = 0
		Else
		side = 1

	EndIF
	led = 1  ' OK with wing lights
	Pause 500
	
'******************************************************************************
Blinkrate:	' We measure for Blinking rate ...
'******************************************************************************

	led = 1 : error = 1
	
Blinkrate1:

	Pause 20
	led = 0 : error = 0

'******************************************************************************
'CALIBRATING Blink Rate
'******************************************************************************

	Strob_off	= 0
	
	For Sample = 1 TO 16

	PulsIn Servoin,1,Measure

	IF ( Measure < 80 ) OR ( Measure > 220 ) Then
	error = 1
	GoTo Blinkrate1
	EndIF

	IF Strob_off = $00 Then prems2

	IF ( Measure < (Strob_off -1)) OR ( Measure > (Strob_off +1)) Then
	error = 1
	GoTo Blinkrate1
	EndIF

prems2:
	Strob_off = Measure

	Next Sample
	
'*****************************************************************************
'Fixing Strob_off time : single flash when outside or = pos1/ double elsewhere
'*****************************************************************************
	
	IF ( NOT Side AND Strob_off <= Pos1 ) OR ( Side AND Strob_off >= Pos1 ) Then
	
		Strob_off = 0
		Else
		Strob_off = 160

	EndIF

'******************************************************************************
' Take SET Jumper OFF
' Program continues without placing it back
'******************************************************************************

	delay = 0
	Button Set,0,255,0,delay,1,Blinkrate
	
	led = 1  ' OK with wing lights
	Pause 500
	

'******************************************************************************
' EEPROM Parameters Saving
'******************************************************************************

	WRITE 1,pos1,pos2,Strob_off
	
'	Write 1,Pos1
'	Write 2,Pos2	
''	Write 3,side
'	Write 4,Strob_off

'******************************************************************************
' Storing success Blink 
'******************************************************************************

	For Sample = 1 TO 5
	led = 1 
	Pause 200
	led = 0
	Pause 200
	Next Sample


'*****************************************************************************
'*****************************************************************************
ColdStart: ' Lighting all leds 1 sec.
'*****************************************************************************
'*****************************************************************************

'*****************************************************************************
' switching side
'*****************************************************************************
	
	IF Pos2 > Pos1 Then
	
		side = 0
		Else
		side = 1

	EndIF
	
Sample = 0

 wing_led	= 1
 land_led	= 1
 strob_led	= 1
	
	PAUSE 1000
'*****************************************************************************
start0:
'*****************************************************************************	
 wing_led	= 0
 land_led	= 0
 strob_led	= 0

'*****************************************************************************
start:
'*****************************************************************************

PULSIN servoin,1,servomes

	Sample = sample + 1

	IF ( servomes < 80 ) OR ( servomes > 220 ) Then
	
		Bad = ( Bad + 1 ) MIN 16	'stop if Bad.4 = 1
	
		IF Bad.4 THEN
		 GOTO nosignal				'16 false pulses ... warning !!!
		ELSE
		 GOTO Start					'Check closer for EACH frame ...
		ENDIF
		 		
	ELSE
	
	IF Sample = 0 THEN Bad = 0	'Clear Bad only if 256 good frames (~ 5-6 secs )
								'for better glitch catching !!!
	Servoval= Servomes			'Signal is good ...
		
	EndIF
	


IF NOT Side THEN ' ( POS2 > POS1 > OFF )


	IF servoval < (pos1-gap) THEN GOTO Start0  						' Everything OFF
	
	IF servoval >= (pos1-gap) and servoval <(pos2-gap) THEN GOSUB lightson 'Wing lights ON

	IF servoval >= ( pos2-gap ) THEN GOSUB landingon	  				'Land Lights ON
	

ELSE	'( POS 2 < POS1 < OFF )

	IF Servoval > ( pos1+gap ) THEN GOTO Start0						' Everything OFF
	
	IF servoval <=( pos1+gap) and servoval >(pos2+gap) THEN GOSUB lightson  'Wing lights ON

	IF servoval < ( pos2+gap ) THEN GOSUB landingon						'Land Lights ON
	
	
ENDIF

 strob_led	= 1
PAUSE strob_on

IF NOT Strob_off THEN Jump	' Here we had a MIN. 18s min LOW Pause !!!

 strob_led	= 0
PAUSE strob_off				
 strob_led 	= 1
 
Jump:

PAUSE strob_on
 strob_led	= 0


PAUSE 650

GOTO start

''*****************************************************************************
'lightsoff:
''*****************************************************************************
'
' wing_led	= 0
' land_led	= 0
' strob_led	= 0
'
'GOTO start0

'*****************************************************************************
lightson:
'*****************************************************************************

 wing_led = 1
 land_led = 0
 
RETURN
END
'*****************************************************************************
landingon:
'*****************************************************************************

 wing_led	= 1
 land_led	= 1

RETURN
END
'*****************************************************************************
nosignal:
'*****************************************************************************

 wing_led	= 1
 land_led	= 1
 strob_led	= 1

PAUSE 200

 wing_led	= 0
 land_led	= 0
 strob_led	= 0

PAUSE 200

GOTO start

'*****************************************************************************
END
'*****************************************************************************
